#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
trace/generated-tracers.dtrace (DTrace only).
"""

__author__     = "Lluís Vilanova <vilanova@ac.upc.edu>"
__copyright__  = "Copyright 2012-2014, Lluís Vilanova <vilanova@ac.upc.edu>"
__license__    = "GPL version 2 or (at your option) any later version"

__maintainer__ = "Stefan Hajnoczi"
__email__      = "stefanha@linux.vnet.ibm.com"


from tracetool import out


def generate(events, backend):
    events = [e for e in events
              if "disable" not in e.properties]

    out('/* This file is autogenerated by tracetool, do not edit. */'
        '',
        'provider qemu {')

    for e in events:
        args = str(e.args)

        # DTrace provider syntax expects foo() for empty
        # params, not foo(void)
        if args == 'void':
            args = ''

        # Define prototype for probe arguments
        out('',
            'probe %(name)s(%(args)s);',
            name=e.name,
            args=args)

    out('',
        '};')
