/****************************************************************************
 **
 ** Author: Grigory A. Mozhaev
 ** Copyright (C) 2008-2009 Griland Company.
 ** Contact: Griland Company (griland.support@gmail.com)
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://www.trolltech.com/products/qt/opensource.html
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/
//! -*- coding: UTF-8 -*-
#define SOURCE_CODING "UTF-8"

#include <QtCore>
#include <QtXml>

#include "capplication.h"

QTranslator *CApplication::mpTranslator = 0;
QSettings   *CApplication::mpSettings   = 0;
CGlobal     *CApplication::mpGlobal     = 0;


CApplication::CApplication(int &aArgc, char **apArgv) :
QApplication(aArgc,apArgv) {
    setApplicationName("MultiRecordBurner");
    setApplicationVersion("0.0.1");

#if HAVE_LOCALE
    initLocale();
#endif // #if HAVE_LOCALE

    initGlobal();
    initTranslation();

    Q_ASSERT_X(mpSettings != 0, "CApplication constructor", "Settings pointer is NULL");
    Q_ASSERT_X(mpGlobal   != 0, "CApplication constructor", "Globals pointer is NULL");
}

void CApplication::initLocale() {
    ::setlocale(LC_ALL,"");
    ::setlocale(LC_NUMERIC,"POSIX");

    char *vpLang = ::getenv("LANG");
    if (vpLang != 0 && vpLang[0] != '\0') {
        QLocale vLocale(vpLang);
        QLocale::setDefault(vLocale);
    }

    QTextCodec *vpC = 0;

#ifdef Q_OS_LINUX
    char *vpNlCodeset = ::nl_langinfo(CODESET);
    if (vpNlCodeset!=0 && vpNlCodeset[0] != '\0') {
        vpC = QTextCodec::codecForName(vpNlCodeset);
        if (vpC) 
            QTextCodec::setCodecForLocale(vpC);
    }
#elif defined(Q_OS_WIN32)
    char *vpNlCodeset = "UTF-8";
    vpC = QTextCodec::codecForName(vpNlCodeset);
    if (vpC) 
        QTextCodec::setCodecForLocale(vpC);
#endif

    if (!vpC) {
        vpC = QTextCodec::codecForLocale();
    }

    if (vpC) {
        QTextCodec::setCodecForCStrings(vpC);
        QTextCodec::setCodecForTr(vpC);
    }
}

void CApplication::initSettings(const QString &aConfigFileName, QSettings::Format aFormat) {
    Q_UNUSED(aFormat);

    if (!aConfigFileName.isNull()) {
        QFileInfo vFile(aConfigFileName);
        if (vFile.isFile() && vFile.exists()) {
            mpSettings = new QSettings(aConfigFileName);
        }
    }

    if (!mpSettings)
        mpSettings = new QSettings();
}

void CApplication::initGlobal() {
    mpGlobal = new CGlobal();
}

void CApplication::initTranslation() {
    //
}

CApplication::~CApplication() {
    if (mpSettings) delete mpSettings;
    if (mpGlobal)  delete mpGlobal;

    if (mpTranslator) {
        delete mpTranslator;
        mpTranslator = NULL;
    }
}

QSettings *CApplication::settings() {
    return mpSettings;
}

CGlobal  *CApplication::global() {
    return mpGlobal;
}

#ifdef HAVE_GUI
void CApplication::storeWidgetStatus (const QString &aName,
    QWidget *aWidget, const QMap<QString, QVariant> *aOptions) {
    Q_UNUSED(aOptions);
    if ((!aName.isNull()) && (aWidget)) {
        QString vPath = QString("Session/Widgets/%1").arg(aName);

        qDebug() << "storeWidget:" << vPath;

        mpSettings->setValue(vPath+"/windowFlags", QVariant(aWidget->windowFlags()));
        mpSettings->setValue(vPath+"/windowState", QVariant(aWidget->windowState()));
        mpSettings->setValue(vPath+"/geometry",    aWidget->geometry());
    }
}

void CApplication::restoreWidgetStatus (const QString &aName,
    QWidget *aWidget, const QMap<QString, QVariant> *aOptions) {
    Q_UNUSED(aOptions);
    if ((!aName.isNull()) && (aWidget)) {
        QString vPath = QString("Session/Widgets/%1").arg(aName);

        qDebug() << "restoreWidget:" << vPath;

        if (mpSettings->contains(vPath+"/windowFlags"))
          aWidget->setWindowFlags(Qt::WindowFlags(mpSettings->value(vPath+"/windowFlags").toInt()));

        if (mpSettings->contains(vPath+"/windowState"))
          aWidget->setWindowState(Qt::WindowStates(mpSettings->value(vPath+"/windowState").toInt()));

        if (mpSettings->contains(vPath+"/geometry"))
          aWidget->setGeometry(mpSettings->value(vPath+"/geometry").toRect());

    }
}
#endif // HAVE_GUI

