/****************************************************************************
 **
 ** Author: Grigory A. Mozhaev
 ** Copyright (C) 2008-2009 Griland Company.
 ** Contact: Griland Company (griland.support@gmail.com)
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://www.trolltech.com/products/qt/opensource.html
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/
#ifndef __CAPPLICATION_H__
#define __CAPPLICATION_H__

#include <Qt/QtCore>
#include <Qt/QtGui>
//#include <QtXml>

#include "cglobal.h"

class CApplication : public QApplication {
Q_OBJECT

public:
    CApplication(int &, char **);
    ~CApplication();

    int init();

    static QSettings *settings();
    static CGlobal   *global();

#ifdef HAVE_GUI
    static void storeWidgetStatus (const QString &aName, QWidget *aWidget,
                            const QMap<QString, QVariant> *aOptions = 0);

    static void restoreWidgetStatus (const QString &aName, QWidget *aWidget,
                              const QMap<QString, QVariant> *aOptions = 0);
#endif // HAVE_GUI

private:
    void initDependsOnSystem();

    void initLocale();
    void initSettings(const QString &aConfigFileName = QString::null,
                      QSettings::Format aFormat = QSettings::NativeFormat);
    void initGlobal();
    void initTranslation();

    static QSettings    *mpSettings;
    static CGlobal      *mpGlobal;
    static QTranslator  *mpTranslator;
};

#endif // __CAPPLICATION_H__
