/****************************************************************************
 **
 ** Copyright (C) 2008-2009 Grigory A. Mozhaev.  All rights reserved.
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://www.trolltech.com/products/qt/opensource.html
 **
 ** If you are unsure which license is appropriate for your use, please
 ** review the following information:
 ** http://www.trolltech.com/products/qt/licensing.html or contact the
 ** sales department at sales@trolltech.com.
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ** AUTHOR: Grigory A. Mozhaev <zcrendel@mail.ru>
 **
 ****************************************************************************/
#ifndef __CCHECKTHREAD_H__
#define __CCHECKTHREAD_H__

#include <QtCore>
#include <QThread>

class CCheckThreadPrivate;
class CDvdModel;

class CCheckThread : public QThread {
Q_OBJECT

public:
    CCheckThread();
    ~CCheckThread();

    void init(CDvdModel *aModel);

    QString hash();
    bool done();

signals:
    void progress(int aProgress, const QString &aInfo = QString::null);

public:
    void run();
    void stop();

private:
    CCheckThreadPrivate *mpData;
};

#endif // __CCHECKTHREAD_H__
