/****************************************************************************
 **
 ** Author: Grigory A. Mozhaev
 ** Copyright (C) 2008-2009 Griland Company.
 ** Contact: Griland Company (griland.support@gmail.com)
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://www.trolltech.com/products/qt/opensource.html
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/
#ifndef __CDVDMODEL_H__
#define __CDVDMODEL_H__

#include <Qt/QtCore>

#include "ccheckthread.h"
#include "cburnthread.h"

class CDvdModelPrivate;

class CDvdModel : public QObject {
Q_OBJECT

public:
    CDvdModel();
    ~CDvdModel();

    enum DeviceType {
        dtUndefined   = 0,
        dtUnsupported = 1,
        dtCdWriter    = 2,
        dtDvdWriter   = 3
    };

    enum DvdStatus { 
        dsUndefined  = 0,
        dsNoDisc     = 1,
        dsEmptyCd    = 2,
        dsEmptyDvd   = 3,
        dsDataCd     = 4,
        dsDataDvd    = 5,
    };

    enum ProcessMode { 
        pmNone       = 0,
        pmWaiting    = 1,
        pmWriting    = 2,
        pmChecking   = 3,
        pmCheckDone  = 4,
        pmCheckFailed= 5,
        pmWriteDone  = 6,
        pmWriteFailed= 7
    };

    void setDevice(const QString &aDevice = QString::null);
    QString device();

    void setDeviceInfo(const QString &aDevice = QString::null);
    QString deviceInfo();

    void setSpeed(int aSpeed);
    int speed();

    quint64 capacity();

    void setISOFileName(const QString &aISOFileName);
    QString isoFileName();

    void setISOSize(quint64 aSize);
    quint64 isoSize();

    CDvdModel::DvdStatus dvdStatus();

    static QMap<QString,QString> allDevices();

signals:
    void statusChanged(const QString &aDevice, 
                       const CDvdModel::DeviceType  &aDeviceType,
                       const CDvdModel::DvdStatus   &aDvdStatus,
                       const CDvdModel::ProcessMode &aProcessMode,
                       quint64 aCapacity,
                       const QString &aHash);

    void progress(int aProgress, const QString &aInfo = QString::null);

private slots:
    void addVolume(const QString &aVolume);
    void removeVolume(const QString &aVolume);

    void burnThreadFinished();
    void burnThreadStarted ();
    void burnThreadTerminated ();

    void checkThreadFinished();
    void checkThreadStarted ();
    void checkThreadTerminated ();


private:
    CDvdModelPrivate *mpData;

    void checkAllVolumes();
    void checkVolume(const QString &aVolume);


public slots:
    void burnISO(const QString aFileName = QString::null);
    void checkSum(quint64 aSize);
    void cancel();

    void update();
};

#endif // __CDVDMODEL_H__
