/****************************************************************************
 **
 ** Author: Grigory A. Mozhaev
 ** Copyright (C) 2008-2009 Griland Company.
 ** Contact: Griland Company (griland.support@gmail.com)
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://www.trolltech.com/products/qt/opensource.html
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/
#ifndef __CDVDVIEW_H__
#define __CDVDVIEW_H__

#include <Qt/QtGui>

#include "cdvdmodel.h"

namespace Ui {
    class CDvdView;
}

class CDvdView : public QFrame {
Q_OBJECT
Q_DISABLE_COPY(CDvdView);

public:
    explicit CDvdView(QWidget* apParent = 0,  Qt::WindowFlags aFlags = 0);
    ~CDvdView();

    void setDevice(const QString& aDevice = QString::null, const QString& aDeviceInfo = QString::null);
    void setLabel(const QString& aLabel = QString::null);

public slots:
    void statusChanged(const QString &aDevice, 
                       const CDvdModel::DeviceType  &aDeviceType,
                       const CDvdModel::DvdStatus   &aDvdStatus,
                       const CDvdModel::ProcessMode &aProcessMode,
                       quint64 aCapacity,
                       const QString &aHash);

    void progress(int aProgress, const QString &aInfo = QString::null);

private:
    void disableGui();
    QPixmap icon(const QString &aName = QString::null);

    void enableWrite();
    void disableWrite();

    void enableCheck();
    void disableCheck();

    void enableCancel();
    void disableCancel();

    void enableCombos();
    void disableCombos();

    void startBurnAnimation();
    void startCheckAnimation();
    void stopAnimation();

    // minor
    int mSpeedList;     // 0 - no list, 1 - CD Speeds, 2 - Dvd Speeds
    int mCDSpeedIndex;  
    int mDvdSpeedIndex; 

    QString  mCategory;
    QString  mISOFile; 
    quint64  mISOSize;
    QString  mISOmd5sum;

    bool mAnimateFlag;

    QTimer *mpTimer;
    CDvdModel *mpModel;

    QMenu *mpMenu;
    Ui::CDvdView* mpUi;

private slots:
    void burnAnimate();
    void checkAnimate();
    
    void refreshRootDirsSlot();

    void on_mpDataCheck_stateChanged(int aState);

    void on_mpCategoryCombo_currentIndexChanged(QString aCategory);
    void on_mpISOCombo_currentIndexChanged(QString aISOFileName);

    void on_mpSpeedCombo_currentIndexChanged(int );

    void on_mpCheckButton_clicked();
    void on_mpBurnButton_clicked();
    void on_mpCancelButton_clicked();

    void on_mpRefreshButton_clicked();
};

#endif // __CDVDVIEW_H__
