/****************************************************************************
 **
 ** Author: Grigory A. Mozhaev
 ** Copyright (C) 2008-2009 Griland Company.
 ** Contact: Griland Company (griland.support@gmail.com)
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://www.trolltech.com/products/qt/opensource.html
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/
//! -*- coding: UTF-8 -*-
#define SOURCE_CODING "UTF-8"

#include <Qt/QtCore>
#include <Qt/QtGui>

#include "capplication.h"

#include "cgeneratedialog.h"
#include "ui_cgeneratedialog.h"


//!
CGenerateDialog::CGenerateDialog(QWidget * apParent, Qt::WindowFlags aFlags)
    : QWidget(apParent,aFlags), mpUi(new Ui::CGenerateDialog) {
    mpUi->setupUi(this);
    mCanClose = false;
    mpThread = 0;
}

//!
CGenerateDialog::~CGenerateDialog() {
    if (mpThread) {
        mpThread->stop();
        mpThread->quit();
        while (!mpThread->wait(1000));
        delete mpThread;
    }
}

void CGenerateDialog::closeEvent(QCloseEvent *apEvent) {
    if (mCanClose) {
        apEvent->accept();
    } else {
        apEvent->ignore();
        setWindowState(Qt::WindowMinimized);
    }
}

void CGenerateDialog::setCanClose(bool aFlag) {
    mCanClose = aFlag;
}

void CGenerateDialog::progress(const QString &aJobName, int aProgress, 
                               const QString &aInfo) {
    //qDebug() << "CGenerateDialog::progress " << aJobName << aProgress;
    QList<QTableWidgetItem *> vItems = mpUi->mpTableWidget->findItems(aJobName, Qt::MatchExactly);
    if (vItems.size() > 0) {
        // 1 column (jobname - category/filename)
        //

        // 2 column (progress)
        QProgressBar *vpBar = qobject_cast<QProgressBar *>(mpUi->mpTableWidget->cellWidget(vItems.at(0)->row(), 1));
        if (vpBar)
            vpBar->setValue(aProgress);

        // 3 column (status)
        if (aInfo!=QString::null)
            mpUi->mpTableWidget->item(vItems.at(0)->row(), 2)->setText(aInfo);
    }
}

void CGenerateDialog::switchJob(const QString &aPrev, 
                                const QString &aNext) {
    QList<QTableWidgetItem *> vItems;

    if (aNext!=QString::null) {
        vItems = mpUi->mpTableWidget->findItems(aNext, Qt::MatchExactly);
    } else
    if (aPrev!=QString::null)  {
        vItems = mpUi->mpTableWidget->findItems(aPrev, Qt::MatchExactly);
    }

    if (vItems.size() > 0) {
        mpUi->mpTableWidget->setCurrentItem(vItems.at(0));

        if (mpThread->jobStatus(vItems.at(0)->text()) == 0) {
            vItems.at(0)->setBackground(QBrush(QColor(255, 0, 0, 127)));
        }
    }
}

void CGenerateDialog::init(const QStringList &aJobList, const QStringList &aFullNames) {
    mpUi->mpTableWidget->setRowCount(aJobList.size());
    for (int i=0; i < aJobList.size(); i++) {
        QTableWidgetItem *vpItem0 = new QTableWidgetItem(aJobList.at(i));
        QTableWidgetItem *vpItem2 = new QTableWidgetItem("wait...");
        mpUi->mpTableWidget->setItem(i,0,vpItem0);
        mpUi->mpTableWidget->setCellWidget(i, 1, new QProgressBar);
        mpUi->mpTableWidget->setItem(i,2,vpItem2);
    }

    if (!mpThread) {
        mpThread = new CGenerateThread ();
        mpThread->init(aJobList,aFullNames);
        
        connect(mpThread, SIGNAL(progress(const QString &, int, const QString &)),
                this, SLOT(progress(const QString &, int, const QString &)));

        connect(mpThread, SIGNAL(switchJob(const QString &, const QString &)),
                this, SLOT(switchJob(const QString &, const QString &)));

        connect(mpThread, SIGNAL(finished()), this, SLOT(finished()));

        mpThread->start();
    }
}

void CGenerateDialog::resizeEvent(QResizeEvent * apEvent) {
    int vColumntSize = mpUi->mpTableWidget->width() - 
        (mpUi->mpTableWidget->columnWidth (1) +  mpUi->mpTableWidget->columnWidth (2) + 18);

    qDebug() << "CGenerateDialog::resizeEvent() =" << vColumntSize;
    mpUi->mpTableWidget->setColumnWidth(0, vColumntSize);    
}

void CGenerateDialog::on_mpCloseButton_clicked() {
    close();
}

void CGenerateDialog::on_mpCancelButton_clicked() {
    if (mpThread) {
        int vRow = mpUi->mpTableWidget->currentRow();
        if (vRow >= 0) {
            if (mpThread->jobStatus(mpUi->mpTableWidget->item(vRow,0)->text()) == 1) {
                mpThread->cancelJob(mpUi->mpTableWidget->item(vRow,0)->text());
                mpUi->mpTableWidget->item(vRow,0)->setBackground(QBrush(QColor(255, 0, 0, 127)));
            }
        }
    }
}

void CGenerateDialog::on_mpStopButton_clicked() {
    if (mpThread) {
        mpThread->stop();
    }
}

void CGenerateDialog::finished() {
    mCanClose = true;
    QTimer::singleShot(2000, this, SLOT(close()));
}
