/****************************************************************************
 **
 ** Author: Grigory A. Mozhaev
 ** Copyright (C) 2008-2009 Griland Company.
 ** Contact: Griland Company (griland.support@gmail.com)
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://www.trolltech.com/products/qt/opensource.html
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/
#ifndef _CGENERATEDIALOG_H_
#define _CGENERATEDIALOG_H_

#include <Qt/QtGui>
#include "cgeneratethread.h"

namespace Ui {
    class CGenerateDialog;
}

class CGenerateDialog : public QWidget {
Q_OBJECT

public:
    CGenerateDialog(QWidget * apParent = 0, Qt::WindowFlags aFlags = 0);
    virtual ~CGenerateDialog();

    void init(const QStringList &aJobList, const QStringList &aFullNames);
    void setCanClose(bool aFlag);

private slots:
    void progress(const QString &aJobName, int aProgress, const QString &aInfo = QString::null);
    void switchJob(const QString &aPrev, const QString &aNext);

    void finished();

    void on_mpCloseButton_clicked();
    void on_mpCancelButton_clicked();
    void on_mpStopButton_clicked();

protected:
    void closeEvent(QCloseEvent *);
    void resizeEvent(QResizeEvent *);

private:
    bool mCanClose;

    CGenerateThread *mpThread;
    Ui::CGenerateDialog* mpUi;
};

#endif /* _CGENERATEDIALOG_H_ */
