/****************************************************************************
 **
 ** Copyright (C) 2008-2009 Grigory A. Mozhaev.  All rights reserved.
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://www.trolltech.com/products/qt/opensource.html
 **
 ** If you are unsure which license is appropriate for your use, please
 ** review the following information:
 ** http://www.trolltech.com/products/qt/licensing.html or contact the
 ** sales department at sales@trolltech.com.
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ** AUTHOR: Grigory A. Mozhaev <zcrendel@mail.ru>
 **
 ****************************************************************************/
#ifndef _CGENERATETHREAD_H_
#define _CGENERATETHREAD_H_

#include <Qt/QtCore>
#include <QtCore/QThread>

class CGenerateThreadPrivate;
class CGenerateThread : public QThread {
Q_OBJECT

public:
    CGenerateThread();
    ~CGenerateThread();

    void init(const QStringList &aJobList, const QStringList &aFullNames);
    int jobStatus(const QString &aJobName);

signals:
    void progress(const QString &aJobName, int aProgress, const QString &aInfo = QString::null);
    void switchJob(const QString &aPrev, const QString &aNext);

public:
    void run();
    void stop();

    void cancelJob(const QString &aJobName);

private:
    CGenerateThreadPrivate *mpData;
    QMutex mMutex;
};

#endif /* _CGENERATETHREAD_H_ */
