/****************************************************************************
 **
 ** Author: Grigory A. Mozhaev
 ** Copyright (C) 2008-2009 Griland Company.
 ** Contact: Griland Company (griland.support@gmail.com)
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://www.trolltech.com/products/qt/opensource.html
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/
//! -*- coding: UTF-8 -*-
#define SOURCE_CODING "UTF-8"

// Заголовочные файлы библиотек
#include <Qt/QtCore>

#include "cglobal.h"

CGlobal::CGlobal() {
    // define constants here  
    mConstants.insert(QLatin1String("DevicesFileName"), QString("%1/devices.txt").arg(QDir::currentPath()));
    mConstants.insert(QLatin1String("RootsFileName"), QString("%1/path.txt").arg(QDir::currentPath()));
}

CGlobal::~CGlobal() {
}

bool CGlobal::contains(const QString &aSection,
                       const QString &aName) {
    if (!mVariables.contains(aSection))
        return false;

    return mVariables.value(aSection).contains(aName);
}

bool CGlobal::containsSection(const QString &aSection) {
    return mVariables.contains(aSection);
}

QVariant CGlobal::variable(const QString &aSection,
                           const QString &aName) {
    if (contains(aSection,aName))
        return mVariables.value(aSection).value(aName);

    return QVariant();
}

void CGlobal::setVariable(const QString  &aSection,
                          const QString  &aName,
                          const QVariant &aValue) {
    if (containsSection(aSection)) {
        mVariables[aSection].insert(aName, aValue);
    } else {
        QMap<QString, QVariant> vMap;
        vMap.insert(aName, aValue);

        mVariables.insert(aSection, vMap);
    }
}

QMap<QString, QVariant> 
CGlobal::sectionVariables(const QString &aSection) {
    if (containsSection(aSection))
        return QMap<QString, QVariant>(mVariables.value(aSection));

    return QMap<QString, QVariant>();
}

void 
CGlobal::setSectionVariables(const QString &aSection,
                             QMap<QString, QVariant> &aValue) {
    mVariables.insert(aSection, aValue);
}

QVariant CGlobal::constant(const QString &aKey, const QVariant &aDefaultValue) const {

    if (mConstants.contains(aKey)) {
        return mConstants.value(aKey);
    }

    return aDefaultValue;
}

void CGlobal::updateRootDirs() {
    refreshRootDirs();
}

