/****************************************************************************
 **
 ** Author: Grigory A. Mozhaev
 ** Copyright (C) 2008-2009 Griland Company.
 ** Contact: Griland Company (griland.support@gmail.com)
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://www.trolltech.com/products/qt/opensource.html
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/
#ifndef __CGLOBAL_H__
#define __CGLOBAL_H__

#include <QtCore>
#include <QtXml>
#include <QSettings>

#ifdef HAVE_GUI
#include <QtGui>
#endif // HAVE_GUI

typedef QMap<QString,QVariant> CValuesMap;

class CGlobal : public QObject {
Q_OBJECT

public:
    CGlobal();
    ~CGlobal();

    bool contains(const QString &aSection, const QString &aName);
    bool containsSection(const QString &aSection);

    QVariant variable(const QString &aSection, const QString &aName);
    void setVariable(const QString &aSection, const QString &aName, const QVariant &aValue);

    QMap<QString, QVariant> sectionVariables(const QString &aSection);
    void setSectionVariables(const QString &aSection, QMap<QString, QVariant> &aValue);

    QVariant constant(const QString &aKey, const QVariant &aDefaultValue = QVariant()) const;

public slots:
    // user defined functions
    void updateRootDirs();

private:
    QMap < QString, CValuesMap > mVariables;
    CValuesMap mConstants;

signals:
    void refreshRootDirs();

};

#endif // __CGLOBAL_H__
