/****************************************************************************
 **
 ** Author: Grigory A. Mozhaev
 ** Copyright (C) 2008-2009 Griland Company.
 ** Contact: Griland Company (griland.support@gmail.com)
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://www.trolltech.com/products/qt/opensource.html
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/
#define SOURCE_CODING "UTF-8"

#include <Qt/QtCore>
#include <Qt/QtGui>

#include "capplication.h"

#include "cdvdview.h"
#include "cselectdialog.h"

#include "cmainwindow.h"


CMainWindow::CMainWindow( QWidget * apParent, Qt::WFlags aFlags)
    : QMainWindow(apParent, aFlags)
{      
    mpGenerateDialog = 0;
    setWindowTitle("QMultirecorder burning tool");
}

CMainWindow::~CMainWindow() {
    qDebug() << "~CMainWindow";
    if (mpGenerateDialog) {
        delete mpGenerateDialog;
    }
}

int CMainWindow::createDvdPlaces() {
    Q_ASSERT(CApplication::global()!=0);

    QFrame *vpFrame = new QFrame();
    QList<QWidget *> vList;

    QStringList vRootDirs;

    QString vRootsFileName = CApplication::global()->constant(QLatin1String("RootsFileName")).toString();
    QFile vPathFile(vRootsFileName);
    if (vPathFile.open(QIODevice::ReadOnly)) {
        QString vString = vPathFile.readAll();
        vRootDirs = vString.split(QLatin1String("\n"),QString::SkipEmptyParts);
        CApplication::global()->setVariable(QLatin1String("fs"),QLatin1String("rootDirs"), QVariant::fromValue(vRootDirs));
        vPathFile.close();
    }

    QString vDevicesFileName = CApplication::global()->constant(QLatin1String("DevicesFileName")).toString();
    QFile vFile(vDevicesFileName);
    if (vFile.open(QIODevice::ReadOnly)) {
        QString vConfig = vFile.readAll();
        vFile.close();
        QStringList vDevices = vConfig.split("\n",QString::SkipEmptyParts);
        int vCounter = 1;
        foreach (QString vDevice, vDevices) {
            QStringList vDeviceList = vDevice.split(":",QString::SkipEmptyParts);

            QString vDeviceName = vDeviceList.at(0).trimmed();
            QString vDeviceInfo;

            if (vDeviceList.size() > 1 ) {
                vDeviceInfo = vDevice.split(":",QString::SkipEmptyParts).at(1);
            }

            qDebug() << vDevice;
            CDvdView *vpWidget = new CDvdView();
            if (vpWidget) {
                vpWidget->setDevice(vDeviceName, vDeviceInfo);
                vpWidget->setLabel(QString("%1.").arg(vCounter++));
                vList.append(vpWidget);
            }
        }

        if (vCounter == 1) {
            qDebug() << "No devices present (file is empty!)";
            qDebug() << "Delete this file and restart application, it tries to recreate file!";
            return -3;
        }

        // create a layout
        int vSize = vList.size();
        if (vSize) {
            if (vSize < 3) {
                QHBoxLayout *vpLayout = new QHBoxLayout();

                foreach (QWidget *vpWidget, vList) {
                    vpLayout->addWidget(vpWidget);
                }

                vpFrame->setLayout(vpLayout);
            } else {
                QGridLayout *vpLayout = new QGridLayout();
                for (int i=0;i < vSize;i++) {
                    vpLayout->addWidget(vList.at(i),i / 2, i % 2);
                }
                vpFrame->setLayout(vpLayout);
            }
        }
    } else {
        qDebug() << "Can't open file with devices information: " << vDevicesFileName;
        return -2;
    }
    
    setCentralWidget(vpFrame);

    return 0;
}

int CMainWindow::init() {
    Q_ASSERT(CApplication::global()!=0);

    QString vDevicesFileName = CApplication::global()->constant(QLatin1String("DevicesFileName")).toString();

    //CSelectDialog vDialog;
    //vDialog.init(vDevicesMap.keys());
    //vDialog.exec();
    QMap<QString,QString> vDevicesMap = CDvdModel::allDevices();

    if (vDevicesMap.size() == 0)
        return -3;

    QFileInfo vInfo(vDevicesFileName);
    if (!vInfo.exists()) {
        QStringList vDevicesList;
        QMap<QString, QString>::const_iterator i = vDevicesMap.constBegin();
        while (i != vDevicesMap.constEnd()) {
            vDevicesList << QString("%1 : %2").arg(i.key()).arg(i.value());
            ++i;
        }
        
        CSelectDialog vDialog;
        vDialog.setWindowTitle(tr("Select active devices"));
        vDialog.init(vDevicesList);
        if (vDialog.exec() == QDialog::Accepted) {
            QFile vFile(vDevicesFileName);
            if (vFile.open(QIODevice::WriteOnly)) {
                QTextStream vOut(&vFile);
                foreach (QString vItem, vDevicesList) {
                    if (vDialog.isChecked(vItem))
                        vOut << vItem;
                }
                vFile.close();
            } else {
                qDebug() << "Can't create file for device information: ";
                return -1;
            }
        } else {
            qDebug() << "Exiting...";
            return -2;
        }
    }

    move(100,100);
    //setGeometry(100, 100, 640, 480);
    //setWindowState(Qt::WindowMaximized);    

    connect(CApplication::global(), SIGNAL(refreshRootDirs()), this, SLOT(refreshRootDirsSlot()));

    return createDvdPlaces();
}

void CMainWindow::refreshRootDirsSlot() {
    checkMd5SumFiles();
}

void CMainWindow::checkMd5SumFiles() {
    QStringList vAbsentFiles;
    QStringList vAbsentFullNames;

    QStringList vRootDirs = CApplication::global()->variable(QLatin1String("fs"), QLatin1String("rootDirs")).toStringList();
    foreach (QString vPath, vRootDirs) {
        QDir vDir(vPath);
        QStringList vCategories = vDir.entryList(QDir::AllDirs | QDir::NoDotAndDotDot);
        foreach (QString vCategory, vCategories) {
            QDir vDir2(QString("%1/%2").arg(vPath).arg(vCategory));

            QStringList vNameFilters;
            vNameFilters << QLatin1String("*.[iI][sS][oO]");

            QStringList vFiles = vDir2.entryList(vNameFilters, QDir::Files);
            foreach (QString vFile, vFiles) {
                QString vFileNameMd5 = QDir::toNativeSeparators(QString("%1/%2/%3.md5sum").arg(vPath).arg(vCategory).arg(vFile));
                QFileInfo vInfo(vFileNameMd5);
                if (!vInfo.exists()) {
                    vAbsentFiles << QDir::toNativeSeparators(QString("%1/%2").arg(vCategory).arg(vFile));
                    vAbsentFullNames << QDir::toNativeSeparators(QString("%1/%2/%3").arg(vPath).arg(vCategory).arg(vFile));
                }
            }
        }
    }

    if (vAbsentFiles.size() > 0) {
        CSelectDialog vDialog;
        vDialog.setWindowTitle(tr("Select files for which need to generate check Md5 sum"));
        vDialog.init(vAbsentFiles);
        if (vDialog.exec() == QDialog::Accepted) {
            if (mpGenerateDialog == 0) {
                mpGenerateDialog = new CGenerateDialog();
                mpGenerateDialog->init(vAbsentFiles,vAbsentFullNames);
                mpGenerateDialog->show();
            }
        }
    }
}

void CMainWindow::closeEvent(QCloseEvent *apEvent) {
    if (mpGenerateDialog) {
        mpGenerateDialog->setCanClose(true);
        mpGenerateDialog->close();
    }
    apEvent->accept();
}
