/****************************************************************************
 **
 ** Author: Grigory A. Mozhaev
 ** Copyright (C) 2008-2009 Griland Company.
 ** Contact: Griland Company (griland.support@gmail.com)
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://www.trolltech.com/products/qt/opensource.html
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/
//! -*- coding: UTF-8 -*-
#define SOURCE_CODING "UTF-8"

#include <Qt/QtCore>
#include <Qt/QtGui>

#include "capplication.h"

#include "cselectdialog.h"
#include "ui_cselectdialog.h"

//!
CSelectDialog::CSelectDialog(QWidget * apParent, Qt::WindowFlags aFlags)
    : QDialog(apParent,aFlags), mpUi(new Ui::CSelectDialog) {  
    mpUi->setupUi(this);
}

//!
CSelectDialog::~CSelectDialog() {
    //
}

//!
void 
CSelectDialog::init(const QStringList& aList) {
    mpUi->mpListWidget->blockSignals(true);
    mpUi->mpListWidget->addItems(aList);

    mCheckedCount = 0;
    for (int i=0; i < mpUi->mpListWidget->count(); i++) {
        QListWidgetItem *vpItem = mpUi->mpListWidget->item(i);
        vpItem->setFlags(Qt::ItemIsUserCheckable | Qt::ItemIsEnabled | Qt::ItemIsSelectable);
        vpItem->setCheckState(Qt::Checked);
        mCheckedCount++;
    }

    canContinue();

    mpUi->mpListWidget->blockSignals(false);
}

//!
bool 
CSelectDialog::isChecked(const QString &aItemName) {
    QList<QListWidgetItem *> vItems = mpUi->mpListWidget->findItems(aItemName, Qt::MatchExactly);
    if (vItems.size() > 0) {
        return (vItems.at(0)->checkState() == Qt::Checked);
    }

    return false;
}

void CSelectDialog::on_mpListWidget_itemChanged(QListWidgetItem * apItem) {
    qDebug() << "intem changed";

    if (apItem->checkState() == Qt::Checked) {
        mCheckedCount++;
    } else {
        mCheckedCount--;
    }

    canContinue();
}

void CSelectDialog::canContinue() {
    qDebug() << "mCheckedCount = " << mCheckedCount;
    if (mCheckedCount > 0) {
        mpUi->mpButtonBox->button(QDialogButtonBox::Ok)->setEnabled(true);
    } else {
        mpUi->mpButtonBox->button(QDialogButtonBox::Ok)->setEnabled(false);
    }
}
