/****************************************************************************
 ** Copyright (C) 2008-2013 Grigory A. Mozhaev <zcrendel@gmail.com>
 **
 ** This file is part of QMultiRecord (http://qt-apps.org/content/show.php?content=106254).
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://www.trolltech.com/products/qt/opensource.html
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ****************************************************************************/
#ifndef __APPLICATION_H__
#define __APPLICATION_H__

#include <locale.h>
#include <langinfo.h>
#include <unistd.h>
#include <errno.h>
#include <stdio.h>

#include "define.h"

#include <QtCore>
#if HAVE_QT5
#include <QtWidgets>
#else
#include <QtGui>
#endif

class GenerateDialog;
class Application : public QApplication {
Q_OBJECT

public:
    Application(int &argc, char **argv);
    ~Application();

    static Application *instance();
    static QStringList paths();

Q_SIGNALS:
    void pathsOutdated();

public Q_SLOTS:
    void refreshPaths();
    void checkMd5SumFiles();

private Q_SLOTS:
    void generateDialog_closed();

private:
    void initLocale();

    GenerateDialog *m_generateDialog;
};

#endif // __APPLICATION_H__
