/****************************************************************************
 ** Copyright (C) 2008-2013 Grigory A. Mozhaev <zcrendel@gmail.com>
 **
 ** This file is part of QMultiRecord (http://qt-apps.org/content/show.php?content=106254).
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://www.trolltech.com/products/qt/opensource.html
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ****************************************************************************/
#ifndef __CHECKTHREAD_H__
#define __CHECKTHREAD_H__

#include <QtCore>
#include <QThread>

class CheckThreadPrivate;
class DvdModel;

class CheckThread : public QThread {
Q_OBJECT

public:
    CheckThread();
    ~CheckThread();

    void init(DvdModel *model);

    QString hash();
    bool done();

signals:
    void progress(int progress, const QString &info = QString::null);

public:
    void run();
    void stop();

private:
    CheckThreadPrivate *m_data;
};

#endif // __CHECKTHREAD_H__
