/****************************************************************************
 ** Copyright (C) 2008-2013 Grigory A. Mozhaev <zcrendel@gmail.com>
 **
 ** This file is part of QMultiRecord (http://qt-apps.org/content/show.php?content=106254).
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://www.trolltech.com/products/qt/opensource.html
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ****************************************************************************/
#ifndef __DVDMODEL_H__
#define __DVDMODEL_H__

#include <QtCore>
#include <QtDBus>

#include "checkthread.h"
#include "burnthread.h"

class DvdModelPrivate;

class DvdModel : public QObject {
Q_OBJECT

public:
    DvdModel(const QString &dbusPath, const QString &deviceFile, const QString &deviceInfo, int type);
    ~DvdModel();

    static void initialize();
    static void finalize();
    static QList<DvdModel *> devices();
    static DvdModel *devicesByFile(const QString &file);

    enum DeviceType {
        dtUndefined   = 0,
        dtUnsupported = 1,
        dtCdWriter    = 2,
        dtDvdWriter   = 3,
        dtBdWriter    = 4
    };

    enum DvdStatus { 
        dsUndefined  = 0,
        dsNoDisc     = 1,
        dsEmptyCd    = 2,
        dsEmptyDvd   = 3,
        dsEmptyBd    = 4,
        dsDataCd     = 5,
        dsDataDvd    = 6,
        dsDataBd     = 7,
    };

    enum ProcessMode { 
        pmNone       = 0,
        pmWaiting    = 1,
        pmWriting    = 2,
        pmChecking   = 3,
        pmCheckDone  = 4,
        pmCheckFailed= 5,
        pmWriteDone  = 6,
        pmWriteFailed= 7
    };

    bool enabled() const;
    void setEnabled(bool enabled);

//    QString deviceId() const;
    QString deviceFile() const;
    QString deviceInfo() const;

    quint64 capacity() const;
    DvdModel::DvdStatus dvdStatus() const;
    DvdModel::ProcessMode processMode() const;

    void setSpeed(int aSpeed);
    int speed() const;

    void setBuffer(const QString &buffer);
    QString buffer() const;

    void setISOFileName(const QString &isoFileName);
    QString isoFileName() const;

    void setISOSize(quint64 size);
    quint64 isoSize() const;

    void setStreamRecording(bool enabled);
    bool streamRecording() const;

Q_SIGNALS:
    void statusChanged(const QString &device, 
                       const DvdModel::DeviceType  &deviceType,
                       const DvdModel::DvdStatus   &dvdStatus,
                       const DvdModel::ProcessMode &processMode,
                       quint64 capacity,
                       const QString &hash);

    void progress(int progress, const QString &info = QString::null);

public Q_SLOTS:
    void checkMedia();

    void burnISO(const QString fileName = QString::null);
    void checkSum(quint64 size);

    void cancel();

    void update();

private Q_SLOTS:
    void deviceChanged();

    void burnThreadFinished();
    void burnThreadStarted ();

    void checkThreadFinished();
    void checkThreadStarted ();

private:
    DvdModelPrivate *m_data;

    void pollMedia();
};

#endif // __DVDMODEL_H__
