/****************************************************************************
 ** Copyright (C) 2008-2013 Grigory A. Mozhaev <zcrendel@gmail.com>
 **
 ** This file is part of QMultiRecord (http://qt-apps.org/content/show.php?content=106254).
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://www.trolltech.com/products/qt/opensource.html
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ****************************************************************************/
#ifndef _GENERATEDIALOG_H_
#define _GENERATEDIALOG_H_

#ifdef QT_5
#include <QtWidgets>
#else
#include <QtGui>
#endif

#include "generatethread.h"
#include "ui_generatedialog.h"

namespace Ui {
    class CGenerateDialog;
}

class GenerateDialog : public QWidget, public Ui_GenerateDialog {
Q_OBJECT

public:
    GenerateDialog(QWidget *parent = 0, Qt::WindowFlags f = 0);
    virtual ~GenerateDialog();

    void init(const QStringList &jobList, const QStringList &fullNames);
    void setCanClose(bool flag);

Q_SIGNALS:
    void closed();

private slots:
    void progress(const QString &jobName, int value, const QString &info = QString::null);
    void switchJob(const QString &prev, const QString &next);

    void finished();

    void on_closeButton_clicked();
    void on_cancelButton_clicked();
    void on_stopButton_clicked();

protected:
    void closeEvent(QCloseEvent *);
    void resizeEvent(QResizeEvent *);

private:
    bool m_canClose;

    GenerateThread *m_thread;
};

#endif /* _GENERATEDIALOG_H_ */
