/****************************************************************************
 ** Copyright (C) 2008-2013 Grigory A. Mozhaev <zcrendel@gmail.com>
 **
 ** This file is part of QMultiRecord (http://qt-apps.org/content/show.php?content=106254).
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://www.trolltech.com/products/qt/opensource.html
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ****************************************************************************/
#ifndef _GENERATETHREAD_H_
#define _GENERATETHREAD_H_

#include <QtCore>
#include <QThread>

class GenerateThreadPrivate;
class GenerateThread : public QThread {
Q_OBJECT

public:
    GenerateThread();
    ~GenerateThread();

    void init(const QStringList &jobList, const QStringList &fullNames);
    int jobStatus(const QString &jobName);

signals:
    void progress(const QString &jobName, int value, const QString &info = QString::null);
    void switchJob(const QString &prev, const QString &next);

public:
    void run();
    void stop();

    void cancelJob(const QString &jobName);

private:
    GenerateThreadPrivate *m_data;
    QMutex m_mutex;
};

#endif /* _GENERATETHREAD_H_ */
