# QOwnNotes Changelog

## 17.09.9
- the note text edit margins will now be updated when the font size increased
  or decreased in the *distraction free mode*
  (for issue [Issue #727](https://github.com/pbek/QOwnNotes/issues/727))
- improvements of the external note tagging support via the scripting engine
  (for issue [Issue #530](https://github.com/pbek/QOwnNotes/issues/530))
    - fixed crash when removing more than one tag that have notes linked to them
- when inserting a link into a note some more broken characters from the 
  webpage's html-title will be replaced
- added more German translation (thank you rakekniven)

## 17.09.8
- fixed the upstream RTL bug in the note text edit
  (for issue [Issue #714](https://github.com/pbek/QOwnNotes/issues/714))
- improvements of the external note tagging support via the scripting engine
  (for issue [Issue #530](https://github.com/pbek/QOwnNotes/issues/530))
    - fixed the problem where notes were overwritten by other notes in bulk operations
    - fixed a lot of occasions where not all notes were handled in bulk operations
    - fixed some random crashes with bulk operations and when the note tag tree reloads
    - fixed some random crashes, updating of the current note and occasions 
      where not all notes were handled when renaming tags
- fixed increasing and decreasing of code font-size via keyboard shortcut 
  (for issue [Issue #724](https://github.com/pbek/QOwnNotes/issues/724))
- when inserting a link into a note some more broken characters from the 
  webpage's html-title will be replaced
- added more Hungarian and French translation (thank you Fabijenna and sagoum.kakoum)

## 17.09.7
- underline bracket closing is temporary disabled because underlines are used
  in different contexts
- improvements of the external note tagging support via the scripting engine
  (for issue [Issue #530](https://github.com/pbek/QOwnNotes/issues/530))
	- improved ui feedback when adding and removing tags in the current note
	- tagging of multiple notes works now but is still a bit wacky because of
	  race conditions with files that are getting changed all around (notes 
	  and note database)
		- the same goes for removing multiple notes
- added more Hungarian translation (thank you Fabijenna)

## 17.09.6
- added the first alpha version of external note tagging support via the 
  scripting engine (for [Issue #323](https://github.com/pbek/QOwnNotes/issues/323),
  [Issue #338](https://github.com/pbek/QOwnNotes/issues/338),
  [Issue #379](https://github.com/pbek/QOwnNotes/issues/379),
  [Issue #472](https://github.com/pbek/QOwnNotes/issues/472),
  [Issue #530](https://github.com/pbek/QOwnNotes/issues/530) and
  [Issue #603](https://github.com/pbek/QOwnNotes/issues/603))
    - as soon as a script is activated that implements the new function
      `noteTaggingHook` note tagging will be handled by that function
    - please install the script [note-tagging.qml](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/note-tagging.qml)
      to test the basic functionality and report in [Issue #530](https://github.com/pbek/QOwnNotes/issues/530).
        - your internal tag database and your notes might get modified 
        - don't use this script on your production note folder, please make a 
          copy of it and test it there!
    - following features should already work via the QOwnNotes user interface
        - initially importing tags like `@tag` from your notes and overwriting
          your current tag assignment
            - you will not loose your tags tree, just the former assignment to notes
            - you can still move tags into other tags
            - if more than one tag has the same name in your tag tree the 
              first hit will be assigned
        - adding a tag to a note will add the tag to the note text        
        - removing a tag from a note will remove the tag from the note text
        - removing of tags in the tag list will remove those tags from your notes
        - renaming of tags in the tag list will rename those tags in your notes
        - bulk tagging of notes in the note list will add those tags to your notes
        - bulk removing of tags from notes in the note list will remove those 
          tags from your notes
    - for more information please take a look at the [scripting documentation](http://docs.qownnotes.org/en/develop/scripting/README.html#notetagginghook)

## 17.09.5
- added support for entering a bracket-character that surrounds the currently 
  selected text (for [Issue #719](https://github.com/pbek/QOwnNotes/issues/719), thank you @sanderboom)
- added more Catalan and Hungarian translation (thank you MGuerra and Fabijenna)
- added two new scripting-methods `addTag` and `removeTag` to `NoteApi` to 
  add and remove tags from notes (for [Issue #530](https://github.com/pbek/QOwnNotes/issues/530))
    - custom tagging could now be implemented by parsing the note text for 
      custom tag handlers and adding/removing tags from the note
    - for more information please take a look at the [scripting documentation](http://docs.qownnotes.org/en/develop/scripting/README.html#note)

## 17.09.4
- fixed a possible crash when selecting a lot of notes quickly in succession 
  and improved speed of selecting notes in quick in succession
  (for [Issue #717](https://github.com/pbek/QOwnNotes/issues/717))
- apostrophe bracket closing is temporary disabled because apostrophes are used
  in different contexts (for [Issue #708](https://github.com/pbek/QOwnNotes/issues/708))
- added more French, Indonesian, Dutch and Hungarian translation (thank you 
  bepolymathe, zmni and Fabijenna)

## 17.09.3
- added improvements to not start new list items when not in a list
  (for [Issue #712](https://github.com/pbek/QOwnNotes/issues/712), thank you @sanderboom)
- added improvements for the auto-completion of `~` and `_`
  (for [Issue #713](https://github.com/pbek/QOwnNotes/issues/713), thank you @sanderboom)
- moved the setting of the *width of the cursor in the note-edit* from the 
  *Interface settings* to the *Editor settings*
- added more Brazilian Portuguese, Russian, Italian, Chinese, German and Spanish
  translation (thank you mlimacarlos, Maboroshy, mlocati, Libnux, rakekniven and 
  richarson)

## 17.09.2
- the scroll position of the note-preview is now also synced when clicking on
  headlines in the navigation panel (for [Issue #710](https://github.com/pbek/QOwnNotes/issues/710))
- you can now set the width of the cursor in the note-edit in the *Interface settings*
  (for [Issue #710](https://github.com/pbek/QOwnNotes/issues/710))
- the automatic closing of brackets now also works for `_` and `~`
  (for [Issue #708](https://github.com/pbek/QOwnNotes/issues/708), thank you @sanderboom)
- added more Brazilian Portuguese, Catalan, Italian, Japanese and Spanish
  translation (thank you mlimacarlos, MGuerra, mlocati, piyo and richarson)

## 17.09.1
- the `QMarkdownTextedit`, which is used in all markdown text-edits is now based
  on`QPlainTextEdit` instead of `QTextEdit`, which should result in **improved
  rendering speed** for large notes
    - this will improve the note text edit, log panel, version dialog, trash 
      dialog, todo dialog, settings dialog, note dialog and note history dialog
- you can now choose different **interface styles** in the *Interface settings* 
  to change the look of the application's interface and its controls
    - the style will be previewed instantly if you select an other style
    - if you select `Automatic` you will be prompted to restart the application
- the snap-packaged version of QOwnNotes will now automatically use the `Fusion`
  interface style, which dramatically improves the styling of the user interface
- the automatic closing of brackets now also works for `'`
  (for [Issue #708](https://github.com/pbek/QOwnNotes/issues/708))
- added more Brazilian Portuguese, Catalan, German and Spanish translation 
  (thank you mlimacarlos, MGuerra and richarson)

## 17.09.0
- margins for headlines in the note editor are now disabled, because Qt bugs 
  are causing multiple problems with them
    - they prevent "undo" in headlines
      (for [Issue #520](https://github.com/pbek/QOwnNotes/issues/520))
    - they generate invisible lines at the end of a note
      (for [Issue #667](https://github.com/pbek/QOwnNotes/issues/667))
    - the cause a crash when reaching the invisible lines when highlighting of
      the current line is turned on (for [Issue #701](https://github.com/pbek/QOwnNotes/issues/701))
- improved background color of current line highlighting for the schemas *Dark*,
  *AnalyticalYellow*, *Bépolymathe Colorize* and *Mountain*
  (for [Issue #701](https://github.com/pbek/QOwnNotes/issues/701))
- added more Russian, Catalan, German, Italian and French translation (thank 
  you Maboroshy, MGuerra, rakekniven, mlocati and bepolymathe)

## 17.08.11
- the shortcuts for restoring workspaces will now be correctly restored after restart
  (for [Issue #697](https://github.com/pbek/QOwnNotes/issues/697))
- the **current line** will now **highlighted** in the editor
  (for [Issue #701](https://github.com/pbek/QOwnNotes/issues/701))
	- you can turn that feature off in the *Editor settings*
	- the background color can be selected as part of the theming in the
	 *Editor fonts & colors settings*
		- a sane default color was chosen for each of the current schemes
- added more Russian, Spanish, Croatian, Indonesian, Brazilian Portuguese,
  Swedish, Catalan and Chinese translation (thank you Maboroshy, richarson,
  davidsraba2, zmni, mlimacarlos, druus, MGuerra and chonghua)

## 17.08.10
- fixed a problem with the note history when notes with the same name were 
  present in different note subfolders
- added a fix by @SmartBlug for the issue of jumping cursors for some users
  (for [Issue #689](https://github.com/pbek/QOwnNotes/issues/689))
- added more French, Indonesian, German and Italian translation (thank you 
  bepolymathe, zmni, rakekniven and mlocati)

## 17.08.9
- added **Indonesian translation** (a big thank you to zmni!)
    - join us at [QOwnNotes on Crowdin](https://crowdin.com/project/qownnotes/)
      to make QOwnNotes available in more languages or help with the current 
      translation
- improved highlighting for Rmarkdown comments like `[Comment]: # (text)`
  (for [Issue #690](https://github.com/pbek/QOwnNotes/issues/690))
- some text changes in the settings dialog were done
- added more German translation (thank you rakekniven)

## 17.08.8
- fixed some highlighting-issues with HTML comments
- added highlighting for Rmarkdown comments like `[Comment]: # (text)`
  (for [Issue #690](https://github.com/pbek/QOwnNotes/issues/690))
- added a fix by @SmartBlug for the sporadic cursor-jumping to the top in the
  note edit (for [Issue #689](https://github.com/pbek/QOwnNotes/issues/689))
- added more Italian and Chinese translation (thank you mlocati, Libnux and enyie)

## 17.08.7
- old notes that were automatically renamed will now only be removed if the new
  note was stored successfully (for [Issue #682](https://github.com/pbek/QOwnNotes/issues/682))
- if a note gets renamed automatically because the note title changed it will
  now be checked if the note can actually be stored to the note folder before
  really storing it to be able to attempt to replace additional characters in
  the filename before storing it again in case the note is stored on a
  filesystem with harsher filename restrictions
  (for [Issue #682](https://github.com/pbek/QOwnNotes/issues/682) and
  [Issue #683](https://github.com/pbek/QOwnNotes/issues/683))
    - if the note still cannot be stored to disk the 2nd time the error will be 
      logged to the log panel like it already was before
- added a new editor color schema *Mountain* by @bepolymathe
  (for [Issue #680](https://github.com/pbek/QOwnNotes/issues/680))
- added a new editor color schema *Arc* by @johanson
  (for [Issue #687](https://github.com/pbek/QOwnNotes/issues/687))
- added more French, Italian, German, Chinese and Spanish translation
  (thank you bepolymathe, mlocati, rakekniven, enyie and richarson)
- the `Delete line` function now *pulls the text from the bottom up*
  (for [Issue #432](https://github.com/pbek/QOwnNotes/issues/432))

## 17.08.6
- if you want to remote control QOwnNotes with sockets you can use `WebSocketServer` in a script
    - for more information please take a look at the [scripting documentation](http://docs.qownnotes.org/en/develop/scripting/README.html#working-with-websockets)
- you can now also search for filenames of notes in the note search line-edit, 
  instead of just for note-text (for [Issue #678](https://github.com/pbek/QOwnNotes/issues/678))
- you now can search for notes in all tags / subfolders with the new main menu 
  entry `Find notes in all tags / subfolders` (shortcut <kbd>Alt + F</kbd>)
  (for [Issue #671](https://github.com/pbek/QOwnNotes/issues/671))
    - the menu entry `Find notes in all subfolders` was removed as a consequence
    - please visit [QOwnNotes shortcuts](http://www.qownnotes.org/shortcuts/QOwnNotes)
      for a list of all shortcuts
- added more French and Italian translation (thank you bepolymathe and mlocati)

## 17.08.5
- added a new editor color schema *Bepolymathe Colorize*
  (for [Issue #675](https://github.com/pbek/QOwnNotes/issues/675), thank you @bepolymathe)
- double clicking on items in the *note subfolder tree* and *tag tree* now 
  causes the tree items to expand and collapse instead of editing them
  (for [Issue #669](https://github.com/pbek/QOwnNotes/issues/669))
    - there now is a new menu entry `Rename subfolder` in the note subfolder
      tree to rename subfolders
- you can now use the new scripting functions `script.setPersistentVariable()`
  and `script.getPersistentVariable()` to store and load persistent variables in 
  scripts (for [Issue #677](https://github.com/pbek/QOwnNotes/issues/677))
  - for more information please take a look at the
    [scripting documentation](http://docs.qownnotes.org/en/develop/scripting/README.html#storing-and-loading-persistent-variables)
- added more French and Swedish translation (thank you bepolymathe and druus)

## 17.08.4
- the order of the scripts in the *Script settings* now really adjusts which
  script is executed first (for [Issue #663](https://github.com/pbek/QOwnNotes/issues/663))
- a warning with error code and error message will now be printed to the log 
  panel if a network error occurs when talking to your ownCloud / Nextcloud 
  server (for [Issue #664](https://github.com/pbek/QOwnNotes/issues/664))
- attempted to fix the reminder date in todo list items for newer versions of
  Nextcloud (for [Issue #664](https://github.com/pbek/QOwnNotes/issues/664))

## 17.08.3
- you can now reorder your scripts in the *Script settings* via drag and drop
  to adjust which scripts should be executed first
  (for [Issue #663](https://github.com/pbek/QOwnNotes/issues/663))
- the scripting function `noteToMarkdownHtmlHook` can now be used in multiple
  scripts to modify the html of the preview
  (for [Issue #663](https://github.com/pbek/QOwnNotes/issues/663))
- added more French, Italian, Brazilian Portuguese and Spanish translation
  (thank you bepolymathe, mlocati, mlimacarlos and richarson)

## 17.08.2
- added **Swedish translation** (a big thank you to druus!)
    - join us at [QOwnNotes on Crowdin](https://crowdin.com/project/qownnotes/)
      to make QOwnNotes available in more languages or help with the current 
      translation
- the `Delete line` function now only deletes the text to the beginning of 
  the line and not the whole line to mimic the behavior of other text editors
  (for [Issue #432](https://github.com/pbek/QOwnNotes/issues/432))
- if <kbd>Tab</kbd> is pressed while adding a tag to the current note the tag 
  that starts with the currently entered text will now be added
  (for [Issue #658](https://github.com/pbek/QOwnNotes/issues/658))
- when `Show in system tray` will be checked in the *Window menu* then the 
  user will now receive a notification if `Allow only one app instance` isn't 
  enabled in the settings (for [Issue #660](https://github.com/pbek/QOwnNotes/issues/660))
- added more Catalan and German translation (thank you MGuerra)

## 17.08.1
- fixed linking of notes in the link dialog
  (for [Issue #646](https://github.com/pbek/QOwnNotes/issues/646))
- fixed the colors in the editor color schema *Bépolymathe Light* 
  (for [Issue #648](https://github.com/pbek/QOwnNotes/issues/648))
- added more Catalan translation (thank you MGuerra)

## 17.08.0
- added a new editor color schema *Bepolymathe Light* (thank you @bepolymathe)
  (for [Issue #648](https://github.com/pbek/QOwnNotes/issues/648))
- when pasting html from the clipboard as markdown null characters and Windows
  line breaks will now be removed as well as all tags will be interpreted over
  multiple lines (for [Issue #645](https://github.com/pbek/QOwnNotes/issues/645))
- added more Catalan translation (thank you MGuerra)

## 17.07.9
- fixed a possible crash when using scripts with custom actions in the note
  list context menu when the script engine is reloaded and the context menu
  is opened (for [Issue #490](https://github.com/pbek/QOwnNotes/issues/490))
- there now is a new scripting command `script.inputDialogGetItem` to open a
  input dialog with a select box (for [Issue #490](https://github.com/pbek/QOwnNotes/issues/490))
    - for more information please take a look at
      [Opening an input dialog with a select box](http://docs.qownnotes.org/en/develop/scripting/README.html#opening-an-input-dialog-with-a-select-box)
- when entering an url in the link-dialog with <kbd>Ctrl + L</kbd> that is 
  missing a`://` then `http://` will automatically added in front of the url
  (for [Issue #646](https://github.com/pbek/QOwnNotes/issues/646))
- added more Catalan and Spanish translation (thank you MGuerra and richarson)

## 17.07.8
- there now is a new scripting command `script.selectedNotesPaths()` to return a
  list of the paths of all selected notes 
  (for [Issue #490](https://github.com/pbek/QOwnNotes/issues/490))
    - for more information please take a look at
      [Getting a list of the paths of all selected notes](http://docs.qownnotes.org/en/develop/scripting/README.html#getting-a-list-of-the-paths-of-all-selected-notes)
- scripting function `registerCustomAction` now has a new parameter to add 
  a menu entry to the note list context menu
    - for more information please take a look at the 
      [registerCustomAction documentation](http://docs.qownnotes.org/en/develop/scripting/README.html#registering-a-custom-action)
- there is a new script *External note diff* in the script repository, that 
  uses above new features and adds adds a menu entry to the context menu of the
  note list to **diff selected notes** in an external diff program 
    - the path of the diff program can be selected in the script settings of 
      the script
- added more Catalan, French, Italian, Brazilian Portuguese and German
  translation (thank you MGuerra, bepolymathe, mlocati and mlimacarlos)

## 17.07.7
- added **Catalan translation** (a big thank you to MGuerra!)
    - join us at [QOwnNotes on Crowdin](https://crowdin.com/project/qownnotes/)
      to make QOwnNotes available in more languages or help with the current 
      translation
- fixed more problems with resetting the mouse cursor after pressing <kbd>Ctrl</kbd> 
  for Windows (for [Issue #637](https://github.com/pbek/QOwnNotes/issues/637))
- fixed an issue with the highlighting of special cases of the references of 
  reference links (for [Issue #643](https://github.com/pbek/QOwnNotes/issues/643))
- added paragraph recognition for the pasting of html-code
  (for [Issue #643](https://github.com/pbek/QOwnNotes/issues/643), thank you @vanleo2001)
- added more Dutch and German translation (thank you Fabijenna and rakekniven)

## 17.07.6
- fixed resizing of too large images under Windows in the preview and the 
  PDF export (for [Issue #639](https://github.com/pbek/QOwnNotes/issues/639))
- the mouse-cursor will now be set to a beam-cursor when pressing <kbd>Ctrl + R</kbd> 
  to reset the pointing-hand-cursor that was set by pressing <kbd>Ctrl</kbd>
  (for [Issue #637](https://github.com/pbek/QOwnNotes/issues/637))
- *Show root folder name* and *Display note subfolders as full tree* in the
  *Panels settings* are now set by default
  (for [Issue #612](https://github.com/pbek/QOwnNotes/issues/612))
- replacing multiple line breaks when pasting html into a note with
  `Ctrl + Shift + V` (for [Issue #634](https://github.com/pbek/QOwnNotes/issues/634))
- added more French and German translation (thank you Loelo and rakekniven)

## 17.07.5
- fixed a problem with correctly storing the note text when special note text
  changes were made between the note save intervals
  (for [Issue #635](https://github.com/pbek/QOwnNotes/issues/635))

## 17.07.4
- the mouse-cursor will now be set to a beam-cursor when pressing <kbd>Ctrl + F</kbd> 
  to reset the pointing-hand-cursor that was set by pressing <kbd>Ctrl</kbd>
  (for [Issue #637](https://github.com/pbek/QOwnNotes/issues/637))
- under Windows the selection background color in the note text edit is now set 
  to a light blue if not in dark mode to prevent visibility problems when
  searching text (for [Issue #636](https://github.com/pbek/QOwnNotes/issues/636))
- added more Polish, Spanish, Italian, Brazilian Portuguese, Hungarian and
  German translation (thank you lucjan, polkillas, smart2128, mlimacarlos,
  vaganyik and jmbm)

## 17.07.3
- when opening the todo list dialog from the system tray the main window of 
  QOwnNotes will be brought to the foreground too to prevent crashes under
  Windows (for [Issue #630](https://github.com/pbek/QOwnNotes/issues/630))
- dialog windows are now maximized if it looks like that they don't fit on
  the current screen the first time they were opened
  (for [Issue #631](https://github.com/pbek/QOwnNotes/issues/631))
- you now get a warning if you try to rename a note in the note list to enable
  the option to allow the note filename to be different from the headline if 
  you haven't allowed it yet (for [Issue #613](https://github.com/pbek/QOwnNotes/issues/613))
    - there is a button to directly open the *General settings* in the 
      warning dialog
- files are now only downloaded if the status code of the request was `success`
  to prevent downloaded files with error pages
  (for [Issue #627](https://github.com/pbek/QOwnNotes/issues/627))
- when downloading files a proper filename suffix will be set by detecting the
  mime type of the file (for [Issue #627](https://github.com/pbek/QOwnNotes/issues/627))
- added more German translation (thank you rakekniven)

## 17.07.2
- more problematic characters will be removed from the filename-suffix of 
  downloaded media files to make sure the file can be stored locally
  (for [Issue #627](https://github.com/pbek/QOwnNotes/issues/627))
- added more French translation (thank you lepascalou)

## 17.07.1
- **QOwnNotesAPI**, the ownCloud / Nextcloud API application for QOwnNotes
  is now available in the ownCloud Marketplace
    - you can find it at the [QOwnNotesAPI Marketplace page](https://marketplace.owncloud.com/apps/qownnotesapi)
- there now is a new *Editor color schema* **Material Dark** by @UltimateRandom
  (for [Issue #626](https://github.com/pbek/QOwnNotes/issues/626), a big thank you)
- added more Italian translation (thank you smart2128)

## 17.07.0
- there now is a repository with QOwnNotes built as **AppImage** for 32 and 64 
  bit systems (for [Issue #534](https://github.com/pbek/QOwnNotes/issues/534))
    - please visit the [AppImage installation page](http://www.qownnotes.org/installation#AppImage)
      for instructions
    - if you run QOwnNotes from the AppImage the automatic updater will be 
      enabled by default and you will be led the the AppImage download page if 
      there is a new version of the application available
- fixed a problem in the desktop file for all openSUSE builds
- added more Polish, Spanish, Croatian, Italian, Brazilian Portuguese, Hungarian
  and German translation (thank you lucjan, asoliverez, richarson, xpertmind,
  mlocati, mlimacarlos, vaganyik, jmbm and rakekniven)

## 17.06.6
- there are now new context menu entries in the note list
  (for [Issue #613](https://github.com/pbek/QOwnNotes/issues/613))
    - a `New note` menu entry to create a new note
    - a `Rename note` menu entry to rename the note if you allowed the note 
      filename to be different than the headline in the *General settings*
- the `Edit tag` context menu entry in the tag tree was renamed to `Rename tag`
- there now is a software repository for **Debian Linux 9.0**
    - please visit the [Debian installation page](http://www.qownnotes.org/installation#Debian)
      for instructions
- there now is a software repository for **Fedora 26**
    - please visit the [Fedora installation page](http://www.qownnotes.org/installation#Fedora)
      for instructions
- there now is a software repository for **openSUSE Leap 42.3**
    - please visit the [openSUSE installation page](http://www.qownnotes.org/installation#openSUSE)
      for instructions
- added more Japanese and German translation (thank you piyo and jmbm)

## 17.06.5
- the first line of the note is now not modified when the note file gets 
  automatically renamed because of harmful or unwanted characters
  (for [Issue #619](https://github.com/pbek/QOwnNotes/issues/619))
    - this doesn't seem to trouble ownCloud / Nextcloud notes a lot, but it
      renames the notes to its own liking
    - so you could use `# ` at the beginning of your note and it will only be
      removed in the note file name (unless you allow the note file name to 
      be different from the headline in the *General settings*)
    - if you want more control over your note file name you can achieve that 
      by writing a script, please take a look at
      [handleNoteTextFileNameHook](http://docs.qownnotes.org/en/develop/scripting/README.html#handlenotetextfilenamehook)
- added more Polish, Spanish and German translation (thank you lucjan,
  richarson and rakekniven)

## 17.06.4
- if you now add a local script in the *Scripting settings* you immediately get
  the dialog to select the script
- there now is a new script variables datatype `boolean`
    - to get information about how to use it please take a look at the example
      [variables.qml](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/variables.qml)
    - there is a new script `Weather stats` in the *Script repository* that 
      is using this new setting
- added more French translation (thank you lepascalou)

## 17.06.3
- you can now open the *Script repository dialog* with the Shortcut
  <kbd>Alt</kbd> + <kbd>⇧</kbd> + <kbd>I</kbd>
- if you now try to install a script in the *Script repository* that doesn't 
  support your platform you will get a dialog to cancel the installation
  (for [Script repository issue #3](https://github.com/qownnotes/scripts/issues/3))
- if you now try to install a script in the *Script repository* that needs a 
  newer version of QOwnNotes you will get a notification to update the application
- a problem with storing script settings if there is more than one setting was
  fixed (for [Issue #605](https://github.com/pbek/QOwnNotes/issues/605))
- the MainWindow is now exposed for scripting as variable `mainWindow`
  (for [Issue #604](https://github.com/pbek/QOwnNotes/issues/604))
  - you can use `mainWindow.buildNotesIndexAndLoadNoteDirectoryList(true, true)`
    to force a reload of the note list
  - for more information please take a look at the
    [scripting documentation](http://docs.qownnotes.org/en/develop/scripting/README.html#mainwindow)
- added more Italian translation (thank you mlocati)

## 17.06.2
- there are now new properties for notes in the scripting engine `fileCreated`
  and `fileLastModified` (for [Issue #599](https://github.com/pbek/QOwnNotes/issues/599))
  - you can use the methods from [Date](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date)
    to work with these date properties
  - for more information please take a look at the
    [scripting documentation](http://docs.qownnotes.org/en/develop/scripting/README.html#note)
- when posting a script to the *Script repository* you can now define which 
  platforms are supported by the script with the new `platforms` parameter
  (for [Script repository issue #3](https://github.com/qownnotes/scripts/issues/3))
    - for an example please take a look at
      [info.json](https://github.com/qownnotes/scripts/blob/master/example-script/info.json)
    - this information will be viewed in the *Script repository* dialog
    - if the platform you are running QOwnNotes on is not supported by the script
      the item will be colored grey in the script list of the *Script repository*
- added more Spanish and Brazilian Portuguese translation (thank you
  richarson and mlimacarlos)

## 17.06.1
- the Evernote import now supports importing file attachments with the 
  correct placement in the note (for [Issue #552](https://github.com/pbek/QOwnNotes/issues/552))
    - the placement of imported images was also improved
- added more Italian and German translation (thank you mlocati and bigant)

## 17.06.0
- you can now cycle through text cases of the selected text instead of just 
  toggling uppercase and lowercase with the shortcut <kbd>Ctrl</kbd> +
  <kbd>⇧</kbd> + <kbd>U</kbd> (for [Issue #396](https://github.com/pbek/QOwnNotes/issues/396))
    - you now can also use *proper case* and *sentence case*
    - this was superbly done by @quailiff, a big thank you
- more styling for links and `<kbd>` tags in various labels and text-browsers 
  was now done to fix problems with operating systems that don't set default
  colors fitting to be used in dark mode
  (for [Issue #597](https://github.com/pbek/QOwnNotes/issues/597))
- added more Italian, Brazilian Portuguese and French translation (thank you
  mlocati, mlimacarlos and lepascalou)
    
## 17.05.14
- when moving or copying notes to an other note subfolder tagging information
  will now be restored (for [Issue #595](https://github.com/pbek/QOwnNotes/issues/595))
- you can now use the shortcut <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>E</kbd> to 
  insert a file attachment into the current note
  (for [Issue #419](https://github.com/pbek/QOwnNotes/issues/419))
    - the file will be copied to an `attachments` folder in the current note 
      folder (note subfolders don't have their own `attachments` folder) and 
      a text link will be created in the note
    - the new `attachments` folder will be ignored in the note subfolder tree
    - you can also drag and drop files into the note, they will be inserted as
      attachment if they are not an image or a note file
    - a space character will be added in front of the attachment link if 
      there was no space or new line in front of the current cursor position
- the Evernote import now optionally supports importing file attachments
  (for [Issue #552](https://github.com/pbek/QOwnNotes/issues/552))
    - attachments in enex files that don't contain correct information about 
      where they are placed inside the text are imported at the end of the text

## 17.05.13
- the Evernote import now supports tagging
  (for [Issue #592](https://github.com/pbek/QOwnNotes/issues/592))
- added more Italian, Brazilian Portuguese and Spanish translation (thank you
  mlocati, mlimacarlos and richarson)

## 17.05.12
- a lot of work was done by @derboblan for the note list, tag tree and note
  subfolder panel, a big thank you for that
  (for [Issue #369](https://github.com/pbek/QOwnNotes/issues/369))
	- there now is a new page *Panels* in the *Settings dialog*
	- you can configure the sort order of the note list, tag tree and note
	  subfolder panel
	- sorting tags by last use is now possible
	- counting used tags in sub folders was also fixed
	- there are options to hide the search bar for tags and note subfolders
	- for note subfolders there are options to show the root folder name, to
	  display the note subfolders as tree with a root element and to show the
	  full path in the tree

## 17.05.11
- the full integer range of values can now be selected in the number selector
  in script variables in the *Scripting settings*
  (for [Issue #536](https://github.com/pbek/QOwnNotes/issues/536))
- fixes in the `QOwnNotes.desktop` file were made by @chronitis (thanks a lot)
- added more Hungarian translation (thank you vaganyik)

## 17.05.10
- fixed duplication of script settings variables in the in the *Scripting
  settings* (for [Issue #536](https://github.com/pbek/QOwnNotes/issues/536))
- moved the qml path settings above the script variable settings in the
  *Scripting settings*
- added more Italian, Brazilian Portuguese and Dutch translation (thank you
  mlocati, mlimacarlos and dmattijssen)

## 17.05.9
- added information about enabled scripts to the *Debug settings*
- now information about the currently installed version of the script will be 
  shown in the *Script repository* if the script is already installed
- you can now also reinstall or update your scripts in the *Script repository*
- the user interface of the *Scripting settings* was adapted to make the 
  entering of script settings more clear
- fixed a problem with automatically setting the name of a local script in 
  the *Scripting settings*
- added more German, Brazilian Portuguese and Spanish translation (thank you
  bigant, mlimacarlos and richarson)

## 17.05.8
- instead of importing `com.qownnotes.noteapi` and `com.qownnotes.tagapi` in 
  your scripts you now only need to import `QOwnNotesTypes`
- there now are new scripting functions `fromNativeDirSeparators`,
  `toNativeDirSeparators` and `dirSeparator` to work with native file paths
    - for more information please take a look at the
      [scripting documentation](http://docs.qownnotes.org/en/develop/scripting/README.html)
- you can now use the property list `resources` in your `info.json` in the
  *Script repository* to specify further files that are present in your script's
  directory and that should be downloaded to be used by your script
    - you can use this for example for other scripts you want to run or for 
      icons in custom actions
    - for example code please take a look at
      [selected-markdown-to-bbcode](https://github.com/qownnotes/scripts/tree/master/selected-markdown-to-bbcode)
- if you register a `property string scriptDirPath;` in your script the 
  property will be filled with the path to the directory where your script is 
  located
    - you can use this for example to access other files that are located in 
      your script's directory
- added more Italian and French translation (thank you mlocati and lepascalou)

## 17.05.7
- tried to fix a design glitch with the `Add script` button menu in the 
  script settings on non-highdpi displays
- you can now **register settings variables** in **scripts**
    - this allows you to let the user configure your script in the script 
      settings
    - currently there are settings types for `string`, `text`, `integer` and 
      `file`
    - take a look at the example at
      [variables.qml](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/variables.qml)
      to understand how this all will work
    - a lot of new useful scripts were added to the script repository, which 
      now can be configured with the script settings variables
- scripts in the script repository can now use the `minAppVersion` property 
  to state what the minimum version of QOwnNotes has to be for the script to run
    - for an example please take a look at
      [info.json](https://github.com/qownnotes/scripts/blob/master/example-script/info.json)
- there now are two new menu entries in the main menu to open the script 
  settings and to search for scripts in the script repository
- you can now print your note preview or export it as pdf even if the preview
  is turned off (for [Issue #587](https://github.com/pbek/QOwnNotes/issues/587))
- added more Italian and Spanish translation (thank you mlocati and richarson)

## 17.05.6
- the `Add script` button in the *Scripting settings* is now a button group
  where you can add local scripts and scripts from the *Script repository*
- if the script in the *Scripting settings* was from the *Script repository*
  additional information from the repository will be shown
- the *example script* will now be ignored in the *Script repository*
- the authors of the scripts in the script repository are now shown in the
  *Script repository dialog* and the *Scripting settings* (if the information
  was available at the time of script installation)
- added more Italian and Brazilian Portuguese translation (thank you mlocati and
  mlimacarlos)

## 17.05.5
- you can now access the new [script repository](https://github.com/qownnotes/scripts)
  from a new button *Search script repository* in the *scripting settings*
    - in the new *Script repository* dialog you can search for scripts from 
      the repository and install them
    - more features and scripts will be added in the coming releases
- added more Chinese, Dutch and Hungarian translation (thank you chonghua and
  Fabijenna)

## 17.05.4
- scripting function `registerCustomAction` now got a new parameter to hide 
  the button of the custom action in the toolbar
    - for more information please take a look at the 
      [registerCustomAction documentation](http://docs.qownnotes.org/en/develop/scripting/README.html#registering-a-custom-action)
- fixed a problem with tag cases for cyrillic tags
  (for [Issue #579](https://github.com/pbek/QOwnNotes/issues/579))
- fixed a warning when tagging a note with the same tag twice
- added more Czech and French translation (thank you jkalousek and lepascalou)

## 17.05.3
- removed a gray area under the note edit widget (glitch from version 17.05.2)
- you can now reduced the height of the scripting widget and the log widget 
  down to 10 pixel
- you can now reduced the height of the note tag widget until the buttons are
  reached
- added more Italian, Brazilian Portuguese, Polish, Spanish and German
  translation (thank you mlocati, mlimacarlos, lucjan and richarson)

## 17.05.2
- the shortcut of custom actions will now be remembered after the app is 
  restarted (for [Issue #576](https://github.com/pbek/QOwnNotes/issues/576))
- there now is a new scripting command to show an open file dialog
  `script.getOpenFileName()` (for [Issue #536](https://github.com/pbek/QOwnNotes/issues/536))
    - for more information please take a look at
      [Showing an open file dialog](http://docs.qownnotes.org/en/develop/scripting/README.html#showing-an-open-file-dialog)
- there now are new scripting commands to register labels with
  `script.registerLabel("my-label")` and write to them with
  `script.setLabelText("my-label", "my custom text")`
  (for [Issue #536](https://github.com/pbek/QOwnNotes/issues/536))
    - the labels will be visible in the new scripting dock widget
    - you can use both plain text or html in the labels
    - the text will be selectable and links can be clicked
    - for more information please take a look at
      [Registering a label](http://docs.qownnotes.org/en/develop/scripting/README.html#registering-a-label)
      and [Setting the text of a registered label](http://docs.qownnotes.org/en/develop/scripting/README.html#setting-the-text-of-a-registered-label)

## 17.05.1
- the restoring of the expanded state of the items in the tag tree widget now
  works across multiple note folders
- QOwnNotes now also remembers when you select *All notes* in the note 
  subfolder tree widget when you restart the app
  (for [Issue #572](https://github.com/pbek/QOwnNotes/issues/572))
- there now is a new scripting command to show an information message box
  `script.informationMessageBox()` (for [Issue #536](https://github.com/pbek/QOwnNotes/issues/536))
    - for more information please take a look at
      [Showing an information message box](http://docs.qownnotes.org/en/develop/scripting/README.html#showing-an-information-message-box)
- added more Italian, French, Polish and Spanish translation (thank you mlocati,
  lepascalou, lucjan and richarson)

## 17.05.0
- the expanded state of the items in the tag tree widget is now restored 
  when the tree is reloaded
- if the version of your QOwnNotesAPI app on your ownCloud / Nextcloud server
  is too low a warning will now be shown when the app starts
  (for [Issue #564](https://github.com/pbek/QOwnNotes/issues/564))
- added more Italian, Brazilian Portuguese, Polish, German and Spanish
  translation (thank you mlocati, mlimacarlos, lucjan, bigant and richarson)

## 17.04.4
- a user agent and content type header was added to requests to your ownCloud / 
  Nextcloud server to prevent troubles with some server hosting providers
  (for [Issue #541](https://github.com/pbek/QOwnNotes/issues/541))
- added more information text to the git settings
- added more Italian, Brazilian Portuguese, Polish, Portuguese, French and
  Spanish translation (thank you mlocati, mlimacarlos, lucjan, manuelarodsilva,
  lepascalou and richarson)

## 17.04.3
- the preview will now be updated correctly if it was previously disabled
  (for [Issue #559](https://github.com/pbek/QOwnNotes/issues/559))
    - when selecting another workspace or switching to the previous workspace
    - when `Show all panels` is clicked in the `Windows` menu
    - when a panel is selected in the `Windows / Panels` menu
- you can now enter a custom command to show the git log of a note in the
  `Git versioning` settings
    - you can optionally use `%notePath%` to enter the note path if you are 
      using more complex parameters
        - for example: `gitk %notePath%`
    - you'll find a new menu item in the `Edit` menu and the note list 
      context menu to show the note versions if you entered a git log command
- added more Italian, Brazilian Portuguese, Polish and Spanish translation 
  (thank you mlocati, mlimacarlos, lucjan and richarson)

## 17.04.2
- more git versioning implementation
    - added Windows support
    - you can now select the path of your git executable in the new
      `Git versioning` settings
    - you can set the git commit interval time, default is 30 sec 
    - changes are now also committed when changing the note folder (for both 
      the old and new note folder) or quitting the application
- added more Brazilian Portuguese translation (thank you mlimacarlos)

## 17.04.1
- more git versioning implementation
    - fixed committing if note path was not initialized by git yet
    - added macOS support 
- added more Spanish translation (thank you richarson)
 
## 17.04.0
- the note preview will now only be updated if the note text has changed
  to improve performance (especially when viewing large notes) and prevent
  a flickering of the scrollbars when no editing is done
- fixed an url highlighting problem
  (for [Issue #556](https://github.com/pbek/QOwnNotes/issues/556))
- added more Italian, German, Polish, French translation (thank you mlocati,
  xpertmind, lucjan and lepascalou)

## 17.03.9
- added experimental git support to keep a local history of files in a note
  folder under Linux
    - you can enable this feature in the note folder settings
    - all changes in your active note folder will be committed to git every 30 sec
- added more Italian, Croatian, German, Polish, Spanish and Brazilian Portuguese
  translation (thank you mlocati, xpertmind, lucjan, richarson and mlimacarlos)

## 17.03.8
- added **Portuguese translation** (`pt_PT`) by manuelarodsilva, thank you very much!
    - the current Portuguese translation (`pt_BR`) got renamed to `Português do Brasil`
    - the current setting will be migrated to `Português do Brasil` when you start the app
- added **Croatian translation** by xpertmind, thank you very much!
- added more Italian, German, Polish and Spanish translation (thank you mlocati,
  xpertmind, lucjan and richarson)

## 17.03.7
- fixed loading of trashed notes in the trash dialog
- improved error messages for the version and trash dialog
- added more Italian, French and Spanish translation (thank you mlocati,
  lepascalou and richarson)

## 17.03.6
- when configuring a new note folder path in the settings the server-path 
  will now be suggested
  (for [QOwnNotesAPI Issue #11](https://github.com/pbek/qownnotesapi/issues/11))
    - the placeholder text was updated to be more informative
- broken links between notes and tags are now automatically removed when the 
  tag tree is reloaded (for [Issue #548](https://github.com/pbek/QOwnNotes/issues/548))
- added more German, Italian, Polish and Portuguese translation (thank you
  mlocati, lucjan and mlimacarlos)

## 17.03.5
- fixed more url highlighting and clicking issues
- you can now copy the file path of an image in the preview by right-clicking
  on it and selecting `Copy image file path` from the context menu
- added more German translation

## 17.03.4
- fixed highlighting and opening of links with `/` at the end

## 17.03.3
- after starting QOwnNotes now the last note along with the previous cursor 
  and scrollbar position will be restored
  (for [Issue #537](https://github.com/pbek/QOwnNotes/issues/537))
    - if that fails the first note in the note list will be opened

## 17.03.2
- fixed a scrollbar position warning
- when pressing <kbd>Tab</kbd> in the note list to switch to the note text 
  edit the previous position will now also be restored
- the generated preview html will now be cached to increase performance when 
  editing large notes (for [Issue #537](https://github.com/pbek/QOwnNotes/issues/537))
- the preview html will now only be generated if the preview panel is visible
  to increase performance when editing large notes

## 17.03.1
- the current note in the scripting function `script.currentNote()` will now 
  be update correctly when when text is written to it by the user 
  (for [Issue #536](https://github.com/pbek/QOwnNotes/issues/536))
- the owncloud / Nextcloud application QOwnNotesAPI was updated to version 17.3.0
    - fixed the time-output of the trashed notes api
    - fixed some PHP warnings in the log
- when restoring the position in a note not only the cursor position will now
  be restored, but also the scroll bar position to make the position 
  restoration feel more natural
    - this is now implemented in the following scenarios
        - switching between note folders
        - selecting a previous selected note (if enabled in the settings)
        - moving forward or back in the note history
        - jumping to note bookmarks

## 17.03.0
- you can now assign different tag colors in dark mode
    - this is handy because the colors you may have defined on an other, synced
      computer, that did not use dark mode may not look good on this computer
      in dark mode
    - with this update the currently set non-dark mode colors will be used as
      dark mode colors 
- added more Dutch, Hungarian and Spanish translation (thank you Fabijenna and
  richarson)

## 17.02.6
- the maximum tag nesting level of the html preview was increased from 16 to 32
  to allow more levels of list items than six
  (for [Issue #473](https://github.com/pbek/QOwnNotes/issues/473))
- added more French, Italian, Polish and Portuguese translation (thank you
  lepascalou, mlocati, lucjan and mlimacarlos)

## 17.02.5
- you can now show a custom action in the note text edit context menu
    - for more information please take a look at the
      [custom action documentation](http://docs.qownnotes.org/en/develop/scripting/README.html#registering-a-custom-action)
- the last directory path will now be selected if you select a script file in 
  the *Scripting settings* or select an external editor in the *General settings*
- the script name will now be set from the file name if no script name was set
  yet in the *Scripting settings*
- added more German translation

## 17.02.4
- you can now copy text to the clipboard in a script with the new scripting
  method `script.setClipboardText()`
    - there is an example at
      [selected-markdown-to-bbcode.qml](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/selected-markdown-to-bbcode.qml)
    - for more information please take a look at the
      [scripting documentation](http://docs.qownnotes.org/en/develop/scripting/README.html#copying-text-into-the-clipboard)
- the unicode line endings from the result of the scripting method
  `script.noteTextEditSelectedText()` will now be converted to `\n` 
- you can now jump to a note with the new scripting method `script.setCurrentNote()`
  if it is visible in the note list (for [Issue #510](https://github.com/pbek/QOwnNotes/issues/510))
    - there is an example at
      [journal-entry.qml](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/journal-entry.qml)
    - for more information please take a look at the
      [scripting documentation](http://docs.qownnotes.org/en/develop/scripting/README.html#jumping-to-a-note)

## 17.02.3
- the bracket closing feature now also just moves the cursor to the right if a
  closing bracket is typed at the position of a closing bracket if there is a
  matching opening bracket (for [Issue #514](https://github.com/pbek/QOwnNotes/issues/514))
    - this works for `)`, `]` and `}` 
- you can now fetch a note by its file name in a script with the new scripting
  method `script.fetchNoteByFileName(fileName)`
  (for [Issue #510](https://github.com/pbek/QOwnNotes/issues/510))
    - for more information please take a look at the
      [scripting documentation](http://docs.qownnotes.org/en/develop/scripting/README.html#fetching-a-note-by-its-file-name)
- you can now check if a note exists by its file name in a script with the 
  new scripting method `script.noteExistsByFileName(fileName)`
  (for [Issue #510](https://github.com/pbek/QOwnNotes/issues/510))
    - for more information please take a look at the
      [scripting documentation](http://docs.qownnotes.org/en/develop/scripting/README.html#checking-if-a-note-exists-by-its-file-name)

## 17.02.2
- the restoring of the cursor position in notes is now disabled by default 
  for macOS because of troubles it causes for some users
  (for [Issue #500](https://github.com/pbek/QOwnNotes/issues/500))
- if the shortcuts for deleting the current line or word isn't used in the 
  note text edit now the default shortcuts will be delegated to the widget 
  with the focus (for [Issue #476](https://github.com/pbek/QOwnNotes/issues/476))
- added more Russian and Portuguese translation (thank you Maboroshy and mlimacarlos)

## 17.02.1
- QOwnNotes for macOS is finally deployed with Qt 5.8, solving some pesky Qt bugs
  (for [Issue #503](https://github.com/pbek/QOwnNotes/issues/503))
- fixed the preview of images if there are more than one in the same line
  (for [Issue #509](https://github.com/pbek/QOwnNotes/issues/509))
- added more Spanish, Hungarian, Italian, Russian, Polish and Portuguese
  translation (thank you richarson, rommel4444, mlocati, azar9610, lucjan and 
  mlimacarlos)

## 17.02.0
- you now can sort or notes also alphabetically descending
  (for [Issue #504](https://github.com/pbek/QOwnNotes/issues/504))
- disabled the `Copy` button in the Note editor font schema settings 
  under macOS because of a Qt bug for Qt versions lower than 5.8
  (for [Issue #503](https://github.com/pbek/QOwnNotes/issues/503))
- added more Spanish, Dutch, Italian, German and French translation (thank
  you richarson, Leime, mlocati, bigant and lepascalou)

## 17.01.14
- you can now turn off the ownCloud / Nextcloud support in the settings to 
  prevent some checks
    - the check whether todo lists will used was also improved
- fixed a problem with showing a copied Editor color schema under macOS
  (for [Issue #503](https://github.com/pbek/QOwnNotes/issues/503))
- added more Portuguese, Dutch, Italian, Czech and Polish translation (thank
  you mlimacarlos, Leime, mlocati, jkalousek and lucjan)

## 17.01.13
- the directory of the previously selected file will now be remembered for a
  lot of file dialogs (for [Issue #502](https://github.com/pbek/QOwnNotes/issues/502))
    - the last directory of each dialog will be remembered separately
    - if no directory was set the last directory path of any dialog will be used
    - if there still is no readable path the home directory will be chosen
- fixed the image link that is inserted when using the *Insert image* menu entry
  (for [Issue #501](https://github.com/pbek/QOwnNotes/issues/501))
- fixed the base64 encoded images in the note HTML export for images with 
  spaces in the path
- added more Portuguese, Ukrainian, Chinese, Czech and Polish translation (thank
  you mlimacarlos, Borisvit, chonghua, jkalousek and lucjan)

## 17.01.12
- there now is a new script function `script.downloadUrlToMedia("http://image.url");`
  to allow you to download an url to the media folder and return the media url
  or the markdown image text (for [Issue #499](https://github.com/pbek/QOwnNotes/issues/499))
    - there is an example at
      [paste-latex-image.qml](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/paste-latex-image.qml)
    - for more information please take a look at the
      [scripting documentation](http://docs.qownnotes.org/en/develop/scripting/README.html#downloading-an-url-to-the-media-folder)
- added more fixes for a warning that might trigger when notes are moved to an
  other note subfolder in macOS
  (for [Issue #498](https://github.com/pbek/QOwnNotes/issues/498))
- added more Hungarian, Ukrainian, Spanish and Italian translation (thank you
  Fabijenna, Borisvit, richarson and mlocati)

## 17.01.11
- added Czech translation (a big thank you to jkalousek!)
- fixed a warning that might trigger when notes are moved to an other note subfolder
  (for [Issue #498](https://github.com/pbek/QOwnNotes/issues/498))
- you now can disable the restoring of the cursor position in the *General settings*
  (for [Issue #500](https://github.com/pbek/QOwnNotes/issues/500))
- added more French and Chinese translation (thank you lepascalou and chonghua)
 
## 17.01.10
- fixed a crash that can happen with long notes with malformed urls
  (for [Issue #494](https://github.com/pbek/QOwnNotes/issues/494))
- you can now save modified notes also manually with the shortcut <kbd>Ctrl</kbd> +
  <kbd>S</kbd> (for [Issue #484](https://github.com/pbek/QOwnNotes/issues/484))
- fixed a problem with <kbd>Ctrl</kbd> - clicking urls with a `)` in it
- when opening notes the cursor position inside the note will now be restored
  to the position when the note was last visited in the current session
- added more Dutch, Portuguese and Italian translation (thank you Leime,
  mlimacarlos and mlocati)

## 17.01.9
- when exporting a note as html the images are now base64 encoded and included
  inside the html (for [Issue #491](https://github.com/pbek/QOwnNotes/issues/491))
- added more Dutch, French, Italian and Polish translation (thank you Leime,
  lepascalou, mlocati and lucjan)

## 17.01.8
- improved log and status messages when a note could not be saved for example
  when the file system doesn't allow certain characters in the filename
  (for [Issue #486](https://github.com/pbek/QOwnNotes/issues/486))
- you can now set that notes are stored with UNIX newline characters instead 
  of the native newline characters in the *General settings*
  (for [Issue #487](https://github.com/pbek/QOwnNotes/issues/487))
    - you can use this for example under Windows if you have troubles with 
      newlines in the ownCloud / Nextcloud notes app
- added more Russian and Chinese translation (thank you azar9610 and chonghua)

## 17.01.7
- fixed a problem with duplicate custom note file extensions in the general 
  settings (for [Issue #483](https://github.com/pbek/QOwnNotes/issues/483))
    - now the same file extension also can't be added twice
- under Windows some more characters that are asking for troubles are now 
  removed from the title at the Evernote import
  (for [Issue #465](https://github.com/pbek/QOwnNotes/issues/465))
- added more German, Polish, Spanish and Chinese translation (thank you bigant,
  lucjan, richarson and chonghua)

## 17.01.6
- you can now use the panel toggle menu items in your toolbars
  (for [Issue #481](https://github.com/pbek/QOwnNotes/issues/481))
- under Windows some characters that are asking for troubles are now removed 
  from the title at the Evernote import
  (for [Issue #465](https://github.com/pbek/QOwnNotes/issues/465))
- added more Dutch, Chinese, Portuguese, Italian and German translation (thank
  you lenkadubois, chonghua, mlimacarlos and mlocati)

## 17.01.5
- fixed a problem with opening notes with special characters in its file name in
  an external editor if no editor was defined in the settings
- you can now use the shortcut <kbd>Alt</kbd> + <kbd>⇧</kbd> + <kbd>O</kbd> 
  to open the current note in a readonly view
    - you can use that view to leave a note open to look at while writing on 
      an other note
    - markdown highlighting will be used in that view and you also can search
      for text in it
- added more Dutch, Chinese and German translation (thank you Leime, chonghua
  and bigant)

## 17.01.4
- fixed two database errors when using QOwnNotes for the first time
  (for [Issue #467](https://github.com/pbek/QOwnNotes/issues/467))
- fixed a highlighting issue when using a grave accent character in `<>` links
- fixed an issue with the note search getting stuck when searching for `^ ` or
  `  ` (just spaces) (for [Issue #469](https://github.com/pbek/QOwnNotes/issues/469))
- fixed a crash under Windows when entering an opening `<` with a lot of text
  after it, but no closing `>`
  (for [Issue #461](https://github.com/pbek/QOwnNotes/issues/461) and
  [Issue #471](https://github.com/pbek/QOwnNotes/issues/471))
- added more Italian, Polish, Russian, Dutch, Spanish, Chinese and French
  translation (thank you mlocati, lucjan, frostyland, Leime, richarson, chonghua
  and lepascalou)

## 17.01.3
- after installing QOwnNotes now only a minimal set of panels will be shown 
  to reduce complexity in the beginning
    - a second workspace with a full set of panels can be chosen in the 
      workspace selector
    - if a tag will be added to a note by the user the panel to add tags to a 
      note will be shown automatically and on the first time also the tag list
      panel will enabled  
- image links like `[![name](image)](link)` and `[![](image)](link)` will now
  also be highlighted (for [Issue #463](https://github.com/pbek/QOwnNotes/issues/463))
- added more Dutch, Hungarian, Italian, Spanish and Portuguese translation 
  (thank you Leime, Fabijenna, mlocati, richarson and mlimacarlos)

## 17.01.2
- years were bumped to 2017
- since the support for legacy **CalDAV** URLs in **Nextcloud 11** is still 
  broken support for the new URLs was added and will now used by default (if the 
  application is re-installed)
    - the legacy URLs will be supported as well
    - switch to the new setting in the *Todo setting* if you have troubles 
      with Nextcloud 11
    - ownCloud 9 seems to support the new CalDAV URLs as well 
- added more Portuguese, Polish and Polish translation (thank you mlimacarlos, 
  mlocati and lucjan)

## 17.01.1
- you can now enter a custom time format when inserting the current time into
  a note in the *Editor settings*
    - take a look at the [time format documentation](http://docs.qownnotes.org/en/develop/time-formats.html)
      for more information about the available time formats
- the menu entry for showing the note sub-folder panel is now invisible if 
  note sub-folders are not enabled for the current note folder

## 17.01.0
- notes in the note list are now resorted if they were sorted alphabetically 
  and a note was manually renamed in the note list
  (for [Issue #450](https://github.com/pbek/QOwnNotes/issues/450), thank you @dwu)
- improved on setting the note text edit to be readonly if the last note from a 
  note folder or note sub-folder was removed or moved somewhere else or when
  there is no visible note to view
  (for [Issue #446](https://github.com/pbek/QOwnNotes/issues/446))
- the *Delete word* functionality now matches that of other editors more closely
  (for [Issue #453](https://github.com/pbek/QOwnNotes/issues/453), thank you @dwu)
- implemented the ability to set shortcuts for panels
  (for [Issue #452](https://github.com/pbek/QOwnNotes/issues/452))
- added more Spanish and Polish translation (thank you richarson and lucjan)

## 16.12.16
- when the current note is moved to a different note sub-folder the current note
  will now be unset, like when it is moved to a different note folder
  (for [Issue #446](https://github.com/pbek/QOwnNotes/issues/446))
- added more French, Dutch, Hungarian and Italian translation (thank you
  lepascalou, Fabijenna and mlocati)

## 16.12.15
- fixed a highlighting problem with italic tags at the start of an ordered 
  list, that starts with a `*`, like `* *italic*`
  (for [Issue #431](https://github.com/pbek/QOwnNotes/issues/431))
- you will now get a dialog to restart the application if you have modified a 
  setting in the settings dialog that requests a restart
- added the application arguments to the output in the debug settings
- added more Dutch, Hungarian, Italian, Spanish and Polish translation 
  (thank you Fabijenna, mlocati, richarson and lucjan)

## 16.12.14
- fixed a highlighting problem with normal text between bold formatted markdown 
  texts (for [Issue #431](https://github.com/pbek/QOwnNotes/issues/431))
- now a `¶` character, followed by a new line is used instead of a `\n` to
  signal a line break in the diffs of the note versions dialog
  (for [Issue #435](https://github.com/pbek/QOwnNotes/issues/435))
- you can now delete the current line in the note text edit with <kbd>Alt</kbd> +
  <kbd>Backspace</kbd> (or <kbd>⌘</kbd> + <kbd>Backspace</kbd> under macOS)
  (for [Issue #434](https://github.com/pbek/QOwnNotes/issues/434) and
  [Issue #432](https://github.com/pbek/QOwnNotes/issues/432))
- you can now delete the current word in the note text edit with <kbd>Ctrl</kbd> +
  <kbd>Backspace</kbd> (or <kbd>Alt</kbd> + <kbd>Backspace</kbd> under macOS)
  (for [Issue #432](https://github.com/pbek/QOwnNotes/issues/432))

## 16.12.13
- note links like `<my note.md>` will now only be translated to real note 
  links in the preview if the linked note was found in the current note folder
  (for [Issue #433](https://github.com/pbek/QOwnNotes/issues/433))
- bold markdown tags will now also be closed at the beginning of a line after
  the 2nd `*` was entered (because after the first `*` it could still be a list)
  (for [Issue #428](https://github.com/pbek/QOwnNotes/issues/428))
- added more Spanish translation (thank you richarson)
 
## 16.12.12
- the foreground and background color of the note text edit will now be taken
  from the *Text preset* highlighting item, so you can use dark highlighting 
  schemas even if you are not in dark mode
  (for [Issue #429](https://github.com/pbek/QOwnNotes/issues/429))
    - it's now also possible to override these colors in a script if you 
      specify the css selector, for example with
      `script.addStyleSheet("QTextEdit#noteTextEdit {background-color: red;}");`
- the automatic bracket-closing of the `*` character now also works if used in
  markdown lists that start with a `* ` and when used in normal text at the 
  start of the line after the 2nd `*`
  (for [Issue #428](https://github.com/pbek/QOwnNotes/issues/428))
- added more Dutch, Hungarian, Italian and Polish translation (thank you
  Fabijenna, Leime, mlocati and lucjan)

## 16.12.11
- added a link to the **new documentation** at
  [docs.qownnotes.org](http://docs.qownnotes.org) to the scripting settings
- the problem with accessing your todo lists on **Nextcloud 11** will be 
  fixed in Nextcloud 11.0.1
  (see [Nextcloud Issue #2552](https://github.com/nextcloud/server/issues/2552))
- added a warning that the ownCloud notes app doesn't support sub-folders in 
  the note folder settings
- there now is a repository for **Fedora 25**
    - please visit the [QOwnNotes installation page](http://www.qownnotes.org/installation#Fedora)
      for instructions
- added more markdown highlighting support
    - **multiple block quote characters** like `> > deeper level`
    - support for **headlines without space** after the `#` like `##no space`,
      because Beebom was (mis-)using headlines that way in his YouTube video
      [10 Must Have Linux Apps You Should Use](https://youtu.be/oSSyLNb8jA8?t=2m19s) ;)
- you can now also **clear the calendar cache** and **reload the tasks** from 
  your server in the *Todo dialog*
- you now can see the **current line number**, the position in the line and the 
  amount of selected characters in the status bar
- added more Dutch, Hungarian, Italian, Spanish and Polish translation 
  (thank you Fabijenna, mlocati, richarson and lucjan)

## 16.12.10
- when linking notes now the title of the note will be used as link-text
- decreased the saturation of some background colors of the `Light` color 
  schema to increase readability
- tried to fix a problem with wrong reminder times of tasks in the todo list
- fixed a problem with duplicate shortcut items in the shortcut settings 
  after opening the settings dialog multiple times
  (for [Issue #424](https://github.com/pbek/QOwnNotes/issues/424))
- added more Dutch, Chinese and Japanese translation (thank you Leime,
  Fabijenna, chonghua and MoeMoePig)

## 16.12.9
- fixed a problem where duplicate actions would be shown in the *find action* 
  dialog
- added experimental support for **regular file links** like `<my-note.md>` or 
  `[my note](my-note.md)` in the note edit pane and the note preview
   (for [Issue #266](https://github.com/pbek/QOwnNotes/issues/266))
    - no paths are allowed
    - only note files are supported
    - when `Ctrl` - clicked the note will be opened
    - the file link is internally converted to a `note://my_note` url, file 
      extensions will be stripped
    - highlighting for such links was also added
    - in the preview these file links are replaced with note links, that also
      takes place when such a link was found in a code block
- added more Dutch, Hungarian, Spanish, Italian and Portuguese translation 
  (thank you Fabijenna, richarson, mlocati and mlimacarlos)

## 16.12.8
- added a new shortcut <kbd>Alt</kbd> + <kbd>⇧</kbd> + <kbd>W</kbd> to 
  **search** for the **selected text** on the **web**
- urls with empty title like `[](file://link)` are now also highlighted
  (for [Issue #415](https://github.com/pbek/QOwnNotes/issues/415))
- added more Dutch, Hungarian, Japanese, Italian, German and Polish translation 
  (thank you Fabijenna, piyo, mlocati, bigant and lucjan)

## 16.12.7
- headlines now have a small top and bottom margin in the note edit panel
- replaced the text `ownCloud` by `ownCloud / Nextcloud` in the settings 
  dialog to make it more clear that Nextcloud is also supported
- there is a new shortcut <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>B</kbd> that
  **inserts a block quote** character or formats the selected text as block quote
- added more Dutch, Hungarian, French, Portuguese and Ukrainian translation 
  (thank you Fabijenna, lepascalou, mlimacarlos and Borisvit)

## 16.12.6
- a lot of **markdown syntax** is now **masked in gray** in the markdown 
  highlighting
    - there is a new highlighting state `Masked syntax` in the Editor fonts &
      color settings to choose a styling for masked markdown syntax
- the font size of the headlines were increased in the `Light` and `Dark` color 
  schemas
- QOwnNotesAPI 16.12.0 was released in the Nextcloud store to fix signature
  checks (for [Issue #414](https://github.com/pbek/QOwnNotes/issues/414))
- added more Spanish, Portuguese and Russian translation (thank you richarson,
  mlimacarlos and frostyland)

## 16.12.5
- updated the OpenSSL DLLs to 1.0.2j to prevent problems on some Windows
 installations (for [Issue #413](https://github.com/pbek/QOwnNotes/issues/413))
- added more Dutch, Hungarian, Italian, Polish, Arabic and Ukrainian translation 
  (thank you Fabijenna, mlocati, lucjan, yousufinternet and Borisvit)

## 16.12.4
- all three settings about external modifications of the current note in the 
  general settings are now mutual exclusive
  (for [Issue #405](https://github.com/pbek/QOwnNotes/issues/405))
- the `version 0` problem at fresh installations of QOwnNotesAPI from the store 
  was now fixed in Nextcloud 11
  (for [Issue #262](https://github.com/pbek/QOwnNotes/issues/262))
- **scripts** now also work with a path relative to the data directory in 
  **portable mode** (for [Issue #412](https://github.com/pbek/QOwnNotes/issues/412))
- if you select a new script path for a script in the script settings the 
  directory of your current script will be selected
    - in portable mode the data directory will be selected if no script path 
      was set yet
- the **path to an external editor** will now also be stored relative to the 
  data directory in **portable mode**
    - if you select a path and no path was set yet the data directory will
      now be selected
- added more Dutch and Hungarian translation (thank you Fabijenna)

## 16.12.3
- fixed a problem with saving tasks in Nextcloud 11.0 RC 1
  (for [Issue #406](https://github.com/pbek/QOwnNotes/issues/406))
- fixed two warnings about no matching signals when opening the todo dialog
- trying to enable the network access again when the network has gone away to
  fix occasional problems where the app remained without network
- you can now choose `Always accept external changes in the future` when your
  current note got modified externally and the diff dialog pops up
  (for [Issue #405](https://github.com/pbek/QOwnNotes/issues/405))
    - you can reset that checkbox in the general settings

## 16.12.2
- fixed a problem with line feeds under Windows where notes will move up to 
  the top in the note list even when not actively edited
  (for [Issue #408](https://github.com/pbek/QOwnNotes/issues/408))
- took some more safety measures to prevent crashes when the application is 
  quitting while log output was still sent to the the log panel
  (for [Issue #406](https://github.com/pbek/QOwnNotes/issues/406))

## 16.12.1
- markdown reference links with text as reference id are now also highlighted
  and can now also be opened with <kbd>Ctrl</kbd> + `Click`
- fixed a problem with exporting font color schemas to a file that already 
  exists (for [Issue #407](https://github.com/pbek/QOwnNotes/issues/407))
- added the new dark font color schema *AnalyticalYellow* (thank you, @Omnicraft)
  (for [Issue #407](https://github.com/pbek/QOwnNotes/issues/407))
- fixed a crash that could occur when closing the settings dialog immediately 
  after opening it, while the ownCloud connection test is still running 
  (for [Issue #406](https://github.com/pbek/QOwnNotes/issues/406))
- fixed problems with note sharing, note versions and the note trash with 
  Nextcloud 11.0 beta 2
  (for [Issue #406](https://github.com/pbek/QOwnNotes/issues/406))
- added more Dutch, Hungarian, Russian, Spanish and Ukrainian translation 
  (thank you Fabijenna, frostyland, richarson and Borisvit)

## 16.12.0
- you can now **import csv files** with the `Insert table` dialog
  (for [Issue #78](https://github.com/pbek/QOwnNotes/issues/78))
    - you'll get a preview of the content of your csv file
    - you can choose the separator, text-delimiter and whether the
      first line is the table heading
- more highlighting fixes
  (for [Issue #78](https://github.com/pbek/QOwnNotes/issues/78))
    - fixed an issue with other highlighting inside an inline code block
    - table highlighting support for tables, that don't start with a `|`
      was dropped, that's far to messy to deal with
- fixed a problem where the shortcuts were not viewed in the settings
- made a special allowance for allowing entering two `*` characters in a row 
  and closing both of them when the first `*` was at the end of the line
  (for [Issue #386](https://github.com/pbek/QOwnNotes/issues/386))
- markdown reference urls can now also be opened with <kbd>Ctrl</kbd> + `Click`
- added more Japanese, Italian, Polish and Portuguese translation (thank
  you MoeMoePig, Manu-sh, lucjan and mlimacarlos)

## 16.11.18
- fixed highlighting issues with images and tables
  (for [Issue #78](https://github.com/pbek/QOwnNotes/issues/78))
- tried to fix a package dependency in openSUSE Tumbleweed
  (for [Issue #367](https://github.com/pbek/QOwnNotes/issues/367))
- there now is a new scripting command `script.reloadScriptingEngine()`
  to reload the scripting engine
- dramatically reduced the loading time of large notes
    - the navigation tree in the navigation panel was rebuilt too often
      with the new highlighter

## 16.11.17
- lots of memory leak fixes, memory related optimizations and speed
  improvements, mainly in conjunction with the dialogs and the
  ownCloud service
- added more German, Italian, Polish and Portuguese translation (thank
  you mlocati, lucjan and mlimacarlos)

## 16.11.16
- **markdown** syntax **highlighting improvements**
  (for [Issue #78](https://github.com/pbek/QOwnNotes/issues/78))
    - better multi-line html comment detection
    - image links like `![](file://)` work now
    - it's now possible to have links and italic/bold formatting in a headline
    - urls without any other markup are now highlighted too
        - they can now also be opened with <kbd>Ctrl</kbd> + `Click`
    - formatting bold and italic with `__bold__` and `_italic_` now also works
    - fixed a wrongly detected table in a link
- you can now **insert** a **markdown table** with the new shortcut
  <kbd>Alt</kbd> + <kbd>⇧</kbd> + <kbd>T</kbd>
  (for [Issue #78](https://github.com/pbek/QOwnNotes/issues/78))
    - a markdown table wizard will be opened to create an empty table
      to work with
- added more Spanish, French and Russian translation (thank you
  richarson, lepascalou and frostyland)

## 16.11.15
- a **new markdown parser and highlighter** was now implemented from
  scratch to allow a higher parsing speed and more flexibility in
  the future (for [Issue #78](https://github.com/pbek/QOwnNotes/issues/78))
    - text will now be instantly highlighted, there is no
      highlighting-interval setting any more
    - now you also can change the styling in the settings or
      enable/disable the highlighting without re-starting the application
    - please report issues with the new highlighter if you find any
- **markdown tables** are now supported by the new markdown highlighter
  (for [Issue #78](https://github.com/pbek/QOwnNotes/issues/78))
    - the mono-space code font is used for it
    - you can change the highlighting color and other styles in the settings
- there now is a **Solus package** for QOwnNotes in the Solus main repository
    - see [Solus package for QOwnNotes](http://www.qownnotes.org/Blog/Solus-package-for-QOwnNotes)
      for more information
- Nextcloud support is now mentioned a bit more often
- to save memory the log output will now only be written to the log
  panel if the panel is visible
- added more Italian, Dutch, Hungarian, Polish, Spanish, Portuguese,
  Ukrainian, German and Japanese translation (thank you mlocati,
  Fabijenna, lucjan, richarson, mlimacarlos, Borisvit, bigant and MoeMoePig)

## 16.11.14
- added **Ukrainian translation** (a big thank you to Borisvit!)
- reduced the margins in the todo dialog to save space on small displays
- added more Italian, Dutch, Hungarian, Polish, German, Portuguese and
  French translation (thank you Manu-sh, Fabijenna, lucjan, bigant,
  mlimacarlos and lepascalou)

## 16.11.13
- QOwnNotes is now also available for Ubuntu 17.04
    - see [Ubuntu installation](http://www.qownnotes.org/installation#Linux)
      for more information
- fixed a problem with inserting images if application language is Italian
  (for [Issue #391](https://github.com/pbek/QOwnNotes/issues/391))
    - potential file open dialog filter problems in other languages were
      also fixed in the process
- fixed searching of settings that are not at the root level of the
  settings page tree
- now a button menu is used in the todo dialog to improve it for small
  screen sizes
- the path to the settings file (or the key if the settings are stored
  in the Windows registry) and the path to the application database file
  are now shown in the debug settings
    - the database file path of the note folders is shown in the note
      folder list 
- added more Italian, Dutch, Hungarian, Polish, Spanish, Portuguese,
  French and Japanese translation (thank you Manu-sh, Fabijenna, lucjan,
  richarson, mlimacarlos, lepascalou and piyo)

## 16.11.12
- added a new scripting hook `noteOpenedHook(note)` that is called every
  time a note is opened
  (for [Issue #389](https://github.com/pbek/QOwnNotes/issues/389))
    - take a look at the
      [noteOpenedHook documentation](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/README.md#noteopenedhook)
      for more information
    - there is an example script at
      [on-note-opened.qml](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/on-note-opened.qml)
- added some documentation for all scripting hooks to the
  [scripting documentation](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/README.md)
- the closing of brackets and markdown formatting characters is now only
  allowed if the cursor was at the end of a block
  (for [Issue #386](https://github.com/pbek/QOwnNotes/issues/386))
- closing brackets and markdown formatting characters are now
  automatically removed if the opening character is removed with
  <kbd>Backspace</kbd>
  (for [Issue #386](https://github.com/pbek/QOwnNotes/issues/386))
   - opening characters can be `(`, `[`, `{`, `<`, `*` or `"`
   - you can disable this feature in the `Editor` settings
   - if text was selected closing characters will not be removed
- added more Italian, Polish and French translation (thank you Manu-sh,
  lucjan and lepascalou)

## 16.11.11
- the `Markdown highlighting` options moved to the new `Editor` settings
- more changes to closing of brackets and markdown formatting characters
  (for [Issue #386](https://github.com/pbek/QOwnNotes/issues/386))
    - you can now disable the feature in the `Editor` settings
    - added closing of `<` and removed closing of `'`
    - `*` will now only be closed if not used in lists
        - it will be checked if it is on the beginning of a block or if
          it has just whitespaces in front of it
- added more Italian, Dutch, Hungarian, Polish, Spanish, Portuguese,
  German and Japanese translation (thank you mlocati, Manu-sh,
  Fabijenna, lucjan, richarson, mlimacarlos, bigant and piyo)

## 16.11.10
- implemented automatic entering of **matching characters** like closing
  parenthesis (for [Issue #386](https://github.com/pbek/QOwnNotes/issues/386))
    - characters like `"`, `'`, `*`, `(`, `[` or `{` are automatically closed
    - `"`, `'` and `*` are only closed if there isn't already an opening
      character in the current text block
- there now is a new button `Import as note` in the todo dialog that
  **imports** the current **todo item as new note**
  (for [Issue #387](https://github.com/pbek/QOwnNotes/issues/387))
- improved the initial sizes of the panels on the first application start
- added more Chinese, Dutch, Portuguese, Russian, German and Japanese
  translation (thank you nkzk, Fabijenna, mlimacarlos, frostyland,
  guijan and piyo)

## 16.11.9
- fixed the shortcut display in the action dialog on macOS
  (and filed a Qt documentation bug 
  [QTWEBSITE-744](https://bugreports.qt.io/browse/QTWEBSITE-744))
- tried to improve the restoring of the workspace in full-screen and
  maximized mode
- added more Dutch and Italian translation (thank you Fabijenna and mlocati)

## 16.11.8
- you can now **search for actions from the menu** with `Find action`
  in the *Help* menu or by pressing <kbd>Ctrl</kbd> + <kbd>⇧</kbd> +
  <kbd>A</kbd>
- you can now set **custom stylesheets** to **change the look of QOwnNotes**
  with the help of the new scripting method `script.addStyleSheet()`
  (for [Issue #381](https://github.com/pbek/QOwnNotes/issues/381))
    - there is an example for adding custom stylesheets at
      [custom-stylesheet.qml](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/custom-stylesheet.qml)
    - take a look at the
      [scripting documentation](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/README.md#add-a-custom-stylesheet)
      for more information
    - you can get the object names from the `*.ui` files, for example
      [mainwindow.ui](https://github.com/pbek/QOwnNotes/blob/develop/src/mainwindow.ui)
    - take a look at [Style Sheet Reference](http://doc.qt.io/qt-5/stylesheet-reference.html)
      for a reference of what styles are available
- you can now also **log to a log file** by checking
 `Enable logging to file` in the *Debug options*
    - if you enable it the path to the log file will be viewed
    - all log messages will be appended to that file
    - there also is a button to clear the log file
- added information whether the notes path exists on the server to the
  debug information
- fixed storing of position and size of non-modal dialogs
- added more Dutch translation (thank you Fabijenna)

## 16.11.7
- the tag color of the note will now be updated correctly if a tag is
  removed from the current note
  (for [Issue #378](https://github.com/pbek/QOwnNotes/issues/378))
- when creating a new tag in the tag tree by right-clicking on a tag and
  clicking `Add tag` the tag will now be shown in the tag tree
- you can now also create tags in the tag tree by right-clicking on the
  `All notes` or `Untagged notes` items and selecting `Add tag`
- added more Polish translation (thank you lucjan)

## 16.11.6
- fixed tag creation (was broken in version 16.11.5) 
  (for [Issue #378](https://github.com/pbek/QOwnNotes/issues/378))

## 16.11.5
- fixed a problem when QOwnNotes didn't detect the macOS updater script
  for some users and added removing of the temporary updater script
  after the update
  (for [Issue #102](https://github.com/pbek/QOwnNotes/issues/102))
- you can now **assign a color to tags**
  (for [Issue #378](https://github.com/pbek/QOwnNotes/issues/378))
    - multiple tags can be selected to assign a color to or to disable
      the color
    - the color will be used as background color of the tag items in the
      tag tree and of the notes in the note list
    - if multiple tags with colors are assigned to a note then the color
      of the first tag with a color is used for the note 
- created a workaround for a sporadic crash that occurs when a network
  connection goes away
- added more Italian, Dutch, Hungarian, French, Spanish and Japanese
  translation (thank you mlocati, Fabijenna, lepascalou, richarson and piyo)

## 16.11.4
- the process for the automatic updates in macOS was improved because of
  problems of some users
  (for [Issue #102](https://github.com/pbek/QOwnNotes/issues/102))
- the `Lock panels` menu entry was renamed to `Unlock panels`, got a new
  icon and now acts accordingly
  (for [Issue #368](https://github.com/pbek/QOwnNotes/issues/368))
- the icon for the `Reload scripting engine` menu entry was changed to
  make it different from the icon of `Reload note folder`
  (for [Issue #368](https://github.com/pbek/QOwnNotes/issues/368))
- when the current note was modified externally the note diff dialog now
  just asks whether to `Accept external changes?`
  (for [Issue #365](https://github.com/pbek/QOwnNotes/issues/365))
    - selecting `No` now really causes external changes to be
      overwritten by the text in the note text edit 
- added more Spanish and Polish translation (thank you richarson and lucjan)

## 16.11.3
- there are now **automatic updates** for **macOS**
  (for [Issue #102](https://github.com/pbek/QOwnNotes/issues/102))
    - in the update dialog you will see a new `Update` button
    - if you press it a script will be loaded after a confirmation to 
      download the latest version of QOwnNotes and update your current
      installation
    - after the update QOwnNotes will be started again
    - please use the checkbox `Fake old version number to trigger update`
      in the `Debug options` and click `Check for updates` in the `Help`
      main menu to test the update process and provide feedback
- added more Italian, Dutch, Hungarian, Portuguese and Japanese
  translation (thank you mlocati, Fabijenna, mlimacarlos and piyo)

## 16.11.2
- QOwnNotes is now built with Qt 5.5 under macOS again because of
  troubles with the Qt 5.7 brewmaster deployment
- changed the download button for Windows in the update dialog to make
  it more clear that it just downloads
- added more Spanish, Italian, French and Japanese translation (thank
  you richarson, mlocati, lepascalou and piyo)

## 16.11.1
- fixed build problems with Qt 5.7 under Windows and Mac OS
  (for [Issue #376](https://github.com/pbek/QOwnNotes/issues/376))
- enabled `HOEDOWN_EXT_MATH_EXPLICIT` in hoedown
  (for [Issue #377](https://github.com/pbek/QOwnNotes/issues/377))

## 16.11.0
- QOwnNotes is now built with Qt 5.7 under OS X and Windows instead of Qt 5.5
- added information about the system environment to the debug settings dump
- there are now **automatic updates** for **Windows**
  (for [Issue #376](https://github.com/pbek/QOwnNotes/issues/376))
    - in the update dialog you will see a new `Update` button
    - if you press it the latest version of QOwnNotes will be downloaded
      and an updater script will uncompress the ZIP file to the folder
      where you were running QOwnNotes from
    - all temporary files for the update will be deleted
    - after the update QOwnNotes will be started again
        - QOwnNotes will be started in portable mode again if it was in
          portable mode before
- there is a new `Debug options` page in the settings
  (for [Issue #376](https://github.com/pbek/QOwnNotes/issues/376))
    - use the checkbox `Fake old version number to trigger update` and
      click `Check for updates` in the `Help` main menu to test the
      update process so you can provide feedback
- added more Spanish, Italian, Dutch, Hungarian, Polish, French
  and Japanese translation (thank you richarson, mlocati, Fabijenna,
  lucjan, lepascalou and piyo)

## 16.10.10
- the controls in the log panel are now hidden by default and can be
  accessed via a context menu
    - you can also clear the log from the context menu
- added an information text about color schemas to the dark mode settings
- improved the search for key sequences in the shortcut settings
- the todo dialog is not modal any more and doesn't hinder you from 
  using the application main window 
  (for [Issue #275](https://github.com/pbek/QOwnNotes/issues/275))
    - you can also open as many todo dialogs as you want now
- added more Russian, Spanish, Italian, Portuguese, Dutch, Hungarian
  and Japanese translation (thank you frostyland, richarson, mlocati,
  mlimacarlos, Fabijenna and piyo)

## 16.10.9
- you can now choose to **scale images down** when inserted into notes
  in the general settings to save disk space
  (for [Issue #268](https://github.com/pbek/QOwnNotes/issues/268))
    - you can set a maximum height and width of the images
- you can now **search for text** in the **settings dialog** to find the
  page you need more easily
- reloading the script engine in the script settings now also stores the
  enabled state of the script engine 
  (for [Issue #371](https://github.com/pbek/QOwnNotes/issues/368))
- the custom actions will be loaded correctly to the custom action
  toolbar when leaving the settings dialog with the `Ok` button 
  (for [Issue #371](https://github.com/pbek/QOwnNotes/issues/368))
- tried to fix a database folder problem under Windows
  (for [Issue #373](https://github.com/pbek/QOwnNotes/issues/373))
- the note folder menu and several menu actions are now disabled in the
  toolbar editor because they will not work in the toolbars
  (for [Issue #371](https://github.com/pbek/QOwnNotes/issues/368))
- added more Russian, Spanish, German, French, Italian, Dutch, Hungarian
  and Japanese translation (thank you frostyland, richarson, bigant,
  lepascalou, mlocati, Fabijenna and piyo)

## 16.10.8
- tried to fix some logging problems that could cause a crash when the
  app quits under OS X
  (for [Issue #371](https://github.com/pbek/QOwnNotes/issues/371))
- added a new `Panels` menu to the windows menu for showing and hiding
  panels (for [Issue #366](https://github.com/pbek/QOwnNotes/issues/366))
- added a new `Toolbars` menu to the windows menu for showing and hiding
  toolbars (for [Issue #366](https://github.com/pbek/QOwnNotes/issues/366))
- the note subfolder panel now remembers if the user originally wanted
  it to be visible if the visibility was set with the new Panels menu
  (for [Issue #370](https://github.com/pbek/QOwnNotes/issues/370))
    - this works even if the note subfolder panel was turned off because
      the current note folder has subfolders disabled
- removed custom toolbars will now not be present again after restart of
  the application
- the `Show toolbar` menu entry now also shows and hides custom toolbars
- added more Italian, Arabic, Dutch, Hungarian and Japanese translation
  (thank you mlocati, yousufinternet, Fabijenna and piyo)

## 16.10.7
- more toolbar editing fixes and improvements
    - fixed a problem with recurring custom toolbar names when creating
      a new one in the settings
    - editing of the window and custom action toolbars is now disabled
      because they are modified by the application itself too often
    - double-clicking on the menu item list now adds the current item
    - double-clicking on the toolbar item list now removes the current item
    - now the user is asked for permission to remove a toolbar
    - the tool buttons are now push buttons to look less crappy under OS X
- added more Italian, Portuguese, Dutch, Hungarian, Spanish and Japanese
  translation (thank you mlocati, mlimacarlos, Fabijenna, richarson and piyo)

## 16.10.6
- the **buttons** in the **toolbars** can now be **customized**
  (for [Issue #343](https://github.com/pbek/QOwnNotes/issues/343))
    - there is a new `Toolbars` page in the settings to add buttons from
      the main menu to toolbars, move buttons around or remove buttons
    - you can as well **add custom toolbars**
    - if you have messed the toolbars up you can also reset the toolbars
      to the default
    - there are still some issues, like that the window toolbar can't be
      modified because of the magic that is happening there
- tried to fix the openSUSE Tumbleweed repository package by using
  `libqt5-qtdeclarative` instead of (the missing) `libQt5Declarative5`
    - feedback is welcome
- added more Italian, French, Portuguese, Polish, Dutch, Russian,
  Japanese and Spanish translation (thank you mlocati, bdouxx,
  mlimacarlos, lucjan, Fabijenna, frostyland, piyo and richarson)

## 16.10.5
- added a new scripting method `tagCurrentNote()` to tag the current note
  (for [Issue #351](https://github.com/pbek/QOwnNotes/issues/351))
    - there is an example for creating a custom action to add a tag
      `favorite` to the current note at
      [favorite-note.qml](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/favorite-note.qml)
- the status messages now all start with an uppercase letter
- there now is a checkbox for ignoring of non-VTODO calendars in the
  todo settings that is turned on by default (for @binerf on GitHub)
- added more Italian, French, Portuguese, Polish, German, Hungarian and
  Dutch translation (thank you mlocati, lepascalou, mlimacarlos, lucjan,
  bigant and Fabijenna)

## 16.10.4
- fixed the left and right margin of the note tag panel
- fixed the restoring of the focus after switching workspaces
  (for [Issue #343](https://github.com/pbek/QOwnNotes/issues/343))
- added an example for custom styling of html in the note preview at
  [preview-styling.qml](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/preview-styling.qml)
  (for [Issue #356](https://github.com/pbek/QOwnNotes/issues/356))
- the log dialog is now a dockable panel that can be placed everywhere
- fixed a problem with showing the title bar of floating panels after
  application start
- fixed a problem where the note folder select box was hidden
- fixed an image preview problem and problem with the notes path under
  Windows (for [Issue #357](https://github.com/pbek/QOwnNotes/issues/357))
- the subfolder dock widget is now turned on or off according to whether
  the subfolders are enabled or not when the workspaces are switched
  (for [Issue #343](https://github.com/pbek/QOwnNotes/issues/343))
- attempted to fix a tagging portability problems between Windows and
  other operating systems
  (for [Issue #358](https://github.com/pbek/QOwnNotes/issues/358))
- added more Arabic, Japanese, Italian, French, Portuguese, Polish,
  Spanish, German, Hungarian and Dutch translation (thank you
  yousufinternet, piyo, mlocati, lepascalou, mlimacarlos, lucjan, guijan
  and Fabijenna)

## 16.10.3
- fixed a problem when the note edit panel was hidden before entering
  the distraction free mode
  (for [Issue #343](https://github.com/pbek/QOwnNotes/issues/343))
- fixed a problem with the restoring of the last workspace correctly
  when starting the app maximized
- the note folder combobox and the note search line edit now have their
  own movable panels
  (for [Issue #343](https://github.com/pbek/QOwnNotes/issues/343))
    - as a consequence the `Show note folders in main area` checkbox in
      the interface settings was removed
    - if the note folder combobox was hidden while the `Select note folder`
      shortcut in the main menu was pressed the panel will be hidden
      again after the combobox was closed
    - you have to move the two new panels to their proper places if you
      have already used version 16.10.2
- decreased the possible minimal height of the note tag panel
- added more Japanese, Italian, French and Polish translation (thank you
  piyo, mlocati, lepascalou and lucjan)

## 16.10.2
- all **panels** are now **dockable**
  (for [Issue #343](https://github.com/pbek/QOwnNotes/issues/343))
    - if you turn off panel locking you can **rearrange panels** as
      you like, they can even **float**, stack or be turned off
    - there is a button to show all panels in case you lost some
        - you can also right click on the toolbar to turn on and off
          panels individually
    - you can create, remove and rename different **workspaces** and 
      switch between them
    - there is a button to **switch between the last two workspaces**
      for example to toggle between edit and preview if you don't want
      to show both panels
    - as a consequence of the new workspace feature the panel visibility
      checkboxes and the different panel placement settings were removed
- added more Arabic, Japanese, Italian, French, Portuguese, Russian,
  Polish and Spanish translation (thank you yousufinternet, piyo,
  mlocati, lepascalou, mlimacarlos, frostyland, lucjan and richarson)

## 16.10.1
- QOwnNotes is now available in **Arabic language** (a big thank you to
  yousufinternet)
- moved the preview font settings to a new page in the settings to make
  more room in the interface settings
- there now is a new checkbox `Use internal icon theme instead of system
  icon theme` in the interface settings
  (for [Issue #331](https://github.com/pbek/QOwnNotes/issues/331))
- there now is a software repository for **openSUSE Leap 42.2**
    - please visit the
      [openSUSE installation page](http://www.qownnotes.org/installation#openSUSE)
      for instructions
- the Ubuntu Linux 14.04 package is now built with Qt 5.6.1
    - please visit the
      [Ubuntu Linux installation page](http://www.qownnotes.org/installation#Linux)
      for more information
- the preview will now only show the decrypted content of a note if the
  `edit encrypted note` button was pressed
- added more Portuguese, Italian, French, Polish and German translation
  (thank you mlimacarlos, mlocati, lepascalou, lucjan and Sqashtrash)

## 16.10.0
- you now can use your **custom method** to **encrypt and decrypt notes**
  via the scripting engine
  (for [Issue #334](https://github.com/pbek/QOwnNotes/issues/334))
    - you can use the new scripting hook `encryptionHook()` do implement
      your own encryption
    - there are examples to encrypt notes with **[Keybase.io](https://keybase.io)**
      ([encryption-keybase.qml](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/encryption-keybase.qml)),
      **PGP** ([encryption-pgp.qml](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/encryption-pgp.qml)) or
      do a trivial "encryption" with ROT13
      ([encryption-rot13.qml](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/encryption-rot13.qml))
    - you can disable the password dialog with `script.encryptionDisablePassword()`
    - to start an external synchronous process you can use `script.startSynchronousProcess()`
    - to check on which platform the script is running you can use
      `script.platformIsLinux()`, `script.platformIsOSX()` and `script.platformIsWindows()` 
    - for more information on the new commands please take a look at the 
      [scripting documentation](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/README.md)
- added some fixes to the demo script
  [insert-headline-with-link-from-github-url.qml](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/insert-headline-with-link-from-github-url.qml)
- the menu entry `Show tag pane under navigation pane` was replaced by
  `Show note list under tag pane` where note list and tag pane are swapped
  (for [Issue #340](https://github.com/pbek/QOwnNotes/issues/340))
- added more Portuguese, Russian, Japanese, Spanish, Italian, French and
  German translation (thank you mlimacarlos, Maboroshy, piyo,
  richarson, mlocati, lepascalou and bigant)

## 16.09.17
- changed the IRC channel link to a fancier web client and added a link
  to the [qownnotes Gitter room](https://gitter.im/qownnotes/qownnotes)
- fixed a problem with special characters when auto-completing text
  with `Ctrl + Space`
- there a now is a new scripting method `script.noteTextEditWrite(text)`
  to write text to the note text edit
  (for [Issue #339](https://github.com/pbek/QOwnNotes/issues/339))
    - for more information please take a look at the 
      [noteTextEditWrite documentation](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/README.md#write-text-to-the-note-text-edit)
- there a now is a new scripting method `script.noteTextEditSelectedText()`
  to read the selected text from the note text edit
  (for [Issue #339](https://github.com/pbek/QOwnNotes/issues/339))
    - for more information please take a look at the 
      [noteTextEditSelectedText documentation](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/README.md#read-the-selected-text-in-the-note-text-edit)
- added more Portuguese, Polish, Italian and Russian translation (thank
  you mlimacarlos, lucjan, mlocati and frostyland)

## 16.09.16
- added RTL support for the markdown preview
  (for [Issue #335](https://github.com/pbek/QOwnNotes/issues/335))
    - you can turn it on in the interface settings
- you now can **delete orphaned images** in a dialog with an image preview
  (for [Issue #204](https://github.com/pbek/QOwnNotes/issues/204))
    - you will find a new menu entry in the edit menu to open the dialog 
- added more Portuguese, Polish, Italian and German translation (thank
  you mlimacarlos, lucjan, mlocati and bigant)

## 16.09.15
- you can now not only solve equations with `Ctrl + Space` but also 
  **autocomplete** the **currently written word** if it was already
  used in the note
- added more French and German translation (thank you lepascalou and bigant)

## 16.09.14
- added some missing translations
  (for [Issue #333](https://github.com/pbek/QOwnNotes/issues/333))
- more **Evernote note import** features
  (for [Issue #332](https://github.com/pbek/QOwnNotes/issues/332))
    - some instances where images weren't detected were fixed
    - images that are not used in the note text can now also be imported
    - code block import
- added more Portuguese, Russian, Polish, Spanish, Italian, Hungarian
  and Dutch translation (thank you mlimacarlos, frostyland, lucjan,
  richarson, asoliverez, mlocati and Fabijenna)

## 16.09.13
- more **Evernote note import** features
  (for [Issue #332](https://github.com/pbek/QOwnNotes/issues/332))
    - the note folder is now reloaded when closing the import dialog
      if notes were imported
    - you can now also import the images of your notes
    - some line break improvements were made
- added more Portuguese, Japanese, Italian, Hungarian and Dutch
  translation (thank you mlimacarlos, piyo, vpistis, mlocati and
  Fabijenna)

## 16.09.12
- the export menu entries in the note menu were moved to a `Export`
  sub-menu to declutter the main menu
- first alpha version of the **Evernote note import**
  (for [Issue #332](https://github.com/pbek/QOwnNotes/issues/332))
    - export an `enex` file (export notes) from your Evernote desktop client
    - click `Import / Import notes from Evernote` in the QOwnNotes main menu
    - please give feedback on how it worked out in above issue
- added more Portuguese, French, Japanese, Polish, German and Italian
  translation (thank you mlimacarlos, lepascalou, piyo, lucjan, bigant
  and mlocati)

## 16.09.11
- disabled the icon of the the share menu entry in OS X 
- `QOwnNotesPortable.exe` was removed from the Windows release of
   v16.09.10, because it wasn't clear if the BAT to EXE "converter" it
   was created with added malware
  (for [Issue #236](https://github.com/pbek/QOwnNotes/issues/236))
   - please use `QOwnNotesPortable.bat` instead
- the item height of the navigation tree widget will now also be set by
  the `List and tree item height` setting in interface settings
  (for [Issue #322](https://github.com/pbek/QOwnNotes/issues/322))
- added access keys for the missing main menu items
  (for [Issue #329](https://github.com/pbek/QOwnNotes/issues/329))
- now a better job is done at syncing the scrollbars after toggling
  between edit and preview
  (for [Issue #328](https://github.com/pbek/QOwnNotes/issues/328))
- fixed setting of wrong preview font on for start of QOwnNotes if the
  settings dialog is used in the welcome dialog
  (for [Issue #325](https://github.com/pbek/QOwnNotes/issues/325))
- added more Portuguese, Russian, Japanese, Polish, German, Hungarian
  and Dutch translation (thank you mlimacarlos, frostyland, piyo,
  lucjan and Fabijenna)

## 16.09.10
- updated the monochromatic tray icon (thanks a lot @Maboroshy)
- in **portable mode** the note folders will now be automatically stored
  relative to the `Data` folder so that the correct note folders will be
  loaded regardless where your QOwnNotes installation is currently located
  (for [Issue #236](https://github.com/pbek/QOwnNotes/issues/236))
    - for Windows there now is a `QOwnNotesPortable.exe` in your release
      path to start QOwnNotes in portable mode
    - there now is a new page in the settings to show more information
      about the portable mode
- added more Italian, Portuguese, Russian, French, Polish, Hungarian and
  Dutch translation (thank you mlocati, mlimacarlos, Maboroshy,
  lepascalou, lucjan and Fabijenna)

## 16.09.9
- you can now set and reset the item height of the tree widgets and
  lists of the main window in the interface settings
  (for [Issue #322](https://github.com/pbek/QOwnNotes/issues/322))
    - this is handy if you are using QOwnNotes on a touch display
- there now is a button to reset the toolbar size in the interface settings
- there now is a **portable mode**, for example to carry around
  QOwnNotes on an USB stick (work in progress)
  (for [Issue #236](https://github.com/pbek/QOwnNotes/issues/236))
    - it will be activated if you run QOwnNotes with the parameter
      `--portable`
    - the internal sqlite database and the settings will be stored
      inside a `Data` folder at the binary's location
    - the settings will be stored in an ini file
    - TODO
        - special handling for note folders, so that they always are
          read from the `Data` folder
        - a batch file for Windows to run QOwnNotes in portable mode
- added more Polish translation (thank you lucjan)

## 16.09.8
- added a button to share a color schema you created in the settings
- took better care that no settings are getting stored after the
  `Clear app data and exit` button was pressed in the settings and
  fixed a problem where the database file wasn't deleted under Windows
  (for [Issue #318](https://github.com/pbek/QOwnNotes/issues/318))
- added more Portuguese, Russian, Chinese, Polish, Hungarian and Dutch
  translation (thank you mlimacarlos, frostyland, lucjan, nkzk and
  Fabijenna)

## 16.09.7
- a lot of text case changes have been made
- added more debug output to the debug settings
- fixed a problem with note subfolders when changing the path of the
  currently active note folder in the settings
  (for [Issue #318](https://github.com/pbek/QOwnNotes/issues/318))
- added more Italian, Portuguese, Russian, Spanish, French, German,
  Chinese, Japanese, Polish, Hungarian and Dutch translation (thank you
  mlocati, mlimacarlos, frostyland, richarson, lepascalou, nkzk, piyo,
  lucjan and Fabijenna)

## 16.09.6
- fixed a possible crash if the option to use a custom CalDAV server was
  selected in the todo settings, but no server url was entered
- only calendars that can hold todo items will now be shown in the
  calendar list in the todo settings
  (for [Issue #312](https://github.com/pbek/QOwnNotes/issues/312))
- the completed status of ical items will now also be taken into account
  then checking for completed todo items on your CalDAV server
  (for [Issue #312](https://github.com/pbek/QOwnNotes/issues/312))
- because of the changes made to the viewing of calendar names you now
  have to select them again in the todo settings
- now an error message is shown if the username or password to your
  CalDAV server is incorrect
- when automatically checking for application updates the update dialog
  will now be refreshed even if it is already open if there is an even
  newer version available
  (for [Issue #102](https://github.com/pbek/QOwnNotes/issues/102))
    - this should prevent the user from downloading an old version and
      getting a new update dialog after updating and starting the
      application again
- added more Italian, Portuguese, Russian, Hungarian and Dutch
  translation (thank you mlocati, mlimacarlos, frostyland and Fabijenna)

## 16.09.5
- more todo list features
  (for [Issue #312](https://github.com/pbek/QOwnNotes/issues/312))
    - storing of additional information to a task, such as description,
      priority and reminder date for custom CalDAV servers (this was
      tested with [Fruux](https://fruux.com))
    - the display name of the calendar will now be shown instead of the
      hash of the calendar
    - there now is a button to clear your calendar item cache in the
      todo settings, so that all todo list items will be reloaded from
      your server the next time you open your todo dialog
    - fixed a problem where an error message is shown every time you
      open your settings dialog when you don't have entered a ownCloud
      server name or when you switch to a the custom CalDAV server
      and have no server name entered yet in the todo settings
- added more Japanese, Portuguese and Polish translation (thank you
  piyo, mlimacarlos and lucjan)

## 16.09.4
- you can now also manage **todo lists** from a **custom CalDAV server**
  (for [Issue #312](https://github.com/pbek/QOwnNotes/issues/312))
    - this should already work
        - listing of all calendars in the settings dialog
        - listing of all tasks of a calendar in the todo dialog
        - creating new tasks
        - removing tasks
        - setting tasks to completed / uncompleted
    - work in progress
        - showing the calendar names instead of the hashes from the server
        - not showing an error message when switching to CalDAV in the
          settings if no server url is entered
        - storing additional information to a task, such as description,
          priority and reminder date
        - showing a better warning dialog if CalDAV username / password
          are wrong, currently there only is a warning in the log dialog
- the automatic note link url renaming method of v16.09.3 will now not
  just search for the url but trying to detect markdown links to prevent
  the wrong links from being renamed
  (for [Issue #313](https://github.com/pbek/QOwnNotes/issues/313))
- added a new monochromatic tray icon
  (for [Issue #306](https://github.com/pbek/QOwnNotes/issues/306),
  thanks a lot @Maboroshy)
- renamed the `tag pane` to `tag / subfolder pane` in the menu for more
  clarity
- added more Italian, Portuguese, Polish, German, Spanish, Hungarian
  and Dutch translation (thank you mlocati, mlimacarlos, kamilko,
  richarson and Fabijenna)

## 16.09.3
- the tag tree will now be reloaded if a tag is moved to an other location
  (for [Issue #311](https://github.com/pbek/QOwnNotes/issues/311))
- when renaming a note in QOwnNotes and a link to that note was found in
  other notes there now a dialog will be opened to ask if you want to
  rename the urls to the note in all found notes
  (for [Issue #313](https://github.com/pbek/QOwnNotes/issues/313))
  - this works if the note was renamed by modifying the first line of
    the note or (if you turned that on) by changing the note name in
    the note list
- added more Spanish translation (thank you richarson)

## 16.09.2
- fixed the tag tree reloading if a tag is added to or removed from a
  note in the note edit oder via bulk tagging 
  (for [Issue #311](https://github.com/pbek/QOwnNotes/issues/311))
- attempted to fix the start problems of the snap version of QOwnNotes
  (popey, thank you for mentioning) 
- added more Italian, Portuguese, Polish and Russian translation
  (thank you vpistis, mlimacarlos, lucjan, kamilko and frostyland)

## 16.09.1
- there now is an option in the windows menu to start the application 
  hidden if the tray icon is shown
  (for [Issue #307](https://github.com/pbek/QOwnNotes/issues/307))
- updated Hoedown (markdown to html library) to version 3.0.7

## 16.09.0
- fixed a possible crash when opening the settings dialog from a
  message dialog
- QOwnNotesAPI was updated to version 16.09.0
    - fixed a problem when the ownCloud or Nextcloud server didn't
      provide the path of a trashed note and thus no note was shown in
      the trash dialog of QOwnNotes
    - increased `max-version` to `9.2`
    - switched to rolling release version numbers
- several fixes in the snap version of QOwnNotes
- tried to make the tag button area a tiny bit smaller
- added more Italian, Chinese, Portuguese, Polish, Russian, German,
  Spanish, Hungarian and Dutch translation (thank you vpistis,
  a514917345, mlimacarlos, lucjan, frostyland, bigant, richarson
  and Fabijenna)

## 16.08.20
- if you have note subfolders activated for a note folder there now is
  a new menu entry `Find notes in all subfolders` in the note menu
  (for [Issue #305](https://github.com/pbek/QOwnNotes/issues/305))
    - triggering it jumps to `All notes` in the note subfolder tree 
      and triggers a `Find note`
- if there are more tags assigned to a note than the width of the edit
  pane allows there now will be used a scrollbar to scroll through the 
  tags, so that the width of the edit pane can still be small
  (for [Issue #308](https://github.com/pbek/QOwnNotes/issues/308))
- more **editor color scheme improvements**
  (for [Issue #280](https://github.com/pbek/QOwnNotes/issues/280))
    - you are now able the adapt the font size for each highlighting item
        - you will be able to see the adapted font size in the item preview
    - the highlighting items were reordered
    - the schema `Default` was renamed to `Light`
- you can now enable a dark mode system tray icon in the interface settings
  (for [Issue #306](https://github.com/pbek/QOwnNotes/issues/306))
- added more French, Italian, Japanese, Portuguese, Polish, Hungarian
  and Dutch translation (thank you Loelo, mlocati, piyo, mlimacarlos,
  Snipirise and Fabijenna)

## 16.08.19
- finally there are configurable **editor color schemes**
  (for [Issue #280](https://github.com/pbek/QOwnNotes/issues/280))
    - there are two default schemes called `Light` and `Dark` that
      are mimicking the current default mode and the dark mode colors
    - you can create as many schemes as you like by copying and
      modifying them
    - you can change the foreground color, background color, bold state,
      italic state and underline state
    - you can export schemes to files and import them again from 
      these files
        - if you come up with a good and proven color theme, that should
          be included by default, please let me know 
- added more Spanish, Russian and German translation (thank you
  richarson, frostyland and bigant)

## 16.08.18
- lots of text corrections in the main window and the settings dialog
- the navigation pane can now also show unrecognized headlines, like
  `# Header [link](http://url)`
  (for [Issue #302](https://github.com/pbek/QOwnNotes/issues/302))
- the settings page was redone to get more structure in it
    - there now is a list on the left to select the proper settings page
- added a donate menu item to the help menu
    - since I've been repeatably asked where to deposit donations there
      now is a donation page at [donations](http://www.qownnotes.org/donate)
- added more Italian, Portuguese, Polish, Dutch and Hungarian
  translation (thank you mlocati, mlimacarlos, lucjan and Fabijenna)

## 16.08.17
- when creating custom action buttons you now can define a button icon
  from your freedesktop theme icons or a local file
  (for [Issue #297](https://github.com/pbek/QOwnNotes/issues/297))
    - for more information please take a look at the 
      [registerCustomAction documentation](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/README.md#register-a-custom-action)
    - you will find a list of icons at
      [freedesktop icons](https://specifications.freedesktop.org/icon-naming-spec/icon-naming-spec-latest.html)
- fixed a problem with selecting text
  (for [Issue #300](https://github.com/pbek/QOwnNotes/issues/300))
- fixed a problem with the one column mode while in vertical preview
  layout mode (for [Issue #295](https://github.com/pbek/QOwnNotes/issues/295))
- you can now turn off the refreshing of the note list on external note
  folder changes completely in the general settings if for example you
  have so many notes, that even the checking for file-time and file-size
  changes is taking too long
  (for [Issue #291](https://github.com/pbek/QOwnNotes/issues/291))
    - use this at your own risk!
- added more Italian, Spanish and Polish translation (thank you mlocati,
  richarson and lucjan)

## 16.08.16
- you are now able to define **custom actions** that will be shown as
  **menu entry** in the scripting menu and optionally in the toolbar
  as **button** (for [Issue #296](https://github.com/pbek/QOwnNotes/issues/296)
  and for [Issue #297](https://github.com/pbek/QOwnNotes/issues/297))
    - there is an example for opening the current note with KWrite
      and to create a new note with a custom text at
      [custom-actions.qml](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/custom-actions.qml)
    - there is a small documentation about the function
      `registerCustomAction` and other functions in the
      [scripting documentation](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/README.md#register-a-custom-action)
    - you can also assign shortcuts for your custom actions in the 
      shortcut settings
- added new methods to the scripting engine
    - you can now also get the full file path of the current note
      with `script.currentNote().fullNoteFilePath`
    - you can now register a custom action with `script.registerCustomAction()`
    - you can now create a new note with `script.createNote()`
    - you can now access the clipboard with `script.clipboard()`
    - take a look at the [scripting documentation](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/README.md)
      for more information
- there now is a new example to create a note from a 5pm email with a 
  custom action at
  [note-from-5pm-mail.qml](https://github.com/pbek/QOwnNotes/tree/develop/doc/scripting/note-from-5pm-mail.qml)
- the warning about tags when copying or moving notes to a note
  subfolder will now be only displayed if one of the selected notes has
  a tag assigned (for [Issue #289](https://github.com/pbek/QOwnNotes/issues/289))
- added more Italian, Portuguese, Dutch and Hungarian translation
  (thank you mlocati, mlimacarlos and Fabijenna)

## 16.08.15
- fixed a problem under OSX where the shortcuts will not be viewed
  in the menu and the settings
- fixed a problem where the note list and the note subfolder list where
  not refreshed when a note or a note subfolder was removed
  (for [Issue #289](https://github.com/pbek/QOwnNotes/issues/289))
- you are now able to show the tag pane under the navigation pane with
  a checkbox in the window menu (for nothinbuttherain on 
  [reddit](https://www.reddit.com/r/linux/comments/4xto4y/4_open_source_alternatives_to_evernote/#thing_t1_d6jlppu))

## 16.08.14
- when the notes are reloaded the note list and the note subfolder tree
  will now only be refreshed in the user interface if a note or a note
  subfolder was really modified
  (for [Issue #291](https://github.com/pbek/QOwnNotes/issues/291))
- fixed a problem with copying/moving notes from a note subfolder to the
  main note folder where not all changes were viewed in the user interface 
  (for [Issue #289](https://github.com/pbek/QOwnNotes/issues/289))
- added more Spanish, Italian, German and Portuguese translation
  (thank you richarson, mlocati, bigant and mlimacarlos)

## 16.08.13
- the **reloading speed** of the **note folder** and note subfolders has
  been **dramatically improved**
  (for [Issue #291](https://github.com/pbek/QOwnNotes/issues/291))
    - when a reload is triggered now only modified notes and folders 
      will be loaded again
    - a reload happens for example if a file, that wasn't watched by 
      QOwnNotes was modified outside the application
    - when the note folder is reloaded manually with <kbd>Ctrl</kbd> +
      <kbd>⇧</kbd> + <kbd>R</kbd> every note and note folder will be reloaded
- it's now possible to copy/move notes from a note subfolder to the note 
  folder (for [Issue #289](https://github.com/pbek/QOwnNotes/issues/289))
- when in *one column mode* the other panes will now not be hidden when 
  QOwnNotes is restarted
  (for [Issue #295](https://github.com/pbek/QOwnNotes/issues/295)
    - they still will be hidden when the mode is manually entered 
- added more Spanish, Italian, Russian, Portuguese, French, Hungarian 
  and Dutch translation (thank you eemantsal, mlocati, frostyland,
  mlimacarlos, Loelo and Fabijenna)

## 16.08.12
- there now is a new item **`All notes`** in the **note subfolder** 
  tree that you can use to search for notes in all subfolders
  (for [Issue #186](https://github.com/pbek/QOwnNotes/issues/186))
    - if you create a new note while having that item selected the note 
      will be created in the root note folder
- when splitting notes now a link to the new note will be added at the 
  end of the old note 
  (for [Issue #290](https://github.com/pbek/QOwnNotes/issues/290))
- in a note subfolder now links to notes in the same subfolder work
    - when linking to notes only notes from the current subfolder will 
      be viewed in the link dialog
- if you are in the last line and press cursor down the cursor will now
  jump to the end of the line (for jd6661 on the IRC channel)
    - if you are in the first line and press cursor up the cursor will 
      now jump to the start of the line
- added more Spanish, Italian, Japanese, Portuguese, Hungarian and Dutch
  translation (thank you richarson, vpistis, piyo, mlimacarlos and Fabijenna)

## 16.08.11
- there now is a new shortcut <kbd>Alt</kbd> + <kbd>⇧</kbd> + <kbd>X</kbd>
  to **split the current note** into two notes at the current cursor position
  (for [Issue #290](https://github.com/pbek/QOwnNotes/issues/290))
  - the name of the current note plus the current timestamp will be
    used as name for the new note
  - the new note will be tagged with the same tags as the old note
- note subfolders are now turned off by default when a new note folder 
  is created
- fixed a build problem with MSVC19 (thank you @rwiesenfarth)
  (for [Issue #292](https://github.com/pbek/QOwnNotes/issues/292))
- added more Spanish, Italian, Japanese, Hungarian and Dutch translation
  (thank you richarson, mlocati, kamilko, piyo and Fabijenna)

## 16.08.10
- now you can **copy and move notes to a note subfolder** from the note 
  context menu (for [Issue #289](https://github.com/pbek/QOwnNotes/issues/289))
- there now is a checkbox in the interface settings where you can 
  **disable the markdown highlighting**
  (for [Issue #197](https://github.com/pbek/QOwnNotes/issues/197))
- added more Spanish, Polish, Hungarian and Dutch translation
  (thank you richarson, kamilko and Fabijenna)

## 16.08.9
- all **shortcuts** from the main menu should now also **work** if your
  desktop environment doesn't show the main menu bar (like **Unity** does)
  (for [Issue #288](https://github.com/pbek/QOwnNotes/issues/288))
- there now is a new shortcut <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + 
  <kbd>M</kbd> to **hide the main menu bar** 
  (for [Issue #287](https://github.com/pbek/QOwnNotes/issues/287))
  - if the menu bar is hidden a new button will be added to the window 
    toolbar to show the main menu bar again
- fixed an UI glitch under OS X where the `add tag` button stuck to 
  the right corner
- added more Spanish and Hungarian translation (thank you richarson 
  and Fabijenna)

## 16.08.8
- when the one column mode is turned on we now try to make sure the 
  note edit pane is visible
  (for [Issue #281](https://github.com/pbek/QOwnNotes/issues/281))
    - when the one column mode is turned off we now try to make sure 
      the navigation pane is visible again
- fixed a problem where notes were filtered when switching note folders 
  while there was a text in the note search line edit
- added a missing demo markdown file
- added more Russian, Dutch and Italian translation (thank you 
  frostyland, Fabijenna and mlocati)

## 16.08.7
- the one column mode is now turned off by default, it was
  accidentally turned on by default
  (for [Issue #281](https://github.com/pbek/QOwnNotes/issues/281))
	- the note edit pane will now be automatically turned on
	  when entering the one column mode

## 16.08.6
- there now is a **one column minimal mode**, like NVAlt has
  (for [Issue #281](https://github.com/pbek/QOwnNotes/issues/281))
    - you can activate it in the window menu
    - it turns off the navigation pane, the tag pane and the preview 
      pane and puts the edit pane beyond the note list
    - the setting will be remembered when you exit the app
    - entering the distraction free mode turns the one column mode off
- some dynamically set shortcuts are now set at the right time
  so they don't show up as custom shortcuts
  (for [Issue #194](https://github.com/pbek/QOwnNotes/issues/194))
  - the note edit context menu shortcuts now also load the custom
    shortcut settings
- changed some icons in the font settings
- the `Add tag` button now sicks to the right of the note edit pane
  (for jd6661 on the IRC channel) 
- added more Italian translation (thank you mlocati)

## 16.08.5
- fixed a crash when opening the link dialog
- resetting of shortcuts works now
  (for [Issue #282](https://github.com/pbek/QOwnNotes/issues/282))
- added more Portuguese, German and Japanese translation (thank you
  mlimacarlos, bigant and piyo)

## 16.08.4
- fixed an issue with the positioning of dialogs if there was
  no stored geometry for them
  (for [Issue #279](https://github.com/pbek/QOwnNotes/issues/279))
    - the geometry (along will the dialog position) will now also be 
      stored if the dialog was moved

## 16.08.3
- there now is a new **Shortcuts** tab in the settings where you can 
  assign custom shortcuts for menu items of the main window
  (for [Issue #194](https://github.com/pbek/QOwnNotes/issues/194))
    - you can also search for shortcuts
- fixed a problem with XFCE where the settings dialog had a geometry
  of 1x1 pixels
  (for [Issue #279](https://github.com/pbek/QOwnNotes/issues/279))
    - additionally now the geometry of all dialogs will be saved when 
      the window is resized and restored when the dialog is opened
- added more Portuguese, Russian, Hungarian, Dutch and Italian
  translation (thank you mlimacarlos, frostyland, Fabijenna, vpistis
  and mlocati)

## 16.08.2
- you can now **share notes** and **remove note shares** on your 
  ownCloud server in the note share dialog
- added more Hungarian, Dutch and Japanese translation (thank you 
  Fabijenna and piyo)

## 16.08.1
- you can now toggle between the note edit mode and the preview with
  <kbd>Alt</kbd> + <kbd>⇧</kbd> + <kbd>P</kbd>
  (for [Issue #269](https://github.com/pbek/QOwnNotes/issues/269))
- there now is a new button to **share your notes** on your ownCloud server
    - currently you can only see if your note is shared publicly and 
      copy the share url from the share dialog
    - actual sharing of notes is work in progress
- added more Portuguese, Russian, Hungarian, Dutch and Japanese
  translation (thank you mlimacarlos, frostyland, Fabijenna and piyo)

## 16.08.0
- tagging, removing tags, moving and copying multiple notes in note 
  subfolders now works correctly if notes with the same name exist 
  in other note subfolders
  (for [Issue #263](https://github.com/pbek/QOwnNotes/issues/263))
- <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>U</kbd> now toggles the case 
  of the selected text
    - the shortcut for checking for updates now moved to 
      <kbd>Alt</kbd> + <kbd>⇧</kbd> + <kbd>U</kbd> 
- added a link to the QOwnNotes markdown cheatsheet to the help menu
    - the markdown file will also be created as a note the first time 
      QOwnNotes starts with an empty note folder
- the scripting hook `handleNewNoteHeadlineHook()` now has a parameter
  to pass the text that would be used to create the headline
  (for [Issue #272](https://github.com/pbek/QOwnNotes/issues/272))
    - the hook will now also be called when using the search line edit 
    - if you are using the hook you have to add the parameter to the
      function in your script, so that the scripting engine will find
      your function call
    - if the headline text was modified by the hook no underline 
      characters `===` will be added automatically, you have to do that
      in your script
    - take a look at the updated example at
      [custom-new-note-headline.qml](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/custom-new-note-headline.qml)
    - you now can use the hook to create your own headline styles, 
      for example using `# headline` instead of `headline`, followed by
      `==========`
        - if you are doing this don't forget to allow the note
          headline to be different from the note filename in the
          general settings
- <kbd>Alt</kbd> + <kbd>⇧</kbd> + <kbd>S</kbd> now adds the `~~`
  characters to symbolize a strikeout of the selected text
  (for [Issue #274](https://github.com/pbek/QOwnNotes/issues/274))
    - there also is a new button in the formatting toolbar for strikeout
    - strikeout now works in the markdown preview

## 16.07.15
- tagging of notes in non-subfolder mode is working again 
  (for [Issue #263](https://github.com/pbek/QOwnNotes/issues/263))
- if showing of note subfolders is turned off in the settings the 
  active note subfolder will now be reset to prevent problems

## 16.07.14
- did a lot of improvements for support of same note names in different 
  note subfolders and general note storing, loading, tagging and
  renaming
  (for [Issue #263](https://github.com/pbek/QOwnNotes/issues/263))
- added support for tagging in note subfolders
  (for [Issue #263](https://github.com/pbek/QOwnNotes/issues/263))
- added more Portuguese, German, Russian, Hungarian, Dutch translation
  (thank you mlimacarlos, bigant, frostyland, Maboroshy and Fabijenna)

## 16.07.13
- quotes will now be shown in the markdown preview
  (for [Issue #261](https://github.com/pbek/QOwnNotes/issues/261))
- no network proxy will now be used by default to prevent issues with 
  the networking stack on some operating systems
  (for [Issue #258](https://github.com/pbek/QOwnNotes/issues/258))
- some more SSL errors are now ignored
  (for [Issue #264](https://github.com/pbek/QOwnNotes/issues/264))
- added more support for same note names in different note subfolders
  (for [Issue #263](https://github.com/pbek/QOwnNotes/issues/263))
    - there still has to be done more here

## 16.07.12
- the expand/collapse state of the items in the note subfolder tree will not 
  be stored while searching and restored when the search field is cleared
  (for [Issue #254](https://github.com/pbek/QOwnNotes/issues/254))
    - after a subfolder was created by the search field it will be cleared
- added more German and Dutch translation (thank you bigant and Telesight)

## 16.07.11
- fixed a character set problem when storing tasks in the todo list dialog
  (for [Issue #256](https://github.com/pbek/QOwnNotes/issues/256))
- improved the demo script `insert-headline-with-link-from-github-url.qml` to
  decode html entities
- added an option to use GitHub line breaks for the debug output in the 
  settings dialog 
- fixed a problem where a subfolder will not be viewed in the note subfolder 
  tree after it was created
- OSX: added a new shortcut <kbd>⌘</kbd> + <kbd>Opt</kbd> + <kbd>V</kbd> to 
  paste notes, images and html from the clipboard
- added more Portuguese translation (thank you mlimacarlos)

## 16.07.10
- added more information to the settings debug tab
- there now are error messages when something went wrong while loading your 
  ownCloud todo lists in the `Todo` tab of the settings dialog
  (for [Issue #229](https://github.com/pbek/QOwnNotes/issues/229))
    - for example keep in mind that the ownCloud calendar service uses case
    sensitive usernames and the ownCloud server itself uses case insensitive
    usernames, so please use the right case in when typing in your username
    in the ownCloud settings tab of QOwnNotes
- when opening a note subfolder in the file manager the folder will be opened
  instead of the parent folder with the subfolder selected
  (for [Issue #246](https://github.com/pbek/QOwnNotes/issues/246))
- fixed troubles with deleting the last note in a note folder or note 
  subfolder (for [Issue #253](https://github.com/pbek/QOwnNotes/issues/253))
- removed the snap part from the default notes folder path to access the 
  notes in the real home directory and not in the snap home directory for 
  Snapcraft builds 
  (for [Snappy playpen issue #145](https://github.com/ubuntu/snappy-playpen/issues/145))
- added more Dutch and German translation (thank you hartwin and bigant)

## 16.07.9
- some debug output was added when the calendar list is reloaded in the 
  settings dialog, because there were some people who had some troubles to 
  connect to their ownCloud calendars
    - please read [My calendars cannot be fetched from my ownCloud server](http://www.qownnotes.org/Knowledge-base/My-calendars-cannot-be-fetched-from-my-ownCloud-server)
      for instructions
- there are now QOwnNotes snap packages available for `amd64`, `i386`, `arm64` 
  and `armhf`
    - please visit the
      [QOwnNotes installation page](http://www.qownnotes.org/installation#snap)
      for instructions
- added more Dutch, Portuguese and Russian translation (thank you hartwin,
  mlimacarlos and Maboroshy)

## 16.07.8
- added an other fix to a duplicate note subfolder listing problem
  (for [Issue #243](https://github.com/pbek/QOwnNotes/issues/243))
- you can now also create a note subfolder by typing it into the search field 
  and pressing <kbd>Return</kbd>
- note subfolders deeper than 2nd level can now be used
  (for [Issue #246](https://github.com/pbek/QOwnNotes/issues/246))
- note subfolders can now be renamed in the note subfolder tree
- now the root note folder cannot be removed in the note subfolder tree
  (for [Issue #246](https://github.com/pbek/QOwnNotes/issues/246))
- the folders that are about to be deleted when removing a note subfolder 
  will now be viewed in the confirmation dialog to make it more clear what 
  will happen (for [Issue #246](https://github.com/pbek/QOwnNotes/issues/246))
- the informational text-block with the links to the examples is now always 
  accessible in the scripting settings tab
  (for [Issue #251](https://github.com/pbek/QOwnNotes/issues/251))
- viewing and restoring of note versions from your ownCloud server now works 
  for notes in note subfolders
- viewing trashed notes on your ownCloud server now works in note subfolders,
  as well as restoring them on your server or downloading them directly
- added more Hungarian and Japanese translation (thank you Fabijenna and piyo)

## 16.07.7
- fixed a possible crash after removing the last script in the settings dialog
  (for [Issue #247](https://github.com/pbek/QOwnNotes/issues/247))
- tried to fix an optimization crash that happened sporadically when building 
  the tag tree
- the build issues with snapcraft 2.12.1 are now fixed
  (for [Snappy playpen issue #145](https://github.com/ubuntu/snappy-playpen/issues/145))
- tried to fix the duplicate file and subfolder listings problem under Windows
  (for [Issue #243](https://github.com/pbek/QOwnNotes/issues/243))
- creating a note in a note sub folder will now not trigger a full rebuild of
  the note index (for [Issue #248](https://github.com/pbek/QOwnNotes/issues/248))
   - on some occasions it only works after a first note was created after 
     QOwnNotes was started
- there now is a context menu in the note subfolder tree where you can
  (for [Issue #246](https://github.com/pbek/QOwnNotes/issues/246))
    - create new notes
    - create new subfolders
    - remove selected subfolders
    - show the subfolder in the file manager

## 16.07.6
- more fixes for the duplicate file and subfolder listings problem under OS X
  (for [Issue #242](https://github.com/pbek/QOwnNotes/issues/242))
- the expand/collapsed state settings for the note subfolder tree will now be
  removed if the note folder is removed
- renaming notes in note subfolders should now work without the "externally 
  removed" error message
  (for [Issue #183](https://github.com/pbek/QOwnNotes/issues/183))

## 16.07.5
- fixed a duplicate file and subfolder listings problem
  (for [Issue #242](https://github.com/pbek/QOwnNotes/issues/242))
- the columns in the note subfolder tree will now be resized when a folder was 
  expanded or collapsed
  (for [Issue #183](https://github.com/pbek/QOwnNotes/issues/183))

## 16.07.4
- the **responsiveness of the app's user interface** while loading many notes, 
  note subfolders, tags or tasks was **significantly improved**
- the **expand/collapsed state** in the **note subfolder tree** is now stored 
  and will be restored when the note subfolders are loaded
  (for [Issue #183](https://github.com/pbek/QOwnNotes/issues/183))
- fixed the theme icon of the down button in the search widget of the 
  markdown editor
- there is now is a **snap** `qownnotes` publicly available for QOwnNotes
  (thanks a lot to @dholbach and @kyrofa for the help)
    - snaps are working on many Linux distributions like Arch Linux, Debian, 
      Fedora, Gentoo Linux and Ubuntu
    - please visit the
      [QOwnNotes installation page](http://www.qownnotes.org/installation#snap)
      for instructions
- there now are community-created packages for **CentOS 7** for QOwnNotes 
  (thanks a lot to Jörg Woll)
    - please visit the
      [QOwnNotes installation page](http://www.qownnotes.org/installation#CentOS)
      for instructions
- added more Russian, Italian, Hungarian and German translation (thank you 
  Maboroshy, mlocati, Fabijenna and bigant)

## 16.07.3
- fixed a bug with searching for multiple words like `"more words"` where the
  app didn't respond any more
- the default code font for the note editor and the markdown preview is now the 
  system fixed font instead of Courier
- fixed the install process in the Slackware repository
  (for [Issue #226](https://github.com/pbek/QOwnNotes/issues/226))
- the package signature of the ownCloud app QOwnNotesAPI was fixed
  (for [Issue #238](https://github.com/pbek/QOwnNotes/issues/238))

## 16.07.2
- added more features to the **note sub folder tree**
  (for [Issue #183](https://github.com/pbek/QOwnNotes/issues/183))
    - the tree decoration was removed in the note list since it should not be
      a tree any more
    - improved the column width setup of the note sub folder tree 
- on Linux a `make install` should now install the application after it was 
  built (thank you to Crazy for the improvements on the qmake project file)
- added more Russian, Dutch, Hungarian and German translation (thank you 
  frostyland, Fabijenna and bigant)

## 16.07.1
- added `Letter` as page size for PDF exports under Windows and OS X
  (for [Issue #234](https://github.com/pbek/QOwnNotes/issues/234))
- added more features to the **note sub folder tree**
  (for [Issue #183](https://github.com/pbek/QOwnNotes/issues/183))
    - there are now tooltips and a note count for note sub folder tree items
    - new notes are now created in the correct note sub folder
    - the current note sub folder will now be stored for each note folder, so
      that it gets remembered when note folders are switched
    - you can now search for note sub folders in the note sub folder line edit
- added more Dutch translation (thank you Telesight)

## 16.07.0
- there now is a new experimental **note sub folder tree** instead of the 
  folders and notes in the same note tree
   - notes are filtered by note sub folder when clicked on a note sub folder
   - searching for note sub folders is not implemented yet
- there now is a community maintained **KaOS repository** for QOwnNotes 
  (thanks a lot to @Adurol)
    - please visit the
      [QOwnNotes installation page](http://www.qownnotes.org/installation#KaOS)
      for instructions
- there now is a repository for **SUSE Linux Enterprise 12 SP1 Backports**
    - please visit the
      [QOwnNotes installation page](http://www.qownnotes.org/installation#openSUSE)
      for instructions
- added more Portuguese and Russian translation (thank you mlimacarlos and 
  Maboroshy)

## 16.06.14
- updated the installation instruction for **Linux Mint** and 
  **Ubuntu Linux 14.04**
  (for [Issue #231](https://github.com/pbek/QOwnNotes/issues/231))
	- please visit the 
	  [QOwnNotes installation](http://www.qownnotes.org/installation#Ubuntu) 
	  page for more information
- first pre-alpha release of the **note sub-folder tree integration**
  (for [Issue #183](https://github.com/pbek/QOwnNotes/issues/183))
	- per default notes will be shown as a list in a new note tree widget
	- all functionality of the old note list was integrated into the new note 
	  tree and should work as it used to
	- for each configured note folder you can now check a checkbox 
	  `Show subfolders in note list` to show the subfolders of the note folder
	- if the checkbox is checked notes of a note folder and the subfolders are 
	  shown as tree instead of a list
	- editing notes in subfolders should already work in most cases, but you 
	  cannot create new notes in subfolders yet
	- a lot more work has to be done to be able to use tags, media files, 
	  note versioning and trash, moving notes in subfolders, updating the 
	  position of edited notes in the tree and so on
- added more Portuguese and Russian translation (thank you mlimacarlos and 
  frostyland)

## 16.06.13
- there now is a checkbox to disable the status bar in the windows menu
  (for [Issue #230](https://github.com/pbek/QOwnNotes/issues/230))
    - if you have disabled the status bar use the <kbd>Esc</kbd> key to leave 
      the distraction free mode, because the `leave` button is in the status bar
- there now is a **Slackware repository** for QOwnNotes (thanks a lot to 
  @richarson for the help)
  (for [Issue #226](https://github.com/pbek/QOwnNotes/issues/226))
    - please visit the [QOwnNotes installation page](http://www.qownnotes.org/installation#Slackware) for instructions
- fixed some `database not open` errors and possible problems with the database
  (for [Issue #226](https://github.com/pbek/QOwnNotes/issues/226))
- added more Dutch translation (thank you Telesight)
- fixed a wrong string in the settings dialog

## 16.06.12
- a problem with detecting the ownCloud server if it just returns a server 
  code 302 when requesting the server url was fixed in the settings dialog 
- there now is a new scripting hook `handleNewNoteHeadlineHook()`, that is 
  called before a new note is created
  (for [Issue #218](https://github.com/pbek/QOwnNotes/issues/218))
    - it allows you to **modify the headline of a note before it is created**
    - note that you have to take care about a unique note name, otherwise
      the new note will not be created, it will just be found in the note list
    - there is an example at
      [custom-new-note-headline.qml](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/custom-new-note-headline.qml)
- added more Hungarian and Russian translation (thank you Fabijenna and 
  frostyland)

## 16.06.11
- the 100% cpu problem when disabling the markdown highlighter in the settings 
  is now fixed (for [Issue #217](https://github.com/pbek/QOwnNotes/issues/217))
- there are now more dependencies required in the openSUSE packages: 
  `libQt5Sql5-sqlite libQt5Gui5 libQt5Network5 libQt5Widgets5 libQt5Xml5`
  (for [Issue #220](https://github.com/pbek/QOwnNotes/issues/220))
- there now are repositories for **Fedora 24**
    - please visit the [QOwnNotes installation page](http://www.qownnotes.org/installation#Fedora) for instructions
- relative file urls like `[manual](file://../ownCloudUserManual.pdf)` and 
  `<file://../ownCloudUserManual.pdf>` now work in the note text edit and the
   note preview (for [Issue #221](https://github.com/pbek/QOwnNotes/issues/221))
 
## 16.06.10
- if there were no note folders found when QOwnNotes starts they now will 
  generated from the settings at the very beginning, this should prevent some 
  errors (for [Issue #220](https://github.com/pbek/QOwnNotes/issues/220))
- the packages `libQt5Sql5` and `libQt5PrintSupport5` are now required in the 
  QOwnNotes openSUSE packages
  (for [Issue #220](https://github.com/pbek/QOwnNotes/issues/220))

## 16.06.9
- there now is note folder information in the debug dump in the settings dialog
- a fallback for loading the note folder path to prevent `Can't write 
  to "/notes.sqlite"` errors was added
  (for [Issue #219](https://github.com/pbek/QOwnNotes/issues/219) and 
  [Issue #220](https://github.com/pbek/QOwnNotes/issues/220))
- the layout direction for the `next` button in the welcome dialog was
  changed to `left to right` again, because some operating systems showed 
  strange behaviors with `right to left`
  (for [Issue #220](https://github.com/pbek/QOwnNotes/issues/220))

## 16.06.8
- the menu entry `Show in system tray` was renamed to `Show menu bar item` on 
  OS X (for [Issue #214](https://github.com/pbek/QOwnNotes/issues/214))
- the `Show toolbar` menu entry is now checked as long as there is one toolbar
  activated (for [Issue #213](https://github.com/pbek/QOwnNotes/issues/213))
    - if the menu entry it is checked by a user all toolbars will be activated 
      again
- under OS X now a lot of settings keys, that get added by Qt under OS X 
  will be ignored in the debug output of the settings dialog
  (for [Issue #217](https://github.com/pbek/QOwnNotes/issues/217))
- added more Portuguese, Japanese, French, Hungarian and Spanish translation
  (thank you mlimacarlos, piyo, Loelo, Fabijenna and kender)

## 16.06.7
- when doing a text search in your note the selected text is now preset as 
  search text if there is any and there is no other search text filled in
- added more information to the debug tab in the settings
- the todo tab in the settings is now disabled if there are no ownCloud settings
  (for [Issue #208](https://github.com/pbek/QOwnNotes/issues/208))
- the app instance settings are now hidden on OS X since we don't need them 
  there (for [Issue #208](https://github.com/pbek/QOwnNotes/issues/208))
- added more Portuguese and Russian translation (thank you mlimacarlos and 
  frostyland)

## 16.06.6
- you now can use a real **dark mode** on every operating system
  (for [Issue #208](https://github.com/pbek/QOwnNotes/issues/208))
    - turn it on in the interface settings
- very long tag names will now be shortened in the tag remove button
  (for [Issue #210](https://github.com/pbek/QOwnNotes/issues/210))
- added more Hungarian and Spanish translation (thank you Fabijenna and kender)

## 16.06.5
- <kbd>Ctrl</kbd> + <kbd>Space</kbd> to solve simple equations and open links
  now also works under OS X
  (for [Issue #203](https://github.com/pbek/QOwnNotes/issues/203))
- menu icons are now hidden under OSX to be more "conform" 
  (for [Issue #198](https://github.com/pbek/QOwnNotes/issues/198))
- you now can disable the soft wrapping in the note editor and preview in the
  window menu (for [Issue #197](https://github.com/pbek/QOwnNotes/issues/197))
- the creation of empty tags is now disabled
  (for [Issue #197](https://github.com/pbek/QOwnNotes/issues/197))
- added more Portuguese, Russian, Dutch, Japanese and German translation
  (thank you mlimacarlos, frostyland, Telesight, Fabijenna, piyo and bigant)

## 16.06.4
- file names with multiple dots are now supported when inserting a headline 
  from the note filename with <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>H</kbd>  
  (for [Issue #206](https://github.com/pbek/QOwnNotes/issues/206))
- you now can open a link at the current cursor position with 
  <kbd>Ctrl</kbd> + <kbd>Space</kbd> 
  (for [Issue #203](https://github.com/pbek/QOwnNotes/issues/203))
- added more Portuguese, Russian, Dutch, Japanese and German translation
  (thank you mlimacarlos, frostyland, Telesight and piyo)

## 16.06.3
- the **highlighting** for text found by the **search for multiple words** 
  feature from version 16.06.2 now also works for those patterns
  (for [Issue #195](https://github.com/pbek/QOwnNotes/issues/195))
- <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>H</kbd> now inserts a headline from
  the note filename at the top of the note
  (for [Issue #201](https://github.com/pbek/QOwnNotes/issues/201))
- there now is a new toolbar for the quit button right of the other toolbars, 
  so this button can be disabled
  (for [Issue #197](https://github.com/pbek/QOwnNotes/issues/197))
- you can now set the markdown highlighting interval in the interface settings
  (for [Issue #104](https://github.com/pbek/QOwnNotes/issues/104))
    - setting it to `0` will disable the highlighting
      (for [Issue #197](https://github.com/pbek/QOwnNotes/issues/197))

## 16.06.2
- you now can **search for multiple words** in notes
  (for [Issue #195](https://github.com/pbek/QOwnNotes/issues/195))
    - by default notes that contain every single word will be found, `word1 
      word2` will find all notes that are containing `word1` and `word2`
    - you can search for longer texts by using quotes, `"this word1" word2` 
      will find all notes that are containing `this word1` and `word2`
- there now is a **search history**
  (for [Issue #138](https://github.com/pbek/QOwnNotes/issues/138))
    - your last 100 note searches will be stored and you can access them as 
      completer in the note search line edit
    - for every note folder a different search history will be kept
    - your whole search history will be shown if you press the <kbd>Down</kbd> 
      button in the note search line edit
- added more Chinese translation (thank you hoilc)

## 16.06.1
- the window title will now be updated correctly if the note is renamed 
- added more Spanish translation (thank you guijan)

## 16.06.0
- now the tag list context menu isn't opened if no tags are selected
  (for [Issue #166](https://github.com/pbek/QOwnNotes/issues/166))
- fixed a wrong note count for `All notes` in the tag list
- the item `Untagged notes` in the tag list will now only be viewed if there 
  are untagged notes
- instead of the notification dialog after bulk tagging notes now a status 
  message will be shown
  (for [Issue #166](https://github.com/pbek/QOwnNotes/issues/166))
- added more Portuguese, Russian, German and Japanese translation (thank you 
  mlimacarlos, frostyland, bigant and piyo)

## 16.05.24
- you can now `Show note in file manager` and `Open note in external editor` 
  from the context menu in the note list
  (for [Issue #188](https://github.com/pbek/QOwnNotes/issues/188))
- added tag name auto-completion when adding a tag to the current note
  (for [Issue #166](https://github.com/pbek/QOwnNotes/issues/166))
- there now is a new item in the tag list that allows you to view all untagged 
  notes (for [Issue #166](https://github.com/pbek/QOwnNotes/issues/166))
- added more Portuguese and Japanese translation (thank you mlimacarlos and
  piyo)

## 16.05.23
- it is now possible to add **custom note file extensions** in the settings
  (for [Issue #185](https://github.com/pbek/QOwnNotes/issues/185))
    - these file extensions will be recognized in the note list and you can 
      create new notes with them
    - they will also work with the ownCloud note versions and the trash feature 
      (for the latter you have to update QOwnNotesAPI on your ownCloud 
      server to version 0.4.4)
- fixed a possible crash in the ownCloud trash dialog
- added a menu entry to the `#qownnotes` **IRC channel** on freenode
    - join the fun at [#qownnotes IRC channel](https://webchat.freenode.net/?channels=qownnotes)
- added more Portuguese, Dutch and Hungarian translation (thank you 
  mlimacarlos and Fabijenna)

## 16.05.22
- more fixes for a problem with the interface language under Windows
  (for [Issue #184](https://github.com/pbek/QOwnNotes/issues/184))

## 16.05.21
- attempted to fix a problem with the interface language
  (for [Issue #184](https://github.com/pbek/QOwnNotes/issues/184))
- added frames for the search box for the task description edit, the 
  note version view, the log dialog and the settings debug output edit so that 
  the search widget doesn't get placed inside the text edits
- the note text view in the trash dialog now also supports markdown 
  highlighting and text searching
- replacing in markdown text edits is now prohibited if they are readonly
- when creating a code block from a selected multi-line text now a newline 
  character will be added at the end of the selected text if there wasn't 
  already one there
- added more information to the debug settings tab

## 16.05.20
- the `insert code block` command will now automatically use a multi-line 
  code block instead of an inline code block if a newline character is found in 
  the selected text (for [Issue #180](https://github.com/pbek/QOwnNotes/issues/180))
- the `deb` package should now use the 2016 version of the application icon
- added more Italian and Russian translation (thank you alexl and frostyland)

## 16.05.19
- added more information to the debug settings tab
- added a hot-fix for a crash in conjunction with the system tray under 
  Ubuntu 14.04 (for [Issue #172](https://github.com/pbek/QOwnNotes/issues/172))
- added more Japanese, German and Portuguese translation (thank you piyo, 
  bigant and mlimacarlos)

## 16.05.18
- in the tray icon there now is a new context menu entry for opening QOwnNotes
  (for [Issue #176](https://github.com/pbek/QOwnNotes/issues/176))
- left clicking on the tray icon now doesn't show or hide the app under OS X 
  because this will also also trigger the context menu
- closing the app from the title bar should now hide the app more reliably if
  the system tray icon was enabled
- opening QOwnNotes with the tray icon or the context menu entry will also 
  un-minimize the window and bring it to the front
  (for [Issue #176](https://github.com/pbek/QOwnNotes/issues/176))
- trying to fix duplicate menu entries in the context menu under Ubuntu 14.04
  (for [Issue #172](https://github.com/pbek/QOwnNotes/issues/172))
- the pane sizes in the main window are now saved and restored for all 
  combinations of tag pane, edit pane, markdown pane and vertical mode 
  toggling possibilities to assure a better pane sizes experience when 
  toggling different panes
  (for [Issue #175](https://github.com/pbek/QOwnNotes/issues/175))

## 16.05.17
- the log entries in the log window now have different colors depending on 
  their log type
- fixed a crash when showing the log window after opening QOwnNotes from the 
  system tray
- from the QOwnNotes tray icon you can now create new notes, open the ten top 
  most notes, open the todo lists, open the 10 most recent tasks or quit the app
  (for [Issue #172](https://github.com/pbek/QOwnNotes/issues/172))
- the tasks of your todo lists will now automatically be updated from your
  ownCloud server every 10 minutes to allow better reminding of tasks
  (for [Issue #172](https://github.com/pbek/QOwnNotes/issues/172))
- the `Show in system tray` checkbox was moved to the `Window` menu
- added more Japanese and Russian translation (thank you piyo and frostyland)

## 16.05.16
- added improvements to the HTML export by @dwu
- assigned tags are now preserved when manually renaming a note
- many improvements with note file renaming and preserving tags in 
  conjunction with scripting and automatic filename generation has been made
  (for [Issue #170](https://github.com/pbek/QOwnNotes/issues/170))
    - the scripting hook `handleNoteTextFileNameHook(note)` now needs to return
      a filename without file-extension
- added more German, Japanese and Russian translation (thank you bigant, piyo
  and frostyland)

## 16.05.15
- the note folder select box is now hidden correctly every time, if it should
  not be viewed and was triggered by the shortcut
  (for [Issue #169](https://github.com/pbek/QOwnNotes/issues/169))
- fixed a database warning
- now also the cursor position in the note text will be restored when 
  switching note folders
- when replacing text in a note with the `Replace` button the cursor will now
  stay with the last search hit if no more text can be replaced instead of 
  moving to the top of the note
- the note version dialog now also lets you also view the full text of the 
  versioned note (beside only the diff between the version on the server and 
  the current version)
    - you can also search in the note text with <kbd>Ctrl</kbd> + <kbd>F</kbd>
- there now is a new scripting hook `noteToMarkdownHtmlHook(note, html)`
  that is called when the markdown html of a note is generated
  (for [Issue #164](https://github.com/pbek/QOwnNotes/issues/164))
    - it allows you to modify this html
    - this is for example called before by the note preview
    - there is an example call in
      [example.qml](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/example.qml)
- added more Japanese and Portuguese translation (thank you piyo and mlimacarlos)

## 16.05.14
- there are several new features in the **log dialog**
    - you can now select different log types you want to log:
      `debug`, `info`, `warning`, `critical`, `fatal`, `status` and `scripting`
      (for [Issue #170](https://github.com/pbek/QOwnNotes/issues/170))
    - the adding of log entries to the text area was improved to handle many 
      log entries
    - the log text area will now only scroll automatically to the bottom if 
      it was scrolled to the bottom before the log entry was added
    - you can search for text in the text area with <kbd>Ctrl</kbd> + <kbd>F</kbd>
    - there is a new button to clear the log
- there are now icons for each dialog
- fixed two possible crashes in the versioning dialog
- you are now able to ignore all external modifications of your note file 
  while you are editing your note in the note diff dialog
  (for [Issue #171](https://github.com/pbek/QOwnNotes/issues/171))
    - you can turn the ignore off in the settings 
- added more Japanese and Portuguese translation (thank you piyo and mlimacarlos)

## 16.05.13
- there now is a new shortcut <kbd>Ctrl</kbd> + <kbd>Alt</kbd> + <kbd>F</kbd>
  that lets you select a different note folder
  (for [Issue #169](https://github.com/pbek/QOwnNotes/issues/169))
- you now can now reload the scripting engine with <kbd>Ctrl</kbd> + 
  <kbd>⇧</kbd> + <kbd>S</kbd>
    - you need to do that when you modify a script
    - you can also do that with a button in the scripting settings
        - it will be done automatically when you set a script file, delete a 
          script or store the settings
- you can now open a dialog to view past status messages and the log output 
  from your scripts (for [Issue #166](https://github.com/pbek/QOwnNotes/issues/166))
    - use the new script command `script.log()` to log to that dialog
- there now is a new menu entry for exporting the HTML of your note preview
  (for [Issue #168](https://github.com/pbek/QOwnNotes/issues/168))
- downloading media files, web pages for links, calendar files for the todo 
  list and files in QML scripting will now support following redirects from 
  Qt 5.6 on
- there now is a new script function `script.downloadUrlToString("http://the-webpage");`
    - it allows you to download an url to a string
    - there is an example at
      [insert-headline-with-link-from-github-url.qml](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/insert-headline-with-link-from-github-url.qml)
- added more German and Russian translation (thank you bigant and frostyland)

## 16.05.12
- tags and notes can now be exposed to the QML scripting engine
- beside the note name, the file name and the note text you can also get a 
  list of all assigned tag names for notes or a list of assigned tag objects
    - see [examples](https://github.com/pbek/QOwnNotes/tree/develop/doc/scripting)
      for a full list of all note properties and functions 
- you can get the current note with `script.currentNote()` from QML
- `function onNoteStored(note)` now gets a note object as parameter instead of 
  just the file name and the note text
- there now is a new scripting hook `function handleNoteTextFileNameHook(note)`
  that is called when a note gets stored to disk (if *Allow note file name to 
  be different from headline* is enabled in the settings)
  (for [Issue #166](https://github.com/pbek/QOwnNotes/issues/166))
    - it allows you to modify the name of the note file
    - there is an example at
      [use-tag-names-in-filename.qml](https://github.com/pbek/QOwnNotes/blob/develop/doc/scripting/use-tag-names-in-filename.qml)
- added more Japanese, Portuguese, German and Dutch translation (thank you 
  piyo, mlimacarlos, bigant and Telesight)

## 16.05.11
- fixed the QOwnNotesAPI test in the settings dialog if no network connection
  is present
- made the ownCloud server error text in the settings dialog copyable by mouse
- clarified the the meaning of the setting `notify about all external 
  modifications` (for [Issue #161](https://github.com/pbek/QOwnNotes/issues/161))
- generally increased the time a status message is visible for messages that 
  were viewed too short (for [Issue #161](https://github.com/pbek/QOwnNotes/issues/161))
- scripts are now automatically validated when the script file is set in the 
  settings dialog
- a new script hook `insertingFromMimeDataHook` was added
    - this function is called when html or media files are pasted to a note 
      with `Ctrl + Shift + V`
    - you can intercept the media paste mechanism with it
    - there is an example at
      [note-text-from-5pm-mail.qml](https://github.com/pbek/QOwnNotes/tree/develop/doc/scripting/note-text-from-5pm-mail.qml)
- the script function `modifyMediaMarkdown` was be renamed to `insertMediaHook`
  for more consistency
- added a `Paste HTML or media` context menu entry for notes
- added more Japanese translation (thank you piyo)

## 16.05.10
- QOwnNotes now has experimental **scripting support**
    - by using the power of the QQmlEngine and QML files you are now able
      to script some behaviors in the application yourself
    - you will find a new *Scripting* tab in the settings dialog where you can 
      add as many scripts to QOwnNotes as you like
    - it is possible to disable or remove scripts
    - you may need to restart QOwnNotes to let changes in a script take action 
    - I prepared some
      [examples](https://github.com/pbek/QOwnNotes/tree/develop/doc/scripting)
      to play around with
    - if you need access to a certain functionality in QOwnNotes or have 
      questions or ideas please open an issue on the 
      [QOwnNotes issue page](https://github.com/pbek/QOwnNotes/issues)

## 16.05.9
- added a small remedy for the problem of not detected external note changes 
  under Linux
- fixed the `undefined` list entry in the version dialog and the trash dialog
- fixed a problem with the automatic text selection when replacing text in notes

## 16.05.8
- fixed the the jumping to headlines when clicking on them in the navigation 
  bar if the note edit pane was disabled at app startup
  (for [Issue #165](https://github.com/pbek/QOwnNotes/issues/165))
- fixed the distraction free mode if the note edit pane was disabled while 
  entering the distraction free mode
- added more Japanese, Portuguese, Italian and Russian translation (thank you 
  piyo, mlimacarlos, rogepix and frostyland)

## 16.05.7
- made a workaround for the not working page setup dialog for the PDF 
  export under OS X and Windows 
  (for [Issue #156](https://github.com/pbek/QOwnNotes/issues/156))
    - you can select page sizes from A0 to A9
    - you can select the page orientation (portrait and landscape)
- added more German translation

## 16.05.6
- SHA256 hashes were added to the AUR repository
- you can now select the page format when exporting notes as PDF
  (for [Issue #156](https://github.com/pbek/QOwnNotes/issues/156))
- added more German, Japanese and French translation (thank you piyo and Loelo)

## 16.05.5
- fixed a problem with the Gentoo Linux overlay
  (for [Issue #163](https://github.com/pbek/QOwnNotes/issues/163))
- did some styling fixes for the text replace widget on OS X
- you can new use a new setting in the general settings to **allow that the 
  note file name is different from the note headline**
  (for [Issue #157](https://github.com/pbek/QOwnNotes/issues/157))
    - this allows you to keep your old note files regardless of what the content
      of them is
    - the note name will also be found in the note search
    - you are able to **rename your note files** by double-clicking on the note 
      name in the note list
        - renaming will fail if there already exists a note with the same name
        - some characters are also not allowed in the file name, they will be 
          removed automatically
    - be aware of that ownCloud notes needs the note file name to be the same 
      as the note headline
- added more Japanese translation (thank you piyo)

## 16.05.4
- the last open note will now be remembered when switching between note folders
- you can now use the new **regular expression** and **whole word** modes to 
  search for text inside of notes
    - when replacing with regular expressions containing capturing parentheses, 
      occurrences of `\1`, `\2`, ... can be used in the replace text
- fixed a possible search and replace infinite loop
- added support for case sensitive search
- added more Portuguese and German translation (thank you mlimacarlos and dgirke)

## 16.05.3
- QOwnNotes will now be built from a **source archive** (like it should be) in 
  the AUR and in the Gentoo overlay (and not from git repositories)
  - visit [Building QOwnNotes](http://www.qownnotes.org/installation#building) 
  for more information on building QOwnNotes and source archives
- the text is now also selected in the text replace dialog
- added more Japanese translation (thank you piyo)

## 16.05.2
- the **active tag** will now be **remembered across different note folders** 
  when switching between note folders
- the note preview is now regenerated once a second when the preview 
  pane is resized to readjust the width of embedded images
  (for [Issue #154](https://github.com/pbek/QOwnNotes/issues/154))
- when the text replace functionality is activated now the currently selected 
  text will be entered in the search line edit
- when clicking a headline in the navigation bar the text beneath the headline 
  will be now made fully visible by scrolling more intelligently
  (for [Issue #153](https://github.com/pbek/QOwnNotes/issues/153))
    - in addition the text of the headline will be selected
- if a note was created by hitting `Return` in the note search line edit now
  the line edit will be cleared so all notes will be viewed again
- <kbd>Ctrl</kbd> + <kbd>Space</kbd> now tries to **solve simple equations** 
  like `(4+5)*3=` in the current line in front of the cursor 
  (for [Issue #152](https://github.com/pbek/QOwnNotes/issues/152))
    - the result will be put into the note if the cursor is after the `=` 
- fixed a problem where opening the settings dialog from an other dialog 
  would remove some settings

## 16.05.1
- fixed the automatic image resizing in the preview under Windows
  (for [Issue #154](https://github.com/pbek/QOwnNotes/issues/154))
- improved the automatic image width calculation for the image resizing in the
  preview (for [Issue #154](https://github.com/pbek/QOwnNotes/issues/154))
- fixed a sporadic crash that occurred when switching the note folder
- in the navigation tree now a suitable parent headline will be searched if 
  the headline order was not correct
- the preview view now also scrolls to the position of the headline if 
  clicked in the navigation bar
- the navigation bar now also works while editing encrypted notes
- added more Portuguese, Japanese and Dutch translation (thank you 
  mlimacarlos, piyo and hartwin)

## 16.05.0
- a navigation bar that shows the headline structure of the current note was 
  implemented (for [Issue #153](https://github.com/pbek/QOwnNotes/issues/153))
    - click on a headline to jump to it in the note
    - you can hide the navigation bar by dragging it to the bottom with the 
      splitter handle between the note list and the navigation bar 
- added more German and French translation (thank you Loelo)

## 16.04.18
- added **Italian translation** (a big thank you to alexl and rogepix!)
- added some styling fixes for the text-replace widget in OS X 
- fixed the size of the todo dialog
- the width of images in the preview will now be reduced to the width of the 
  preview pane if they are larger than that
  (for [Issue #154](https://github.com/pbek/QOwnNotes/issues/154))
- added more German, Portuguese, French, Russian, Japanese, Dutch and Hungarian
  translation (thank you mlimacarlos, Loelo, frostyland, piyo and Fabijenna)

## 16.04.17
- decreased the width of *add tag* dialog
- if a note is created while a tag was selected in the tag tree the note will
  now get tagged with that tag
- when creating a new note folder in the settings dialog the folder name will
  now be selected and gets the focus
- you can now replace found text in the current note with <kbd>Ctrl</kbd> +
  <kbd>R</kbd>
  (for [Issue #149](https://github.com/pbek/QOwnNotes/issues/149))
    - The shortcut for removing the current note went to <kbd>Alt</kbd> + 
    <kbd>R</kbd>
    - please visit [QOwnNotes shortcuts](http://www.qownnotes.org/shortcuts/QOwnNotes)
      for a list of all shortcuts
- added more Portuguese, French, Russian, German and Japanese translation 
  (thank you mlimacarlos, Loelo, frostyland and piyo)

## 16.04.16
- did some fixes to the settings dialog to support small screen widths
  (for [Issue #136](https://github.com/pbek/QOwnNotes/issues/136))
- the tag tree will now be expanded automatically when the tags are loaded 
  and the columns are sized to the contained content
- you can now add a new tag beneath an other tag by right-clicking on it and 
  select *Add tag*
- added a new QOwnNotes desktop icon (a big thank you to Alex L from the KDE 
  V Design Group)
- added more Dutch, Hungarian, Portuguese, French, Spanish, Russian and Japanese 
  translation (thank you Fabijenna, mlimacarlos, Loelo, fitoschido, frostyland
  and piyo)

## 16.04.15
- **tags can now have a hierarchical structure**
  (for [Issue #137](https://github.com/pbek/QOwnNotes/issues/137))
	- there is a number right of each tag name in the tag tree that indicates
	  how many notes are tagged with the tag
	- you are able to search for tags in your tag tree with the `find or create 
	  tag` line edit by typing in it
		- if you press enter a new tag with the content of the line edit is 
		  created at the root level
	- you are able to move selected tags to an other tag by right-clicking on 
	  them and select *Move tags to...*
	- you are able to remove selected tags by right-clicking on them and select
	  *Remove tags*
	- you are able to edit the name of selected tags by right-clicking on them
	  and select *Edit tag* or double-clicking on it
	- you are able to tag selected notes by right-clicking on the notes and 
	  select *Tag selected notes with...*
	- you are able to remove a tag from selected notes by right-clicking on the 
	  notes and select *Remove tag from selected notes...*
	- the name of a tag has to be unique for its parent
		- so you can create tags with the same name under different tags
		- you cannot move a tag to an other tag if a tag with the same name 
		  already exists there
- improved the code background color in the markdown view in dark mode
- when in single application mode the app will now come up again if it was 
  minimized and started a second time
  (for [Issue #136](https://github.com/pbek/QOwnNotes/issues/136))
- added more Portuguese, French, Spanish and Japanese translation (thank you 
  mlimacarlos, Loelo, fitoschido and piyo)

## 16.04.14
- you can now also delete tags, notes and tasks with the <kbd>Backspace</kbd>
  key (for the OS X users) instead of only with the <kbd>Del</kbd> key
- fixed some problems with remembering the correct sizes of the panes in the 
  main window after an app restart
- you can now set in the general settings that you only want to **allow one 
  application instance running at the same time**
  (for [Issue #136](https://github.com/pbek/QOwnNotes/issues/136))
- the tag list has now a context menu for deleting and editing tags
- the structure of the settings dialog was changed to decrease the height for
  smaller screens
  (for [Issue #141](https://github.com/pbek/QOwnNotes/issues/141))
- added more Russian and Japanese translation (thank you Valerian and piyo)
- improved the meaningfulness of some error messages

## 16.04.13
- added better support for full width numbers in note names when linking notes 
  with unicode characters
  (for [Issue #144](https://github.com/pbek/QOwnNotes/issues/144))
- the in-text search in the todo summary edit and debug text-edit were fixed
- collapsing was disabled for all panels in the main window, so they can't be 
  hidden by accident
  (for [Issue #148](https://github.com/pbek/QOwnNotes/issues/148))
- you can now also **split** the note edit pane and note markdown preview 
  **vertically** instead of horizontally to gain more space on screens with 
  lower horizontal resolution
  (for [Issue #145](https://github.com/pbek/QOwnNotes/issues/145))
- added more Portuguese and Japanese translation (thank you mlimacarlos and piyo)

## 16.04.12
- **switched QOwnNotes release versioning** to a more *rolling release 
  style*, so it doesn't get confused with semantic versioning
    - `<year of release>.<month of release>.<release number in the month>` 
- added support for full width numbers in note names when linking notes with 
  unicode characters
  (for [Issue #144](https://github.com/pbek/QOwnNotes/issues/144))
- added a workaround to keep the note count in the tag name and still being 
  able to edit it without having to remove the note count from the name
- it is now possible to toggle the visibility of the note edit pane
  (for [Issue #145](https://github.com/pbek/QOwnNotes/issues/145))
- the main toolbar is now split into multiple toolbars that you can rearrange
  or hide by themselves
  (for [Issue #141](https://github.com/pbek/QOwnNotes/issues/141))
    - keep in mind that you can also drag toolbars to the left, right or 
      bottom of the window
- added more Japanese translation (thank you piyo)

## 1.4.3
- added **Japanese translation** (a big thank you to piyo!)
- opening notes in the default editor was fixed for Windows
  (for [Issue #142](https://github.com/pbek/QOwnNotes/issues/142))
- opening notes with multi-byte file names in the an custom external editor was 
  fixed for Windows and OS X
  (for [Issue #143](https://github.com/pbek/QOwnNotes/issues/143))
- SSL warnings on OS X are not logged to the console any more
- support for **linking notes with unicode characters** in their names was added
  (for [Issue #144](https://github.com/pbek/QOwnNotes/issues/144))
- fixed a problem with a jumping text cursor when the note folder is modified
  externally (for [Issue #146](https://github.com/pbek/QOwnNotes/issues/146))
- you can now **remove a tag from multiple notes** by selecting them, then 
  right-clicking on the notes and selecting *Remove tag from selected notes...*  
  (for [Issue #139](https://github.com/pbek/QOwnNotes/issues/139))
- added more Russian, German, Hungarian and Dutch translation (thank you 
  Valerian, calis2002 and Fabijenna)

## 1.4.2
- some improvements were made to the detection whether the <kbd>Ctrl</kbd> 
  key is pressed in the note text edit or not
- the lines between frames on the main screen were made a bit stronger under 
  Linux  
- the `Reload note folder` menu entry also reloads the current note now
- fixed some displaying problems on the main screen
  (for [Issue #140](https://github.com/pbek/QOwnNotes/issues/140))
- the note edit and note markdown view scrollbars are now linked together
- the markdown preview now also works when editing encrypted notes (although 
  the update interval is the note storage interval)
- fixed an issue with the note order in the note list in alphabetical sorting 
  mode when editing a note
  (for [Issue #141](https://github.com/pbek/QOwnNotes/issues/141))
- some visual improvements in the html of the markdown preview has been made
  (for [Issue #141](https://github.com/pbek/QOwnNotes/issues/141))
- inserted buttons for *bold* and *italic* in the main menu
  (for [Issue #141](https://github.com/pbek/QOwnNotes/issues/141))
- added more Portuguese and Russian translation (thank you mlimacarlos and Valerian)

## 1.4.1
- you can now **tag multiple notes** by selecting them, then right-clicking on 
  the notes and selecting *Tag selected notes with...*  
  (for [Issue #135](https://github.com/pbek/QOwnNotes/issues/135))
- added **live markdown preview**
  (for [Issue #119](https://github.com/pbek/QOwnNotes/issues/119))
    - the **markdown note view** is now optionally **visible all the time**
    - <kbd>Ctrl</kbd> + <kbd>E</kbd> now toggles the markdown view mode
    - the markdown preview will be updated every 2 sec 
    - todo: linked scrolling between note edit and markdown view
    - todo: markdown preview update when editing encrypted notes 
- some main splitter user interface fixes for OS X were done
- did some note editing user interface improvements and fixes for the 
  distraction free mode and the dark mode
- added more Portuguese and Russian translation (thank you mlimacarlos and Valerian)

## 1.4.0
- a lot of **design changes** were done in the **main interface**
- the amount of all notes is now also shown in the tag list
- the size of the settings screen was decreased so it fits on smaller displays
- the distraction free mode was fixed for when tagging is turned on
- the distraction free mode was fixed for when dark mode is turned on
- added more Portuguese and Russian translation (thank you mlimacarlos and Valerian)

## 1.3.9
- there now is a menu entry to reload the current note folder
    - use <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>R</kbd> as a shortcut
- on Linux now only the 200 most recent notes will be watched for external 
  changes to prevent that nothing is watched at all because of too many open 
  files
- the notes in the note list now have an icon to look more fancy and the last
  modified date is shown in the tooltip
- the amount of notes for each tag is now shown in the tag list 
- added more Portuguese and Russian translation (thank you mlimacarlos and Valerian)

## 1.3.8
- some user interface styling and naming changes for tagging 
- when a tag is clicked in the tag list widget the note search line edit now 
  will be cleared
- when a new tag is created for a note the previously entered text will now 
  be selected
- fixed a possible crash when selecting a remote note folder in the note 
  folder settings

## 1.3.7
- you now can **tag your notes**
	- you can turn on tagging with <kbd>Alt</kbd> + <kbd>⇧</kbd> + <kbd>T</kbd>
	- tags and their associations to note files are stored in each note folder
	  individually in a SQLite database
	- if notes are renamed by QOwnNotes the tags will be moved to the renamed
	  notes
	- if notes are move to an other folder their associated tags are lost 
	- <kbd>Alt</kbd> + <kbd>⇧</kbd> + <kbd>A</kbd> adds a new tag to a note

## 1.3.6
- fixed a remote folder selection issue with deeper levels of folders in the 
  note folders settings
- added more Russian translation (thank you Valerian)

## 1.3.5
- fixed a remote folder selection issue with special characters and 
  whitespaces in the folder names
- implemented a new symbol in the note search/create line edit with an  
  additional dark mode theme version of the symbol
- improved the note font preview in the settings for dark mode themes
- improved the links and some texts in the settings dialog for dark mode themes
- added more Portuguese and Russian translation (thank you mlimacarlos and Valerian)

## 1.3.4
- in the *note folder* settings you can now select your remote ownCloud note 
  path directly on your server 
   - the folders will be fetched via WebDAV from your ownCloud server 
- added more Russian translation (thank you Valerian)
- characters like `:`, `/` and `\`, as well as multiple whitespace characters
  will now be removed from the note file name if the first line of the note 
  is containing them
  (for [Issue #126](https://github.com/pbek/QOwnNotes/issues/126))

## 1.3.3
- fixed a possible problem with an empty default note file extension setting
  (for [Issue #123](https://github.com/pbek/QOwnNotes/issues/123))
- added more Spanish and Russian translation (thank you asoliverez and Valerian)

## 1.3.2
- fixed a problem with the output of ownCloud error messages in the settings 
  dialog
- fixed a potential crash when opening the note folder tab in the settings 
  from the welcome screen as long there was no note folder configured
- removed an obsolete button from the ownCloud settings tab
- <kbd>⇧</kbd> + <kbd>Tab</kbd> will now also un-indent spaces in front of text
- added more Portuguese and Spanish translation (thank you mlimacarlos and asoliverez)

## 1.3.1
- fixed the background color in the note folder text edit on the welcome 
  screen for dark mode themes 

## 1.3.0
- moving and copying of notes now works with note folders, like it should
- fixed the position of the context menu in the note text edit
  (for [Issue #124](https://github.com/pbek/QOwnNotes/issues/124))
- added a setting that will optimize the colors in dark desktop themes a bit
    - more ideas for dark mode theme colors are welcome
- added more Portuguese translation (thank you mlimacarlos)

## 1.2.9
- fixed that the note list didn't get reloaded after you set a different active 
  note folder in the settings
- fixed that notes weren't stopped from being watched for external changes 
  after the note folder got switched
- if you configured an editor for opening your note files with it the editor 
  will now be executed in the background, so you can continue to work with 
  QOwnNotes
- strings like `?b=16068071000` will now be removed from the suffix of 
  downloaded media files

## 1.2.8
- you are now able to **configure your note folders** in the settings
  (for [Issue #36](https://github.com/pbek/QOwnNotes/issues/36))
	- as a consequence the *recent note folders* will not be used any more to 
	  switch between note folders
		- everything that was using the *recent note folders* will now use the 
		  **note folders**
	- you can also configure a path on your ownCloud server for each folder
	- the field *main ownCloud sync folder* was removed from the ownCloud 
	  settings since this will now be done be the *note folders*
	- keep in mind that you also can turn on a **select box** with all your 
	  **note folders** over your note list in the settings 
- the default horizontal stretch of the notes list and the note view was 
  improved
- some more information was added to the welcome screen
- added more Polish translation (thank you @Olhur)

## 1.2.7
- fixed a problem after moving notes to an other folder
  (for [Issue #117](https://github.com/pbek/QOwnNotes/issues/117))
- added more Portuguese translation (thank you mlimacarlos)

## 1.2.6
- fixed building of QOwnNotes under ARM by patching the Botan library
  (for [Issue #116](https://github.com/pbek/QOwnNotes/issues/116))
- there now is a setup-wizard-like welcome dialog that opens if no note path is
  set (for example at first start of QOwnNotes)
    - there you can setup your notes path
    - reach the ownCloud settings to setup access to your ownCloud server
    - reach the general settings to disable app metrics
- added more Portuguese translation (thank you mlimacarlos)

## 1.2.5
- lots of todo dialog improvements
    - the *save and insert* button will be disabled correctly now
    - did some tab order improvements
    - the description edit now gets the focus after creating a new task
    - when editing a reminder date and pressing enter, the task 
      now gets stored and the description edit gets the focus
    - you can now remove tasks with the <kbd>Del</kbd> key
    - fixed the shortcuts of the *Store*, *Store and insert* and *Remove* 
      buttons
        - please visit [QOwnNotes shortcuts](http://www.qownnotes.org/shortcuts/QOwnNotes)
          for a list of all shortcuts
- added more German and Portuguese translation (thank you calis2002 and mlimacarlos)

## 1.2.4
- the selected text in a note will be inserted as summary in the todo dialog
  to create a new tasks more easily
- you now can insert a link to a task in a note from the todo dialog
    - tasks from these links get viewed in the todo dialog when clicked
      if they exist  
- added some information about [Let's encrypt](https://letsencrypt.org/) to 
  the settings
- added some status messages about externally modified notes
- added some missing SSL error checks

## 1.2.3
- added some alternate shortcuts for moving between notes
    - <kbd>Alt</kbd> + <kbd>Up</kbd> jumps to the previous visible note
    - <kbd>Alt</kbd> + <kbd>Down</kbd> jumps to the next visible note
- you can now close the distraction free mode with <kbd>Esc</kbd>
- you can now open the settings with <kbd>Ctrl</kbd> + <kbd>,</kbd>
- there now is a new setting for **ignoring SSL errors** when connecting to 
  your ownCloud server
    - by default this setting is turned on, to mimic recent behaviour of 
      QOwnNotes
    - get free SSL certificates at [Let's encrypt](https://letsencrypt.org/) 
      for your own server and turn off the *ignoring SSL errors* checkbox!
- added more Portuguese translation (thank you mlimacarlos)

## 1.2.2
- fixed a crash that could happen when a recent notes folder was selected
- added shortcuts to quickly increase or decrease the font size of the notes 
  in edit mode
    - <kbd>Ctrl</kbd> + <kbd>+</kbd> increases the note text font size by one point
    - <kbd>Ctrl</kbd> + <kbd>-</kbd> decreases the note text font size by one point
    - <kbd>Ctrl</kbd> + <kbd>/</kbd> resets the note text font size
- added more German, Portuguese, Hungarian and Dutch translation (thank you 
  mlimacarlos and Fabijenna)

## 1.2.1
- client side **note encryption** changed from SimpleCrypt to the much 
  more secure **AES-256** encryption
    - old encrypted notes will be decrypted with SimpleCrypt and encrypted 
      with AES-256 when you edit them
    - some major changes had to be made to make this possible, please report 
      if you run into troubles
- added more German translation (thank you calis2002)

## 1.2.0
- added bold and italic formatting helpers
    - <kbd>Ctrl</kbd> + <kbd>B</kbd> formats the selected text bold 
    - <kbd>Ctrl</kbd> + <kbd>I</kbd> formats the selected text italic 
- when inserting code blocks there will be added a new line on top and at the 
  bottom of the selected text if the selected text has multiple lines
  (for [Issue #113](https://github.com/pbek/QOwnNotes/issues/113))
- added more German, Portuguese, Hungarian and Dutch translation (thank you 
  mlimacarlos and Fabijenna)

## 1.1.9
- fixed a problem with continuous list editing where text from the previous 
  line got copied to the next line
- scroll to the cursor if we are at the bottom of the document when creating 
  a new list item in a note
- if return is pressed in a markdown list and there is just a list symbol then
  the list symbol is now removed
- you can now also search in the current note with <kbd>F3</kbd> and 
  <kbd>⇧</kbd> + <kbd>F3</kbd> even if the search widget doesn't have the focus
- you can now show the current note in your file manager with a new menu item
  (for [Issue #106](https://github.com/pbek/QOwnNotes/issues/106))
    - use <kbd>Alt</kbd> + <kbd>⇧</kbd> + <kbd>F</kbd> as shortcut
    - under OS X the folder of the note is opened in Finder, but the note is 
      not selected
- added more German and Spanish translation (thank you calis2002 and 
  moblesmarti)

## 1.1.8
- added rich text pasting fixes for Internet Explorer
  (for [Issue #112](https://github.com/pbek/QOwnNotes/issues/112))

## 1.1.7
- you can now also drop images from websites directly to a note
  (for [Issue #105](https://github.com/pbek/QOwnNotes/issues/105))
- if there is no plain text to paste with <kbd>Ctrl</kbd> + <kbd>V</kbd> then
  it will be checked if there html, notes or images to paste automatically
  (for [Issue #105](https://github.com/pbek/QOwnNotes/issues/105))
- added more Spanish translation (thank you moblesmarti)
- implemented continuous list editing for unordered markdown lists starting 
  with `-`, `+` or `*`
    - <kbd>Tab</kbd> after a list character indents the list item
    - <kbd>⇧</kbd> + <kbd>Tab</kbd> after a list character un-indents the list item
    - <kbd>Return</kbd> in lists creates a new list item

## 1.1.6
- added **Spanish translation** (a big thank you to moblesmarti!)
    - join us at [QOwnNotes on Crowdin](https://crowdin.com/project/qownnotes/invite)
      to make QOwnNotes available in more languages
- added more Hungarian translation (thank you Fabijenna)
- you can now **paste html** in notes with <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + 
  <kbd>V</kbd> (for [Issue #112](https://github.com/pbek/QOwnNotes/issues/112))
  - html tags like `strong`, `b`, `em`, `i`, `a`, `h1`, `h2`, `h3`, `h4`, 
    `h5`, `br` will be translated to markdown
  - images from `img` tags will be downloaded and inserted as markdown images

## 1.1.5
- added more German, Hungarian and Dutch translation (thank you Fabijenna)
    - join us at [QOwnNotes on Crowdin](https://crowdin.com/project/qownnotes/invite)
      to make QOwnNotes available in more languages
- fixed some typos
- added several fixes for Windows
  (for [Issue #105](https://github.com/pbek/QOwnNotes/issues/105))
    - dragging and dropping of images into notes
    - the image preview in markdown mode
    - opening of links to local files

## 1.1.4
- added support for copying notes from a file manager to QOwnNotes via drag and 
  drop (for [Issue #100](https://github.com/pbek/QOwnNotes/issues/100))
- added support for dragging and dropping images into notes
  (for [Issue #105](https://github.com/pbek/QOwnNotes/issues/105))
- added support for copying and pasting images into notes from a file manager
  (for [Issue #105](https://github.com/pbek/QOwnNotes/issues/105))
    - use <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>V</kbd> as shortcut for 
    pasting this way
- added support for copying and pasting images from an image manipulation 
  software into a note
  (for [Issue #105](https://github.com/pbek/QOwnNotes/issues/105))
    - a new png image will be created in the `media` folder of your notes folder 
    - use <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>V</kbd> as shortcut for 
    pasting image data
    - please visit [QOwnNotes shortcuts](http://www.qownnotes.org/shortcuts/QOwnNotes)
      for a list of all shortcuts
- added more Hungarian translation (thank you Fabijenna)

## 1.1.3
- added **Hungarian translation** (a big thank you to Fabijenna!)
    - join us at [QOwnNotes on Crowdin](https://crowdin.com/project/qownnotes/)
      to make QOwnNotes available in more languages
- added shortcuts for note printing
  (for [Issue #99](https://github.com/pbek/QOwnNotes/issues/99))
    - <kbd>Ctrl</kbd> + <kbd>P</kbd> prints the current note as text
    - <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>P</kbd> prints the current note 
    as markdown
- you now get a feedback while note versions or trashed notes are loaded and 
  the buttons are disabled while you are loading them 
  (for [Issue #97](https://github.com/pbek/QOwnNotes/issues/97))
- added more German translation

## 1.1.2
- added more Dutch translation (thank you Fabijenna)
- fixed the *leave distraction free mode* button icon
- the notes viewed in the distraction free mode now have an adjustable viewport 
  width (for [Issue #86](https://github.com/pbek/QOwnNotes/issues/86))
    - the viewport will resize automatically if the width of the window changes
    - you can select between four width modes in the *Window* menu 
- you can now toggle visibility of the tool bar in the *Windows* menu
  (for [Issue #103](https://github.com/pbek/QOwnNotes/issues/103))
- added more German translation

## 1.1.1
- added **Dutch translation** (a big thank you to Fabijenna!)
- pressing <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>F</kbd> to do a note search 
  now leaves the distraction free mode
- the notes in the distraction free mode now have a padding 
  (for [Issue #86](https://github.com/pbek/QOwnNotes/issues/86))
- added more German translation
- there now is a **Gentoo Linux overlay** for QOwnNotes (thanks a lot to 
  @internethering and @suhr for the help)
    - please visit the [QOwnNotes installation page](http://www.qownnotes.org/installation#Gentoo) for instructions

## 1.1
- QOwnNotes now allows the usage of `# ` markdown headlines as note title
  (for [Issue #87](https://github.com/pbek/QOwnNotes/issues/87))
    - the characters will be removed in the note name
    - keep in mind that this behaviour may not be supported by other note 
      clients, that may add the `# ` back again into the file name 
- added more Russian translation (thank you SpacePotato)

## 1.0.9
- improved the in-note search, so that it will not be able to block the note 
  text any more

## 1.0.8
- you can now enter a distraction free mode with a new button in the toolbar
  (for [Issue #86](https://github.com/pbek/QOwnNotes/issues/86))
    - you can also toggle it with <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>D</kbd> 

## 1.0.7
- the Chinese language got renamed internally for Crowdin, it's possible that 
  you have to re-select it in the settings if you were using it 
  (for [Issue #95](https://github.com/pbek/QOwnNotes/issues/95))
    - join us on [QOwnNotes on Crowdin](https://crowdin.com/project/qownnotes/)
      to make QOwnNotes available in your language
- **fixed note encryption** that got broken in version 1.0.6
    - if you have encrypted notes in version 1.0.6 you have to first **decrypt 
      them with version 1.0.6** before using them in version 1.0.7! 

## 1.0.6
- you can now enter **network proxy settings** in the new network settings 
  tab to make QOwnNotes work over network proxies
  (for [Issue #79](https://github.com/pbek/QOwnNotes/issues/79))
- added more German translation
- use <kbd>Ctrl</kbd> + <kbd>PgUp</kbd> and <kbd>Ctrl</kbd> + <kbd>PgDn</kbd>
  to **jump between visible notes**
  (for [Issue #80](https://github.com/pbek/QOwnNotes/issues/80))
    - please visit [QOwnNotes shortcuts](http://www.qownnotes.org/shortcuts/QOwnNotes)
      for a list of all shortcuts
    
## 1.0.5
- Google Analytics got removed in favor of Piwik
- code blocks will now wrap around selected text when inserted
  (for [Issue #91](https://github.com/pbek/QOwnNotes/issues/91))
- increased the color contrast in the markdown highlighting for better 
  readability
- added more Russian translation (thank you @elnull)

## 1.0.4
- added a button to insert a markdown code block at the current cursor position
  (for [Issue #82](https://github.com/pbek/QOwnNotes/issues/82))
  - you can use 'Ctrl + Shift + C` as shortcut
- fixed a display problem with the update notification button under Windows
  (for [Issue #90](https://github.com/pbek/QOwnNotes/issues/90))
- added more German translation

## 1.0.3
- added **Portuguese translation** by @mlimacarlos, thank you a lot!
- added more German, French and Russian translation (thank you @Dalan94 and @elnull)
- you can now select an external editor in the settings that will be used
  instead of the default editor when you open a note file with `Open note in 
  external editor`
  (for [Issue #77](https://github.com/pbek/QOwnNotes/issues/77))
- added an option to disabled the app-heartbeat in the settings
  (for [Issue #84](https://github.com/pbek/QOwnNotes/issues/84))

## 1.0.2
- you can now set a note bookmark with `Ctrl + ⇧ + 0..9` on slot 0..9
  - use `Ctrl + 0..9` jump to the bookmark on slot 0..9
- fixed a markdown highlighting problem with certain characters like `»` and `·`
  (for [Issue #73](https://github.com/pbek/QOwnNotes/issues/73))
- added more German and Russian translation (thank you @calis2002 and @elnull)
- you can now disable the automatic update dialog in the settings
    - for self-build versions of QOwnNotes or versions from repositories 
      the automatic update dialog is disabled by default
- in any case you will get a flat button on the bottom right if there is an 
  update available

## 1.0.1
- added more German and Russian translation (thank you, @elnull)
- added a *Get involved* menu entry and a link in the update dialog
- added support for newlines in code blocks in the markdown highlighting
  (for [Issue #71](https://github.com/pbek/QOwnNotes/issues/71))

## 1.0
- yippee, **version 1.0**, so there were already 100 releases!?
    - want to get involved with QOwnNotes? read:
    [Getting involved](http://www.qownnotes.org/Knowledge-base/How-can-I-get-involved-with-QOwnNotes)
- updated German and Russian translation (thanks for your help, @elnull)
- fixed the visual blocking of the note search bar by the scroll bar
- the code font in the note Markdown view can now be configured in the settings
  (for [Issue #59](https://github.com/pbek/QOwnNotes/issues/59))

## 0.99
- implemented plural translations
  (for [Issue #65](https://github.com/pbek/QOwnNotes/issues/65))
- updated German translation
- added missing icons in dialogs
- added plural translations for English and German
- added **Russian translation** (a big thank you to @elnull!)
  (for [Issue #67](https://github.com/pbek/QOwnNotes/issues/67))
- the languages are now selectable in their native language
  (for [Issue #67](https://github.com/pbek/QOwnNotes/issues/67))
- add some links to knowledge base articles in the settings dialog

## 0.98
- made a workaround for the lacking OS X theming support, icons should work 
  again
- the search bar in the text edits now also uses themes

## 0.97
- I adopted the **AUR package** **`qownnotes`**, the repository 
  `qownnotes-pbek` will be discontinued (a big thank you to Midov for 
  managing `qownnotes` until now)
- QOwnNote now uses default **freedesktop theme icons**
  (for [Issue #39](https://github.com/pbek/QOwnNotes/issues/39))
  - if the operating system hasn't a theme set (like for Windows and OS X)
    there is a bundled fallback theme with Breeze icons that will be used 
  - this allows the usage of QOwnNotes with **dark system themes**

## 0.96
- fixed the debug output in the *Debug* settings tab
- you can now select a font for the code in the markdown enabled text edits
- you can now reset the fonts to the operating system's default font

## 0.95
- code in the Markdown edit now uses the `Courier` font
  (for [Issue #59](https://github.com/pbek/QOwnNotes/issues/59))
- the update checker was modified to fix a crash on OS X
- there now is a new *Interface* tab in the settings dialog to make room for 
  more configuration items
- there now is a new button in the *general settings*, that allows you to clear 
  all settings, remove the local todo database and exit QOwnNotes
  (for [Issue #56](https://github.com/pbek/QOwnNotes/issues/56))

## 0.94
- pressing `Delete` in the note list widget now attempts to remove all 
  selected notes, not just the current one
  (for [Issue #63](https://github.com/pbek/QOwnNotes/issues/63))
- canceling the update dialog now really cancels the update process like it 
  used to
- fixed a problem with a wrong note showing up after you change your note folder
  (for [Issue #60](https://github.com/pbek/QOwnNotes/issues/60))
  
## 0.93
- added more German translation by @calis2002
- attempted to fix a problem with removing multiple notes
- fixed a problem with two notes with the same name (but different extension) 
  showing up in the note list
- fixed a problem with empty entries in the recent note folders list 

## 0.92
- you can now choose to use `.md` instead of `.txt` as your default 
  file-extension for your notes in the settings
  (for [Issue #25](https://github.com/pbek/QOwnNotes/issues/25))
    - *ownCloud Notes* and *Cloudnotes* finally also support `.md` as 
      file-extension 
    - please try not to use `.md` and `.txt` notes with the same name
    - you have to update the ownCloud app `QOwnNotesAPI` to version 0.4.2 to
      make use of the `.md` support
- added more German translation for the new settings texts and added some 
  changes by @calis2002

## 0.91
- the OS X dmg and Ubuntu deb files, that are created by Travis CI now have 
  the version number in the filename
- the markdown view mode can now be selected as default view mode in the 
  settings (a big thank you to @dasmaetthes for the contribution)
- added **Chinese translation** by @LiangWei88, a big thank you!
- you can now select Chinese in the settings

## 0.90
- more strings made translatable and add **French translation** by @Dalan94, a 
  big thank you!
- added **Polish translation** by @Olhur, thank you a lot!
- you can now select the two new language in the settings

## 0.89
- you can now select the interface language in the settings
    - by default the system language will be used
    - the fallback language is English
- added **German translation** from @calis2002, thanks a lot for the great job!
- if you feel like translating QOwnNotes to an other language please read
 [How can I help to translate QOwnNotes?](http://www.qownnotes.org/Knowledge-base/How-can-I-help-to-translate-QOwnNotes)
- fixed a character in link titles that was disorienting the markdown 
  highlighter

## 0.88
- more app internationalization implementation and integration in deployment 
  systems (for [Issue #40](https://github.com/pbek/QOwnNotes/issues/40))
- start of German translation of QOwnNotes
    - please leave a message at the
    [QOwnNotes issues page](https://github.com/pbek/QOwnNotes/issues)
    if you want to help out with translation
- fixed a file watcher error on app startup
- the demo notes are now only created once instead of every time a notes folder
  is empty (for [Issue #41](https://github.com/pbek/QOwnNotes/issues/41))
- fixed a problem with an empty note in the note list
- fixed a problem with the note text after the last note was deleted in the 
  note list

## 0.87
- start of app internationalization implementation
  (for [Issue #40](https://github.com/pbek/QOwnNotes/issues/40))
- fixed a problem with the crypto key expiration of encrypted messages where one
  had to enter the password every minute while editing the note
  (for [Issue #42](https://github.com/pbek/QOwnNotes/issues/42))
    - now the crypto key will expire after 10min without editing the note
- did some fixes and layout changes in the settings dialog
- added basic app metrics
    - anonymous usage data helps to decide what parts of QOwnNotes to 
    improve next and to find and fix bugs
    - you can disable the app metrics in the settings

## 0.86
- tried to fix a sporadic crash on OS X
- there now is a software repository for **Debian Linux 8.0**
    - please visit the [QOwnNotes installation page](http://www.qownnotes.org/installation) for instructions

## 0.85
- you can now export the current note as markdown file
- beside the regular QOwnNotes software repository for Arch Linux there now 
  also is an official package on the **Arch User Repository** called 
 `qownnotes-pbek`

## 0.84
- now non Travis CI or AppVeyor builds can perform an update check again, but 
  will open the [QOwnNotes installation page](http://www.qownnotes.org/installation) 
  instead of downloading the app
- there is a new software repository for **Arch Linux**
    - please visit the [QOwnNotes installation page](http://www.qownnotes.org/installation) for instructions

## 0.83
- switched two buttons in the menu bar
- fixed a problem with updating and creating the todo list item database (for [Issue #35](https://github.com/pbek/QOwnNotes/issues/35))

## 0.82
- you are now able to open the current note in an external editor with `Ctrl + Shift + O`
- fixed a problem with editing encrypted notes while there are changes in the note directory
- you will now get a warning if you enter a wrong password when you are 
  decrypting a note
- the password dialog will now ask you for your password a 2nd time when 
  encrypting a note
- added more information to the debug output in the settings dialog

## 0.81
- fixed a problem where the password of an encrypted note was overwritten 
  while editing the encrypted note
    - **please decrypt your notes from v0.80 before upgrading to v0.81 or you 
    will not be able to decrypt them!**
- fixed a problem with encrypting empty notes
- crypto keys of encrypted notes will now expire after 10min, you will then 
  have to enter the password again

## 0.80
- the OSX build of QOwnNotes now uses Qt 5.5.1 to fix a few bugs
- fixed a few small issues in the todo list
- you are now able to **encrypt** and **decrypt** notes in QOwnNotes
    - you are also able to edit encrypted notes without the unencrypted note getting saved to disk
    - this functionality is still in alpha stage

## 0.79
- the search widget in the text edits will now move out of the way if it blocks the search result 
- some margin changes in the search widget were done and some key events were fixed
- you can now search for todo items in the todo list

## 0.78
- you are now able to configure the icon size of the main toolbar in the general settings
- you are now able to duplicate text with `Ctrl + Alt + Down` in all markdown edits
- searching for text is now possible in all markdown edits with `Ctrl + F`
- added a clear button to most of the text lines
- you can now jump to all visited note folders with a select box above the notes list (for [Issue #31](https://github.com/pbek/QOwnNotes/issues/31))
    - this select box is turned off by default and can be turned on in the general settings
- small margin tuning on the main screen

## 0.77
- the icon size in the main toolbar was set to a fixed `38x38` to try to prevent high-dpi problems in KDE Plasma
- `libqt5sql5-sqlite` was added to the dependencies for the Ubuntu PPA build and the Ubuntu deb-package (for [Issue #30](https://github.com/pbek/QOwnNotes/issues/30))
- if you don't want to miss a single version of QOwnNotes you might want to take a look at [New release version RSS feed](http://www.qownnotes.org/Blog/New-release-version-RSS-feed)

## 0.76
- the Windows version of QOwnNotes now also includes the OpenSSL library, please report if you have any problems on the [QOwnNotes issue page](https://github.com/pbek/QOwnNotes/issues))
- clicking links in all text edit boxes with markdown highlighting should work in the same way now

## 0.75
- added markdown highlighting to the debug information text box
- added link clicking support, 4 characters tab stops, custom font support and block indention to all markdown highlighting editors

## 0.74
- fixed another problem with todo lists if the server url contains a path (thanks again to Dirk for the report)

## 0.73
- fixed a bug with the todo list calendars if the server url had a path in it (a big thank you to Dirk for the report)
- more information was added to the debug information and you can now store it to a markdown file to help us finding problems
- pressing return in the summary text line of a todo item now saves it
- added basic markdown highlighting to the description edit field of the todo items

## 0.72
- fixed a crash that occurred when all notes were removed
- fixed a crash that occurred when all todo items were removed
- added a menu entry to show the changelog in the help menu
- fixed a design glitch with the visibility of the todo reminder date selector and some other user interface elements
- now a warning is issued if you want to open the todo lists, but haven't configured them yet
- fixed a bug where newly created todo list items were stored to the wrong todo list

## 0.71
- you are now able to print notes (text or markdown)
- reduced many margins in the main window to get more room
- you can now clear the recent note folders history in the settings (for [Issue #26](https://github.com/pbek/QOwnNotes/issues/26))
- you can now insert images in notes with `Ctrl+I`
    - the image will be copied to the `media` folder in the current notes folder
    - the image will be shown in the markdown view (maximum width is 980px)
    - the image is clickable in the edit view
- there now is a new debug tab in the settings dialog where you can find a dump of data you can use in an Issue on the [QOwnNotes issue page](https://github.com/pbek/QOwnNotes/issues))

## 0.70
- beside the new software repositories for **Ubuntu Linux** and **openSUSE Linux** there are now also repositories for **Fedora Linux**
    - please visit the [QOwnNotes installation page](http://www.qownnotes.org/installation) for instructions
- tried to fix a crash that sometimes occurs on OSX after waking from sleep
- you can now also export the text of notes as PDF

## 0.69
- if you are using **Ubuntu Linux** or **openSUSE Linux** you can now take advantage of the brand new repositories for both distributions
    - take a look at the [QOwnNotes installation page](http://www.qownnotes.org/installation) for instructions
    - the update check for these releases have been removed from the menu and you will not get a report for new software versions, since updates are done by your operating system
    - you can always visit the [QOwnNotes changelog](http://www.qownnotes.org/changelog/QOwnNotes) to see what has changed in the versions
- you can now export notes as PDF (for [Issue #23](https://github.com/pbek/QOwnNotes/issues/23))

## 0.68
- fixed a problem with creating new todo items after changing the enabled todo lists
- fixed a problem with newly created todo items that are set to completed
- fixed an other problem with storing todo items with a reminder and an empty description
- fixed some design glitches in the todo list
- if a todo item has no priority it now counts as medium priority
- added a button to reload the todo list from the server to the todo list dialog

## 0.67
- fixed a problem with storing todo items with a reminder and an empty description
- added a button to reinitialize the database to the settings dialog
- now a simple alert is shown when the reminder of a todo item is due

## 0.66
- fixed a problem with storing wrong todo list urls in the settings
- fixed the cursor after releasing the `Ctrl` key in the edit mode
- fixed troubles with storing new todo items
- you can now set a reminder date for todo items, this date will just be set on the server, QOwnNotes doesn't remind you (yet)
- added a menu bar button and a shortcut (`Ctrl + Shift + T`) for the todo list

## 0.65
- you are now able to create new todo items on your ownCloud server
- you are now able to delete todo items on your ownCloud server
- you are now able to mark todo items as done on your ownCloud server
- made a workaround for a server problem with *Calendar Plus* / *Tasks Plus*
- fixed the todo priorities according to [RFC2445](http://www.ietf.org/rfc/rfc2445.txt)

## 0.64
- fixed some network issues
- fixed a problem with `,` in todo list items
- fixed a problem with missing todo list items
- now a progress bar is shown while the todo list items are loaded from the server
- note: **Merry Christmas everyone**

## 0.63
- fixed some problems with special characters in todo list names
- the default todo item priority is now 0 (not set)
- todo items are now locally stored in a sqlite database and only updated from server if they were changed on the server
- vcalendar and vjournal items are now ignored when fetching items from the server, only vtodo items will be fetched

## 0.62
- you can now also use the todo items from the *Calendar Plus* / *Tasks Plus* ownCloud apps
    - select which backend you want to use in the todo settings
- you can now **save local changes** of existing **todo items** on your ownCloud calendar server
    - this functionality is in **alpha phase**, you may not want to use it in production yet
    - please report if you have any troubles with it

## 0.61
- only todo items (not calendar items) are now shown in your todo lists
- you can now choose to hide completed todo items at the todo list dialog
- the last selected todo list is now remembered at the todo list dialog
- the completed check for todo items was improved
- the note path error messages in the settings dialog are a bit more verbose now

## 0.60
- if the `Ctrl` key is pressed in the note text edit to click a link the mouse cursor is now a pointing hand
- you are now able to view your **ownCloud todo lists** (ownCloud tasks) in QOwnNotes (readonly so far)
    - you can setup which todo lists to view in the new *todo* tab in the settings dialog

## 0.59
- an *Insert current time* button was added to the toolbar so that the feature also works in Gnome on GNU/Linux
- the markdown view also supports tables now (for [Issue #20](https://github.com/pbek/QOwnNotes/issues/20))

## 0.58
- fixed a problem with linking notes with special characters in their name (everything but charactes and numbers)
- html entities from the titles of inserted links are now decoded
- whitespaces are now trimmed from the start and end of the title of inserted links
- you can now select a local file to link to in the link dialog
- added a new shortcut `Ctrl + T` to insert the current date in ISO 8601 format

## 0.57
- `Ctrl + Click` in edit mode now works on the whole portion of links like `[QOwnNotes - cross-platform open source notepad](http://www.qownnotes.org/)`, not just on the URL alone
- added a menu entry to the new knowledge base in the help menu
- you can now change the font of the note text edit and the note markdown view in the settings (for [Issue #19](https://github.com/pbek/QOwnNotes/issues/19))

## 0.56
- added a shortcut list to the help menu and to the startup notes
- you can now also link to URLs with `Ctrl + L` (or `Cmd + L` on OSX), if possible the title of the webpage will be fetched and used as link text

## 0.55
- added some different shortcuts for the note history on the mac
- tried to fix the duplicate line shortcut for the Ubuntu Unity desktop
- the OSX package is now code signed (but there are still some troubles with the signature)

## 0.54
- fixed a problem with canceling the notes folder selection dialog
- the note history is now cleared when switching to an other notes directory
- when moving forward and back in the note history the search field will be cleared so that all notes are visible

## 0.53
- fixed a problem that the note list did not get reloaded after the current note was renamed
- you can now jump back and forward to your last used notes with *Alt+left/right* and the *back* and *forward* mouse buttons
- you can now press *Shift+tab* to remove tabs even if nothing was selected

## 0.52
- notes will now be parsed for markdown highlighting immediately after a note was selected instead of waiting up to 1 second
- added functionality to duplicate the selected text or the current line (shortcut: *Ctrl+D*)
- it is  now (after quite some work) possible to *Ctrl+click* links to open them in the note edit mode
- you now can indent and unindent the selected text with the *Tab* and *Shift+Tab* keys
- the current note name now shows up in the window title

## 0.51
- fixed the flickering in the note list, that could happen when you edit the current note
- fixed a redraw error that could happen after storing the settings in the settings dialog
- fixed the note storing interval time (it was set far too low in version 0.50)

## 0.50
- the link color in the markdown view was a bit darkened
- the *externally modified* dialog isn't shown any more by default when the current note wasn't edited for a minute
    - this behaviour can be changed in the settings dialog
    - feel free to contact me if you have thoughts on that
- you are now able to set the note save interval time in the settings dialog
    - default is still 10 seconds

## 0.49
- added some markdown view styling
- more improvements in the current note search feature
- the position of the menu bar will now be stored and will be restored when the application starts
- about dialog styling changes and link fixup

## 0.48
- lots of improvements in the current note search feature
- added more shortcuts

## 0.47
- added the ability to search in the current note
- OSX builds are finally made on Travis CI too
- added some new icons

## 0.46
- improved some error messages
- added some more items to the main menu (so that Ubuntu's unity desktop recognizes the shortcuts)

## 0.45
- making sure the welcome note is selected after it was created
- added the ability to link the selected text to a note or create a link to a note at the current cursor position in markdown
- there is a new dialog to search for notes to link to

## 0.44
- added more explanations in the settings dialog
- added a check if the notes path was found on the server in the settings dialog (needs QOwnNotesAPI v0.4.1)

## 0.43
- added functionality to restore a trashed note directly on the ownCloud server, restoring the note's versions with it. (needs QOwnNotesAPI v0.4)
- updating to QOwnNotesAPI v0.4 is suggested, because it also contains two important bugfixes for the trashed notes api
- fixed a bug when the ownCloud path and the notes path are the same
- added write permissions to the demo notes
- note editing is now disallowed if note file is read only
- some improvements on storing notes to disk

## 0.42.1
- fixed a missing svg

## 0.42
- improvements and fixes in the settings connection troubleshooter
- minimum QOwnNotesAPI version is now detected
- detection for ownCloud core apps "Versions" and "Deleted files" (needs QOwnNotesAPI v0.3.1)
- you can open your ownCLoud server Apps page from the settings dialog

## 0.41
- added an interactive ownCloud server connection troubleshooting helper and other improvements to the settings page
- added a better connection error handling
- some menu restructuring
- added the ability to select all notes
- the current notes folder isn't shown in the recent notes folders any more
- some message box text styling
- notes are now restored from trash with their original name if their names are not taken

## 0.40
- you now are able to select multiple notes and remove them or copy/move them to a recent note folder
- fixed a possible crash with empty note files

## 0.39
- turned on native file dialogs again
- some text changes and svg image fixes
- added an automatic update check every 6h
- you now are able to skip an update, no more update notifications as long there is no new update

## 0.38
- you will now start with some demo notes if your notes directory is empty
- settings dialog improvements
- added some icons and made some minor layout changes

## 0.37
- trashed notes can now be viewed and restored from your ownCloud server
    - please install QOwnNotesAPI v0.3 for trash support

## 0.36
- fixed a problem with the OSX build

## 0.35
- added information text for Windows users to install OpenSSL
- added more detailed network connection error messages
- fixed a problem with Windows 8.1

## 0.34
- old versions of your notes can now be restored from your ownCloud server
- introduced a settings page
- fixed a text
- OSX: QOwnNotes.dmg is now compressed and includes a symbolic link to the *Applications* folder

## 0.33
- fixed a bug where quitting the app didn't store the settings
- sorting support (thank you pmarki)
- system tray support (thank you pmarki)

## 0.32
- added a help menu entry to report problems or ideas
- fixed problems with file dialogs by using the QT file dialog
- fixed the crash that can happen on the first start of the application after choosing the notes directory

## 0.31
- implemented an update service to check if a new version of QOwnNotes is available
- the update check will be performed automatically at the start of the application and can be performed manually in the menu

## 0.30
- help screen improvements
- added version number to build number

## 0.29
- fixed a problem with disappearing newlines

## 0.28
- more utf-8 fixes
- icons for Windows 8.1.

## 0.27
- added a character set fix for Windows

## 0.26
- updated hoedown to 3.0.3

## 0.25
- brings better url handling in the markdown preview mode.
- links to other notes or files are now possible

## 0.24
- added a "recent note folder list" feature

## 0.23
- fixed a crash when opening empty note-files

## 0.21
- clickable links in markdown html preview

## 0.20
- fixes for the Linux package

## 0.19
- Markdown HTML preview
- menu - toolbar

## 0.18
- fixed some troubles with the Windows package
- added a hotkey to create new note with date in name
- turned off pasting of rich text in the note text edit box to avoid troubles
