Important Shortcuts
===================

## Linux / Windows

### In the main window

- <kbd>Ctrl</kbd> + <kbd>N</kbd> creates a new note with the current date and time in the name
- <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>F</kbd> lets you search for notes (in the name of the note and its content)
- <kbd>Alt</kbd> + <kbd>F</kbd> lets you search for notes in all tags / subfolders
- <kbd>Alt</kbd> + <kbd>⇧</kbd> + <kbd>P</kbd> switches to the previous workspace
- <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>E</kbd> edits an encrypted note
- <kbd>Alt</kbd> + <kbd>R</kbd> removes the current note
- <kbd>Alt</kbd> + <kbd>⇧</kbd> + <kbd>U</kbd> checks for updates
- <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>T</kbd> opens the todo list
- <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>O</kbd> opens the current note in an external editor
- <kbd>Alt</kbd> + <kbd>⇧</kbd> + <kbd>O</kbd> opens the current note in a view
- <kbd>Alt</kbd> + <kbd>⇧</kbd> + <kbd>F</kbd> shows the current note in the file manager
- <kbd>Alt</kbd> + <kbd>⇧</kbd> + <kbd>E</kbd> enables or disables editing of notes
- <kbd>Alt</kbd> + <kbd>Up</kbd> jumps to the previous visible note
    - alternate shortcut is <kbd>Ctrl</kbd> + <kbd>PgUp</kbd>
- <kbd>Alt</kbd> + <kbd>Down</kbd> jumps to the next visible note
    - alternate shortcut is <kbd>Ctrl</kbd> + <kbd>PgDown</kbd>
- <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>D</kbd> toggles the distraction free mode
    - you can also close it with <kbd>Esc</kbd>
- <kbd>Ctrl</kbd> + <kbd>P</kbd> prints the current note as text
- <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>P</kbd> prints the current note as markdown
- <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>V</kbd> pastes notes, images and html from the clipboard
- <kbd>Ctrl</kbd> + <kbd>,</kbd> opens the settings
- <kbd>Alt</kbd> + <kbd>⇧</kbd> + <kbd>A</kbd> adds a new tag to a note
- <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>R</kbd> reloads the current note folder 
- <kbd>Ctrl</kbd> + <kbd>Alt</kbd> + <kbd>F</kbd> lets you select a different note folder
- <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>S</kbd> reloads the scripting engine 
- <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>M</kbd> hides or shows the main menu bar
- <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>A</kbd> lets you search for actions
- <kbd>Ctrl</kbd> + <kbd>S</kbd> manually saves modified notes
- <kbd>Alt</kbd> + <kbd>⇧</kbd> + <kbd>I</kbd> opens the Script repository dialog

### In the note search bar

- <kbd>Down</kbd> or <kbd>Tab</kbd> sets the focus to the note list
- <kbd>Return</kbd> creates a new note with the text from the search bar as 
  headline

### In the note list

- <kbd>Ctrl</kbd> + <kbd>A</kbd> selects all notes (to move, copy or remove them with a right click)
- <kbd>Tab</kbd> or <kbd>Return</kbd> lets you edit the current note

### In the note text edit panel

- <kbd>Ctrl</kbd> + <kbd>Click</kbd> on a link to open it
- <kbd>Ctrl</kbd> + <kbd>F</kbd> lets you search in the current note
    - use the <kbd>Up</kbd> and <kbd>Down</kbd> keys or <kbd>F3</kbd> and 
      <kbd>⇧</kbd> + <kbd>F3</kbd> keys to jump to the previous and next matches
    - <kbd>Esc</kbd> closes the search bar
- <kbd>Ctrl</kbd> + <kbd>R</kbd> lets you search and replace in the current note
- <kbd>Ctrl</kbd> + <kbd>D</kbd> duplicates the current line or the selected text
    - <kbd>Ctrl</kbd> + <kbd>Alt</kbd> + <kbd>Down</kbd> does the same
- <kbd>Alt</kbd> + <kbd>Backspace</kbd> deletes the current line
- <kbd>Ctrl</kbd> + <kbd>Backspace</kbd> deletes the current word
- <kbd>Ctrl</kbd> + <kbd>L</kbd> opens a dialog to add a link to an other note or an URL (also works on selected text)
- <kbd>Ctrl</kbd> + <kbd>T</kbd> inserts the current date in ISO 8601 format
- <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>I</kbd> inserts an image (the image will be copied to the `media` folder in the current notes folder)
- <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>E</kbd> inserts an attachment (the file will be copied to the `attachments` folder in the current notes folder)
- <kbd>Alt</kbd> + <kbd>⇧</kbd> + <kbd>T</kbd> inserts a table
- <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>C</kbd> inserts a code block at the current position
- <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>B</kbd> inserts a block quote at the current position
- <kbd>Ctrl</kbd> + <kbd>B</kbd> formats the selected text bold 
- <kbd>Ctrl</kbd> + <kbd>I</kbd> formats the selected text italic 
- <kbd>Alt</kbd> + <kbd>⇧</kbd> + <kbd>S</kbd> strikes out the selected text
- <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>U</kbd> cycles through the cases of the selected text
- <kbd>Tab</kbd> indents the selected text (also works on multiple lines)
    - <kbd>⇧</kbd> + <kbd>Tab</kbd> un-indents the selected text
- <kbd>Tab</kbd> after an unordered list character indents the list item
    - <kbd>⇧</kbd> + <kbd>Tab</kbd> after an unordered list character 
      un-indents the list item
- <kbd>Return</kbd> in lists creates a new list item
- <kbd>Alt</kbd> + <kbd>Left</kbd> jumps back in the note history
    - <kbd>Alt</kbd> + <kbd>Right</kbd> jumps forward in the note history
- <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>0..9</kbd> sets a note bookmark on bookmark slot 0..9
- <kbd>Ctrl</kbd> + <kbd>0..9</kbd> jumps to the note bookmark on bookmark slot 0..9
- <kbd>Ctrl</kbd> + <kbd>+</kbd> increases the note text font size by one point
- <kbd>Ctrl</kbd> + <kbd>-</kbd> decreases the note text font size by one point
- <kbd>Ctrl</kbd> + <kbd>/</kbd> resets the note text font size
- <kbd>Ctrl</kbd> + <kbd>Space</kbd> tries to solve simple equations like `(4+5)*3=` in front of the cursor, auto-completes text or opens urls
- <kbd>Ctrl</kbd> + <kbd>⇧</kbd> + <kbd>H</kbd> inserts a headline from the note filename at the top of the note
- <kbd>Alt</kbd> + <kbd>⇧</kbd> + <kbd>X</kbd> splits the current note into two notes at the current cursor position
- <kbd>Alt</kbd> + <kbd>⇧</kbd> + <kbd>W</kbd> searches for the selected text on the web

### In the note preview panel

- <kbd>Ctrl</kbd> + <kbd>F</kbd> lets you search in the current note
    - use the <kbd>Up</kbd> and <kbd>Down</kbd> keys or <kbd>F3</kbd> and 
      <kbd>⇧</kbd> + <kbd>F3</kbd> keys to jump to the previous and next matches
    - <kbd>Esc</kbd> closes the search bar

### In the Todo list

- <kbd>Ctrl</kbd> + <kbd>S</kbd> saves the current todo item
- <kbd>Ctrl</kbd> + <kbd>I</kbd> saves the current todo item and inserts in into the current note
- <kbd>Ctrl</kbd> + <kbd>R</kbd> removes the current todo item


## macOS

### In the main window

- <kbd>⌘</kbd> + <kbd>N</kbd> creates a new note with the current date and time in the name
- <kbd>⌘</kbd> + <kbd>⇧</kbd> + <kbd>F</kbd> lets you search for notes (in the name of the note and its content)
- <kbd>Opt</kbd> + <kbd>F</kbd> lets you search for notes in all tags / subfolders
- <kbd>Opt</kbd> + <kbd>⇧</kbd> + <kbd>P</kbd> switches to the previous workspace
- <kbd>⌘</kbd> + <kbd>⇧</kbd> + <kbd>E</kbd> edits an encrypted note
- <kbd>Opt</kbd> + <kbd>R</kbd> removes the current note
- <kbd>Opt</kbd> + <kbd>⇧</kbd> + <kbd>U</kbd> checks for updates
- <kbd>⌘</kbd> + <kbd>⇧</kbd> + <kbd>T</kbd> opens the todo list
- <kbd>⌘</kbd> + <kbd>⇧</kbd> + <kbd>O</kbd> opens the current note in an external editor
- <kbd>Opt</kbd> + <kbd>⇧</kbd> + <kbd>O</kbd> opens the current note in a view
- <kbd>Opt</kbd> + <kbd>⇧</kbd> + <kbd>F</kbd> opens the folder of the current note in Finder
- <kbd>Opt</kbd> + <kbd>⇧</kbd> + <kbd>E</kbd> enables or disables editing of notes
- <kbd>Opt</kbd> + <kbd>Up</kbd> jumps to the previous visible note
    - alternate shortcut is <kbd>⌘</kbd> + <kbd>PgUp</kbd>
- <kbd>Opt</kbd> + <kbd>Down</kbd> jumps to the next visible note
    - alternate shortcut is <kbd>⌘</kbd> + <kbd>PgDown</kbd>
- <kbd>⌘</kbd> + <kbd>⇧</kbd> + <kbd>D</kbd> toggles the distraction free mode
    - you can also close it with <kbd>Esc</kbd>
- <kbd>⌘</kbd> + <kbd>P</kbd> prints the current note as text
- <kbd>⌘</kbd> + <kbd>⇧</kbd> + <kbd>P</kbd> prints the current note as markdown
- <kbd>⌘</kbd> + <kbd>Opt</kbd> + <kbd>V</kbd> pastes notes, images and html from the clipboard
- <kbd>⌘</kbd> + <kbd>,</kbd> opens the settings
- <kbd>Opt</kbd> + <kbd>⇧</kbd> + <kbd>A</kbd> adds a new tag to a note
- <kbd>⌘</kbd> + <kbd>⇧</kbd> + <kbd>R</kbd> reloads the current note folder 
- <kbd>⌘</kbd> + <kbd>Opt</kbd> + <kbd>F</kbd> lets you select a different note folder
- <kbd>⌘</kbd> + <kbd>⇧</kbd> + <kbd>S</kbd> reloads the scripting engine 
- <kbd>⌘</kbd> + <kbd>⇧</kbd> + <kbd>M</kbd> hides or shows the main menu bar
- <kbd>⌘</kbd> + <kbd>⇧</kbd> + <kbd>A</kbd> lets you search for actions
- <kbd>⌘</kbd> + <kbd>S</kbd> manually saves modified notes
- <kbd>Opt</kbd> + <kbd>⇧</kbd> + <kbd>I</kbd> opens the Script repository dialog

### In the note search bar

- <kbd>Down</kbd> or <kbd>Tab</kbd> sets the focus to the note list
- <kbd>Return</kbd> creates a new note with the text from the search bar as 
  headline

### In the note list

- <kbd>⌘</kbd> + <kbd>A</kbd> selects all notes (to move, copy or remove them with a right click)
- <kbd>Tab</kbd> or <kbd>Return</kbd> lets you edit the current note

### In the note text edit panel

- <kbd>⌘</kbd> + <kbd>Click</kbd> on a link to open it
- <kbd>⌘</kbd> + <kbd>F</kbd> lets you search in the current note
    - use the <kbd>Up</kbd> and <kbd>Down</kbd> keys or <kbd>F3</kbd> and 
      <kbd>⇧</kbd> + <kbd>F3</kbd> keys to jump to the previous and next matches
    - <kbd>Esc</kbd> closes the search bar
- <kbd>⌘</kbd> + <kbd>R</kbd> lets you search and replace in the current note
- <kbd>⌘</kbd> + <kbd>D</kbd> duplicates the current line or the selected text
    - <kbd>⌘</kbd> + <kbd>Opt</kbd> + <kbd>Down</kbd> does the same
- <kbd>⌘</kbd> + <kbd>Backspace</kbd> deletes the current line
- <kbd>Opt</kbd> + <kbd>Backspace</kbd> deletes the current word
- <kbd>⌘</kbd> + <kbd>L</kbd> opens a dialog to add a link to an other note or an URL (also works on selected text)
- <kbd>⌘</kbd> + <kbd>T</kbd> inserts the current date in ISO 8601 format
- <kbd>⌘</kbd> + <kbd>⇧</kbd> + <kbd>I</kbd> inserts an image (the image will be copied to the `media` folder in the current notes folder)
- <kbd>⌘</kbd> + <kbd>⇧</kbd> + <kbd>E</kbd> inserts an attachment (the file will be copied to the `attachments` folder in the current notes folder)
- <kbd>Opt</kbd> + <kbd>⇧</kbd> + <kbd>T</kbd> inserts a table
- <kbd>⌘</kbd> + <kbd>⇧</kbd> + <kbd>C</kbd> inserts a code block at the current position
- <kbd>⌘</kbd> + <kbd>⇧</kbd> + <kbd>B</kbd> inserts a block quote at the current position
- <kbd>⌘</kbd> + <kbd>B</kbd> formats the selected text bold 
- <kbd>⌘</kbd> + <kbd>I</kbd> formats the selected text italic 
- <kbd>Opt</kbd> + <kbd>⇧</kbd> + <kbd>S</kbd> strikes out the selected text
- <kbd>⌘</kbd> + <kbd>⇧</kbd> + <kbd>U</kbd> cycles through the cases of the selected text
- <kbd>Tab</kbd> indents the selected text (also works on multiple lines)
    - <kbd>⇧</kbd> + <kbd>Tab</kbd> un-indents the selected text
- <kbd>Tab</kbd> after an unordered list character indents the list item
    - <kbd>⇧</kbd> + <kbd>Tab</kbd> after an unordered list character 
      un-indents the list item
- <kbd>Return</kbd> in lists creates a new list item
- <kbd>⌘</kbd> + <kbd>Opt</kbd> + <kbd>Left</kbd> jumps back in the note history
    - <kbd>⌘</kbd> + <kbd>Opt</kbd> + <kbd>Right</kbd> jumps forward in the note history
- <kbd>⌘</kbd> + <kbd>⇧</kbd> + <kbd>0..9</kbd> sets a note bookmark on bookmark slot 0..9
- <kbd>⌘</kbd> + <kbd>0..9</kbd> jumps to the note bookmark on bookmark slot 0..9
- <kbd>⌘</kbd> + <kbd>+</kbd> increases the note text font size by one point
- <kbd>⌘</kbd> + <kbd>-</kbd> decreases the note text font size by one point
- <kbd>⌘</kbd> + <kbd>/</kbd> resets the note text font size
- <kbd>⌘</kbd> + <kbd>Space</kbd> tries to solve simple equations like `(4+5)*3=` in the current line in front of the cursor, auto-completes text or opens urls
- <kbd>⌘</kbd> + <kbd>⇧</kbd> + <kbd>H</kbd> inserts a headline from the note filename at the top of the note
- <kbd>Opt</kbd> + <kbd>⇧</kbd> + <kbd>X</kbd> splits the current note into two notes at the current cursor position
- <kbd>Opt</kbd> + <kbd>⇧</kbd> + <kbd>W</kbd> searches for the selected text on the web

### In the note preview panel

- <kbd>⌘</kbd> + <kbd>F</kbd> lets you search in the current note
    - use the <kbd>Up</kbd> and <kbd>Down</kbd> keys or <kbd>F3</kbd> and 
      <kbd>⇧</kbd> + <kbd>F3</kbd> keys to jump to the previous and next matches
    - <kbd>Esc</kbd> closes the search bar

### In the Todo list

- <kbd>⌘</kbd> + <kbd>S</kbd> saves the current todo item
- <kbd>⌘</kbd> + <kbd>I</kbd> saves the current todo item and inserts in into the current note
- <kbd>⌘</kbd> + <kbd>R</kbd> removes the current todo item
