/**************************************************************************
**
** This file is part of Qt Creator
**
** Copyright (c) 2011 Nokia Corporation and/or its subsidiary(-ies).
**
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** No Commercial Usage
**
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
**
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**************************************************************************/

#ifndef UTILS_ENVIRONMENT_H
#define UTILS_ENVIRONMENT_H

#include "utils_global.h"

#include <QtCore/QString>
#include <QtCore/QStringList>
#include <QtCore/QMap>
#include <QtCore/QList>

namespace Utils {

class QTCREATOR_UTILS_EXPORT EnvironmentItem
{
public:
    EnvironmentItem(QString n, QString v)
            : name(n), value(v), unset(false)
    {}

    QString name;
    QString value;
    bool unset;

    bool operator==(const EnvironmentItem &other)
    {
        return (unset == other.unset) && (name == other.name) && (value == other.value);
    }

    static QList<EnvironmentItem> fromStringList(QStringList list);
    static QStringList toStringList(QList<EnvironmentItem> list);
};

class QTCREATOR_UTILS_EXPORT Environment {
public:
    typedef QMap<QString, QString>::const_iterator const_iterator;

    Environment();
    explicit Environment(QStringList env);
    static Environment systemEnvironment();

    QStringList toStringList() const;
    QString value(const QString &key) const;
    void set(const QString &key, const QString &value);
    void unset(const QString &key);
    void modify(const QList<EnvironmentItem> & list);
    bool hasKey(const QString &key);

    void appendOrSet(const QString &key, const QString &value, const QString &sep = QString());
    void prependOrSet(const QString &key, const QString &value, const QString &sep = QString());

    void appendOrSetPath(const QString &value);
    void prependOrSetPath(const QString &value);

    void clear();
    int size() const;

    Environment::const_iterator find(const QString &name);
    QString key(Environment::const_iterator it) const;
    QString value(Environment::const_iterator it) const;

    Environment::const_iterator constBegin() const;
    Environment::const_iterator constEnd() const;

    QString searchInPath(const QString &executable,
                         const QStringList & additionalDirs = QStringList()) const;
    QStringList path() const;

    static QStringList parseCombinedArgString(const QString &program);
    static QString joinArgumentList(const QStringList &arguments);

    QString expandVariables(const QString &) const;
    QStringList expandVariables(const QStringList &) const;

    bool operator!=(const Environment &other) const;
    bool operator==(const Environment &other) const;
private:
    QMap<QString, QString> m_values;
};

} // namespace Utils

#endif // UTILS_ENVIRONMENT_H
