/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFileList.h"

#include "ExceptionCode.h"
#include "File.h"
#include "FileList.h"
#include "JSFile.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSFileList);

/* Hash table */

static const HashTableValue JSFileListTableValues[3] =
{
    { "length", DontDelete|ReadOnly, (intptr_t)jsFileListLength, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsFileListConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSFileListTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSFileListTableValues, 0 };
#else
    { 5, 3, JSFileListTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSFileListConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSFileListConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSFileListConstructorTableValues, 0 };
#else
    { 1, 0, JSFileListConstructorTableValues, 0 };
#endif

class JSFileListConstructor : public DOMConstructorObject {
public:
    JSFileListConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSFileListConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSFileListPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags)); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSFileListConstructor::s_info = { "FileListConstructor", 0, &JSFileListConstructorTable, 0 };

bool JSFileListConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSFileListConstructor, DOMObject>(exec, &JSFileListConstructorTable, this, propertyName, slot);
}

bool JSFileListConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSFileListConstructor, DOMObject>(exec, &JSFileListConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSFileListPrototypeTableValues[2] =
{
    { "item", DontDelete|Function, (intptr_t)jsFileListPrototypeFunctionItem, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSFileListPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSFileListPrototypeTableValues, 0 };
#else
    { 2, 1, JSFileListPrototypeTableValues, 0 };
#endif

const ClassInfo JSFileListPrototype::s_info = { "FileListPrototype", 0, &JSFileListPrototypeTable, 0 };

JSObject* JSFileListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSFileList>(exec, globalObject);
}

bool JSFileListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSFileListPrototypeTable, this, propertyName, slot);
}

bool JSFileListPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSFileListPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSFileList::s_info = { "FileList", 0, &JSFileListTable, 0 };

JSFileList::JSFileList(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<FileList> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSFileList::~JSFileList()
{
    forgetDOMObject(this, impl());
}

JSObject* JSFileList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSFileListPrototype(JSFileListPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSFileList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = JSFileListTable.entry(exec, propertyName);
    if (entry) {
        slot.setCustom(this, entry->propertyGetter());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<FileList*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSFileList, Base>(exec, &JSFileListTable, this, propertyName, slot);
}

bool JSFileList::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    const HashEntry* entry = JSFileListTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(this, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<FileList*>(impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(this, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSFileList, Base>(exec, &JSFileListTable, this, propertyName, descriptor);
}

bool JSFileList::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<FileList*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue jsFileListLength(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSFileList* castedThis = static_cast<JSFileList*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    FileList* imp = static_cast<FileList*>(castedThis->impl());
    return jsNumber(exec, imp->length());
}

JSValue jsFileListConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSFileList* domObject = static_cast<JSFileList*>(asObject(slot.slotBase()));
    return JSFileList::getConstructor(exec, domObject->globalObject());
}
void JSFileList::getOwnPropertyNames(ExecState* exec, PropertyNameArray& propertyNames)
{
    for (unsigned i = 0; i < static_cast<FileList*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(exec, propertyNames);
}

JSValue JSFileList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFileListConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsFileListPrototypeFunctionItem(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSFileList::s_info))
        return throwError(exec, TypeError);
    JSFileList* castedThisObj = static_cast<JSFileList*>(asObject(thisValue));
    FileList* imp = static_cast<FileList*>(castedThisObj->impl());
    int index = args.at(0).toInt32(exec);
    if (index < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return jsUndefined();
    }


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->item(index)));
    return result;
}


JSValue JSFileList::indexGetter(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSFileList* thisObj = static_cast<JSFileList*>(asObject(slot.slotBase()));
    return toJS(exec, thisObj->globalObject(), static_cast<FileList*>(thisObj->impl())->item(slot.index()));
}
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, FileList* object)
{
    return getDOMObjectWrapper<JSFileList>(exec, globalObject, object);
}
FileList* toFileList(JSC::JSValue value)
{
    return value.inherits(&JSFileList::s_info) ? static_cast<JSFileList*>(asObject(value))->impl() : 0;
}

}
