/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the QtOpenGL module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial Usage
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef FRAGMENTPROGRAMS_P_H
#define FRAGMENTPROGRAMS_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

enum FragmentVariable {
    VAR_BRUSH_TEXTURE,
    VAR_LINEAR,
    VAR_INV_MATRIX_M1,
    VAR_INV_MASK_SIZE,
    VAR_INV_MATRIX_M2,
    VAR_PORTERDUFF_AB,
    VAR_MASK_CHANNEL,
    VAR_ELLIPSE_OFFSET,
    VAR_PORTERDUFF_XYZ,
    VAR_INV_DST_SIZE,
    VAR_MASK_TEXTURE,
    VAR_DST_TEXTURE,
    VAR_PALETTE,
    VAR_MASK_OFFSET,
    VAR_INV_BRUSH_TEXTURE_SIZE,
    VAR_FMP2_M_RADIUS2,
    VAR_FMP,
    VAR_INV_MATRIX_M0,
    VAR_ANGLE
};

enum FragmentBrushType {
    FRAGMENT_PROGRAM_BRUSH_SOLID,
    FRAGMENT_PROGRAM_BRUSH_RADIAL,
    FRAGMENT_PROGRAM_BRUSH_CONICAL,
    FRAGMENT_PROGRAM_BRUSH_LINEAR,
    FRAGMENT_PROGRAM_BRUSH_TEXTURE,
    FRAGMENT_PROGRAM_BRUSH_PATTERN
};

enum FragmentCompositionModeType {
    COMPOSITION_MODES_SIMPLE_PORTER_DUFF,
    COMPOSITION_MODES_MULTIPLY,
    COMPOSITION_MODES_SCREEN,
    COMPOSITION_MODES_OVERLAY,
    COMPOSITION_MODES_DARKEN,
    COMPOSITION_MODES_LIGHTEN,
    COMPOSITION_MODES_COLORDODGE,
    COMPOSITION_MODES_COLORBURN,
    COMPOSITION_MODES_HARDLIGHT,
    COMPOSITION_MODES_SOFTLIGHT,
    COMPOSITION_MODES_DIFFERENCE,
    COMPOSITION_MODES_EXCLUSION,
    COMPOSITION_MODES_SIMPLE_PORTER_DUFF_NOMASK,
    COMPOSITION_MODES_MULTIPLY_NOMASK,
    COMPOSITION_MODES_SCREEN_NOMASK,
    COMPOSITION_MODES_OVERLAY_NOMASK,
    COMPOSITION_MODES_DARKEN_NOMASK,
    COMPOSITION_MODES_LIGHTEN_NOMASK,
    COMPOSITION_MODES_COLORDODGE_NOMASK,
    COMPOSITION_MODES_COLORBURN_NOMASK,
    COMPOSITION_MODES_HARDLIGHT_NOMASK,
    COMPOSITION_MODES_SOFTLIGHT_NOMASK,
    COMPOSITION_MODES_DIFFERENCE_NOMASK,
    COMPOSITION_MODES_EXCLUSION_NOMASK,
    COMPOSITION_MODE_BLEND_MODE_MASK,
    COMPOSITION_MODE_BLEND_MODE_NOMASK
};

enum FragmentMaskType {
    FRAGMENT_PROGRAM_MASK_TRAPEZOID_AA,
    FRAGMENT_PROGRAM_MASK_ELLIPSE_AA
};

static const unsigned int num_fragment_variables = 19;

static const unsigned int num_fragment_brushes = 6;
static const unsigned int num_fragment_composition_modes = 26;
static const unsigned int num_fragment_masks = 2;

static const char *FragmentProgram_FRAGMENT_PROGRAM_MASK_TRAPEZOID_AA =
    "!!ARBfp1.0\n"
    "PARAM c[1] = { { 0.5, 2 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "ADD R3.z, fragment.position.x, c[0].x;\n"
    "ADD R0.y, fragment.position, -c[0].x;\n"
    "MAX R4.x, fragment.texcoord[0].y, R0.y;\n"
    "ADD R0.x, fragment.position.y, c[0];\n"
    "MIN R3.w, R0.x, fragment.texcoord[0].x;\n"
    "ADD R2.z, fragment.position.x, -c[0].x;\n"
    "MOV R2.w, R3.z;\n"
    "MOV R0.yw, R4.x;\n"
    "MOV R0.xz, R3.w;\n"
    "MAD R0, fragment.texcoord[1].xxzz, R0, fragment.texcoord[1].yyww;\n"
    "MAD R0.zw, fragment.position.x, c[0].y, -R0;\n"
    "MOV R2.x, R0;\n"
    "MOV R2.y, R0.z;\n"
    "MOV R1.w, R0;\n"
    "MOV R1.z, R0.y;\n"
    "MIN R1.xy, R2, R1.zwzw;\n"
    "SGE R0.xy, R1.zwzw, R2;\n"
    "ADD R0.zw, -fragment.texcoord[0], -fragment.texcoord[0];\n"
    "MAD R3.xy, R0, R0.zwzw, fragment.texcoord[0].zwzw;\n"
    "ADD R0, -R1.xxyy, R2.zwzw;\n"
    "MAD R0, R0, R3.xxyy, R4.x;\n"
    "ADD R3.xy, R0.ywzw, R0.xzzw;\n"
    "ADD R4.zw, R3.w, -R0.xyxz;\n"
    "ADD R0.zw, -R4.x, R0.xyyw;\n"
    "ADD R0.xy, R3.z, -R1;\n"
    "MAX R1.zw, R2.xyxy, R1;\n"
    "MUL R0.xy, R0, R0.zwzw;\n"
    "MAD R3.xy, -R3, c[0].x, R3.w;\n"
    "ADD R2.w, R3.z, -R2.z;\n"
    "MUL R2.xy, R3, R2.w;\n"
    "ADD R2.w, R3, -R4.x;\n"
    "ADD R3.xy, -R2.z, R1.zwzw;\n"
    "MUL R3.xy, R4.zwzw, R3;\n"
    "ADD R4.zw, R1.xyxy, R1;\n"
    "MAD R0.zw, R4, c[0].x, -R2.z;\n"
    "MAD R0.xy, -R0, c[0].x, R2.w;\n"
    "MAD R4.zw, R0, R2.w, -R0.xyxy;\n"
    "SGE R0.zw, R3.z, R1;\n"
    "MAD R0.xy, R0.zwzw, R4.zwzw, R0;\n"
    "MAD R3.xy, R3, c[0].x, -R2;\n"
    "MAD R0.zw, R0, R3.xyxy, R2.xyxy;\n"
    "ADD R2.xy, R0.zwzw, -R0;\n"
    "SGE R0.zw, R2.z, R1.xyxy;\n"
    "MAD R0.xy, R0.zwzw, R2, R0;\n"
    "SGE R0.zw, R1, R2.z;\n"
    "ADD R0.xy, R0, -R2.w;\n"
    "SGE R1.xy, R3.z, R1;\n"
    "MAD R0.xy, R1, R0, R2.w;\n"
    "MAD R0.x, -R0, R0.z, R2.w;\n"
    "SGE R0.z, R3.w, R4.x;\n"
    "MAD R0.x, -R0.y, R0.w, R0;\n"
    "MUL result.color, R0.x, R0.z;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_MASK_ELLIPSE_AA =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..3],\n"
    "		{ -2, 1, -0.5, 2 },\n"
    "		{ 3 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "ADD R0.xy, fragment.position, c[3];\n"
    "MUL R1.xyz, R0.y, c[1];\n"
    "MAD R0.xyz, R0.x, c[0], R1;\n"
    "ADD R0.xyz, R0, c[2];\n"
    "RCP R2.z, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R2.z;\n"
    "MUL R2.xy, R0.zwzw, fragment.texcoord[0];\n"
    "MOV R1.xy, c[0];\n"
    "MOV R1.zw, c[1].xyxy;\n"
    "MOV R0.x, c[0].z;\n"
    "MOV R0.y, c[1].z;\n"
    "MAD R0, R0.zzww, -R0.xyxy, R1.xzyw;\n"
    "MUL R1.xy, R2, fragment.texcoord[0];\n"
    "MUL R0, R2.z, R0;\n"
    "MUL R1.xy, R1, c[4].x;\n"
    "MUL R1.zw, R1.xyxy, R0.xyxz;\n"
    "MUL R0.zw, R1.xyxy, R0.xyyw;\n"
    "ADD R0.y, R0.z, R0.w;\n"
    "ADD R0.x, R1.z, R1.w;\n"
    "MUL R0.xy, R0, R0;\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.zw, R2.xyxy, R2.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "ADD R0.y, -R0.z, c[4];\n"
    "RSQ R0.x, R0.x;\n"
    "MAD_SAT R0.x, R0, R0.y, -c[4].z;\n"
    "MUL R0.y, -R0.x, c[4].w;\n"
    "ADD R0.y, R0, c[5].x;\n"
    "MUL R0.x, R0, R0;\n"
    "MUL result.color, R0.x, R0.y;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_SIMPLE_PORTER_DUFF =
    "!!ARBfp1.0\n"
    "PARAM c[7] = { program.local[0..5],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xy, fragment.position, c[3];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "MUL R1.xyz, R0, c[0].y;\n"
    "MUL R2.xyz, fragment.color.primary.w, R1;\n"
    "MUL R1.xyz, fragment.color.primary, c[0].x;\n"
    "MAD R2.xyz, R0.w, R1, R2;\n"
    "ADD R3.xy, fragment.position, c[4];\n"
    "ADD R1.w, -R0, c[6].x;\n"
    "MUL R1.xyz, fragment.color.primary, c[1].y;\n"
    "MAD R2.xyz, R1.w, R1, R2;\n"
    "MUL R1.xyz, R0, c[1].z;\n"
    "ADD R2.w, -fragment.color.primary, c[6].x;\n"
    "MAD R2.xyz, R2.w, R1, R2;\n"
    "MUL R1.z, R0.w, R2.w;\n"
    "MUL R1.x, fragment.color.primary.w, R0.w;\n"
    "MUL R1.y, fragment.color.primary.w, R1.w;\n"
    "DP3 R2.w, R1, c[1];\n"
    "MUL R3.xy, R3, c[2];\n"
    "TEX R1, R3, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[5];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_MULTIPLY =
    "!!ARBfp1.0\n"
    "PARAM c[5] = { program.local[0..3],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xy, fragment.position, c[1];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "ADD R1.x, -R0.w, c[4];\n"
    "MUL R1.xyz, fragment.color.primary, R1.x;\n"
    "MAD R1.xyz, fragment.color.primary, R0, R1;\n"
    "ADD R1.w, -fragment.color.primary, c[4].x;\n"
    "MAD R2.xyz, R0, R1.w, R1;\n"
    "ADD R1.z, fragment.color.primary.w, R0.w;\n"
    "MAD R2.w, -fragment.color.primary, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[2];\n"
    "MUL R1.xy, R1, c[0];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[3];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_SCREEN =
    "!!ARBfp1.0\n"
    "PARAM c[4] = { program.local[0..3] };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xy, fragment.position, c[1];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "ADD R1.xy, fragment.position, c[2];\n"
    "ADD R2, fragment.color.primary, R0;\n"
    "MUL R1.xy, R1, c[0];\n"
    "MAD R2, -fragment.color.primary, R0, R2;\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[3];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_OVERLAY =
    "!!ARBfp1.0\n"
    "PARAM c[5] = { program.local[0..3],\n"
    "		{ 2, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xy, fragment.position, c[1];\n"
    "TEX R1, R0, texture[0], 2D;\n"
    "ADD R0.w, -R1, c[4].y;\n"
    "MUL R3.xyz, fragment.color.primary, R0.w;\n"
    "ADD R2.xyz, fragment.color.primary.w, -fragment.color.primary;\n"
    "ADD R0.xyz, R1.w, -R1;\n"
    "MUL R0.xyz, R0, R2;\n"
    "MUL R0.xyz, R0, c[4].x;\n"
    "MAD R0.xyz, fragment.color.primary.w, R1.w, -R0;\n"
    "MAD R0.xyz, fragment.color.primary, R0.w, R0;\n"
    "MUL R2.xyz, fragment.color.primary, R1;\n"
    "MAD R2.xyz, R2, c[4].x, R3;\n"
    "ADD R0.w, -fragment.color.primary, c[4].y;\n"
    "MAD R3.xyz, R1, R0.w, R0;\n"
    "MAD R2.xyz, R1, R0.w, R2;\n"
    "MUL R0.xyz, R1, c[4].x;\n"
    "SGE R0.xyz, R0, R1.w;\n"
    "ADD R3.xyz, R3, -R2;\n"
    "MAD R2.xyz, R0, R3, R2;\n"
    "ADD R0.z, fragment.color.primary.w, R1.w;\n"
    "MAD R2.w, -fragment.color.primary, R1, R0.z;\n"
    "ADD R0.xy, fragment.position, c[2];\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "ADD R2, R2, -R1;\n"
    "DP4 R0.x, R0, c[3];\n"
    "MAD result.color, R0.x, R2, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_DARKEN =
    "!!ARBfp1.0\n"
    "PARAM c[5] = { program.local[0..3],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xy, fragment.position, c[1];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "MUL R2.xyz, fragment.color.primary.w, R0;\n"
    "MUL R1.xyz, fragment.color.primary, R0.w;\n"
    "MIN R1.xyz, R1, R2;\n"
    "ADD R1.w, -R0, c[4].x;\n"
    "MAD R1.xyz, fragment.color.primary, R1.w, R1;\n"
    "ADD R1.w, -fragment.color.primary, c[4].x;\n"
    "MAD R2.xyz, R0, R1.w, R1;\n"
    "ADD R1.z, fragment.color.primary.w, R0.w;\n"
    "MAD R2.w, -fragment.color.primary, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[2];\n"
    "MUL R1.xy, R1, c[0];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[3];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_LIGHTEN =
    "!!ARBfp1.0\n"
    "PARAM c[5] = { program.local[0..3],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xy, fragment.position, c[1];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "MUL R2.xyz, fragment.color.primary.w, R0;\n"
    "MUL R1.xyz, fragment.color.primary, R0.w;\n"
    "MAX R1.xyz, R1, R2;\n"
    "ADD R1.w, -R0, c[4].x;\n"
    "MAD R1.xyz, fragment.color.primary, R1.w, R1;\n"
    "ADD R1.w, -fragment.color.primary, c[4].x;\n"
    "MAD R2.xyz, R0, R1.w, R1;\n"
    "ADD R1.z, fragment.color.primary.w, R0.w;\n"
    "MAD R2.w, -fragment.color.primary, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[2];\n"
    "MUL R1.xy, R1, c[0];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[3];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_COLORDODGE =
    "!!ARBfp1.0\n"
    "PARAM c[5] = { program.local[0..3],\n"
    "		{ 1, 1e-006 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xy, fragment.position, c[1];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "ADD R1.x, -fragment.color.primary.w, c[4];\n"
    "MAX R1.y, fragment.color.primary.w, c[4];\n"
    "MUL R2.xyz, R0, R1.x;\n"
    "ADD R1.w, -R0, c[4].x;\n"
    "MAD R3.xyz, fragment.color.primary, R1.w, R2;\n"
    "RCP R1.y, R1.y;\n"
    "MAD R1.xyz, -fragment.color.primary, R1.y, c[4].x;\n"
    "MAX R1.xyz, R1, c[4].y;\n"
    "MUL R2.xyz, fragment.color.primary.w, R0;\n"
    "MUL R1.w, fragment.color.primary, R0;\n"
    "RCP R1.x, R1.x;\n"
    "RCP R1.y, R1.y;\n"
    "RCP R1.z, R1.z;\n"
    "MAD R1.xyz, R2, R1, R3;\n"
    "MAD R3.xyz, fragment.color.primary.w, R0.w, R3;\n"
    "MAD R2.xyz, fragment.color.primary, R0.w, R2;\n"
    "ADD R3.xyz, R3, -R1;\n"
    "SGE R2.xyz, R2, R1.w;\n"
    "MAD R2.xyz, R2, R3, R1;\n"
    "ADD R1.z, fragment.color.primary.w, R0.w;\n"
    "MAD R2.w, -fragment.color.primary, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[2];\n"
    "MUL R1.xy, R1, c[0];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[3];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_COLORBURN =
    "!!ARBfp1.0\n"
    "PARAM c[5] = { program.local[0..3],\n"
    "		{ 1, 9.9999997e-006 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "MUL R0.xy, fragment.position, c[1];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "ADD R1.w, -R0, c[4].x;\n"
    "MUL R1.xyz, fragment.color.primary.w, R0;\n"
    "MAD R2.xyz, fragment.color.primary, R0.w, R1;\n"
    "MAD R1.xyz, -fragment.color.primary.w, R0.w, R2;\n"
    "MUL R3.xyz, fragment.color.primary.w, R1;\n"
    "MAX R1.xyz, fragment.color.primary, c[4].y;\n"
    "ADD R2.w, -fragment.color.primary, c[4].x;\n"
    "MUL R4.xyz, fragment.color.primary, R1.w;\n"
    "RCP R1.x, R1.x;\n"
    "RCP R1.y, R1.y;\n"
    "RCP R1.z, R1.z;\n"
    "MAD R3.xyz, R3, R1, R4;\n"
    "MUL R1.xyz, R0, R2.w;\n"
    "MAD R1.xyz, fragment.color.primary, R1.w, R1;\n"
    "MAD R3.xyz, R0, R2.w, R3;\n"
    "MUL R1.w, fragment.color.primary, R0;\n"
    "ADD R3.xyz, R3, -R1;\n"
    "SGE R2.xyz, R2, R1.w;\n"
    "MAD R2.xyz, R2, R3, R1;\n"
    "ADD R1.z, fragment.color.primary.w, R0.w;\n"
    "MAD R2.w, -fragment.color.primary, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[2];\n"
    "MUL R1.xy, R1, c[0];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[3];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_HARDLIGHT =
    "!!ARBfp1.0\n"
    "PARAM c[5] = { program.local[0..3],\n"
    "		{ 2, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xy, fragment.position, c[1];\n"
    "TEX R1, R0, texture[0], 2D;\n"
    "ADD R0.w, -R1, c[4].y;\n"
    "MUL R3.xyz, fragment.color.primary, R0.w;\n"
    "ADD R2.xyz, fragment.color.primary.w, -fragment.color.primary;\n"
    "ADD R0.xyz, R1.w, -R1;\n"
    "MUL R0.xyz, R0, R2;\n"
    "MUL R0.xyz, R0, c[4].x;\n"
    "MAD R0.xyz, fragment.color.primary.w, R1.w, -R0;\n"
    "MAD R0.xyz, fragment.color.primary, R0.w, R0;\n"
    "MUL R2.xyz, fragment.color.primary, R1;\n"
    "MAD R2.xyz, R2, c[4].x, R3;\n"
    "ADD R0.w, -fragment.color.primary, c[4].y;\n"
    "MAD R3.xyz, R1, R0.w, R0;\n"
    "MAD R2.xyz, R1, R0.w, R2;\n"
    "MUL R0.xyz, fragment.color.primary, c[4].x;\n"
    "SGE R0.xyz, R0, fragment.color.primary.w;\n"
    "ADD R3.xyz, R3, -R2;\n"
    "MAD R2.xyz, R0, R3, R2;\n"
    "ADD R0.z, fragment.color.primary.w, R1.w;\n"
    "MAD R2.w, -fragment.color.primary, R1, R0.z;\n"
    "ADD R0.xy, fragment.position, c[2];\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "ADD R2, R2, -R1;\n"
    "DP4 R0.x, R0, c[3];\n"
    "MAD result.color, R0.x, R2, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_SOFTLIGHT =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..3],\n"
    "		{ 1, 2, 9.9999997e-006, 4 },\n"
    "		{ 16, 12, 3 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "TEMP R5;\n"
    "MUL R0.xy, fragment.position, c[1];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "MAX R1.x, R0.w, c[4].z;\n"
    "RCP R1.x, R1.x;\n"
    "MUL R2.xyz, R0, R1.x;\n"
    "MAD R1.xyz, R2, c[5].x, -c[5].y;\n"
    "MAD R3.xyz, R2, R1, c[5].z;\n"
    "MAD R1.xyz, fragment.color.primary, c[4].y, -fragment.color.primary.w;\n"
    "MUL R4.xyz, R0.w, R1;\n"
    "MUL R5.xyz, R4, R3;\n"
    "RSQ R1.w, R2.x;\n"
    "RSQ R2.w, R2.z;\n"
    "RCP R3.x, R1.w;\n"
    "RSQ R1.w, R2.y;\n"
    "MUL R5.xyz, R2, R5;\n"
    "RCP R3.z, R2.w;\n"
    "RCP R3.y, R1.w;\n"
    "ADD R3.xyz, -R2, R3;\n"
    "MUL R3.xyz, R4, R3;\n"
    "ADD R2.xyz, -R2, c[4].x;\n"
    "MAD R1.xyz, R1, R2, fragment.color.primary.w;\n"
    "MUL R2.xyz, fragment.color.primary, c[4].y;\n"
    "MAD R4.xyz, fragment.color.primary.w, R0, R5;\n"
    "MAD R3.xyz, fragment.color.primary.w, R0, R3;\n"
    "ADD R5.xyz, R3, -R4;\n"
    "MUL R3.xyz, R0, c[4].w;\n"
    "SGE R3.xyz, R3, R0.w;\n"
    "MAD R3.xyz, R3, R5, R4;\n"
    "MAD R3.xyz, -R0, R1, R3;\n"
    "MUL R1.xyz, R0, R1;\n"
    "SGE R2.xyz, R2, fragment.color.primary.w;\n"
    "MAD R2.xyz, R2, R3, R1;\n"
    "ADD R1.x, -R0.w, c[4];\n"
    "MAD R2.xyz, fragment.color.primary, R1.x, R2;\n"
    "ADD R1.x, -fragment.color.primary.w, c[4];\n"
    "MAD R2.xyz, R0, R1.x, R2;\n"
    "ADD R1.z, fragment.color.primary.w, R0.w;\n"
    "MAD R2.w, -fragment.color.primary, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[2];\n"
    "MUL R1.xy, R1, c[0];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[3];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_DIFFERENCE =
    "!!ARBfp1.0\n"
    "PARAM c[5] = { program.local[0..3],\n"
    "		{ 2 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xy, fragment.position, c[1];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "ADD R1.xyz, fragment.color.primary, R0;\n"
    "MUL R3.xyz, fragment.color.primary.w, R0;\n"
    "MUL R2.xyz, fragment.color.primary, R0.w;\n"
    "MIN R2.xyz, R2, R3;\n"
    "MAD R2.xyz, -R2, c[4].x, R1;\n"
    "ADD R1.z, fragment.color.primary.w, R0.w;\n"
    "MAD R2.w, -fragment.color.primary, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[2];\n"
    "MUL R1.xy, R1, c[0];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[3];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_EXCLUSION =
    "!!ARBfp1.0\n"
    "PARAM c[5] = { program.local[0..3],\n"
    "		{ 2, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xy, fragment.position, c[1];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "MUL R1.xyz, fragment.color.primary.w, R0;\n"
    "MAD R2.xyz, fragment.color.primary, R0.w, R1;\n"
    "MUL R1.xyz, fragment.color.primary, R0;\n"
    "MAD R1.xyz, -R1, c[4].x, R2;\n"
    "ADD R1.w, -R0, c[4].y;\n"
    "MAD R1.xyz, fragment.color.primary, R1.w, R1;\n"
    "ADD R1.w, -fragment.color.primary, c[4].y;\n"
    "MAD R2.xyz, R0, R1.w, R1;\n"
    "ADD R1.z, fragment.color.primary.w, R0.w;\n"
    "MAD R2.w, -fragment.color.primary, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[2];\n"
    "MUL R1.xy, R1, c[0];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[3];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_SIMPLE_PORTER_DUFF_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[4] = { program.local[0..2],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xy, fragment.position, c[2];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "MUL R1.xyz, R0, c[0].y;\n"
    "MUL R2.xyz, fragment.color.primary.w, R1;\n"
    "MUL R1.xyz, fragment.color.primary, c[0].x;\n"
    "MAD R2.xyz, R0.w, R1, R2;\n"
    "MUL R0.xyz, R0, c[1].z;\n"
    "ADD R1.w, -R0, c[3].x;\n"
    "MUL R1.xyz, fragment.color.primary, c[1].y;\n"
    "MAD R1.xyz, R1.w, R1, R2;\n"
    "ADD R2.x, -fragment.color.primary.w, c[3];\n"
    "MAD result.color.xyz, R2.x, R0, R1;\n"
    "MUL R0.x, fragment.color.primary.w, R0.w;\n"
    "MUL R0.z, R0.w, R2.x;\n"
    "MUL R0.y, fragment.color.primary.w, R1.w;\n"
    "DP3 result.color.w, R0, c[1];\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_MULTIPLY_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[2] = { program.local[0],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xy, fragment.position, c[0];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "ADD R1.x, -R0.w, c[1];\n"
    "MUL R1.xyz, fragment.color.primary, R1.x;\n"
    "ADD R1.w, fragment.color.primary, R0;\n"
    "MAD R1.xyz, fragment.color.primary, R0, R1;\n"
    "ADD R2.x, -fragment.color.primary.w, c[1];\n"
    "MAD result.color.xyz, R0, R2.x, R1;\n"
    "MAD result.color.w, -fragment.color.primary, R0, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_SCREEN_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[1] = { program.local[0] };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "MUL R0.xy, fragment.position, c[0];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "ADD R1, fragment.color.primary, R0;\n"
    "MAD result.color, -fragment.color.primary, R0, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_OVERLAY_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[2] = { program.local[0],\n"
    "		{ 2, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xy, fragment.position, c[0];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "ADD R1.w, -R0, c[1].y;\n"
    "ADD R2.xyz, fragment.color.primary.w, -fragment.color.primary;\n"
    "ADD R1.xyz, R0.w, -R0;\n"
    "MUL R1.xyz, R1, R2;\n"
    "MUL R1.xyz, R1, c[1].x;\n"
    "MAD R1.xyz, fragment.color.primary.w, R0.w, -R1;\n"
    "MUL R3.xyz, fragment.color.primary, R1.w;\n"
    "MUL R2.xyz, fragment.color.primary, R0;\n"
    "MAD R1.xyz, fragment.color.primary, R1.w, R1;\n"
    "ADD R1.w, -fragment.color.primary, c[1].y;\n"
    "MAD R2.xyz, R2, c[1].x, R3;\n"
    "MAD R2.xyz, R0, R1.w, R2;\n"
    "MAD R1.xyz, R0, R1.w, R1;\n"
    "MUL R0.xyz, R0, c[1].x;\n"
    "ADD R1.w, fragment.color.primary, R0;\n"
    "ADD R1.xyz, R1, -R2;\n"
    "SGE R0.xyz, R0, R0.w;\n"
    "MAD result.color.xyz, R0, R1, R2;\n"
    "MAD result.color.w, -fragment.color.primary, R0, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_DARKEN_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[2] = { program.local[0],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xy, fragment.position, c[0];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "MUL R2.xyz, fragment.color.primary.w, R0;\n"
    "MUL R1.xyz, fragment.color.primary, R0.w;\n"
    "MIN R1.xyz, R1, R2;\n"
    "ADD R1.w, -R0, c[1].x;\n"
    "MAD R1.xyz, fragment.color.primary, R1.w, R1;\n"
    "ADD R1.w, fragment.color.primary, R0;\n"
    "ADD R2.x, -fragment.color.primary.w, c[1];\n"
    "MAD result.color.xyz, R0, R2.x, R1;\n"
    "MAD result.color.w, -fragment.color.primary, R0, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_LIGHTEN_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[2] = { program.local[0],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xy, fragment.position, c[0];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "MUL R2.xyz, fragment.color.primary.w, R0;\n"
    "MUL R1.xyz, fragment.color.primary, R0.w;\n"
    "MAX R1.xyz, R1, R2;\n"
    "ADD R1.w, -R0, c[1].x;\n"
    "MAD R1.xyz, fragment.color.primary, R1.w, R1;\n"
    "ADD R1.w, fragment.color.primary, R0;\n"
    "ADD R2.x, -fragment.color.primary.w, c[1];\n"
    "MAD result.color.xyz, R0, R2.x, R1;\n"
    "MAD result.color.w, -fragment.color.primary, R0, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_COLORDODGE_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[2] = { program.local[0],\n"
    "		{ 1, 1e-006 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MAX R1.y, fragment.color.primary.w, c[1];\n"
    "RCP R2.x, R1.y;\n"
    "MUL R0.xy, fragment.position, c[0];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "ADD R1.x, -fragment.color.primary.w, c[1];\n"
    "MUL R1.xyz, R0, R1.x;\n"
    "ADD R1.w, -R0, c[1].x;\n"
    "MAD R1.xyz, fragment.color.primary, R1.w, R1;\n"
    "MAD R2.xyz, -fragment.color.primary, R2.x, c[1].x;\n"
    "MAX R2.xyz, R2, c[1].y;\n"
    "MUL R0.xyz, fragment.color.primary.w, R0;\n"
    "MUL R1.w, fragment.color.primary, R0;\n"
    "RCP R2.x, R2.x;\n"
    "RCP R2.y, R2.y;\n"
    "RCP R2.z, R2.z;\n"
    "MAD R2.xyz, R0, R2, R1;\n"
    "MAD R1.xyz, fragment.color.primary.w, R0.w, R1;\n"
    "MAD R0.xyz, fragment.color.primary, R0.w, R0;\n"
    "SGE R0.xyz, R0, R1.w;\n"
    "ADD R1.xyz, R1, -R2;\n"
    "ADD R1.w, fragment.color.primary, R0;\n"
    "MAD result.color.xyz, R0, R1, R2;\n"
    "MAD result.color.w, -fragment.color.primary, R0, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_COLORBURN_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[2] = { program.local[0],\n"
    "		{ 1, 9.9999997e-006 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "MUL R0.xy, fragment.position, c[0];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "MUL R1.xyz, fragment.color.primary.w, R0;\n"
    "MAD R2.xyz, fragment.color.primary, R0.w, R1;\n"
    "MAD R1.xyz, -fragment.color.primary.w, R0.w, R2;\n"
    "MUL R3.xyz, fragment.color.primary.w, R1;\n"
    "MAX R1.xyz, fragment.color.primary, c[1].y;\n"
    "ADD R1.w, -R0, c[1].x;\n"
    "MUL R4.xyz, fragment.color.primary, R1.w;\n"
    "ADD R2.w, -fragment.color.primary, c[1].x;\n"
    "RCP R1.x, R1.x;\n"
    "RCP R1.y, R1.y;\n"
    "RCP R1.z, R1.z;\n"
    "MAD R1.xyz, R3, R1, R4;\n"
    "MUL R3.xyz, R0, R2.w;\n"
    "MAD R0.xyz, R0, R2.w, R1;\n"
    "MAD R1.xyz, fragment.color.primary, R1.w, R3;\n"
    "MUL R1.w, fragment.color.primary, R0;\n"
    "SGE R2.xyz, R2, R1.w;\n"
    "ADD R0.xyz, R0, -R1;\n"
    "ADD R1.w, fragment.color.primary, R0;\n"
    "MAD result.color.xyz, R2, R0, R1;\n"
    "MAD result.color.w, -fragment.color.primary, R0, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_HARDLIGHT_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[2] = { program.local[0],\n"
    "		{ 2, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xy, fragment.position, c[0];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "ADD R1.w, -R0, c[1].y;\n"
    "ADD R2.xyz, fragment.color.primary.w, -fragment.color.primary;\n"
    "ADD R1.xyz, R0.w, -R0;\n"
    "MUL R1.xyz, R1, R2;\n"
    "MUL R1.xyz, R1, c[1].x;\n"
    "MAD R1.xyz, fragment.color.primary.w, R0.w, -R1;\n"
    "MAD R1.xyz, fragment.color.primary, R1.w, R1;\n"
    "MUL R3.xyz, fragment.color.primary, R1.w;\n"
    "MUL R2.xyz, fragment.color.primary, R0;\n"
    "ADD R1.w, -fragment.color.primary, c[1].y;\n"
    "MAD R2.xyz, R2, c[1].x, R3;\n"
    "MAD R2.xyz, R0, R1.w, R2;\n"
    "MAD R0.xyz, R0, R1.w, R1;\n"
    "ADD R1.xyz, R0, -R2;\n"
    "MUL R0.xyz, fragment.color.primary, c[1].x;\n"
    "ADD R1.w, fragment.color.primary, R0;\n"
    "SGE R0.xyz, R0, fragment.color.primary.w;\n"
    "MAD result.color.xyz, R0, R1, R2;\n"
    "MAD result.color.w, -fragment.color.primary, R0, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_SOFTLIGHT_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[3] = { program.local[0],\n"
    "		{ 1, 2, 9.9999997e-006, 4 },\n"
    "		{ 16, 12, 3 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "TEMP R5;\n"
    "MUL R0.xy, fragment.position, c[0];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "MAX R1.x, R0.w, c[1].z;\n"
    "RCP R1.x, R1.x;\n"
    "MUL R2.xyz, R0, R1.x;\n"
    "MAD R1.xyz, R2, c[2].x, -c[2].y;\n"
    "MAD R3.xyz, R2, R1, c[2].z;\n"
    "MAD R1.xyz, fragment.color.primary, c[1].y, -fragment.color.primary.w;\n"
    "MUL R4.xyz, R0.w, R1;\n"
    "MUL R5.xyz, R4, R3;\n"
    "RSQ R1.w, R2.x;\n"
    "RCP R3.x, R1.w;\n"
    "RSQ R2.w, R2.z;\n"
    "RSQ R1.w, R2.y;\n"
    "MUL R5.xyz, R2, R5;\n"
    "RCP R3.z, R2.w;\n"
    "RCP R3.y, R1.w;\n"
    "ADD R3.xyz, -R2, R3;\n"
    "MUL R3.xyz, R4, R3;\n"
    "ADD R2.xyz, -R2, c[1].x;\n"
    "MAD R1.xyz, R1, R2, fragment.color.primary.w;\n"
    "MUL R2.xyz, fragment.color.primary, c[1].y;\n"
    "MAD R4.xyz, fragment.color.primary.w, R0, R5;\n"
    "MAD R3.xyz, fragment.color.primary.w, R0, R3;\n"
    "ADD R5.xyz, R3, -R4;\n"
    "MUL R3.xyz, R0, c[1].w;\n"
    "SGE R3.xyz, R3, R0.w;\n"
    "MAD R3.xyz, R3, R5, R4;\n"
    "MAD R3.xyz, -R0, R1, R3;\n"
    "MUL R1.xyz, R0, R1;\n"
    "SGE R2.xyz, R2, fragment.color.primary.w;\n"
    "MAD R2.xyz, R2, R3, R1;\n"
    "ADD R1.x, -R0.w, c[1];\n"
    "MAD R2.xyz, fragment.color.primary, R1.x, R2;\n"
    "ADD R1.x, fragment.color.primary.w, R0.w;\n"
    "ADD R1.y, -fragment.color.primary.w, c[1].x;\n"
    "MAD result.color.xyz, R0, R1.y, R2;\n"
    "MAD result.color.w, -fragment.color.primary, R0, R1.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_DIFFERENCE_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[2] = { program.local[0],\n"
    "		{ 2 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xy, fragment.position, c[0];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "MUL R2.xyz, fragment.color.primary.w, R0;\n"
    "MUL R1.xyz, fragment.color.primary, R0.w;\n"
    "ADD R1.w, fragment.color.primary, R0;\n"
    "MIN R1.xyz, R1, R2;\n"
    "ADD R0.xyz, fragment.color.primary, R0;\n"
    "MAD result.color.xyz, -R1, c[1].x, R0;\n"
    "MAD result.color.w, -fragment.color.primary, R0, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_EXCLUSION_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[2] = { program.local[0],\n"
    "		{ 2, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xy, fragment.position, c[0];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "MUL R1.xyz, fragment.color.primary.w, R0;\n"
    "MAD R2.xyz, fragment.color.primary, R0.w, R1;\n"
    "MUL R1.xyz, fragment.color.primary, R0;\n"
    "MAD R1.xyz, -R1, c[1].x, R2;\n"
    "ADD R1.w, -R0, c[1].y;\n"
    "MAD R1.xyz, fragment.color.primary, R1.w, R1;\n"
    "ADD R1.w, fragment.color.primary, R0;\n"
    "ADD R2.x, -fragment.color.primary.w, c[1].y;\n"
    "MAD result.color.xyz, R0, R2.x, R1;\n"
    "MAD result.color.w, -fragment.color.primary, R0, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODE_BLEND_MODE_MASK =
    "!!ARBfp1.0\n"
    "PARAM c[3] = { program.local[0..2] };\n"
    "TEMP R0;\n"
    "ADD R0.xy, fragment.position, c[1];\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "DP4 R0.x, R0, c[2];\n"
    "MUL result.color, fragment.color.primary, R0.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODE_BLEND_MODE_NOMASK =
    "!!ARBfp1.0\n"
    "MOV result.color, fragment.color.primary;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_SIMPLE_PORTER_DUFF =
    "!!ARBfp1.0\n"
    "PARAM c[12] = { program.local[0..10],\n"
    "		{ 2, 4, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.y, R0.x, c[11].x;\n"
    "MUL R0.z, R0, c[11].y;\n"
    "MAD R0.x, R0.y, R0.y, -R0.z;\n"
    "RSQ R0.x, R0.x;\n"
    "RCP R0.z, R0.x;\n"
    "ADD R1.x, -R0.y, R0.z;\n"
    "MOV R0.x, c[11];\n"
    "MUL R0.z, R0.x, c[1].x;\n"
    "RCP R1.y, R0.z;\n"
    "MUL R0.xy, fragment.position, c[8];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "MUL R1.x, R1, R1.y;\n"
    "TEX R1, R1, texture[2], 1D;\n"
    "MUL R2.xyz, R0, c[5].y;\n"
    "MUL R3.xyz, R1.w, R2;\n"
    "MUL R2.xyz, R1, c[5].x;\n"
    "MAD R2.xyz, R0.w, R2, R3;\n"
    "ADD R3.xy, fragment.position, c[9];\n"
    "ADD R2.w, -R0, c[11].z;\n"
    "MUL R1.xyz, R1, c[6].y;\n"
    "MAD R2.xyz, R2.w, R1, R2;\n"
    "MUL R1.xyz, R0, c[6].z;\n"
    "ADD R3.z, -R1.w, c[11];\n"
    "MAD R2.xyz, R3.z, R1, R2;\n"
    "MUL R1.y, R1.w, R2.w;\n"
    "MUL R1.x, R1.w, R0.w;\n"
    "MUL R1.z, R0.w, R3;\n"
    "DP3 R2.w, R1, c[6];\n"
    "MUL R3.xy, R3, c[7];\n"
    "TEX R1, R3, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[10];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_MULTIPLY =
    "!!ARBfp1.0\n"
    "PARAM c[10] = { program.local[0..8],\n"
    "		{ 2, 4, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.y, R0.x, c[9].x;\n"
    "MUL R0.z, R0, c[9].y;\n"
    "MAD R0.x, R0.y, R0.y, -R0.z;\n"
    "RSQ R0.x, R0.x;\n"
    "RCP R0.z, R0.x;\n"
    "ADD R1.x, -R0.y, R0.z;\n"
    "MOV R0.x, c[9];\n"
    "MUL R0.z, R0.x, c[1].x;\n"
    "RCP R1.y, R0.z;\n"
    "MUL R0.xy, fragment.position, c[6];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "MUL R1.x, R1, R1.y;\n"
    "TEX R1, R1, texture[2], 1D;\n"
    "ADD R2.x, -R0.w, c[9].z;\n"
    "MUL R2.xyz, R1, R2.x;\n"
    "MAD R1.xyz, R1, R0, R2;\n"
    "ADD R2.x, -R1.w, c[9].z;\n"
    "MAD R2.xyz, R0, R2.x, R1;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[7];\n"
    "MUL R1.xy, R1, c[5];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[8];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_SCREEN =
    "!!ARBfp1.0\n"
    "PARAM c[10] = { program.local[0..8],\n"
    "		{ 2, 4 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.y, R0.x, c[9].x;\n"
    "MOV R0.x, c[9];\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.z, R0, c[9].y;\n"
    "MAD R0.z, R0.y, R0.y, -R0;\n"
    "ADD R3.xy, fragment.position, c[7];\n"
    "MUL R0.w, R0.x, c[1].x;\n"
    "RSQ R0.z, R0.z;\n"
    "RCP R0.x, R0.z;\n"
    "RCP R0.z, R0.w;\n"
    "ADD R0.x, -R0.y, R0;\n"
    "MUL R0.z, R0.x, R0;\n"
    "TEX R1, R0.z, texture[2], 1D;\n"
    "MUL R0.xy, fragment.position, c[6];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "ADD R2, R1, R0;\n"
    "MAD R2, -R1, R0, R2;\n"
    "MUL R3.xy, R3, c[5];\n"
    "TEX R1, R3, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[8];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_OVERLAY =
    "!!ARBfp1.0\n"
    "PARAM c[10] = { program.local[0..8],\n"
    "		{ 2, 4, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.y, R0.x, c[9].x;\n"
    "MOV R0.x, c[9];\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.z, R0, c[9].y;\n"
    "MAD R0.z, R0.y, R0.y, -R0;\n"
    "MUL R1.xy, fragment.position, c[6];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "MUL R0.w, R0.x, c[1].x;\n"
    "RSQ R0.z, R0.z;\n"
    "RCP R0.x, R0.z;\n"
    "ADD R2.w, -R1, c[9].z;\n"
    "RCP R0.z, R0.w;\n"
    "ADD R0.x, -R0.y, R0;\n"
    "MUL R0.x, R0, R0.z;\n"
    "TEX R0, R0, texture[2], 1D;\n"
    "ADD R3.xyz, R0.w, -R0;\n"
    "ADD R2.xyz, R1.w, -R1;\n"
    "MUL R2.xyz, R2, R3;\n"
    "MUL R2.xyz, R2, c[9].x;\n"
    "MAD R2.xyz, R0.w, R1.w, -R2;\n"
    "MUL R4.xyz, R0, R2.w;\n"
    "MUL R3.xyz, R0, R1;\n"
    "MAD R0.xyz, R0, R2.w, R2;\n"
    "ADD R2.x, -R0.w, c[9].z;\n"
    "MAD R3.xyz, R3, c[9].x, R4;\n"
    "MAD R3.xyz, R1, R2.x, R3;\n"
    "MAD R0.xyz, R1, R2.x, R0;\n"
    "MUL R2.xyz, R1, c[9].x;\n"
    "ADD R0.xyz, R0, -R3;\n"
    "SGE R2.xyz, R2, R1.w;\n"
    "MAD R2.xyz, R2, R0, R3;\n"
    "ADD R0.z, R0.w, R1.w;\n"
    "MAD R2.w, -R0, R1, R0.z;\n"
    "ADD R0.xy, fragment.position, c[7];\n"
    "MUL R0.xy, R0, c[5];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "ADD R2, R2, -R1;\n"
    "DP4 R0.x, R0, c[8];\n"
    "MAD result.color, R0.x, R2, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_DARKEN =
    "!!ARBfp1.0\n"
    "PARAM c[10] = { program.local[0..8],\n"
    "		{ 2, 4, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.y, R0.x, c[9].x;\n"
    "MUL R0.z, R0, c[9].y;\n"
    "MAD R0.x, R0.y, R0.y, -R0.z;\n"
    "RSQ R0.z, R0.x;\n"
    "MOV R0.x, c[9];\n"
    "MUL R0.x, R0, c[1];\n"
    "RCP R0.z, R0.z;\n"
    "ADD R0.z, -R0.y, R0;\n"
    "RCP R0.w, R0.x;\n"
    "MUL R1.x, R0.z, R0.w;\n"
    "MUL R0.xy, fragment.position, c[6];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "TEX R1, R1, texture[2], 1D;\n"
    "MUL R3.xyz, R1.w, R0;\n"
    "MUL R2.xyz, R1, R0.w;\n"
    "MIN R2.xyz, R2, R3;\n"
    "ADD R2.w, -R0, c[9].z;\n"
    "MAD R1.xyz, R1, R2.w, R2;\n"
    "ADD R2.x, -R1.w, c[9].z;\n"
    "MAD R2.xyz, R0, R2.x, R1;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[7];\n"
    "MUL R1.xy, R1, c[5];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[8];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_LIGHTEN =
    "!!ARBfp1.0\n"
    "PARAM c[10] = { program.local[0..8],\n"
    "		{ 2, 4, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.y, R0.x, c[9].x;\n"
    "MUL R0.z, R0, c[9].y;\n"
    "MAD R0.x, R0.y, R0.y, -R0.z;\n"
    "RSQ R0.z, R0.x;\n"
    "MOV R0.x, c[9];\n"
    "MUL R0.x, R0, c[1];\n"
    "RCP R0.z, R0.z;\n"
    "ADD R0.z, -R0.y, R0;\n"
    "RCP R0.w, R0.x;\n"
    "MUL R1.x, R0.z, R0.w;\n"
    "MUL R0.xy, fragment.position, c[6];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "TEX R1, R1, texture[2], 1D;\n"
    "MUL R3.xyz, R1.w, R0;\n"
    "MUL R2.xyz, R1, R0.w;\n"
    "MAX R2.xyz, R2, R3;\n"
    "ADD R2.w, -R0, c[9].z;\n"
    "MAD R1.xyz, R1, R2.w, R2;\n"
    "ADD R2.x, -R1.w, c[9].z;\n"
    "MAD R2.xyz, R0, R2.x, R1;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[7];\n"
    "MUL R1.xy, R1, c[5];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[8];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_COLORDODGE =
    "!!ARBfp1.0\n"
    "PARAM c[10] = { program.local[0..8],\n"
    "		{ 2, 4, 1, 1e-006 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.y, R0.x, c[9].x;\n"
    "MOV R0.x, c[9];\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.z, R0, c[9].y;\n"
    "MAD R0.z, R0.y, R0.y, -R0;\n"
    "MUL R0.w, R0.x, c[1].x;\n"
    "RSQ R0.z, R0.z;\n"
    "RCP R0.x, R0.z;\n"
    "RCP R0.z, R0.w;\n"
    "ADD R0.x, -R0.y, R0;\n"
    "MUL R0.x, R0, R0.z;\n"
    "TEX R0, R0, texture[2], 1D;\n"
    "MAX R1.x, R0.w, c[9].w;\n"
    "RCP R1.x, R1.x;\n"
    "MAD R1.xyz, -R0, R1.x, c[9].z;\n"
    "MAX R2.xyz, R1, c[9].w;\n"
    "MUL R1.xy, fragment.position, c[6];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "ADD R2.w, -R0, c[9].z;\n"
    "MUL R3.xyz, R1, R2.w;\n"
    "ADD R2.w, -R1, c[9].z;\n"
    "MAD R4.xyz, R0, R2.w, R3;\n"
    "MUL R3.xyz, R0.w, R1;\n"
    "MUL R2.w, R0, R1;\n"
    "MAD R0.xyz, R0, R1.w, R3;\n"
    "SGE R0.xyz, R0, R2.w;\n"
    "RCP R2.x, R2.x;\n"
    "RCP R2.y, R2.y;\n"
    "RCP R2.z, R2.z;\n"
    "MAD R2.xyz, R3, R2, R4;\n"
    "MAD R4.xyz, R0.w, R1.w, R4;\n"
    "ADD R4.xyz, R4, -R2;\n"
    "MAD R2.xyz, R0, R4, R2;\n"
    "ADD R0.z, R0.w, R1.w;\n"
    "MAD R2.w, -R0, R1, R0.z;\n"
    "ADD R0.xy, fragment.position, c[7];\n"
    "MUL R0.xy, R0, c[5];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "ADD R2, R2, -R1;\n"
    "DP4 R0.x, R0, c[8];\n"
    "MAD result.color, R0.x, R2, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_COLORBURN =
    "!!ARBfp1.0\n"
    "PARAM c[10] = { program.local[0..8],\n"
    "		{ 2, 4, 1, 9.9999997e-006 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "TEMP R5;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.y, R0.x, c[9].x;\n"
    "MUL R0.z, R0, c[9].y;\n"
    "MAD R0.x, R0.y, R0.y, -R0.z;\n"
    "RSQ R0.z, R0.x;\n"
    "MOV R0.x, c[9];\n"
    "MUL R0.w, R0.x, c[1].x;\n"
    "RCP R0.z, R0.z;\n"
    "ADD R0.x, -R0.y, R0.z;\n"
    "RCP R0.y, R0.w;\n"
    "MUL R0.zw, fragment.position.xyxy, c[6].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MUL R0.x, R0, R0.y;\n"
    "TEX R0, R0, texture[2], 1D;\n"
    "MUL R2.xyz, R0.w, R1;\n"
    "MAD R3.xyz, R0, R1.w, R2;\n"
    "MAD R2.xyz, -R0.w, R1.w, R3;\n"
    "MUL R4.xyz, R0.w, R2;\n"
    "MAX R2.xyz, R0, c[9].w;\n"
    "ADD R2.w, -R1, c[9].z;\n"
    "MUL R5.xyz, R0, R2.w;\n"
    "ADD R3.w, -R0, c[9].z;\n"
    "RCP R2.x, R2.x;\n"
    "RCP R2.y, R2.y;\n"
    "RCP R2.z, R2.z;\n"
    "MAD R2.xyz, R4, R2, R5;\n"
    "MUL R4.xyz, R1, R3.w;\n"
    "MAD R0.xyz, R0, R2.w, R4;\n"
    "MUL R2.w, R0, R1;\n"
    "MAD R2.xyz, R1, R3.w, R2;\n"
    "ADD R2.xyz, R2, -R0;\n"
    "SGE R3.xyz, R3, R2.w;\n"
    "MAD R2.xyz, R3, R2, R0;\n"
    "ADD R0.z, R0.w, R1.w;\n"
    "MAD R2.w, -R0, R1, R0.z;\n"
    "ADD R0.xy, fragment.position, c[7];\n"
    "MUL R0.xy, R0, c[5];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "ADD R2, R2, -R1;\n"
    "DP4 R0.x, R0, c[8];\n"
    "MAD result.color, R0.x, R2, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_HARDLIGHT =
    "!!ARBfp1.0\n"
    "PARAM c[10] = { program.local[0..8],\n"
    "		{ 2, 4, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.y, R0.x, c[9].x;\n"
    "MOV R0.x, c[9];\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.z, R0, c[9].y;\n"
    "MAD R0.z, R0.y, R0.y, -R0;\n"
    "MUL R1.xy, fragment.position, c[6];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "MUL R0.w, R0.x, c[1].x;\n"
    "RSQ R0.z, R0.z;\n"
    "RCP R0.x, R0.z;\n"
    "ADD R2.w, -R1, c[9].z;\n"
    "RCP R0.z, R0.w;\n"
    "ADD R0.x, -R0.y, R0;\n"
    "MUL R0.x, R0, R0.z;\n"
    "TEX R0, R0, texture[2], 1D;\n"
    "ADD R3.xyz, R0.w, -R0;\n"
    "ADD R2.xyz, R1.w, -R1;\n"
    "MUL R2.xyz, R2, R3;\n"
    "MUL R2.xyz, R2, c[9].x;\n"
    "MAD R2.xyz, R0.w, R1.w, -R2;\n"
    "MUL R4.xyz, R0, R2.w;\n"
    "MAD R2.xyz, R0, R2.w, R2;\n"
    "MUL R3.xyz, R0, R1;\n"
    "ADD R2.w, -R0, c[9].z;\n"
    "MAD R3.xyz, R3, c[9].x, R4;\n"
    "MUL R0.xyz, R0, c[9].x;\n"
    "SGE R0.xyz, R0, R0.w;\n"
    "MAD R3.xyz, R1, R2.w, R3;\n"
    "MAD R2.xyz, R1, R2.w, R2;\n"
    "ADD R2.xyz, R2, -R3;\n"
    "MAD R2.xyz, R0, R2, R3;\n"
    "ADD R0.z, R0.w, R1.w;\n"
    "MAD R2.w, -R0, R1, R0.z;\n"
    "ADD R0.xy, fragment.position, c[7];\n"
    "MUL R0.xy, R0, c[5];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "ADD R2, R2, -R1;\n"
    "DP4 R0.x, R0, c[8];\n"
    "MAD result.color, R0.x, R2, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_SOFTLIGHT =
    "!!ARBfp1.0\n"
    "PARAM c[11] = { program.local[0..8],\n"
    "		{ 2, 4, 1, 9.9999997e-006 },\n"
    "		{ 16, 12, 3 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "TEMP R5;\n"
    "TEMP R6;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.y, R0.z, c[9];\n"
    "MUL R0.x, R0, c[9];\n"
    "MUL R0.zw, fragment.position.xyxy, c[6].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MAD R0.y, R0.x, R0.x, -R0;\n"
    "RSQ R0.y, R0.y;\n"
    "RCP R0.y, R0.y;\n"
    "ADD R0.y, -R0.x, R0;\n"
    "MOV R0.x, c[9];\n"
    "MUL R0.x, R0, c[1];\n"
    "MAX R0.z, R1.w, c[9].w;\n"
    "RCP R0.z, R0.z;\n"
    "MUL R3.xyz, R1, R0.z;\n"
    "MAD R4.xyz, R3, c[10].x, -c[10].y;\n"
    "RCP R0.x, R0.x;\n"
    "MUL R0.x, R0.y, R0;\n"
    "TEX R0, R0, texture[2], 1D;\n"
    "MAD R2.xyz, R0, c[9].x, -R0.w;\n"
    "MAD R4.xyz, R3, R4, c[10].z;\n"
    "MUL R5.xyz, R1.w, R2;\n"
    "MUL R6.xyz, R5, R4;\n"
    "RSQ R2.w, R3.x;\n"
    "RCP R4.x, R2.w;\n"
    "RSQ R2.w, R3.y;\n"
    "RSQ R3.w, R3.z;\n"
    "RCP R4.y, R2.w;\n"
    "RCP R4.z, R3.w;\n"
    "ADD R4.xyz, -R3, R4;\n"
    "MUL R6.xyz, R3, R6;\n"
    "MUL R4.xyz, R5, R4;\n"
    "ADD R3.xyz, -R3, c[9].z;\n"
    "MAD R2.xyz, R2, R3, R0.w;\n"
    "MUL R3.xyz, R0, c[9].x;\n"
    "MAD R5.xyz, R0.w, R1, R6;\n"
    "MAD R4.xyz, R0.w, R1, R4;\n"
    "ADD R6.xyz, R4, -R5;\n"
    "MUL R4.xyz, R1, c[9].y;\n"
    "SGE R4.xyz, R4, R1.w;\n"
    "MAD R4.xyz, R4, R6, R5;\n"
    "MAD R4.xyz, -R1, R2, R4;\n"
    "SGE R3.xyz, R3, R0.w;\n"
    "MUL R2.xyz, R1, R2;\n"
    "ADD R2.w, -R1, c[9].z;\n"
    "MAD R2.xyz, R3, R4, R2;\n"
    "MAD R2.xyz, R0, R2.w, R2;\n"
    "ADD R0.x, -R0.w, c[9].z;\n"
    "MAD R2.xyz, R1, R0.x, R2;\n"
    "ADD R0.z, R0.w, R1.w;\n"
    "MAD R2.w, -R0, R1, R0.z;\n"
    "ADD R0.xy, fragment.position, c[7];\n"
    "MUL R0.xy, R0, c[5];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "ADD R2, R2, -R1;\n"
    "DP4 R0.x, R0, c[8];\n"
    "MAD result.color, R0.x, R2, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_DIFFERENCE =
    "!!ARBfp1.0\n"
    "PARAM c[10] = { program.local[0..8],\n"
    "		{ 2, 4 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.y, R0.x, c[9].x;\n"
    "MUL R0.z, R0, c[9].y;\n"
    "MAD R0.x, R0.y, R0.y, -R0.z;\n"
    "RSQ R0.z, R0.x;\n"
    "MOV R0.x, c[9];\n"
    "MUL R0.x, R0, c[1];\n"
    "RCP R0.z, R0.z;\n"
    "ADD R0.z, -R0.y, R0;\n"
    "RCP R0.w, R0.x;\n"
    "MUL R1.x, R0.z, R0.w;\n"
    "MUL R0.xy, fragment.position, c[6];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "TEX R1, R1, texture[2], 1D;\n"
    "ADD R2.xyz, R1, R0;\n"
    "MUL R3.xyz, R1.w, R0;\n"
    "MUL R1.xyz, R1, R0.w;\n"
    "MIN R1.xyz, R1, R3;\n"
    "MAD R2.xyz, -R1, c[9].x, R2;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[7];\n"
    "MUL R1.xy, R1, c[5];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[8];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_EXCLUSION =
    "!!ARBfp1.0\n"
    "PARAM c[10] = { program.local[0..8],\n"
    "		{ 2, 4, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.y, R0.x, c[9].x;\n"
    "MUL R0.z, R0, c[9].y;\n"
    "MAD R0.x, R0.y, R0.y, -R0.z;\n"
    "RSQ R0.z, R0.x;\n"
    "MOV R0.x, c[9];\n"
    "MUL R0.x, R0, c[1];\n"
    "RCP R0.z, R0.z;\n"
    "ADD R0.z, -R0.y, R0;\n"
    "RCP R0.w, R0.x;\n"
    "MUL R1.x, R0.z, R0.w;\n"
    "MUL R0.xy, fragment.position, c[6];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "TEX R1, R1, texture[2], 1D;\n"
    "MUL R2.xyz, R1.w, R0;\n"
    "MAD R3.xyz, R1, R0.w, R2;\n"
    "MUL R2.xyz, R1, R0;\n"
    "MAD R2.xyz, -R2, c[9].x, R3;\n"
    "ADD R2.w, -R0, c[9].z;\n"
    "MAD R1.xyz, R1, R2.w, R2;\n"
    "ADD R2.x, -R1.w, c[9].z;\n"
    "MAD R2.xyz, R0, R2.x, R1;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[7];\n"
    "MUL R1.xy, R1, c[5];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[8];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_SIMPLE_PORTER_DUFF_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 2, 4, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.y, R0.x, c[8].x;\n"
    "MUL R0.z, R0, c[8].y;\n"
    "MAD R0.x, R0.y, R0.y, -R0.z;\n"
    "RSQ R0.x, R0.x;\n"
    "RCP R0.z, R0.x;\n"
    "ADD R0.y, -R0, R0.z;\n"
    "MUL R0.zw, fragment.position.xyxy, c[7].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MUL R2.xyz, R1, c[5].y;\n"
    "MOV R0.x, c[8];\n"
    "MUL R0.x, R0, c[1];\n"
    "RCP R0.x, R0.x;\n"
    "MUL R0.x, R0.y, R0;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MUL R3.xyz, R0.w, R2;\n"
    "MUL R2.xyz, R0, c[5].x;\n"
    "MAD R2.xyz, R1.w, R2, R3;\n"
    "ADD R2.w, -R1, c[8].z;\n"
    "MUL R0.xyz, R0, c[6].y;\n"
    "MAD R0.xyz, R2.w, R0, R2;\n"
    "ADD R2.x, -R0.w, c[8].z;\n"
    "MUL R1.xyz, R1, c[6].z;\n"
    "MAD result.color.xyz, R2.x, R1, R0;\n"
    "MUL R0.x, R0.w, R1.w;\n"
    "MUL R0.z, R1.w, R2.x;\n"
    "MUL R0.y, R0.w, R2.w;\n"
    "DP3 result.color.w, R0, c[6];\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_MULTIPLY_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[7] = { program.local[0..5],\n"
    "		{ 2, 4, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.y, R0.x, c[6].x;\n"
    "MUL R0.z, R0, c[6].y;\n"
    "MAD R0.x, R0.y, R0.y, -R0.z;\n"
    "RSQ R0.x, R0.x;\n"
    "RCP R0.z, R0.x;\n"
    "ADD R0.y, -R0, R0.z;\n"
    "MUL R0.zw, fragment.position.xyxy, c[5].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MOV R0.x, c[6];\n"
    "MUL R0.x, R0, c[1];\n"
    "RCP R0.x, R0.x;\n"
    "MUL R0.x, R0.y, R0;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "ADD R2.x, -R1.w, c[6].z;\n"
    "MUL R2.xyz, R0, R2.x;\n"
    "MAD R0.xyz, R0, R1, R2;\n"
    "ADD R2.x, R0.w, R1.w;\n"
    "ADD R2.y, -R0.w, c[6].z;\n"
    "MAD result.color.xyz, R1, R2.y, R0;\n"
    "MAD result.color.w, -R0, R1, R2.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_SCREEN_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[7] = { program.local[0..5],\n"
    "		{ 2, 4 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.y, R0.x, c[6].x;\n"
    "MUL R0.z, R0, c[6].y;\n"
    "MAD R0.x, R0.y, R0.y, -R0.z;\n"
    "RSQ R0.z, R0.x;\n"
    "MOV R0.x, c[6];\n"
    "MUL R0.w, R0.x, c[1].x;\n"
    "RCP R0.z, R0.z;\n"
    "ADD R0.x, -R0.y, R0.z;\n"
    "RCP R0.y, R0.w;\n"
    "MUL R0.zw, fragment.position.xyxy, c[5].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MUL R0.x, R0, R0.y;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "ADD R2, R0, R1;\n"
    "MAD result.color, -R0, R1, R2;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_OVERLAY_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[7] = { program.local[0..5],\n"
    "		{ 2, 4, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.y, R0.x, c[6].x;\n"
    "MOV R0.x, c[6];\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.z, R0, c[6].y;\n"
    "MAD R0.z, R0.y, R0.y, -R0;\n"
    "MUL R1.xy, fragment.position, c[5];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "MUL R0.w, R0.x, c[1].x;\n"
    "RSQ R0.z, R0.z;\n"
    "RCP R0.x, R0.z;\n"
    "ADD R2.w, -R1, c[6].z;\n"
    "RCP R0.z, R0.w;\n"
    "ADD R0.x, -R0.y, R0;\n"
    "MUL R0.x, R0, R0.z;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "ADD R3.xyz, R0.w, -R0;\n"
    "ADD R2.xyz, R1.w, -R1;\n"
    "MUL R2.xyz, R2, R3;\n"
    "MUL R2.xyz, R2, c[6].x;\n"
    "MAD R2.xyz, R0.w, R1.w, -R2;\n"
    "MAD R2.xyz, R0, R2.w, R2;\n"
    "MUL R3.xyz, R0, R2.w;\n"
    "MUL R0.xyz, R0, R1;\n"
    "ADD R2.w, -R0, c[6].z;\n"
    "MAD R0.xyz, R0, c[6].x, R3;\n"
    "MAD R0.xyz, R1, R2.w, R0;\n"
    "MAD R2.xyz, R1, R2.w, R2;\n"
    "MUL R1.xyz, R1, c[6].x;\n"
    "ADD R2.w, R0, R1;\n"
    "ADD R2.xyz, R2, -R0;\n"
    "SGE R1.xyz, R1, R1.w;\n"
    "MAD result.color.xyz, R1, R2, R0;\n"
    "MAD result.color.w, -R0, R1, R2;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_DARKEN_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[7] = { program.local[0..5],\n"
    "		{ 2, 4, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.y, R0.x, c[6].x;\n"
    "MUL R0.z, R0, c[6].y;\n"
    "MAD R0.x, R0.y, R0.y, -R0.z;\n"
    "RSQ R0.z, R0.x;\n"
    "MOV R0.x, c[6];\n"
    "MUL R0.w, R0.x, c[1].x;\n"
    "RCP R0.z, R0.z;\n"
    "ADD R0.x, -R0.y, R0.z;\n"
    "RCP R0.y, R0.w;\n"
    "MUL R0.zw, fragment.position.xyxy, c[5].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MUL R0.x, R0, R0.y;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MUL R2.xyz, R0, R1.w;\n"
    "MUL R3.xyz, R0.w, R1;\n"
    "MIN R2.xyz, R2, R3;\n"
    "ADD R2.w, -R1, c[6].z;\n"
    "MAD R0.xyz, R0, R2.w, R2;\n"
    "ADD R2.x, R0.w, R1.w;\n"
    "ADD R2.y, -R0.w, c[6].z;\n"
    "MAD result.color.xyz, R1, R2.y, R0;\n"
    "MAD result.color.w, -R0, R1, R2.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_LIGHTEN_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[7] = { program.local[0..5],\n"
    "		{ 2, 4, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.y, R0.x, c[6].x;\n"
    "MUL R0.z, R0, c[6].y;\n"
    "MAD R0.x, R0.y, R0.y, -R0.z;\n"
    "RSQ R0.z, R0.x;\n"
    "MOV R0.x, c[6];\n"
    "MUL R0.w, R0.x, c[1].x;\n"
    "RCP R0.z, R0.z;\n"
    "ADD R0.x, -R0.y, R0.z;\n"
    "RCP R0.y, R0.w;\n"
    "MUL R0.zw, fragment.position.xyxy, c[5].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MUL R0.x, R0, R0.y;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MUL R2.xyz, R0, R1.w;\n"
    "MUL R3.xyz, R0.w, R1;\n"
    "MAX R2.xyz, R2, R3;\n"
    "ADD R2.w, -R1, c[6].z;\n"
    "MAD R0.xyz, R0, R2.w, R2;\n"
    "ADD R2.x, R0.w, R1.w;\n"
    "ADD R2.y, -R0.w, c[6].z;\n"
    "MAD result.color.xyz, R1, R2.y, R0;\n"
    "MAD result.color.w, -R0, R1, R2.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_COLORDODGE_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[7] = { program.local[0..5],\n"
    "		{ 2, 4, 1, 1e-006 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.y, R0.x, c[6].x;\n"
    "MOV R0.x, c[6];\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.z, R0, c[6].y;\n"
    "MAD R0.z, R0.y, R0.y, -R0;\n"
    "MUL R0.w, R0.x, c[1].x;\n"
    "RSQ R0.z, R0.z;\n"
    "RCP R0.x, R0.z;\n"
    "RCP R0.z, R0.w;\n"
    "ADD R0.x, -R0.y, R0;\n"
    "MUL R0.x, R0, R0.z;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MAX R1.x, R0.w, c[6].w;\n"
    "RCP R1.x, R1.x;\n"
    "MAD R1.xyz, -R0, R1.x, c[6].z;\n"
    "MAX R2.xyz, R1, c[6].w;\n"
    "MUL R1.xy, fragment.position, c[5];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "ADD R2.w, -R0, c[6].z;\n"
    "MUL R3.xyz, R1, R2.w;\n"
    "ADD R2.w, -R1, c[6].z;\n"
    "MAD R3.xyz, R0, R2.w, R3;\n"
    "MUL R1.xyz, R0.w, R1;\n"
    "MAD R0.xyz, R0, R1.w, R1;\n"
    "MUL R2.w, R0, R1;\n"
    "RCP R2.x, R2.x;\n"
    "RCP R2.y, R2.y;\n"
    "RCP R2.z, R2.z;\n"
    "MAD R2.xyz, R1, R2, R3;\n"
    "MAD R3.xyz, R0.w, R1.w, R3;\n"
    "ADD R1.x, R0.w, R1.w;\n"
    "ADD R3.xyz, R3, -R2;\n"
    "SGE R0.xyz, R0, R2.w;\n"
    "MAD result.color.xyz, R0, R3, R2;\n"
    "MAD result.color.w, -R0, R1, R1.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_COLORBURN_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[7] = { program.local[0..5],\n"
    "		{ 2, 4, 1, 9.9999997e-006 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "TEMP R5;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.y, R0.x, c[6].x;\n"
    "MUL R0.z, R0, c[6].y;\n"
    "MAD R0.x, R0.y, R0.y, -R0.z;\n"
    "RSQ R0.z, R0.x;\n"
    "MOV R0.x, c[6];\n"
    "MUL R0.w, R0.x, c[1].x;\n"
    "RCP R0.z, R0.z;\n"
    "ADD R0.x, -R0.y, R0.z;\n"
    "RCP R0.y, R0.w;\n"
    "MUL R0.zw, fragment.position.xyxy, c[5].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MUL R0.x, R0, R0.y;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MUL R2.xyz, R0.w, R1;\n"
    "MAD R3.xyz, R0, R1.w, R2;\n"
    "ADD R2.w, -R1, c[6].z;\n"
    "MAD R2.xyz, -R0.w, R1.w, R3;\n"
    "MUL R4.xyz, R0.w, R2;\n"
    "MAX R2.xyz, R0, c[6].w;\n"
    "MUL R5.xyz, R0, R2.w;\n"
    "ADD R3.w, -R0, c[6].z;\n"
    "RCP R2.x, R2.x;\n"
    "RCP R2.y, R2.y;\n"
    "RCP R2.z, R2.z;\n"
    "MAD R2.xyz, R4, R2, R5;\n"
    "MUL R4.xyz, R1, R3.w;\n"
    "MAD R1.xyz, R1, R3.w, R2;\n"
    "MAD R0.xyz, R0, R2.w, R4;\n"
    "MUL R2.x, R0.w, R1.w;\n"
    "ADD R2.w, R0, R1;\n"
    "ADD R1.xyz, R1, -R0;\n"
    "SGE R2.xyz, R3, R2.x;\n"
    "MAD result.color.xyz, R2, R1, R0;\n"
    "MAD result.color.w, -R0, R1, R2;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_HARDLIGHT_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[7] = { program.local[0..5],\n"
    "		{ 2, 4, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.y, R0.x, c[6].x;\n"
    "MOV R0.x, c[6];\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.z, R0, c[6].y;\n"
    "MAD R0.z, R0.y, R0.y, -R0;\n"
    "MUL R1.xy, fragment.position, c[5];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "MUL R0.w, R0.x, c[1].x;\n"
    "RSQ R0.z, R0.z;\n"
    "RCP R0.x, R0.z;\n"
    "ADD R2.w, -R1, c[6].z;\n"
    "RCP R0.z, R0.w;\n"
    "ADD R0.x, -R0.y, R0;\n"
    "MUL R0.x, R0, R0.z;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "ADD R3.xyz, R0.w, -R0;\n"
    "ADD R2.xyz, R1.w, -R1;\n"
    "MUL R2.xyz, R2, R3;\n"
    "MUL R2.xyz, R2, c[6].x;\n"
    "MAD R2.xyz, R0.w, R1.w, -R2;\n"
    "MUL R4.xyz, R0, R2.w;\n"
    "MUL R3.xyz, R0, R1;\n"
    "MAD R2.xyz, R0, R2.w, R2;\n"
    "ADD R2.w, -R0, c[6].z;\n"
    "MUL R0.xyz, R0, c[6].x;\n"
    "MAD R2.xyz, R1, R2.w, R2;\n"
    "MAD R3.xyz, R3, c[6].x, R4;\n"
    "MAD R1.xyz, R1, R2.w, R3;\n"
    "ADD R2.w, R0, R1;\n"
    "ADD R2.xyz, R2, -R1;\n"
    "SGE R0.xyz, R0, R0.w;\n"
    "MAD result.color.xyz, R0, R2, R1;\n"
    "MAD result.color.w, -R0, R1, R2;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_SOFTLIGHT_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[8] = { program.local[0..5],\n"
    "		{ 2, 4, 1, 9.9999997e-006 },\n"
    "		{ 16, 12, 3 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "TEMP R5;\n"
    "TEMP R6;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.y, R0.z, c[6];\n"
    "MUL R0.x, R0, c[6];\n"
    "MUL R0.zw, fragment.position.xyxy, c[5].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MAD R0.y, R0.x, R0.x, -R0;\n"
    "RSQ R0.y, R0.y;\n"
    "RCP R0.y, R0.y;\n"
    "ADD R0.y, -R0.x, R0;\n"
    "MOV R0.x, c[6];\n"
    "MUL R0.x, R0, c[1];\n"
    "MAX R0.z, R1.w, c[6].w;\n"
    "RCP R0.z, R0.z;\n"
    "MUL R3.xyz, R1, R0.z;\n"
    "MAD R4.xyz, R3, c[7].x, -c[7].y;\n"
    "RCP R0.x, R0.x;\n"
    "MUL R0.x, R0.y, R0;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MAD R2.xyz, R0, c[6].x, -R0.w;\n"
    "MAD R4.xyz, R3, R4, c[7].z;\n"
    "MUL R5.xyz, R1.w, R2;\n"
    "MUL R6.xyz, R5, R4;\n"
    "RSQ R2.w, R3.x;\n"
    "RCP R4.x, R2.w;\n"
    "RSQ R2.w, R3.y;\n"
    "RSQ R3.w, R3.z;\n"
    "RCP R4.y, R2.w;\n"
    "RCP R4.z, R3.w;\n"
    "ADD R4.xyz, -R3, R4;\n"
    "MUL R6.xyz, R3, R6;\n"
    "MUL R4.xyz, R5, R4;\n"
    "ADD R3.xyz, -R3, c[6].z;\n"
    "MAD R2.xyz, R2, R3, R0.w;\n"
    "MUL R3.xyz, R0, c[6].x;\n"
    "MAD R5.xyz, R0.w, R1, R6;\n"
    "MAD R4.xyz, R0.w, R1, R4;\n"
    "ADD R6.xyz, R4, -R5;\n"
    "MUL R4.xyz, R1, c[6].y;\n"
    "SGE R4.xyz, R4, R1.w;\n"
    "MAD R4.xyz, R4, R6, R5;\n"
    "MAD R4.xyz, -R1, R2, R4;\n"
    "MUL R2.xyz, R1, R2;\n"
    "SGE R3.xyz, R3, R0.w;\n"
    "MAD R2.xyz, R3, R4, R2;\n"
    "ADD R2.w, -R1, c[6].z;\n"
    "MAD R2.xyz, R0, R2.w, R2;\n"
    "ADD R0.x, R0.w, R1.w;\n"
    "ADD R0.y, -R0.w, c[6].z;\n"
    "MAD result.color.xyz, R1, R0.y, R2;\n"
    "MAD result.color.w, -R0, R1, R0.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_DIFFERENCE_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[7] = { program.local[0..5],\n"
    "		{ 2, 4 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.y, R0.x, c[6].x;\n"
    "MUL R0.z, R0, c[6].y;\n"
    "MAD R0.x, R0.y, R0.y, -R0.z;\n"
    "RSQ R0.z, R0.x;\n"
    "MOV R0.x, c[6];\n"
    "MUL R0.w, R0.x, c[1].x;\n"
    "RCP R0.z, R0.z;\n"
    "ADD R0.x, -R0.y, R0.z;\n"
    "RCP R0.y, R0.w;\n"
    "MUL R0.zw, fragment.position.xyxy, c[5].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MUL R0.x, R0, R0.y;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MUL R2.xyz, R0, R1.w;\n"
    "MUL R3.xyz, R0.w, R1;\n"
    "ADD R0.xyz, R0, R1;\n"
    "MIN R2.xyz, R2, R3;\n"
    "ADD R1.x, R0.w, R1.w;\n"
    "MAD result.color.xyz, -R2, c[6].x, R0;\n"
    "MAD result.color.w, -R0, R1, R1.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_EXCLUSION_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[7] = { program.local[0..5],\n"
    "		{ 2, 4, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.y, R0.x, c[6].x;\n"
    "MUL R0.z, R0, c[6].y;\n"
    "MAD R0.x, R0.y, R0.y, -R0.z;\n"
    "RSQ R0.z, R0.x;\n"
    "MOV R0.x, c[6];\n"
    "MUL R0.w, R0.x, c[1].x;\n"
    "RCP R0.z, R0.z;\n"
    "ADD R0.x, -R0.y, R0.z;\n"
    "RCP R0.y, R0.w;\n"
    "MUL R0.zw, fragment.position.xyxy, c[5].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MUL R0.x, R0, R0.y;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MUL R2.xyz, R0.w, R1;\n"
    "MAD R3.xyz, R0, R1.w, R2;\n"
    "MUL R2.xyz, R0, R1;\n"
    "MAD R2.xyz, -R2, c[6].x, R3;\n"
    "ADD R2.w, -R1, c[6].z;\n"
    "MAD R0.xyz, R0, R2.w, R2;\n"
    "ADD R2.x, R0.w, R1.w;\n"
    "ADD R2.y, -R0.w, c[6].z;\n"
    "MAD result.color.xyz, R1, R2.y, R0;\n"
    "MAD result.color.w, -R0, R1, R2.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODE_BLEND_MODE_MASK =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 2, 4 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "ADD R0.z, R0, R0.w;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.y, R0.z, c[8];\n"
    "MUL R0.x, R0, c[8];\n"
    "MAD R0.y, R0.x, R0.x, -R0;\n"
    "RSQ R0.y, R0.y;\n"
    "RCP R0.y, R0.y;\n"
    "ADD R1.x, -R0, R0.y;\n"
    "MOV R0.x, c[8];\n"
    "MUL R0.x, R0, c[1];\n"
    "RCP R1.y, R0.x;\n"
    "ADD R0.zw, fragment.position.xyxy, c[6].xyxy;\n"
    "MUL R0.zw, R0, c[5].xyxy;\n"
    "TEX R0, R0.zwzw, texture[0], 2D;\n"
    "MUL R1.x, R1, R1.y;\n"
    "DP4 R1.y, R0, c[7];\n"
    "TEX R0, R1, texture[1], 1D;\n"
    "MUL result.color, R0, R1.y;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODE_BLEND_MODE_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 2, 4 } };\n"
    "TEMP R0;\n"
    "MUL R0.xyz, fragment.position.y, c[3];\n"
    "MAD R0.xyz, fragment.position.x, c[2], R0;\n"
    "ADD R0.xyz, R0, c[4];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.xyxy;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.z, R0, R0.w;\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.z, -R0, c[1].x;\n"
    "MUL R0.y, R0.z, c[5];\n"
    "MUL R0.x, R0, c[5];\n"
    "MAD R0.z, R0.x, R0.x, -R0.y;\n"
    "MOV R0.y, c[5].x;\n"
    "RSQ R0.z, R0.z;\n"
    "MUL R0.w, R0.y, c[1].x;\n"
    "RCP R0.y, R0.z;\n"
    "RCP R0.z, R0.w;\n"
    "ADD R0.x, -R0, R0.y;\n"
    "MUL R0.x, R0, R0.z;\n"
    "TEX result.color, R0, texture[0], 1D;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_SIMPLE_PORTER_DUFF =
    "!!ARBfp1.0\n"
    "PARAM c[13] = { program.local[0..9],\n"
    "		{ 0.15915494, 0.0020000001, 3.141593, 1.570796 },\n"
    "		{ -0.01348047, 0.05747731, 0.1212391, 0.1956359 },\n"
    "		{ 0.33299461, 0.99999559, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ABS R0.z, R0.x;\n"
    "ABS R0.w, R0.y;\n"
    "ADD R0.w, R0, -R0.z;\n"
    "ADD R1.x, R0.y, c[10].y;\n"
    "ABS R0.w, R0;\n"
    "CMP R0.y, -R0.w, R0, R1.x;\n"
    "ABS R0.w, -R0.y;\n"
    "MAX R1.x, R0.z, R0.w;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.z, R0.w;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[11].x, c[11].y;\n"
    "MAD R1.z, R1, R1.y, -c[11];\n"
    "MAD R1.z, R1, R1.y, c[11].w;\n"
    "MAD R1.z, R1, R1.y, -c[12].x;\n"
    "MAD R1.y, R1.z, R1, c[12];\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R1.y, -R1.x, c[10].w;\n"
    "ADD R0.z, -R0, R0.w;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[10].z;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R1.x, R0, c[10];\n"
    "FLR R1.y, R1.x;\n"
    "MUL R0.xy, fragment.position, c[7];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "ADD R1.x, R1, -R1.y;\n"
    "TEX R1, R1, texture[2], 1D;\n"
    "MUL R2.xyz, R0, c[4].y;\n"
    "MUL R3.xyz, R1.w, R2;\n"
    "MUL R2.xyz, R1, c[4].x;\n"
    "MAD R2.xyz, R0.w, R2, R3;\n"
    "ADD R3.xy, fragment.position, c[8];\n"
    "ADD R2.w, -R0, c[12].z;\n"
    "MUL R1.xyz, R1, c[5].y;\n"
    "MAD R2.xyz, R2.w, R1, R2;\n"
    "MUL R1.xyz, R0, c[5].z;\n"
    "ADD R3.z, -R1.w, c[12];\n"
    "MAD R2.xyz, R3.z, R1, R2;\n"
    "MUL R1.y, R1.w, R2.w;\n"
    "MUL R1.x, R1.w, R0.w;\n"
    "MUL R1.z, R0.w, R3;\n"
    "DP3 R2.w, R1, c[5];\n"
    "MUL R3.xy, R3, c[6];\n"
    "TEX R1, R3, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[9];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_MULTIPLY =
    "!!ARBfp1.0\n"
    "PARAM c[11] = { program.local[0..7],\n"
    "		{ 0.15915494, 0.0020000001, 3.141593, 1.570796 },\n"
    "		{ -0.01348047, 0.05747731, 0.1212391, 0.1956359 },\n"
    "		{ 0.33299461, 0.99999559, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ABS R0.z, R0.x;\n"
    "ABS R0.w, R0.y;\n"
    "ADD R0.w, R0, -R0.z;\n"
    "ADD R1.x, R0.y, c[8].y;\n"
    "ABS R0.w, R0;\n"
    "CMP R0.y, -R0.w, R0, R1.x;\n"
    "ABS R0.w, -R0.y;\n"
    "MAX R1.x, R0.z, R0.w;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.z, R0.w;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[9].x, c[9].y;\n"
    "MAD R1.z, R1, R1.y, -c[9];\n"
    "MAD R1.z, R1, R1.y, c[9].w;\n"
    "MAD R1.z, R1, R1.y, -c[10].x;\n"
    "MAD R1.y, R1.z, R1, c[10];\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R1.y, -R1.x, c[8].w;\n"
    "ADD R0.z, -R0, R0.w;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[8].z;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R1.x, R0, c[8];\n"
    "FLR R1.y, R1.x;\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "ADD R1.x, R1, -R1.y;\n"
    "TEX R1, R1, texture[2], 1D;\n"
    "ADD R2.x, -R0.w, c[10].z;\n"
    "MUL R2.xyz, R1, R2.x;\n"
    "MAD R1.xyz, R1, R0, R2;\n"
    "ADD R2.x, -R1.w, c[10].z;\n"
    "MAD R2.xyz, R0, R2.x, R1;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[6];\n"
    "MUL R1.xy, R1, c[4];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_SCREEN =
    "!!ARBfp1.0\n"
    "PARAM c[11] = { program.local[0..7],\n"
    "		{ 0.15915494, 0.0020000001, 3.141593, 1.570796 },\n"
    "		{ -0.01348047, 0.05747731, 0.1212391, 0.1956359 },\n"
    "		{ 0.33299461, 0.99999559 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ADD R3.xy, fragment.position, c[6];\n"
    "ABS R0.z, R0.x;\n"
    "ABS R0.w, R0.y;\n"
    "ADD R0.w, R0, -R0.z;\n"
    "ADD R1.x, R0.y, c[8].y;\n"
    "ABS R0.w, R0;\n"
    "CMP R0.y, -R0.w, R0, R1.x;\n"
    "ABS R0.w, -R0.y;\n"
    "MAX R1.x, R0.z, R0.w;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.z, R0.w;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[9].x, c[9].y;\n"
    "MAD R1.z, R1, R1.y, -c[9];\n"
    "MAD R1.z, R1, R1.y, c[9].w;\n"
    "MAD R1.z, R1, R1.y, -c[10].x;\n"
    "MAD R1.y, R1.z, R1, c[10];\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R0.z, -R0, R0.w;\n"
    "ADD R1.y, -R1.x, c[8].w;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[8].z;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R0.x, R0, c[8];\n"
    "FLR R0.y, R0.x;\n"
    "ADD R0.z, R0.x, -R0.y;\n"
    "TEX R1, R0.z, texture[2], 1D;\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "ADD R2, R1, R0;\n"
    "MAD R2, -R1, R0, R2;\n"
    "MUL R3.xy, R3, c[4];\n"
    "TEX R1, R3, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_OVERLAY =
    "!!ARBfp1.0\n"
    "PARAM c[11] = { program.local[0..7],\n"
    "		{ 0.0020000001, -0.01348047, 0.05747731, 0.1212391 },\n"
    "		{ 0.1956359, 0.33299461, 0.99999559, 1.570796 },\n"
    "		{ 3.141593, 0.15915494, 2, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ABS R0.z, R0.x;\n"
    "ABS R0.w, R0.y;\n"
    "ADD R0.w, R0, -R0.z;\n"
    "ADD R1.x, R0.y, c[8];\n"
    "ABS R0.w, R0;\n"
    "CMP R0.y, -R0.w, R0, R1.x;\n"
    "ABS R0.w, -R0.y;\n"
    "MAX R1.x, R0.z, R0.w;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.z, R0.w;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[8].y, c[8];\n"
    "MAD R1.z, R1, R1.y, -c[8].w;\n"
    "MAD R1.z, R1, R1.y, c[9].x;\n"
    "MAD R1.z, R1, R1.y, -c[9].y;\n"
    "MAD R1.y, R1.z, R1, c[9].z;\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R0.z, -R0, R0.w;\n"
    "ADD R1.y, -R1.x, c[9].w;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[10].x;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R0.x, R0, c[10].y;\n"
    "FLR R0.y, R0.x;\n"
    "ADD R0.x, R0, -R0.y;\n"
    "TEX R0, R0, texture[2], 1D;\n"
    "MUL R1.xy, fragment.position, c[5];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "ADD R2.w, -R1, c[10];\n"
    "ADD R3.xyz, R0.w, -R0;\n"
    "ADD R2.xyz, R1.w, -R1;\n"
    "MUL R2.xyz, R2, R3;\n"
    "MUL R2.xyz, R2, c[10].z;\n"
    "MAD R2.xyz, R0.w, R1.w, -R2;\n"
    "MUL R4.xyz, R0, R2.w;\n"
    "MUL R3.xyz, R0, R1;\n"
    "MAD R0.xyz, R0, R2.w, R2;\n"
    "ADD R2.x, -R0.w, c[10].w;\n"
    "MAD R3.xyz, R3, c[10].z, R4;\n"
    "MAD R3.xyz, R1, R2.x, R3;\n"
    "MAD R0.xyz, R1, R2.x, R0;\n"
    "MUL R2.xyz, R1, c[10].z;\n"
    "ADD R0.xyz, R0, -R3;\n"
    "SGE R2.xyz, R2, R1.w;\n"
    "MAD R2.xyz, R2, R0, R3;\n"
    "ADD R0.z, R0.w, R1.w;\n"
    "MAD R2.w, -R0, R1, R0.z;\n"
    "ADD R0.xy, fragment.position, c[6];\n"
    "MUL R0.xy, R0, c[4];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "ADD R2, R2, -R1;\n"
    "DP4 R0.x, R0, c[7];\n"
    "MAD result.color, R0.x, R2, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_DARKEN =
    "!!ARBfp1.0\n"
    "PARAM c[11] = { program.local[0..7],\n"
    "		{ 0.15915494, 0.0020000001, 3.141593, 1.570796 },\n"
    "		{ -0.01348047, 0.05747731, 0.1212391, 0.1956359 },\n"
    "		{ 0.33299461, 0.99999559, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ABS R0.z, R0.x;\n"
    "ABS R0.w, R0.y;\n"
    "ADD R0.w, R0, -R0.z;\n"
    "ADD R1.x, R0.y, c[8].y;\n"
    "ABS R0.w, R0;\n"
    "CMP R0.y, -R0.w, R0, R1.x;\n"
    "ABS R0.w, -R0.y;\n"
    "MAX R1.x, R0.z, R0.w;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.z, R0.w;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[9].x, c[9].y;\n"
    "MAD R1.z, R1, R1.y, -c[9];\n"
    "MAD R1.z, R1, R1.y, c[9].w;\n"
    "MAD R1.z, R1, R1.y, -c[10].x;\n"
    "MAD R1.y, R1.z, R1, c[10];\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R1.y, -R1.x, c[8].w;\n"
    "ADD R0.z, -R0, R0.w;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[8].z;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R0.z, R0.x, c[8].x;\n"
    "FLR R0.w, R0.z;\n"
    "ADD R1.x, R0.z, -R0.w;\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "TEX R1, R1, texture[2], 1D;\n"
    "MUL R3.xyz, R1.w, R0;\n"
    "MUL R2.xyz, R1, R0.w;\n"
    "MIN R2.xyz, R2, R3;\n"
    "ADD R2.w, -R0, c[10].z;\n"
    "MAD R1.xyz, R1, R2.w, R2;\n"
    "ADD R2.x, -R1.w, c[10].z;\n"
    "MAD R2.xyz, R0, R2.x, R1;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[6];\n"
    "MUL R1.xy, R1, c[4];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_LIGHTEN =
    "!!ARBfp1.0\n"
    "PARAM c[11] = { program.local[0..7],\n"
    "		{ 0.15915494, 0.0020000001, 3.141593, 1.570796 },\n"
    "		{ -0.01348047, 0.05747731, 0.1212391, 0.1956359 },\n"
    "		{ 0.33299461, 0.99999559, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ABS R0.z, R0.x;\n"
    "ABS R0.w, R0.y;\n"
    "ADD R0.w, R0, -R0.z;\n"
    "ADD R1.x, R0.y, c[8].y;\n"
    "ABS R0.w, R0;\n"
    "CMP R0.y, -R0.w, R0, R1.x;\n"
    "ABS R0.w, -R0.y;\n"
    "MAX R1.x, R0.z, R0.w;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.z, R0.w;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[9].x, c[9].y;\n"
    "MAD R1.z, R1, R1.y, -c[9];\n"
    "MAD R1.z, R1, R1.y, c[9].w;\n"
    "MAD R1.z, R1, R1.y, -c[10].x;\n"
    "MAD R1.y, R1.z, R1, c[10];\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R1.y, -R1.x, c[8].w;\n"
    "ADD R0.z, -R0, R0.w;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[8].z;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R0.z, R0.x, c[8].x;\n"
    "FLR R0.w, R0.z;\n"
    "ADD R1.x, R0.z, -R0.w;\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "TEX R1, R1, texture[2], 1D;\n"
    "MUL R3.xyz, R1.w, R0;\n"
    "MUL R2.xyz, R1, R0.w;\n"
    "MAX R2.xyz, R2, R3;\n"
    "ADD R2.w, -R0, c[10].z;\n"
    "MAD R1.xyz, R1, R2.w, R2;\n"
    "ADD R2.x, -R1.w, c[10].z;\n"
    "MAD R2.xyz, R0, R2.x, R1;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[6];\n"
    "MUL R1.xy, R1, c[4];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_COLORDODGE =
    "!!ARBfp1.0\n"
    "PARAM c[11] = { program.local[0..7],\n"
    "		{ 0.0020000001, -0.01348047, 0.05747731, 0.1212391 },\n"
    "		{ 0.1956359, 0.33299461, 0.99999559, 1.570796 },\n"
    "		{ 3.141593, 0.15915494, 1, 1e-006 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ABS R0.z, R0.x;\n"
    "ABS R0.w, R0.y;\n"
    "ADD R0.w, R0, -R0.z;\n"
    "ADD R1.x, R0.y, c[8];\n"
    "ABS R0.w, R0;\n"
    "CMP R0.y, -R0.w, R0, R1.x;\n"
    "ABS R0.w, -R0.y;\n"
    "MAX R1.x, R0.z, R0.w;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.z, R0.w;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[8].y, c[8];\n"
    "MAD R1.z, R1, R1.y, -c[8].w;\n"
    "MAD R1.z, R1, R1.y, c[9].x;\n"
    "MAD R1.z, R1, R1.y, -c[9].y;\n"
    "MAD R1.y, R1.z, R1, c[9].z;\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R1.y, -R1.x, c[9].w;\n"
    "ADD R0.z, -R0, R0.w;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[10].x;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R0.x, R0, c[10].y;\n"
    "FLR R0.y, R0.x;\n"
    "ADD R0.x, R0, -R0.y;\n"
    "TEX R0, R0, texture[2], 1D;\n"
    "MAX R1.x, R0.w, c[10].w;\n"
    "RCP R1.x, R1.x;\n"
    "MAD R1.xyz, -R0, R1.x, c[10].z;\n"
    "MAX R2.xyz, R1, c[10].w;\n"
    "MUL R1.xy, fragment.position, c[5];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "ADD R2.w, -R0, c[10].z;\n"
    "MUL R3.xyz, R1, R2.w;\n"
    "ADD R2.w, -R1, c[10].z;\n"
    "MAD R4.xyz, R0, R2.w, R3;\n"
    "MUL R3.xyz, R0.w, R1;\n"
    "MUL R2.w, R0, R1;\n"
    "MAD R0.xyz, R0, R1.w, R3;\n"
    "SGE R0.xyz, R0, R2.w;\n"
    "RCP R2.x, R2.x;\n"
    "RCP R2.y, R2.y;\n"
    "RCP R2.z, R2.z;\n"
    "MAD R2.xyz, R3, R2, R4;\n"
    "MAD R4.xyz, R0.w, R1.w, R4;\n"
    "ADD R4.xyz, R4, -R2;\n"
    "MAD R2.xyz, R0, R4, R2;\n"
    "ADD R0.z, R0.w, R1.w;\n"
    "MAD R2.w, -R0, R1, R0.z;\n"
    "ADD R0.xy, fragment.position, c[6];\n"
    "MUL R0.xy, R0, c[4];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "ADD R2, R2, -R1;\n"
    "DP4 R0.x, R0, c[7];\n"
    "MAD result.color, R0.x, R2, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_COLORBURN =
    "!!ARBfp1.0\n"
    "PARAM c[11] = { program.local[0..7],\n"
    "		{ 0.0020000001, -0.01348047, 0.05747731, 0.1212391 },\n"
    "		{ 0.1956359, 0.33299461, 0.99999559, 1.570796 },\n"
    "		{ 3.141593, 0.15915494, 1, 9.9999997e-006 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "TEMP R5;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ABS R0.w, R0.x;\n"
    "ABS R0.z, R0.y;\n"
    "ADD R0.z, R0, -R0.w;\n"
    "ADD R1.x, R0.y, c[8];\n"
    "ABS R0.z, R0;\n"
    "CMP R0.y, -R0.z, R0, R1.x;\n"
    "ABS R0.z, -R0.y;\n"
    "MAX R1.x, R0.w, R0.z;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.w, R0.z;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[8].y, c[8];\n"
    "MAD R1.z, R1, R1.y, -c[8].w;\n"
    "MAD R1.z, R1, R1.y, c[9].x;\n"
    "MAD R1.z, R1, R1.y, -c[9].y;\n"
    "MAD R1.y, R1.z, R1, c[9].z;\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R1.y, -R1.x, c[9].w;\n"
    "ADD R0.z, -R0.w, R0;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[10].x;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "MUL R0.zw, fragment.position.xyxy, c[5].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R0.x, R0, c[10].y;\n"
    "FLR R0.y, R0.x;\n"
    "ADD R0.x, R0, -R0.y;\n"
    "TEX R0, R0, texture[2], 1D;\n"
    "MUL R2.xyz, R0.w, R1;\n"
    "MAD R3.xyz, R0, R1.w, R2;\n"
    "MAD R2.xyz, -R0.w, R1.w, R3;\n"
    "MUL R4.xyz, R0.w, R2;\n"
    "MAX R2.xyz, R0, c[10].w;\n"
    "ADD R2.w, -R1, c[10].z;\n"
    "ADD R3.w, -R0, c[10].z;\n"
    "MUL R5.xyz, R0, R2.w;\n"
    "RCP R2.x, R2.x;\n"
    "RCP R2.y, R2.y;\n"
    "RCP R2.z, R2.z;\n"
    "MAD R2.xyz, R4, R2, R5;\n"
    "MUL R4.xyz, R1, R3.w;\n"
    "MAD R0.xyz, R0, R2.w, R4;\n"
    "MUL R2.w, R0, R1;\n"
    "MAD R2.xyz, R1, R3.w, R2;\n"
    "ADD R2.xyz, R2, -R0;\n"
    "SGE R3.xyz, R3, R2.w;\n"
    "MAD R2.xyz, R3, R2, R0;\n"
    "ADD R0.z, R0.w, R1.w;\n"
    "MAD R2.w, -R0, R1, R0.z;\n"
    "ADD R0.xy, fragment.position, c[6];\n"
    "MUL R0.xy, R0, c[4];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "ADD R2, R2, -R1;\n"
    "DP4 R0.x, R0, c[7];\n"
    "MAD result.color, R0.x, R2, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_HARDLIGHT =
    "!!ARBfp1.0\n"
    "PARAM c[11] = { program.local[0..7],\n"
    "		{ 0.0020000001, -0.01348047, 0.05747731, 0.1212391 },\n"
    "		{ 0.1956359, 0.33299461, 0.99999559, 1.570796 },\n"
    "		{ 3.141593, 0.15915494, 2, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ABS R0.z, R0.x;\n"
    "ABS R0.w, R0.y;\n"
    "ADD R0.w, R0, -R0.z;\n"
    "ADD R1.x, R0.y, c[8];\n"
    "ABS R0.w, R0;\n"
    "CMP R0.y, -R0.w, R0, R1.x;\n"
    "ABS R0.w, -R0.y;\n"
    "MAX R1.x, R0.z, R0.w;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.z, R0.w;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[8].y, c[8];\n"
    "MAD R1.z, R1, R1.y, -c[8].w;\n"
    "MAD R1.z, R1, R1.y, c[9].x;\n"
    "MAD R1.z, R1, R1.y, -c[9].y;\n"
    "MAD R1.y, R1.z, R1, c[9].z;\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R0.z, -R0, R0.w;\n"
    "ADD R1.y, -R1.x, c[9].w;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[10].x;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R0.x, R0, c[10].y;\n"
    "FLR R0.y, R0.x;\n"
    "ADD R0.x, R0, -R0.y;\n"
    "TEX R0, R0, texture[2], 1D;\n"
    "MUL R1.xy, fragment.position, c[5];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "ADD R2.w, -R1, c[10];\n"
    "ADD R3.xyz, R0.w, -R0;\n"
    "ADD R2.xyz, R1.w, -R1;\n"
    "MUL R2.xyz, R2, R3;\n"
    "MUL R2.xyz, R2, c[10].z;\n"
    "MAD R2.xyz, R0.w, R1.w, -R2;\n"
    "MUL R4.xyz, R0, R2.w;\n"
    "MAD R2.xyz, R0, R2.w, R2;\n"
    "MUL R3.xyz, R0, R1;\n"
    "ADD R2.w, -R0, c[10];\n"
    "MAD R3.xyz, R3, c[10].z, R4;\n"
    "MUL R0.xyz, R0, c[10].z;\n"
    "SGE R0.xyz, R0, R0.w;\n"
    "MAD R3.xyz, R1, R2.w, R3;\n"
    "MAD R2.xyz, R1, R2.w, R2;\n"
    "ADD R2.xyz, R2, -R3;\n"
    "MAD R2.xyz, R0, R2, R3;\n"
    "ADD R0.z, R0.w, R1.w;\n"
    "MAD R2.w, -R0, R1, R0.z;\n"
    "ADD R0.xy, fragment.position, c[6];\n"
    "MUL R0.xy, R0, c[4];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "ADD R2, R2, -R1;\n"
    "DP4 R0.x, R0, c[7];\n"
    "MAD result.color, R0.x, R2, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_SOFTLIGHT =
    "!!ARBfp1.0\n"
    "PARAM c[13] = { program.local[0..7],\n"
    "		{ 0.0020000001, -0.01348047, 0.05747731, 0.1212391 },\n"
    "		{ 0.1956359, 0.33299461, 0.99999559, 1.570796 },\n"
    "		{ 3.141593, 0.15915494, 1, 2 },\n"
    "		{ 9.9999997e-006, 4, 16, 12 },\n"
    "		{ 3 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "TEMP R5;\n"
    "TEMP R6;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ABS R0.w, R0.x;\n"
    "ABS R0.z, R0.y;\n"
    "ADD R0.z, R0, -R0.w;\n"
    "ADD R1.x, R0.y, c[8];\n"
    "ABS R0.z, R0;\n"
    "CMP R0.y, -R0.z, R0, R1.x;\n"
    "ABS R0.z, -R0.y;\n"
    "MAX R1.x, R0.w, R0.z;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.w, R0.z;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[8].y, c[8];\n"
    "MAD R1.z, R1, R1.y, -c[8].w;\n"
    "MAD R1.z, R1, R1.y, c[9].x;\n"
    "MAD R1.z, R1, R1.y, -c[9].y;\n"
    "MAD R1.y, R1.z, R1, c[9].z;\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R1.y, -R1.x, c[9].w;\n"
    "ADD R0.z, -R0.w, R0;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[10].x;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "MUL R0.zw, fragment.position.xyxy, c[5].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "MAX R0.z, R1.w, c[11].x;\n"
    "RCP R2.x, R0.z;\n"
    "MUL R3.xyz, R1, R2.x;\n"
    "MAD R4.xyz, R3, c[11].z, -c[11].w;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R0.x, R0, c[10].y;\n"
    "FLR R0.y, R0.x;\n"
    "ADD R0.x, R0, -R0.y;\n"
    "TEX R0, R0, texture[2], 1D;\n"
    "MAD R2.xyz, R0, c[10].w, -R0.w;\n"
    "MAD R4.xyz, R3, R4, c[12].x;\n"
    "MUL R5.xyz, R1.w, R2;\n"
    "MUL R6.xyz, R5, R4;\n"
    "RSQ R2.w, R3.x;\n"
    "RCP R4.x, R2.w;\n"
    "RSQ R2.w, R3.y;\n"
    "RSQ R3.w, R3.z;\n"
    "RCP R4.y, R2.w;\n"
    "RCP R4.z, R3.w;\n"
    "ADD R4.xyz, -R3, R4;\n"
    "MUL R6.xyz, R3, R6;\n"
    "MUL R4.xyz, R5, R4;\n"
    "ADD R3.xyz, -R3, c[10].z;\n"
    "MAD R2.xyz, R2, R3, R0.w;\n"
    "MUL R3.xyz, R0, c[10].w;\n"
    "MAD R5.xyz, R0.w, R1, R6;\n"
    "MAD R4.xyz, R0.w, R1, R4;\n"
    "ADD R6.xyz, R4, -R5;\n"
    "MUL R4.xyz, R1, c[11].y;\n"
    "SGE R4.xyz, R4, R1.w;\n"
    "MAD R4.xyz, R4, R6, R5;\n"
    "MAD R4.xyz, -R1, R2, R4;\n"
    "SGE R3.xyz, R3, R0.w;\n"
    "MUL R2.xyz, R1, R2;\n"
    "ADD R2.w, -R1, c[10].z;\n"
    "MAD R2.xyz, R3, R4, R2;\n"
    "MAD R2.xyz, R0, R2.w, R2;\n"
    "ADD R0.x, -R0.w, c[10].z;\n"
    "MAD R2.xyz, R1, R0.x, R2;\n"
    "ADD R0.z, R0.w, R1.w;\n"
    "MAD R2.w, -R0, R1, R0.z;\n"
    "ADD R0.xy, fragment.position, c[6];\n"
    "MUL R0.xy, R0, c[4];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "ADD R2, R2, -R1;\n"
    "DP4 R0.x, R0, c[7];\n"
    "MAD result.color, R0.x, R2, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_DIFFERENCE =
    "!!ARBfp1.0\n"
    "PARAM c[11] = { program.local[0..7],\n"
    "		{ 0.15915494, 0.0020000001, 3.141593, 1.570796 },\n"
    "		{ -0.01348047, 0.05747731, 0.1212391, 0.1956359 },\n"
    "		{ 0.33299461, 0.99999559, 2 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ABS R0.z, R0.x;\n"
    "ABS R0.w, R0.y;\n"
    "ADD R0.w, R0, -R0.z;\n"
    "ADD R1.x, R0.y, c[8].y;\n"
    "ABS R0.w, R0;\n"
    "CMP R0.y, -R0.w, R0, R1.x;\n"
    "ABS R0.w, -R0.y;\n"
    "MAX R1.x, R0.z, R0.w;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.z, R0.w;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[9].x, c[9].y;\n"
    "MAD R1.z, R1, R1.y, -c[9];\n"
    "MAD R1.z, R1, R1.y, c[9].w;\n"
    "MAD R1.z, R1, R1.y, -c[10].x;\n"
    "MAD R1.y, R1.z, R1, c[10];\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R1.y, -R1.x, c[8].w;\n"
    "ADD R0.z, -R0, R0.w;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[8].z;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R0.z, R0.x, c[8].x;\n"
    "FLR R0.w, R0.z;\n"
    "ADD R1.x, R0.z, -R0.w;\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "TEX R1, R1, texture[2], 1D;\n"
    "ADD R2.xyz, R1, R0;\n"
    "MUL R3.xyz, R1.w, R0;\n"
    "MUL R1.xyz, R1, R0.w;\n"
    "MIN R1.xyz, R1, R3;\n"
    "MAD R2.xyz, -R1, c[10].z, R2;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[6];\n"
    "MUL R1.xy, R1, c[4];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_EXCLUSION =
    "!!ARBfp1.0\n"
    "PARAM c[11] = { program.local[0..7],\n"
    "		{ 0.15915494, 0.0020000001, 3.141593, 1.570796 },\n"
    "		{ -0.01348047, 0.05747731, 0.1212391, 0.1956359 },\n"
    "		{ 0.33299461, 0.99999559, 2, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ABS R0.z, R0.x;\n"
    "ABS R0.w, R0.y;\n"
    "ADD R0.w, R0, -R0.z;\n"
    "ADD R1.x, R0.y, c[8].y;\n"
    "ABS R0.w, R0;\n"
    "CMP R0.y, -R0.w, R0, R1.x;\n"
    "ABS R0.w, -R0.y;\n"
    "MAX R1.x, R0.z, R0.w;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.z, R0.w;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[9].x, c[9].y;\n"
    "MAD R1.z, R1, R1.y, -c[9];\n"
    "MAD R1.z, R1, R1.y, c[9].w;\n"
    "MAD R1.z, R1, R1.y, -c[10].x;\n"
    "MAD R1.y, R1.z, R1, c[10];\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R1.y, -R1.x, c[8].w;\n"
    "ADD R0.z, -R0, R0.w;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[8].z;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R0.z, R0.x, c[8].x;\n"
    "FLR R0.w, R0.z;\n"
    "ADD R1.x, R0.z, -R0.w;\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "TEX R1, R1, texture[2], 1D;\n"
    "MUL R2.xyz, R1.w, R0;\n"
    "MAD R3.xyz, R1, R0.w, R2;\n"
    "MUL R2.xyz, R1, R0;\n"
    "MAD R2.xyz, -R2, c[10].z, R3;\n"
    "ADD R2.w, -R0, c[10];\n"
    "MAD R1.xyz, R1, R2.w, R2;\n"
    "ADD R2.x, -R1.w, c[10].w;\n"
    "MAD R2.xyz, R0, R2.x, R1;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[6];\n"
    "MUL R1.xy, R1, c[4];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_SIMPLE_PORTER_DUFF_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[10] = { program.local[0..6],\n"
    "		{ 0.15915494, 0.0020000001, 3.141593, 1.570796 },\n"
    "		{ -0.01348047, 0.05747731, 0.1212391, 0.1956359 },\n"
    "		{ 0.33299461, 0.99999559, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ABS R0.z, R0.x;\n"
    "ABS R0.w, R0.y;\n"
    "ADD R0.w, R0, -R0.z;\n"
    "ADD R1.x, R0.y, c[7].y;\n"
    "ABS R0.w, R0;\n"
    "CMP R0.y, -R0.w, R0, R1.x;\n"
    "ABS R0.w, -R0.y;\n"
    "MAX R1.x, R0.z, R0.w;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.z, R0.w;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[8].x, c[8].y;\n"
    "MAD R1.z, R1, R1.y, -c[8];\n"
    "MAD R1.z, R1, R1.y, c[8].w;\n"
    "MAD R1.z, R1, R1.y, -c[9].x;\n"
    "MAD R1.y, R1.z, R1, c[9];\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R0.z, -R0, R0.w;\n"
    "ADD R1.y, -R1.x, c[7].w;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[7].z;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "MUL R0.zw, fragment.position.xyxy, c[6].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MUL R2.xyz, R1, c[4].y;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R0.x, R0, c[7];\n"
    "FLR R0.y, R0.x;\n"
    "ADD R0.x, R0, -R0.y;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MUL R3.xyz, R0.w, R2;\n"
    "MUL R2.xyz, R0, c[4].x;\n"
    "MAD R2.xyz, R1.w, R2, R3;\n"
    "ADD R2.w, -R1, c[9].z;\n"
    "MUL R0.xyz, R0, c[5].y;\n"
    "MAD R0.xyz, R2.w, R0, R2;\n"
    "ADD R2.x, -R0.w, c[9].z;\n"
    "MUL R1.xyz, R1, c[5].z;\n"
    "MAD result.color.xyz, R2.x, R1, R0;\n"
    "MUL R0.x, R0.w, R1.w;\n"
    "MUL R0.z, R1.w, R2.x;\n"
    "MUL R0.y, R0.w, R2.w;\n"
    "DP3 result.color.w, R0, c[5];\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_MULTIPLY_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[8] = { program.local[0..4],\n"
    "		{ 0.15915494, 0.0020000001, 3.141593, 1.570796 },\n"
    "		{ -0.01348047, 0.05747731, 0.1212391, 0.1956359 },\n"
    "		{ 0.33299461, 0.99999559, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ABS R0.z, R0.x;\n"
    "ABS R0.w, R0.y;\n"
    "ADD R0.w, R0, -R0.z;\n"
    "ADD R1.x, R0.y, c[5].y;\n"
    "ABS R0.w, R0;\n"
    "CMP R0.y, -R0.w, R0, R1.x;\n"
    "ABS R0.w, -R0.y;\n"
    "MAX R1.x, R0.z, R0.w;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.z, R0.w;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[6].x, c[6].y;\n"
    "MAD R1.z, R1, R1.y, -c[6];\n"
    "MAD R1.z, R1, R1.y, c[6].w;\n"
    "MAD R1.z, R1, R1.y, -c[7].x;\n"
    "MAD R1.y, R1.z, R1, c[7];\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R0.z, -R0, R0.w;\n"
    "ADD R1.y, -R1.x, c[5].w;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[5].z;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R0.x, R0, c[5];\n"
    "FLR R0.y, R0.x;\n"
    "ADD R0.x, R0, -R0.y;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "ADD R2.x, -R1.w, c[7].z;\n"
    "MUL R2.xyz, R0, R2.x;\n"
    "MAD R0.xyz, R0, R1, R2;\n"
    "ADD R2.x, R0.w, R1.w;\n"
    "ADD R2.y, -R0.w, c[7].z;\n"
    "MAD result.color.xyz, R1, R2.y, R0;\n"
    "MAD result.color.w, -R0, R1, R2.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_SCREEN_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[8] = { program.local[0..4],\n"
    "		{ 0.15915494, 0.0020000001, 3.141593, 1.570796 },\n"
    "		{ -0.01348047, 0.05747731, 0.1212391, 0.1956359 },\n"
    "		{ 0.33299461, 0.99999559 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ABS R0.z, R0.x;\n"
    "ABS R0.w, R0.y;\n"
    "ADD R0.w, R0, -R0.z;\n"
    "ADD R1.x, R0.y, c[5].y;\n"
    "ABS R0.w, R0;\n"
    "CMP R0.y, -R0.w, R0, R1.x;\n"
    "ABS R0.w, -R0.y;\n"
    "MAX R1.x, R0.z, R0.w;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.z, R0.w;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[6].x, c[6].y;\n"
    "MAD R1.z, R1, R1.y, -c[6];\n"
    "MAD R1.z, R1, R1.y, c[6].w;\n"
    "MAD R1.z, R1, R1.y, -c[7].x;\n"
    "MAD R1.y, R1.z, R1, c[7];\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R0.z, -R0, R0.w;\n"
    "ADD R1.y, -R1.x, c[5].w;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[5].z;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R0.x, R0, c[5];\n"
    "FLR R0.y, R0.x;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "ADD R0.x, R0, -R0.y;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "ADD R2, R0, R1;\n"
    "MAD result.color, -R0, R1, R2;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_OVERLAY_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[8] = { program.local[0..4],\n"
    "		{ 0.0020000001, -0.01348047, 0.05747731, 0.1212391 },\n"
    "		{ 0.1956359, 0.33299461, 0.99999559, 1.570796 },\n"
    "		{ 3.141593, 0.15915494, 2, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ABS R0.z, R0.x;\n"
    "ABS R0.w, R0.y;\n"
    "ADD R0.w, R0, -R0.z;\n"
    "ADD R1.x, R0.y, c[5];\n"
    "ABS R0.w, R0;\n"
    "CMP R0.y, -R0.w, R0, R1.x;\n"
    "ABS R0.w, -R0.y;\n"
    "MAX R1.x, R0.z, R0.w;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.z, R0.w;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[5].y, c[5];\n"
    "MAD R1.z, R1, R1.y, -c[5].w;\n"
    "MAD R1.z, R1, R1.y, c[6].x;\n"
    "MAD R1.z, R1, R1.y, -c[6].y;\n"
    "MAD R1.y, R1.z, R1, c[6].z;\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R0.z, -R0, R0.w;\n"
    "ADD R1.y, -R1.x, c[6].w;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[7].x;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R0.x, R0, c[7].y;\n"
    "FLR R0.y, R0.x;\n"
    "ADD R0.x, R0, -R0.y;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MUL R1.xy, fragment.position, c[4];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "ADD R3.xyz, R0.w, -R0;\n"
    "ADD R2.xyz, R1.w, -R1;\n"
    "MUL R2.xyz, R2, R3;\n"
    "ADD R2.w, -R1, c[7];\n"
    "MUL R2.xyz, R2, c[7].z;\n"
    "MAD R2.xyz, R0.w, R1.w, -R2;\n"
    "MAD R2.xyz, R0, R2.w, R2;\n"
    "MUL R3.xyz, R0, R2.w;\n"
    "MUL R0.xyz, R0, R1;\n"
    "ADD R2.w, -R0, c[7];\n"
    "MAD R0.xyz, R0, c[7].z, R3;\n"
    "MAD R0.xyz, R1, R2.w, R0;\n"
    "MAD R2.xyz, R1, R2.w, R2;\n"
    "MUL R1.xyz, R1, c[7].z;\n"
    "ADD R2.w, R0, R1;\n"
    "ADD R2.xyz, R2, -R0;\n"
    "SGE R1.xyz, R1, R1.w;\n"
    "MAD result.color.xyz, R1, R2, R0;\n"
    "MAD result.color.w, -R0, R1, R2;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_DARKEN_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[8] = { program.local[0..4],\n"
    "		{ 0.15915494, 0.0020000001, 3.141593, 1.570796 },\n"
    "		{ -0.01348047, 0.05747731, 0.1212391, 0.1956359 },\n"
    "		{ 0.33299461, 0.99999559, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ABS R0.z, R0.x;\n"
    "ABS R0.w, R0.y;\n"
    "ADD R0.w, R0, -R0.z;\n"
    "ADD R1.x, R0.y, c[5].y;\n"
    "ABS R0.w, R0;\n"
    "CMP R0.y, -R0.w, R0, R1.x;\n"
    "ABS R0.w, -R0.y;\n"
    "MAX R1.x, R0.z, R0.w;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.z, R0.w;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[6].x, c[6].y;\n"
    "MAD R1.z, R1, R1.y, -c[6];\n"
    "MAD R1.z, R1, R1.y, c[6].w;\n"
    "MAD R1.z, R1, R1.y, -c[7].x;\n"
    "MAD R1.y, R1.z, R1, c[7];\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R0.z, -R0, R0.w;\n"
    "ADD R1.y, -R1.x, c[5].w;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[5].z;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R0.x, R0, c[5];\n"
    "FLR R0.y, R0.x;\n"
    "ADD R0.x, R0, -R0.y;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MUL R2.xyz, R0, R1.w;\n"
    "MUL R3.xyz, R0.w, R1;\n"
    "MIN R2.xyz, R2, R3;\n"
    "ADD R2.w, -R1, c[7].z;\n"
    "MAD R0.xyz, R0, R2.w, R2;\n"
    "ADD R2.x, R0.w, R1.w;\n"
    "ADD R2.y, -R0.w, c[7].z;\n"
    "MAD result.color.xyz, R1, R2.y, R0;\n"
    "MAD result.color.w, -R0, R1, R2.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_LIGHTEN_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[8] = { program.local[0..4],\n"
    "		{ 0.15915494, 0.0020000001, 3.141593, 1.570796 },\n"
    "		{ -0.01348047, 0.05747731, 0.1212391, 0.1956359 },\n"
    "		{ 0.33299461, 0.99999559, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ABS R0.z, R0.x;\n"
    "ABS R0.w, R0.y;\n"
    "ADD R0.w, R0, -R0.z;\n"
    "ADD R1.x, R0.y, c[5].y;\n"
    "ABS R0.w, R0;\n"
    "CMP R0.y, -R0.w, R0, R1.x;\n"
    "ABS R0.w, -R0.y;\n"
    "MAX R1.x, R0.z, R0.w;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.z, R0.w;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[6].x, c[6].y;\n"
    "MAD R1.z, R1, R1.y, -c[6];\n"
    "MAD R1.z, R1, R1.y, c[6].w;\n"
    "MAD R1.z, R1, R1.y, -c[7].x;\n"
    "MAD R1.y, R1.z, R1, c[7];\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R0.z, -R0, R0.w;\n"
    "ADD R1.y, -R1.x, c[5].w;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[5].z;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R0.x, R0, c[5];\n"
    "FLR R0.y, R0.x;\n"
    "ADD R0.x, R0, -R0.y;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MUL R2.xyz, R0, R1.w;\n"
    "MUL R3.xyz, R0.w, R1;\n"
    "MAX R2.xyz, R2, R3;\n"
    "ADD R2.w, -R1, c[7].z;\n"
    "MAD R0.xyz, R0, R2.w, R2;\n"
    "ADD R2.x, R0.w, R1.w;\n"
    "ADD R2.y, -R0.w, c[7].z;\n"
    "MAD result.color.xyz, R1, R2.y, R0;\n"
    "MAD result.color.w, -R0, R1, R2.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_COLORDODGE_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[8] = { program.local[0..4],\n"
    "		{ 0.0020000001, -0.01348047, 0.05747731, 0.1212391 },\n"
    "		{ 0.1956359, 0.33299461, 0.99999559, 1.570796 },\n"
    "		{ 3.141593, 0.15915494, 1, 1e-006 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ABS R0.z, R0.x;\n"
    "ABS R0.w, R0.y;\n"
    "ADD R0.w, R0, -R0.z;\n"
    "ADD R1.x, R0.y, c[5];\n"
    "ABS R0.w, R0;\n"
    "CMP R0.y, -R0.w, R0, R1.x;\n"
    "ABS R0.w, -R0.y;\n"
    "MAX R1.x, R0.z, R0.w;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.z, R0.w;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[5].y, c[5];\n"
    "MAD R1.z, R1, R1.y, -c[5].w;\n"
    "MAD R1.z, R1, R1.y, c[6].x;\n"
    "MAD R1.z, R1, R1.y, -c[6].y;\n"
    "MAD R1.y, R1.z, R1, c[6].z;\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R1.y, -R1.x, c[6].w;\n"
    "ADD R0.z, -R0, R0.w;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[7].x;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R0.x, R0, c[7].y;\n"
    "FLR R0.y, R0.x;\n"
    "ADD R0.x, R0, -R0.y;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MAX R1.x, R0.w, c[7].w;\n"
    "RCP R1.x, R1.x;\n"
    "MAD R1.xyz, -R0, R1.x, c[7].z;\n"
    "MAX R2.xyz, R1, c[7].w;\n"
    "MUL R1.xy, fragment.position, c[4];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "ADD R2.w, -R0, c[7].z;\n"
    "MUL R3.xyz, R1, R2.w;\n"
    "ADD R2.w, -R1, c[7].z;\n"
    "MAD R3.xyz, R0, R2.w, R3;\n"
    "MUL R1.xyz, R0.w, R1;\n"
    "MAD R0.xyz, R0, R1.w, R1;\n"
    "MUL R2.w, R0, R1;\n"
    "RCP R2.x, R2.x;\n"
    "RCP R2.y, R2.y;\n"
    "RCP R2.z, R2.z;\n"
    "MAD R2.xyz, R1, R2, R3;\n"
    "MAD R3.xyz, R0.w, R1.w, R3;\n"
    "ADD R1.x, R0.w, R1.w;\n"
    "ADD R3.xyz, R3, -R2;\n"
    "SGE R0.xyz, R0, R2.w;\n"
    "MAD result.color.xyz, R0, R3, R2;\n"
    "MAD result.color.w, -R0, R1, R1.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_COLORBURN_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[8] = { program.local[0..4],\n"
    "		{ 0.0020000001, -0.01348047, 0.05747731, 0.1212391 },\n"
    "		{ 0.1956359, 0.33299461, 0.99999559, 1.570796 },\n"
    "		{ 3.141593, 0.15915494, 1, 9.9999997e-006 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "TEMP R5;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ABS R0.w, R0.x;\n"
    "ABS R0.z, R0.y;\n"
    "ADD R0.z, R0, -R0.w;\n"
    "ADD R1.x, R0.y, c[5];\n"
    "ABS R0.z, R0;\n"
    "CMP R0.y, -R0.z, R0, R1.x;\n"
    "ABS R0.z, -R0.y;\n"
    "MAX R1.x, R0.w, R0.z;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.w, R0.z;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[5].y, c[5];\n"
    "MAD R1.z, R1, R1.y, -c[5].w;\n"
    "MAD R1.z, R1, R1.y, c[6].x;\n"
    "MAD R1.z, R1, R1.y, -c[6].y;\n"
    "MAD R1.y, R1.z, R1, c[6].z;\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R1.y, -R1.x, c[6].w;\n"
    "ADD R0.z, -R0.w, R0;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[7].x;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R0.x, R0, c[7].y;\n"
    "FLR R0.y, R0.x;\n"
    "ADD R0.x, R0, -R0.y;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MUL R2.xyz, R0.w, R1;\n"
    "MAD R3.xyz, R0, R1.w, R2;\n"
    "ADD R2.w, -R1, c[7].z;\n"
    "MAD R2.xyz, -R0.w, R1.w, R3;\n"
    "MUL R4.xyz, R0.w, R2;\n"
    "MAX R2.xyz, R0, c[7].w;\n"
    "MUL R5.xyz, R0, R2.w;\n"
    "ADD R3.w, -R0, c[7].z;\n"
    "RCP R2.x, R2.x;\n"
    "RCP R2.y, R2.y;\n"
    "RCP R2.z, R2.z;\n"
    "MAD R2.xyz, R4, R2, R5;\n"
    "MUL R4.xyz, R1, R3.w;\n"
    "MAD R1.xyz, R1, R3.w, R2;\n"
    "MAD R0.xyz, R0, R2.w, R4;\n"
    "MUL R2.x, R0.w, R1.w;\n"
    "ADD R2.w, R0, R1;\n"
    "ADD R1.xyz, R1, -R0;\n"
    "SGE R2.xyz, R3, R2.x;\n"
    "MAD result.color.xyz, R2, R1, R0;\n"
    "MAD result.color.w, -R0, R1, R2;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_HARDLIGHT_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[8] = { program.local[0..4],\n"
    "		{ 0.0020000001, -0.01348047, 0.05747731, 0.1212391 },\n"
    "		{ 0.1956359, 0.33299461, 0.99999559, 1.570796 },\n"
    "		{ 3.141593, 0.15915494, 2, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ABS R0.z, R0.x;\n"
    "ABS R0.w, R0.y;\n"
    "ADD R0.w, R0, -R0.z;\n"
    "ADD R1.x, R0.y, c[5];\n"
    "ABS R0.w, R0;\n"
    "CMP R0.y, -R0.w, R0, R1.x;\n"
    "ABS R0.w, -R0.y;\n"
    "MAX R1.x, R0.z, R0.w;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.z, R0.w;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[5].y, c[5];\n"
    "MAD R1.z, R1, R1.y, -c[5].w;\n"
    "MAD R1.z, R1, R1.y, c[6].x;\n"
    "MAD R1.z, R1, R1.y, -c[6].y;\n"
    "MAD R1.y, R1.z, R1, c[6].z;\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R0.z, -R0, R0.w;\n"
    "ADD R1.y, -R1.x, c[6].w;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[7].x;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R0.x, R0, c[7].y;\n"
    "FLR R0.y, R0.x;\n"
    "ADD R0.x, R0, -R0.y;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MUL R1.xy, fragment.position, c[4];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "ADD R2.w, -R1, c[7];\n"
    "ADD R3.xyz, R0.w, -R0;\n"
    "ADD R2.xyz, R1.w, -R1;\n"
    "MUL R2.xyz, R2, R3;\n"
    "MUL R2.xyz, R2, c[7].z;\n"
    "MAD R2.xyz, R0.w, R1.w, -R2;\n"
    "MUL R4.xyz, R0, R2.w;\n"
    "MUL R3.xyz, R0, R1;\n"
    "MAD R2.xyz, R0, R2.w, R2;\n"
    "ADD R2.w, -R0, c[7];\n"
    "MUL R0.xyz, R0, c[7].z;\n"
    "MAD R2.xyz, R1, R2.w, R2;\n"
    "MAD R3.xyz, R3, c[7].z, R4;\n"
    "MAD R1.xyz, R1, R2.w, R3;\n"
    "ADD R2.w, R0, R1;\n"
    "ADD R2.xyz, R2, -R1;\n"
    "SGE R0.xyz, R0, R0.w;\n"
    "MAD result.color.xyz, R0, R2, R1;\n"
    "MAD result.color.w, -R0, R1, R2;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_SOFTLIGHT_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[10] = { program.local[0..4],\n"
    "		{ 0.0020000001, -0.01348047, 0.05747731, 0.1212391 },\n"
    "		{ 0.1956359, 0.33299461, 0.99999559, 1.570796 },\n"
    "		{ 3.141593, 0.15915494, 1, 2 },\n"
    "		{ 9.9999997e-006, 4, 16, 12 },\n"
    "		{ 3 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "TEMP R5;\n"
    "TEMP R6;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ABS R0.w, R0.x;\n"
    "ABS R0.z, R0.y;\n"
    "ADD R0.z, R0, -R0.w;\n"
    "ADD R1.x, R0.y, c[5];\n"
    "ABS R0.z, R0;\n"
    "CMP R0.y, -R0.z, R0, R1.x;\n"
    "ABS R0.z, -R0.y;\n"
    "MAX R1.x, R0.w, R0.z;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.w, R0.z;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[5].y, c[5];\n"
    "MAD R1.z, R1, R1.y, -c[5].w;\n"
    "MAD R1.z, R1, R1.y, c[6].x;\n"
    "MAD R1.z, R1, R1.y, -c[6].y;\n"
    "MAD R1.y, R1.z, R1, c[6].z;\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R1.y, -R1.x, c[6].w;\n"
    "ADD R0.z, -R0.w, R0;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[7].x;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "MAX R0.z, R1.w, c[8].x;\n"
    "RCP R2.x, R0.z;\n"
    "MUL R3.xyz, R1, R2.x;\n"
    "MAD R4.xyz, R3, c[8].z, -c[8].w;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R0.x, R0, c[7].y;\n"
    "FLR R0.y, R0.x;\n"
    "ADD R0.x, R0, -R0.y;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MAD R2.xyz, R0, c[7].w, -R0.w;\n"
    "MAD R4.xyz, R3, R4, c[9].x;\n"
    "MUL R5.xyz, R1.w, R2;\n"
    "MUL R6.xyz, R5, R4;\n"
    "RSQ R2.w, R3.x;\n"
    "RCP R4.x, R2.w;\n"
    "RSQ R2.w, R3.y;\n"
    "RSQ R3.w, R3.z;\n"
    "RCP R4.y, R2.w;\n"
    "RCP R4.z, R3.w;\n"
    "ADD R4.xyz, -R3, R4;\n"
    "MUL R6.xyz, R3, R6;\n"
    "MUL R4.xyz, R5, R4;\n"
    "ADD R3.xyz, -R3, c[7].z;\n"
    "MAD R2.xyz, R2, R3, R0.w;\n"
    "MUL R3.xyz, R0, c[7].w;\n"
    "MAD R5.xyz, R0.w, R1, R6;\n"
    "MAD R4.xyz, R0.w, R1, R4;\n"
    "ADD R6.xyz, R4, -R5;\n"
    "MUL R4.xyz, R1, c[8].y;\n"
    "SGE R4.xyz, R4, R1.w;\n"
    "MAD R4.xyz, R4, R6, R5;\n"
    "MAD R4.xyz, -R1, R2, R4;\n"
    "MUL R2.xyz, R1, R2;\n"
    "SGE R3.xyz, R3, R0.w;\n"
    "MAD R2.xyz, R3, R4, R2;\n"
    "ADD R2.w, -R1, c[7].z;\n"
    "MAD R2.xyz, R0, R2.w, R2;\n"
    "ADD R0.x, R0.w, R1.w;\n"
    "ADD R0.y, -R0.w, c[7].z;\n"
    "MAD result.color.xyz, R1, R0.y, R2;\n"
    "MAD result.color.w, -R0, R1, R0.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_DIFFERENCE_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[8] = { program.local[0..4],\n"
    "		{ 0.15915494, 0.0020000001, 3.141593, 1.570796 },\n"
    "		{ -0.01348047, 0.05747731, 0.1212391, 0.1956359 },\n"
    "		{ 0.33299461, 0.99999559, 2 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ABS R0.z, R0.x;\n"
    "ABS R0.w, R0.y;\n"
    "ADD R0.w, R0, -R0.z;\n"
    "ADD R1.x, R0.y, c[5].y;\n"
    "ABS R0.w, R0;\n"
    "CMP R0.y, -R0.w, R0, R1.x;\n"
    "ABS R0.w, -R0.y;\n"
    "MAX R1.x, R0.z, R0.w;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.z, R0.w;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[6].x, c[6].y;\n"
    "MAD R1.z, R1, R1.y, -c[6];\n"
    "MAD R1.z, R1, R1.y, c[6].w;\n"
    "MAD R1.z, R1, R1.y, -c[7].x;\n"
    "MAD R1.y, R1.z, R1, c[7];\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R0.z, -R0, R0.w;\n"
    "ADD R1.y, -R1.x, c[5].w;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[5].z;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R0.x, R0, c[5];\n"
    "FLR R0.y, R0.x;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "ADD R0.x, R0, -R0.y;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MUL R2.xyz, R0, R1.w;\n"
    "MUL R3.xyz, R0.w, R1;\n"
    "ADD R0.xyz, R0, R1;\n"
    "MIN R2.xyz, R2, R3;\n"
    "ADD R1.x, R0.w, R1.w;\n"
    "MAD result.color.xyz, -R2, c[7].z, R0;\n"
    "MAD result.color.w, -R0, R1, R1.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_EXCLUSION_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[8] = { program.local[0..4],\n"
    "		{ 0.15915494, 0.0020000001, 3.141593, 1.570796 },\n"
    "		{ -0.01348047, 0.05747731, 0.1212391, 0.1956359 },\n"
    "		{ 0.33299461, 0.99999559, 2, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ABS R0.z, R0.x;\n"
    "ABS R0.w, R0.y;\n"
    "ADD R0.w, R0, -R0.z;\n"
    "ADD R1.x, R0.y, c[5].y;\n"
    "ABS R0.w, R0;\n"
    "CMP R0.y, -R0.w, R0, R1.x;\n"
    "ABS R0.w, -R0.y;\n"
    "MAX R1.x, R0.z, R0.w;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.z, R0.w;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[6].x, c[6].y;\n"
    "MAD R1.z, R1, R1.y, -c[6];\n"
    "MAD R1.z, R1, R1.y, c[6].w;\n"
    "MAD R1.z, R1, R1.y, -c[7].x;\n"
    "MAD R1.y, R1.z, R1, c[7];\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R0.z, -R0, R0.w;\n"
    "ADD R1.y, -R1.x, c[5].w;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[5].z;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R0.x, R0, c[5];\n"
    "FLR R0.y, R0.x;\n"
    "ADD R0.x, R0, -R0.y;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MUL R2.xyz, R0.w, R1;\n"
    "MAD R3.xyz, R0, R1.w, R2;\n"
    "MUL R2.xyz, R0, R1;\n"
    "MAD R2.xyz, -R2, c[7].z, R3;\n"
    "ADD R2.w, -R1, c[7];\n"
    "MAD R0.xyz, R0, R2.w, R2;\n"
    "ADD R2.x, R0.w, R1.w;\n"
    "ADD R2.y, -R0.w, c[7].w;\n"
    "MAD result.color.xyz, R1, R2.y, R0;\n"
    "MAD result.color.w, -R0, R1, R2.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODE_BLEND_MODE_MASK =
    "!!ARBfp1.0\n"
    "PARAM c[10] = { program.local[0..6],\n"
    "		{ 0.15915494, 0.0020000001, 3.141593, 1.570796 },\n"
    "		{ -0.01348047, 0.05747731, 0.1212391, 0.1956359 },\n"
    "		{ 0.33299461, 0.99999559 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ABS R0.z, R0.x;\n"
    "ABS R0.w, R0.y;\n"
    "ADD R0.w, R0, -R0.z;\n"
    "ADD R1.x, R0.y, c[7].y;\n"
    "ABS R0.w, R0;\n"
    "CMP R0.y, -R0.w, R0, R1.x;\n"
    "ABS R0.w, -R0.y;\n"
    "MAX R1.x, R0.z, R0.w;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.z, R0.w;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[8].x, c[8].y;\n"
    "MAD R1.z, R1, R1.y, -c[8];\n"
    "MAD R1.z, R1, R1.y, c[8].w;\n"
    "MAD R1.z, R1, R1.y, -c[9].x;\n"
    "MAD R1.y, R1.z, R1, c[9];\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R1.y, -R1.x, c[7].w;\n"
    "ADD R0.z, -R0, R0.w;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[7].z;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R1.x, R0, c[7];\n"
    "FLR R1.y, R1.x;\n"
    "ADD R0.zw, fragment.position.xyxy, c[5].xyxy;\n"
    "MUL R0.xy, R0.zwzw, c[4];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "ADD R1.x, R1, -R1.y;\n"
    "DP4 R1.y, R0, c[6];\n"
    "TEX R0, R1, texture[1], 1D;\n"
    "MUL result.color, R0, R1.y;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODE_BLEND_MODE_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[7] = { program.local[0..3],\n"
    "		{ 0.15915494, 0.0020000001, 3.141593, 1.570796 },\n"
    "		{ -0.01348047, 0.05747731, 0.1212391, 0.1956359 },\n"
    "		{ 0.33299461, 0.99999559 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "ABS R0.z, R0.x;\n"
    "ABS R0.w, R0.y;\n"
    "ADD R0.w, R0, -R0.z;\n"
    "ADD R1.x, R0.y, c[4].y;\n"
    "ABS R0.w, R0;\n"
    "CMP R0.y, -R0.w, R0, R1.x;\n"
    "ABS R0.w, -R0.y;\n"
    "MAX R1.x, R0.z, R0.w;\n"
    "RCP R1.y, R1.x;\n"
    "MIN R1.x, R0.z, R0.w;\n"
    "MUL R1.x, R1, R1.y;\n"
    "MUL R1.y, R1.x, R1.x;\n"
    "MAD R1.z, R1.y, c[5].x, c[5].y;\n"
    "MAD R1.z, R1, R1.y, -c[5];\n"
    "MAD R1.z, R1, R1.y, c[5].w;\n"
    "MAD R1.z, R1, R1.y, -c[6].x;\n"
    "MAD R1.y, R1.z, R1, c[6];\n"
    "MUL R1.x, R1.y, R1;\n"
    "ADD R0.z, -R0, R0.w;\n"
    "ADD R1.y, -R1.x, c[4].w;\n"
    "CMP R0.z, -R0, R1.y, R1.x;\n"
    "ADD R0.w, -R0.z, c[4].z;\n"
    "CMP R0.x, R0, R0.w, R0.z;\n"
    "CMP R0.x, -R0.y, -R0, R0;\n"
    "ADD R0.x, R0, c[0];\n"
    "MUL R0.x, R0, c[4];\n"
    "FLR R0.y, R0.x;\n"
    "ADD R0.x, R0, -R0.y;\n"
    "TEX result.color, R0, texture[0], 1D;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_SIMPLE_PORTER_DUFF =
    "!!ARBfp1.0\n"
    "PARAM c[11] = { program.local[0..9],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, c[0].xyxy;\n"
    "ADD R1.x, R0.z, R0.w;\n"
    "MUL R0.xy, fragment.position, c[7];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "MUL R1.x, R1, c[0].z;\n"
    "TEX R1, R1, texture[2], 1D;\n"
    "MUL R2.xyz, R0, c[4].y;\n"
    "MUL R3.xyz, R1.w, R2;\n"
    "MUL R2.xyz, R1, c[4].x;\n"
    "MAD R2.xyz, R0.w, R2, R3;\n"
    "ADD R3.xy, fragment.position, c[8];\n"
    "ADD R2.w, -R0, c[10].x;\n"
    "MUL R1.xyz, R1, c[5].y;\n"
    "MAD R2.xyz, R2.w, R1, R2;\n"
    "MUL R1.xyz, R0, c[5].z;\n"
    "ADD R3.z, -R1.w, c[10].x;\n"
    "MAD R2.xyz, R3.z, R1, R2;\n"
    "MUL R1.y, R1.w, R2.w;\n"
    "MUL R1.x, R1.w, R0.w;\n"
    "MUL R1.z, R0.w, R3;\n"
    "DP3 R2.w, R1, c[5];\n"
    "MUL R3.xy, R3, c[6];\n"
    "TEX R1, R3, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[9];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_MULTIPLY =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, c[0].xyxy;\n"
    "ADD R1.x, R0.z, R0.w;\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "MUL R1.x, R1, c[0].z;\n"
    "TEX R1, R1, texture[2], 1D;\n"
    "ADD R2.x, -R0.w, c[8];\n"
    "MUL R2.xyz, R1, R2.x;\n"
    "MAD R1.xyz, R1, R0, R2;\n"
    "ADD R2.x, -R1.w, c[8];\n"
    "MAD R2.xyz, R0, R2.x, R1;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[6];\n"
    "MUL R1.xy, R1, c[4];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_SCREEN =
    "!!ARBfp1.0\n"
    "PARAM c[8] = { program.local[0..7] };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.z, R0.x, c[0];\n"
    "ADD R3.xy, fragment.position, c[6];\n"
    "TEX R1, R0.z, texture[2], 1D;\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "ADD R2, R1, R0;\n"
    "MAD R2, -R1, R0, R2;\n"
    "MUL R3.xy, R3, c[4];\n"
    "TEX R1, R3, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_OVERLAY =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 2, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.x, R0, c[0].z;\n"
    "TEX R0, R0, texture[2], 1D;\n"
    "MUL R1.xy, fragment.position, c[5];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "ADD R2.w, -R1, c[8].y;\n"
    "ADD R3.xyz, R0.w, -R0;\n"
    "ADD R2.xyz, R1.w, -R1;\n"
    "MUL R2.xyz, R2, R3;\n"
    "MUL R2.xyz, R2, c[8].x;\n"
    "MAD R2.xyz, R0.w, R1.w, -R2;\n"
    "MUL R4.xyz, R0, R2.w;\n"
    "MUL R3.xyz, R0, R1;\n"
    "MAD R0.xyz, R0, R2.w, R2;\n"
    "ADD R2.x, -R0.w, c[8].y;\n"
    "MAD R3.xyz, R3, c[8].x, R4;\n"
    "MAD R3.xyz, R1, R2.x, R3;\n"
    "MAD R0.xyz, R1, R2.x, R0;\n"
    "MUL R2.xyz, R1, c[8].x;\n"
    "ADD R0.xyz, R0, -R3;\n"
    "SGE R2.xyz, R2, R1.w;\n"
    "MAD R2.xyz, R2, R0, R3;\n"
    "ADD R0.z, R0.w, R1.w;\n"
    "MAD R2.w, -R0, R1, R0.z;\n"
    "ADD R0.xy, fragment.position, c[6];\n"
    "MUL R0.xy, R0, c[4];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "ADD R2, R2, -R1;\n"
    "DP4 R0.x, R0, c[7];\n"
    "MAD result.color, R0.x, R2, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_DARKEN =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.z, R0.x, R0.y;\n"
    "MUL R1.x, R0.z, c[0].z;\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "TEX R1, R1, texture[2], 1D;\n"
    "MUL R3.xyz, R1.w, R0;\n"
    "MUL R2.xyz, R1, R0.w;\n"
    "MIN R2.xyz, R2, R3;\n"
    "ADD R2.w, -R0, c[8].x;\n"
    "MAD R1.xyz, R1, R2.w, R2;\n"
    "ADD R2.x, -R1.w, c[8];\n"
    "MAD R2.xyz, R0, R2.x, R1;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[6];\n"
    "MUL R1.xy, R1, c[4];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_LIGHTEN =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.z, R0.x, R0.y;\n"
    "MUL R1.x, R0.z, c[0].z;\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "TEX R1, R1, texture[2], 1D;\n"
    "MUL R3.xyz, R1.w, R0;\n"
    "MUL R2.xyz, R1, R0.w;\n"
    "MAX R2.xyz, R2, R3;\n"
    "ADD R2.w, -R0, c[8].x;\n"
    "MAD R1.xyz, R1, R2.w, R2;\n"
    "ADD R2.x, -R1.w, c[8];\n"
    "MAD R2.xyz, R0, R2.x, R1;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[6];\n"
    "MUL R1.xy, R1, c[4];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_COLORDODGE =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 1, 1e-006 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.x, R0, c[0].z;\n"
    "TEX R0, R0, texture[2], 1D;\n"
    "MAX R1.x, R0.w, c[8].y;\n"
    "RCP R1.x, R1.x;\n"
    "MAD R2.xyz, -R0, R1.x, c[8].x;\n"
    "MAX R2.xyz, R2, c[8].y;\n"
    "MUL R1.xy, fragment.position, c[5];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "ADD R2.w, -R0, c[8].x;\n"
    "MUL R3.xyz, R1, R2.w;\n"
    "ADD R2.w, -R1, c[8].x;\n"
    "MAD R4.xyz, R0, R2.w, R3;\n"
    "MUL R3.xyz, R0.w, R1;\n"
    "MUL R2.w, R0, R1;\n"
    "MAD R0.xyz, R0, R1.w, R3;\n"
    "SGE R0.xyz, R0, R2.w;\n"
    "RCP R2.x, R2.x;\n"
    "RCP R2.y, R2.y;\n"
    "RCP R2.z, R2.z;\n"
    "MAD R2.xyz, R3, R2, R4;\n"
    "MAD R4.xyz, R0.w, R1.w, R4;\n"
    "ADD R4.xyz, R4, -R2;\n"
    "MAD R2.xyz, R0, R4, R2;\n"
    "ADD R0.z, R0.w, R1.w;\n"
    "MAD R2.w, -R0, R1, R0.z;\n"
    "ADD R0.xy, fragment.position, c[6];\n"
    "MUL R0.xy, R0, c[4];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "ADD R2, R2, -R1;\n"
    "DP4 R0.x, R0, c[7];\n"
    "MAD result.color, R0.x, R2, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_COLORBURN =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 1, 9.9999997e-006 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "TEMP R5;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.zw, fragment.position.xyxy, c[5].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MUL R0.x, R0, c[0].z;\n"
    "TEX R0, R0, texture[2], 1D;\n"
    "MUL R2.xyz, R0.w, R1;\n"
    "MAD R3.xyz, R0, R1.w, R2;\n"
    "MAD R2.xyz, -R0.w, R1.w, R3;\n"
    "MUL R4.xyz, R0.w, R2;\n"
    "MAX R2.xyz, R0, c[8].y;\n"
    "ADD R2.w, -R1, c[8].x;\n"
    "MUL R5.xyz, R0, R2.w;\n"
    "ADD R3.w, -R0, c[8].x;\n"
    "RCP R2.x, R2.x;\n"
    "RCP R2.y, R2.y;\n"
    "RCP R2.z, R2.z;\n"
    "MAD R2.xyz, R4, R2, R5;\n"
    "MUL R4.xyz, R1, R3.w;\n"
    "MAD R0.xyz, R0, R2.w, R4;\n"
    "MUL R2.w, R0, R1;\n"
    "MAD R2.xyz, R1, R3.w, R2;\n"
    "ADD R2.xyz, R2, -R0;\n"
    "SGE R3.xyz, R3, R2.w;\n"
    "MAD R2.xyz, R3, R2, R0;\n"
    "ADD R0.z, R0.w, R1.w;\n"
    "MAD R2.w, -R0, R1, R0.z;\n"
    "ADD R0.xy, fragment.position, c[6];\n"
    "MUL R0.xy, R0, c[4];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "ADD R2, R2, -R1;\n"
    "DP4 R0.x, R0, c[7];\n"
    "MAD result.color, R0.x, R2, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_HARDLIGHT =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 2, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.x, R0, c[0].z;\n"
    "TEX R0, R0, texture[2], 1D;\n"
    "MUL R1.xy, fragment.position, c[5];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "ADD R2.w, -R1, c[8].y;\n"
    "ADD R3.xyz, R0.w, -R0;\n"
    "ADD R2.xyz, R1.w, -R1;\n"
    "MUL R2.xyz, R2, R3;\n"
    "MUL R2.xyz, R2, c[8].x;\n"
    "MAD R2.xyz, R0.w, R1.w, -R2;\n"
    "MUL R4.xyz, R0, R2.w;\n"
    "MAD R2.xyz, R0, R2.w, R2;\n"
    "MUL R3.xyz, R0, R1;\n"
    "ADD R2.w, -R0, c[8].y;\n"
    "MAD R3.xyz, R3, c[8].x, R4;\n"
    "MUL R0.xyz, R0, c[8].x;\n"
    "SGE R0.xyz, R0, R0.w;\n"
    "MAD R3.xyz, R1, R2.w, R3;\n"
    "MAD R2.xyz, R1, R2.w, R2;\n"
    "ADD R2.xyz, R2, -R3;\n"
    "MAD R2.xyz, R0, R2, R3;\n"
    "ADD R0.z, R0.w, R1.w;\n"
    "MAD R2.w, -R0, R1, R0.z;\n"
    "ADD R0.xy, fragment.position, c[6];\n"
    "MUL R0.xy, R0, c[4];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "ADD R2, R2, -R1;\n"
    "DP4 R0.x, R0, c[7];\n"
    "MAD result.color, R0.x, R2, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_SOFTLIGHT =
    "!!ARBfp1.0\n"
    "PARAM c[10] = { program.local[0..7],\n"
    "		{ 1, 2, 9.9999997e-006, 4 },\n"
    "		{ 16, 12, 3 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "TEMP R5;\n"
    "TEMP R6;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R1.xy, fragment.position, c[5];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "MAX R0.z, R1.w, c[8];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R3.xyz, R1, R0.z;\n"
    "MAD R2.xyz, R3, c[9].x, -c[9].y;\n"
    "MUL R0.x, R0, c[0].z;\n"
    "TEX R0, R0, texture[2], 1D;\n"
    "MAD R4.xyz, R3, R2, c[9].z;\n"
    "MAD R2.xyz, R0, c[8].y, -R0.w;\n"
    "MUL R5.xyz, R1.w, R2;\n"
    "MUL R6.xyz, R5, R4;\n"
    "RSQ R2.w, R3.x;\n"
    "RCP R4.x, R2.w;\n"
    "RSQ R2.w, R3.y;\n"
    "RSQ R3.w, R3.z;\n"
    "RCP R4.y, R2.w;\n"
    "RCP R4.z, R3.w;\n"
    "ADD R4.xyz, -R3, R4;\n"
    "MUL R6.xyz, R3, R6;\n"
    "MUL R4.xyz, R5, R4;\n"
    "ADD R3.xyz, -R3, c[8].x;\n"
    "MAD R2.xyz, R2, R3, R0.w;\n"
    "MUL R3.xyz, R0, c[8].y;\n"
    "MAD R5.xyz, R0.w, R1, R6;\n"
    "MAD R4.xyz, R0.w, R1, R4;\n"
    "ADD R6.xyz, R4, -R5;\n"
    "MUL R4.xyz, R1, c[8].w;\n"
    "SGE R4.xyz, R4, R1.w;\n"
    "MAD R4.xyz, R4, R6, R5;\n"
    "MAD R4.xyz, -R1, R2, R4;\n"
    "SGE R3.xyz, R3, R0.w;\n"
    "MUL R2.xyz, R1, R2;\n"
    "ADD R2.w, -R1, c[8].x;\n"
    "MAD R2.xyz, R3, R4, R2;\n"
    "MAD R2.xyz, R0, R2.w, R2;\n"
    "ADD R0.x, -R0.w, c[8];\n"
    "MAD R2.xyz, R1, R0.x, R2;\n"
    "ADD R0.z, R0.w, R1.w;\n"
    "MAD R2.w, -R0, R1, R0.z;\n"
    "ADD R0.xy, fragment.position, c[6];\n"
    "MUL R0.xy, R0, c[4];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "ADD R2, R2, -R1;\n"
    "DP4 R0.x, R0, c[7];\n"
    "MAD result.color, R0.x, R2, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_DIFFERENCE =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 2 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.z, R0.x, R0.y;\n"
    "MUL R1.x, R0.z, c[0].z;\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "TEX R1, R1, texture[2], 1D;\n"
    "ADD R2.xyz, R1, R0;\n"
    "MUL R3.xyz, R1.w, R0;\n"
    "MUL R1.xyz, R1, R0.w;\n"
    "MIN R1.xyz, R1, R3;\n"
    "MAD R2.xyz, -R1, c[8].x, R2;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[6];\n"
    "MUL R1.xy, R1, c[4];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_EXCLUSION =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 2, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.z, R0.x, R0.y;\n"
    "MUL R1.x, R0.z, c[0].z;\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "TEX R1, R1, texture[2], 1D;\n"
    "MUL R2.xyz, R1.w, R0;\n"
    "MAD R3.xyz, R1, R0.w, R2;\n"
    "MUL R2.xyz, R1, R0;\n"
    "MAD R2.xyz, -R2, c[8].x, R3;\n"
    "ADD R2.w, -R0, c[8].y;\n"
    "MAD R1.xyz, R1, R2.w, R2;\n"
    "ADD R2.x, -R1.w, c[8].y;\n"
    "MAD R2.xyz, R0, R2.x, R1;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[6];\n"
    "MUL R1.xy, R1, c[4];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_SIMPLE_PORTER_DUFF_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[8] = { program.local[0..6],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.zw, fragment.position.xyxy, c[6].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MUL R2.xyz, R1, c[4].y;\n"
    "MUL R0.x, R0, c[0].z;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MUL R3.xyz, R0.w, R2;\n"
    "MUL R2.xyz, R0, c[4].x;\n"
    "MAD R2.xyz, R1.w, R2, R3;\n"
    "ADD R2.w, -R1, c[7].x;\n"
    "MUL R0.xyz, R0, c[5].y;\n"
    "MAD R0.xyz, R2.w, R0, R2;\n"
    "ADD R2.x, -R0.w, c[7];\n"
    "MUL R1.xyz, R1, c[5].z;\n"
    "MAD result.color.xyz, R2.x, R1, R0;\n"
    "MUL R0.x, R0.w, R1.w;\n"
    "MUL R0.z, R1.w, R2.x;\n"
    "MUL R0.y, R0.w, R2.w;\n"
    "DP3 result.color.w, R0, c[5];\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_MULTIPLY_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MUL R0.x, R0, c[0].z;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "ADD R2.x, -R1.w, c[5];\n"
    "MUL R2.xyz, R0, R2.x;\n"
    "MAD R0.xyz, R0, R1, R2;\n"
    "ADD R2.x, R0.w, R1.w;\n"
    "ADD R2.y, -R0.w, c[5].x;\n"
    "MAD result.color.xyz, R1, R2.y, R0;\n"
    "MAD result.color.w, -R0, R1, R2.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_SCREEN_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[5] = { program.local[0..4] };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MUL R0.x, R0, c[0].z;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "ADD R2, R0, R1;\n"
    "MAD result.color, -R0, R1, R2;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_OVERLAY_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 2, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.x, R0, c[0].z;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MUL R1.xy, fragment.position, c[4];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "ADD R3.xyz, R0.w, -R0;\n"
    "ADD R2.xyz, R1.w, -R1;\n"
    "MUL R2.xyz, R2, R3;\n"
    "ADD R2.w, -R1, c[5].y;\n"
    "MUL R2.xyz, R2, c[5].x;\n"
    "MAD R2.xyz, R0.w, R1.w, -R2;\n"
    "MAD R2.xyz, R0, R2.w, R2;\n"
    "MUL R3.xyz, R0, R2.w;\n"
    "MUL R0.xyz, R0, R1;\n"
    "ADD R2.w, -R0, c[5].y;\n"
    "MAD R0.xyz, R0, c[5].x, R3;\n"
    "MAD R0.xyz, R1, R2.w, R0;\n"
    "MAD R2.xyz, R1, R2.w, R2;\n"
    "MUL R1.xyz, R1, c[5].x;\n"
    "ADD R2.w, R0, R1;\n"
    "ADD R2.xyz, R2, -R0;\n"
    "SGE R1.xyz, R1, R1.w;\n"
    "MAD result.color.xyz, R1, R2, R0;\n"
    "MAD result.color.w, -R0, R1, R2;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_DARKEN_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MUL R0.x, R0, c[0].z;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MUL R2.xyz, R0, R1.w;\n"
    "MUL R3.xyz, R0.w, R1;\n"
    "MIN R2.xyz, R2, R3;\n"
    "ADD R2.w, -R1, c[5].x;\n"
    "MAD R0.xyz, R0, R2.w, R2;\n"
    "ADD R2.x, R0.w, R1.w;\n"
    "ADD R2.y, -R0.w, c[5].x;\n"
    "MAD result.color.xyz, R1, R2.y, R0;\n"
    "MAD result.color.w, -R0, R1, R2.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_LIGHTEN_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MUL R0.x, R0, c[0].z;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MUL R2.xyz, R0, R1.w;\n"
    "MUL R3.xyz, R0.w, R1;\n"
    "MAX R2.xyz, R2, R3;\n"
    "ADD R2.w, -R1, c[5].x;\n"
    "MAD R0.xyz, R0, R2.w, R2;\n"
    "ADD R2.x, R0.w, R1.w;\n"
    "ADD R2.y, -R0.w, c[5].x;\n"
    "MAD result.color.xyz, R1, R2.y, R0;\n"
    "MAD result.color.w, -R0, R1, R2.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_COLORDODGE_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 1, 1e-006 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.x, R0, c[0].z;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MAX R1.x, R0.w, c[5].y;\n"
    "RCP R1.x, R1.x;\n"
    "MAD R3.xyz, -R0, R1.x, c[5].x;\n"
    "MAX R3.xyz, R3, c[5].y;\n"
    "MUL R1.xy, fragment.position, c[4];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "ADD R2.x, -R0.w, c[5];\n"
    "MUL R2.xyz, R1, R2.x;\n"
    "ADD R2.w, -R1, c[5].x;\n"
    "MAD R2.xyz, R0, R2.w, R2;\n"
    "MUL R1.xyz, R0.w, R1;\n"
    "MAD R0.xyz, R0, R1.w, R1;\n"
    "MUL R2.w, R0, R1;\n"
    "RCP R3.x, R3.x;\n"
    "RCP R3.y, R3.y;\n"
    "RCP R3.z, R3.z;\n"
    "MAD R3.xyz, R1, R3, R2;\n"
    "MAD R2.xyz, R0.w, R1.w, R2;\n"
    "ADD R1.x, R0.w, R1.w;\n"
    "ADD R2.xyz, R2, -R3;\n"
    "SGE R0.xyz, R0, R2.w;\n"
    "MAD result.color.xyz, R0, R2, R3;\n"
    "MAD result.color.w, -R0, R1, R1.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_COLORBURN_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 1, 9.9999997e-006 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "TEMP R5;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MUL R0.x, R0, c[0].z;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MUL R2.xyz, R0.w, R1;\n"
    "MAD R3.xyz, R0, R1.w, R2;\n"
    "ADD R2.w, -R1, c[5].x;\n"
    "MAD R2.xyz, -R0.w, R1.w, R3;\n"
    "MUL R4.xyz, R0.w, R2;\n"
    "MAX R2.xyz, R0, c[5].y;\n"
    "MUL R5.xyz, R0, R2.w;\n"
    "ADD R3.w, -R0, c[5].x;\n"
    "RCP R2.x, R2.x;\n"
    "RCP R2.y, R2.y;\n"
    "RCP R2.z, R2.z;\n"
    "MAD R2.xyz, R4, R2, R5;\n"
    "MUL R4.xyz, R1, R3.w;\n"
    "MAD R1.xyz, R1, R3.w, R2;\n"
    "MAD R0.xyz, R0, R2.w, R4;\n"
    "MUL R2.x, R0.w, R1.w;\n"
    "ADD R2.w, R0, R1;\n"
    "ADD R1.xyz, R1, -R0;\n"
    "SGE R2.xyz, R3, R2.x;\n"
    "MAD result.color.xyz, R2, R1, R0;\n"
    "MAD result.color.w, -R0, R1, R2;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_HARDLIGHT_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 2, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.x, R0, c[0].z;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MUL R1.xy, fragment.position, c[4];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "ADD R2.w, -R1, c[5].y;\n"
    "ADD R3.xyz, R0.w, -R0;\n"
    "ADD R2.xyz, R1.w, -R1;\n"
    "MUL R2.xyz, R2, R3;\n"
    "MUL R2.xyz, R2, c[5].x;\n"
    "MAD R2.xyz, R0.w, R1.w, -R2;\n"
    "MAD R2.xyz, R0, R2.w, R2;\n"
    "MUL R4.xyz, R0, R2.w;\n"
    "MUL R3.xyz, R0, R1;\n"
    "MUL R0.xyz, R0, c[5].x;\n"
    "ADD R2.w, -R0, c[5].y;\n"
    "MAD R3.xyz, R3, c[5].x, R4;\n"
    "MAD R3.xyz, R1, R2.w, R3;\n"
    "MAD R1.xyz, R1, R2.w, R2;\n"
    "ADD R2.x, R0.w, R1.w;\n"
    "ADD R1.xyz, R1, -R3;\n"
    "SGE R0.xyz, R0, R0.w;\n"
    "MAD result.color.xyz, R0, R1, R3;\n"
    "MAD result.color.w, -R0, R1, R2.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_SOFTLIGHT_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[7] = { program.local[0..4],\n"
    "		{ 1, 2, 9.9999997e-006, 4 },\n"
    "		{ 16, 12, 3 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "TEMP R5;\n"
    "TEMP R6;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R1.xy, fragment.position, c[4];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "MAX R0.z, R1.w, c[5];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R3.xyz, R1, R0.z;\n"
    "MAD R2.xyz, R3, c[6].x, -c[6].y;\n"
    "MUL R0.x, R0, c[0].z;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MAD R4.xyz, R3, R2, c[6].z;\n"
    "MAD R2.xyz, R0, c[5].y, -R0.w;\n"
    "MUL R5.xyz, R1.w, R2;\n"
    "MUL R6.xyz, R5, R4;\n"
    "RSQ R2.w, R3.x;\n"
    "RCP R4.x, R2.w;\n"
    "RSQ R2.w, R3.y;\n"
    "RSQ R3.w, R3.z;\n"
    "RCP R4.y, R2.w;\n"
    "RCP R4.z, R3.w;\n"
    "ADD R4.xyz, -R3, R4;\n"
    "MUL R6.xyz, R3, R6;\n"
    "MUL R4.xyz, R5, R4;\n"
    "ADD R3.xyz, -R3, c[5].x;\n"
    "MAD R2.xyz, R2, R3, R0.w;\n"
    "MUL R3.xyz, R0, c[5].y;\n"
    "MAD R5.xyz, R0.w, R1, R6;\n"
    "MAD R4.xyz, R0.w, R1, R4;\n"
    "ADD R6.xyz, R4, -R5;\n"
    "MUL R4.xyz, R1, c[5].w;\n"
    "SGE R4.xyz, R4, R1.w;\n"
    "MAD R4.xyz, R4, R6, R5;\n"
    "MAD R4.xyz, -R1, R2, R4;\n"
    "MUL R2.xyz, R1, R2;\n"
    "SGE R3.xyz, R3, R0.w;\n"
    "MAD R2.xyz, R3, R4, R2;\n"
    "ADD R2.w, -R1, c[5].x;\n"
    "MAD R2.xyz, R0, R2.w, R2;\n"
    "ADD R0.x, R0.w, R1.w;\n"
    "ADD R0.y, -R0.w, c[5].x;\n"
    "MAD result.color.xyz, R1, R0.y, R2;\n"
    "MAD result.color.w, -R0, R1, R0.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_DIFFERENCE_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 2 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MUL R0.x, R0, c[0].z;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MUL R2.xyz, R0, R1.w;\n"
    "MUL R3.xyz, R0.w, R1;\n"
    "ADD R0.xyz, R0, R1;\n"
    "MIN R2.xyz, R2, R3;\n"
    "ADD R1.x, R0.w, R1.w;\n"
    "MAD result.color.xyz, -R2, c[5].x, R0;\n"
    "MAD result.color.w, -R0, R1, R1.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_EXCLUSION_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 2, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MUL R0.x, R0, c[0].z;\n"
    "TEX R0, R0, texture[1], 1D;\n"
    "MUL R2.xyz, R0.w, R1;\n"
    "MAD R3.xyz, R0, R1.w, R2;\n"
    "MUL R2.xyz, R0, R1;\n"
    "MAD R2.xyz, -R2, c[5].x, R3;\n"
    "ADD R2.w, -R1, c[5].y;\n"
    "MAD R0.xyz, R0, R2.w, R2;\n"
    "ADD R2.x, R0.w, R1.w;\n"
    "ADD R2.y, -R0.w, c[5];\n"
    "MAD result.color.xyz, R1, R2.y, R0;\n"
    "MAD result.color.w, -R0, R1, R2.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODE_BLEND_MODE_MASK =
    "!!ARBfp1.0\n"
    "PARAM c[7] = { program.local[0..6] };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.z;\n"
    "MUL R0.zw, R0, c[0].xyxy;\n"
    "ADD R1.x, R0.z, R0.w;\n"
    "ADD R0.xy, fragment.position, c[5];\n"
    "MUL R0.xy, R0, c[4];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "DP4 R1.y, R0, c[6];\n"
    "MUL R1.x, R1, c[0].z;\n"
    "TEX R0, R1, texture[1], 1D;\n"
    "MUL result.color, R0, R1.y;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODE_BLEND_MODE_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[4] = { program.local[0..3] };\n"
    "TEMP R0;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "ADD R0.x, R0, R0.y;\n"
    "MUL R0.x, R0, c[0].z;\n"
    "TEX result.color, R0, texture[0], 1D;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_SIMPLE_PORTER_DUFF =
    "!!ARBfp1.0\n"
    "PARAM c[11] = { program.local[0..9],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R1.xyz, R0, c[3];\n"
    "RCP R0.z, R1.z;\n"
    "MUL R1.xy, R1, R0.z;\n"
    "MUL R0.xy, fragment.position, c[7];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "MUL R1.xy, R1, c[0];\n"
    "TEX R1, R1, texture[2], 2D;\n"
    "MUL R2.xyz, R0, c[4].y;\n"
    "MUL R3.xyz, R1.w, R2;\n"
    "MUL R2.xyz, R1, c[4].x;\n"
    "MAD R2.xyz, R0.w, R2, R3;\n"
    "ADD R3.xy, fragment.position, c[8];\n"
    "ADD R2.w, -R0, c[10].x;\n"
    "MUL R1.xyz, R1, c[5].y;\n"
    "MAD R2.xyz, R2.w, R1, R2;\n"
    "MUL R1.xyz, R0, c[5].z;\n"
    "ADD R3.z, -R1.w, c[10].x;\n"
    "MAD R2.xyz, R3.z, R1, R2;\n"
    "MUL R1.y, R1.w, R2.w;\n"
    "MUL R1.x, R1.w, R0.w;\n"
    "MUL R1.z, R0.w, R3;\n"
    "DP3 R2.w, R1, c[5];\n"
    "MUL R3.xy, R3, c[6];\n"
    "TEX R1, R3, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[9];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_MULTIPLY =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R1.xyz, R0, c[3];\n"
    "RCP R0.z, R1.z;\n"
    "MUL R1.xy, R1, R0.z;\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "MUL R1.xy, R1, c[0];\n"
    "TEX R1, R1, texture[2], 2D;\n"
    "ADD R2.x, -R0.w, c[8];\n"
    "MUL R2.xyz, R1, R2.x;\n"
    "MAD R1.xyz, R1, R0, R2;\n"
    "ADD R2.x, -R1.w, c[8];\n"
    "MAD R2.xyz, R0, R2.x, R1;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[6];\n"
    "MUL R1.xy, R1, c[4];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_SCREEN =
    "!!ARBfp1.0\n"
    "PARAM c[8] = { program.local[0..7] };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, c[0].xyxy;\n"
    "ADD R3.xy, fragment.position, c[6];\n"
    "TEX R1, R0.zwzw, texture[2], 2D;\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "ADD R2, R1, R0;\n"
    "MAD R2, -R1, R0, R2;\n"
    "MUL R3.xy, R3, c[4];\n"
    "TEX R1, R3, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_OVERLAY =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 2, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0, R0, texture[2], 2D;\n"
    "MUL R1.xy, fragment.position, c[5];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "ADD R2.w, -R1, c[8].y;\n"
    "ADD R3.xyz, R0.w, -R0;\n"
    "ADD R2.xyz, R1.w, -R1;\n"
    "MUL R2.xyz, R2, R3;\n"
    "MUL R2.xyz, R2, c[8].x;\n"
    "MAD R2.xyz, R0.w, R1.w, -R2;\n"
    "MUL R4.xyz, R0, R2.w;\n"
    "MUL R3.xyz, R0, R1;\n"
    "MAD R0.xyz, R0, R2.w, R2;\n"
    "ADD R2.x, -R0.w, c[8].y;\n"
    "MAD R3.xyz, R3, c[8].x, R4;\n"
    "MAD R3.xyz, R1, R2.x, R3;\n"
    "MAD R0.xyz, R1, R2.x, R0;\n"
    "MUL R2.xyz, R1, c[8].x;\n"
    "ADD R0.xyz, R0, -R3;\n"
    "SGE R2.xyz, R2, R1.w;\n"
    "MAD R2.xyz, R2, R0, R3;\n"
    "ADD R0.z, R0.w, R1.w;\n"
    "MAD R2.w, -R0, R1, R0.z;\n"
    "ADD R0.xy, fragment.position, c[6];\n"
    "MUL R0.xy, R0, c[4];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "ADD R2, R2, -R1;\n"
    "DP4 R0.x, R0, c[7];\n"
    "MAD result.color, R0.x, R2, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_DARKEN =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.z;\n"
    "MUL R1.xy, R0.zwzw, c[0];\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "TEX R1, R1, texture[2], 2D;\n"
    "MUL R3.xyz, R1.w, R0;\n"
    "MUL R2.xyz, R1, R0.w;\n"
    "MIN R2.xyz, R2, R3;\n"
    "ADD R2.w, -R0, c[8].x;\n"
    "MAD R1.xyz, R1, R2.w, R2;\n"
    "ADD R2.x, -R1.w, c[8];\n"
    "MAD R2.xyz, R0, R2.x, R1;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[6];\n"
    "MUL R1.xy, R1, c[4];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_LIGHTEN =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.z;\n"
    "MUL R1.xy, R0.zwzw, c[0];\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "TEX R1, R1, texture[2], 2D;\n"
    "MUL R3.xyz, R1.w, R0;\n"
    "MUL R2.xyz, R1, R0.w;\n"
    "MAX R2.xyz, R2, R3;\n"
    "ADD R2.w, -R0, c[8].x;\n"
    "MAD R1.xyz, R1, R2.w, R2;\n"
    "ADD R2.x, -R1.w, c[8];\n"
    "MAD R2.xyz, R0, R2.x, R1;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[6];\n"
    "MUL R1.xy, R1, c[4];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_COLORDODGE =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 1, 1e-006 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0, R0, texture[2], 2D;\n"
    "MAX R1.x, R0.w, c[8].y;\n"
    "RCP R1.x, R1.x;\n"
    "MAD R2.xyz, -R0, R1.x, c[8].x;\n"
    "MAX R2.xyz, R2, c[8].y;\n"
    "MUL R1.xy, fragment.position, c[5];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "ADD R2.w, -R0, c[8].x;\n"
    "MUL R3.xyz, R1, R2.w;\n"
    "ADD R2.w, -R1, c[8].x;\n"
    "MAD R4.xyz, R0, R2.w, R3;\n"
    "MUL R3.xyz, R0.w, R1;\n"
    "MUL R2.w, R0, R1;\n"
    "MAD R0.xyz, R0, R1.w, R3;\n"
    "SGE R0.xyz, R0, R2.w;\n"
    "RCP R2.x, R2.x;\n"
    "RCP R2.y, R2.y;\n"
    "RCP R2.z, R2.z;\n"
    "MAD R2.xyz, R3, R2, R4;\n"
    "MAD R4.xyz, R0.w, R1.w, R4;\n"
    "ADD R4.xyz, R4, -R2;\n"
    "MAD R2.xyz, R0, R4, R2;\n"
    "ADD R0.z, R0.w, R1.w;\n"
    "MAD R2.w, -R0, R1, R0.z;\n"
    "ADD R0.xy, fragment.position, c[6];\n"
    "MUL R0.xy, R0, c[4];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "ADD R2, R2, -R1;\n"
    "DP4 R0.x, R0, c[7];\n"
    "MAD result.color, R0.x, R2, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_COLORBURN =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 1, 9.9999997e-006 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "TEMP R5;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, fragment.position.xyxy, c[5].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0, R0, texture[2], 2D;\n"
    "MUL R2.xyz, R0.w, R1;\n"
    "MAD R3.xyz, R0, R1.w, R2;\n"
    "MAD R2.xyz, -R0.w, R1.w, R3;\n"
    "MUL R4.xyz, R0.w, R2;\n"
    "MAX R2.xyz, R0, c[8].y;\n"
    "ADD R2.w, -R1, c[8].x;\n"
    "MUL R5.xyz, R0, R2.w;\n"
    "ADD R3.w, -R0, c[8].x;\n"
    "RCP R2.x, R2.x;\n"
    "RCP R2.y, R2.y;\n"
    "RCP R2.z, R2.z;\n"
    "MAD R2.xyz, R4, R2, R5;\n"
    "MUL R4.xyz, R1, R3.w;\n"
    "MAD R0.xyz, R0, R2.w, R4;\n"
    "MUL R2.w, R0, R1;\n"
    "MAD R2.xyz, R1, R3.w, R2;\n"
    "ADD R2.xyz, R2, -R0;\n"
    "SGE R3.xyz, R3, R2.w;\n"
    "MAD R2.xyz, R3, R2, R0;\n"
    "ADD R0.z, R0.w, R1.w;\n"
    "MAD R2.w, -R0, R1, R0.z;\n"
    "ADD R0.xy, fragment.position, c[6];\n"
    "MUL R0.xy, R0, c[4];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "ADD R2, R2, -R1;\n"
    "DP4 R0.x, R0, c[7];\n"
    "MAD result.color, R0.x, R2, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_HARDLIGHT =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 2, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0, R0, texture[2], 2D;\n"
    "MUL R1.xy, fragment.position, c[5];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "ADD R2.w, -R1, c[8].y;\n"
    "ADD R3.xyz, R0.w, -R0;\n"
    "ADD R2.xyz, R1.w, -R1;\n"
    "MUL R2.xyz, R2, R3;\n"
    "MUL R2.xyz, R2, c[8].x;\n"
    "MAD R2.xyz, R0.w, R1.w, -R2;\n"
    "MUL R4.xyz, R0, R2.w;\n"
    "MAD R2.xyz, R0, R2.w, R2;\n"
    "MUL R3.xyz, R0, R1;\n"
    "ADD R2.w, -R0, c[8].y;\n"
    "MAD R3.xyz, R3, c[8].x, R4;\n"
    "MUL R0.xyz, R0, c[8].x;\n"
    "SGE R0.xyz, R0, R0.w;\n"
    "MAD R3.xyz, R1, R2.w, R3;\n"
    "MAD R2.xyz, R1, R2.w, R2;\n"
    "ADD R2.xyz, R2, -R3;\n"
    "MAD R2.xyz, R0, R2, R3;\n"
    "ADD R0.z, R0.w, R1.w;\n"
    "MAD R2.w, -R0, R1, R0.z;\n"
    "ADD R0.xy, fragment.position, c[6];\n"
    "MUL R0.xy, R0, c[4];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "ADD R2, R2, -R1;\n"
    "DP4 R0.x, R0, c[7];\n"
    "MAD result.color, R0.x, R2, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_SOFTLIGHT =
    "!!ARBfp1.0\n"
    "PARAM c[10] = { program.local[0..7],\n"
    "		{ 1, 2, 9.9999997e-006, 4 },\n"
    "		{ 16, 12, 3 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "TEMP R5;\n"
    "TEMP R6;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MUL R1.xy, fragment.position, c[5];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MAX R0.w, R1, c[8].z;\n"
    "RCP R0.w, R0.w;\n"
    "MUL R3.xyz, R1, R0.w;\n"
    "MAD R2.xyz, R3, c[9].x, -c[9].y;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0, R0, texture[2], 2D;\n"
    "MAD R4.xyz, R3, R2, c[9].z;\n"
    "MAD R2.xyz, R0, c[8].y, -R0.w;\n"
    "MUL R5.xyz, R1.w, R2;\n"
    "MUL R6.xyz, R5, R4;\n"
    "RSQ R2.w, R3.x;\n"
    "RCP R4.x, R2.w;\n"
    "RSQ R2.w, R3.y;\n"
    "RSQ R3.w, R3.z;\n"
    "RCP R4.y, R2.w;\n"
    "RCP R4.z, R3.w;\n"
    "ADD R4.xyz, -R3, R4;\n"
    "MUL R6.xyz, R3, R6;\n"
    "MUL R4.xyz, R5, R4;\n"
    "ADD R3.xyz, -R3, c[8].x;\n"
    "MAD R2.xyz, R2, R3, R0.w;\n"
    "MUL R3.xyz, R0, c[8].y;\n"
    "MAD R5.xyz, R0.w, R1, R6;\n"
    "MAD R4.xyz, R0.w, R1, R4;\n"
    "ADD R6.xyz, R4, -R5;\n"
    "MUL R4.xyz, R1, c[8].w;\n"
    "SGE R4.xyz, R4, R1.w;\n"
    "MAD R4.xyz, R4, R6, R5;\n"
    "MAD R4.xyz, -R1, R2, R4;\n"
    "SGE R3.xyz, R3, R0.w;\n"
    "MUL R2.xyz, R1, R2;\n"
    "ADD R2.w, -R1, c[8].x;\n"
    "MAD R2.xyz, R3, R4, R2;\n"
    "MAD R2.xyz, R0, R2.w, R2;\n"
    "ADD R0.x, -R0.w, c[8];\n"
    "MAD R2.xyz, R1, R0.x, R2;\n"
    "ADD R0.z, R0.w, R1.w;\n"
    "MAD R2.w, -R0, R1, R0.z;\n"
    "ADD R0.xy, fragment.position, c[6];\n"
    "MUL R0.xy, R0, c[4];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "ADD R2, R2, -R1;\n"
    "DP4 R0.x, R0, c[7];\n"
    "MAD result.color, R0.x, R2, R1;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_DIFFERENCE =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 2 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.z;\n"
    "MUL R1.xy, R0.zwzw, c[0];\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "TEX R1, R1, texture[2], 2D;\n"
    "ADD R2.xyz, R1, R0;\n"
    "MUL R3.xyz, R1.w, R0;\n"
    "MUL R1.xyz, R1, R0.w;\n"
    "MIN R1.xyz, R1, R3;\n"
    "MAD R2.xyz, -R1, c[8].x, R2;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[6];\n"
    "MUL R1.xy, R1, c[4];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_EXCLUSION =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 2, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.z;\n"
    "MUL R1.xy, R0.zwzw, c[0];\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "TEX R1, R1, texture[2], 2D;\n"
    "MUL R2.xyz, R1.w, R0;\n"
    "MAD R3.xyz, R1, R0.w, R2;\n"
    "MUL R2.xyz, R1, R0;\n"
    "MAD R2.xyz, -R2, c[8].x, R3;\n"
    "ADD R2.w, -R0, c[8].y;\n"
    "MAD R1.xyz, R1, R2.w, R2;\n"
    "ADD R2.x, -R1.w, c[8].y;\n"
    "MAD R2.xyz, R0, R2.x, R1;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[6];\n"
    "MUL R1.xy, R1, c[4];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_SIMPLE_PORTER_DUFF_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[8] = { program.local[0..6],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R1.xy, fragment.position, c[6];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "MUL R2.xyz, R1, c[4].y;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "MUL R3.xyz, R0.w, R2;\n"
    "MUL R2.xyz, R0, c[4].x;\n"
    "MAD R2.xyz, R1.w, R2, R3;\n"
    "ADD R2.w, -R1, c[7].x;\n"
    "MUL R0.xyz, R0, c[5].y;\n"
    "MAD R0.xyz, R2.w, R0, R2;\n"
    "ADD R2.x, -R0.w, c[7];\n"
    "MUL R1.xyz, R1, c[5].z;\n"
    "MAD result.color.xyz, R2.x, R1, R0;\n"
    "MUL R0.x, R0.w, R1.w;\n"
    "MUL R0.z, R1.w, R2.x;\n"
    "MUL R0.y, R0.w, R2.w;\n"
    "DP3 result.color.w, R0, c[5];\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_MULTIPLY_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R1.xy, fragment.position, c[4];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "ADD R2.x, -R1.w, c[5];\n"
    "MUL R2.xyz, R0, R2.x;\n"
    "MAD R0.xyz, R0, R1, R2;\n"
    "ADD R2.x, R0.w, R1.w;\n"
    "ADD R2.y, -R0.w, c[5].x;\n"
    "MAD result.color.xyz, R1, R2.y, R0;\n"
    "MAD result.color.w, -R0, R1, R2.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_SCREEN_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[5] = { program.local[0..4] };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "ADD R2, R0, R1;\n"
    "MAD result.color, -R0, R1, R2;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_OVERLAY_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 2, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "MUL R1.xy, fragment.position, c[4];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "ADD R3.xyz, R0.w, -R0;\n"
    "ADD R2.xyz, R1.w, -R1;\n"
    "MUL R2.xyz, R2, R3;\n"
    "ADD R2.w, -R1, c[5].y;\n"
    "MUL R2.xyz, R2, c[5].x;\n"
    "MAD R2.xyz, R0.w, R1.w, -R2;\n"
    "MAD R2.xyz, R0, R2.w, R2;\n"
    "MUL R3.xyz, R0, R2.w;\n"
    "MUL R0.xyz, R0, R1;\n"
    "ADD R2.w, -R0, c[5].y;\n"
    "MAD R0.xyz, R0, c[5].x, R3;\n"
    "MAD R0.xyz, R1, R2.w, R0;\n"
    "MAD R2.xyz, R1, R2.w, R2;\n"
    "MUL R1.xyz, R1, c[5].x;\n"
    "ADD R2.w, R0, R1;\n"
    "ADD R2.xyz, R2, -R0;\n"
    "SGE R1.xyz, R1, R1.w;\n"
    "MAD result.color.xyz, R1, R2, R0;\n"
    "MAD result.color.w, -R0, R1, R2;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_DARKEN_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "MUL R2.xyz, R0, R1.w;\n"
    "MUL R3.xyz, R0.w, R1;\n"
    "MIN R2.xyz, R2, R3;\n"
    "ADD R2.w, -R1, c[5].x;\n"
    "MAD R0.xyz, R0, R2.w, R2;\n"
    "ADD R2.x, R0.w, R1.w;\n"
    "ADD R2.y, -R0.w, c[5].x;\n"
    "MAD result.color.xyz, R1, R2.y, R0;\n"
    "MAD result.color.w, -R0, R1, R2.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_LIGHTEN_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "MUL R2.xyz, R0, R1.w;\n"
    "MUL R3.xyz, R0.w, R1;\n"
    "MAX R2.xyz, R2, R3;\n"
    "ADD R2.w, -R1, c[5].x;\n"
    "MAD R0.xyz, R0, R2.w, R2;\n"
    "ADD R2.x, R0.w, R1.w;\n"
    "ADD R2.y, -R0.w, c[5].x;\n"
    "MAD result.color.xyz, R1, R2.y, R0;\n"
    "MAD result.color.w, -R0, R1, R2.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_COLORDODGE_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 1, 1e-006 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "MAX R1.x, R0.w, c[5].y;\n"
    "RCP R1.x, R1.x;\n"
    "MAD R3.xyz, -R0, R1.x, c[5].x;\n"
    "MAX R3.xyz, R3, c[5].y;\n"
    "MUL R1.xy, fragment.position, c[4];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "ADD R2.x, -R0.w, c[5];\n"
    "MUL R2.xyz, R1, R2.x;\n"
    "ADD R2.w, -R1, c[5].x;\n"
    "MAD R2.xyz, R0, R2.w, R2;\n"
    "MUL R1.xyz, R0.w, R1;\n"
    "MAD R0.xyz, R0, R1.w, R1;\n"
    "MUL R2.w, R0, R1;\n"
    "RCP R3.x, R3.x;\n"
    "RCP R3.y, R3.y;\n"
    "RCP R3.z, R3.z;\n"
    "MAD R3.xyz, R1, R3, R2;\n"
    "MAD R2.xyz, R0.w, R1.w, R2;\n"
    "ADD R1.x, R0.w, R1.w;\n"
    "ADD R2.xyz, R2, -R3;\n"
    "SGE R0.xyz, R0, R2.w;\n"
    "MAD result.color.xyz, R0, R2, R3;\n"
    "MAD result.color.w, -R0, R1, R1.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_COLORBURN_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 1, 9.9999997e-006 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "TEMP R5;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "MUL R2.xyz, R0.w, R1;\n"
    "MAD R3.xyz, R0, R1.w, R2;\n"
    "ADD R2.w, -R1, c[5].x;\n"
    "MAD R2.xyz, -R0.w, R1.w, R3;\n"
    "MUL R4.xyz, R0.w, R2;\n"
    "MAX R2.xyz, R0, c[5].y;\n"
    "MUL R5.xyz, R0, R2.w;\n"
    "ADD R3.w, -R0, c[5].x;\n"
    "RCP R2.x, R2.x;\n"
    "RCP R2.y, R2.y;\n"
    "RCP R2.z, R2.z;\n"
    "MAD R2.xyz, R4, R2, R5;\n"
    "MUL R4.xyz, R1, R3.w;\n"
    "MAD R1.xyz, R1, R3.w, R2;\n"
    "MAD R0.xyz, R0, R2.w, R4;\n"
    "MUL R2.x, R0.w, R1.w;\n"
    "ADD R2.w, R0, R1;\n"
    "ADD R1.xyz, R1, -R0;\n"
    "SGE R2.xyz, R3, R2.x;\n"
    "MAD result.color.xyz, R2, R1, R0;\n"
    "MAD result.color.w, -R0, R1, R2;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_HARDLIGHT_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 2, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "MUL R1.xy, fragment.position, c[4];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "ADD R2.w, -R1, c[5].y;\n"
    "ADD R3.xyz, R0.w, -R0;\n"
    "ADD R2.xyz, R1.w, -R1;\n"
    "MUL R2.xyz, R2, R3;\n"
    "MUL R2.xyz, R2, c[5].x;\n"
    "MAD R2.xyz, R0.w, R1.w, -R2;\n"
    "MAD R2.xyz, R0, R2.w, R2;\n"
    "MUL R4.xyz, R0, R2.w;\n"
    "MUL R3.xyz, R0, R1;\n"
    "MUL R0.xyz, R0, c[5].x;\n"
    "ADD R2.w, -R0, c[5].y;\n"
    "MAD R3.xyz, R3, c[5].x, R4;\n"
    "MAD R3.xyz, R1, R2.w, R3;\n"
    "MAD R1.xyz, R1, R2.w, R2;\n"
    "ADD R2.x, R0.w, R1.w;\n"
    "ADD R1.xyz, R1, -R3;\n"
    "SGE R0.xyz, R0, R0.w;\n"
    "MAD result.color.xyz, R0, R1, R3;\n"
    "MAD result.color.w, -R0, R1, R2.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_SOFTLIGHT_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[7] = { program.local[0..4],\n"
    "		{ 1, 2, 9.9999997e-006, 4 },\n"
    "		{ 16, 12, 3 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "TEMP R5;\n"
    "TEMP R6;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MUL R1.xy, fragment.position, c[4];\n"
    "TEX R1, R1, texture[0], 2D;\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MAX R0.w, R1, c[5].z;\n"
    "RCP R0.w, R0.w;\n"
    "MUL R3.xyz, R1, R0.w;\n"
    "MAD R2.xyz, R3, c[6].x, -c[6].y;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "MAD R4.xyz, R3, R2, c[6].z;\n"
    "MAD R2.xyz, R0, c[5].y, -R0.w;\n"
    "MUL R5.xyz, R1.w, R2;\n"
    "MUL R6.xyz, R5, R4;\n"
    "RSQ R2.w, R3.x;\n"
    "RCP R4.x, R2.w;\n"
    "RSQ R2.w, R3.y;\n"
    "RSQ R3.w, R3.z;\n"
    "RCP R4.y, R2.w;\n"
    "RCP R4.z, R3.w;\n"
    "ADD R4.xyz, -R3, R4;\n"
    "MUL R6.xyz, R3, R6;\n"
    "MUL R4.xyz, R5, R4;\n"
    "ADD R3.xyz, -R3, c[5].x;\n"
    "MAD R2.xyz, R2, R3, R0.w;\n"
    "MUL R3.xyz, R0, c[5].y;\n"
    "MAD R5.xyz, R0.w, R1, R6;\n"
    "MAD R4.xyz, R0.w, R1, R4;\n"
    "ADD R6.xyz, R4, -R5;\n"
    "MUL R4.xyz, R1, c[5].w;\n"
    "SGE R4.xyz, R4, R1.w;\n"
    "MAD R4.xyz, R4, R6, R5;\n"
    "MAD R4.xyz, -R1, R2, R4;\n"
    "MUL R2.xyz, R1, R2;\n"
    "SGE R3.xyz, R3, R0.w;\n"
    "MAD R2.xyz, R3, R4, R2;\n"
    "ADD R2.w, -R1, c[5].x;\n"
    "MAD R2.xyz, R0, R2.w, R2;\n"
    "ADD R0.x, R0.w, R1.w;\n"
    "ADD R0.y, -R0.w, c[5].x;\n"
    "MAD result.color.xyz, R1, R0.y, R2;\n"
    "MAD result.color.w, -R0, R1, R0.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_DIFFERENCE_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 2 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "MUL R2.xyz, R0, R1.w;\n"
    "MUL R3.xyz, R0.w, R1;\n"
    "ADD R0.xyz, R0, R1;\n"
    "MIN R2.xyz, R2, R3;\n"
    "ADD R1.x, R0.w, R1.w;\n"
    "MAD result.color.xyz, -R2, c[5].x, R0;\n"
    "MAD result.color.w, -R0, R1, R1.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_EXCLUSION_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 2, 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R1, R0.zwzw, texture[0], 2D;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0, R0, texture[1], 2D;\n"
    "MUL R2.xyz, R0.w, R1;\n"
    "MAD R3.xyz, R0, R1.w, R2;\n"
    "MUL R2.xyz, R0, R1;\n"
    "MAD R2.xyz, -R2, c[5].x, R3;\n"
    "ADD R2.w, -R1, c[5].y;\n"
    "MAD R0.xyz, R0, R2.w, R2;\n"
    "ADD R2.x, R0.w, R1.w;\n"
    "ADD R2.y, -R0.w, c[5];\n"
    "MAD result.color.xyz, R1, R2.y, R0;\n"
    "MAD result.color.w, -R0, R1, R2.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODE_BLEND_MODE_MASK =
    "!!ARBfp1.0\n"
    "PARAM c[7] = { program.local[0..6] };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R1.xyz, R0, c[3];\n"
    "RCP R0.z, R1.z;\n"
    "MUL R1.xy, R1, R0.z;\n"
    "ADD R0.xy, fragment.position, c[5];\n"
    "MUL R0.xy, R0, c[4];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "DP4 R1.z, R0, c[6];\n"
    "MUL R1.xy, R1, c[0];\n"
    "TEX R0, R1, texture[1], 2D;\n"
    "MUL result.color, R0, R1.z;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODE_BLEND_MODE_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[4] = { program.local[0..3] };\n"
    "TEMP R0;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX result.color, R0, texture[0], 2D;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_SIMPLE_PORTER_DUFF =
    "!!ARBfp1.0\n"
    "PARAM c[11] = { program.local[0..9],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, c[0].xyxy;\n"
    "TEX R1.x, R0.zwzw, texture[2], 2D;\n"
    "MUL R0.xy, fragment.position, c[7];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "ADD R1.x, -R1, c[10];\n"
    "MUL R1, fragment.color.primary, R1.x;\n"
    "MUL R2.xyz, R0, c[4].y;\n"
    "MUL R3.xyz, R1.w, R2;\n"
    "MUL R2.xyz, R1, c[4].x;\n"
    "MAD R2.xyz, R0.w, R2, R3;\n"
    "ADD R3.xy, fragment.position, c[8];\n"
    "ADD R2.w, -R0, c[10].x;\n"
    "MUL R1.xyz, R1, c[5].y;\n"
    "MAD R2.xyz, R2.w, R1, R2;\n"
    "MUL R1.xyz, R0, c[5].z;\n"
    "ADD R3.z, -R1.w, c[10].x;\n"
    "MAD R2.xyz, R3.z, R1, R2;\n"
    "MUL R1.y, R1.w, R2.w;\n"
    "MUL R1.x, R1.w, R0.w;\n"
    "MUL R1.z, R0.w, R3;\n"
    "DP3 R2.w, R1, c[5];\n"
    "MUL R3.xy, R3, c[6];\n"
    "TEX R1, R3, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[9];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_MULTIPLY =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.zw, R0.xyxy, c[0].xyxy;\n"
    "TEX R1.x, R0.zwzw, texture[2], 2D;\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "ADD R1.x, -R1, c[8];\n"
    "MUL R1, fragment.color.primary, R1.x;\n"
    "ADD R2.x, -R0.w, c[8];\n"
    "MUL R2.xyz, R1, R2.x;\n"
    "MAD R1.xyz, R1, R0, R2;\n"
    "ADD R2.x, -R1.w, c[8];\n"
    "MAD R2.xyz, R0, R2.x, R1;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[6];\n"
    "MUL R1.xy, R1, c[4];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_SCREEN =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0.x, R0, texture[2], 2D;\n"
    "ADD R0.z, -R0.x, c[8].x;\n"
    "ADD R3.xy, fragment.position, c[6];\n"
    "MUL R1, fragment.color.primary, R0.z;\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "ADD R2, R1, R0;\n"
    "MAD R2, -R1, R0, R2;\n"
    "MUL R3.xy, R3, c[4];\n"
    "TEX R1, R3, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_OVERLAY =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 1, 2 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0.x, R0, texture[2], 2D;\n"
    "ADD R0.x, -R0, c[8];\n"
    "MUL R1, fragment.color.primary, R0.x;\n"
    "MUL R0.zw, fragment.position.xyxy, c[5].xyxy;\n"
    "TEX R0, R0.zwzw, texture[0], 2D;\n"
    "ADD R2.w, -R0, c[8].x;\n"
    "ADD R3.xyz, R1.w, -R1;\n"
    "ADD R2.xyz, R0.w, -R0;\n"
    "MUL R2.xyz, R2, R3;\n"
    "MUL R2.xyz, R2, c[8].y;\n"
    "MAD R2.xyz, R1.w, R0.w, -R2;\n"
    "MUL R4.xyz, R1, R2.w;\n"
    "MUL R3.xyz, R1, R0;\n"
    "MAD R1.xyz, R1, R2.w, R2;\n"
    "ADD R2.x, -R1.w, c[8];\n"
    "MAD R3.xyz, R3, c[8].y, R4;\n"
    "MAD R3.xyz, R0, R2.x, R3;\n"
    "MAD R1.xyz, R0, R2.x, R1;\n"
    "MUL R2.xyz, R0, c[8].y;\n"
    "ADD R1.xyz, R1, -R3;\n"
    "SGE R2.xyz, R2, R0.w;\n"
    "MAD R2.xyz, R2, R1, R3;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[6];\n"
    "MUL R1.xy, R1, c[4];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_DARKEN =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R1.x, R0, texture[2], 2D;\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "ADD R1.x, -R1, c[8];\n"
    "MUL R1, fragment.color.primary, R1.x;\n"
    "MUL R3.xyz, R1.w, R0;\n"
    "MUL R2.xyz, R1, R0.w;\n"
    "MIN R2.xyz, R2, R3;\n"
    "ADD R2.w, -R0, c[8].x;\n"
    "MAD R1.xyz, R1, R2.w, R2;\n"
    "ADD R2.x, -R1.w, c[8];\n"
    "MAD R2.xyz, R0, R2.x, R1;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[6];\n"
    "MUL R1.xy, R1, c[4];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_LIGHTEN =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R1.x, R0, texture[2], 2D;\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "ADD R1.x, -R1, c[8];\n"
    "MUL R1, fragment.color.primary, R1.x;\n"
    "MUL R3.xyz, R1.w, R0;\n"
    "MUL R2.xyz, R1, R0.w;\n"
    "MAX R2.xyz, R2, R3;\n"
    "ADD R2.w, -R0, c[8].x;\n"
    "MAD R1.xyz, R1, R2.w, R2;\n"
    "ADD R2.x, -R1.w, c[8];\n"
    "MAD R2.xyz, R0, R2.x, R1;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[6];\n"
    "MUL R1.xy, R1, c[4];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_COLORDODGE =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 1, 1e-006 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0.x, R0, texture[2], 2D;\n"
    "ADD R0.x, -R0, c[8];\n"
    "MUL R1, fragment.color.primary, R0.x;\n"
    "MAX R0.x, R1.w, c[8].y;\n"
    "RCP R0.x, R0.x;\n"
    "MAD R2.xyz, -R1, R0.x, c[8].x;\n"
    "MAX R2.xyz, R2, c[8].y;\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "ADD R2.w, -R1, c[8].x;\n"
    "MUL R3.xyz, R0, R2.w;\n"
    "ADD R2.w, -R0, c[8].x;\n"
    "MAD R4.xyz, R1, R2.w, R3;\n"
    "MUL R3.xyz, R1.w, R0;\n"
    "MUL R2.w, R1, R0;\n"
    "MAD R1.xyz, R1, R0.w, R3;\n"
    "SGE R1.xyz, R1, R2.w;\n"
    "RCP R2.x, R2.x;\n"
    "RCP R2.y, R2.y;\n"
    "RCP R2.z, R2.z;\n"
    "MAD R2.xyz, R3, R2, R4;\n"
    "MAD R4.xyz, R1.w, R0.w, R4;\n"
    "ADD R4.xyz, R4, -R2;\n"
    "MAD R2.xyz, R1, R4, R2;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[6];\n"
    "MUL R1.xy, R1, c[4];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_COLORBURN =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 1, 9.9999997e-006 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "TEMP R5;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0.x, R0, texture[2], 2D;\n"
    "ADD R1.x, -R0, c[8];\n"
    "MUL R1, fragment.color.primary, R1.x;\n"
    "MUL R0.zw, fragment.position.xyxy, c[5].xyxy;\n"
    "TEX R0, R0.zwzw, texture[0], 2D;\n"
    "MUL R2.xyz, R1.w, R0;\n"
    "MAD R3.xyz, R1, R0.w, R2;\n"
    "MAD R2.xyz, -R1.w, R0.w, R3;\n"
    "MUL R4.xyz, R1.w, R2;\n"
    "MAX R2.xyz, R1, c[8].y;\n"
    "ADD R2.w, -R0, c[8].x;\n"
    "MUL R5.xyz, R1, R2.w;\n"
    "ADD R3.w, -R1, c[8].x;\n"
    "RCP R2.x, R2.x;\n"
    "RCP R2.y, R2.y;\n"
    "RCP R2.z, R2.z;\n"
    "MAD R2.xyz, R4, R2, R5;\n"
    "MUL R4.xyz, R0, R3.w;\n"
    "MAD R1.xyz, R1, R2.w, R4;\n"
    "MUL R2.w, R1, R0;\n"
    "MAD R2.xyz, R0, R3.w, R2;\n"
    "ADD R2.xyz, R2, -R1;\n"
    "SGE R3.xyz, R3, R2.w;\n"
    "MAD R2.xyz, R3, R2, R1;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[6];\n"
    "MUL R1.xy, R1, c[4];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_HARDLIGHT =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 1, 2 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0.x, R0, texture[2], 2D;\n"
    "ADD R0.x, -R0, c[8];\n"
    "MUL R1, fragment.color.primary, R0.x;\n"
    "MUL R0.zw, fragment.position.xyxy, c[5].xyxy;\n"
    "TEX R0, R0.zwzw, texture[0], 2D;\n"
    "ADD R2.w, -R0, c[8].x;\n"
    "ADD R3.xyz, R1.w, -R1;\n"
    "ADD R2.xyz, R0.w, -R0;\n"
    "MUL R2.xyz, R2, R3;\n"
    "MUL R2.xyz, R2, c[8].y;\n"
    "MAD R2.xyz, R1.w, R0.w, -R2;\n"
    "MUL R4.xyz, R1, R2.w;\n"
    "MAD R2.xyz, R1, R2.w, R2;\n"
    "MUL R3.xyz, R1, R0;\n"
    "ADD R2.w, -R1, c[8].x;\n"
    "MAD R3.xyz, R3, c[8].y, R4;\n"
    "MUL R1.xyz, R1, c[8].y;\n"
    "SGE R1.xyz, R1, R1.w;\n"
    "MAD R3.xyz, R0, R2.w, R3;\n"
    "MAD R2.xyz, R0, R2.w, R2;\n"
    "ADD R2.xyz, R2, -R3;\n"
    "MAD R2.xyz, R1, R2, R3;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[6];\n"
    "MUL R1.xy, R1, c[4];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_SOFTLIGHT =
    "!!ARBfp1.0\n"
    "PARAM c[10] = { program.local[0..7],\n"
    "		{ 1, 2, 9.9999997e-006, 4 },\n"
    "		{ 16, 12, 3 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "TEMP R5;\n"
    "TEMP R6;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R1.xyz, R0, c[3];\n"
    "RCP R1.z, R1.z;\n"
    "MUL R1.xy, R1, R1.z;\n"
    "MUL R1.xy, R1, c[0];\n"
    "TEX R1.x, R1, texture[2], 2D;\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "MAX R1.z, R0.w, c[8];\n"
    "RCP R1.z, R1.z;\n"
    "MUL R3.xyz, R0, R1.z;\n"
    "MAD R2.xyz, R3, c[9].x, -c[9].y;\n"
    "ADD R1.x, -R1, c[8];\n"
    "MUL R1, fragment.color.primary, R1.x;\n"
    "MAD R4.xyz, R3, R2, c[9].z;\n"
    "MAD R2.xyz, R1, c[8].y, -R1.w;\n"
    "MUL R5.xyz, R0.w, R2;\n"
    "MUL R6.xyz, R5, R4;\n"
    "RSQ R2.w, R3.x;\n"
    "RCP R4.x, R2.w;\n"
    "RSQ R2.w, R3.y;\n"
    "RSQ R3.w, R3.z;\n"
    "RCP R4.y, R2.w;\n"
    "RCP R4.z, R3.w;\n"
    "ADD R4.xyz, -R3, R4;\n"
    "MUL R6.xyz, R3, R6;\n"
    "MUL R4.xyz, R5, R4;\n"
    "ADD R3.xyz, -R3, c[8].x;\n"
    "MAD R2.xyz, R2, R3, R1.w;\n"
    "MUL R3.xyz, R1, c[8].y;\n"
    "MAD R5.xyz, R1.w, R0, R6;\n"
    "MAD R4.xyz, R1.w, R0, R4;\n"
    "ADD R6.xyz, R4, -R5;\n"
    "MUL R4.xyz, R0, c[8].w;\n"
    "SGE R4.xyz, R4, R0.w;\n"
    "MAD R4.xyz, R4, R6, R5;\n"
    "MAD R4.xyz, -R0, R2, R4;\n"
    "SGE R3.xyz, R3, R1.w;\n"
    "MUL R2.xyz, R0, R2;\n"
    "ADD R2.w, -R0, c[8].x;\n"
    "MAD R2.xyz, R3, R4, R2;\n"
    "MAD R2.xyz, R1, R2.w, R2;\n"
    "ADD R1.x, -R1.w, c[8];\n"
    "MAD R2.xyz, R0, R1.x, R2;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[6];\n"
    "MUL R1.xy, R1, c[4];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_DIFFERENCE =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 1, 2 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R1.x, R0, texture[2], 2D;\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "ADD R1.x, -R1, c[8];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "MUL R1, fragment.color.primary, R1.x;\n"
    "ADD R2.xyz, R1, R0;\n"
    "MUL R3.xyz, R1.w, R0;\n"
    "MUL R1.xyz, R1, R0.w;\n"
    "MIN R1.xyz, R1, R3;\n"
    "MAD R2.xyz, -R1, c[8].y, R2;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[6];\n"
    "MUL R1.xy, R1, c[4];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_EXCLUSION =
    "!!ARBfp1.0\n"
    "PARAM c[9] = { program.local[0..7],\n"
    "		{ 1, 2 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R1.x, R0, texture[2], 2D;\n"
    "MUL R0.xy, fragment.position, c[5];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "ADD R1.x, -R1, c[8];\n"
    "MUL R1, fragment.color.primary, R1.x;\n"
    "MUL R2.xyz, R1.w, R0;\n"
    "MAD R3.xyz, R1, R0.w, R2;\n"
    "MUL R2.xyz, R1, R0;\n"
    "MAD R2.xyz, -R2, c[8].y, R3;\n"
    "ADD R2.w, -R0, c[8].x;\n"
    "MAD R1.xyz, R1, R2.w, R2;\n"
    "ADD R2.x, -R1.w, c[8];\n"
    "MAD R2.xyz, R0, R2.x, R1;\n"
    "ADD R1.z, R1.w, R0.w;\n"
    "MAD R2.w, -R1, R0, R1.z;\n"
    "ADD R1.xy, fragment.position, c[6];\n"
    "MUL R1.xy, R1, c[4];\n"
    "TEX R1, R1, texture[1], 2D;\n"
    "ADD R2, R2, -R0;\n"
    "DP4 R1.x, R1, c[7];\n"
    "MAD result.color, R1.x, R2, R0;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_SIMPLE_PORTER_DUFF_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[8] = { program.local[0..6],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R1.x, R0, texture[1], 2D;\n"
    "MUL R0.zw, fragment.position.xyxy, c[6].xyxy;\n"
    "TEX R0, R0.zwzw, texture[0], 2D;\n"
    "MUL R2.xyz, R0, c[4].y;\n"
    "ADD R1.x, -R1, c[7];\n"
    "MUL R1, fragment.color.primary, R1.x;\n"
    "MUL R3.xyz, R1.w, R2;\n"
    "MUL R2.xyz, R1, c[4].x;\n"
    "MUL R0.xyz, R0, c[5].z;\n"
    "MAD R2.xyz, R0.w, R2, R3;\n"
    "ADD R2.w, -R0, c[7].x;\n"
    "MUL R1.xyz, R1, c[5].y;\n"
    "MAD R1.xyz, R2.w, R1, R2;\n"
    "ADD R2.x, -R1.w, c[7];\n"
    "MAD result.color.xyz, R2.x, R0, R1;\n"
    "MUL R0.x, R1.w, R0.w;\n"
    "MUL R0.z, R0.w, R2.x;\n"
    "MUL R0.y, R1.w, R2.w;\n"
    "DP3 result.color.w, R0, c[5];\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_MULTIPLY_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R1.x, R0, texture[1], 2D;\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R0, R0.zwzw, texture[0], 2D;\n"
    "ADD R1.x, -R1, c[5];\n"
    "MUL R1, fragment.color.primary, R1.x;\n"
    "ADD R2.x, -R0.w, c[5];\n"
    "MUL R2.xyz, R1, R2.x;\n"
    "MAD R1.xyz, R1, R0, R2;\n"
    "ADD R2.x, R1.w, R0.w;\n"
    "ADD R2.y, -R1.w, c[5].x;\n"
    "MAD result.color.xyz, R0, R2.y, R1;\n"
    "MAD result.color.w, -R1, R0, R2.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_SCREEN_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0.x, R0, texture[1], 2D;\n"
    "ADD R1.x, -R0, c[5];\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R0, R0.zwzw, texture[0], 2D;\n"
    "MUL R1, fragment.color.primary, R1.x;\n"
    "ADD R2, R1, R0;\n"
    "MAD result.color, -R1, R0, R2;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_OVERLAY_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 1, 2 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0.x, R0, texture[1], 2D;\n"
    "ADD R0.x, -R0, c[5];\n"
    "MUL R1, fragment.color.primary, R0.x;\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R0, R0.zwzw, texture[0], 2D;\n"
    "ADD R3.xyz, R1.w, -R1;\n"
    "ADD R2.xyz, R0.w, -R0;\n"
    "MUL R2.xyz, R2, R3;\n"
    "ADD R2.w, -R0, c[5].x;\n"
    "MUL R2.xyz, R2, c[5].y;\n"
    "MAD R2.xyz, R1.w, R0.w, -R2;\n"
    "MAD R2.xyz, R1, R2.w, R2;\n"
    "MUL R3.xyz, R1, R2.w;\n"
    "MUL R1.xyz, R1, R0;\n"
    "ADD R2.w, -R1, c[5].x;\n"
    "MAD R1.xyz, R1, c[5].y, R3;\n"
    "MAD R1.xyz, R0, R2.w, R1;\n"
    "MAD R2.xyz, R0, R2.w, R2;\n"
    "MUL R0.xyz, R0, c[5].y;\n"
    "ADD R2.w, R1, R0;\n"
    "ADD R2.xyz, R2, -R1;\n"
    "SGE R0.xyz, R0, R0.w;\n"
    "MAD result.color.xyz, R0, R2, R1;\n"
    "MAD result.color.w, -R1, R0, R2;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_DARKEN_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0.x, R0, texture[1], 2D;\n"
    "ADD R1.x, -R0, c[5];\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R0, R0.zwzw, texture[0], 2D;\n"
    "MUL R1, fragment.color.primary, R1.x;\n"
    "MUL R2.xyz, R1, R0.w;\n"
    "MUL R3.xyz, R1.w, R0;\n"
    "MIN R2.xyz, R2, R3;\n"
    "ADD R2.w, -R0, c[5].x;\n"
    "MAD R1.xyz, R1, R2.w, R2;\n"
    "ADD R2.x, R1.w, R0.w;\n"
    "ADD R2.y, -R1.w, c[5].x;\n"
    "MAD result.color.xyz, R0, R2.y, R1;\n"
    "MAD result.color.w, -R1, R0, R2.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_LIGHTEN_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0.x, R0, texture[1], 2D;\n"
    "ADD R1.x, -R0, c[5];\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R0, R0.zwzw, texture[0], 2D;\n"
    "MUL R1, fragment.color.primary, R1.x;\n"
    "MUL R2.xyz, R1, R0.w;\n"
    "MUL R3.xyz, R1.w, R0;\n"
    "MAX R2.xyz, R2, R3;\n"
    "ADD R2.w, -R0, c[5].x;\n"
    "MAD R1.xyz, R1, R2.w, R2;\n"
    "ADD R2.x, R1.w, R0.w;\n"
    "ADD R2.y, -R1.w, c[5].x;\n"
    "MAD result.color.xyz, R0, R2.y, R1;\n"
    "MAD result.color.w, -R1, R0, R2.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_COLORDODGE_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 1, 1e-006 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0.x, R0, texture[1], 2D;\n"
    "ADD R0.x, -R0, c[5];\n"
    "MUL R1, fragment.color.primary, R0.x;\n"
    "MAX R0.x, R1.w, c[5].y;\n"
    "RCP R0.x, R0.x;\n"
    "MAD R3.xyz, -R1, R0.x, c[5].x;\n"
    "MAX R3.xyz, R3, c[5].y;\n"
    "MUL R0.xy, fragment.position, c[4];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "ADD R2.x, -R1.w, c[5];\n"
    "MUL R2.xyz, R0, R2.x;\n"
    "ADD R2.w, -R0, c[5].x;\n"
    "MAD R2.xyz, R1, R2.w, R2;\n"
    "MUL R0.xyz, R1.w, R0;\n"
    "RCP R3.x, R3.x;\n"
    "RCP R3.y, R3.y;\n"
    "RCP R3.z, R3.z;\n"
    "MAD R3.xyz, R0, R3, R2;\n"
    "MAD R0.xyz, R1, R0.w, R0;\n"
    "MAD R2.xyz, R1.w, R0.w, R2;\n"
    "MUL R2.w, R1, R0;\n"
    "ADD R1.x, R1.w, R0.w;\n"
    "ADD R2.xyz, R2, -R3;\n"
    "SGE R0.xyz, R0, R2.w;\n"
    "MAD result.color.xyz, R0, R2, R3;\n"
    "MAD result.color.w, -R1, R0, R1.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_COLORBURN_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 1, 9.9999997e-006 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "TEMP R5;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0.x, R0, texture[1], 2D;\n"
    "ADD R1.x, -R0, c[5];\n"
    "MUL R1, fragment.color.primary, R1.x;\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R0, R0.zwzw, texture[0], 2D;\n"
    "MUL R2.xyz, R1.w, R0;\n"
    "MAD R3.xyz, R1, R0.w, R2;\n"
    "ADD R2.w, -R0, c[5].x;\n"
    "MAD R2.xyz, -R1.w, R0.w, R3;\n"
    "MUL R4.xyz, R1.w, R2;\n"
    "MAX R2.xyz, R1, c[5].y;\n"
    "MUL R5.xyz, R1, R2.w;\n"
    "ADD R3.w, -R1, c[5].x;\n"
    "RCP R2.x, R2.x;\n"
    "RCP R2.y, R2.y;\n"
    "RCP R2.z, R2.z;\n"
    "MAD R2.xyz, R4, R2, R5;\n"
    "MUL R4.xyz, R0, R3.w;\n"
    "MAD R0.xyz, R0, R3.w, R2;\n"
    "MAD R1.xyz, R1, R2.w, R4;\n"
    "MUL R2.x, R1.w, R0.w;\n"
    "ADD R2.w, R1, R0;\n"
    "ADD R0.xyz, R0, -R1;\n"
    "SGE R2.xyz, R3, R2.x;\n"
    "MAD result.color.xyz, R2, R0, R1;\n"
    "MAD result.color.w, -R1, R0, R2;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_HARDLIGHT_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 1, 2 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0.x, R0, texture[1], 2D;\n"
    "ADD R0.x, -R0, c[5];\n"
    "MUL R1, fragment.color.primary, R0.x;\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R0, R0.zwzw, texture[0], 2D;\n"
    "ADD R2.w, -R0, c[5].x;\n"
    "ADD R3.xyz, R1.w, -R1;\n"
    "ADD R2.xyz, R0.w, -R0;\n"
    "MUL R2.xyz, R2, R3;\n"
    "MUL R2.xyz, R2, c[5].y;\n"
    "MAD R2.xyz, R1.w, R0.w, -R2;\n"
    "MAD R2.xyz, R1, R2.w, R2;\n"
    "MUL R4.xyz, R1, R2.w;\n"
    "MUL R3.xyz, R1, R0;\n"
    "MUL R1.xyz, R1, c[5].y;\n"
    "ADD R2.w, -R1, c[5].x;\n"
    "MAD R3.xyz, R3, c[5].y, R4;\n"
    "MAD R3.xyz, R0, R2.w, R3;\n"
    "MAD R0.xyz, R0, R2.w, R2;\n"
    "ADD R2.x, R1.w, R0.w;\n"
    "ADD R0.xyz, R0, -R3;\n"
    "SGE R1.xyz, R1, R1.w;\n"
    "MAD result.color.xyz, R1, R0, R3;\n"
    "MAD result.color.w, -R1, R0, R2.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_SOFTLIGHT_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[7] = { program.local[0..4],\n"
    "		{ 1, 2, 9.9999997e-006, 4 },\n"
    "		{ 16, 12, 3 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "TEMP R4;\n"
    "TEMP R5;\n"
    "TEMP R6;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R1.xyz, R0, c[3];\n"
    "RCP R1.z, R1.z;\n"
    "MUL R1.xy, R1, R1.z;\n"
    "MUL R1.xy, R1, c[0];\n"
    "TEX R1.x, R1, texture[1], 2D;\n"
    "MUL R0.xy, fragment.position, c[4];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "MAX R1.z, R0.w, c[5];\n"
    "RCP R1.z, R1.z;\n"
    "MUL R3.xyz, R0, R1.z;\n"
    "MAD R2.xyz, R3, c[6].x, -c[6].y;\n"
    "ADD R1.x, -R1, c[5];\n"
    "MUL R1, fragment.color.primary, R1.x;\n"
    "MAD R4.xyz, R3, R2, c[6].z;\n"
    "MAD R2.xyz, R1, c[5].y, -R1.w;\n"
    "MUL R5.xyz, R0.w, R2;\n"
    "MUL R6.xyz, R5, R4;\n"
    "RSQ R2.w, R3.x;\n"
    "RCP R4.x, R2.w;\n"
    "RSQ R2.w, R3.y;\n"
    "RSQ R3.w, R3.z;\n"
    "RCP R4.y, R2.w;\n"
    "RCP R4.z, R3.w;\n"
    "ADD R4.xyz, -R3, R4;\n"
    "MUL R6.xyz, R3, R6;\n"
    "MUL R4.xyz, R5, R4;\n"
    "ADD R3.xyz, -R3, c[5].x;\n"
    "MAD R2.xyz, R2, R3, R1.w;\n"
    "MUL R3.xyz, R1, c[5].y;\n"
    "MAD R5.xyz, R1.w, R0, R6;\n"
    "MAD R4.xyz, R1.w, R0, R4;\n"
    "ADD R6.xyz, R4, -R5;\n"
    "MUL R4.xyz, R0, c[5].w;\n"
    "SGE R4.xyz, R4, R0.w;\n"
    "MAD R4.xyz, R4, R6, R5;\n"
    "MAD R4.xyz, -R0, R2, R4;\n"
    "MUL R2.xyz, R0, R2;\n"
    "SGE R3.xyz, R3, R1.w;\n"
    "MAD R2.xyz, R3, R4, R2;\n"
    "ADD R2.w, -R0, c[5].x;\n"
    "MAD R2.xyz, R1, R2.w, R2;\n"
    "ADD R1.x, R1.w, R0.w;\n"
    "ADD R1.y, -R1.w, c[5].x;\n"
    "MAD result.color.xyz, R0, R1.y, R2;\n"
    "MAD result.color.w, -R1, R0, R1.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_DIFFERENCE_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 1, 2 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0.x, R0, texture[1], 2D;\n"
    "ADD R1.x, -R0, c[5];\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R0, R0.zwzw, texture[0], 2D;\n"
    "MUL R1, fragment.color.primary, R1.x;\n"
    "MUL R3.xyz, R1.w, R0;\n"
    "MUL R2.xyz, R1, R0.w;\n"
    "ADD R0.xyz, R1, R0;\n"
    "MIN R2.xyz, R2, R3;\n"
    "ADD R1.x, R1.w, R0.w;\n"
    "MAD result.color.xyz, -R2, c[5].y, R0;\n"
    "MAD result.color.w, -R1, R0, R1.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_EXCLUSION_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[6] = { program.local[0..4],\n"
    "		{ 1, 2 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "TEMP R2;\n"
    "TEMP R3;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0.x, R0, texture[1], 2D;\n"
    "ADD R1.x, -R0, c[5];\n"
    "MUL R0.zw, fragment.position.xyxy, c[4].xyxy;\n"
    "TEX R0, R0.zwzw, texture[0], 2D;\n"
    "MUL R1, fragment.color.primary, R1.x;\n"
    "MUL R2.xyz, R1.w, R0;\n"
    "MAD R3.xyz, R1, R0.w, R2;\n"
    "MUL R2.xyz, R1, R0;\n"
    "MAD R2.xyz, -R2, c[5].y, R3;\n"
    "ADD R2.w, -R0, c[5].x;\n"
    "MAD R1.xyz, R1, R2.w, R2;\n"
    "ADD R2.x, R1.w, R0.w;\n"
    "ADD R2.y, -R1.w, c[5].x;\n"
    "MAD result.color.xyz, R0, R2.y, R1;\n"
    "MAD result.color.w, -R1, R0, R2.x;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODE_BLEND_MODE_MASK =
    "!!ARBfp1.0\n"
    "PARAM c[8] = { program.local[0..6],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "TEMP R1;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.zw, R0.xyxy, R0.z;\n"
    "MUL R0.zw, R0, c[0].xyxy;\n"
    "TEX R1.x, R0.zwzw, texture[1], 2D;\n"
    "ADD R0.xy, fragment.position, c[5];\n"
    "MUL R0.xy, R0, c[4];\n"
    "TEX R0, R0, texture[0], 2D;\n"
    "DP4 R1.y, R0, c[6];\n"
    "ADD R1.x, -R1, c[7];\n"
    "MUL R0, fragment.color.primary, R1.x;\n"
    "MUL result.color, R0, R1.y;\n"
    "END\n"
    ;

static const char *FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODE_BLEND_MODE_NOMASK =
    "!!ARBfp1.0\n"
    "PARAM c[5] = { program.local[0..3],\n"
    "		{ 1 } };\n"
    "TEMP R0;\n"
    "MUL R0.xyz, fragment.position.y, c[2];\n"
    "MAD R0.xyz, fragment.position.x, c[1], R0;\n"
    "ADD R0.xyz, R0, c[3];\n"
    "RCP R0.z, R0.z;\n"
    "MUL R0.xy, R0, R0.z;\n"
    "MUL R0.xy, R0, c[0];\n"
    "TEX R0.x, R0, texture[0], 2D;\n"
    "ADD R0.x, -R0, c[4];\n"
    "MUL result.color, fragment.color.primary, R0.x;\n"
    "END\n"
    ;

static const char *mask_fragment_program_sources[num_fragment_masks] = {
    FragmentProgram_FRAGMENT_PROGRAM_MASK_TRAPEZOID_AA,
    FragmentProgram_FRAGMENT_PROGRAM_MASK_ELLIPSE_AA,
};

static const char *painter_fragment_program_sources[num_fragment_brushes][num_fragment_composition_modes] = {
    {
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_SIMPLE_PORTER_DUFF,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_MULTIPLY,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_SCREEN,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_OVERLAY,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_DARKEN,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_LIGHTEN,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_COLORDODGE,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_COLORBURN,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_HARDLIGHT,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_SOFTLIGHT,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_DIFFERENCE,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_EXCLUSION,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_SIMPLE_PORTER_DUFF_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_MULTIPLY_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_SCREEN_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_OVERLAY_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_DARKEN_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_LIGHTEN_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_COLORDODGE_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_COLORBURN_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_HARDLIGHT_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_SOFTLIGHT_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_DIFFERENCE_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODES_EXCLUSION_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODE_BLEND_MODE_MASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_SOLID_COMPOSITION_MODE_BLEND_MODE_NOMASK,
    },
    {
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_SIMPLE_PORTER_DUFF,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_MULTIPLY,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_SCREEN,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_OVERLAY,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_DARKEN,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_LIGHTEN,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_COLORDODGE,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_COLORBURN,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_HARDLIGHT,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_SOFTLIGHT,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_DIFFERENCE,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_EXCLUSION,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_SIMPLE_PORTER_DUFF_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_MULTIPLY_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_SCREEN_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_OVERLAY_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_DARKEN_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_LIGHTEN_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_COLORDODGE_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_COLORBURN_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_HARDLIGHT_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_SOFTLIGHT_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_DIFFERENCE_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODES_EXCLUSION_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODE_BLEND_MODE_MASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_RADIAL_COMPOSITION_MODE_BLEND_MODE_NOMASK,
    },
    {
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_SIMPLE_PORTER_DUFF,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_MULTIPLY,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_SCREEN,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_OVERLAY,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_DARKEN,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_LIGHTEN,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_COLORDODGE,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_COLORBURN,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_HARDLIGHT,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_SOFTLIGHT,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_DIFFERENCE,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_EXCLUSION,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_SIMPLE_PORTER_DUFF_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_MULTIPLY_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_SCREEN_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_OVERLAY_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_DARKEN_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_LIGHTEN_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_COLORDODGE_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_COLORBURN_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_HARDLIGHT_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_SOFTLIGHT_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_DIFFERENCE_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODES_EXCLUSION_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODE_BLEND_MODE_MASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_CONICAL_COMPOSITION_MODE_BLEND_MODE_NOMASK,
    },
    {
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_SIMPLE_PORTER_DUFF,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_MULTIPLY,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_SCREEN,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_OVERLAY,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_DARKEN,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_LIGHTEN,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_COLORDODGE,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_COLORBURN,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_HARDLIGHT,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_SOFTLIGHT,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_DIFFERENCE,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_EXCLUSION,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_SIMPLE_PORTER_DUFF_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_MULTIPLY_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_SCREEN_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_OVERLAY_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_DARKEN_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_LIGHTEN_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_COLORDODGE_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_COLORBURN_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_HARDLIGHT_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_SOFTLIGHT_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_DIFFERENCE_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODES_EXCLUSION_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODE_BLEND_MODE_MASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_LINEAR_COMPOSITION_MODE_BLEND_MODE_NOMASK,
    },
    {
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_SIMPLE_PORTER_DUFF,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_MULTIPLY,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_SCREEN,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_OVERLAY,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_DARKEN,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_LIGHTEN,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_COLORDODGE,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_COLORBURN,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_HARDLIGHT,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_SOFTLIGHT,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_DIFFERENCE,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_EXCLUSION,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_SIMPLE_PORTER_DUFF_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_MULTIPLY_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_SCREEN_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_OVERLAY_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_DARKEN_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_LIGHTEN_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_COLORDODGE_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_COLORBURN_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_HARDLIGHT_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_SOFTLIGHT_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_DIFFERENCE_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODES_EXCLUSION_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODE_BLEND_MODE_MASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_TEXTURE_COMPOSITION_MODE_BLEND_MODE_NOMASK,
    },
    {
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_SIMPLE_PORTER_DUFF,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_MULTIPLY,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_SCREEN,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_OVERLAY,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_DARKEN,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_LIGHTEN,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_COLORDODGE,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_COLORBURN,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_HARDLIGHT,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_SOFTLIGHT,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_DIFFERENCE,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_EXCLUSION,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_SIMPLE_PORTER_DUFF_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_MULTIPLY_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_SCREEN_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_OVERLAY_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_DARKEN_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_LIGHTEN_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_COLORDODGE_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_COLORBURN_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_HARDLIGHT_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_SOFTLIGHT_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_DIFFERENCE_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODES_EXCLUSION_NOMASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODE_BLEND_MODE_MASK,
        FragmentProgram_FRAGMENT_PROGRAM_BRUSH_PATTERN_COMPOSITION_MODE_BLEND_MODE_NOMASK,
    },
};

static int painter_variable_locations[num_fragment_brushes][num_fragment_composition_modes][num_fragment_variables] = {
    {
        { -1, -1, -1, 2, -1, 0, 5, -1, 1, 3, 1, 0, -1, 4, -1, -1, -1, -1, -1, },
        { -1, -1, -1, 0, -1, -1, 3, -1, -1, 1, 1, 0, -1, 2, -1, -1, -1, -1, -1, },
        { -1, -1, -1, 0, -1, -1, 3, -1, -1, 1, 1, 0, -1, 2, -1, -1, -1, -1, -1, },
        { -1, -1, -1, 0, -1, -1, 3, -1, -1, 1, 1, 0, -1, 2, -1, -1, -1, -1, -1, },
        { -1, -1, -1, 0, -1, -1, 3, -1, -1, 1, 1, 0, -1, 2, -1, -1, -1, -1, -1, },
        { -1, -1, -1, 0, -1, -1, 3, -1, -1, 1, 1, 0, -1, 2, -1, -1, -1, -1, -1, },
        { -1, -1, -1, 0, -1, -1, 3, -1, -1, 1, 1, 0, -1, 2, -1, -1, -1, -1, -1, },
        { -1, -1, -1, 0, -1, -1, 3, -1, -1, 1, 1, 0, -1, 2, -1, -1, -1, -1, -1, },
        { -1, -1, -1, 0, -1, -1, 3, -1, -1, 1, 1, 0, -1, 2, -1, -1, -1, -1, -1, },
        { -1, -1, -1, 0, -1, -1, 3, -1, -1, 1, 1, 0, -1, 2, -1, -1, -1, -1, -1, },
        { -1, -1, -1, 0, -1, -1, 3, -1, -1, 1, 1, 0, -1, 2, -1, -1, -1, -1, -1, },
        { -1, -1, -1, 0, -1, -1, 3, -1, -1, 1, 1, 0, -1, 2, -1, -1, -1, -1, -1, },
        { -1, -1, -1, -1, -1, 0, -1, -1, 1, 2, -1, 0, -1, -1, -1, -1, -1, -1, -1, },
        { -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, 0, -1, -1, -1, -1, -1, -1, -1, },
        { -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, 0, -1, -1, -1, -1, -1, -1, -1, },
        { -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, 0, -1, -1, -1, -1, -1, -1, -1, },
        { -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, 0, -1, -1, -1, -1, -1, -1, -1, },
        { -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, 0, -1, -1, -1, -1, -1, -1, -1, },
        { -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, 0, -1, -1, -1, -1, -1, -1, -1, },
        { -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, 0, -1, -1, -1, -1, -1, -1, -1, },
        { -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, 0, -1, -1, -1, -1, -1, -1, -1, },
        { -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, 0, -1, -1, -1, -1, -1, -1, -1, },
        { -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, 0, -1, -1, -1, -1, -1, -1, -1, },
        { -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, 0, -1, -1, -1, -1, -1, -1, -1, },
        { -1, -1, -1, 0, -1, -1, 2, -1, -1, -1, 0, -1, -1, 1, -1, -1, -1, -1, -1, },
        { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, },
    },
    {
        { -1, -1, 3, 7, 4, 5, 10, -1, 6, 8, 1, 0, 2, 9, -1, 1, 0, 2, -1, },
        { -1, -1, 3, 5, 4, -1, 8, -1, -1, 6, 1, 0, 2, 7, -1, 1, 0, 2, -1, },
        { -1, -1, 3, 5, 4, -1, 8, -1, -1, 6, 1, 0, 2, 7, -1, 1, 0, 2, -1, },
        { -1, -1, 3, 5, 4, -1, 8, -1, -1, 6, 1, 0, 2, 7, -1, 1, 0, 2, -1, },
        { -1, -1, 3, 5, 4, -1, 8, -1, -1, 6, 1, 0, 2, 7, -1, 1, 0, 2, -1, },
        { -1, -1, 3, 5, 4, -1, 8, -1, -1, 6, 1, 0, 2, 7, -1, 1, 0, 2, -1, },
        { -1, -1, 3, 5, 4, -1, 8, -1, -1, 6, 1, 0, 2, 7, -1, 1, 0, 2, -1, },
        { -1, -1, 3, 5, 4, -1, 8, -1, -1, 6, 1, 0, 2, 7, -1, 1, 0, 2, -1, },
        { -1, -1, 3, 5, 4, -1, 8, -1, -1, 6, 1, 0, 2, 7, -1, 1, 0, 2, -1, },
        { -1, -1, 3, 5, 4, -1, 8, -1, -1, 6, 1, 0, 2, 7, -1, 1, 0, 2, -1, },
        { -1, -1, 3, 5, 4, -1, 8, -1, -1, 6, 1, 0, 2, 7, -1, 1, 0, 2, -1, },
        { -1, -1, 3, 5, 4, -1, 8, -1, -1, 6, 1, 0, 2, 7, -1, 1, 0, 2, -1, },
        { -1, -1, 3, -1, 4, 5, -1, -1, 6, 7, -1, 0, 1, -1, -1, 1, 0, 2, -1, },
        { -1, -1, 3, -1, 4, -1, -1, -1, -1, 5, -1, 0, 1, -1, -1, 1, 0, 2, -1, },
        { -1, -1, 3, -1, 4, -1, -1, -1, -1, 5, -1, 0, 1, -1, -1, 1, 0, 2, -1, },
        { -1, -1, 3, -1, 4, -1, -1, -1, -1, 5, -1, 0, 1, -1, -1, 1, 0, 2, -1, },
        { -1, -1, 3, -1, 4, -1, -1, -1, -1, 5, -1, 0, 1, -1, -1, 1, 0, 2, -1, },
        { -1, -1, 3, -1, 4, -1, -1, -1, -1, 5, -1, 0, 1, -1, -1, 1, 0, 2, -1, },
        { -1, -1, 3, -1, 4, -1, -1, -1, -1, 5, -1, 0, 1, -1, -1, 1, 0, 2, -1, },
        { -1, -1, 3, -1, 4, -1, -1, -1, -1, 5, -1, 0, 1, -1, -1, 1, 0, 2, -1, },
        { -1, -1, 3, -1, 4, -1, -1, -1, -1, 5, -1, 0, 1, -1, -1, 1, 0, 2, -1, },
        { -1, -1, 3, -1, 4, -1, -1, -1, -1, 5, -1, 0, 1, -1, -1, 1, 0, 2, -1, },
        { -1, -1, 3, -1, 4, -1, -1, -1, -1, 5, -1, 0, 1, -1, -1, 1, 0, 2, -1, },
        { -1, -1, 3, -1, 4, -1, -1, -1, -1, 5, -1, 0, 1, -1, -1, 1, 0, 2, -1, },
        { -1, -1, 3, 5, 4, -1, 7, -1, -1, -1, 0, -1, 1, 6, -1, 1, 0, 2, -1, },
        { -1, -1, 3, -1, 4, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, 1, 0, 2, -1, },
    },
    {
        { -1, -1, 2, 6, 3, 4, 9, -1, 5, 7, 1, 0, 2, 8, -1, -1, -1, 1, 0, },
        { -1, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, 2, 6, -1, -1, -1, 1, 0, },
        { -1, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, 2, 6, -1, -1, -1, 1, 0, },
        { -1, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, 2, 6, -1, -1, -1, 1, 0, },
        { -1, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, 2, 6, -1, -1, -1, 1, 0, },
        { -1, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, 2, 6, -1, -1, -1, 1, 0, },
        { -1, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, 2, 6, -1, -1, -1, 1, 0, },
        { -1, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, 2, 6, -1, -1, -1, 1, 0, },
        { -1, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, 2, 6, -1, -1, -1, 1, 0, },
        { -1, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, 2, 6, -1, -1, -1, 1, 0, },
        { -1, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, 2, 6, -1, -1, -1, 1, 0, },
        { -1, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, 2, 6, -1, -1, -1, 1, 0, },
        { -1, -1, 2, -1, 3, 4, -1, -1, 5, 6, -1, 0, 1, -1, -1, -1, -1, 1, 0, },
        { -1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, 1, -1, -1, -1, -1, 1, 0, },
        { -1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, 1, -1, -1, -1, -1, 1, 0, },
        { -1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, 1, -1, -1, -1, -1, 1, 0, },
        { -1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, 1, -1, -1, -1, -1, 1, 0, },
        { -1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, 1, -1, -1, -1, -1, 1, 0, },
        { -1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, 1, -1, -1, -1, -1, 1, 0, },
        { -1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, 1, -1, -1, -1, -1, 1, 0, },
        { -1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, 1, -1, -1, -1, -1, 1, 0, },
        { -1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, 1, -1, -1, -1, -1, 1, 0, },
        { -1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, 1, -1, -1, -1, -1, 1, 0, },
        { -1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, 1, -1, -1, -1, -1, 1, 0, },
        { -1, -1, 2, 4, 3, -1, 6, -1, -1, -1, 0, -1, 1, 5, -1, -1, -1, 1, 0, },
        { -1, -1, 2, -1, 3, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, 1, 0, },
    },
    {
        { -1, 0, 2, 6, 3, 4, 9, -1, 5, 7, 1, 0, 2, 8, -1, -1, -1, 1, -1, },
        { -1, 0, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, 2, 6, -1, -1, -1, 1, -1, },
        { -1, 0, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, 2, 6, -1, -1, -1, 1, -1, },
        { -1, 0, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, 2, 6, -1, -1, -1, 1, -1, },
        { -1, 0, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, 2, 6, -1, -1, -1, 1, -1, },
        { -1, 0, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, 2, 6, -1, -1, -1, 1, -1, },
        { -1, 0, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, 2, 6, -1, -1, -1, 1, -1, },
        { -1, 0, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, 2, 6, -1, -1, -1, 1, -1, },
        { -1, 0, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, 2, 6, -1, -1, -1, 1, -1, },
        { -1, 0, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, 2, 6, -1, -1, -1, 1, -1, },
        { -1, 0, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, 2, 6, -1, -1, -1, 1, -1, },
        { -1, 0, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, 2, 6, -1, -1, -1, 1, -1, },
        { -1, 0, 2, -1, 3, 4, -1, -1, 5, 6, -1, 0, 1, -1, -1, -1, -1, 1, -1, },
        { -1, 0, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, 1, -1, -1, -1, -1, 1, -1, },
        { -1, 0, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, 1, -1, -1, -1, -1, 1, -1, },
        { -1, 0, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, 1, -1, -1, -1, -1, 1, -1, },
        { -1, 0, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, 1, -1, -1, -1, -1, 1, -1, },
        { -1, 0, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, 1, -1, -1, -1, -1, 1, -1, },
        { -1, 0, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, 1, -1, -1, -1, -1, 1, -1, },
        { -1, 0, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, 1, -1, -1, -1, -1, 1, -1, },
        { -1, 0, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, 1, -1, -1, -1, -1, 1, -1, },
        { -1, 0, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, 1, -1, -1, -1, -1, 1, -1, },
        { -1, 0, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, 1, -1, -1, -1, -1, 1, -1, },
        { -1, 0, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, 1, -1, -1, -1, -1, 1, -1, },
        { -1, 0, 2, 4, 3, -1, 6, -1, -1, -1, 0, -1, 1, 5, -1, -1, -1, 1, -1, },
        { -1, 0, 2, -1, 3, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, 1, -1, },
    },
    {
        { 2, -1, 2, 6, 3, 4, 9, -1, 5, 7, 1, 0, -1, 8, 0, -1, -1, 1, -1, },
        { 2, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, -1, 6, 0, -1, -1, 1, -1, },
        { 2, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, -1, 6, 0, -1, -1, 1, -1, },
        { 2, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, -1, 6, 0, -1, -1, 1, -1, },
        { 2, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, -1, 6, 0, -1, -1, 1, -1, },
        { 2, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, -1, 6, 0, -1, -1, 1, -1, },
        { 2, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, -1, 6, 0, -1, -1, 1, -1, },
        { 2, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, -1, 6, 0, -1, -1, 1, -1, },
        { 2, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, -1, 6, 0, -1, -1, 1, -1, },
        { 2, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, -1, 6, 0, -1, -1, 1, -1, },
        { 2, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, -1, 6, 0, -1, -1, 1, -1, },
        { 2, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, -1, 6, 0, -1, -1, 1, -1, },
        { 1, -1, 2, -1, 3, 4, -1, -1, 5, 6, -1, 0, -1, -1, 0, -1, -1, 1, -1, },
        { 1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, -1, -1, 0, -1, -1, 1, -1, },
        { 1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, -1, -1, 0, -1, -1, 1, -1, },
        { 1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, -1, -1, 0, -1, -1, 1, -1, },
        { 1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, -1, -1, 0, -1, -1, 1, -1, },
        { 1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, -1, -1, 0, -1, -1, 1, -1, },
        { 1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, -1, -1, 0, -1, -1, 1, -1, },
        { 1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, -1, -1, 0, -1, -1, 1, -1, },
        { 1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, -1, -1, 0, -1, -1, 1, -1, },
        { 1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, -1, -1, 0, -1, -1, 1, -1, },
        { 1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, -1, -1, 0, -1, -1, 1, -1, },
        { 1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, -1, -1, 0, -1, -1, 1, -1, },
        { 1, -1, 2, 4, 3, -1, 6, -1, -1, -1, 0, -1, -1, 5, 0, -1, -1, 1, -1, },
        { 0, -1, 2, -1, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, 1, -1, },
    },
    {
        { 2, -1, 2, 6, 3, 4, 9, -1, 5, 7, 1, 0, -1, 8, 0, -1, -1, 1, -1, },
        { 2, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, -1, 6, 0, -1, -1, 1, -1, },
        { 2, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, -1, 6, 0, -1, -1, 1, -1, },
        { 2, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, -1, 6, 0, -1, -1, 1, -1, },
        { 2, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, -1, 6, 0, -1, -1, 1, -1, },
        { 2, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, -1, 6, 0, -1, -1, 1, -1, },
        { 2, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, -1, 6, 0, -1, -1, 1, -1, },
        { 2, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, -1, 6, 0, -1, -1, 1, -1, },
        { 2, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, -1, 6, 0, -1, -1, 1, -1, },
        { 2, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, -1, 6, 0, -1, -1, 1, -1, },
        { 2, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, -1, 6, 0, -1, -1, 1, -1, },
        { 2, -1, 2, 4, 3, -1, 7, -1, -1, 5, 1, 0, -1, 6, 0, -1, -1, 1, -1, },
        { 1, -1, 2, -1, 3, 4, -1, -1, 5, 6, -1, 0, -1, -1, 0, -1, -1, 1, -1, },
        { 1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, -1, -1, 0, -1, -1, 1, -1, },
        { 1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, -1, -1, 0, -1, -1, 1, -1, },
        { 1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, -1, -1, 0, -1, -1, 1, -1, },
        { 1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, -1, -1, 0, -1, -1, 1, -1, },
        { 1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, -1, -1, 0, -1, -1, 1, -1, },
        { 1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, -1, -1, 0, -1, -1, 1, -1, },
        { 1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, -1, -1, 0, -1, -1, 1, -1, },
        { 1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, -1, -1, 0, -1, -1, 1, -1, },
        { 1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, -1, -1, 0, -1, -1, 1, -1, },
        { 1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, -1, -1, 0, -1, -1, 1, -1, },
        { 1, -1, 2, -1, 3, -1, -1, -1, -1, 4, -1, 0, -1, -1, 0, -1, -1, 1, -1, },
        { 1, -1, 2, 4, 3, -1, 6, -1, -1, -1, 0, -1, -1, 5, 0, -1, -1, 1, -1, },
        { 0, -1, 2, -1, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, 1, -1, },
    },
};

static int mask_variable_locations[num_fragment_masks][num_fragment_variables] = {
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, },
    { -1, -1, 1, -1, 2, -1, -1, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, },
};

#endif
