/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGSwitchElement.h"

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGElement.h"
#include "SVGStringList.h"
#include "SVGSwitchElement.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGSwitchElement);

/* Hash table */

static const HashTableValue JSSVGSwitchElementTableValues[13] =
{
    { "requiredFeatures", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSwitchElementRequiredFeatures), (intptr_t)0 },
    { "requiredExtensions", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSwitchElementRequiredExtensions), (intptr_t)0 },
    { "systemLanguage", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSwitchElementSystemLanguage), (intptr_t)0 },
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSwitchElementXmllang), (intptr_t)setJSSVGSwitchElementXmllang },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSwitchElementXmlspace), (intptr_t)setJSSVGSwitchElementXmlspace },
    { "externalResourcesRequired", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSwitchElementExternalResourcesRequired), (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSwitchElementClassName), (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSwitchElementStyle), (intptr_t)0 },
    { "transform", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSwitchElementTransform), (intptr_t)0 },
    { "nearestViewportElement", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSwitchElementNearestViewportElement), (intptr_t)0 },
    { "farthestViewportElement", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSwitchElementFarthestViewportElement), (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSwitchElementConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGSwitchElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSSVGSwitchElementTableValues, 0 };
#else
    { 34, 31, JSSVGSwitchElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGSwitchElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGSwitchElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGSwitchElementConstructorTableValues, 0 };
#else
    { 1, 0, JSSVGSwitchElementConstructorTableValues, 0 };
#endif

class JSSVGSwitchElementConstructor : public DOMConstructorObject {
public:
    JSSVGSwitchElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSSVGSwitchElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSSVGSwitchElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGSwitchElementConstructor::s_info = { "SVGSwitchElementConstructor", 0, &JSSVGSwitchElementConstructorTable, 0 };

bool JSSVGSwitchElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGSwitchElementConstructor, DOMObject>(exec, &JSSVGSwitchElementConstructorTable, this, propertyName, slot);
}

bool JSSVGSwitchElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGSwitchElementConstructor, DOMObject>(exec, &JSSVGSwitchElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGSwitchElementPrototypeTableValues[7] =
{
    { "hasExtension", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGSwitchElementPrototypeFunctionHasExtension), (intptr_t)1 },
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGSwitchElementPrototypeFunctionGetPresentationAttribute), (intptr_t)1 },
    { "getBBox", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGSwitchElementPrototypeFunctionGetBBox), (intptr_t)0 },
    { "getCTM", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGSwitchElementPrototypeFunctionGetCTM), (intptr_t)0 },
    { "getScreenCTM", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGSwitchElementPrototypeFunctionGetScreenCTM), (intptr_t)0 },
    { "getTransformToElement", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGSwitchElementPrototypeFunctionGetTransformToElement), (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGSwitchElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 2047, JSSVGSwitchElementPrototypeTableValues, 0 };
#else
    { 17, 15, JSSVGSwitchElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGSwitchElementPrototype::s_info = { "SVGSwitchElementPrototype", 0, &JSSVGSwitchElementPrototypeTable, 0 };

JSObject* JSSVGSwitchElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGSwitchElement>(exec, globalObject);
}

bool JSSVGSwitchElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGSwitchElementPrototypeTable, this, propertyName, slot);
}

bool JSSVGSwitchElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGSwitchElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGSwitchElement::s_info = { "SVGSwitchElement", &JSSVGElement::s_info, &JSSVGSwitchElementTable, 0 };

JSSVGSwitchElement::JSSVGSwitchElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGSwitchElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

JSObject* JSSVGSwitchElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGSwitchElementPrototype(JSSVGSwitchElementPrototype::createStructure(JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGSwitchElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGSwitchElement, Base>(exec, &JSSVGSwitchElementTable, this, propertyName, slot);
}

bool JSSVGSwitchElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGSwitchElement, Base>(exec, &JSSVGSwitchElementTable, this, propertyName, descriptor);
}

JSValue jsSVGSwitchElementRequiredFeatures(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGSwitchElement* castedThis = static_cast<JSSVGSwitchElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSwitchElement* imp = static_cast<SVGSwitchElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->requiredFeatures()), imp);
    return result;
}

JSValue jsSVGSwitchElementRequiredExtensions(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGSwitchElement* castedThis = static_cast<JSSVGSwitchElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSwitchElement* imp = static_cast<SVGSwitchElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->requiredExtensions()), imp);
    return result;
}

JSValue jsSVGSwitchElementSystemLanguage(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGSwitchElement* castedThis = static_cast<JSSVGSwitchElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSwitchElement* imp = static_cast<SVGSwitchElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->systemLanguage()), imp);
    return result;
}

JSValue jsSVGSwitchElementXmllang(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGSwitchElement* castedThis = static_cast<JSSVGSwitchElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSwitchElement* imp = static_cast<SVGSwitchElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->xmllang());
    return result;
}

JSValue jsSVGSwitchElementXmlspace(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGSwitchElement* castedThis = static_cast<JSSVGSwitchElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSwitchElement* imp = static_cast<SVGSwitchElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->xmlspace());
    return result;
}

JSValue jsSVGSwitchElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGSwitchElement* castedThis = static_cast<JSSVGSwitchElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSwitchElement* imp = static_cast<SVGSwitchElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGSwitchElementClassName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGSwitchElement* castedThis = static_cast<JSSVGSwitchElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSwitchElement* imp = static_cast<SVGSwitchElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGSwitchElementStyle(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGSwitchElement* castedThis = static_cast<JSSVGSwitchElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSwitchElement* imp = static_cast<SVGSwitchElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->style()));
    return result;
}

JSValue jsSVGSwitchElementTransform(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGSwitchElement* castedThis = static_cast<JSSVGSwitchElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSwitchElement* imp = static_cast<SVGSwitchElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = imp->transformAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGSwitchElementNearestViewportElement(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGSwitchElement* castedThis = static_cast<JSSVGSwitchElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSwitchElement* imp = static_cast<SVGSwitchElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->nearestViewportElement()));
    return result;
}

JSValue jsSVGSwitchElementFarthestViewportElement(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGSwitchElement* castedThis = static_cast<JSSVGSwitchElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSwitchElement* imp = static_cast<SVGSwitchElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->farthestViewportElement()));
    return result;
}

JSValue jsSVGSwitchElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGSwitchElement* domObject = static_cast<JSSVGSwitchElement*>(asObject(slotBase));
    return JSSVGSwitchElement::getConstructor(exec, domObject->globalObject());
}
void JSSVGSwitchElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGSwitchElement, Base>(exec, propertyName, value, &JSSVGSwitchElementTable, this, slot);
}

void setJSSVGSwitchElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGSwitchElement* castedThisObj = static_cast<JSSVGSwitchElement*>(thisObject);
    SVGSwitchElement* imp = static_cast<SVGSwitchElement*>(castedThisObj->impl());
    imp->setXmllang(value.toString(exec));
}

void setJSSVGSwitchElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGSwitchElement* castedThisObj = static_cast<JSSVGSwitchElement*>(thisObject);
    SVGSwitchElement* imp = static_cast<SVGSwitchElement*>(castedThisObj->impl());
    imp->setXmlspace(value.toString(exec));
}

JSValue JSSVGSwitchElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGSwitchElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsSVGSwitchElementPrototypeFunctionHasExtension(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGSwitchElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSwitchElement* castedThisObj = static_cast<JSSVGSwitchElement*>(asObject(thisValue));
    SVGSwitchElement* imp = static_cast<SVGSwitchElement*>(castedThisObj->impl());
    const UString& extension = args.at(0).toString(exec);


    JSC::JSValue result = jsBoolean(imp->hasExtension(extension));
    return result;
}

JSValue JSC_HOST_CALL jsSVGSwitchElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGSwitchElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSwitchElement* castedThisObj = static_cast<JSSVGSwitchElement*>(asObject(thisValue));
    SVGSwitchElement* imp = static_cast<SVGSwitchElement*>(castedThisObj->impl());
    const UString& name = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}

JSValue JSC_HOST_CALL jsSVGSwitchElementPrototypeFunctionGetBBox(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGSwitchElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSwitchElement* castedThisObj = static_cast<JSSVGSwitchElement*>(asObject(thisValue));
    SVGSwitchElement* imp = static_cast<SVGSwitchElement*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<FloatRect>::create(imp->getBBox()).get(), 0 /* no context on purpose */);
    return result;
}

JSValue JSC_HOST_CALL jsSVGSwitchElementPrototypeFunctionGetCTM(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGSwitchElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSwitchElement* castedThisObj = static_cast<JSSVGSwitchElement*>(asObject(thisValue));
    SVGSwitchElement* imp = static_cast<SVGSwitchElement*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<AffineTransform>::create(imp->getCTM()).get(), 0 /* no context on purpose */);
    return result;
}

JSValue JSC_HOST_CALL jsSVGSwitchElementPrototypeFunctionGetScreenCTM(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGSwitchElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSwitchElement* castedThisObj = static_cast<JSSVGSwitchElement*>(asObject(thisValue));
    SVGSwitchElement* imp = static_cast<SVGSwitchElement*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<AffineTransform>::create(imp->getScreenCTM()).get(), 0 /* no context on purpose */);
    return result;
}

JSValue JSC_HOST_CALL jsSVGSwitchElementPrototypeFunctionGetTransformToElement(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGSwitchElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSwitchElement* castedThisObj = static_cast<JSSVGSwitchElement*>(asObject(thisValue));
    SVGSwitchElement* imp = static_cast<SVGSwitchElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    SVGElement* element = toSVGElement(args.at(0));


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<AffineTransform>::create(imp->getTransformToElement(element, ec)).get(), 0 /* no context on purpose */);
    setDOMException(exec, ec);
    return result;
}


}

#endif // ENABLE(SVG)
