/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the example classes of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui>
#include <QMainWindow>

#include "ui_mainwindow.h"

class QMdiArea;
class QMdiSubWindow;
class QGroupBox;
class QAction;
class QActionGroup;
class QMenu;
class QDialogButtonBox;
class QCloseEvent;

class MainWindow : public QMainWindow, Ui::MainWindow
{
    Q_OBJECT

public:
    enum Presets { SaveChanges, ReallyQuit, FileError, Empty };

    MainWindow();

private slots:
    void addButton();
    void deleteButton();
    void loadPresetBox();
    void newStyle(QAction *action);
    void newOrientation(QAction *action);
    void subWindowActivated(QMdiSubWindow *widget);

private:
    void connectActions();
    QWidget *createDialogButtonBox(Presets present);
    void setStyle(QDialogButtonBox *widget, QStyle *style);
    void resolveButtons();
    void resizeActiveWindow();

    int windowCount;

    QMdiArea *mdiArea;
    QMdiSubWindow *currentWindow;

    QActionGroup *styleGroup;
    QActionGroup *orientationGroup;

    QAbstractButton *myAddButton;
    QAbstractButton *myDeleteButton;
};

#endif
