#!/bin/sh

SOURCE_DIR=qt-x11-opensource-src-4.4.1-source
# Dont change this.
HEADERS_DIR=qt-x11-opensource-src-4.4.1

mkdir -p "${HEADERS_DIR}"
pushd "${SOURCE_DIR}" >/dev/null
# Copy all headers.
find . -name "*.h" -exec cp --parent '{}' ../"${HEADERS_DIR}" ';'
# Copy all pro files, since they might be needed.
find . -name "*.pro" -exec cp --parent '{}' ../"${HEADERS_DIR}" ';'
# Copy all pri files, since they might be needed.
find . -name "*.pri" -exec cp --parent '{}' ../"${HEADERS_DIR}" ';'
# Copy the include/ dir. This is necessary, because some headers don't have the .h extension.
cp -Rf include ../"${HEADERS_DIR}"
# Copy the license files.
cp {LICENSE*,GPL*,OPENSOURCE-NOTICE.TXT} ../"${HEADERS_DIR}"
popd >/dev/null
# Reproduce myself, I'm a virus, HarHarHar.
cp extract-headers.sh "${HEADERS_DIR}"
tar cfj "${HEADERS_DIR}"-headers.tar.bz2 "${HEADERS_DIR}"
