/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSMediaList.h"

#include <wtf/GetPtr.h>

#include "ExceptionCode.h"
#include "MediaList.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSMediaListTableEntries[] =
{
    { "constructor", JSMediaList::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 },
    { "length", JSMediaList::LengthAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "mediaText", JSMediaList::MediaTextAttrNum, DontDelete, 0, 0 }
};

static const HashTable JSMediaListTable = 
{
    2, 3, JSMediaListTableEntries, 3
};

/* Hash table for constructor */

static const HashEntry JSMediaListConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSMediaListConstructorTable = 
{
    2, 1, JSMediaListConstructorTableEntries, 1
};

class JSMediaListConstructor : public DOMObject {
public:
    JSMediaListConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSMediaListPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSMediaListConstructor::info = { "MediaListConstructor", 0, &JSMediaListConstructorTable, 0 };

bool JSMediaListConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMediaListConstructor, DOMObject>(exec, &JSMediaListConstructorTable, this, propertyName, slot);
}

JSValue* JSMediaListConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSMediaListPrototypeTableEntries[] =
{
    { "deleteMedium", JSMediaList::DeleteMediumFuncNum, DontDelete|Function, 1, 0 },
    { 0, 0, 0, 0, 0 },
    { "item", JSMediaList::ItemFuncNum, DontDelete|Function, 1, &JSMediaListPrototypeTableEntries[3] },
    { "appendMedium", JSMediaList::AppendMediumFuncNum, DontDelete|Function, 1, 0 }
};

static const HashTable JSMediaListPrototypeTable = 
{
    2, 4, JSMediaListPrototypeTableEntries, 3
};

const ClassInfo JSMediaListPrototype::info = { "MediaListPrototype", 0, &JSMediaListPrototypeTable, 0 };

JSObject* JSMediaListPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSMediaListPrototype>(exec, "[[JSMediaList.prototype]]");
}

bool JSMediaListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSMediaListPrototypeFunction, JSObject>(exec, &JSMediaListPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSMediaList::info = { "MediaList", 0, &JSMediaListTable, 0 };

JSMediaList::JSMediaList(ExecState* exec, MediaList* impl)
    : m_impl(impl)
{
    setPrototype(JSMediaListPrototype::self(exec));
}

JSMediaList::~JSMediaList()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSMediaList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = Lookup::findEntry(&JSMediaListTable, propertyName);
    if (entry) {
        slot.setStaticEntry(this, entry, staticValueGetter<JSMediaList>);
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<MediaList*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    return KJS::DOMObject::getOwnPropertySlot(exec, propertyName, slot);
}

JSValue* JSMediaList::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case MediaTextAttrNum: {
        MediaList* imp = static_cast<MediaList*>(impl());

        return jsStringOrNull(imp->mediaText());
    }
    case LengthAttrNum: {
        MediaList* imp = static_cast<MediaList*>(impl());

        return jsNumber(imp->length());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSMediaList::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSMediaList, KJS::DOMObject>(exec, propertyName, value, attr, &JSMediaListTable, this);
}

void JSMediaList::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case MediaTextAttrNum: {
        MediaList* imp = static_cast<MediaList*>(impl());

        ExceptionCode ec = 0;
        imp->setMediaText(valueToStringWithNullCheck(exec, value), ec);
        setDOMException(exec, ec);
        break;
    }
    }
}

JSValue* JSMediaList::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSMediaListConstructor>(exec, "[[MediaList.constructor]]");
}
JSValue* JSMediaListPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSMediaList::info))
      return throwError(exec, TypeError);

    MediaList* imp = static_cast<MediaList*>(static_cast<JSMediaList*>(thisObj)->impl());

    switch (id) {
    case JSMediaList::ItemFuncNum: {
        bool indexOk;
        unsigned index = args[0]->toInt32(exec, indexOk);
        if (!indexOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }


        KJS::JSValue* result = jsStringOrNull(imp->item(index));
        return result;
    }
    case JSMediaList::DeleteMediumFuncNum: {
        ExceptionCode ec = 0;
        String oldMedium = args[0]->toString(exec);

        imp->deleteMedium(oldMedium, ec);
        setDOMException(exec, ec);
        return jsUndefined();
    }
    case JSMediaList::AppendMediumFuncNum: {
        ExceptionCode ec = 0;
        String newMedium = args[0]->toString(exec);

        imp->appendMedium(newMedium, ec);
        setDOMException(exec, ec);
        return jsUndefined();
    }
    }
    return 0;
}

JSValue* JSMediaList::indexGetter(ExecState* exec, JSObject* originalObject, const Identifier& propertyName, const PropertySlot& slot)
{
    JSMediaList* thisObj = static_cast<JSMediaList*>(slot.slotBase());
    return jsStringOrNull(thisObj->impl()->item(slot.index()));
}
KJS::JSValue* toJS(KJS::ExecState* exec, MediaList* obj)
{
    return KJS::cacheDOMObject<MediaList, JSMediaList>(exec, obj);
}
MediaList* toMediaList(KJS::JSValue* val)
{
    return val->isObject(&JSMediaList::info) ? static_cast<JSMediaList*>(val)->impl() : 0;
}

}
