/*
 * This file is part of the DOM implementation for KDE.
 *
 * Copyright (C) 2003 Lars Knoll (knoll@kde.org)
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

/* This file is mostly data generated by flex. Unfortunately flex
   can't handle 16bit strings directly, so we just copy the part of
   the code we need and modify it to our needs.

   Most of the defines below are to make sure we can easily use the
   flex generated code, using as little editing as possible.

   The flex syntax to generate the lexer are more or less directly
   copied from the CSS2.1 specs, with some fixes for comments and
   the important symbol.

   To regenerate, run flex on tokenizer.flex. After this, copy the
   data tables and the YY_DECL method over to this file. Remove the
   init code from YY_DECL and change the YY_END_OF_BUFFER to only call
   yyterminate().

*/

// --------- begin generated code -------------------


#include "CSSGrammar.h"

#define INITIAL 0
#define mediaquery 1
#define forkeyword 2

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L
#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t;
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */
#define YY_NUM_RULES 68
#define YY_END_OF_BUFFER 69
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[479] =
    {   0,
        0,    0,    0,    0,    0,    0,   69,   67,    2,    2,
       67,   67,   67,   67,   67,   67,   67,   67,   67,   56,
       67,   67,   15,   15,   15,   67,   67,   67,   67,   66,
       15,   15,   15,   65,   15,    2,    0,    0,    0,   14,
        0,    0,    0,   18,   18,    0,    8,    0,    0,    9,
        0,    0,   15,   15,   15,    0,   57,    0,   55,    0,
        0,   56,   54,   54,   54,   54,   54,   54,   54,   54,
       54,   16,   54,   54,   51,   54,    0,   54,    0,    0,
       35,   35,   35,   35,   35,   35,   35,    0,   62,   15,
        0,    0,   15,   15,    0,   15,   15,   15,    7,    6,

        5,   15,   15,   15,   15,    0,    0,    0,   14,    0,
        0,    0,   18,   18,    0,   18,   18,    0,    0,   14,
        0,    0,    4,   16,   15,    0,    0,   54,    0,   41,
       54,   37,   39,   54,   52,   43,   54,   42,   50,   54,
       45,   44,   40,   54,   54,   54,   54,   54,    0,   35,
       35,    0,   35,   35,   35,   35,   35,   35,   35,   35,
       15,   15,   16,   15,   15,   63,   63,   15,   15,   12,
       10,   15,   13,    0,    0,    0,   17,   17,   18,   18,
       18,    0,    0,   15,    0,    1,   54,   54,   46,   54,
       53,   16,   47,   54,   54,   54,    3,   35,   35,   35,

       35,   35,   35,   35,   35,   35,   35,   15,   58,    0,
       63,   63,   63,   62,   15,   11,    0,    0,    0,   18,
       18,   18,    0,   15,    0,    0,   54,   48,   49,   54,
       54,   35,   35,   35,   35,   35,   35,   35,   20,   35,
       15,   64,   63,   63,   63,   63,    0,    0,    0,    0,
       60,    0,   15,    0,    0,    0,   18,   18,   18,    0,
       15,   54,   54,   38,   35,   35,   35,   35,   35,   21,
       35,   35,   15,   64,   63,   63,   63,   63,   63,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   60,    0,
        0,   15,    0,    0,   17,   17,   18,   18,    0,   15,

       54,   54,   35,   35,   35,   35,   19,   35,   35,   15,
       64,   63,   63,   63,   63,   63,   63,    0,   59,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       15,    0,    0,   18,   18,    0,   15,   54,   54,   35,
       35,   23,   35,   35,   35,   15,   64,   63,   63,   63,
       63,   63,   63,   63,    0,   59,    0,    0,    0,   59,
        0,    0,    0,    0,   18,   15,   54,   35,   35,   35,
       35,   64,    0,    0,    0,   36,   15,   35,   35,   35,
       35,   35,   35,   22,   24,   64,    0,    0,    0,   15,
       35,   35,   35,   35,   35,   35,    0,    0,    0,   62,

       35,   35,   35,   35,   35,   35,   35,   35,    0,    0,
        0,    0,    0,    0,   35,   35,   35,   35,   25,   35,
       35,   35,    0,   61,    0,    0,    0,    0,   26,   35,
       35,   35,   35,   27,   35,    0,    0,    0,    0,   31,
       35,   35,   35,   35,    0,    0,    0,   35,   35,   35,
       35,    0,    0,   35,   35,   29,   35,    0,    0,   35,
       33,   35,   30,    0,    0,   35,   28,   35,    0,   35,
       35,   35,   35,   34,   35,   35,   32,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    4,    5,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    6,    7,    8,    9,   10,   11,   12,   13,   14,
       15,   16,   17,   12,   18,   19,   20,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   12,   22,   23,
       24,   25,   26,   27,   28,   29,   30,   31,   32,   33,
       34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
       44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
       12,   54,   12,   55,   56,   12,   57,   58,   59,   60,

       61,   62,   63,   64,   65,   37,   66,   67,   68,   69,
       70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
       80,   81,   82,   83,   12,   84,    1,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,

       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85
    } ;

static yyconst flex_int32_t yy_meta[86] =
    {   0,
        1,    2,    3,    4,    4,    5,    6,    7,    6,    6,
        6,    6,    7,    8,    9,    6,    6,   10,    6,    6,
       11,    6,    6,    6,    6,   12,    6,   13,   13,   13,
       13,   13,   13,   14,   14,   14,   14,   14,   14,   14,
       14,   14,   14,   14,   14,   14,   14,   14,   14,   14,
       14,   14,   14,   14,    6,   14,   13,   13,   13,   13,
       13,   13,   14,   14,   14,   14,   14,   14,   14,   14,
       14,   14,   14,   14,   14,   14,   14,   14,   14,   14,
       14,    6,    6,    6,   14
    } ;

static yyconst flex_int16_t yy_base[550] =
    {   0,
        0,    0,   64,   66,   54,   56, 1407, 6578,   93,   98,
      107,   83,  155, 1376,   77, 1350,   99, 1345, 1328,  207,
     1334,  275,  100,  108,  125,  326, 1315, 1313, 1312, 6578,
      141,  110,  151, 6578,  105,  197,  295,   89,  107, 6578,
      387,  120,    0,  429, 1281,  471, 6578,  117,  532, 6578,
     1283,  269,  137,  176,  281,  574,  283, 1289, 1292, 1246,
     1257,    0, 1221,  249,  135,  282,  276,  153,   91,  169,
      299,  308,  318,  266, 1219,  320,  616,  102, 1246,  348,
     1209,  316,  127,  359,  346,  347,  375,  658, 6578,  208,
      700, 1241,  400,  409, 1220,  397,  327,  761, 6578, 6578,

     6578,  411,  419,  414,  424,  248,  368,  355,  356,  822,
      883,    0, 1191,  925,  967, 1190, 1028,  381,  421,  464,
     1089, 1150, 6578,  214,  456, 1225,  312, 1151, 1192, 1142,
      442, 1139, 1134,  452, 1131, 1104,  458, 1082, 1060,  358,
     1046, 1028, 1027,  462,  453, 1000, 1253,  469, 1023,  463,
      986, 1295,  492,  486,  500,  484,  502,  513,  969, 1356,
      425, 1417, 1001,  545,  494,  193,  993,  543, 1459,  544,
      554,  558,  555,  508,  398, 1520,    0, 1562,  956, 1623,
     1684,  570, 1745,  563,  993, 6578,  948, 1806,  935,  520,
      921,  498,  914,  546, 1848,  564, 6578,  585,  913, 1909,

      568,  576,  586,  606,  631,  640, 1951, 2012, 6578,    0,
      203,  924,  907,  694, 2054,  565,  543, 2115,    0, 2157,
     2218, 2279, 2340,  669,  912,  505, 2401,  856,  840, 2443,
      612,  615, 2504,  608,  557,  639,  682,  668,  839, 2546,
     2607,    0,  288,  863,  841,  819,  741,  794,  573,  418,
     6578, 2668, 2710,  620, 2771,    0, 2813, 2874, 2935, 2996,
     3057, 3131, 3173, 3234,  670, 3295,  718,  719,  729,  763,
      684, 3337, 3398,    0,  456,  782,  777,  760,  742,  829,
      649,  834, 3459,  572, 3520,  854,  894,  915,  920, 3581,
     3642, 3684,  593, 3745, 6578,  697, 3806, 3867, 3928, 3989,

     4050, 4111,  730, 4172,  731,  683,  672,  759, 4214, 4275,
        0,  762,  682,  429,  417,  414,  411,  859, 6578,  650,
      838,  957, 4336, 4397,  607,  926,  988, 4458, 4519, 4580,
     1002,  672, 1010, 4622, 4664, 1042,  752, 4706, 4767,  756,
     4828,  376,  812,  847, 1069, 1033,    0,  387, 6578, 6578,
     6578, 6578, 6578, 6578, 1122,  924,  963, 4870, 1162, 1049,
     1050, 4912, 4973,  678, 1063,  850, 1074, 5005, 1103,  841,
      989,    0, 5062, 5104, 5146, 6578, 1066, 1080, 1081, 1084,
     1108, 1137,  877,  328,  273, 6578, 5188, 5230, 5272,  641,
     1140,  884,  916,  836, 1105, 1161, 5314, 5356, 1233, 1286,

     1147, 1138,  919, 1206, 1165, 1186, 1141, 1207, 1291, 1263,
     1316, 1345, 1327, 5398, 1086, 1029, 1225, 1133,  258, 1247,
     1248, 1310, 1388, 6578, 1427, 5440, 1449, 5501,  242, 1311,
     1341, 1324, 1326,  173, 1317, 1454, 5562, 1480, 5604,  170,
     1061, 1328, 1355, 1372, 1552, 5646, 5688, 1351, 1374, 1389,
     1409, 5730, 5772, 1419, 1456,  154, 1453, 5814, 5856, 1457,
      112,  897,  793, 5898, 1557, 1418,  109, 1348, 1582, 1550,
     1477, 1481, 1485,   90, 1564, 1458,   39, 6578, 5959, 5964,
     5977, 5982, 5987, 5994, 6004, 6017,  296, 6022, 6032, 6045,
     6059,  651, 6064, 6074, 6079, 6089, 6099, 6103,  571, 6112,

     6125, 6138, 6152, 6166, 6176, 6186, 6191, 6203,  657, 6217,
      758, 6222, 6234, 6247,  801, 6261,  859, 6266, 6278, 6291,
     6304, 6317, 6330, 1086, 6335, 6348, 1120, 6353, 6365, 6378,
     6391, 6404, 6417, 6430, 6435, 6448, 1216, 6453, 6465, 6478,
     6491, 6504, 6517, 1219, 1220, 6530, 6543, 6553, 6563
    } ;

static yyconst flex_int16_t yy_def[550] =
    {   0,
      478,    1,    1,    1,    1,    1,  478,  478,  478,  478,
      478,  479,  480,  478,  481,  478,  482,  478,  478,  478,
      478,  483,  484,  484,  484,  485,  478,  478,  478,  478,
      484,  484,  484,  478,  484,  478,  478,  478,  479,  478,
      486,  480,  487,  488,  488,  489,  478,  481,  490,  478,
      478,  478,  484,  484,  484,  485,   20,  491,  478,  492,
      478,   20,  493,  493,  493,  493,  493,  493,  493,  493,
      493,  493,  493,  493,  493,  493,  494,  493,  478,  483,
      495,  495,  495,  495,  495,  495,  495,  496,  478,  484,
      497,  478,  484,  484,  498,  484,  484,  484,  478,  478,

      478,  484,  484,  484,  484,  478,  479,  479,  479,  479,
      486,  499,  488,  488,  500,  488,  114,  501,  501,  501,
      501,  502,  478,  478,  484,  503,  504,  493,  505,  493,
      493,  493,  493,  493,  493,  493,  493,  493,  493,  493,
      493,  493,  493,  493,  493,  493,  493,  493,  478,  495,
      495,  506,  495,  495,  495,  495,  495,  495,  495,  495,
      484,   98,  478,  484,  484,  507,  478,  484,   98,  484,
      484,  484,  484,  478,  508,  508,  509,  114,  488,  114,
      114,  501,  501,  484,  510,  478,  493,  147,  493,  493,
      493,  493,  493,  493,  147,  493,  478,  495,  495,  160,

      495,  495,  495,  495,  495,  495,  160,   98,  478,  511,
      512,  478,  478,  513,   98,  484,  478,  514,  515,  114,
      114,  114,  501,  484,  510,  516,  147,  493,  493,  147,
      493,  495,  160,  495,  495,  495,  495,  495,  495,  160,
       98,  517,  518,  478,  478,  478,  519,  519,  520,  521,
      478,  522,   98,  478,  523,  524,  525,  525,  258,  526,
       98,  147,  147,  147,  495,  160,  495,  495,  495,  495,
      495,  160,   98,  527,  528,  478,  478,  478,  478,  478,
      520,  478,  529,  530,  531,  532,  532,  532,  532,  532,
      533,   98,  478,  534,  478,  535,  535,  297,  536,   98,

      147,  301,  495,  160,  495,  495,  495,  495,  160,   98,
      537,  538,  478,  478,  478,  478,  478,  478,  478,  539,
      539,  539,  539,  540,  541,  541,  541,  541,  542,  543,
      300,  478,  534,  297,  298,  536,  300,  301,  301,  495,
      160,  495,  495,  495,  495,  300,  544,  478,  478,  478,
      478,  478,  478,  478,  539,  539,  539,  323,  541,  541,
      541,  328,  543,  478,  335,  300,  339,  495,  495,  495,
      495,  545,  323,  328,  363,  478,  300,  495,  495,  495,
      495,  495,  495,  495,  495,  478,  323,  328,  363,  300,
      495,  495,  495,  495,  495,  495,  323,  328,  543,  546,

      495,  495,  495,  495,  495,  495,  495,  495,  539,  541,
      546,  546,  547,  548,  495,  495,  495,  495,  495,  495,
      495,  495,  478,  478,  547,  549,  547,  547,  495,  495,
      495,  495,  495,  495,  495,  547,  428,  547,  428,  495,
      495,  495,  495,  495,  547,  437,  428,  495,  495,  495,
      495,  437,  428,  495,  495,  495,  495,  437,  428,  495,
      495,  495,  495,  437,  547,  495,  495,  495,  547,  495,
      495,  495,  495,  495,  495,  495,  495,    0,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,

      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478
    } ;

static yyconst flex_int16_t yy_nxt[6664] =
    {   0,
        8,    9,   10,    9,    9,    9,   11,   12,   13,   14,
        8,    8,   15,    8,    8,   16,    8,   17,   18,   19,
       20,    8,   21,    8,    8,    8,   22,   23,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       24,   23,   23,   23,   23,   23,   23,   25,   23,   23,
       23,   23,   23,   26,   27,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   24,   23,
       23,   23,   23,   23,   23,   25,   23,   23,   23,   23,
       23,    8,   28,   29,   23,   30,   35,   30,   35,   40,
       40,   31,  152,   31,   36,   36,   36,   36,   36,   36,

       36,   36,   36,   36,   32,   33,   32,   33,   37,   37,
       37,   37,   37,   89,   40,   35,   51,   35,   89,   52,
       31,   89,   31,   89,   92,   93,   92,   93,  106,   40,
       49,  136,   32,   33,   32,   33,   41,  478,   89,   54,
      478,   95,   38,  152,  129,   34,  105,   34,   55,   94,
       89,  103,   56,   91,   89,  129,  106,  148,   91,  136,
       41,   91,  152,   91,   89,  152,  131,   54,  154,   96,
       49,   38,   42,   46,  105,   43,   55,   94,   91,  103,
      152,  102,   44,   44,   44,   44,   44,   44,  129,   89,
       91,  104,   92,   93,   91,  131,  154,   96,   36,   36,

       36,   36,   36,  137,   91,  135,  129,  152,   46,  102,
      210,   44,   44,   44,   44,   44,   44,   59,  212,  104,
      210,   89,  129,  152,   60,   61,  152,   62,  244,   91,
       92,   92,  137,  135,   63,   63,   64,   65,   66,   63,
       67,   68,   69,   63,   70,   63,   71,   72,   63,   73,
       63,   74,   75,   76,   63,   63,   63,   63,   63,   63,
       77,   91,   78,   63,   63,   64,   65,   66,   63,   67,
       68,   69,   70,   63,   71,   72,   63,   73,   63,   74,
       75,   76,   63,   63,   63,   63,   63,   63,  130,   52,
      174,   63,   80,  144,   89,  152,   37,   37,   37,   37,

       37,  478,  129,   57,   82,  210,  112,   83,  112,  124,
       84,  152,  125,  276,   85,   86,  130,   87,  174,  129,
      134,  132,  144,   63,   92,  140,  152,  127,   88,  129,
       38,  186,  133,   82,   91,  129,   83,  124,  138,   84,
       89,  125,   85,   86,  139,   87,   98,  141,  134,  132,
      153,   63,  129,   98,   98,   98,   98,   98,   98,   38,
      133,  129,   40,   40,  142,  478,  138,  145,  143,  152,
       39,  129,  139,  129,  157,   40,  141,  156,  192,  153,
       91,  152,   98,   98,   98,   98,   98,   98,   39,   39,
       39,  107,  142,   40,  109,  145,  143,  150,  155,  152,

      152,   88,  158,  157,  210,   40,  156,  110,   41,   41,
       89,  129,  152,   89,  110,  110,  110,  110,  110,  110,
      164,   41,   89,  478,   89,  150,  155,   89,  152,  152,
      282,  158,   89,   40,   49,  168,  354,   89,   89,  353,
      111,  170,  352,  110,  110,  110,  110,  110,  110,  114,
       91,   41,  172,   91,  351,  165,  114,  114,  114,  114,
      114,  114,   91,  168,   91,  171,  478,   91,  173,   89,
      170,  285,   91,  210,   49,  189,   40,   91,   91,  190,
      172,  313,  115,  165,  184,  114,  114,  114,  114,  114,
      114,  117,  193,  171,  198,  129,  173,  194,  117,  117,

      117,  117,  117,  117,  189,  129,  129,  209,  190,   91,
      191,  129,  196,  184,  204,  129,  152,   49,  192,  201,
      226,  193,  129,  198,  186,  194,  202,  117,  117,  117,
      117,  117,  117,   48,   48,   48,  118,  152,  191,  152,
      196,  205,  203,  204,  120,  152,  206,   91,  201,  217,
      228,  129,  121,  152,  202,  152,  214,   89,   89,  121,
      121,  121,  121,  121,  121,  164,  152,  209,   89,  205,
      203,   89,  478,  129,  268,  206,   89,  217,   89,  228,
      282,  177,   40,  177,  282,  122,  229,  254,  121,  121,
      121,  121,  121,  121,   98,  231,   91,   91,   91,  129,

      224,   98,   98,   98,   98,   98,   98,   91,   91,  216,
      152,   91,  234,  232,  229,  254,   91,  129,   91,  282,
      332,  152,  235,   49,  231,  285,  283,  236,  224,  152,
       98,   98,   98,   98,   98,   98,  147,  216,  152,  152,
      234,  237,  232,  147,  147,  147,  147,  147,  147,  332,
      235,  264,  265,  267,  400,  236,  282,  282,   90,  152,
      285,  152,  238,   63,   63,  129,  293,  219,  152,  219,
      237,  239,  147,  147,  147,  147,  147,  147,  160,  264,
      265,  267,   89,  269,  152,  160,  160,  160,  160,  160,
      160,  238,  152,  152,  293,  247,  247,  247,  247,  247,

      239,  249,  283,  283,  261,  303,  250,  350,  251,  270,
      343,  269,  364,  271,  160,  160,  160,  160,  160,  160,
      162,  152,   91,  152,  376,  152,  308,  162,  162,  162,
      162,  162,  162,  261,  303,  152,  152,  152,  270,  343,
      364,  271,  247,  247,  247,  247,  247,  252,  249,  305,
      115,  306,  376,  250,  308,  251,  162,  162,  162,  162,
      162,  162,   97,   97,   97,   97,   97,  317,  242,   90,
      242,  152,  152,  368,   89,  307,  340,  342,  305,  210,
      306,  169,  152,  152,  152,  316,  344,  349,  169,  169,
      169,  169,  169,  169,  252,  280,  280,  280,  280,  280,

      366,  478,  315,  307,  340,  342,  478,  314,  251,  152,
      468,  256,  152,  256,   91,  344,  152,  169,  169,  169,
      169,  169,  169,  108,  175,  175,  175,  108,  366,   40,
      280,  280,  280,  280,  280,  318,  318,  318,  318,  318,
      478,  370,  176,  251,  279,  282,  152,  252,  319,  176,
      176,  176,  176,  176,  176,  280,  280,  280,  280,  280,
      318,  318,  318,  318,  318,  152,  278,   90,  251,  274,
      370,  274,  384,  319,  405,   41,  371,  377,  176,  176,
      176,  176,  176,  176,   39,   39,   39,  107,  277,  152,
      109,  283,  152,  129,  152,  280,  280,  280,  280,  280,

      152,  384,  405,  110,  396,  371,  377,  252,  251,  129,
      110,  110,  110,  110,  110,  110,  280,  280,  280,  280,
      280,  280,  280,  280,  280,  280,  478,  226,  478,  251,
      152,  282,  246,  396,  251,  403,  111,  152,  282,  110,
      110,  110,  110,  110,  110,  178,  404,  252,  467,  245,
      152,  417,  178,  178,  178,  178,  178,  178,  355,  318,
      318,  318,  355,  403,  282,  478,  152,  129,  252,  152,
      282,  356,  152,  252,  129,  404,  467,  283,  115,  285,
      417,  178,  178,  178,  178,  178,  178,  180,  129,  359,
      318,  318,  318,  359,  180,  180,  180,  180,  180,  180,

      282,  129,  360,   97,   97,   97,   97,   97,  226,  115,
      283,  108,  175,  175,  175,  108,  283,   40,  213,   90,
      385,  163,  152,  180,  180,  180,  180,  180,  180,  116,
      116,  116,  116,  116,  161,  161,  161,  161,  161,  152,
      197,  285,  152,  119,  182,  182,  182,  119,  181,  385,
       90,  478,  478,  129,   40,  181,  181,  181,  181,  181,
      181,  282,  282,   41,  179,  179,  179,  179,  179,  430,
      159,  159,  159,  159,  159,  187,  187,  187,  187,  187,
      129,  129,  152,   90,  181,  181,  181,  181,  181,  181,
      119,  182,  182,  182,  119,   49,  295,  430,  295,  129,

      448,   40,  285,  285,  199,  199,  199,  199,  199,  183,
      390,  391,  392,  129,  152,  393,  183,  183,  183,  183,
      183,  183,  152,  355,  318,  318,  318,  355,  448,  282,
      311,  429,  311,  152,  152,  129,  356,  152,  390,  152,
      391,  392,   49,  406,  393,  183,  183,  183,  183,  183,
      183,   48,   48,   48,  118,  394,  152,  129,  152,  429,
      432,  152,  120,  359,  318,  318,  318,  359,  395,  401,
      121,  406,  402,  416,  282,  283,  360,  121,  121,  121,
      121,  121,  121,  394,  129,  415,  152,  129,  421,  432,
      152,  152,  129,  152,  152,  129,  419,  395,  401,  407,

      152,  402,  416,  122,  129,  408,  121,  121,  121,  121,
      121,  121,  188,  415,  152,  285,  421,  420,  152,  188,
      188,  188,  188,  188,  188,  419,  347,  407,  347,  372,
      386,  372,  386,  408,  286,  286,  286,  286,  286,  152,
      127,  418,  422,  115,  115,  167,  420,  251,  188,  188,
      188,  188,  188,  188,  146,  146,  146,  146,  146,  152,
      152,  163,  152,  149,  326,  361,  361,  361,  326,  431,
      418,  422,  129,  195,  129,  282,  433,   57,  152,  434,
      195,  195,  195,  195,  195,  195,  252,  411,  411,  411,
      411,  411,  321,  357,  357,  357,  321,  431,  282,   77,

      152,  152,   59,  412,  127,  433,  129,  123,  434,  195,
      195,  195,  195,  195,  195,  200,  285,  411,  411,  411,
      411,  411,  200,  200,  200,  200,  200,  200,  423,  423,
      423,  423,  423,  412,  115,  101,  100,  435,   99,  414,
       79,  424,  440,   58,  283,  444,  478,  478,  478,  478,
      478,  200,  200,  200,  200,  200,  200,  159,  159,  159,
      159,  159,  478,  152,  152,   57,  435,  442,  441,  414,
      152,  440,  443,   50,  444,  449,  207,  152,  471,  152,
      426,  152,  454,  207,  207,  207,  207,  207,  207,  423,
      423,  423,  423,  423,  152,  442,  450,  441,  414,   47,

      443,  152,  424,  449,  152,  455,  478,  471,  152,  152,
      451,  454,  207,  207,  207,  207,  207,  207,  161,  161,
      161,  161,  161,  478,  450,  152,  478,  152,  423,  423,
      423,  423,  423,  456,  455,  478,  460,  208,  451,  478,
      457,  424,  152,  478,  208,  208,  208,  208,  208,  208,
      423,  423,  423,  423,  423,  423,  423,  423,  423,  423,
      478,  456,  152,  424,  461,  470,  478,  478,  424,  457,
      478,  152,  152,  208,  208,  208,  208,  208,  208,  215,
      426,  423,  423,  423,  423,  423,  215,  215,  215,  215,
      215,  215,  461,  470,  424,  478,  478,  478,  463,  478,

      462,  466,  426,  477,  478,  478,  152,  426,  473,  152,
      152,  152,  474,  478,  475,  215,  215,  215,  215,  215,
      215,  108,  175,  175,  175,  108,  463,   40,  462,  466,
      152,  477,  478,  426,  152,  478,  478,  473,  152,  478,
      218,  474,  478,  475,  478,  478,  478,  218,  218,  218,
      218,  218,  218,  423,  423,  423,  423,  423,  438,  438,
      438,  438,  438,  478,  478,  478,  424,  478,  478,  478,
      478,  424,  478,   41,  478,  478,  218,  218,  218,  218,
      218,  218,  220,  445,  445,  445,  445,  445,  472,  220,
      220,  220,  220,  220,  220,  478,  424,  478,  478,  478,

      478,  478,  476,  152,  478,  426,  478,  478,  478,  478,
      426,  478,  478,  478,  478,  478,  472,  152,  220,  220,
      220,  220,  220,  220,  179,  179,  179,  179,  179,  478,
      476,  478,  478,  478,  478,  426,  478,  478,  478,  478,
      478,  478,  478,  221,  478,  478,  478,  478,  478,  478,
      221,  221,  221,  221,  221,  221,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  221,
      221,  221,  221,  221,  221,  116,  116,  116,  116,  116,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,

      478,  478,  478,  478,  222,  478,  478,  478,  478,  478,
      478,  222,  222,  222,  222,  222,  222,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      222,  222,  222,  222,  222,  222,  119,  182,  182,  182,
      119,  478,  478,  478,  478,  478,  478,   40,  478,  478,
      478,  478,  478,  478,  478,  223,  478,  478,  478,  478,
      478,  478,  223,  223,  223,  223,  223,  223,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,   49,  478,

      478,  223,  223,  223,  223,  223,  223,  187,  187,  187,
      187,  187,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  227,  478,  478,  478,
      478,  478,  478,  227,  227,  227,  227,  227,  227,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  227,  227,  227,  227,  227,  227,  230,  478,
      478,  478,  478,  478,  478,  230,  230,  230,  230,  230,
      230,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,

      478,  478,  478,  478,  230,  230,  230,  230,  230,  230,
      199,  199,  199,  199,  199,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  233,
      478,  478,  478,  478,  478,  478,  233,  233,  233,  233,
      233,  233,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  233,  233,  233,  233,  233,
      233,  240,  478,  478,  478,  478,  478,  478,  240,  240,
      240,  240,  240,  240,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,

      478,  478,  478,  478,  478,  478,  478,  240,  240,  240,
      240,  240,  240,  161,  161,  161,  161,  161,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  241,  478,  478,  478,  478,  478,  478,  241,
      241,  241,  241,  241,  241,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  241,  241,
      241,  241,  241,  241,  253,  478,  478,  478,  478,  478,
      478,  253,  253,  253,  253,  253,  253,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,

      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      253,  253,  253,  253,  253,  253,  108,  175,  175,  175,
      108,  478,   40,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  255,  478,  478,  478,  478,
      478,  478,  255,  255,  255,  255,  255,  255,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,   41,  478,
      478,  255,  255,  255,  255,  255,  255,  257,  478,  478,
      478,  478,  478,  478,  257,  257,  257,  257,  257,  257,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,

      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  257,  257,  257,  257,  257,  257,  179,
      179,  179,  179,  179,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  258,  478,
      478,  478,  478,  478,  478,  258,  258,  258,  258,  258,
      258,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  258,  258,  258,  258,  258,  258,
      116,  116,  116,  116,  116,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  259,

      478,  478,  478,  478,  478,  478,  259,  259,  259,  259,
      259,  259,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  259,  259,  259,  259,  259,
      259,  119,  182,  182,  182,  119,  478,  478,  478,  478,
      478,  478,   40,  478,  478,  478,  478,  478,  478,  478,
      260,  478,  478,  478,  478,  478,  478,  260,  260,  260,
      260,  260,  260,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,   49,  478,  478,  260,  260,  260,  260,

      260,  260,  187,  187,  187,  187,  187,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  262,  478,  478,  478,  478,  478,  478,  262,  262,
      262,  262,  262,  262,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  262,  262,  262,
      262,  262,  262,  263,  478,  478,  478,  478,  478,  478,
      263,  263,  263,  263,  263,  263,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  263,

      263,  263,  263,  263,  263,  199,  199,  199,  199,  199,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  266,  478,  478,  478,  478,  478,
      478,  266,  266,  266,  266,  266,  266,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      266,  266,  266,  266,  266,  266,  272,  478,  478,  478,
      478,  478,  478,  272,  272,  272,  272,  272,  272,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,

      478,  478,  272,  272,  272,  272,  272,  272,  161,  161,
      161,  161,  161,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  273,  478,  478,
      478,  478,  478,  478,  273,  273,  273,  273,  273,  273,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  273,  273,  273,  273,  273,  273,  280,
      280,  280,  280,  286,  478,  288,  478,  478,  478,  478,
      288,  288,  289,  478,  478,  478,  478,  478,  290,  478,
      478,  478,  478,  478,  478,  290,  290,  290,  290,  290,

      290,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  291,  478,  478,  290,  290,  290,  290,  290,  290,
      292,  478,  478,  478,  478,  478,  478,  292,  292,  292,
      292,  292,  292,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  292,  292,  292,  292,
      292,  292,  108,  175,  175,  175,  108,  478,   40,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  294,  478,  478,  478,  478,  478,  478,  294,  294,

      294,  294,  294,  294,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,   41,  478,  478,  294,  294,  294,
      294,  294,  294,  296,  478,  478,  478,  478,  478,  478,
      296,  296,  296,  296,  296,  296,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  115,  478,  478,  296,
      296,  296,  296,  296,  296,  179,  179,  179,  179,  179,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  297,  478,  478,  478,  478,  478,

      478,  297,  297,  297,  297,  297,  297,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  115,  478,  478,
      297,  297,  297,  297,  297,  297,  116,  116,  116,  116,
      116,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  298,  478,  478,  478,  478,
      478,  478,  298,  298,  298,  298,  298,  298,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  298,  298,  298,  298,  298,  298,  119,  182,  182,

      182,  119,  478,  478,  478,  478,  478,  478,   40,  478,
      478,  478,  478,  478,  478,  478,  299,  478,  478,  478,
      478,  478,  478,  299,  299,  299,  299,  299,  299,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,   49,
      478,  478,  299,  299,  299,  299,  299,  299,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,   90,  478,  478,
      478,  478,  478,  478,   90,   90,   90,   90,   90,   90,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,

      478,  478,  478,  300,  478,  478,  478,  478,  478,  478,
      478,  478,  478,   90,   90,   90,   90,   90,   90,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  300,  187,  187,  187,  187,  187,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  301,  478,  478,  478,  478,  478,  478,  301,  301,
      301,  301,  301,  301,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  301,  301,  301,
      301,  301,  301,  302,  478,  478,  478,  478,  478,  478,

      302,  302,  302,  302,  302,  302,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  302,
      302,  302,  302,  302,  302,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  128,  478,  478,  478,  478,  478,
      478,  128,  128,  128,  128,  128,  128,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      128,  128,  128,  128,  128,  128,  199,  199,  199,  199,

      199,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  304,  478,  478,  478,  478,
      478,  478,  304,  304,  304,  304,  304,  304,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  304,  304,  304,  304,  304,  304,  309,  478,  478,
      478,  478,  478,  478,  309,  309,  309,  309,  309,  309,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  309,  309,  309,  309,  309,  309,  161,

      161,  161,  161,  161,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  310,  478,
      478,  478,  478,  478,  478,  310,  310,  310,  310,  310,
      310,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  310,  310,  310,  310,  310,  310,
      281,  281,  281,  320,  478,  478,  322,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  323,
      478,  478,  478,  478,  478,  478,  323,  323,  323,  323,
      323,  323,  478,  478,  478,  478,  478,  478,  478,  478,

      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  324,  478,  478,  323,  323,  323,  323,  323,
      323,  284,  284,  284,  325,  478,  478,  478,  478,  478,
      478,  478,  327,  478,  478,  478,  478,  478,  478,  478,
      328,  478,  478,  478,  478,  478,  478,  328,  328,  328,
      328,  328,  328,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  329,  478,  478,  328,  328,  328,  328,
      328,  328,  286,  286,  286,  286,  286,  478,  478,  478,
      478,  478,  478,  478,  478,  251,  478,  478,  478,  478,

      478,  330,  478,  478,  478,  478,  478,  478,  330,  330,
      330,  330,  330,  330,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  252,  478,  478,  330,  330,  330,
      330,  330,  330,  280,  280,  280,  280,  286,  478,  288,
      478,  478,  478,  478,  288,  288,  289,  478,  478,  478,
      478,  478,  290,  478,  478,  478,  478,  478,  478,  290,
      290,  290,  290,  290,  290,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  291,  478,  478,  290,  290,

      290,  290,  290,  290,  331,  478,  478,  478,  478,  478,
      478,  331,  331,  331,  331,  331,  331,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      331,  331,  331,  331,  331,  331,  108,  175,  175,  175,
      108,  478,   40,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  333,  478,  478,  478,  478,
      478,  478,  333,  333,  333,  333,  333,  333,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,   41,  478,

      478,  333,  333,  333,  333,  333,  333,  179,  179,  179,
      179,  179,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  334,  478,  478,  478,
      478,  478,  478,  334,  334,  334,  334,  334,  334,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  115,
      478,  478,  334,  334,  334,  334,  334,  334,  116,  116,
      116,  116,  116,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  335,  478,  478,
      478,  478,  478,  478,  335,  335,  335,  335,  335,  335,

      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  335,  335,  335,  335,  335,  335,  119,
      182,  182,  182,  119,  478,  478,  478,  478,  478,  478,
       40,  478,  478,  478,  478,  478,  478,  478,  336,  478,
      478,  478,  478,  478,  478,  336,  336,  336,  336,  336,
      336,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,   49,  478,  478,  336,  336,  336,  336,  336,  336,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,

      478,  478,  478,  478,  478,  478,  337,  478,  478,   90,
      478,  478,  478,  478,  478,  478,   90,   90,   90,   90,
       90,   90,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,   90,   90,   90,   90,   90,
       90,  187,  187,  187,  187,  187,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      338,  478,  478,  478,  478,  478,  478,  338,  338,  338,
      338,  338,  338,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,

      478,  478,  478,  478,  478,  478,  338,  338,  338,  338,
      338,  338,  146,  146,  146,  146,  146,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  339,  478,  478,  478,  478,  478,  478,  339,  339,
      339,  339,  339,  339,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  339,  339,  339,
      339,  339,  339,  199,  199,  199,  199,  199,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  341,  478,  478,  478,  478,  478,  478,  341,

      341,  341,  341,  341,  341,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  341,  341,
      341,  341,  341,  341,  345,  478,  478,  478,  478,  478,
      478,  345,  345,  345,  345,  345,  345,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      345,  345,  345,  345,  345,  345,  161,  161,  161,  161,
      161,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  346,  478,  478,  478,  478,

      478,  478,  346,  346,  346,  346,  346,  346,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  346,  346,  346,  346,  346,  346,  321,  357,  357,
      357,  321,  478,  282,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  358,  478,  478,  478,
      478,  478,  478,  358,  358,  358,  358,  358,  358,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  283,
      478,  478,  358,  358,  358,  358,  358,  358,  281,  281,

      281,  320,  478,  478,  322,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  323,  478,  478,
      478,  478,  478,  478,  323,  323,  323,  323,  323,  323,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      324,  478,  478,  323,  323,  323,  323,  323,  323,  326,
      361,  361,  361,  326,  478,  478,  478,  478,  478,  478,
      282,  478,  478,  478,  478,  478,  478,  478,  362,  478,
      478,  478,  478,  478,  478,  362,  362,  362,  362,  362,
      362,  478,  478,  478,  478,  478,  478,  478,  478,  478,

      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  285,  478,  478,  362,  362,  362,  362,  362,  362,
      284,  284,  284,  325,  478,  478,  478,  478,  478,  478,
      478,  327,  478,  478,  478,  478,  478,  478,  478,  328,
      478,  478,  478,  478,  478,  478,  328,  328,  328,  328,
      328,  328,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  329,  478,  478,  328,  328,  328,  328,  328,
      328,  286,  286,  286,  286,  286,  478,  478,  478,  478,
      478,  478,  478,  478,  251,  478,  478,  478,  478,  478,

      363,  478,  478,  478,  478,  478,  478,  363,  363,  363,
      363,  363,  363,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  252,  478,  478,  363,  363,  363,  363,
      363,  363,  365,  478,  478,  478,  478,  478,  478,  365,
      365,  365,  365,  365,  365,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  365,  365,
      365,  365,  365,  365,  113,  478,  478,  478,  478,  478,
      478,  113,  113,  113,  113,  113,  113,  478,  478,  478,

      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      113,  113,  113,  113,  113,  113,  367,  478,  478,  478,
      478,  478,  478,  367,  367,  367,  367,  367,  367,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  367,  367,  367,  367,  367,  367,  146,  146,
      146,  146,  146,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  128,  478,  478,
      478,  478,  478,  478,  128,  128,  128,  128,  128,  128,

      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  128,  128,  128,  128,  128,  128,  199,
      199,  199,  199,  199,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  369,  478,
      478,  478,  478,  478,  478,  369,  369,  369,  369,  369,
      369,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  369,  369,  369,  369,  369,  369,
      373,  478,  478,  478,  478,  478,  478,  373,  373,  373,

      373,  373,  373,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  373,  373,  373,  373,
      373,  373,  374,  478,  478,  478,  478,  478,  478,  374,
      374,  374,  374,  374,  374,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  374,  374,
      374,  374,  374,  374,  286,  286,  286,  286,  286,  478,
      478,  478,  478,  478,  478,  478,  478,  251,  478,  478,
      478,  478,  478,  375,  478,  478,  478,  478,  478,  478,

      375,  375,  375,  375,  375,  375,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  252,  478,  478,  375,
      375,  375,  375,  375,  375,  378,  478,  478,  478,  478,
      478,  478,  379,  478,  380,  478,  478,  478,  478,  381,
      382,  478,  478,  383,  478,  478,  478,  478,  152,  478,
      478,  478,  478,  478,  378,  478,  478,  478,  478,  478,
      379,  478,  380,  478,  478,  478,  478,  381,  382,  478,
      478,  383,  387,  478,  478,  478,  478,  478,  478,  387,
      387,  387,  387,  387,  387,  478,  478,  478,  478,  478,

      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  387,  387,
      387,  387,  387,  387,  388,  478,  478,  478,  478,  478,
      478,  388,  388,  388,  388,  388,  388,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      388,  388,  388,  388,  388,  388,  389,  478,  478,  478,
      478,  478,  478,  389,  389,  389,  389,  389,  389,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,

      478,  478,  389,  389,  389,  389,  389,  389,  397,  478,
      478,  478,  478,  478,  478,  397,  397,  397,  397,  397,
      397,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  397,  397,  397,  397,  397,  397,
      398,  478,  478,  478,  478,  478,  478,  398,  398,  398,
      398,  398,  398,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  398,  398,  398,  398,
      398,  398,  399,  478,  478,  478,  478,  478,  478,  399,

      399,  399,  399,  399,  399,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  399,  399,
      399,  399,  399,  399,  409,  478,  478,  478,  478,  478,
      478,  409,  409,  409,  409,  409,  409,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      409,  409,  409,  409,  409,  409,  410,  478,  478,  478,
      478,  478,  478,  410,  410,  410,  410,  410,  410,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,

      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  410,  410,  410,  410,  410,  410,  428,  478,
      478,  478,  478,  478,  478,  428,  428,  428,  428,  428,
      428,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  428,  428,  428,  428,  428,  428,
      437,  478,  478,  478,  478,  478,  478,  437,  437,  437,
      437,  437,  437,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  437,  437,  437,  437,

      437,  437,  438,  438,  438,  438,  438,  478,  478,  478,
      478,  478,  478,  478,  478,  424,  478,  478,  478,  478,
      478,  439,  478,  478,  478,  478,  478,  478,  439,  439,
      439,  439,  439,  439,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  426,  478,  478,  439,  439,  439,
      439,  439,  439,  445,  445,  445,  445,  445,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  446,  478,  478,  478,  478,  478,  478,  446,
      446,  446,  446,  446,  446,  478,  478,  478,  478,  478,

      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  446,  446,
      446,  446,  446,  446,  447,  478,  478,  478,  478,  478,
      478,  447,  447,  447,  447,  447,  447,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      447,  447,  447,  447,  447,  447,  452,  478,  478,  478,
      478,  478,  478,  452,  452,  452,  452,  452,  452,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,

      478,  478,  452,  452,  452,  452,  452,  452,  453,  478,
      478,  478,  478,  478,  478,  453,  453,  453,  453,  453,
      453,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  453,  453,  453,  453,  453,  453,
      458,  478,  478,  478,  478,  478,  478,  458,  458,  458,
      458,  458,  458,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  458,  458,  458,  458,
      458,  458,  459,  478,  478,  478,  478,  478,  478,  459,

      459,  459,  459,  459,  459,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  459,  459,
      459,  459,  459,  459,  464,  478,  478,  478,  478,  478,
      478,  464,  464,  464,  464,  464,  464,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      464,  464,  464,  464,  464,  464,  465,  478,  478,  478,
      478,  478,  478,  465,  465,  465,  465,  465,  465,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,

      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  465,  465,  465,  465,  465,  465,  469,  478,
      478,  478,  478,  478,  478,  469,  469,  469,  469,  469,
      469,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  469,  469,  469,  469,  469,  469,
       39,  478,  478,   39,   39,   39,   39,   39,   39,   39,
       39,   39,   39,   45,   45,  478,   45,   45,   48,  478,
      478,   48,   48,   48,   48,   48,   48,   48,   48,   48,
       48,   53,   53,  478,   53,   53,   81,  478,  478,   81,

       81,   90,  478,   90,   90,  478,   90,   90,   97,   97,
       97,   97,   97,   97,   97,   97,   97,   97,  108,  108,
      108,  108,  108,  108,  108,  108,  108,  108,  108,  108,
      108,  113,  113,  478,  113,  113,  116,  116,  116,  116,
      116,  116,  116,  116,  116,  116,  119,  119,  119,  119,
      119,  119,  119,  119,  119,  119,  119,  119,  119,  126,
      126,  126,  126,  126,  126,  126,  126,  126,  126,  126,
      126,  126,  126,  128,  128,  478,  128,  128,  146,  146,
      146,  146,  146,  146,  146,  146,  146,  146,  151,  151,
      478,  151,  151,  159,  159,  159,  159,  159,  159,  159,

      159,  159,  159,  161,  161,  161,  161,  161,  161,  161,
      161,  161,  161,  166,  166,  166,  179,  179,  179,  179,
      179,  179,  179,  179,  179,  179,   48,   48,  478,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   48,  119,
      119,  119,  119,  119,  119,  119,  119,  119,  119,  119,
      119,  119,  126,  126,  126,  126,  126,  126,  126,  126,
      126,  126,  126,  126,  126,  126,  185,  185,  185,  185,
      185,  185,  185,  185,  185,  185,  185,  185,  185,  185,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      199,  199,  199,  199,  199,  199,  199,  199,  199,  199,

      211,  211,  211,  211,   39,  478,  478,   39,   39,   39,
       39,   39,   39,   39,   39,   39,   39,  225,  225,  225,
      225,  225,  225,  225,  225,  225,  225,  225,  225,  225,
      225,  243,  243,  243,  243,  248,  248,  248,  248,  248,
      248,  478,  248,  248,  248,  248,  248,  248,   39,   39,
       39,   39,   39,   39,   39,   39,   39,   39,   39,   39,
       39,  185,  185,  185,  185,  185,  185,  185,  185,  185,
      185,  185,  185,  185,  185,  275,  275,  275,  275,  248,
      248,  248,  248,  248,  248,  478,  248,  248,  248,  248,
      248,  248,  281,  478,  478,  281,  281,  281,  281,  281,

      281,  281,  281,  281,  281,  284,  478,  478,  284,  284,
      284,  284,  284,  284,  284,  284,  284,  284,  287,  287,
      287,  287,  287,  287,  287,  287,  287,  287,  287,  287,
      287,   39,   39,   39,   39,   39,   39,   39,   39,   39,
       39,   39,   39,   39,  113,  113,  478,  113,  113,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   48,   48,
       48,   48,  312,  312,  312,  312,  321,  321,  321,  321,
      321,  321,  321,  321,  321,  321,  321,  321,  321,  284,
      478,  478,  284,  284,  284,  284,  284,  284,  284,  284,
      284,  284,  326,  326,  326,  326,  326,  326,  326,  326,

      326,  326,  326,  326,  326,  248,  248,  248,  248,  248,
      478,  478,  248,  248,  248,  248,  248,  248,  287,  287,
      287,  287,  287,  287,  287,  287,  287,  287,  287,  287,
      287,   39,   39,   39,   39,   39,   39,   39,   39,   39,
       39,   39,   39,   39,  113,  113,  478,  113,  113,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   48,   48,
       48,   48,  348,  348,  348,  348,  281,  281,  478,  281,
      281,  281,  281,  281,  281,  281,  281,  281,  281,  321,
      321,  321,  321,  321,  321,  321,  321,  321,  321,  321,
      321,  321,  284,  284,  478,  284,  284,  284,  284,  284,

      284,  284,  284,  284,  284,  326,  326,  326,  326,  326,
      326,  326,  326,  326,  326,  326,  326,  326,  248,  248,
      248,  248,  248,  478,  478,  248,  248,  248,  248,  248,
      248,  413,  413,  413,  413,  478,  478,  478,  478,  413,
      478,  478,  413,  413,  425,  425,  425,  425,  478,  478,
      478,  425,  425,  425,  478,  425,  425,  427,  427,  427,
      427,  427,  427,  427,  427,  427,  427,  436,  436,  436,
      436,  436,  436,  436,  436,  436,  436,    7,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,

      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478
    } ;

static yyconst flex_int16_t yy_chk[6664] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    3,    5,    4,    6,   15,
       12,    3,  477,    4,    9,    9,    9,    9,    9,   10,

       10,   10,   10,   10,    3,    3,    4,    4,   11,   11,
       11,   11,   11,   23,   39,    5,   17,    6,   35,   17,
        3,   24,    4,   32,   24,   24,   32,   32,   38,   48,
       15,   69,    3,    3,    4,    4,   12,   42,   25,   17,
       42,   25,   11,  474,   69,    3,   35,    4,   17,   24,
       53,   32,   17,   23,   31,   78,   38,   78,   35,   69,
       39,   24,  467,   32,   33,  461,   65,   17,   83,   25,
       48,   11,   13,   42,   35,   13,   17,   24,   25,   32,
       83,   31,   13,   13,   13,   13,   13,   13,   65,   54,
       53,   33,   54,   54,   31,   65,   83,   25,   36,   36,

       36,   36,   36,   70,   33,   68,   68,  456,   13,   31,
      166,   13,   13,   13,   13,   13,   13,   20,  166,   33,
      211,   90,   70,  440,   20,   20,  434,   20,  211,   54,
      124,  124,   70,   68,   20,   20,   20,   20,   20,   20,
       20,   20,   20,   20,   20,   20,   20,   20,   20,   20,
       20,   20,   20,   20,   20,   20,   20,   20,   20,   20,
       20,   90,   20,   20,   20,   20,   20,   20,   20,   20,
       20,   20,   20,   20,   20,   20,   20,   20,   20,   20,
       20,   20,   20,   20,   20,   20,   20,   20,   64,   52,
      106,   20,   22,   74,   55,  429,   37,   37,   37,   37,

       37,   57,   64,   57,   22,  243,  487,   22,  487,   52,
       22,  419,   55,  243,   22,   22,   64,   22,  106,   74,
       67,   66,   74,   57,   72,   72,  385,  127,   22,   67,
       37,  127,   66,   22,   55,   66,   22,   52,   71,   22,
       97,   55,   22,   22,   71,   22,   26,   73,   67,   66,
       82,   57,   71,   26,   26,   26,   26,   26,   26,   37,
       66,   72,  108,  109,   73,   80,   71,   76,   73,   82,
      107,   73,   71,   76,   86,  107,   73,   85,  140,   82,
       97,  384,   26,   26,   26,   26,   26,   26,   41,   41,
       41,   41,   73,  118,   41,   76,   73,   80,   84,   85,

       86,   80,   87,   86,  348,  175,   85,   41,  108,  109,
       96,  140,   84,   93,   41,   41,   41,   41,   41,   41,
       93,  107,   94,  119,  102,   80,   84,  104,   87,  342,
      250,   87,  103,  119,  118,   96,  317,  105,  161,  316,
       41,  102,  315,   41,   41,   41,   41,   41,   41,   44,
       96,  175,  104,   93,  314,   94,   44,   44,   44,   44,
       44,   44,   94,   96,  102,  103,  120,  104,  105,  125,
      102,  250,  103,  275,  119,  131,  120,  105,  161,  134,
      104,  275,   44,   94,  125,   44,   44,   44,   44,   44,
       44,   46,  144,  103,  150,  131,  105,  145,   46,   46,

       46,   46,   46,   46,  131,  134,  145,  165,  134,  125,
      137,  137,  148,  125,  156,  144,  150,  120,  192,  153,
      226,  144,  148,  150,  226,  145,  154,   46,   46,   46,
       46,   46,   46,   49,   49,   49,   49,  156,  137,  154,
      148,  157,  155,  156,   49,  153,  158,  165,  153,  174,
      190,  192,   49,  155,  154,  157,  168,  170,  164,   49,
       49,   49,   49,   49,   49,  164,  158,  171,  173,  157,
      155,  172,  182,  190,  235,  158,  184,  174,  216,  190,
      249,  499,  182,  499,  284,   49,  194,  217,   49,   49,
       49,   49,   49,   49,   56,  196,  168,  170,  164,  194,

      184,   56,   56,   56,   56,   56,   56,  171,  173,  172,
      235,  172,  201,  198,  194,  217,  184,  196,  216,  325,
      293,  201,  202,  182,  196,  284,  249,  203,  184,  202,
       56,   56,   56,   56,   56,   56,   77,  172,  198,  203,
      201,  204,  198,   77,   77,   77,   77,   77,   77,  293,
      202,  231,  232,  234,  390,  203,  281,  320,  390,  204,
      325,  234,  205,  492,  492,  231,  254,  509,  232,  509,
      204,  206,   77,   77,   77,   77,   77,   77,   88,  231,
      232,  234,  224,  236,  205,   88,   88,   88,   88,   88,
       88,  205,  236,  206,  254,  214,  214,  214,  214,  214,

      206,  214,  281,  320,  224,  265,  214,  313,  214,  237,
      306,  236,  332,  238,   88,   88,   88,   88,   88,   88,
       91,  238,  224,  265,  364,  307,  271,   91,   91,   91,
       91,   91,   91,  224,  265,  237,  306,  271,  237,  306,
      332,  238,  247,  247,  247,  247,  247,  214,  247,  267,
      296,  268,  364,  247,  271,  247,   91,   91,   91,   91,
       91,   91,   98,   98,   98,   98,   98,  279,  511,  337,
      511,  267,  268,  340,   98,  269,  303,  305,  267,  312,
      268,   98,  269,  303,  305,  278,  308,  312,   98,   98,
       98,   98,   98,   98,  247,  248,  248,  248,  248,  248,

      337,  248,  277,  269,  303,  305,  248,  276,  248,  340,
      463,  515,  308,  515,   98,  308,  270,   98,   98,   98,
       98,   98,   98,  110,  110,  110,  110,  110,  337,  110,
      280,  280,  280,  280,  280,  282,  282,  282,  282,  282,
      321,  343,  110,  280,  246,  321,  463,  248,  282,  110,
      110,  110,  110,  110,  110,  286,  286,  286,  286,  286,
      318,  318,  318,  318,  318,  343,  245,  366,  286,  517,
      343,  517,  370,  318,  394,  110,  344,  366,  110,  110,
      110,  110,  110,  110,  111,  111,  111,  111,  244,  394,
      111,  321,  239,  229,  370,  287,  287,  287,  287,  287,

      344,  370,  394,  111,  383,  344,  366,  286,  287,  228,
      111,  111,  111,  111,  111,  111,  288,  288,  288,  288,
      288,  289,  289,  289,  289,  289,  356,  225,  326,  288,
      383,  356,  213,  383,  289,  392,  111,  392,  326,  111,
      111,  111,  111,  111,  111,  114,  393,  287,  462,  212,
      462,  403,  114,  114,  114,  114,  114,  114,  322,  322,
      322,  322,  322,  392,  322,  357,  199,  193,  288,  393,
      357,  322,  403,  289,  191,  393,  462,  356,  114,  326,
      403,  114,  114,  114,  114,  114,  114,  115,  189,  327,
      327,  327,  327,  327,  115,  115,  115,  115,  115,  115,

      327,  187,  327,  331,  331,  331,  331,  331,  185,  179,
      322,  333,  333,  333,  333,  333,  357,  333,  167,  331,
      371,  163,  159,  115,  115,  115,  115,  115,  115,  117,
      117,  117,  117,  117,  346,  346,  346,  346,  346,  151,
      149,  327,  371,  336,  336,  336,  336,  336,  117,  371,
      346,  360,  361,  146,  336,  117,  117,  117,  117,  117,
      117,  360,  361,  333,  365,  365,  365,  365,  365,  416,
      345,  345,  345,  345,  345,  367,  367,  367,  367,  367,
      143,  142,  416,  377,  117,  117,  117,  117,  117,  117,
      121,  121,  121,  121,  121,  336,  524,  416,  524,  141,

      441,  121,  360,  361,  369,  369,  369,  369,  369,  121,
      377,  378,  379,  139,  441,  380,  121,  121,  121,  121,
      121,  121,  345,  355,  355,  355,  355,  355,  441,  355,
      527,  415,  527,  378,  379,  138,  355,  380,  377,  415,
      378,  379,  121,  395,  380,  121,  121,  121,  121,  121,
      121,  122,  122,  122,  122,  381,  369,  136,  395,  415,
      418,  381,  122,  359,  359,  359,  359,  359,  382,  391,
      122,  395,  391,  402,  359,  355,  359,  122,  122,  122,
      122,  122,  122,  381,  135,  401,  418,  133,  407,  418,
      382,  402,  132,  391,  407,  130,  405,  382,  391,  396,

      401,  391,  402,  122,  128,  396,  122,  122,  122,  122,
      122,  122,  129,  401,  396,  359,  407,  406,  405,  129,
      129,  129,  129,  129,  129,  405,  537,  396,  537,  544,
      545,  544,  545,  396,  399,  399,  399,  399,  399,  406,
      126,  404,  408,  116,  113,   95,  406,  399,  129,  129,
      129,  129,  129,  129,  147,  147,  147,  147,  147,  404,
      408,   92,   81,   79,  410,  410,  410,  410,  410,  417,
      404,  408,   75,  147,   63,  410,  420,   61,  417,  421,
      147,  147,  147,  147,  147,  147,  399,  400,  400,  400,
      400,  400,  409,  409,  409,  409,  409,  417,  409,   60,

      420,  421,   59,  400,   58,  420,  147,   51,  421,  147,
      147,  147,  147,  147,  147,  152,  410,  411,  411,  411,
      411,  411,  152,  152,  152,  152,  152,  152,  413,  413,
      413,  413,  413,  411,   45,   29,   28,  422,   27,  400,
       21,  413,  430,   19,  409,  435,  412,  412,  412,  412,
      412,  152,  152,  152,  152,  152,  152,  160,  160,  160,
      160,  160,  412,  422,  430,   18,  422,  432,  431,  411,
      435,  430,  433,   16,  435,  442,  160,  432,  468,  433,
      413,  442,  448,  160,  160,  160,  160,  160,  160,  423,
      423,  423,  423,  423,  431,  432,  443,  431,  412,   14,

      433,  468,  423,  442,  448,  449,    7,  468,  443,  160,
      444,  448,  160,  160,  160,  160,  160,  160,  162,  162,
      162,  162,  162,    0,  443,  444,    0,  449,  425,  425,
      425,  425,  425,  450,  449,    0,  454,  162,  444,    0,
      451,  425,  450,    0,  162,  162,  162,  162,  162,  162,
      427,  427,  427,  427,  427,  436,  436,  436,  436,  436,
        0,  450,  451,  427,  454,  466,    0,    0,  436,  451,
        0,  466,  454,  162,  162,  162,  162,  162,  162,  169,
      425,  438,  438,  438,  438,  438,  169,  169,  169,  169,
      169,  169,  454,  466,  438,    0,    0,    0,  457,    0,

      455,  460,  427,  476,    0,    0,  457,  436,  471,  455,
      460,  476,  472,    0,  473,  169,  169,  169,  169,  169,
      169,  176,  176,  176,  176,  176,  457,  176,  455,  460,
      471,  476,    0,  438,  472,    0,    0,  471,  473,    0,
      176,  472,    0,  473,    0,    0,    0,  176,  176,  176,
      176,  176,  176,  445,  445,  445,  445,  445,  465,  465,
      465,  465,  465,    0,    0,    0,  445,    0,    0,    0,
        0,  465,    0,  176,    0,    0,  176,  176,  176,  176,
      176,  176,  178,  469,  469,  469,  469,  469,  470,  178,
      178,  178,  178,  178,  178,    0,  469,    0,    0,    0,

        0,    0,  475,  470,    0,  445,    0,    0,    0,    0,
      465,    0,    0,    0,    0,    0,  470,  475,  178,  178,
      178,  178,  178,  178,  180,  180,  180,  180,  180,    0,
      475,    0,    0,    0,    0,  469,    0,    0,    0,    0,
        0,    0,    0,  180,    0,    0,    0,    0,    0,    0,
      180,  180,  180,  180,  180,  180,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  180,
      180,  180,  180,  180,  180,  181,  181,  181,  181,  181,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,  181,    0,    0,    0,    0,    0,
        0,  181,  181,  181,  181,  181,  181,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      181,  181,  181,  181,  181,  181,  183,  183,  183,  183,
      183,    0,    0,    0,    0,    0,    0,  183,    0,    0,
        0,    0,    0,    0,    0,  183,    0,    0,    0,    0,
        0,    0,  183,  183,  183,  183,  183,  183,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  183,    0,

        0,  183,  183,  183,  183,  183,  183,  188,  188,  188,
      188,  188,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  188,    0,    0,    0,
        0,    0,    0,  188,  188,  188,  188,  188,  188,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  188,  188,  188,  188,  188,  188,  195,    0,
        0,    0,    0,    0,    0,  195,  195,  195,  195,  195,
      195,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,  195,  195,  195,  195,  195,  195,
      200,  200,  200,  200,  200,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  200,
        0,    0,    0,    0,    0,    0,  200,  200,  200,  200,
      200,  200,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  200,  200,  200,  200,  200,
      200,  207,    0,    0,    0,    0,    0,    0,  207,  207,
      207,  207,  207,  207,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,  207,  207,  207,
      207,  207,  207,  208,  208,  208,  208,  208,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  208,    0,    0,    0,    0,    0,    0,  208,
      208,  208,  208,  208,  208,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  208,  208,
      208,  208,  208,  208,  215,    0,    0,    0,    0,    0,
        0,  215,  215,  215,  215,  215,  215,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      215,  215,  215,  215,  215,  215,  218,  218,  218,  218,
      218,    0,  218,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  218,    0,    0,    0,    0,
        0,    0,  218,  218,  218,  218,  218,  218,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  218,    0,
        0,  218,  218,  218,  218,  218,  218,  220,    0,    0,
        0,    0,    0,    0,  220,  220,  220,  220,  220,  220,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  220,  220,  220,  220,  220,  220,  221,
      221,  221,  221,  221,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  221,    0,
        0,    0,    0,    0,    0,  221,  221,  221,  221,  221,
      221,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  221,  221,  221,  221,  221,  221,
      222,  222,  222,  222,  222,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  222,

        0,    0,    0,    0,    0,    0,  222,  222,  222,  222,
      222,  222,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  222,  222,  222,  222,  222,
      222,  223,  223,  223,  223,  223,    0,    0,    0,    0,
        0,    0,  223,    0,    0,    0,    0,    0,    0,    0,
      223,    0,    0,    0,    0,    0,    0,  223,  223,  223,
      223,  223,  223,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  223,    0,    0,  223,  223,  223,  223,

      223,  223,  227,  227,  227,  227,  227,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  227,    0,    0,    0,    0,    0,    0,  227,  227,
      227,  227,  227,  227,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  227,  227,  227,
      227,  227,  227,  230,    0,    0,    0,    0,    0,    0,
      230,  230,  230,  230,  230,  230,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  230,

      230,  230,  230,  230,  230,  233,  233,  233,  233,  233,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  233,    0,    0,    0,    0,    0,
        0,  233,  233,  233,  233,  233,  233,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      233,  233,  233,  233,  233,  233,  240,    0,    0,    0,
        0,    0,    0,  240,  240,  240,  240,  240,  240,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,  240,  240,  240,  240,  240,  240,  241,  241,
      241,  241,  241,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  241,    0,    0,
        0,    0,    0,    0,  241,  241,  241,  241,  241,  241,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  241,  241,  241,  241,  241,  241,  252,
      252,  252,  252,  252,    0,  252,    0,    0,    0,    0,
      252,  252,  252,    0,    0,    0,    0,    0,  252,    0,
        0,    0,    0,    0,    0,  252,  252,  252,  252,  252,

      252,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  252,    0,    0,  252,  252,  252,  252,  252,  252,
      253,    0,    0,    0,    0,    0,    0,  253,  253,  253,
      253,  253,  253,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  253,  253,  253,  253,
      253,  253,  255,  255,  255,  255,  255,    0,  255,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  255,    0,    0,    0,    0,    0,    0,  255,  255,

      255,  255,  255,  255,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  255,    0,    0,  255,  255,  255,
      255,  255,  255,  257,    0,    0,    0,    0,    0,    0,
      257,  257,  257,  257,  257,  257,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  257,    0,    0,  257,
      257,  257,  257,  257,  257,  258,  258,  258,  258,  258,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  258,    0,    0,    0,    0,    0,

        0,  258,  258,  258,  258,  258,  258,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  258,    0,    0,
      258,  258,  258,  258,  258,  258,  259,  259,  259,  259,
      259,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  259,    0,    0,    0,    0,
        0,    0,  259,  259,  259,  259,  259,  259,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  259,  259,  259,  259,  259,  259,  260,  260,  260,

      260,  260,    0,    0,    0,    0,    0,    0,  260,    0,
        0,    0,    0,    0,    0,    0,  260,    0,    0,    0,
        0,    0,    0,  260,  260,  260,  260,  260,  260,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  260,
        0,    0,  260,  260,  260,  260,  260,  260,  261,  261,
      261,  261,  261,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  261,    0,    0,
        0,    0,    0,    0,  261,  261,  261,  261,  261,  261,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,  261,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  261,  261,  261,  261,  261,  261,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  261,  262,  262,  262,  262,  262,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  262,    0,    0,    0,    0,    0,    0,  262,  262,
      262,  262,  262,  262,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  262,  262,  262,
      262,  262,  262,  263,    0,    0,    0,    0,    0,    0,

      263,  263,  263,  263,  263,  263,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  263,
      263,  263,  263,  263,  263,  264,  264,  264,  264,  264,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  264,    0,    0,    0,    0,    0,
        0,  264,  264,  264,  264,  264,  264,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      264,  264,  264,  264,  264,  264,  266,  266,  266,  266,

      266,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  266,    0,    0,    0,    0,
        0,    0,  266,  266,  266,  266,  266,  266,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  266,  266,  266,  266,  266,  266,  272,    0,    0,
        0,    0,    0,    0,  272,  272,  272,  272,  272,  272,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  272,  272,  272,  272,  272,  272,  273,

      273,  273,  273,  273,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  273,    0,
        0,    0,    0,    0,    0,  273,  273,  273,  273,  273,
      273,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  273,  273,  273,  273,  273,  273,
      283,  283,  283,  283,    0,    0,  283,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  283,
        0,    0,    0,    0,    0,    0,  283,  283,  283,  283,
      283,  283,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  283,    0,    0,  283,  283,  283,  283,  283,
      283,  285,  285,  285,  285,    0,    0,    0,    0,    0,
        0,    0,  285,    0,    0,    0,    0,    0,    0,    0,
      285,    0,    0,    0,    0,    0,    0,  285,  285,  285,
      285,  285,  285,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  285,    0,    0,  285,  285,  285,  285,
      285,  285,  290,  290,  290,  290,  290,    0,    0,    0,
        0,    0,    0,    0,    0,  290,    0,    0,    0,    0,

        0,  290,    0,    0,    0,    0,    0,    0,  290,  290,
      290,  290,  290,  290,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  290,    0,    0,  290,  290,  290,
      290,  290,  290,  291,  291,  291,  291,  291,    0,  291,
        0,    0,    0,    0,  291,  291,  291,    0,    0,    0,
        0,    0,  291,    0,    0,    0,    0,    0,    0,  291,
      291,  291,  291,  291,  291,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  291,    0,    0,  291,  291,

      291,  291,  291,  291,  292,    0,    0,    0,    0,    0,
        0,  292,  292,  292,  292,  292,  292,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      292,  292,  292,  292,  292,  292,  294,  294,  294,  294,
      294,    0,  294,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  294,    0,    0,    0,    0,
        0,    0,  294,  294,  294,  294,  294,  294,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  294,    0,

        0,  294,  294,  294,  294,  294,  294,  297,  297,  297,
      297,  297,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  297,    0,    0,    0,
        0,    0,    0,  297,  297,  297,  297,  297,  297,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  297,
        0,    0,  297,  297,  297,  297,  297,  297,  298,  298,
      298,  298,  298,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  298,    0,    0,
        0,    0,    0,    0,  298,  298,  298,  298,  298,  298,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  298,  298,  298,  298,  298,  298,  299,
      299,  299,  299,  299,    0,    0,    0,    0,    0,    0,
      299,    0,    0,    0,    0,    0,    0,    0,  299,    0,
        0,    0,    0,    0,    0,  299,  299,  299,  299,  299,
      299,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  299,    0,    0,  299,  299,  299,  299,  299,  299,
      300,  300,  300,  300,  300,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,  300,    0,    0,  300,
        0,    0,    0,    0,    0,    0,  300,  300,  300,  300,
      300,  300,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  300,  300,  300,  300,  300,
      300,  301,  301,  301,  301,  301,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      301,    0,    0,    0,    0,    0,    0,  301,  301,  301,
      301,  301,  301,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,  301,  301,  301,  301,
      301,  301,  302,  302,  302,  302,  302,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  302,    0,    0,    0,    0,    0,    0,  302,  302,
      302,  302,  302,  302,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  302,  302,  302,
      302,  302,  302,  304,  304,  304,  304,  304,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  304,    0,    0,    0,    0,    0,    0,  304,

      304,  304,  304,  304,  304,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  304,  304,
      304,  304,  304,  304,  309,    0,    0,    0,    0,    0,
        0,  309,  309,  309,  309,  309,  309,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      309,  309,  309,  309,  309,  309,  310,  310,  310,  310,
      310,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  310,    0,    0,    0,    0,

        0,    0,  310,  310,  310,  310,  310,  310,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  310,  310,  310,  310,  310,  310,  323,  323,  323,
      323,  323,    0,  323,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  323,    0,    0,    0,
        0,    0,    0,  323,  323,  323,  323,  323,  323,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  323,
        0,    0,  323,  323,  323,  323,  323,  323,  324,  324,

      324,  324,    0,    0,  324,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  324,    0,    0,
        0,    0,    0,    0,  324,  324,  324,  324,  324,  324,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      324,    0,    0,  324,  324,  324,  324,  324,  324,  328,
      328,  328,  328,  328,    0,    0,    0,    0,    0,    0,
      328,    0,    0,    0,    0,    0,    0,    0,  328,    0,
        0,    0,    0,    0,    0,  328,  328,  328,  328,  328,
      328,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  328,    0,    0,  328,  328,  328,  328,  328,  328,
      329,  329,  329,  329,    0,    0,    0,    0,    0,    0,
        0,  329,    0,    0,    0,    0,    0,    0,    0,  329,
        0,    0,    0,    0,    0,    0,  329,  329,  329,  329,
      329,  329,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  329,    0,    0,  329,  329,  329,  329,  329,
      329,  330,  330,  330,  330,  330,    0,    0,    0,    0,
        0,    0,    0,    0,  330,    0,    0,    0,    0,    0,

      330,    0,    0,    0,    0,    0,    0,  330,  330,  330,
      330,  330,  330,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  330,    0,    0,  330,  330,  330,  330,
      330,  330,  334,    0,    0,    0,    0,    0,    0,  334,
      334,  334,  334,  334,  334,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  334,  334,
      334,  334,  334,  334,  335,    0,    0,    0,    0,    0,
        0,  335,  335,  335,  335,  335,  335,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      335,  335,  335,  335,  335,  335,  338,    0,    0,    0,
        0,    0,    0,  338,  338,  338,  338,  338,  338,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  338,  338,  338,  338,  338,  338,  339,  339,
      339,  339,  339,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  339,    0,    0,
        0,    0,    0,    0,  339,  339,  339,  339,  339,  339,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  339,  339,  339,  339,  339,  339,  341,
      341,  341,  341,  341,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  341,    0,
        0,    0,    0,    0,    0,  341,  341,  341,  341,  341,
      341,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  341,  341,  341,  341,  341,  341,
      358,    0,    0,    0,    0,    0,    0,  358,  358,  358,

      358,  358,  358,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  358,  358,  358,  358,
      358,  358,  362,    0,    0,    0,    0,    0,    0,  362,
      362,  362,  362,  362,  362,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  362,  362,
      362,  362,  362,  362,  363,  363,  363,  363,  363,    0,
        0,    0,    0,    0,    0,    0,    0,  363,    0,    0,
        0,    0,    0,  363,    0,    0,    0,    0,    0,    0,

      363,  363,  363,  363,  363,  363,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  363,    0,    0,  363,
      363,  363,  363,  363,  363,  368,    0,    0,    0,    0,
        0,    0,  368,    0,  368,    0,    0,    0,    0,  368,
      368,    0,    0,  368,    0,    0,    0,    0,  368,    0,
        0,    0,    0,    0,  368,    0,    0,    0,    0,    0,
      368,    0,  368,    0,    0,    0,    0,  368,  368,    0,
        0,  368,  373,    0,    0,    0,    0,    0,    0,  373,
      373,  373,  373,  373,  373,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  373,  373,
      373,  373,  373,  373,  374,    0,    0,    0,    0,    0,
        0,  374,  374,  374,  374,  374,  374,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      374,  374,  374,  374,  374,  374,  375,    0,    0,    0,
        0,    0,    0,  375,  375,  375,  375,  375,  375,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,  375,  375,  375,  375,  375,  375,  387,    0,
        0,    0,    0,    0,    0,  387,  387,  387,  387,  387,
      387,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  387,  387,  387,  387,  387,  387,
      388,    0,    0,    0,    0,    0,    0,  388,  388,  388,
      388,  388,  388,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  388,  388,  388,  388,
      388,  388,  389,    0,    0,    0,    0,    0,    0,  389,

      389,  389,  389,  389,  389,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  389,  389,
      389,  389,  389,  389,  397,    0,    0,    0,    0,    0,
        0,  397,  397,  397,  397,  397,  397,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      397,  397,  397,  397,  397,  397,  398,    0,    0,    0,
        0,    0,    0,  398,  398,  398,  398,  398,  398,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  398,  398,  398,  398,  398,  398,  414,    0,
        0,    0,    0,    0,    0,  414,  414,  414,  414,  414,
      414,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  414,  414,  414,  414,  414,  414,
      426,    0,    0,    0,    0,    0,    0,  426,  426,  426,
      426,  426,  426,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  426,  426,  426,  426,

      426,  426,  428,  428,  428,  428,  428,    0,    0,    0,
        0,    0,    0,    0,    0,  428,    0,    0,    0,    0,
        0,  428,    0,    0,    0,    0,    0,    0,  428,  428,
      428,  428,  428,  428,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  428,    0,    0,  428,  428,  428,
      428,  428,  428,  437,  437,  437,  437,  437,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  437,    0,    0,    0,    0,    0,    0,  437,
      437,  437,  437,  437,  437,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  437,  437,
      437,  437,  437,  437,  439,    0,    0,    0,    0,    0,
        0,  439,  439,  439,  439,  439,  439,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      439,  439,  439,  439,  439,  439,  446,    0,    0,    0,
        0,    0,    0,  446,  446,  446,  446,  446,  446,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,  446,  446,  446,  446,  446,  446,  447,    0,
        0,    0,    0,    0,    0,  447,  447,  447,  447,  447,
      447,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  447,  447,  447,  447,  447,  447,
      452,    0,    0,    0,    0,    0,    0,  452,  452,  452,
      452,  452,  452,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  452,  452,  452,  452,
      452,  452,  453,    0,    0,    0,    0,    0,    0,  453,

      453,  453,  453,  453,  453,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  453,  453,
      453,  453,  453,  453,  458,    0,    0,    0,    0,    0,
        0,  458,  458,  458,  458,  458,  458,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      458,  458,  458,  458,  458,  458,  459,    0,    0,    0,
        0,    0,    0,  459,  459,  459,  459,  459,  459,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  459,  459,  459,  459,  459,  459,  464,    0,
        0,    0,    0,    0,    0,  464,  464,  464,  464,  464,
      464,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  464,  464,  464,  464,  464,  464,
      479,    0,    0,  479,  479,  479,  479,  479,  479,  479,
      479,  479,  479,  480,  480,    0,  480,  480,  481,    0,
        0,  481,  481,  481,  481,  481,  481,  481,  481,  481,
      481,  482,  482,    0,  482,  482,  483,    0,    0,  483,

      483,  484,    0,  484,  484,    0,  484,  484,  485,  485,
      485,  485,  485,  485,  485,  485,  485,  485,  486,  486,
      486,  486,  486,  486,  486,  486,  486,  486,  486,  486,
      486,  488,  488,    0,  488,  488,  489,  489,  489,  489,
      489,  489,  489,  489,  489,  489,  490,  490,  490,  490,
      490,  490,  490,  490,  490,  490,  490,  490,  490,  491,
      491,  491,  491,  491,  491,  491,  491,  491,  491,  491,
      491,  491,  491,  493,  493,    0,  493,  493,  494,  494,
      494,  494,  494,  494,  494,  494,  494,  494,  495,  495,
        0,  495,  495,  496,  496,  496,  496,  496,  496,  496,

      496,  496,  496,  497,  497,  497,  497,  497,  497,  497,
      497,  497,  497,  498,  498,  498,  500,  500,  500,  500,
      500,  500,  500,  500,  500,  500,  501,  501,    0,  501,
      501,  501,  501,  501,  501,  501,  501,  501,  501,  502,
      502,  502,  502,  502,  502,  502,  502,  502,  502,  502,
      502,  502,  503,  503,  503,  503,  503,  503,  503,  503,
      503,  503,  503,  503,  503,  503,  504,  504,  504,  504,
      504,  504,  504,  504,  504,  504,  504,  504,  504,  504,
      505,  505,  505,  505,  505,  505,  505,  505,  505,  505,
      506,  506,  506,  506,  506,  506,  506,  506,  506,  506,

      507,  507,  507,  507,  508,    0,    0,  508,  508,  508,
      508,  508,  508,  508,  508,  508,  508,  510,  510,  510,
      510,  510,  510,  510,  510,  510,  510,  510,  510,  510,
      510,  512,  512,  512,  512,  513,  513,  513,  513,  513,
      513,    0,  513,  513,  513,  513,  513,  513,  514,  514,
      514,  514,  514,  514,  514,  514,  514,  514,  514,  514,
      514,  516,  516,  516,  516,  516,  516,  516,  516,  516,
      516,  516,  516,  516,  516,  518,  518,  518,  518,  519,
      519,  519,  519,  519,  519,    0,  519,  519,  519,  519,
      519,  519,  520,    0,    0,  520,  520,  520,  520,  520,

      520,  520,  520,  520,  520,  521,    0,    0,  521,  521,
      521,  521,  521,  521,  521,  521,  521,  521,  522,  522,
      522,  522,  522,  522,  522,  522,  522,  522,  522,  522,
      522,  523,  523,  523,  523,  523,  523,  523,  523,  523,
      523,  523,  523,  523,  525,  525,    0,  525,  525,  526,
      526,  526,  526,  526,  526,  526,  526,  526,  526,  526,
      526,  526,  528,  528,  528,  528,  529,  529,  529,  529,
      529,  529,  529,  529,  529,  529,  529,  529,  529,  530,
        0,    0,  530,  530,  530,  530,  530,  530,  530,  530,
      530,  530,  531,  531,  531,  531,  531,  531,  531,  531,

      531,  531,  531,  531,  531,  532,  532,  532,  532,  532,
        0,    0,  532,  532,  532,  532,  532,  532,  533,  533,
      533,  533,  533,  533,  533,  533,  533,  533,  533,  533,
      533,  534,  534,  534,  534,  534,  534,  534,  534,  534,
      534,  534,  534,  534,  535,  535,    0,  535,  535,  536,
      536,  536,  536,  536,  536,  536,  536,  536,  536,  536,
      536,  536,  538,  538,  538,  538,  539,  539,    0,  539,
      539,  539,  539,  539,  539,  539,  539,  539,  539,  540,
      540,  540,  540,  540,  540,  540,  540,  540,  540,  540,
      540,  540,  541,  541,    0,  541,  541,  541,  541,  541,

      541,  541,  541,  541,  541,  542,  542,  542,  542,  542,
      542,  542,  542,  542,  542,  542,  542,  542,  543,  543,
      543,  543,  543,    0,    0,  543,  543,  543,  543,  543,
      543,  546,  546,  546,  546,    0,    0,    0,    0,  546,
        0,    0,  546,  546,  547,  547,  547,  547,    0,    0,
        0,  547,  547,  547,    0,  547,  547,  548,  548,  548,
      548,  548,  548,  548,  548,  548,  548,  549,  549,  549,
      549,  549,  549,  549,  549,  549,  549,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,

      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478
    } ;

#line 1 "<stdin>"
YY_DECL
{
	register yy_state_type yy_current_state;
	register UChar *yy_cp, *yy_bp;
	register int yy_act;
	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 479 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 6578 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 31 "<stdin>"
/* ignore comments */
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 33 "<stdin>"
{yyTok = WHITESPACE; return yyTok;}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 35 "<stdin>"
{yyTok = SGML_CD; return yyTok;}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 36 "<stdin>"
{yyTok = SGML_CD; return yyTok;}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 37 "<stdin>"
{yyTok = INCLUDES; return yyTok;}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 38 "<stdin>"
{yyTok = DASHMATCH; return yyTok;}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 39 "<stdin>"
{yyTok = BEGINSWITH; return yyTok;}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 40 "<stdin>"
{yyTok = ENDSWITH; return yyTok;}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 41 "<stdin>"
{yyTok = CONTAINS; return yyTok;}
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 42 "<stdin>"
{yyTok = MEDIA_NOT; return yyTok;}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 43 "<stdin>"
{yyTok = MEDIA_ONLY; return yyTok;}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 44 "<stdin>"
{yyTok = MEDIA_AND; return yyTok;}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 45 "<stdin>"
{BEGIN(mediaquery); yyTok = VARIABLES_FOR; return yyTok; }
	YY_BREAK
case 14:
/* rule 14 can match eol */
YY_RULE_SETUP
#line 47 "<stdin>"
{yyTok = STRING; return yyTok;}
	YY_BREAK
case 15:
/* rule 15 can match eol */
YY_RULE_SETUP
#line 48 "<stdin>"
{yyTok = IDENT; return yyTok;}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 49 "<stdin>"
{yyTok = NTH; return yyTok;}
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 51 "<stdin>"
{yyTok = HEX; return yyTok;}
	YY_BREAK
case 18:
/* rule 18 can match eol */
YY_RULE_SETUP
#line 52 "<stdin>"
{yyTok = IDSEL; return yyTok;}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 54 "<stdin>"
{BEGIN(mediaquery); yyTok = IMPORT_SYM; return yyTok;}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 55 "<stdin>"
{yyTok = PAGE_SYM; return yyTok;}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 56 "<stdin>"
{BEGIN(mediaquery); yyTok = MEDIA_SYM; return yyTok;}
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 57 "<stdin>"
{yyTok = FONT_FACE_SYM; return yyTok;}
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 58 "<stdin>"
{yyTok = CHARSET_SYM; return yyTok;}
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 59 "<stdin>"
{yyTok = NAMESPACE_SYM; return yyTok; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 60 "<stdin>"
{yyTok = WEBKIT_RULE_SYM; return yyTok; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 61 "<stdin>"
{yyTok = WEBKIT_DECLS_SYM; return yyTok; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 62 "<stdin>"
{yyTok = WEBKIT_VALUE_SYM; return yyTok; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 63 "<stdin>"
{BEGIN(mediaquery); yyTok = WEBKIT_MEDIAQUERY_SYM; return yyTok; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 64 "<stdin>"
{yyTok = WEBKIT_SELECTOR_SYM; return yyTok; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 65 "<stdin>"
{BEGIN(mediaquery); yyTok = WEBKIT_VARIABLES_SYM; return yyTok; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 66 "<stdin>"
{BEGIN(forkeyword); yyTok = WEBKIT_DEFINE_SYM; return yyTok; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 67 "<stdin>"
{ yyTok = WEBKIT_VARIABLES_DECLS_SYM; return yyTok; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 68 "<stdin>"
{yyTok = WEBKIT_KEYFRAMES_SYM; return yyTok; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 69 "<stdin>"
{yyTok = WEBKIT_KEYFRAME_RULE_SYM; return yyTok; }
	YY_BREAK
case 35:
/* rule 35 can match eol */
YY_RULE_SETUP
#line 71 "<stdin>"
{yyTok = ATKEYWORD; return yyTok; }
	YY_BREAK
case 36:
/* rule 36 can match eol */
YY_RULE_SETUP
#line 73 "<stdin>"
{yyTok = IMPORTANT_SYM; return yyTok;}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 75 "<stdin>"
{yyTok = EMS; return yyTok;}
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 76 "<stdin>"
{yyTok = QEMS; return yyTok;} /* quirky ems */
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 77 "<stdin>"
{yyTok = EXS; return yyTok;}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 78 "<stdin>"
{yyTok = PXS; return yyTok;}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 79 "<stdin>"
{yyTok = CMS; return yyTok;}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 80 "<stdin>"
{yyTok = MMS; return yyTok;}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 81 "<stdin>"
{yyTok = INS; return yyTok;}
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 82 "<stdin>"
{yyTok = PTS; return yyTok;}
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 83 "<stdin>"
{yyTok = PCS; return yyTok;}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 84 "<stdin>"
{yyTok = DEGS; return yyTok;}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 85 "<stdin>"
{yyTok = RADS; return yyTok;}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 86 "<stdin>"
{yyTok = GRADS; return yyTok;}
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 87 "<stdin>"
{yyTok = TURNS; return yyTok;}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 88 "<stdin>"
{yyTok = MSECS; return yyTok;}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 89 "<stdin>"
{yyTok = SECS; return yyTok;}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 90 "<stdin>"
{yyTok = HERZ; return yyTok;}
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 91 "<stdin>"
{yyTok = KHERZ; return yyTok;}
	YY_BREAK
case 54:
/* rule 54 can match eol */
YY_RULE_SETUP
#line 92 "<stdin>"
{yyTok = DIMEN; return yyTok;}
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 93 "<stdin>"
{yyTok = PERCENTAGE; return yyTok;}
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 94 "<stdin>"
{yyTok = INTEGER; return yyTok;}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 95 "<stdin>"
{yyTok = FLOATTOKEN; return yyTok;}
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 97 "<stdin>"
{yyTok = NOTFUNCTION; return yyTok;}
	YY_BREAK
case 59:
/* rule 59 can match eol */
YY_RULE_SETUP
#line 98 "<stdin>"
{yyTok = URI; return yyTok;}
	YY_BREAK
case 60:
/* rule 60 can match eol */
YY_RULE_SETUP
#line 99 "<stdin>"
{yyTok = URI; return yyTok;}
	YY_BREAK
case 61:
/* rule 61 can match eol */
YY_RULE_SETUP
#line 100 "<stdin>"
{ yyTok = VARCALL; return yyTok; }
	YY_BREAK
case 62:
/* rule 62 can match eol */
YY_RULE_SETUP
#line 101 "<stdin>"
{yyTok = FUNCTION; return yyTok;}
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 103 "<stdin>"
{yyTok = UNICODERANGE; return yyTok;}
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 104 "<stdin>"
{yyTok = UNICODERANGE; return yyTok;}
	YY_BREAK
case 65:
#line 107 "<stdin>"
case 66:
YY_RULE_SETUP
#line 107 "<stdin>"
{BEGIN(INITIAL); yyTok = *yytext; return yyTok; }
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 108 "<stdin>"
{yyTok = *yytext; return yyTok;}
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 110 "<stdin>"
ECHO;
	YY_BREAK
#line 2738 "<stdout>"
case YY_STATE_EOF(INITIAL):
case YY_END_OF_BUFFER:
case YY_STATE_EOF(mediaquery):
case YY_STATE_EOF(forkeyword):
	yyterminate();

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of yylex */
