/*
 * libjingle
 * Copyright 2004 Google Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the documentation
 *     and/or other materials provided with the distribution.
 *  3. The name of the author may not be used to endorse or promote products
 *     derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef TALK_MEDIA_BASE_VIDEOPROCESSOR_H_
#define TALK_MEDIA_BASE_VIDEOPROCESSOR_H_

#include "talk/media/base/videoframe.h"
#include "webrtc/base/sigslot.h"

namespace cricket {

class VideoProcessor : public sigslot::has_slots<> {
 public:
  virtual ~VideoProcessor() {}
  // Contents of frame may be manipulated by the processor.
  // The processed data is expected to be the same size as the
  // original data. VideoProcessors may be chained together and may decide
  // that the current frame should be dropped. If *drop_frame is true,
  // the current processor should skip processing. If the current processor
  // decides it cannot process the current frame in a timely manner, it may set
  // *drop_frame = true and the frame will be dropped.
  virtual void OnFrame(uint32 ssrc, VideoFrame* frame, bool* drop_frame) = 0;
};

}  // namespace cricket
#endif  // TALK_MEDIA_BASE_VIDEOPROCESSOR_H_
