/*
	client.h

	Client definitions

	Copyright (C) 1996-1997  Id Software, Inc.

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to:

		Free Software Foundation, Inc.
		59 Temple Place - Suite 330
		Boston, MA  02111-1307, USA

	$Id: cl_main.h,v 1.10 2003/01/03 04:30:38 snax Exp $
*/

#ifndef _CL_MAIN_H
#define _CL_MAIN_H

#include "client.h"
#include "QF/qtypes.h"
#include "QF/render.h"

void CL_Init (void);
void Host_WriteConfiguration (void);

void CL_EstablishConnection (const char *host);

void CL_Disconnect (void);
void CL_Disconnect_f (void);
void CL_NextDemo (void);
qboolean CL_DemoBehind(void);

void CL_BeginServerConnect(void);

extern char emodel_name[], pmodel_name[], prespawn_name[], modellist_name[], soundlist_name[];

extern struct cvar_s *cl_timeframes;
extern struct cvar_s *cl_predict_players;
extern struct cvar_s *cl_solid_players;
extern struct cvar_s *cl_autoexec;
extern struct cvar_s *cl_cshift_bonus;
extern struct cvar_s *cl_cshift_contents;
extern struct cvar_s *cl_cshift_damage;
extern struct cvar_s *cl_cshift_powerup;

extern struct gib_event_s *cl_player_health_e, *cl_chat_e;

#endif // _CL_MAIN_H
