#!/bin/sh
#
# last updated 2003.08.02
#
# usage quickblock.sh x.x.x.x [nat]
# nat is optional
#
# x.x.x.x can be a single IP address like 53.128.9.240 or a network
# address like 53.128.9.0/24
#
# NOTE:  these drops will not be reapplied the next time your
# quicktables script is ran
# 

### must be root ###
if [ `whoami` != "root" ]; then
	echo ""
	echo "$0 must be ran as root"
	echo ""
	exit 1
fi


### set path ###
export PATH=/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin


### set output file for sourcing by quicktables ###
out=/etc/qblock


### ip validation regex ###
is_ip="grep -Ec '^[1-2]?[0-9]?[0-9]\.[0-2]?[0-9]?[0-9]\.[0-2]?[0-9]?[0-9]\.[0-2]?[0-9]?[0-9](\/[0-3]?[0-9])?$'"


### what to block ###
echo ""
echo "example: '207.46.249.27' to block single host 207.46.249.27"
echo "example: '207.46.0.0/16' to block network 207.46.0.0/16"
echo ""
echo -n "what IP or network address would you like to block : "
read blocked

while [ -z $blocked ]; do
	echo ""
	echo "i didn't understand your last answer"
	echo ""
	echo -n "what IP or network address would you like to block : "
	read blocked
done

while [ `echo $blocked |eval $is_ip` != "1" ]; do
	echo ""
	echo "$blocked doesn't seem to be a valid IP address"
	echo ""
	echo -n "what IP or network address would you like to block : "
	read blocked
done


### one time or all time block ###
echo ""
echo "if you answer yes to the next question, quicktables will block this IP or network address the next time you run your quicktables firewall.  if you answer no this IP or network address will no longer be blocked"
echo ""
echo -n "would you like your quicktables firewall to block this IP or network address permanently (yes/no) : "
read perm_block

while [ -z $perm_block ]; do
	echo ""
	echo "i didn't understand your last answer"
	echo ""
	echo -n "would you like your quicktables firewall to block this IP or network address permanently (yes/no) : "
	read perm_block
done

while [ x$perm_block != "xyes" ] && [ x$perm_block != "xno" ]; do
	echo ""
	echo "i didn't understand your last answer"
	echo ""
	echo -n "would you like your quicktables firewall to block this IP or network address permanently (yes/no) : "
	read perm_block
done


### write to out file ###
if [ $perm_block = "yes" ]; then
	if [ ! -f $out ]; then
		touch $out
		chmod 700 $out
	fi
	echo "$blocked" >> $out
fi


### nat ###
echo ""
echo -n "do you use quicktables for NAT (yes/no) : "
read nat

while [ -z $nat ]; do
	echo ""
	echo "i didn't understand your last answer"
	echo ""
	echo -n "do you use quicktables for NAT (yes/no) : "
	read nat
done

while [ x$nat != "xyes" ] && [ x$nat != "xno" ]; do
	echo ""
	echo "i didn't understand your last answer"
	echo ""
	echo -n "do you use quicktables for NAT (yes/no) : "
	read nat
done


### do it ###
iptables -I INPUT -s $blocked -j DROP

if [ $nat = "yes" ]; then
	iptables -I FORWARD -s $blocked -j DROP
fi

echo "now dropping all packets from $blocked"

echo ""
