/* 
 *  testdct.c
 *
 *     Copyright (C) Charles 'Buck' Krasic - April 2000
 *     Copyright (C) Erik Walthinsen - April 2000
 *
 *  This file is part of libdv, a free DV (IEC 61834/SMPTE 314M)
 *  codec.
 *
 *  libdv is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your
 *  option) any later version.
 *   
 *  libdv is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 *  The libdv homepage is http://libdv.sourceforge.net/.  
 */

#include <dv_types.h>

#include <stdio.h>
#include <math.h>

#include "dct.h"

static double x88[64] = {
  -1.26625000004818,  -2.27483830381940,  -1.11913598848804,   0.00231571511382,
   0.19875000000756,   0.00338638153636,  -0.00051435135496,  -0.00033449538004,
   0.19110058081125,   0.20451452728524,  -0.11202906120804,  -0.20189123810253,
  -0.00225660764574,   0.00856950101587,   0.00227547076567,  -0.00722456308331,
   0.00067649512526,  -0.00957380701402,   0.01295495129088,  -0.00452013440891,
  -0.01271742500911,  -0.00167221782116,  -0.00195621394722,   0.00280554839562,
   0.05758041945440,   0.00945018306559,  -0.03415859898093,  -0.02063254849679,
   0.00323716202410,   0.01142682371674,   0.00048230363576,  -0.00179946111698,
   0.04625000000176,  -0.01246970301554,   0.02067122127015,  -0.00548199981454,
  -0.01375000000052,   0.00447656893807,   0.00090863155270,   0.00081517808886,
   0.07644876238822,   0.02219791002631,  -0.05046296372776,  -0.03791453635593,
   0.00190506633420,   0.01633429825921,  -0.00073666569325,  -0.00673253710743,
  -0.00163320370628,  -0.03682899175479,   0.03554378605993,   0.00251750406161,
  -0.03396898734785,  -0.00061910481814,  -0.00295495128897,   0.00875485232190,
   0.20718807891285,   0.12343407682795,  -0.12335908623861,  -0.18738678085651,
  -0.00787713312303,   0.03771031298174,   0.00050163819006,  -0.00021627703883 
};

static double x248[64] = {
  -1.26625000004818,  -2.27483830381940,  -1.11913598848804,   0.00231571511382,     0.19875000000756,   0.00338638153636,  -0.00051435135496,  -0.00033449538004,
   0.14700824772316,   0.17650404421132,  -0.08581029036438,  -0.16145460717335,    -0.00067649512526,   0.00104792335571,   0.00213388347704,  -0.00704355157317,
   0.00125000000005,   0.00524880062647,  -0.00163320370628,  -0.00513946675949,     0.00125000000005,  -0.00130800666197,  -0.00067649512526,  -0.00075834819617,
   0.00540371228727,  -0.00447495801009,  -0.00036611652353,   0.00390885071494,     0.00163320370603,   0.00042620679342,   0.00081029034771,   0.00224419997264,
   0.25875000000985,   0.15778101925484,  -0.15529033446770,  -0.22263582089763,    -0.00625000000024,   0.04334174934676,   0.00073282086779,  -0.00402293205459,
   0.01654425933321,  -0.03959231146621,   0.04282931996745,  -0.00154715522401,    -0.03875253025314,   0.00059345146944,  -0.00286611652415,   0.00877660018034,
  -0.00375000000014,  -0.03969462756662,  -0.00163320370628,   0.04568931770836,     0.00625000000024,   0.00361920167595,  -0.00067649512526,  -0.00547486704211,
   0.04320778266740,   0.00290256308948,   0.00463388347666,  -0.00529282116402,     0.00116893085116,   0.00459958765505,   0.00217068004096,  -0.00275304442048,
};

int main(int argc, char **argv)
{
  int row,col;
  double temp[64];

  dct_init();
  memcpy(temp,x88,sizeof(x88));
  for(row=0;row<8;row++) {
    for(col=0;col<8;col++) {
      printf("%8.3f ",100*temp[row*8+col]);
    }
    printf("\n");
  }
  printf("\n");
  idct_88(temp);
  for(row=0;row<8;row++) {
    for(col=0;col<8;col++) {
      printf("%8.3f ",100*temp[row*8+col]);
    }
    printf("\n");
  }
  printf("\n");
  memcpy(temp,x248,sizeof(x248));
  for(row=0;row<8;row++) {
    for(col=0;col<8;col++) {
      printf("%8.3f ",100*temp[row*8+col]);
    }
    printf("\n");
  }
  printf("\n");
  idct_248(temp);
  for(row=0;row<8;row++) {
    for(col=0;col<8;col++) {
      printf("%8.3f ",100*temp[row*8+col]);
    }
    printf("\n");
  }
    
  exit(0);
} // main
