/*
Copyright (c) 2012, Broadcom Europe Ltd
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the copyright holder nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*=============================================================================
Copyright (c) 2011 Broadcom Europe Limited.
All rights reserved.
=============================================================================*/
/** \file
 * Multi-Media Abstraction Layer - Definition of some standard parameters.
 */

#ifndef MMAL_PARAMETERS_CAMERA_H
#define MMAL_PARAMETERS_CAMERA_H

#include "mmal_parameters_common.h"

/** Camera-specific MMAL parameter IDs.
 * @ingroup MMAL_PARAMETER_IDS
 */
enum {
   MMAL_PARAMETER_THUMBNAIL_CONFIGURATION    /**< Takes a @ref MMAL_PARAMETER_THUMBNAIL_CONFIG_T */
         = MMAL_PARAMETER_GROUP_CAMERA,
   MMAL_PARAMETER_CAPTURE_QUALITY,           /**< Unused? */
   MMAL_PARAMETER_ROTATION,                  /**< Takes a @ref MMAL_PARAMETER_INT32_T */
   MMAL_PARAMETER_EXIF,                      /**< Takes a @ref MMAL_PARAMETER_EXIF_T */
   MMAL_PARAMETER_AWB_MODE,                  /**< Takes a @ref MMAL_PARAM_AWBMODE_T */
   MMAL_PARAMETER_IMAGE_EFFECT,              /**< Takes a @ref MMAL_PARAMETER_IMAGEFX_T */
   MMAL_PARAMETER_COLOUR_EFFECT,             /**< Takes a @ref MMAL_PARAMETER_COLOURFX_T */
   MMAL_PARAMETER_FLICKER_AVOID,             /**< Takes a @ref MMAL_PARAMETER_FLICKERAVOID_T */
   MMAL_PARAMETER_FLASH,                     /**< Takes a @ref MMAL_PARAMETER_FLASH_T */
   MMAL_PARAMETER_REDEYE,                    /**< Takes a @ref MMAL_PARAMETER_REDEYE_T */
   MMAL_PARAMETER_FOCUS,                     /**< Takes a @ref MMAL_PARAMETER_FOCUS_T */
   MMAL_PARAMETER_FOCAL_LENGTHS,             /**< Unused? */
   MMAL_PARAMETER_EXPOSURE_COMP,             /**< Takes a @ref MMAL_PARAMETER_INT32_T */
   MMAL_PARAMETER_ZOOM,                      /**< Takes a @ref MMAL_PARAMETER_SCALEFACTOR_T */
   MMAL_PARAMETER_MIRROR,                    /**< Takes a @ref MMAL_PARAMETER_MIRROR_T */
   MMAL_PARAMETER_CAMERA_NUM,                /**< Takes a @ref MMAL_PARAMETER_UINT32_T */
   MMAL_PARAMETER_CAPTURE,                   /**< Takes a @ref MMAL_PARAMETER_BOOLEAN_T */
   MMAL_PARAMETER_EXPOSURE_MODE,             /**< Takes a @ref MMAL_PARAMETER_EXPOSUREMODE_T */
   MMAL_PARAMETER_EXP_METERING_MODE,         /**< Takes a @ref MMAL_PARAMETER_EXPOSUREMETERINGMODE_T */
   MMAL_PARAMETER_FOCUS_STATUS,              /**< Takes a @ref MMAL_PARAMETER_FOCUS_STATUS_T */
   MMAL_PARAMETER_CAMERA_CONFIG,             /**< Takes a @ref MMAL_PARAMETER_CAMERA_CONFIG_T */
   MMAL_PARAMETER_CAPTURE_STATUS,            /**< Takes a @ref MMAL_PARAMETER_BOOLEAN_T */
   MMAL_PARAMETER_FACE_TRACK,                /**< Takes a @ref MMAL_PARAMETER_FACE_TRACK_T */
   MMAL_PARAMETER_DRAW_BOX_FACES_AND_FOCUS,  /**< Takes a @ref MMAL_PARAMETER_BOOLEAN_T */
   MMAL_PARAMETER_JPEG_Q_FACTOR,             /**< Takes a @ref MMAL_PARAMETER_UINT32_T */
   MMAL_PARAMETER_FRAME_RATE,                /**< Takes a @ref MMAL_PARAMETER_FRAME_RATE_T */
   MMAL_PARAMETER_USE_STC,                   /**< Takes a @ref MMAL_PARAMETER_CAMERA_STC_MODE_T */
   MMAL_PARAMETER_CAMERA_INFO,               /**< Takes a @ref MMAL_PARAMETER_CAMERA_INFO_T */
   MMAL_PARAMETER_VIDEO_STABILISATION,       /**< Takes a @ref MMAL_PARAMETER_BOOLEAN_T */
   MMAL_PARAMETER_FACE_TRACK_RESULTS,        /**< Takes a @ref MMAL_PARAMETER_FACE_TRACK_RESULTS_T */
   MMAL_PARAMETER_ENABLE_RAW_CAPTURE,        /**< Takes a @ref MMAL_PARAMETER_BOOLEAN_T */
   MMAL_PARAMETER_DPF_FILE,                  /**< Takes a @ref MMAL_PARAMETER_URI_T */
   MMAL_PARAMETER_ENABLE_DPF_FILE,           /**< Takes a @ref MMAL_PARAMETER_BOOLEAN_T */
   MMAL_PARAMETER_DPF_FAIL_IS_FATAL,         /**< Takes a @ref MMAL_PARAMETER_BOOLEAN_T */
   MMAL_PARAMETER_CAPTURE_MODE,              /**< Takes a @ref MMAL_PARAMETER_CAPTUREMODE_T */
   MMAL_PARAMETER_FOCUS_REGIONS,             /**< Takes a @ref MMAL_PARAMETER_FOCUS_REGIONS_T */
   MMAL_PARAMETER_INPUT_CROP,                /**< Takes a @ref MMAL_PARAMETER_INPUT_CROP_T */
   MMAL_PARAMETER_SENSOR_INFORMATION,        /**< Takes a @ref MMAL_PARAMETER_SENSOR_INFORMATION_T */
   MMAL_PARAMETER_FLASH_SELECT,              /**< Takes a @ref MMAL_PARAMETER_FLASH_SELECT_T */
};

/** Thumbnail configuration parameter type */
typedef struct MMAL_PARAMETER_THUMBNAIL_CONFIG_T
{
   MMAL_PARAMETER_HEADER_T hdr;

   uint32_t enable;                  /**< Enable generation of thumbnails during still capture */
   uint32_t width;                   /**< Desired width of the thumbnail */
   uint32_t height;                  /**< Desired height of the thumbnail */
   uint32_t quality;                 /**< Desired compression quality of the thumbnail */
} MMAL_PARAMETER_THUMBNAIL_CONFIG_T;

/** EXIF parameter type. */
typedef struct MMAL_PARAMETER_EXIF_T
{
   MMAL_PARAMETER_HEADER_T hdr;

   uint32_t keylen;                            /**< If 0, assume key is terminated by '=', otherwise length of key and treat data as binary */
   uint32_t value_offset;                      /**< Offset within data buffer of the start of the value. If 0, look for a "key=value" string */
   uint32_t valuelen;                          /**< If 0, assume value is null-terminated, otherwise length of value and treat data as binary */
   uint8_t data[1];                            /**< EXIF key/value string. Variable length */
} MMAL_PARAMETER_EXIF_T;

/** Exposure modes. */
typedef enum
{
   MMAL_PARAM_EXPOSUREMODE_OFF,
   MMAL_PARAM_EXPOSUREMODE_AUTO,
   MMAL_PARAM_EXPOSUREMODE_NIGHT,
   MMAL_PARAM_EXPOSUREMODE_NIGHTPREVIEW,
   MMAL_PARAM_EXPOSUREMODE_BACKLIGHT,
   MMAL_PARAM_EXPOSUREMODE_SPOTLIGHT,
   MMAL_PARAM_EXPOSUREMODE_SPORTS,
   MMAL_PARAM_EXPOSUREMODE_SNOW,
   MMAL_PARAM_EXPOSUREMODE_BEACH,
   MMAL_PARAM_EXPOSUREMODE_VERYLONG,
   MMAL_PARAM_EXPOSUREMODE_FIXEDFPS,
   MMAL_PARAM_EXPOSUREMODE_MAX = 0x7fffffff
} MMAL_PARAM_EXPOSUREMODE_T;

typedef struct MMAL_PARAMETER_EXPOSUREMODE_T
{
   MMAL_PARAMETER_HEADER_T hdr;

   MMAL_PARAM_EXPOSUREMODE_T value;   /**< exposure mode */
} MMAL_PARAMETER_EXPOSUREMODE_T;

typedef enum
{
   MMAL_PARAM_EXPOSUREMETERINGMODE_AVERAGE,
   MMAL_PARAM_EXPOSUREMETERINGMODE_SPOT,
   MMAL_PARAM_EXPOSUREMETERINGMODE_BACKLIT,
   MMAL_PARAM_EXPOSUREMETERINGMODE_MAX = 0x7fffffff
} MMAL_PARAM_EXPOSUREMETERINGMODE_T;

typedef struct MMAL_PARAMETER_EXPOSUREMETERINGMODE_T
{
   MMAL_PARAMETER_HEADER_T hdr;

   MMAL_PARAM_EXPOSUREMETERINGMODE_T value;   /**< metering mode */
} MMAL_PARAMETER_EXPOSUREMETERINGMODE_T;

/** AWB parameter modes. */
typedef enum MMAL_PARAM_AWBMODE_T
{
   MMAL_PARAM_AWBMODE_OFF,
   MMAL_PARAM_AWBMODE_AUTO,
   MMAL_PARAM_AWBMODE_SUNLIGHT,
   MMAL_PARAM_AWBMODE_CLOUDY,
   MMAL_PARAM_AWBMODE_SHADE,
   MMAL_PARAM_AWBMODE_TUNGSTEN,
   MMAL_PARAM_AWBMODE_FLUORESCENT,
   MMAL_PARAM_AWBMODE_INCANDESCENT,
   MMAL_PARAM_AWBMODE_FLASH,
   MMAL_PARAM_AWBMODE_HORIZON,
   MMAL_PARAM_AWBMODE_MAX = 0x7fffffff
} MMAL_PARAM_AWBMODE_T;

/** AWB parameter type. */
typedef struct MMAL_PARAMETER_AWBMODE_T
{
   MMAL_PARAMETER_HEADER_T hdr;

   MMAL_PARAM_AWBMODE_T value;   /**< AWB mode */
} MMAL_PARAMETER_AWBMODE_T;

/** Image effect */
typedef enum MMAL_PARAM_IMAGEFX_T
{
   MMAL_PARAM_IMAGEFX_NONE,
   MMAL_PARAM_IMAGEFX_NEGATIVE,
   MMAL_PARAM_IMAGEFX_SOLARIZE,
   MMAL_PARAM_IMAGEFX_POSTERIZE,
   MMAL_PARAM_IMAGEFX_WHITEBOARD,
   MMAL_PARAM_IMAGEFX_BLACKBOARD,
   MMAL_PARAM_IMAGEFX_MAX = 0x7fffffff
} MMAL_PARAM_IMAGEFX_T;

typedef struct MMAL_PARAMETER_IMAGEFX_T
{
   MMAL_PARAMETER_HEADER_T hdr;

   MMAL_PARAM_IMAGEFX_T value;   /**< Image effect mode */
} MMAL_PARAMETER_IMAGEFX_T;

/** Colour effect parameter type*/
typedef struct MMAL_PARAMETER_COLOURFX_T
{
   MMAL_PARAMETER_HEADER_T hdr;

   int32_t enable;
   uint32_t u;
   uint32_t v;
} MMAL_PARAMETER_COLOURFX_T;

typedef enum MMAL_CAMERA_STC_MODE_T
{
   MMAL_PARAM_STC_MODE_OFF,         /**< Frames do not have STCs, as needed in OpenMAX/IL */
   MMAL_PARAM_STC_MODE_RAW,         /**< Use raw clock STC, needed for true pause/resume support */
   MMAL_PARAM_STC_MODE_COOKED,      /**< Start the STC from the start of capture, only for quick demo code */
   MMAL_PARAM_STC_MODE_MAX = 0x7fffffff
} MMAL_CAMERA_STC_MODE_T;

typedef struct MMAL_PARAMETER_CAMERA_STC_MODE_T
{
   MMAL_PARAMETER_HEADER_T hdr;
   MMAL_CAMERA_STC_MODE_T value;
} MMAL_PARAMETER_CAMERA_STC_MODE_T;

typedef enum MMAL_PARAM_FLICKERAVOID_T
{
   MMAL_PARAM_FLICKERAVOID_OFF,
   MMAL_PARAM_FLICKERAVOID_AUTO,
   MMAL_PARAM_FLICKERAVOID_50HZ,
   MMAL_PARAM_FLICKERAVOID_60HZ,
   MMAL_PARAM_FLICKERAVOID_MAX = 0x7FFFFFFF
} MMAL_PARAM_FLICKERAVOID_T;

typedef struct MMAL_PARAMETER_FLICKERAVOID_T
{
   MMAL_PARAMETER_HEADER_T hdr;

   MMAL_PARAM_FLICKERAVOID_T value;   /**< Flicker avoidance mode */
} MMAL_PARAMETER_FLICKERAVOID_T;

typedef enum MMAL_PARAM_FLASH_T
{
   MMAL_PARAM_FLASH_OFF,
   MMAL_PARAM_FLASH_AUTO,
   MMAL_PARAM_FLASH_ON,
   MMAL_PARAM_FLASH_REDEYE,
   MMAL_PARAM_FLASH_FILLIN,
   MMAL_PARAM_FLASH_TORCH,
   MMAL_PARAM_FLASH_MAX = 0x7FFFFFFF
} MMAL_PARAM_FLASH_T;

typedef struct MMAL_PARAMETER_FLASH_T
{
   MMAL_PARAMETER_HEADER_T hdr;

   MMAL_PARAM_FLASH_T value;   /**< Flash mode */
} MMAL_PARAMETER_FLASH_T;

typedef enum MMAL_PARAM_REDEYE_T
{
   MMAL_PARAM_REDEYE_OFF,
   MMAL_PARAM_REDEYE_ON,
   MMAL_PARAM_REDEYE_SIMPLE,
   MMAL_PARAM_REDEYE_MAX = 0x7FFFFFFF
} MMAL_PARAM_REDEYE_T;

typedef struct MMAL_PARAMETER_REDEYE_T
{
   MMAL_PARAMETER_HEADER_T hdr;

   MMAL_PARAM_REDEYE_T value;   /**< Red eye reduction mode */
} MMAL_PARAMETER_REDEYE_T;

typedef enum MMAL_PARAM_FOCUS_T
{
   MMAL_PARAM_FOCUS_AUTO,
   MMAL_PARAM_FOCUS_AUTO_NEAR,
   MMAL_PARAM_FOCUS_AUTO_MACRO,
   MMAL_PARAM_FOCUS_CAF,
   MMAL_PARAM_FOCUS_CAF_NEAR,
   MMAL_PARAM_FOCUS_FIXED_INFINITY,
   MMAL_PARAM_FOCUS_FIXED_HYPERFOCAL,
   MMAL_PARAM_FOCUS_FIXED_NEAR,
   MMAL_PARAM_FOCUS_FIXED_MACRO,
   MMAL_PARAM_FOCUS_EDOF,
   MMAL_PARAM_FOCUS_MAX = 0x7FFFFFFF
} MMAL_PARAM_FOCUS_T;

typedef struct MMAL_PARAMETER_FOCUS_T
{
   MMAL_PARAMETER_HEADER_T hdr;

   MMAL_PARAM_FOCUS_T value;   /**< Focus mode */
} MMAL_PARAMETER_FOCUS_T;

typedef enum MMAL_PARAM_FOCUS_STATUS_T
{
   MMAL_PARAM_FOCUS_STATUS_OFF,
   MMAL_PARAM_FOCUS_STATUS_REQUEST,
   MMAL_PARAM_FOCUS_STATUS_REACHED,
   MMAL_PARAM_FOCUS_STATUS_UNABLE_TO_REACH,
   MMAL_PARAM_FOCUS_STATUS_LOST,

   MMAL_PARAM_FOCUS_STATUS_MAX = 0x7FFFFFFF
} MMAL_PARAM_FOCUS_STATUS_T;

typedef struct MMAL_PARAMETER_FOCUS_STATUS_T
{
   MMAL_PARAMETER_HEADER_T hdr;

   MMAL_PARAM_FOCUS_STATUS_T status;   /**< Focus status */
} MMAL_PARAMETER_FOCUS_STATUS_T;

typedef enum MMAL_PARAM_FACE_TRACK_MODE_T
{
   MMAL_PARAM_FACE_DETECT_NONE,                           /**< Disables face detection */
   MMAL_PARAM_FACE_DETECT_ON,                             /**< Enables face detection */
   MMAL_PARAM_FACE_DETECT_MAX = 0x7FFFFFFF
} MMAL_PARAM_FACE_TRACK_MODE_T;

typedef struct MMAL_PARAMETER_FACE_TRACK_T /* face tracking control */
{
   MMAL_PARAMETER_HEADER_T hdr;
   MMAL_PARAM_FACE_TRACK_MODE_T mode;
   uint32_t maxRegions;
   uint32_t frames;
   uint32_t quality;
} MMAL_PARAMETER_FACE_TRACK_T;

typedef struct MMAL_PARAMETER_FACE_TRACK_FACE_T /* face tracking face information */
{
   int32_t     face_id;             /**< Face ID. Should remain the same whilst the face is detected to remain in the scene */
   int32_t     score;               /**< Confidence of the face detection. Range 1-100 (1=unsure, 100=positive). */
   MMAL_RECT_T face_rect;           /**< Rectangle around the whole face */

   MMAL_RECT_T eye_rect[2];         /**< Rectangle around the eyes ([0] = left eye, [1] = right eye) */
   MMAL_RECT_T mouth_rect;          /**< Rectangle around the mouth */
} MMAL_PARAMETER_FACE_TRACK_FACE_T;

typedef struct MMAL_PARAMETER_FACE_TRACK_RESULTS_T /* face tracking results */
{
   MMAL_PARAMETER_HEADER_T hdr;

   uint32_t num_faces;        /**< Number of faces detected */
   uint32_t frame_width;      /**< Width of the frame on which the faces were detected (allows scaling) */
   uint32_t frame_height;     /**< Height of the frame on which the faces were detected (allows scaling) */

   MMAL_PARAMETER_FACE_TRACK_FACE_T faces[1];   /**< Face information (variable length array */
} MMAL_PARAMETER_FACE_TRACK_RESULTS_T;

typedef enum MMAL_PARAMETER_CAMERA_CONFIG_TIMESTAMP_MODE_T
{
   MMAL_PARAM_TIMESTAMP_MODE_ZERO,           /**< Always timestamp frames as 0 */
   MMAL_PARAM_TIMESTAMP_MODE_RAW_STC,        /**< Use the raw STC value for the frame timestamp */
   MMAL_PARAM_TIMESTAMP_MODE_RESET_STC,      /**< Use the STC timestamp but subtract the timestamp
                                              * of the first frame sent to give a zero based timestamp.
                                              */
   MMAL_PARAM_TIMESTAMP_MODE_MAX = 0x7FFFFFFF
} MMAL_PARAMETER_CAMERA_CONFIG_TIMESTAMP_MODE_T;

typedef struct MMAL_PARAMETER_CAMERA_CONFIG_T
{
   MMAL_PARAMETER_HEADER_T hdr;

   /* Parameters for setting up the image pools */
   uint32_t max_stills_w;        /**< Max size of stills capture */
   uint32_t max_stills_h;
   uint32_t stills_yuv422;       /**< Allow YUV422 stills capture */
   uint32_t one_shot_stills;     /**< Continuous or one shot stills captures. */

   uint32_t max_preview_video_w; /**< Max size of the preview or video capture frames */
   uint32_t max_preview_video_h;
   uint32_t num_preview_video_frames;

   uint32_t stills_capture_circular_buffer_height; /**< Sets the height of the circular buffer for stills capture. */

   uint32_t fast_preview_resume;    /**< Allows preview/encode to resume as fast as possible after the stills input frame
                                     * has been received, and then processes the still frame in the background
                                     * whilst preview/encode has resumed.
                                     * Actual mode is controlled by MMAL_PARAMETER_CAPTURE_MODE.
                                     */

   MMAL_PARAMETER_CAMERA_CONFIG_TIMESTAMP_MODE_T use_stc_timestamp;
                                    /**< Selects algorithm for timestamping frames if there is no clock component connected.
                                      */


} MMAL_PARAMETER_CAMERA_CONFIG_T;

#define MMAL_PARAMETER_CAMERA_INFO_MAX_CAMERAS 4
#define MMAL_PARAMETER_CAMERA_INFO_MAX_FLASHES 2

typedef struct MMAL_PARAMETER_CAMERA_INFO_CAMERA_T
{
   uint32_t    port_id;
   uint32_t    max_width;
   uint32_t    max_height;
   MMAL_BOOL_T lens_present;
} MMAL_PARAMETER_CAMERA_INFO_CAMERA_T;

typedef enum MMAL_PARAMETER_CAMERA_INFO_FLASH_TYPE_T
{
   MMAL_PARAMETER_CAMERA_INFO_FLASH_TYPE_XENON = 0, /* Make values explicit */
   MMAL_PARAMETER_CAMERA_INFO_FLASH_TYPE_LED   = 1, /* to ensure they match */
   MMAL_PARAMETER_CAMERA_INFO_FLASH_TYPE_OTHER = 2, /* values in config ini */
   MMAL_PARAMETER_CAMERA_INFO_FLASH_TYPE_MAX = 0x7FFFFFFF
} MMAL_PARAMETER_CAMERA_INFO_FLASH_TYPE_T;

typedef struct MMAL_PARAMETER_CAMERA_INFO_FLASH_T
{
   MMAL_PARAMETER_CAMERA_INFO_FLASH_TYPE_T flash_type;
} MMAL_PARAMETER_CAMERA_INFO_FLASH_T;

typedef struct MMAL_PARAMETER_CAMERA_INFO_T
{
   MMAL_PARAMETER_HEADER_T             hdr;
   uint32_t                            num_cameras;
   uint32_t                            num_flashes;
   MMAL_PARAMETER_CAMERA_INFO_CAMERA_T cameras[MMAL_PARAMETER_CAMERA_INFO_MAX_CAMERAS];
   MMAL_PARAMETER_CAMERA_INFO_FLASH_T  flashes[MMAL_PARAMETER_CAMERA_INFO_MAX_FLASHES];
} MMAL_PARAMETER_CAMERA_INFO_T;

typedef enum MMAL_PARAMETER_CAPTUREMODE_MODE_T
{
   MMAL_PARAM_CAPTUREMODE_WAIT_FOR_END,            /**< Resumes preview once capture is completed. */
   MMAL_PARAM_CAPTUREMODE_WAIT_FOR_END_AND_HOLD,   /**< Resumes preview once capture is completed, and hold the image for subsequent reprocessing. */
   MMAL_PARAM_CAPTUREMODE_RESUME_VF_IMMEDIATELY,   /**< Resumes preview as soon as possible once capture frame is received from the sensor.
                                                    *   Requires fast_preview_resume to be set via MMAL_PARAMETER_CAMERA_CONFIG.
                                                    */
} MMAL_PARAMETER_CAPTUREMODE_MODE_T;

/** Stills capture mode control. */
typedef struct MMAL_PARAMETER_CAPTUREMODE_T
{
   MMAL_PARAMETER_HEADER_T hdr;
   MMAL_PARAMETER_CAPTUREMODE_MODE_T mode;
} MMAL_PARAMETER_CAPTUREMODE_T;

typedef enum MMAL_PARAMETER_FOCUS_REGION_TYPE_T
{
   MMAL_PARAMETER_FOCUS_REGION_TYPE_NORMAL,     /**< Region defines a generic region */
   MMAL_PARAMETER_FOCUS_REGION_TYPE_FACE,       /**< Region defines a face */
   MMAL_PARAMETER_FOCUS_REGION_TYPE_MAX
} MMAL_PARAMETER_FOCUS_REGION_TYPE_T;

typedef struct MMAL_PARAMETER_FOCUS_REGION_T
{
   MMAL_RECT_T rect;    /**< Focus rectangle as 0P16 fixed point values. */
   uint32_t weight;     /**< Region weighting. */
   uint32_t mask;       /**< Mask for multi-stage regions */
   MMAL_PARAMETER_FOCUS_REGION_TYPE_T type;  /**< Region type */
} MMAL_PARAMETER_FOCUS_REGION_T;

typedef struct MMAL_PARAMETER_FOCUS_REGIONS_T
{
   MMAL_PARAMETER_HEADER_T          hdr;
   uint32_t                         num_regions;      /**< Number of regions defined */
   MMAL_BOOL_T                      lock_to_faces;    /**< If region is within tolerance of a face, adopt face rect instead of defined region */
   MMAL_PARAMETER_FOCUS_REGION_T    regions[1];       /**< Variable number of regions */
} MMAL_PARAMETER_FOCUS_REGIONS_T;

typedef struct MMAL_PARAMETER_INPUT_CROP_T
{
   MMAL_PARAMETER_HEADER_T hdr;
   MMAL_RECT_T             rect;    /**< Crop rectangle as 16P16 fixed point values */
} MMAL_PARAMETER_INPUT_CROP_T;

typedef struct MMAL_PARAMETER_SENSOR_INFORMATION_T
{
   MMAL_PARAMETER_HEADER_T          hdr;
   MMAL_RATIONAL_T                  f_number;         /**< Lens f-number */
   MMAL_RATIONAL_T                  focal_length;     /**< Lens focal length */
   uint32_t                         model_id;         /**< Sensor reported model id */
   uint32_t                         manufacturer_id;  /**< Sensor reported manufacturer id */
   uint32_t                         revision;         /**< Sensor reported revision */
} MMAL_PARAMETER_SENSOR_INFORMATION_T;

typedef struct MMAL_PARAMETER_FLASH_SELECT_T
{
   MMAL_PARAMETER_HEADER_T          hdr;
   MMAL_PARAMETER_CAMERA_INFO_FLASH_TYPE_T flash_type;   /**< Flash type to use */
} MMAL_PARAMETER_FLASH_SELECT_T;

#endif  /* MMAL_PARAMETERS_CAMERA_H */
