/* Generated by re2c */
#line 1 "parse_date.g.re"
/*
   +----------------------------------------------------------------------+
   | PHP Version 5                                                        |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997-2006 The PHP Group                                |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Derick Rethans <derick@derickrethans.nl>                    |
   +----------------------------------------------------------------------+
 */



#include "timelib.h"

#include <stdio.h>
#include <ctype.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define TIMELIB_SECOND  1
#define TIMELIB_MINUTE  2
#define TIMELIB_HOUR    3
#define TIMELIB_DAY     4
#define TIMELIB_MONTH   5
#define TIMELIB_YEAR    6
#define TIMELIB_WEEKDAY 7

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; s->time->relative.weekday_behavior = 0; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_weekday_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { return TIMELIB_ERROR; } else { s->time.have_zone = 1; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x) { \
	if ((x) == -1) {         \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

#include "timelib_structs.h"

typedef struct timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	int           errors;

	struct timelib_time *time;
	timelib_tzdb        *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
    const char *name;
    int         type;
    int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

#define HOUR(a) (int)(a * 60)

/* The timezone table. */
static timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

static timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

static timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		*ptr += 3;
	} else {
		++*ptr;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = -1;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	free(str);
	return tmp_nr;
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!strncasecmp(*ptr, "nd", 2) || !strncasecmp(*ptr, "rd", 2) ||!strncasecmp(*ptr, "st", 2) || !strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static double timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = -1;
	int len = 0;

	while ((**ptr != '.') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtod(str, NULL);
	free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
	} else if (**ptr == '-') {
		dir = -1;
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static long timelib_parse_tz_cor(char **ptr)
{
	char *begin = *ptr, *end;
	long  tmp;

	while (**ptr != '\0') {
		++*ptr;
	}
	end = *ptr;
	switch (end - begin) {
		case 1:
		case 2:
			return HOUR(strtol(begin, NULL, 10));
			break;
		case 3:
		case 4:
			if (begin[1] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 2, NULL, 10);
				return tmp;
			} else if (begin[2] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
				return tmp;
			} else {
				tmp = strtol(begin, NULL, 10);
				return HOUR(tmp / 100) + tmp % 100;
			}
		case 5:
			tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
			return tmp;
	}
	return 0;
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	free(word);
	return value;
}

static long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ') {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	relunit = timelib_lookup_relunit(ptr);
	switch (relunit->unit) {
		case TIMELIB_SECOND: s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE: s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:   s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:    s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:  s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:   s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;
	}
}

static timelib_tz_lookup_table* zone_search(const char *word, long gmtoffset, int isdst)
{
	int first_found = 0;
	timelib_tz_lookup_table  *tp, *first_found_elem;
	timelib_tz_lookup_table  *fmp;

	if (strcasecmp("utc", word) == 0 || strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}
	
	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if ((fmp->gmtoffset * 3600) == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static long timelib_lookup_zone(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = zone_search(word, -1, 0))) {
		value = -tp->gmtoffset / 60;
		*dst = tp->type;
		value += tp->type * 60;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

static long timelib_get_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, timelib_tzdb *tzdb)
{
	timelib_tzinfo *res;
	long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '(') {
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		long offset;
		char *tz_abbr;

		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_ABBR;

		offset = timelib_lookup_zone(ptr, dst, &tz_abbr, &found);
#if 0
		/* If we found a TimeZone identifier, use it */
		if (tz_name) {
			t->tz_info = timelib_parse_tzfile(tz_name);
			t->zone_type = TIMELIB_ZONETYPE_ID;
		}
#endif
		/* If we have a TimeZone identifier to start with, use it */
		if (strstr(tz_abbr, "/")) {
			if ((res = timelib_parse_tzfile(tz_abbr, tzdb)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		if (t->zone_type != TIMELIB_ZONETYPE_ID) {
			timelib_time_tz_abbr_update(t, tz_abbr);
		}
		free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		free(arg.v[i]);            \
	}                              \
	if (arg.v) {                   \
		free(arg.v);               \
	}                              \
}

static int scan(Scanner *s)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;
		
std:
	s->tok = cursor;
	s->len = 0;
#line 845 "parse_date.g.re"


{
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		208,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64, 192,  64, 192,   0, 
		  8,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,  32,  32,  32, 160,  32,  32,  32, 
		160,  32,  32,  32,  32,  32, 160,  32, 
		 32,  32, 160, 160, 160,  32,  32,  32, 
		 32,  32,  32,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};

#line 778 "<stdout>"
	{
		YYCTYPE yych;
		unsigned int yyaccept = 0;

		if((YYLIMIT - YYCURSOR) < 26) YYFILL(26);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy48,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,
				&&yy50,   &&yy50,   &&yy48,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,
				&&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,
				&&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,
				&&yy45,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,
				&&yy42,   &&yy50,   &&yy50,   &&yy41,   &&yy47,   &&yy41,   &&yy47,   &&yy50,
				&&yy13,   &&yy14,   &&yy15,   &&yy16,   &&yy17,   &&yy17,   &&yy17,   &&yy17,
				&&yy17,   &&yy17,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,
				&&yy11,   &&yy25,   &&yy43,   &&yy43,   &&yy31,   &&yy35,   &&yy23,   &&yy43,
				&&yy43,   &&yy18,   &&yy21,   &&yy43,   &&yy37,   &&yy7,    &&yy5,    &&yy29,
				&&yy39,   &&yy43,   &&yy43,   &&yy27,   &&yy9,    &&yy43,   &&yy19,   &&yy33,
				&&yy20,   &&yy2,    &&yy43,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,
				&&yy50,   &&yy26,   &&yy44,   &&yy44,   &&yy32,   &&yy36,   &&yy24,   &&yy44,
				&&yy44,   &&yy44,   &&yy22,   &&yy44,   &&yy38,   &&yy8,    &&yy6,    &&yy30,
				&&yy40,   &&yy44,   &&yy44,   &&yy28,   &&yy10,   &&yy44,   &&yy44,   &&yy34,
				&&yy44,   &&yy4,    &&yy44,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,
				&&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,
				&&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,
				&&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,
				&&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,
				&&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,
				&&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,
				&&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,
				&&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,
				&&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,
				&&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,
				&&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,
				&&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,
				&&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,
				&&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,
				&&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,
				&&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50,   &&yy50
			};
			goto *yytarget[yych];
		}
yy2:
		++YYCURSOR;
		if((yych = *YYCURSOR) <= 'E') {
			if(yych <= ')') {
				if(yych >= ')') goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy133;
				goto yy1302;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy133;
				if(yych >= 'a') goto yy136;
			} else {
				if(yych <= 'e') goto yy1311;
				if(yych <= 'z') goto yy136;
			}
		}
yy3:
#line 1340 "parse_date.g.re"
		{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		s->errors += tz_not_found;
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
#line 852 "<stdout>"
yy4:
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy133;
				goto yy1302;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy133;
				if(yych <= '`') goto yy3;
				goto yy133;
			} else {
				if(yych <= 'e') goto yy1302;
				if(yych <= 'z') goto yy133;
				goto yy3;
			}
		}
yy5:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy132,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy1273, &&yy133,  &&yy133,
				&&yy133,  &&yy1274, &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy1272,
				&&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,
				&&yy133,  &&yy133,  &&yy133,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy1289, &&yy136,  &&yy136,
				&&yy136,  &&yy1290, &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy1288,
				&&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,
				&&yy136,  &&yy136,  &&yy136,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy6:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy132,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy1273, &&yy133,  &&yy133,
				&&yy133,  &&yy1274, &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy1272,
				&&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,
				&&yy133,  &&yy133,  &&yy133,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy1273, &&yy133,  &&yy133,
				&&yy133,  &&yy1274, &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy1272,
				&&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,
				&&yy133,  &&yy133,  &&yy133,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy7:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy132,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy1244, &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,
				&&yy133,  &&yy1245, &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy1246,
				&&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,
				&&yy133,  &&yy133,  &&yy133,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy1258, &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,
				&&yy136,  &&yy1259, &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy1260,
				&&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,
				&&yy136,  &&yy136,  &&yy136,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy8:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy132,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy1244, &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,
				&&yy133,  &&yy1245, &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy1246,
				&&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,
				&&yy133,  &&yy133,  &&yy133,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy1244, &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,
				&&yy133,  &&yy1245, &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy1246,
				&&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,
				&&yy133,  &&yy133,  &&yy133,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy9:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy132,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy1180, &&yy133,  &&yy133,
				&&yy1181, &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy1182,
				&&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy1183, &&yy133,  &&yy1184,
				&&yy133,  &&yy133,  &&yy133,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy1213, &&yy136,  &&yy136,
				&&yy1214, &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy1215,
				&&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy1216, &&yy136,  &&yy1217,
				&&yy136,  &&yy136,  &&yy136,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy10:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy132,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy1180, &&yy133,  &&yy133,
				&&yy1181, &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy1182,
				&&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy1183, &&yy133,  &&yy1184,
				&&yy133,  &&yy133,  &&yy133,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy1180, &&yy133,  &&yy133,
				&&yy1181, &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy1182,
				&&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy1183, &&yy133,  &&yy1184,
				&&yy133,  &&yy133,  &&yy133,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy11:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '-') goto yy1176;
		if(yych <= '0') goto yy12;
		if(yych <= '9') goto yy1177;
yy12:
#line 1406 "parse_date.g.re"
		{
/*		printf("unexpected character: #%d, %c ", *s->tok, *s->tok); */
		s->errors++;
		goto std;
	}
#line 1122 "<stdout>"
yy13:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy1140, &&yy1140, &&yy1140, &&yy1140, &&yy1140, &&yy1140, &&yy1140, &&yy1140,
				&&yy1140, &&yy1140, &&yy1140, &&yy1140, &&yy1140, &&yy615,  &&yy1142, &&yy614,
				&&yy1175, &&yy1174, &&yy1174, &&yy1174, &&yy1174, &&yy1174, &&yy1174, &&yy1174,
				&&yy1174, &&yy1174, &&yy1143, &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy1140, &&yy12,   &&yy12,   &&yy1140, &&yy12,   &&yy1140, &&yy12,
				&&yy1140, &&yy1140, &&yy1140, &&yy12,   &&yy12,   &&yy1140, &&yy1140, &&yy1140,
				&&yy12,   &&yy12,   &&yy12,   &&yy1140, &&yy1140, &&yy12,   &&yy1140, &&yy1140,
				&&yy1140, &&yy1140, &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy1140, &&yy12,   &&yy12,   &&yy1140, &&yy12,   &&yy1140, &&yy12,
				&&yy1140, &&yy12,   &&yy1140, &&yy12,   &&yy12,   &&yy1140, &&yy612,  &&yy1140,
				&&yy12,   &&yy12,   &&yy613,  &&yy606,  &&yy610,  &&yy12,   &&yy12,   &&yy1140,
				&&yy12,   &&yy1140, &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12
			};
			goto *yytarget[yych];
		}
yy14:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy604,  &&yy604,  &&yy604,  &&yy604,  &&yy604,  &&yy604,  &&yy604,  &&yy604,
				&&yy604,  &&yy604,  &&yy604,  &&yy604,  &&yy604,  &&yy615,  &&yy618,  &&yy614,
				&&yy1174, &&yy1174, &&yy1174, &&yy1141, &&yy1141, &&yy1141, &&yy1141, &&yy1141,
				&&yy1141, &&yy1141, &&yy627,  &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy604,  &&yy12,   &&yy12,   &&yy604,  &&yy12,   &&yy604,  &&yy12,
				&&yy604,  &&yy604,  &&yy604,  &&yy12,   &&yy12,   &&yy604,  &&yy604,  &&yy604,
				&&yy604,  &&yy12,   &&yy12,   &&yy604,  &&yy604,  &&yy12,   &&yy604,  &&yy604,
				&&yy604,  &&yy604,  &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy604,  &&yy12,   &&yy12,   &&yy604,  &&yy12,   &&yy604,  &&yy12,
				&&yy604,  &&yy12,   &&yy604,  &&yy12,   &&yy12,   &&yy604,  &&yy612,  &&yy604,
				&&yy604,  &&yy12,   &&yy613,  &&yy606,  &&yy610,  &&yy12,   &&yy12,   &&yy604,
				&&yy12,   &&yy604,  &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12
			};
			goto *yytarget[yych];
		}
yy15:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy604,  &&yy604,  &&yy604,  &&yy604,  &&yy604,  &&yy604,  &&yy604,  &&yy604,
				&&yy604,  &&yy604,  &&yy604,  &&yy604,  &&yy604,  &&yy615,  &&yy618,  &&yy614,
				&&yy1141, &&yy1141, &&yy1141, &&yy1141, &&yy1138, &&yy1138, &&yy1138, &&yy1138,
				&&yy1138, &&yy1138, &&yy627,  &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy604,  &&yy12,   &&yy12,   &&yy604,  &&yy12,   &&yy604,  &&yy12,
				&&yy604,  &&yy604,  &&yy604,  &&yy12,   &&yy12,   &&yy604,  &&yy604,  &&yy604,
				&&yy604,  &&yy12,   &&yy12,   &&yy604,  &&yy604,  &&yy12,   &&yy604,  &&yy604,
				&&yy604,  &&yy604,  &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy604,  &&yy12,   &&yy12,   &&yy604,  &&yy12,   &&yy604,  &&yy12,
				&&yy604,  &&yy12,   &&yy604,  &&yy12,   &&yy12,   &&yy604,  &&yy612,  &&yy604,
				&&yy604,  &&yy12,   &&yy613,  &&yy606,  &&yy610,  &&yy12,   &&yy12,   &&yy604,
				&&yy12,   &&yy604,  &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12
			};
			goto *yytarget[yych];
		}
yy16:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy604,  &&yy604,  &&yy604,  &&yy604,  &&yy604,  &&yy604,  &&yy604,  &&yy604,
				&&yy604,  &&yy604,  &&yy604,  &&yy604,  &&yy604,  &&yy615,  &&yy618,  &&yy614,
				&&yy1138, &&yy1138, &&yy611,  &&yy611,  &&yy611,  &&yy611,  &&yy611,  &&yy611,
				&&yy611,  &&yy611,  &&yy627,  &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy604,  &&yy12,   &&yy12,   &&yy604,  &&yy12,   &&yy604,  &&yy12,
				&&yy604,  &&yy604,  &&yy604,  &&yy12,   &&yy12,   &&yy604,  &&yy604,  &&yy604,
				&&yy604,  &&yy12,   &&yy12,   &&yy604,  &&yy604,  &&yy12,   &&yy604,  &&yy604,
				&&yy604,  &&yy604,  &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy604,  &&yy12,   &&yy12,   &&yy604,  &&yy12,   &&yy604,  &&yy12,
				&&yy604,  &&yy12,   &&yy604,  &&yy12,   &&yy12,   &&yy604,  &&yy612,  &&yy604,
				&&yy604,  &&yy12,   &&yy613,  &&yy606,  &&yy610,  &&yy12,   &&yy12,   &&yy604,
				&&yy12,   &&yy604,  &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12
			};
			goto *yytarget[yych];
		}
yy17:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy604,  &&yy604,  &&yy604,  &&yy604,  &&yy604,  &&yy604,  &&yy604,  &&yy604,
				&&yy604,  &&yy604,  &&yy604,  &&yy604,  &&yy604,  &&yy615,  &&yy618,  &&yy614,
				&&yy611,  &&yy611,  &&yy611,  &&yy611,  &&yy611,  &&yy611,  &&yy611,  &&yy611,
				&&yy611,  &&yy611,  &&yy627,  &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy604,  &&yy12,   &&yy12,   &&yy604,  &&yy12,   &&yy604,  &&yy12,
				&&yy604,  &&yy604,  &&yy604,  &&yy12,   &&yy12,   &&yy604,  &&yy604,  &&yy604,
				&&yy604,  &&yy12,   &&yy12,   &&yy604,  &&yy604,  &&yy12,   &&yy604,  &&yy604,
				&&yy604,  &&yy604,  &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy604,  &&yy12,   &&yy12,   &&yy604,  &&yy12,   &&yy604,  &&yy12,
				&&yy604,  &&yy12,   &&yy604,  &&yy12,   &&yy12,   &&yy604,  &&yy612,  &&yy604,
				&&yy604,  &&yy12,   &&yy613,  &&yy606,  &&yy610,  &&yy12,   &&yy12,   &&yy604,
				&&yy12,   &&yy604,  &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,
				&&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12,   &&yy12
			};
			goto *yytarget[yych];
		}
yy18:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy360,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy359,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,
				&&yy133,  &&yy602,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,
				&&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy601,  &&yy133,
				&&yy601,  &&yy133,  &&yy133,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,
				&&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,
				&&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,
				&&yy136,  &&yy136,  &&yy136,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy19:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= ')') {
				if(yych <= 0x1F) goto yy3;
				if(yych <= '(') goto yy359;
				goto yy360;
			} else {
				if(yych == '/') goto yy3;
				goto yy359;
			}
		} else {
			if(yych <= 'I') {
				if(yych <= '@') goto yy3;
				if(yych <= 'H') goto yy133;
				goto yy599;
			} else {
				if(yych <= 'Z') goto yy133;
				if(yych <= '`') goto yy3;
				if(yych <= 'z') goto yy136;
				goto yy3;
			}
		}
yy20:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= ')') {
				if(yych <= 0x1F) goto yy3;
				if(yych <= '(') goto yy359;
				goto yy360;
			} else {
				if(yych == '/') goto yy3;
				goto yy359;
			}
		} else {
			if(yych <= 'I') {
				if(yych <= '@') goto yy3;
				if(yych <= 'H') goto yy133;
				goto yy597;
			} else {
				if(yych <= 'Z') goto yy133;
				if(yych <= '`') goto yy3;
				if(yych <= 'z') goto yy136;
				goto yy3;
			}
		}
yy21:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych <= '@') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= 'A') goto yy580;
				if(yych <= 'T') goto yy133;
				goto yy579;
			}
		} else {
			if(yych <= 'a') {
				if(yych <= 'Z') goto yy133;
				if(yych <= '`') goto yy3;
				goto yy589;
			} else {
				if(yych == 'u') goto yy588;
				if(yych <= 'z') goto yy136;
				goto yy3;
			}
		}
yy22:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych <= '@') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= 'A') goto yy580;
				if(yych <= 'T') goto yy133;
				goto yy579;
			}
		} else {
			if(yych <= 'a') {
				if(yych <= 'Z') goto yy133;
				if(yych <= '`') goto yy3;
				goto yy580;
			} else {
				if(yych == 'u') goto yy579;
				if(yych <= 'z') goto yy133;
				goto yy3;
			}
		}
yy23:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy132,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy541,  &&yy133,  &&yy133,
				&&yy133,  &&yy542,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy543,
				&&yy133,  &&yy133,  &&yy544,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,
				&&yy133,  &&yy133,  &&yy133,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy560,  &&yy136,  &&yy136,
				&&yy136,  &&yy561,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy562,
				&&yy136,  &&yy136,  &&yy563,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,
				&&yy136,  &&yy136,  &&yy136,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy24:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy132,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy541,  &&yy133,  &&yy133,
				&&yy133,  &&yy542,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy543,
				&&yy133,  &&yy133,  &&yy544,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,
				&&yy133,  &&yy133,  &&yy133,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy541,  &&yy133,  &&yy133,
				&&yy133,  &&yy542,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy543,
				&&yy133,  &&yy133,  &&yy544,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,
				&&yy133,  &&yy133,  &&yy133,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy25:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy132,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy524,
				&&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,
				&&yy523,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy522,  &&yy133,  &&yy133,
				&&yy133,  &&yy133,  &&yy133,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy534,
				&&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,
				&&yy533,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy532,  &&yy136,  &&yy136,
				&&yy136,  &&yy136,  &&yy136,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy26:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy132,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy524,
				&&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,
				&&yy523,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy522,  &&yy133,  &&yy133,
				&&yy133,  &&yy133,  &&yy133,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy524,
				&&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,
				&&yy523,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy522,  &&yy133,  &&yy133,
				&&yy133,  &&yy133,  &&yy133,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy27:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy132,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy469,  &&yy133,  &&yy133,  &&yy133,  &&yy468,  &&yy133,  &&yy133,
				&&yy133,  &&yy470,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,
				&&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy471,  &&yy133,  &&yy133,
				&&yy133,  &&yy133,  &&yy133,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy496,  &&yy136,  &&yy136,  &&yy136,  &&yy495,  &&yy136,  &&yy136,
				&&yy136,  &&yy497,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,
				&&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy136,  &&yy498,  &&yy136,  &&yy136,
				&&yy136,  &&yy136,  &&yy136,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy28:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy132,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy469,  &&yy133,  &&yy133,  &&yy133,  &&yy468,  &&yy133,  &&yy133,
				&&yy133,  &&yy470,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,
				&&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy471,  &&yy133,  &&yy133,
				&&yy133,  &&yy133,  &&yy133,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy469,  &&yy133,  &&yy133,  &&yy133,  &&yy468,  &&yy133,  &&yy133,
				&&yy133,  &&yy470,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,
				&&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy133,  &&yy471,  &&yy133,  &&yy133,
				&&yy133,  &&yy133,  &&yy133,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy29:
		yych = *++YYCURSOR;
		if(yych <= 'C') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'B') goto yy133;
				goto yy458;
			}
		} else {
			if(yych <= 'b') {
				if(yych <= 'Z') goto yy133;
				if(yych <= '`') goto yy3;
				goto yy136;
			} else {
				if(yych <= 'c') goto yy463;
				if(yych <= 'z') goto yy136;
				goto yy3;
			}
		}
yy30:
		yych = *++YYCURSOR;
		if(yych <= 'C') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'B') goto yy133;
				goto yy458;
			}
		} else {
			if(yych <= 'b') {
				if(yych <= 'Z') goto yy133;
				if(yych <= '`') goto yy3;
				goto yy133;
			} else {
				if(yych <= 'c') goto yy458;
				if(yych <= 'z') goto yy133;
				goto yy3;
			}
		}
yy31:
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy133;
				goto yy356;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy133;
				if(yych <= '`') goto yy3;
				goto yy136;
			} else {
				if(yych <= 'e') goto yy451;
				if(yych <= 'z') goto yy136;
				goto yy3;
			}
		}
yy32:
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy133;
				goto yy356;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy133;
				if(yych <= '`') goto yy3;
				goto yy133;
			} else {
				if(yych <= 'e') goto yy356;
				if(yych <= 'z') goto yy133;
				goto yy3;
			}
		}
yy33:
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy133;
				goto yy339;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy133;
				if(yych <= '`') goto yy3;
				goto yy136;
			} else {
				if(yych <= 'e') goto yy348;
				if(yych <= 'z') goto yy136;
				goto yy3;
			}
		}
yy34:
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy133;
				goto yy339;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy133;
				if(yych <= '`') goto yy3;
				goto yy133;
			} else {
				if(yych <= 'e') goto yy339;
				if(yych <= 'z') goto yy133;
				goto yy3;
			}
		}
yy35:
		yych = *++YYCURSOR;
		if(yych <= 'L') {
			if(yych <= '@') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych == 'I') goto yy321;
				if(yych <= 'K') goto yy133;
				goto yy322;
			}
		} else {
			if(yych <= 'i') {
				if(yych <= 'Z') goto yy133;
				if(yych <= '`') goto yy3;
				if(yych <= 'h') goto yy136;
				goto yy330;
			} else {
				if(yych == 'l') goto yy331;
				if(yych <= 'z') goto yy136;
				goto yy3;
			}
		}
yy36:
		yych = *++YYCURSOR;
		if(yych <= 'L') {
			if(yych <= '@') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych == 'I') goto yy321;
				if(yych <= 'K') goto yy133;
				goto yy322;
			}
		} else {
			if(yych <= 'i') {
				if(yych <= 'Z') goto yy133;
				if(yych <= '`') goto yy3;
				if(yych <= 'h') goto yy133;
				goto yy321;
			} else {
				if(yych == 'l') goto yy322;
				if(yych <= 'z') goto yy133;
				goto yy3;
			}
		}
yy37:
		yych = *++YYCURSOR;
		if(yych <= 'A') {
			if(yych == ')') goto yy132;
			if(yych <= '@') goto yy3;
			goto yy315;
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy133;
				goto yy3;
			} else {
				if(yych <= 'a') goto yy318;
				if(yych <= 'z') goto yy136;
				goto yy3;
			}
		}
yy38:
		yych = *++YYCURSOR;
		if(yych <= 'A') {
			if(yych == ')') goto yy132;
			if(yych <= '@') goto yy3;
			goto yy315;
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy133;
				goto yy3;
			} else {
				if(yych <= 'a') goto yy315;
				if(yych <= 'z') goto yy133;
				goto yy3;
			}
		}
yy39:
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'Q') goto yy133;
				goto yy153;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= 'Z') goto yy133;
				if(yych <= '`') goto yy3;
				goto yy136;
			} else {
				if(yych <= 'r') goto yy235;
				if(yych <= 'z') goto yy136;
				goto yy3;
			}
		}
yy40:
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'Q') goto yy133;
				goto yy153;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= 'Z') goto yy133;
				if(yych <= '`') goto yy3;
				goto yy133;
			} else {
				if(yych <= 'r') goto yy153;
				if(yych <= 'z') goto yy133;
				goto yy3;
			}
		}
yy41:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yybm[0+yych] & 16) {
			goto yy54;
		}
		if(yych <= '/') goto yy12;
		if(yych <= '1') goto yy146;
		if(yych <= '2') goto yy147;
		if(yych <= '9') goto yy148;
		goto yy12;
yy42:
		yych = *++YYCURSOR;
		if(yych <= '@') goto yy12;
		if(yych <= 'Z') goto yy145;
		if(yych <= '`') goto yy12;
		if(yych <= 'z') goto yy145;
		goto yy12;
yy43:
		yych = *++YYCURSOR;
		if(yych <= '@') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'Z') goto yy133;
			if(yych <= '`') goto yy3;
			if(yych <= 'z') goto yy136;
			goto yy3;
		}
yy44:
		yych = *++YYCURSOR;
		if(yych <= '@') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'Z') goto yy133;
			if(yych <= '`') goto yy3;
			if(yych <= 'z') goto yy133;
			goto yy3;
		}
yy45:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yybm[0+yych] & 16) {
			goto yy54;
		}
		if(yych <= '/') goto yy46;
		if(yych <= '9') goto yy51;
yy46:
#line 1395 "parse_date.g.re"
		{
		goto std;
	}
#line 1996 "<stdout>"
yy47:
		yych = *++YYCURSOR;
		goto yy46;
yy48:
		++YYCURSOR;
#line 1400 "parse_date.g.re"
		{
		s->pos = cursor; s->line++;
		goto std;
	}
#line 2007 "<stdout>"
yy50:
		yych = *++YYCURSOR;
		goto yy12;
yy51:
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy56,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy51,   &&yy51,   &&yy51,   &&yy51,   &&yy51,   &&yy51,   &&yy51,   &&yy51,
				&&yy51,   &&yy51,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy61,   &&yy53,   &&yy63,   &&yy53,
				&&yy60,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy59,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy58,   &&yy65,   &&yy53,   &&yy53,   &&yy62,
				&&yy53,   &&yy64,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy61,   &&yy53,   &&yy63,   &&yy53,
				&&yy60,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy59,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy58,   &&yy65,   &&yy53,   &&yy53,   &&yy62,
				&&yy53,   &&yy64,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53
			};
			goto *yytarget[yych];
		}
yy53:
		YYCURSOR = YYMARKER;
		{
			static void *yytarget[27] = {
				&&yy12,
				&&yy3,
				&&yy46,
				&&yy69,
				&&yy172,
				&&yy341,
				&&yy363,
				&&yy385,
				&&yy420,
				&&yy526,
				&&yy620,
				&&yy634,
				&&yy775,
				&&yy784,
				&&yy880,
				&&yy916,
				&&yy943,
				&&yy889,
				&&yy1043,
				&&yy937,
				&&yy1146,
				&&yy1154,
				&&yy1200,
				&&yy1203,
				&&yy1279,
				&&yy1287,
				&&yy1310,
			};
			goto *yytarget[yyaccept];
		}
yy54:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 16) {
			goto yy54;
		}
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy51;
		goto yy53;
yy56:
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
		yych = *YYCURSOR;
yy57:
		{
			static void *yytarget[256] = {
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy56,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy61,   &&yy53,   &&yy63,   &&yy53,
				&&yy60,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy59,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy58,   &&yy65,   &&yy53,   &&yy53,   &&yy62,
				&&yy53,   &&yy64,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy61,   &&yy53,   &&yy63,   &&yy53,
				&&yy60,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy59,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy58,   &&yy65,   &&yy53,   &&yy53,   &&yy62,
				&&yy53,   &&yy64,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53
			};
			goto *yytarget[yych];
		}
yy58:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych <= 'D') {
				if(yych == 'A') goto yy119;
				goto yy53;
			} else {
				if(yych <= 'E') goto yy120;
				if(yych <= 'T') goto yy53;
				goto yy118;
			}
		} else {
			if(yych <= 'd') {
				if(yych == 'a') goto yy119;
				goto yy53;
			} else {
				if(yych <= 'e') goto yy120;
				if(yych == 'u') goto yy118;
				goto yy53;
			}
		}
yy59:
		yych = *++YYCURSOR;
		if(yych <= 'O') {
			if(yych == 'I') goto yy110;
			if(yych <= 'N') goto yy53;
			goto yy109;
		} else {
			if(yych <= 'i') {
				if(yych <= 'h') goto yy53;
				goto yy110;
			} else {
				if(yych == 'o') goto yy109;
				goto yy53;
			}
		}
yy60:
		yych = *++YYCURSOR;
		if(yych == 'O') goto yy107;
		if(yych == 'o') goto yy107;
		goto yy53;
yy61:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy106;
		if(yych == 'a') goto yy106;
		goto yy53;
yy62:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy98;
		if(yych == 'e') goto yy98;
		goto yy53;
yy63:
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych == 'O') goto yy83;
			if(yych <= 'Q') goto yy53;
			goto yy82;
		} else {
			if(yych <= 'o') {
				if(yych <= 'n') goto yy53;
				goto yy83;
			} else {
				if(yych == 'r') goto yy82;
				goto yy53;
			}
		}
yy64:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy79;
		if(yych == 'e') goto yy79;
		goto yy53;
yy65:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'H') goto yy66;
			if(yych <= 'T') goto yy53;
			goto yy67;
		} else {
			if(yych <= 'h') {
				if(yych <= 'g') goto yy53;
			} else {
				if(yych == 'u') goto yy67;
				goto yy53;
			}
		}
yy66:
		yych = *++YYCURSOR;
		if(yych == 'U') goto yy74;
		if(yych == 'u') goto yy74;
		goto yy53;
yy67:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy68;
		if(yych != 'e') goto yy53;
yy68:
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'S') goto yy70;
		if(yych == 's') goto yy70;
yy69:
#line 1379 "parse_date.g.re"
		{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 0, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 2253 "<stdout>"
yy70:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy71;
		if(yych != 'd') goto yy53;
yy71:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy72;
		if(yych != 'a') goto yy53;
yy72:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy73;
		if(yych != 'y') goto yy53;
yy73:
		yych = *++YYCURSOR;
		goto yy69;
yy74:
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'R') goto yy75;
		if(yych != 'r') goto yy69;
yy75:
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy76;
		if(yych != 's') goto yy53;
yy76:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy77;
		if(yych != 'd') goto yy53;
yy77:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy78;
		if(yych != 'a') goto yy53;
yy78:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy73;
		if(yych == 'y') goto yy73;
		goto yy53;
yy79:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy80;
		if(yych != 'a') goto yy53;
yy80:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy81;
		if(yych != 'r') goto yy53;
yy81:
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy73;
		if(yych == 's') goto yy73;
		goto yy69;
yy82:
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy95;
		if(yych == 'i') goto yy95;
		goto yy53;
yy83:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy84;
		if(yych != 'r') goto yy53;
yy84:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy85;
		if(yych != 't') goto yy53;
yy85:
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych == 'H') goto yy87;
			if(yych <= 'M') goto yy53;
		} else {
			if(yych <= 'h') {
				if(yych <= 'g') goto yy53;
				goto yy87;
			} else {
				if(yych != 'n') goto yy53;
			}
		}
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy92;
		if(yych == 'i') goto yy92;
		goto yy53;
yy87:
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy88;
		if(yych != 'n') goto yy53;
yy88:
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy89;
		if(yych != 'i') goto yy53;
yy89:
		yych = *++YYCURSOR;
		if(yych == 'G') goto yy90;
		if(yych != 'g') goto yy53;
yy90:
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy91;
		if(yych != 'h') goto yy53;
yy91:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy81;
		if(yych == 't') goto yy81;
		goto yy53;
yy92:
		yych = *++YYCURSOR;
		if(yych == 'G') goto yy93;
		if(yych != 'g') goto yy53;
yy93:
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy94;
		if(yych != 'h') goto yy53;
yy94:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy81;
		if(yych == 't') goto yy81;
		goto yy53;
yy95:
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'D') goto yy96;
		if(yych != 'd') goto yy69;
yy96:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy97;
		if(yych != 'a') goto yy53;
yy97:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy73;
		if(yych == 'y') goto yy73;
		goto yy53;
yy98:
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= 'C') goto yy53;
			if(yych <= 'D') goto yy100;
		} else {
			if(yych <= 'c') goto yy53;
			if(yych <= 'd') goto yy100;
			if(yych >= 'f') goto yy53;
		}
		yych = *++YYCURSOR;
		if(yych == 'K') goto yy81;
		if(yych == 'k') goto yy81;
		goto yy53;
yy100:
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'N') goto yy101;
		if(yych != 'n') goto yy69;
yy101:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy102;
		if(yych != 'e') goto yy53;
yy102:
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy103;
		if(yych != 's') goto yy53;
yy103:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy104;
		if(yych != 'd') goto yy53;
yy104:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy105;
		if(yych != 'a') goto yy53;
yy105:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy73;
		if(yych == 'y') goto yy73;
		goto yy53;
yy106:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy81;
		if(yych == 'y') goto yy81;
		goto yy53;
yy107:
		yych = *++YYCURSOR;
		if(yych == 'U') goto yy108;
		if(yych != 'u') goto yy53;
yy108:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy81;
		if(yych == 'r') goto yy81;
		goto yy53;
yy109:
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy114;
		if(yych == 'n') goto yy114;
		goto yy53;
yy110:
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy111;
		if(yych != 'n') goto yy53;
yy111:
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'U') {
			if(yych == 'S') goto yy73;
			if(yych <= 'T') goto yy69;
		} else {
			if(yych <= 's') {
				if(yych <= 'r') goto yy69;
				goto yy73;
			} else {
				if(yych != 'u') goto yy69;
			}
		}
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy113;
		if(yych != 't') goto yy53;
yy113:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy81;
		if(yych == 'e') goto yy81;
		goto yy53;
yy114:
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych == 'D') goto yy115;
			if(yych <= 'S') goto yy69;
			goto yy116;
		} else {
			if(yych <= 'd') {
				if(yych <= 'c') goto yy69;
			} else {
				if(yych == 't') goto yy116;
				goto yy69;
			}
		}
yy115:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy117;
		if(yych == 'a') goto yy117;
		goto yy53;
yy116:
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy81;
		if(yych == 'h') goto yy81;
		goto yy53;
yy117:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy73;
		if(yych == 'y') goto yy73;
		goto yy53;
yy118:
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy129;
		if(yych == 'n') goto yy129;
		goto yy53;
yy119:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy124;
		if(yych == 't') goto yy124;
		goto yy53;
yy120:
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy121;
		if(yych != 'c') goto yy53;
yy121:
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych == 'O') goto yy122;
			if(yych <= 'R') goto yy69;
			goto yy73;
		} else {
			if(yych <= 'o') {
				if(yych <= 'n') goto yy69;
			} else {
				if(yych == 's') goto yy73;
				goto yy69;
			}
		}
yy122:
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy123;
		if(yych != 'n') goto yy53;
yy123:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy81;
		if(yych == 'd') goto yy81;
		goto yy53;
yy124:
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'U') goto yy125;
		if(yych != 'u') goto yy69;
yy125:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy126;
		if(yych != 'r') goto yy53;
yy126:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy127;
		if(yych != 'd') goto yy53;
yy127:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy128;
		if(yych != 'a') goto yy53;
yy128:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy73;
		if(yych == 'y') goto yy73;
		goto yy53;
yy129:
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'D') goto yy130;
		if(yych != 'd') goto yy69;
yy130:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy131;
		if(yych != 'a') goto yy53;
yy131:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy73;
		if(yych == 'y') goto yy73;
		goto yy53;
yy132:
		yych = *++YYCURSOR;
		goto yy3;
yy133:
		yych = *++YYCURSOR;
		if(yych <= '@') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'Z') goto yy134;
			if(yych <= '`') goto yy3;
			if(yych >= '{') goto yy3;
		}
yy134:
		yych = *++YYCURSOR;
		if(yych <= '@') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'Z') goto yy135;
			if(yych <= '`') goto yy3;
			if(yych >= '{') goto yy3;
		}
yy135:
		yych = *++YYCURSOR;
		if(yych == ')') goto yy132;
		goto yy3;
yy136:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych == '/') goto yy138;
				goto yy3;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '^') goto yy3;
				goto yy138;
			} else {
				if(yych <= '`') goto yy3;
				if(yych >= '{') goto yy3;
			}
		}
yy137:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych != '/') goto yy3;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '^') goto yy3;
			} else {
				if(yych <= '`') goto yy3;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy138:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= '@') goto yy53;
		if(yych >= '[') goto yy53;
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 32) {
			goto yy140;
		}
		goto yy53;
yy140:
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 32) {
			goto yy140;
		}
		if(yych == '/') goto yy138;
		if(yych == '_') goto yy138;
		goto yy3;
yy142:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == ')') goto yy132;
			if(yych <= '.') goto yy3;
			goto yy138;
		} else {
			if(yych <= '_') {
				if(yych <= '^') goto yy3;
				goto yy138;
			} else {
				if(yych <= '`') goto yy3;
				if(yych >= '{') goto yy3;
			}
		}
yy143:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
yy144:
		if(yych <= '^') {
			if(yych == '/') goto yy138;
			goto yy53;
		} else {
			if(yych <= '_') goto yy138;
			if(yych <= '`') goto yy53;
			if(yych <= 'z') goto yy143;
			goto yy53;
		}
yy145:
		yych = *++YYCURSOR;
		if(yych <= '@') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'Z') goto yy133;
			if(yych <= '`') goto yy3;
			if(yych <= 'z') goto yy133;
			goto yy3;
		}
yy146:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy57,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy148,  &&yy148,  &&yy148,  &&yy148,  &&yy148,  &&yy148,  &&yy148,  &&yy148,
				&&yy148,  &&yy148,  &&yy149,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy3,    &&yy57,   &&yy3,
				&&yy57,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy57,   &&yy3,    &&yy3,    &&yy57,
				&&yy3,    &&yy57,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy3,    &&yy57,   &&yy3,
				&&yy57,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy57,   &&yy3,    &&yy3,    &&yy57,
				&&yy3,    &&yy57,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy147:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy57,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy148,  &&yy148,  &&yy148,  &&yy148,  &&yy150,  &&yy150,  &&yy151,  &&yy151,
				&&yy151,  &&yy151,  &&yy149,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy3,    &&yy57,   &&yy3,
				&&yy57,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy57,   &&yy3,    &&yy3,    &&yy57,
				&&yy3,    &&yy57,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy3,    &&yy57,   &&yy3,
				&&yy57,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy57,   &&yy3,    &&yy3,    &&yy57,
				&&yy3,    &&yy57,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy148:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy57,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy150,  &&yy150,  &&yy150,  &&yy150,  &&yy150,  &&yy150,  &&yy151,  &&yy151,
				&&yy151,  &&yy151,  &&yy149,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy3,    &&yy57,   &&yy3,
				&&yy57,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy57,   &&yy3,    &&yy3,    &&yy57,
				&&yy3,    &&yy57,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy3,    &&yy57,   &&yy3,
				&&yy57,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy57,   &&yy3,    &&yy3,    &&yy57,
				&&yy3,    &&yy57,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy149:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy3;
		if(yych <= '5') goto yy152;
		if(yych <= '9') goto yy132;
		goto yy3;
yy150:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy57,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy151,  &&yy151,  &&yy151,  &&yy151,  &&yy151,  &&yy151,  &&yy151,  &&yy151,
				&&yy151,  &&yy151,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy3,    &&yy57,   &&yy3,
				&&yy57,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy57,   &&yy3,    &&yy3,    &&yy57,
				&&yy3,    &&yy57,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy3,    &&yy57,   &&yy3,
				&&yy57,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy57,   &&yy3,    &&yy3,    &&yy57,
				&&yy3,    &&yy57,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy151:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy57,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy51,   &&yy51,   &&yy51,   &&yy51,   &&yy51,   &&yy51,   &&yy51,   &&yy51,
				&&yy51,   &&yy51,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy3,    &&yy57,   &&yy3,
				&&yy57,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy57,   &&yy3,    &&yy3,    &&yy57,
				&&yy3,    &&yy57,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy3,    &&yy57,   &&yy3,
				&&yy57,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy57,   &&yy57,   &&yy3,    &&yy3,    &&yy57,
				&&yy3,    &&yy57,   &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy152:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy3;
		if(yych <= '9') goto yy132;
		goto yy3;
yy153:
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy134;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				goto yy134;
			} else {
				if(yych <= 'e') goto yy154;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy154:
		yych = *++YYCURSOR;
		if(yych <= 'V') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'U') goto yy135;
			}
		} else {
			if(yych <= 'u') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy3;
				goto yy135;
			} else {
				if(yych <= 'v') goto yy155;
				if(yych <= 'z') goto yy135;
				goto yy3;
			}
		}
yy155:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'H') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'I') goto yy156;
			if(yych != 'i') goto yy3;
		}
yy156:
		yych = *++YYCURSOR;
		if(yych == 'O') goto yy157;
		if(yych != 'o') goto yy53;
yy157:
		yych = *++YYCURSOR;
		if(yych == 'U') goto yy158;
		if(yych != 'u') goto yy53;
yy158:
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy159;
		if(yych != 's') goto yy53;
yy159:
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
		yych = *YYCURSOR;
yy160:
		{
			static void *yytarget[256] = {
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy159,  &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy164,  &&yy53,   &&yy166,  &&yy53,
				&&yy163,  &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy162,  &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy161,  &&yy168,  &&yy53,   &&yy53,   &&yy165,
				&&yy53,   &&yy167,  &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy164,  &&yy53,   &&yy166,  &&yy53,
				&&yy163,  &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy162,  &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy161,  &&yy168,  &&yy53,   &&yy53,   &&yy165,
				&&yy53,   &&yy167,  &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53
			};
			goto *yytarget[yych];
		}
yy161:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych <= 'D') {
				if(yych == 'A') goto yy222;
				goto yy53;
			} else {
				if(yych <= 'E') goto yy223;
				if(yych <= 'T') goto yy53;
				goto yy221;
			}
		} else {
			if(yych <= 'd') {
				if(yych == 'a') goto yy222;
				goto yy53;
			} else {
				if(yych <= 'e') goto yy223;
				if(yych == 'u') goto yy221;
				goto yy53;
			}
		}
yy162:
		yych = *++YYCURSOR;
		if(yych <= 'O') {
			if(yych == 'I') goto yy213;
			if(yych <= 'N') goto yy53;
			goto yy212;
		} else {
			if(yych <= 'i') {
				if(yych <= 'h') goto yy53;
				goto yy213;
			} else {
				if(yych == 'o') goto yy212;
				goto yy53;
			}
		}
yy163:
		yych = *++YYCURSOR;
		if(yych == 'O') goto yy210;
		if(yych == 'o') goto yy210;
		goto yy53;
yy164:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy209;
		if(yych == 'a') goto yy209;
		goto yy53;
yy165:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy201;
		if(yych == 'e') goto yy201;
		goto yy53;
yy166:
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych == 'O') goto yy186;
			if(yych <= 'Q') goto yy53;
			goto yy185;
		} else {
			if(yych <= 'o') {
				if(yych <= 'n') goto yy53;
				goto yy186;
			} else {
				if(yych == 'r') goto yy185;
				goto yy53;
			}
		}
yy167:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy182;
		if(yych == 'e') goto yy182;
		goto yy53;
yy168:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'H') goto yy169;
			if(yych <= 'T') goto yy53;
			goto yy170;
		} else {
			if(yych <= 'h') {
				if(yych <= 'g') goto yy53;
			} else {
				if(yych == 'u') goto yy170;
				goto yy53;
			}
		}
yy169:
		yych = *++YYCURSOR;
		if(yych == 'U') goto yy177;
		if(yych == 'u') goto yy177;
		goto yy53;
yy170:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy171;
		if(yych != 'e') goto yy53;
yy171:
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'S') goto yy173;
		if(yych == 's') goto yy173;
yy172:
#line 1323 "parse_date.g.re"
		{
		timelib_sll i;
		int         behavior;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 3137 "<stdout>"
yy173:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy174;
		if(yych != 'd') goto yy53;
yy174:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy175;
		if(yych != 'a') goto yy53;
yy175:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy176;
		if(yych != 'y') goto yy53;
yy176:
		yych = *++YYCURSOR;
		goto yy172;
yy177:
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'R') goto yy178;
		if(yych != 'r') goto yy172;
yy178:
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy179;
		if(yych != 's') goto yy53;
yy179:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy180;
		if(yych != 'd') goto yy53;
yy180:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy181;
		if(yych != 'a') goto yy53;
yy181:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy176;
		if(yych == 'y') goto yy176;
		goto yy53;
yy182:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy183;
		if(yych != 'a') goto yy53;
yy183:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy184;
		if(yych != 'r') goto yy53;
yy184:
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy176;
		if(yych == 's') goto yy176;
		goto yy172;
yy185:
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy198;
		if(yych == 'i') goto yy198;
		goto yy53;
yy186:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy187;
		if(yych != 'r') goto yy53;
yy187:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy188;
		if(yych != 't') goto yy53;
yy188:
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych == 'H') goto yy190;
			if(yych <= 'M') goto yy53;
		} else {
			if(yych <= 'h') {
				if(yych <= 'g') goto yy53;
				goto yy190;
			} else {
				if(yych != 'n') goto yy53;
			}
		}
yy189:
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy195;
		if(yych == 'i') goto yy195;
		goto yy53;
yy190:
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy191;
		if(yych != 'n') goto yy53;
yy191:
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy192;
		if(yych != 'i') goto yy53;
yy192:
		yych = *++YYCURSOR;
		if(yych == 'G') goto yy193;
		if(yych != 'g') goto yy53;
yy193:
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy194;
		if(yych != 'h') goto yy53;
yy194:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy184;
		if(yych == 't') goto yy184;
		goto yy53;
yy195:
		yych = *++YYCURSOR;
		if(yych == 'G') goto yy196;
		if(yych != 'g') goto yy53;
yy196:
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy197;
		if(yych != 'h') goto yy53;
yy197:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy184;
		if(yych == 't') goto yy184;
		goto yy53;
yy198:
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'D') goto yy199;
		if(yych != 'd') goto yy172;
yy199:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy200;
		if(yych != 'a') goto yy53;
yy200:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy176;
		if(yych == 'y') goto yy176;
		goto yy53;
yy201:
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= 'C') goto yy53;
			if(yych <= 'D') goto yy203;
		} else {
			if(yych <= 'c') goto yy53;
			if(yych <= 'd') goto yy203;
			if(yych >= 'f') goto yy53;
		}
yy202:
		yych = *++YYCURSOR;
		if(yych == 'K') goto yy184;
		if(yych == 'k') goto yy184;
		goto yy53;
yy203:
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'N') goto yy204;
		if(yych != 'n') goto yy172;
yy204:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy205;
		if(yych != 'e') goto yy53;
yy205:
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy206;
		if(yych != 's') goto yy53;
yy206:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy207;
		if(yych != 'd') goto yy53;
yy207:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy208;
		if(yych != 'a') goto yy53;
yy208:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy176;
		if(yych == 'y') goto yy176;
		goto yy53;
yy209:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy184;
		if(yych == 'y') goto yy184;
		goto yy53;
yy210:
		yych = *++YYCURSOR;
		if(yych == 'U') goto yy211;
		if(yych != 'u') goto yy53;
yy211:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy184;
		if(yych == 'r') goto yy184;
		goto yy53;
yy212:
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy217;
		if(yych == 'n') goto yy217;
		goto yy53;
yy213:
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy214;
		if(yych != 'n') goto yy53;
yy214:
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'U') {
			if(yych == 'S') goto yy176;
			if(yych <= 'T') goto yy172;
		} else {
			if(yych <= 's') {
				if(yych <= 'r') goto yy172;
				goto yy176;
			} else {
				if(yych != 'u') goto yy172;
			}
		}
yy215:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy216;
		if(yych != 't') goto yy53;
yy216:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy184;
		if(yych == 'e') goto yy184;
		goto yy53;
yy217:
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych == 'D') goto yy218;
			if(yych <= 'S') goto yy172;
			goto yy219;
		} else {
			if(yych <= 'd') {
				if(yych <= 'c') goto yy172;
			} else {
				if(yych == 't') goto yy219;
				goto yy172;
			}
		}
yy218:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy220;
		if(yych == 'a') goto yy220;
		goto yy53;
yy219:
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy184;
		if(yych == 'h') goto yy184;
		goto yy53;
yy220:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy176;
		if(yych == 'y') goto yy176;
		goto yy53;
yy221:
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy232;
		if(yych == 'n') goto yy232;
		goto yy53;
yy222:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy227;
		if(yych == 't') goto yy227;
		goto yy53;
yy223:
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy224;
		if(yych != 'c') goto yy53;
yy224:
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych == 'O') goto yy225;
			if(yych <= 'R') goto yy172;
			goto yy176;
		} else {
			if(yych <= 'o') {
				if(yych <= 'n') goto yy172;
			} else {
				if(yych == 's') goto yy176;
				goto yy172;
			}
		}
yy225:
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy226;
		if(yych != 'n') goto yy53;
yy226:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy184;
		if(yych == 'd') goto yy184;
		goto yy53;
yy227:
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'U') goto yy228;
		if(yych != 'u') goto yy172;
yy228:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy229;
		if(yych != 'r') goto yy53;
yy229:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy230;
		if(yych != 'd') goto yy53;
yy230:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy231;
		if(yych != 'a') goto yy53;
yy231:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy176;
		if(yych == 'y') goto yy176;
		goto yy53;
yy232:
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'D') goto yy233;
		if(yych != 'd') goto yy172;
yy233:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy234;
		if(yych != 'a') goto yy53;
yy234:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy176;
		if(yych == 'y') goto yy176;
		goto yy53;
yy235:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'E') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy134;
				goto yy154;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy134;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'e') goto yy236;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy236:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'V') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'U') goto yy135;
				goto yy155;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'v') goto yy237;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy237:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'I') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'H') goto yy3;
				goto yy156;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'i') goto yy238;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy238:
		yych = *++YYCURSOR;
		if(yych == 'O') goto yy157;
		if(yych != 'o') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'U') goto yy158;
		if(yych != 'u') goto yy144;
		yych = *++YYCURSOR;
		if(yych <= '^') {
			if(yych <= '/') {
				if(yych <= '.') goto yy53;
				goto yy138;
			} else {
				if(yych == 'S') goto yy159;
				goto yy53;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= '_') goto yy138;
				if(yych <= '`') goto yy53;
				goto yy143;
			} else {
				if(yych <= 's') goto yy241;
				if(yych <= 'z') goto yy143;
				goto yy53;
			}
		}
yy241:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy138,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy138,
				&&yy160,  &&yy143,  &&yy143,  &&yy143,  &&yy245,  &&yy143,  &&yy247,  &&yy143,
				&&yy244,  &&yy143,  &&yy143,  &&yy143,  &&yy143,  &&yy243,  &&yy143,  &&yy143,
				&&yy143,  &&yy143,  &&yy143,  &&yy242,  &&yy249,  &&yy143,  &&yy143,  &&yy246,
				&&yy143,  &&yy248,  &&yy143,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,
				&&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160,  &&yy160
			};
			goto *yytarget[yych];
		}
yy242:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych <= 'D') {
				if(yych == 'A') goto yy222;
				goto yy144;
			} else {
				if(yych <= 'E') goto yy223;
				if(yych <= 'T') goto yy144;
				goto yy221;
			}
		} else {
			if(yych <= 'd') {
				if(yych == 'a') goto yy301;
				goto yy144;
			} else {
				if(yych <= 'e') goto yy302;
				if(yych == 'u') goto yy303;
				goto yy144;
			}
		}
yy243:
		yych = *++YYCURSOR;
		if(yych <= 'O') {
			if(yych == 'I') goto yy213;
			if(yych <= 'N') goto yy144;
			goto yy212;
		} else {
			if(yych <= 'i') {
				if(yych <= 'h') goto yy144;
				goto yy292;
			} else {
				if(yych == 'o') goto yy293;
				goto yy144;
			}
		}
yy244:
		yych = *++YYCURSOR;
		if(yych == 'O') goto yy210;
		if(yych == 'o') goto yy290;
		goto yy144;
yy245:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy209;
		if(yych == 'a') goto yy289;
		goto yy144;
yy246:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy201;
		if(yych == 'e') goto yy281;
		goto yy144;
yy247:
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych == 'O') goto yy186;
			if(yych <= 'Q') goto yy144;
			goto yy185;
		} else {
			if(yych <= 'o') {
				if(yych <= 'n') goto yy144;
				goto yy265;
			} else {
				if(yych == 'r') goto yy266;
				goto yy144;
			}
		}
yy248:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy182;
		if(yych == 'e') goto yy262;
		goto yy144;
yy249:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'H') goto yy169;
			if(yych <= 'T') goto yy144;
			goto yy170;
		} else {
			if(yych <= 'h') {
				if(yych <= 'g') goto yy144;
			} else {
				if(yych == 'u') goto yy251;
				goto yy144;
			}
		}
		yych = *++YYCURSOR;
		if(yych == 'U') goto yy177;
		if(yych == 'u') goto yy257;
		goto yy144;
yy251:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy171;
		if(yych != 'e') goto yy144;
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '^') {
			if(yych <= '/') {
				if(yych <= '.') goto yy172;
				goto yy138;
			} else {
				if(yych == 'S') goto yy173;
				goto yy172;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= '_') goto yy138;
				if(yych <= '`') goto yy172;
				goto yy143;
			} else {
				if(yych <= 's') goto yy253;
				if(yych <= 'z') goto yy143;
				goto yy172;
			}
		}
yy253:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy174;
		if(yych != 'd') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy175;
		if(yych != 'a') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy176;
		if(yych != 'y') goto yy144;
yy256:
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '^') {
			if(yych == '/') goto yy138;
			goto yy172;
		} else {
			if(yych <= '_') goto yy138;
			if(yych <= '`') goto yy172;
			if(yych <= 'z') goto yy143;
			goto yy172;
		}
yy257:
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '^') {
			if(yych <= '/') {
				if(yych <= '.') goto yy172;
				goto yy138;
			} else {
				if(yych == 'R') goto yy178;
				goto yy172;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= '_') goto yy138;
				if(yych <= '`') goto yy172;
				goto yy143;
			} else {
				if(yych <= 'r') goto yy258;
				if(yych <= 'z') goto yy143;
				goto yy172;
			}
		}
yy258:
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy179;
		if(yych != 's') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy180;
		if(yych != 'd') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy181;
		if(yych != 'a') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy176;
		if(yych == 'y') goto yy256;
		goto yy144;
yy262:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy183;
		if(yych != 'a') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy184;
		if(yych != 'r') goto yy144;
yy264:
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '^') {
			if(yych <= '/') {
				if(yych <= '.') goto yy172;
				goto yy138;
			} else {
				if(yych == 'S') goto yy176;
				goto yy172;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= '_') goto yy138;
				if(yych <= '`') goto yy172;
				goto yy143;
			} else {
				if(yych <= 's') goto yy256;
				if(yych <= 'z') goto yy143;
				goto yy172;
			}
		}
yy265:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy187;
		if(yych == 'r') goto yy270;
		goto yy144;
yy266:
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy198;
		if(yych != 'i') goto yy144;
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '^') {
			if(yych <= '/') {
				if(yych <= '.') goto yy172;
				goto yy138;
			} else {
				if(yych == 'D') goto yy199;
				goto yy172;
			}
		} else {
			if(yych <= 'c') {
				if(yych <= '_') goto yy138;
				if(yych <= '`') goto yy172;
				goto yy143;
			} else {
				if(yych <= 'd') goto yy268;
				if(yych <= 'z') goto yy143;
				goto yy172;
			}
		}
yy268:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy200;
		if(yych != 'a') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy176;
		if(yych == 'y') goto yy256;
		goto yy144;
yy270:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy188;
		if(yych != 't') goto yy144;
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych == 'H') goto yy190;
			if(yych <= 'M') goto yy144;
			goto yy189;
		} else {
			if(yych <= 'h') {
				if(yych <= 'g') goto yy144;
				goto yy273;
			} else {
				if(yych != 'n') goto yy144;
			}
		}
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy195;
		if(yych == 'i') goto yy278;
		goto yy144;
yy273:
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy191;
		if(yych != 'n') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy192;
		if(yych != 'i') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'G') goto yy193;
		if(yych != 'g') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy194;
		if(yych != 'h') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy184;
		if(yych == 't') goto yy264;
		goto yy144;
yy278:
		yych = *++YYCURSOR;
		if(yych == 'G') goto yy196;
		if(yych != 'g') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy197;
		if(yych != 'h') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy184;
		if(yych == 't') goto yy264;
		goto yy144;
yy281:
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= 'C') goto yy144;
			if(yych <= 'D') goto yy203;
			goto yy202;
		} else {
			if(yych <= 'c') goto yy144;
			if(yych <= 'd') goto yy283;
			if(yych >= 'f') goto yy144;
		}
		yych = *++YYCURSOR;
		if(yych == 'K') goto yy184;
		if(yych == 'k') goto yy264;
		goto yy144;
yy283:
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '^') {
			if(yych <= '/') {
				if(yych <= '.') goto yy172;
				goto yy138;
			} else {
				if(yych == 'N') goto yy204;
				goto yy172;
			}
		} else {
			if(yych <= 'm') {
				if(yych <= '_') goto yy138;
				if(yych <= '`') goto yy172;
				goto yy143;
			} else {
				if(yych <= 'n') goto yy284;
				if(yych <= 'z') goto yy143;
				goto yy172;
			}
		}
yy284:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy205;
		if(yych != 'e') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy206;
		if(yych != 's') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy207;
		if(yych != 'd') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy208;
		if(yych != 'a') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy176;
		if(yych == 'y') goto yy256;
		goto yy144;
yy289:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy184;
		if(yych == 'y') goto yy264;
		goto yy144;
yy290:
		yych = *++YYCURSOR;
		if(yych == 'U') goto yy211;
		if(yych != 'u') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy184;
		if(yych == 'r') goto yy264;
		goto yy144;
yy292:
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy214;
		if(yych == 'n') goto yy298;
		goto yy144;
yy293:
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy217;
		if(yych != 'n') goto yy144;
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '^') {
			if(yych <= 'C') {
				if(yych == '/') goto yy138;
				goto yy172;
			} else {
				if(yych <= 'D') goto yy218;
				if(yych == 'T') goto yy219;
				goto yy172;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= '_') goto yy138;
				if(yych <= '`') goto yy172;
				if(yych <= 'c') goto yy143;
			} else {
				if(yych == 't') goto yy296;
				if(yych <= 'z') goto yy143;
				goto yy172;
			}
		}
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy220;
		if(yych == 'a') goto yy297;
		goto yy144;
yy296:
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy184;
		if(yych == 'h') goto yy264;
		goto yy144;
yy297:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy176;
		if(yych == 'y') goto yy256;
		goto yy144;
yy298:
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '^') {
			if(yych <= 'R') {
				if(yych == '/') goto yy138;
				goto yy172;
			} else {
				if(yych <= 'S') goto yy176;
				if(yych == 'U') goto yy215;
				goto yy172;
			}
		} else {
			if(yych <= 's') {
				if(yych <= '_') goto yy138;
				if(yych <= '`') goto yy172;
				if(yych <= 'r') goto yy143;
				goto yy256;
			} else {
				if(yych == 'u') goto yy299;
				if(yych <= 'z') goto yy143;
				goto yy172;
			}
		}
yy299:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy216;
		if(yych != 't') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy184;
		if(yych == 'e') goto yy264;
		goto yy144;
yy301:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy227;
		if(yych == 't') goto yy310;
		goto yy144;
yy302:
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy224;
		if(yych == 'c') goto yy307;
		goto yy144;
yy303:
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy232;
		if(yych != 'n') goto yy144;
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '^') {
			if(yych <= '/') {
				if(yych <= '.') goto yy172;
				goto yy138;
			} else {
				if(yych == 'D') goto yy233;
				goto yy172;
			}
		} else {
			if(yych <= 'c') {
				if(yych <= '_') goto yy138;
				if(yych <= '`') goto yy172;
				goto yy143;
			} else {
				if(yych <= 'd') goto yy305;
				if(yych <= 'z') goto yy143;
				goto yy172;
			}
		}
yy305:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy234;
		if(yych != 'a') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy176;
		if(yych == 'y') goto yy256;
		goto yy144;
yy307:
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '^') {
			if(yych <= 'N') {
				if(yych == '/') goto yy138;
				goto yy172;
			} else {
				if(yych <= 'O') goto yy225;
				if(yych == 'S') goto yy176;
				goto yy172;
			}
		} else {
			if(yych <= 'o') {
				if(yych <= '_') goto yy138;
				if(yych <= '`') goto yy172;
				if(yych <= 'n') goto yy143;
			} else {
				if(yych == 's') goto yy256;
				if(yych <= 'z') goto yy143;
				goto yy172;
			}
		}
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy226;
		if(yych != 'n') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy184;
		if(yych == 'd') goto yy264;
		goto yy144;
yy310:
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '^') {
			if(yych <= '/') {
				if(yych <= '.') goto yy172;
				goto yy138;
			} else {
				if(yych == 'U') goto yy228;
				goto yy172;
			}
		} else {
			if(yych <= 't') {
				if(yych <= '_') goto yy138;
				if(yych <= '`') goto yy172;
				goto yy143;
			} else {
				if(yych <= 'u') goto yy311;
				if(yych <= 'z') goto yy143;
				goto yy172;
			}
		}
yy311:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy229;
		if(yych != 'r') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy230;
		if(yych != 'd') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy231;
		if(yych != 'a') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy176;
		if(yych == 'y') goto yy256;
		goto yy144;
yy315:
		yych = *++YYCURSOR;
		if(yych <= 'S') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'R') goto yy134;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				goto yy134;
			} else {
				if(yych <= 's') goto yy316;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy316:
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy135;
			}
		} else {
			if(yych <= 's') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy3;
				goto yy135;
			} else {
				if(yych <= 't') goto yy317;
				if(yych <= 'z') goto yy135;
				goto yy3;
			}
		}
yy317:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy160,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy132,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy160,  &&yy3,    &&yy160,  &&yy3,
				&&yy160,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy160,  &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy160,  &&yy160,  &&yy3,    &&yy3,    &&yy160,
				&&yy3,    &&yy160,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy160,  &&yy3,    &&yy160,  &&yy3,
				&&yy160,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy160,  &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy160,  &&yy160,  &&yy3,    &&yy3,    &&yy160,
				&&yy3,    &&yy160,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy318:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'R') goto yy134;
				goto yy316;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy134;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 's') goto yy319;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy319:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy135;
				goto yy317;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 't') goto yy320;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy320:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy160,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy132,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy160,  &&yy3,    &&yy160,  &&yy3,
				&&yy160,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy160,  &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy160,  &&yy160,  &&yy3,    &&yy3,    &&yy160,
				&&yy3,    &&yy160,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy143,  &&yy143,  &&yy143,  &&yy245,  &&yy143,  &&yy247,  &&yy143,
				&&yy244,  &&yy143,  &&yy143,  &&yy143,  &&yy143,  &&yy243,  &&yy143,  &&yy143,
				&&yy143,  &&yy143,  &&yy143,  &&yy242,  &&yy249,  &&yy143,  &&yy143,  &&yy246,
				&&yy143,  &&yy248,  &&yy143,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy321:
		yych = *++YYCURSOR;
		if(yych <= 'G') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'F') goto yy134;
				goto yy328;
			}
		} else {
			if(yych <= 'f') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				goto yy134;
			} else {
				if(yych <= 'g') goto yy328;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy322:
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy134;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				goto yy134;
			} else {
				if(yych <= 'e') goto yy323;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy323:
		yych = *++YYCURSOR;
		if(yych <= 'V') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'U') goto yy135;
			}
		} else {
			if(yych <= 'u') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy3;
				goto yy135;
			} else {
				if(yych <= 'v') goto yy324;
				if(yych <= 'z') goto yy135;
				goto yy3;
			}
		}
yy324:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'E') goto yy325;
			if(yych != 'e') goto yy3;
		}
yy325:
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy326;
		if(yych != 'n') goto yy53;
yy326:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy327;
		if(yych != 't') goto yy53;
yy327:
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy159;
		if(yych == 'h') goto yy159;
		goto yy53;
yy328:
		yych = *++YYCURSOR;
		if(yych <= 'H') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'G') goto yy135;
			}
		} else {
			if(yych <= 'g') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy3;
				goto yy135;
			} else {
				if(yych <= 'h') goto yy329;
				if(yych <= 'z') goto yy135;
				goto yy3;
			}
		}
yy329:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'T') goto yy159;
			if(yych == 't') goto yy159;
			goto yy3;
		}
yy330:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'G') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'F') goto yy134;
				goto yy328;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy134;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'g') goto yy337;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy331:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'E') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy134;
				goto yy323;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy134;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'e') goto yy332;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy332:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'V') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'U') goto yy135;
				goto yy324;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'v') goto yy333;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy333:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'E') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'D') goto yy3;
				goto yy325;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'e') goto yy334;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy334:
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy326;
		if(yych != 'n') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy327;
		if(yych != 't') goto yy144;
		yych = *++YYCURSOR;
		if(yych <= '^') {
			if(yych <= '/') {
				if(yych <= '.') goto yy53;
				goto yy138;
			} else {
				if(yych == 'H') goto yy159;
				goto yy53;
			}
		} else {
			if(yych <= 'g') {
				if(yych <= '_') goto yy138;
				if(yych <= '`') goto yy53;
				goto yy143;
			} else {
				if(yych <= 'h') goto yy241;
				if(yych <= 'z') goto yy143;
				goto yy53;
			}
		}
yy337:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'H') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'G') goto yy135;
				goto yy329;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'h') goto yy338;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy338:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'S') goto yy3;
				goto yy159;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 't') goto yy241;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy339:
		yych = *++YYCURSOR;
		if(yych <= 'D') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'C') goto yy134;
			}
		} else {
			if(yych <= 'c') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				goto yy134;
			} else {
				if(yych <= 'd') goto yy340;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy340:
		++YYCURSOR;
		if((yych = *YYCURSOR) <= 'N') {
			if(yych <= ')') {
				if(yych >= ')') goto yy132;
			} else {
				if(yych <= '@') goto yy341;
				if(yych <= 'M') goto yy135;
				goto yy342;
			}
		} else {
			if(yych <= 'm') {
				if(yych <= 'Z') goto yy135;
				if(yych >= 'a') goto yy135;
			} else {
				if(yych <= 'n') goto yy342;
				if(yych <= 'z') goto yy135;
			}
		}
yy341:
#line 1307 "parse_date.g.re"
		{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		s->time->relative.weekday_behavior = 1;
		
		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
#line 4647 "<stdout>"
yy342:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'E') goto yy343;
			if(yych != 'e') goto yy3;
		}
yy343:
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy344;
		if(yych != 's') goto yy53;
yy344:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy345;
		if(yych != 'd') goto yy53;
yy345:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy346;
		if(yych != 'a') goto yy53;
yy346:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy347;
		if(yych != 'y') goto yy53;
yy347:
		yych = *++YYCURSOR;
		goto yy341;
yy348:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'C') goto yy134;
				goto yy340;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy134;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'd') goto yy349;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy349:
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'N') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy341;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy341;
				if(yych <= 'M') goto yy135;
				goto yy342;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				if(yych == '_') goto yy138;
				goto yy341;
			} else {
				if(yych == 'n') goto yy350;
				if(yych <= 'z') goto yy142;
				goto yy341;
			}
		}
yy350:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'E') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'D') goto yy3;
				goto yy343;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'e') goto yy351;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy351:
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy344;
		if(yych != 's') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy345;
		if(yych != 'd') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy346;
		if(yych != 'a') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy347;
		if(yych != 'y') goto yy144;
yy355:
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '^') {
			if(yych == '/') goto yy138;
			goto yy341;
		} else {
			if(yych <= '_') goto yy138;
			if(yych <= '`') goto yy341;
			if(yych <= 'z') goto yy143;
			goto yy341;
		}
yy356:
		yych = *++YYCURSOR;
		if(yych <= 'C') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'B') goto yy134;
			}
		} else {
			if(yych <= 'b') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				goto yy134;
			} else {
				if(yych <= 'c') goto yy357;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy357:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy360,  &&yy359,  &&yy359,  &&yy359,  &&yy361,  &&yy359,  &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy359,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy366,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy366,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy358:
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 17) YYFILL(17);
		yych = *YYCURSOR;
yy359:
		if(yybm[0+yych] & 64) {
			goto yy358;
		}
		if(yych <= '/') goto yy53;
		if(yych <= '2') goto yy362;
		if(yych <= '3') goto yy364;
		if(yych <= '9') goto yy365;
		goto yy53;
yy360:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 0x1F) goto yy3;
		if(yych == '/') goto yy3;
		if(yych <= '9') goto yy359;
		goto yy3;
yy361:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy359;
		if(yych <= '0') goto yy440;
		if(yych <= '2') goto yy441;
		if(yych <= '3') goto yy442;
		goto yy359;
yy362:
		++YYCURSOR;
		if((yych = *YYCURSOR) <= 'm') {
			if(yych <= '1') {
				if(yych <= '/') goto yy378;
				goto yy422;
			} else {
				if(yych <= '2') goto yy439;
				if(yych <= '9') goto yy422;
				goto yy378;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'n') goto yy374;
				if(yych <= 'q') goto yy378;
				goto yy375;
			} else {
				if(yych <= 's') goto yy373;
				if(yych <= 't') goto yy376;
				goto yy378;
			}
		}
yy363:
#line 1126 "parse_date.g.re"
		{
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 4895 "<stdout>"
yy364:
		yych = *++YYCURSOR;
		if(yych <= 'm') {
			if(yych <= '1') {
				if(yych <= '/') goto yy378;
				goto yy422;
			} else {
				if(yych <= '2') goto yy371;
				if(yych <= '9') goto yy372;
				goto yy378;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'n') goto yy374;
				if(yych <= 'q') goto yy378;
				goto yy375;
			} else {
				if(yych <= 's') goto yy373;
				if(yych <= 't') goto yy376;
				goto yy378;
			}
		}
yy365:
		yych = *++YYCURSOR;
		if(yych <= 'm') {
			if(yych <= '1') {
				if(yych <= '/') goto yy378;
				goto yy370;
			} else {
				if(yych <= '2') goto yy371;
				if(yych <= '9') goto yy372;
				goto yy378;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'n') goto yy374;
				if(yych <= 'q') goto yy378;
				goto yy375;
			} else {
				if(yych <= 's') goto yy373;
				if(yych <= 't') goto yy376;
				goto yy378;
			}
		}
yy366:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'L') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'M') goto yy367;
			if(yych != 'm') goto yy3;
		}
yy367:
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy368;
		if(yych != 'b') goto yy53;
yy368:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy369;
		if(yych != 'e') goto yy53;
yy369:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy358;
		if(yych == 'r') goto yy358;
		goto yy53;
yy370:
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy383;
			goto yy363;
		} else {
			if(yych <= '9') goto yy421;
			if(yych <= ':') goto yy383;
			goto yy363;
		}
yy371:
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy383;
			goto yy363;
		} else {
			if(yych <= '3') goto yy421;
			if(yych <= '9') goto yy418;
			if(yych <= ':') goto yy383;
			goto yy363;
		}
yy372:
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy383;
			goto yy363;
		} else {
			if(yych <= '9') goto yy418;
			if(yych <= ':') goto yy383;
			goto yy363;
		}
yy373:
		yych = *++YYCURSOR;
		goto yy378;
yy374:
		yych = *++YYCURSOR;
		goto yy378;
yy375:
		yych = *++YYCURSOR;
		goto yy378;
yy376:
		yych = *++YYCURSOR;
		goto yy378;
yy377:
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 14) YYFILL(14);
		yych = *YYCURSOR;
yy378:
		if(yybm[0+yych] & 128) {
			goto yy377;
		}
		if(yych <= '/') goto yy363;
		if(yych <= '1') goto yy379;
		if(yych <= '2') goto yy380;
		if(yych <= '9') goto yy381;
		goto yy363;
yy379:
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy383;
			goto yy363;
		} else {
			if(yych <= '9') goto yy417;
			if(yych <= ':') goto yy383;
			goto yy363;
		}
yy380:
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy383;
			goto yy363;
		} else {
			if(yych <= '3') goto yy417;
			if(yych <= '9') goto yy382;
			if(yych <= ':') goto yy383;
			goto yy363;
		}
yy381:
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy383;
			goto yy363;
		} else {
			if(yych <= '9') goto yy382;
			if(yych <= ':') goto yy383;
			goto yy363;
		}
yy382:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy363;
		if(yych <= '9') goto yy415;
		goto yy363;
yy383:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy384;
		if(yych <= '9') goto yy386;
		goto yy53;
yy384:
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy387;
		} else {
			if(yych <= '9') goto yy386;
			if(yych <= ':') goto yy387;
		}
yy385:
#line 1351 "parse_date.g.re"
		{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			s->errors += tz_not_found;
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 5104 "<stdout>"
yy386:
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '.') goto yy387;
		if(yych != ':') goto yy385;
yy387:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy388;
		if(yych <= '6') goto yy389;
		if(yych <= '9') goto yy390;
		goto yy53;
yy388:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy385;
		if(yych <= '9') goto yy391;
		goto yy385;
yy389:
		yych = *++YYCURSOR;
		if(yych == '0') goto yy391;
		goto yy385;
yy390:
		yych = *++YYCURSOR;
		goto yy385;
yy391:
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '+') {
			if(yych <= '\'') {
				if(yych != ' ') goto yy385;
			} else {
				if(yych <= '(') goto yy395;
				if(yych <= '*') goto yy385;
				goto yy394;
			}
		} else {
			if(yych <= '@') {
				if(yych == '-') goto yy394;
				goto yy385;
			} else {
				if(yych <= 'Z') goto yy396;
				if(yych <= '`') goto yy385;
				if(yych <= 'z') goto yy397;
				goto yy385;
			}
		}
yy392:
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
		yych = *YYCURSOR;
		if(yych <= '+') {
			if(yych <= '\'') {
				if(yych == ' ') goto yy392;
				goto yy53;
			} else {
				if(yych <= '(') goto yy395;
				if(yych <= '*') goto yy53;
			}
		} else {
			if(yych <= '@') {
				if(yych != '-') goto yy53;
			} else {
				if(yych <= 'Z') goto yy396;
				if(yych <= '`') goto yy53;
				if(yych <= 'z') goto yy397;
				goto yy53;
			}
		}
yy394:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '1') goto yy410;
		if(yych <= '2') goto yy411;
		if(yych <= '9') goto yy412;
		goto yy53;
yy395:
		yych = *++YYCURSOR;
		if(yych <= '@') goto yy53;
		if(yych <= 'Z') goto yy397;
		if(yych <= '`') goto yy53;
		if(yych <= 'z') goto yy397;
		goto yy53;
yy396:
		yych = *++YYCURSOR;
		if(yych <= '@') {
			if(yych == ')') goto yy390;
			goto yy385;
		} else {
			if(yych <= 'Z') goto yy398;
			if(yych <= '`') goto yy385;
			if(yych <= 'z') goto yy401;
			goto yy385;
		}
yy397:
		yych = *++YYCURSOR;
		if(yych <= '@') {
			if(yych == ')') goto yy390;
			goto yy385;
		} else {
			if(yych <= 'Z') goto yy398;
			if(yych <= '`') goto yy385;
			if(yych >= '{') goto yy385;
		}
yy398:
		yych = *++YYCURSOR;
		if(yych <= '@') {
			if(yych == ')') goto yy390;
			goto yy385;
		} else {
			if(yych <= 'Z') goto yy399;
			if(yych <= '`') goto yy385;
			if(yych >= '{') goto yy385;
		}
yy399:
		yych = *++YYCURSOR;
		if(yych <= '@') {
			if(yych == ')') goto yy390;
			goto yy385;
		} else {
			if(yych <= 'Z') goto yy400;
			if(yych <= '`') goto yy385;
			if(yych >= '{') goto yy385;
		}
yy400:
		yych = *++YYCURSOR;
		if(yych == ')') goto yy390;
		goto yy385;
yy401:
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych <= ')') {
				if(yych <= '(') goto yy385;
				goto yy390;
			} else {
				if(yych == '/') goto yy403;
				goto yy385;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy399;
				if(yych <= '^') goto yy385;
				goto yy403;
			} else {
				if(yych <= '`') goto yy385;
				if(yych >= '{') goto yy385;
			}
		}
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych <= ')') {
				if(yych <= '(') goto yy385;
				goto yy390;
			} else {
				if(yych != '/') goto yy385;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy400;
				if(yych <= '^') goto yy385;
			} else {
				if(yych <= '`') goto yy385;
				if(yych <= 'z') goto yy407;
				goto yy385;
			}
		}
yy403:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= '@') goto yy53;
		if(yych >= '[') goto yy53;
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= '`') goto yy53;
		if(yych >= '{') goto yy53;
yy405:
		yyaccept = 7;
		YYMARKER = ++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= '^') {
			if(yych == '/') goto yy403;
			goto yy385;
		} else {
			if(yych <= '_') goto yy403;
			if(yych <= '`') goto yy385;
			if(yych <= 'z') goto yy405;
			goto yy385;
		}
yy407:
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == ')') goto yy390;
			if(yych <= '.') goto yy385;
			goto yy403;
		} else {
			if(yych <= '_') {
				if(yych <= '^') goto yy385;
				goto yy403;
			} else {
				if(yych <= '`') goto yy385;
				if(yych >= '{') goto yy385;
			}
		}
yy408:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= '^') {
			if(yych == '/') goto yy403;
			goto yy53;
		} else {
			if(yych <= '_') goto yy403;
			if(yych <= '`') goto yy53;
			if(yych <= 'z') goto yy408;
			goto yy53;
		}
yy410:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy385;
		if(yych <= '9') goto yy412;
		if(yych <= ':') goto yy413;
		goto yy385;
yy411:
		yych = *++YYCURSOR;
		if(yych <= '5') {
			if(yych <= '/') goto yy385;
			if(yych >= '4') goto yy414;
		} else {
			if(yych <= '9') goto yy390;
			if(yych <= ':') goto yy413;
			goto yy385;
		}
yy412:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy385;
		if(yych <= '5') goto yy414;
		if(yych <= '9') goto yy390;
		if(yych >= ';') goto yy385;
yy413:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy385;
		if(yych <= '5') goto yy414;
		if(yych <= '9') goto yy390;
		goto yy385;
yy414:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy385;
		if(yych <= '9') goto yy390;
		goto yy385;
yy415:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy363;
		if(yych >= ':') goto yy363;
yy416:
		yych = *++YYCURSOR;
		goto yy363;
yy417:
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy383;
			goto yy363;
		} else {
			if(yych <= '9') goto yy415;
			if(yych <= ':') goto yy383;
			goto yy363;
		}
yy418:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy363;
		if(yych >= ':') goto yy363;
yy419:
		++YYCURSOR;
		if((yych = *YYCURSOR) <= '/') goto yy420;
		if(yych <= '9') goto yy416;
yy420:
#line 1100 "parse_date.g.re"
		{
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 5398 "<stdout>"
yy421:
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy383;
			goto yy363;
		} else {
			if(yych <= '9') goto yy419;
			if(yych <= ':') goto yy383;
			goto yy363;
		}
yy422:
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ':') {
			if(yych <= '/') {
				if(yych != '.') goto yy378;
			} else {
				if(yych <= '1') goto yy424;
				if(yych <= '2') goto yy425;
				if(yych <= '9') goto yy426;
				goto yy383;
			}
		} else {
			if(yych <= 'q') {
				if(yych == 'n') goto yy374;
				goto yy378;
			} else {
				if(yych <= 'r') goto yy375;
				if(yych <= 's') goto yy373;
				if(yych <= 't') goto yy376;
				goto yy378;
			}
		}
yy423:
		yych = *++YYCURSOR;
		if(yych <= '2') {
			if(yych <= '/') goto yy378;
			if(yych <= '1') goto yy429;
			goto yy430;
		} else {
			if(yych <= '5') goto yy431;
			if(yych <= '9') goto yy432;
			goto yy378;
		}
yy424:
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy383;
			goto yy363;
		} else {
			if(yych <= '9') goto yy428;
			if(yych <= ':') goto yy383;
			goto yy363;
		}
yy425:
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy383;
			goto yy363;
		} else {
			if(yych <= '3') goto yy428;
			if(yych <= '9') goto yy427;
			if(yych <= ':') goto yy383;
			goto yy363;
		}
yy426:
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy383;
			goto yy363;
		} else {
			if(yych <= '9') goto yy427;
			if(yych <= ':') goto yy383;
			goto yy363;
		}
yy427:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy420;
		if(yych <= '9') goto yy415;
		goto yy420;
yy428:
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy383;
			goto yy420;
		} else {
			if(yych <= '9') goto yy415;
			if(yych <= ':') goto yy383;
			goto yy420;
		}
yy429:
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy433;
			goto yy363;
		} else {
			if(yych <= '9') goto yy438;
			if(yych <= ':') goto yy433;
			goto yy363;
		}
yy430:
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy433;
			goto yy363;
		} else {
			if(yych <= '3') goto yy438;
			if(yych <= '9') goto yy437;
			if(yych <= ':') goto yy433;
			goto yy363;
		}
yy431:
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy433;
			goto yy363;
		} else {
			if(yych <= '9') goto yy437;
			if(yych <= ':') goto yy433;
			goto yy363;
		}
yy432:
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych != '.') goto yy363;
		} else {
			if(yych <= '9') goto yy382;
			if(yych >= ';') goto yy363;
		}
yy433:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy434;
		if(yych <= '6') goto yy435;
		if(yych <= '9') goto yy386;
		goto yy53;
yy434:
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy387;
			goto yy385;
		} else {
			if(yych <= '9') goto yy436;
			if(yych <= ':') goto yy387;
			goto yy385;
		}
yy435:
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy387;
			goto yy385;
		} else {
			if(yych <= '0') goto yy391;
			if(yych == ':') goto yy387;
			goto yy385;
		}
yy436:
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,
				&&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,
				&&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,
				&&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,
				&&yy392,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,
				&&yy395,  &&yy385,  &&yy385,  &&yy394,  &&yy385,  &&yy394,  &&yy387,  &&yy385,
				&&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,
				&&yy385,  &&yy385,  &&yy387,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,
				&&yy385,  &&yy396,  &&yy396,  &&yy396,  &&yy396,  &&yy396,  &&yy396,  &&yy396,
				&&yy396,  &&yy396,  &&yy396,  &&yy396,  &&yy396,  &&yy396,  &&yy396,  &&yy396,
				&&yy396,  &&yy396,  &&yy396,  &&yy396,  &&yy396,  &&yy396,  &&yy396,  &&yy396,
				&&yy396,  &&yy396,  &&yy396,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,
				&&yy385,  &&yy397,  &&yy397,  &&yy397,  &&yy397,  &&yy397,  &&yy397,  &&yy397,
				&&yy397,  &&yy397,  &&yy397,  &&yy397,  &&yy397,  &&yy397,  &&yy397,  &&yy397,
				&&yy397,  &&yy397,  &&yy397,  &&yy397,  &&yy397,  &&yy397,  &&yy397,  &&yy397,
				&&yy397,  &&yy397,  &&yy397,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,
				&&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,
				&&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,
				&&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,
				&&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,
				&&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,
				&&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,
				&&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,
				&&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,
				&&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,
				&&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,
				&&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,
				&&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,
				&&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,
				&&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,
				&&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,
				&&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385,  &&yy385
			};
			goto *yytarget[yych];
		}
yy437:
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy387;
			goto yy363;
		} else {
			if(yych <= '9') goto yy415;
			if(yych <= ':') goto yy387;
			goto yy363;
		}
yy438:
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy433;
			goto yy363;
		} else {
			if(yych <= '9') goto yy415;
			if(yych <= ':') goto yy433;
			goto yy363;
		}
yy439:
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ':') {
			if(yych <= '/') {
				if(yych == '.') goto yy423;
				goto yy378;
			} else {
				if(yych <= '1') goto yy424;
				if(yych <= '2') goto yy425;
				if(yych <= '9') goto yy426;
				goto yy383;
			}
		} else {
			if(yych <= 'q') {
				if(yych == 'n') goto yy374;
				goto yy378;
			} else {
				if(yych <= 'r') goto yy375;
				if(yych <= 's') goto yy373;
				if(yych <= 't') goto yy376;
				goto yy378;
			}
		}
yy440:
		yych = *++YYCURSOR;
		if(yych <= 'm') {
			if(yych <= '1') {
				if(yych <= '/') goto yy378;
				if(yych <= '0') goto yy422;
				goto yy443;
			} else {
				if(yych <= '2') goto yy450;
				if(yych <= '9') goto yy443;
				goto yy378;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'n') goto yy374;
				if(yych <= 'q') goto yy378;
				goto yy375;
			} else {
				if(yych <= 's') goto yy373;
				if(yych <= 't') goto yy376;
				goto yy378;
			}
		}
yy441:
		yych = *++YYCURSOR;
		if(yych <= 'm') {
			if(yych <= '1') {
				if(yych <= '/') goto yy378;
				goto yy443;
			} else {
				if(yych <= '2') goto yy450;
				if(yych <= '9') goto yy443;
				goto yy378;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'n') goto yy374;
				if(yych <= 'q') goto yy378;
				goto yy375;
			} else {
				if(yych <= 's') goto yy373;
				if(yych <= 't') goto yy376;
				goto yy378;
			}
		}
yy442:
		yych = *++YYCURSOR;
		if(yych <= 'm') {
			if(yych <= '1') {
				if(yych <= '/') goto yy378;
			} else {
				if(yych <= '2') goto yy371;
				if(yych <= '9') goto yy372;
				goto yy378;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'n') goto yy374;
				if(yych <= 'q') goto yy378;
				goto yy375;
			} else {
				if(yych <= 's') goto yy373;
				if(yych <= 't') goto yy376;
				goto yy378;
			}
		}
yy443:
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= '.') {
				if(yych <= ',') goto yy378;
				if(yych >= '.') goto yy423;
			} else {
				if(yych <= '/') goto yy378;
				if(yych <= '1') goto yy424;
				if(yych <= '2') goto yy425;
				goto yy426;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= ':') goto yy383;
				if(yych == 'n') goto yy374;
				goto yy378;
			} else {
				if(yych <= 'r') goto yy375;
				if(yych <= 's') goto yy373;
				if(yych <= 't') goto yy376;
				goto yy378;
			}
		}
yy444:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
		++YYCURSOR;
		if((yych = *YYCURSOR) <= '/') goto yy446;
		if(yych <= '9') goto yy447;
yy446:
#line 1238 "parse_date.g.re"
		{
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 5763 "<stdout>"
yy447:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy446;
		if(yych >= ':') goto yy446;
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy446;
		if(yych >= ':') goto yy446;
		yych = *++YYCURSOR;
		goto yy446;
yy450:
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= '.') {
				if(yych <= ',') goto yy378;
				if(yych <= '-') goto yy444;
				goto yy423;
			} else {
				if(yych <= '/') goto yy378;
				if(yych <= '1') goto yy424;
				if(yych <= '2') goto yy425;
				goto yy426;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= ':') goto yy383;
				if(yych == 'n') goto yy374;
				goto yy378;
			} else {
				if(yych <= 'r') goto yy375;
				if(yych <= 's') goto yy373;
				if(yych <= 't') goto yy376;
				goto yy378;
			}
		}
yy451:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'C') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'B') goto yy134;
				goto yy357;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy134;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'c') goto yy452;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy452:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy360,  &&yy359,  &&yy359,  &&yy359,  &&yy361,  &&yy359,  &&yy138,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy359,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy366,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy453,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy453:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'M') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'L') goto yy3;
				goto yy367;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'm') goto yy454;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy454:
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy368;
		if(yych != 'b') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy369;
		if(yych != 'e') goto yy144;
		yych = *++YYCURSOR;
		if(yych <= '^') {
			if(yych <= '/') {
				if(yych <= '.') goto yy53;
				goto yy138;
			} else {
				if(yych == 'R') goto yy358;
				goto yy53;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= '_') goto yy138;
				if(yych <= '`') goto yy53;
				goto yy143;
			} else {
				if(yych <= 'r') goto yy457;
				if(yych <= 'z') goto yy143;
				goto yy53;
			}
		}
yy457:
		yych = *++YYCURSOR;
		if(yych <= '^') {
			if(yych == '/') goto yy138;
			goto yy359;
		} else {
			if(yych <= '_') goto yy138;
			if(yych <= '`') goto yy359;
			if(yych <= 'z') goto yy143;
			goto yy359;
		}
yy458:
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy134;
			}
		} else {
			if(yych <= 's') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				goto yy134;
			} else {
				if(yych <= 't') goto yy459;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy459:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy360,  &&yy359,  &&yy359,  &&yy359,  &&yy361,  &&yy359,  &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy359,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy460,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy460,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy460:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'A') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'B') goto yy461;
			if(yych != 'b') goto yy3;
		}
yy461:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy462;
		if(yych != 'e') goto yy53;
yy462:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy358;
		if(yych == 'r') goto yy358;
		goto yy53;
yy463:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy134;
				goto yy459;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy134;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 't') goto yy464;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy464:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy360,  &&yy359,  &&yy359,  &&yy359,  &&yy361,  &&yy359,  &&yy138,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy359,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy460,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy465,
				&&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy465:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'B') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'A') goto yy3;
				goto yy461;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'b') goto yy466;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy466:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy462;
		if(yych != 'e') goto yy144;
		yych = *++YYCURSOR;
		if(yych <= '^') {
			if(yych <= '/') {
				if(yych <= '.') goto yy53;
				goto yy138;
			} else {
				if(yych == 'R') goto yy358;
				goto yy53;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= '_') goto yy138;
				if(yych <= '`') goto yy53;
				goto yy143;
			} else {
				if(yych <= 'r') goto yy457;
				if(yych <= 'z') goto yy143;
				goto yy53;
			}
		}
yy468:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy132,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy134,  &&yy134,  &&yy483,  &&yy134,  &&yy134,  &&yy134,  &&yy134,
				&&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,
				&&yy482,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy484,  &&yy134,
				&&yy134,  &&yy134,  &&yy134,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy134,  &&yy134,  &&yy483,  &&yy134,  &&yy134,  &&yy134,  &&yy134,
				&&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,
				&&yy482,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy484,  &&yy134,
				&&yy134,  &&yy134,  &&yy134,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy469:
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy134;
				goto yy477;
			}
		} else {
			if(yych <= 's') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				goto yy134;
			} else {
				if(yych <= 't') goto yy477;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy470:
		yych = *++YYCURSOR;
		if(yych <= 'X') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'W') goto yy134;
				goto yy475;
			}
		} else {
			if(yych <= 'w') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				goto yy134;
			} else {
				if(yych <= 'x') goto yy475;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy471:
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy134;
			}
		} else {
			if(yych <= 'm') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				goto yy134;
			} else {
				if(yych <= 'n') goto yy472;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy472:
		yych = *++YYCURSOR;
		if(yych <= 'D') {
			if(yych <= ')') {
				if(yych <= '(') goto yy341;
				goto yy132;
			} else {
				if(yych <= '@') goto yy341;
				if(yych <= 'C') goto yy135;
			}
		} else {
			if(yych <= 'c') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy341;
				goto yy135;
			} else {
				if(yych <= 'd') goto yy473;
				if(yych <= 'z') goto yy135;
				goto yy341;
			}
		}
yy473:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'A') goto yy474;
			if(yych != 'a') goto yy3;
		}
yy474:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy347;
		if(yych == 'y') goto yy347;
		goto yy53;
yy475:
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy135;
			}
		} else {
			if(yych <= 's') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy3;
				goto yy135;
			} else {
				if(yych <= 't') goto yy476;
				if(yych <= 'z') goto yy135;
				goto yy3;
			}
		}
yy476:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'G') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'H') goto yy159;
			if(yych == 'h') goto yy159;
			goto yy3;
		}
yy477:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych <= ')') {
				if(yych <= '(') goto yy341;
				goto yy132;
			} else {
				if(yych <= '@') goto yy341;
				if(yych <= 'T') goto yy135;
			}
		} else {
			if(yych <= 't') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy341;
				goto yy135;
			} else {
				if(yych <= 'u') goto yy478;
				if(yych <= 'z') goto yy135;
				goto yy341;
			}
		}
yy478:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'Q') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'R') goto yy479;
			if(yych != 'r') goto yy3;
		}
yy479:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy480;
		if(yych != 'd') goto yy53;
yy480:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy481;
		if(yych != 'a') goto yy53;
yy481:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy347;
		if(yych == 'y') goto yy347;
		goto yy53;
yy482:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy360,  &&yy359,  &&yy359,  &&yy359,  &&yy361,  &&yy359,  &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy359,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy490,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy490,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy483:
		yych = *++YYCURSOR;
		if(yych <= 'O') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'N') goto yy135;
				goto yy488;
			}
		} else {
			if(yych <= 'n') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy3;
				goto yy135;
			} else {
				if(yych <= 'o') goto yy488;
				if(yych <= 'z') goto yy135;
				goto yy3;
			}
		}
yy484:
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy135;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy3;
				goto yy135;
			} else {
				if(yych <= 'e') goto yy485;
				if(yych <= 'z') goto yy135;
				goto yy3;
			}
		}
yy485:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'M') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'N') goto yy486;
			if(yych != 'n') goto yy3;
		}
yy486:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy487;
		if(yych != 't') goto yy53;
yy487:
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy159;
		if(yych == 'h') goto yy159;
		goto yy53;
yy488:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'M') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'N') goto yy489;
			if(yych != 'n') goto yy3;
		}
yy489:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy159;
		if(yych == 'd') goto yy159;
		goto yy53;
yy490:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= ')') {
				if(yych <= 0x1F) goto yy3;
				if(yych <= '(') goto yy359;
				goto yy360;
			} else {
				if(yych == '-') goto yy361;
				goto yy359;
			}
		} else {
			if(yych <= 'D') {
				if(yych <= '/') goto yy3;
				if(yych <= '9') goto yy359;
				goto yy3;
			} else {
				if(yych <= 'E') goto yy491;
				if(yych != 'e') goto yy3;
			}
		}
yy491:
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy492;
		if(yych != 'm') goto yy53;
yy492:
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy493;
		if(yych != 'b') goto yy53;
yy493:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy494;
		if(yych != 'e') goto yy53;
yy494:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy358;
		if(yych == 'r') goto yy358;
		goto yy53;
yy495:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy132,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy134,  &&yy134,  &&yy483,  &&yy134,  &&yy134,  &&yy134,  &&yy134,
				&&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,
				&&yy482,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy484,  &&yy134,
				&&yy134,  &&yy134,  &&yy134,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy137,  &&yy137,  &&yy510,  &&yy137,  &&yy137,  &&yy137,  &&yy137,
				&&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,
				&&yy509,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy511,  &&yy137,
				&&yy137,  &&yy137,  &&yy137,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy496:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy134;
				goto yy477;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy134;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 't') goto yy504;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy497:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'X') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'W') goto yy134;
				goto yy475;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy134;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'x') goto yy502;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy498:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'N') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy134;
				goto yy472;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy134;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'n') goto yy499;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy499:
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy341;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy341;
				if(yych <= 'C') goto yy135;
				goto yy473;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				if(yych == '_') goto yy138;
				goto yy341;
			} else {
				if(yych == 'd') goto yy500;
				if(yych <= 'z') goto yy142;
				goto yy341;
			}
		}
yy500:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'A') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				goto yy474;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych <= 'a') goto yy501;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy501:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy347;
		if(yych == 'y') goto yy355;
		goto yy144;
yy502:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy135;
				goto yy476;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 't') goto yy503;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy503:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'H') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'G') goto yy3;
				goto yy159;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'h') goto yy241;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy504:
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'U') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy341;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy341;
				if(yych <= 'T') goto yy135;
				goto yy478;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				if(yych == '_') goto yy138;
				goto yy341;
			} else {
				if(yych == 'u') goto yy505;
				if(yych <= 'z') goto yy142;
				goto yy341;
			}
		}
yy505:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'R') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'Q') goto yy3;
				goto yy479;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'r') goto yy506;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy506:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy480;
		if(yych != 'd') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy481;
		if(yych != 'a') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy347;
		if(yych == 'y') goto yy355;
		goto yy144;
yy509:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy360,  &&yy359,  &&yy359,  &&yy359,  &&yy361,  &&yy359,  &&yy138,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy359,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy490,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy517,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy510:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'O') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'N') goto yy135;
				goto yy488;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'o') goto yy515;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy511:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'E') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy135;
				goto yy485;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'e') goto yy512;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy512:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'N') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'M') goto yy3;
				goto yy486;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'n') goto yy513;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy513:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy487;
		if(yych != 't') goto yy144;
		yych = *++YYCURSOR;
		if(yych <= '^') {
			if(yych <= '/') {
				if(yych <= '.') goto yy53;
				goto yy138;
			} else {
				if(yych == 'H') goto yy159;
				goto yy53;
			}
		} else {
			if(yych <= 'g') {
				if(yych <= '_') goto yy138;
				if(yych <= '`') goto yy53;
				goto yy143;
			} else {
				if(yych <= 'h') goto yy241;
				if(yych <= 'z') goto yy143;
				goto yy53;
			}
		}
yy515:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'N') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'M') goto yy3;
				goto yy489;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'n') goto yy516;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy516:
		yych = *++YYCURSOR;
		if(yych <= '^') {
			if(yych <= '/') {
				if(yych <= '.') goto yy53;
				goto yy138;
			} else {
				if(yych == 'D') goto yy159;
				goto yy53;
			}
		} else {
			if(yych <= 'c') {
				if(yych <= '_') goto yy138;
				if(yych <= '`') goto yy53;
				goto yy143;
			} else {
				if(yych <= 'd') goto yy241;
				if(yych <= 'z') goto yy143;
				goto yy53;
			}
		}
yy517:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy360,  &&yy359,  &&yy359,  &&yy359,  &&yy361,  &&yy359,  &&yy138,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy359,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy491,  &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy143,  &&yy143,  &&yy143,  &&yy143,  &&yy518,  &&yy143,  &&yy143,
				&&yy143,  &&yy143,  &&yy143,  &&yy143,  &&yy143,  &&yy143,  &&yy143,  &&yy143,
				&&yy143,  &&yy143,  &&yy143,  &&yy143,  &&yy143,  &&yy143,  &&yy143,  &&yy143,
				&&yy143,  &&yy143,  &&yy143,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy518:
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy492;
		if(yych != 'm') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy493;
		if(yych != 'b') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy494;
		if(yych != 'e') goto yy144;
		yych = *++YYCURSOR;
		if(yych <= '^') {
			if(yych <= '/') {
				if(yych <= '.') goto yy53;
				goto yy138;
			} else {
				if(yych == 'R') goto yy358;
				goto yy53;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= '_') goto yy138;
				if(yych <= '`') goto yy53;
				goto yy143;
			} else {
				if(yych <= 'r') goto yy457;
				if(yych <= 'z') goto yy143;
				goto yy53;
			}
		}
yy522:
		yych = *++YYCURSOR;
		if(yych <= 'G') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'F') goto yy134;
				goto yy529;
			}
		} else {
			if(yych <= 'f') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				goto yy134;
			} else {
				if(yych <= 'g') goto yy529;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy523:
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'Q') goto yy134;
				goto yy527;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				goto yy134;
			} else {
				if(yych <= 'r') goto yy527;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy524:
		yych = *++YYCURSOR;
		if(yych <= 'O') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'N') goto yy134;
			}
		} else {
			if(yych <= 'n') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				goto yy134;
			} else {
				if(yych <= 'o') goto yy525;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy525:
		++YYCURSOR;
		if((yych = *YYCURSOR) <= '@') {
			if(yych == ')') goto yy132;
		} else {
			if(yych <= 'Z') goto yy135;
			if(yych <= '`') goto yy526;
			if(yych <= 'z') goto yy135;
		}
yy526:
#line 1292 "parse_date.g.re"
		{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
#line 7087 "<stdout>"
yy527:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy360,  &&yy359,  &&yy359,  &&yy359,  &&yy361,  &&yy359,  &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy359,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy528,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy528,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy528:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'K') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'L') goto yy358;
			if(yych == 'l') goto yy358;
			goto yy3;
		}
yy529:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy360,  &&yy359,  &&yy359,  &&yy359,  &&yy361,  &&yy359,  &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy359,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy530,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy530,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy530:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'R') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'S') goto yy531;
			if(yych != 's') goto yy3;
		}
yy531:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy358;
		if(yych == 't') goto yy358;
		goto yy53;
yy532:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'G') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'F') goto yy134;
				goto yy529;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy134;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'g') goto yy538;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy533:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'R') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'Q') goto yy134;
				goto yy527;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy134;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'r') goto yy536;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy534:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'O') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'N') goto yy134;
				goto yy525;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy134;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'o') goto yy535;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy535:
		yyaccept = 9;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych <= ')') {
				if(yych <= '(') goto yy526;
				goto yy132;
			} else {
				if(yych == '/') goto yy138;
				goto yy526;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '^') goto yy526;
				goto yy138;
			} else {
				if(yych <= '`') goto yy526;
				if(yych <= 'z') goto yy142;
				goto yy526;
			}
		}
yy536:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy360,  &&yy359,  &&yy359,  &&yy359,  &&yy361,  &&yy359,  &&yy138,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy359,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy528,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy537,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy537:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'L') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'K') goto yy3;
				goto yy358;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'l') goto yy457;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy538:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy360,  &&yy359,  &&yy359,  &&yy359,  &&yy361,  &&yy359,  &&yy138,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy359,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy530,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy539,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy539:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'R') goto yy3;
				goto yy531;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 's') goto yy540;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy540:
		yych = *++YYCURSOR;
		if(yych <= '^') {
			if(yych <= '/') {
				if(yych <= '.') goto yy53;
				goto yy138;
			} else {
				if(yych == 'T') goto yy358;
				goto yy53;
			}
		} else {
			if(yych <= 's') {
				if(yych <= '_') goto yy138;
				if(yych <= '`') goto yy53;
				goto yy143;
			} else {
				if(yych <= 't') goto yy457;
				if(yych <= 'z') goto yy143;
				goto yy53;
			}
		}
yy541:
		yych = *++YYCURSOR;
		if(yych <= 'B') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'A') goto yy134;
				goto yy555;
			}
		} else {
			if(yych <= 'a') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				goto yy134;
			} else {
				if(yych <= 'b') goto yy555;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy542:
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych <= '@') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych == 'F') goto yy552;
				if(yych <= 'Q') goto yy134;
				goto yy551;
			}
		} else {
			if(yych <= 'f') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				if(yych <= 'e') goto yy134;
				goto yy552;
			} else {
				if(yych == 'r') goto yy551;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy543:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'T') goto yy134;
				goto yy548;
			}
		} else {
			if(yych <= 't') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				goto yy134;
			} else {
				if(yych <= 'u') goto yy548;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy544:
		yych = *++YYCURSOR;
		if(yych <= 'I') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'H') goto yy134;
			}
		} else {
			if(yych <= 'h') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				goto yy134;
			} else {
				if(yych <= 'i') goto yy545;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy545:
		yych = *++YYCURSOR;
		if(yych <= 'D') {
			if(yych <= ')') {
				if(yych <= '(') goto yy341;
				goto yy132;
			} else {
				if(yych <= '@') goto yy341;
				if(yych <= 'C') goto yy135;
			}
		} else {
			if(yych <= 'c') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy341;
				goto yy135;
			} else {
				if(yych <= 'd') goto yy546;
				if(yych <= 'z') goto yy135;
				goto yy341;
			}
		}
yy546:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'A') goto yy547;
			if(yych != 'a') goto yy3;
		}
yy547:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy347;
		if(yych == 'y') goto yy347;
		goto yy53;
yy548:
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'Q') goto yy135;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy3;
				goto yy135;
			} else {
				if(yych <= 'r') goto yy549;
				if(yych <= 'z') goto yy135;
				goto yy3;
			}
		}
yy549:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'T') goto yy550;
			if(yych != 't') goto yy3;
		}
yy550:
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy159;
		if(yych == 'h') goto yy159;
		goto yy53;
yy551:
		yych = *++YYCURSOR;
		if(yych <= 'S') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'R') goto yy135;
				goto yy554;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy3;
				goto yy135;
			} else {
				if(yych <= 's') goto yy554;
				if(yych <= 'z') goto yy135;
				goto yy3;
			}
		}
yy552:
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy135;
			}
		} else {
			if(yych <= 's') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy3;
				goto yy135;
			} else {
				if(yych <= 't') goto yy553;
				if(yych <= 'z') goto yy135;
				goto yy3;
			}
		}
yy553:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'G') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'H') goto yy159;
			if(yych == 'h') goto yy159;
			goto yy3;
		}
yy554:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'T') goto yy159;
			if(yych == 't') goto yy159;
			goto yy3;
		}
yy555:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy360,  &&yy359,  &&yy359,  &&yy359,  &&yy361,  &&yy359,  &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy359,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy556,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy556,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy556:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'U') goto yy557;
			if(yych != 'u') goto yy3;
		}
yy557:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy558;
		if(yych != 'a') goto yy53;
yy558:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy559;
		if(yych != 'r') goto yy53;
yy559:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy358;
		if(yych == 'y') goto yy358;
		goto yy53;
yy560:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'B') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'A') goto yy134;
				goto yy555;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy134;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'b') goto yy574;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy561:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy132,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy552,  &&yy134,
				&&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,
				&&yy134,  &&yy134,  &&yy551,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,
				&&yy134,  &&yy134,  &&yy134,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy571,  &&yy137,
				&&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,
				&&yy137,  &&yy137,  &&yy570,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,
				&&yy137,  &&yy137,  &&yy137,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy562:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'U') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'T') goto yy134;
				goto yy548;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy134;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'u') goto yy567;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy563:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'I') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'H') goto yy134;
				goto yy545;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy134;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'i') goto yy564;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy564:
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy341;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy341;
				if(yych <= 'C') goto yy135;
				goto yy546;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				if(yych == '_') goto yy138;
				goto yy341;
			} else {
				if(yych == 'd') goto yy565;
				if(yych <= 'z') goto yy142;
				goto yy341;
			}
		}
yy565:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'A') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				goto yy547;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych <= 'a') goto yy566;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy566:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy347;
		if(yych == 'y') goto yy355;
		goto yy144;
yy567:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'R') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'Q') goto yy135;
				goto yy549;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'r') goto yy568;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy568:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'S') goto yy3;
				goto yy550;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 't') goto yy569;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy569:
		yych = *++YYCURSOR;
		if(yych <= '^') {
			if(yych <= '/') {
				if(yych <= '.') goto yy53;
				goto yy138;
			} else {
				if(yych == 'H') goto yy159;
				goto yy53;
			}
		} else {
			if(yych <= 'g') {
				if(yych <= '_') goto yy138;
				if(yych <= '`') goto yy53;
				goto yy143;
			} else {
				if(yych <= 'h') goto yy241;
				if(yych <= 'z') goto yy143;
				goto yy53;
			}
		}
yy570:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'R') goto yy135;
				goto yy554;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 's') goto yy573;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy571:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy135;
				goto yy553;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 't') goto yy572;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy572:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'H') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'G') goto yy3;
				goto yy159;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'h') goto yy241;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy573:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'S') goto yy3;
				goto yy159;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 't') goto yy241;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy574:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy360,  &&yy359,  &&yy359,  &&yy359,  &&yy361,  &&yy359,  &&yy138,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy359,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy556,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy575,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy575:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'U') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'T') goto yy3;
				goto yy557;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'u') goto yy576;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy576:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy558;
		if(yych != 'a') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy559;
		if(yych != 'r') goto yy144;
		yych = *++YYCURSOR;
		if(yych <= '^') {
			if(yych <= '/') {
				if(yych <= '.') goto yy53;
				goto yy138;
			} else {
				if(yych == 'Y') goto yy358;
				goto yy53;
			}
		} else {
			if(yych <= 'x') {
				if(yych <= '_') goto yy138;
				if(yych <= '`') goto yy53;
				goto yy143;
			} else {
				if(yych <= 'y') goto yy457;
				if(yych <= 'z') goto yy143;
				goto yy53;
			}
		}
yy579:
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych <= '@') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych == 'L') goto yy586;
				if(yych <= 'M') goto yy134;
				goto yy585;
			}
		} else {
			if(yych <= 'l') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				if(yych <= 'k') goto yy134;
				goto yy586;
			} else {
				if(yych == 'n') goto yy585;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy580:
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy134;
			}
		} else {
			if(yych <= 'm') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				goto yy134;
			} else {
				if(yych <= 'n') goto yy581;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy581:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy360,  &&yy359,  &&yy359,  &&yy359,  &&yy361,  &&yy359,  &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy359,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy582,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy582,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy582:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'A') goto yy583;
			if(yych != 'a') goto yy3;
		}
yy583:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy584;
		if(yych != 'r') goto yy53;
yy584:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy358;
		if(yych == 'y') goto yy358;
		goto yy53;
yy585:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy360,  &&yy359,  &&yy359,  &&yy359,  &&yy361,  &&yy359,  &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy359,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy587,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy587,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy586:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy360,  &&yy359,  &&yy359,  &&yy359,  &&yy361,  &&yy359,  &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy359,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy587,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy587,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy587:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ')') {
			if(yych <= 0x1F) goto yy3;
			if(yych <= '(') goto yy359;
			goto yy360;
		} else {
			if(yych == '/') goto yy3;
			if(yych <= '9') goto yy359;
			goto yy3;
		}
yy588:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy132,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,
				&&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy586,  &&yy134,  &&yy585,  &&yy134,
				&&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,
				&&yy134,  &&yy134,  &&yy134,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,
				&&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy595,  &&yy137,  &&yy594,  &&yy137,
				&&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,
				&&yy137,  &&yy137,  &&yy137,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy589:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'N') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy134;
				goto yy581;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy134;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'n') goto yy590;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy590:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy360,  &&yy359,  &&yy359,  &&yy359,  &&yy361,  &&yy359,  &&yy138,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy359,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy582,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy591,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy591:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'A') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				goto yy583;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych <= 'a') goto yy592;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy592:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy584;
		if(yych != 'r') goto yy144;
		yych = *++YYCURSOR;
		if(yych <= '^') {
			if(yych <= '/') {
				if(yych <= '.') goto yy53;
				goto yy138;
			} else {
				if(yych == 'Y') goto yy358;
				goto yy53;
			}
		} else {
			if(yych <= 'x') {
				if(yych <= '_') goto yy138;
				if(yych <= '`') goto yy53;
				goto yy143;
			} else {
				if(yych <= 'y') goto yy457;
				if(yych <= 'z') goto yy143;
				goto yy53;
			}
		}
yy594:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy360,  &&yy359,  &&yy359,  &&yy359,  &&yy361,  &&yy359,  &&yy138,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy359,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy587,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy596,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy595:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy360,  &&yy359,  &&yy359,  &&yy359,  &&yy361,  &&yy359,  &&yy138,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy359,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy587,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy596,  &&yy142,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy596:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= '(') {
				if(yych <= 0x1F) goto yy3;
				goto yy359;
			} else {
				if(yych <= ')') goto yy360;
				if(yych <= '.') goto yy359;
				goto yy138;
			}
		} else {
			if(yych <= '_') {
				if(yych <= '9') goto yy359;
				if(yych <= '^') goto yy3;
				goto yy138;
			} else {
				if(yych <= '`') goto yy3;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy597:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= ')') {
				if(yych <= 0x1F) goto yy3;
				if(yych <= '(') goto yy359;
				goto yy360;
			} else {
				if(yych == '/') goto yy3;
				goto yy359;
			}
		} else {
			if(yych <= 'I') {
				if(yych <= '@') goto yy3;
				if(yych <= 'H') goto yy134;
			} else {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy598:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= '(') {
				if(yych <= 0x1F) goto yy3;
				goto yy359;
			} else {
				if(yych <= ')') goto yy360;
				if(yych <= '.') goto yy359;
				goto yy3;
			}
		} else {
			if(yych <= 'Z') {
				if(yych <= '9') goto yy359;
				if(yych <= '@') goto yy3;
				goto yy135;
			} else {
				if(yych <= '`') goto yy3;
				if(yych <= 'z') goto yy135;
				goto yy3;
			}
		}
yy599:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= ')') {
				if(yych <= 0x1F) goto yy3;
				if(yych <= '(') goto yy359;
				goto yy360;
			} else {
				if(yych == '/') goto yy3;
				goto yy359;
			}
		} else {
			if(yych <= 'I') {
				if(yych <= '@') goto yy3;
				if(yych <= 'H') goto yy134;
			} else {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= ')') {
				if(yych <= 0x1F) goto yy3;
				if(yych <= '(') goto yy359;
				goto yy360;
			} else {
				if(yych == '/') goto yy3;
				goto yy359;
			}
		} else {
			if(yych <= 'I') {
				if(yych <= '@') goto yy3;
				if(yych <= 'H') goto yy135;
				goto yy587;
			} else {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy3;
				if(yych <= 'z') goto yy135;
				goto yy3;
			}
		}
yy601:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= '(') {
				if(yych <= 0x1F) goto yy3;
				goto yy359;
			} else {
				if(yych <= ')') goto yy360;
				if(yych <= '.') goto yy359;
				goto yy3;
			}
		} else {
			if(yych <= 'Z') {
				if(yych <= '9') goto yy359;
				if(yych <= '@') goto yy3;
				goto yy134;
			} else {
				if(yych <= '`') goto yy3;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy602:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= ')') {
				if(yych <= 0x1F) goto yy3;
				if(yych <= '(') goto yy359;
				goto yy360;
			} else {
				if(yych == '/') goto yy3;
				goto yy359;
			}
		} else {
			if(yych <= 'I') {
				if(yych <= '@') goto yy3;
				if(yych <= 'H') goto yy134;
				goto yy598;
			} else {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy603:
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
		yych = *YYCURSOR;
yy604:
		{
			static void *yytarget[256] = {
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy603,  &&yy616,  &&yy616,  &&yy616,  &&yy616,  &&yy616,  &&yy616,  &&yy616,
				&&yy616,  &&yy616,  &&yy616,  &&yy616,  &&yy616,  &&yy616,  &&yy616,  &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy624,  &&yy53,   &&yy53,   &&yy608,  &&yy53,   &&yy609,  &&yy53,
				&&yy60,   &&yy619,  &&yy623,  &&yy53,   &&yy53,   &&yy607,  &&yy626,  &&yy625,
				&&yy628,  &&yy53,   &&yy53,   &&yy605,  &&yy65,   &&yy53,   &&yy621,  &&yy62,
				&&yy622,  &&yy64,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy624,  &&yy53,   &&yy53,   &&yy608,  &&yy53,   &&yy609,  &&yy53,
				&&yy60,   &&yy53,   &&yy623,  &&yy53,   &&yy53,   &&yy607,  &&yy626,  &&yy625,
				&&yy628,  &&yy53,   &&yy53,   &&yy605,  &&yy65,   &&yy53,   &&yy53,   &&yy62,
				&&yy53,   &&yy64,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53
			};
			goto *yytarget[yych];
		}
yy605:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych <= 'D') {
				if(yych == 'A') goto yy119;
				goto yy53;
			} else {
				if(yych <= 'E') goto yy1137;
				if(yych <= 'T') goto yy53;
				goto yy118;
			}
		} else {
			if(yych <= 'd') {
				if(yych == 'a') goto yy119;
				goto yy53;
			} else {
				if(yych <= 'e') goto yy1137;
				if(yych == 'u') goto yy118;
				goto yy53;
			}
		}
yy606:
		yych = *++YYCURSOR;
		if(yych <= '`') {
			if(yych <= 'D') {
				if(yych == 'A') goto yy119;
				goto yy53;
			} else {
				if(yych <= 'E') goto yy1137;
				if(yych == 'U') goto yy118;
				goto yy53;
			}
		} else {
			if(yych <= 'e') {
				if(yych <= 'a') goto yy119;
				if(yych <= 'd') goto yy53;
				goto yy1137;
			} else {
				if(yych <= 's') goto yy53;
				if(yych <= 't') goto yy843;
				if(yych <= 'u') goto yy118;
				goto yy53;
			}
		}
yy607:
		yych = *++YYCURSOR;
		if(yych <= 'O') {
			if(yych <= 'H') {
				if(yych == 'A') goto yy715;
				goto yy53;
			} else {
				if(yych <= 'I') goto yy110;
				if(yych <= 'N') goto yy53;
				goto yy109;
			}
		} else {
			if(yych <= 'h') {
				if(yych == 'a') goto yy715;
				goto yy53;
			} else {
				if(yych <= 'i') goto yy110;
				if(yych == 'o') goto yy109;
				goto yy53;
			}
		}
yy608:
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych == 'A') goto yy106;
			if(yych <= 'D') goto yy53;
			goto yy702;
		} else {
			if(yych <= 'a') {
				if(yych <= '`') goto yy53;
				goto yy106;
			} else {
				if(yych == 'e') goto yy702;
				goto yy53;
			}
		}
yy609:
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych <= 'N') {
				if(yych == 'E') goto yy718;
				goto yy53;
			} else {
				if(yych <= 'O') goto yy83;
				if(yych <= 'Q') goto yy53;
				goto yy82;
			}
		} else {
			if(yych <= 'n') {
				if(yych == 'e') goto yy718;
				goto yy53;
			} else {
				if(yych <= 'o') goto yy83;
				if(yych == 'r') goto yy82;
				goto yy53;
			}
		}
yy610:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'H') goto yy66;
			if(yych <= 'T') goto yy53;
			goto yy67;
		} else {
			if(yych <= 'h') {
				if(yych <= 'g') goto yy53;
				goto yy1136;
			} else {
				if(yych == 'u') goto yy67;
				goto yy53;
			}
		}
yy611:
		yych = *++YYCURSOR;
		if(yych == '-') goto yy852;
		if(yych <= '/') goto yy57;
		if(yych <= '9') goto yy851;
		goto yy57;
yy612:
		yych = *++YYCURSOR;
		if(yych <= 'c') {
			if(yych == 'O') goto yy655;
			goto yy53;
		} else {
			if(yych <= 'd') goto yy843;
			if(yych == 'o') goto yy655;
			goto yy53;
		}
yy613:
		yych = *++YYCURSOR;
		if(yych == 'd') goto yy843;
		goto yy53;
yy614:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy783,  &&yy783,  &&yy783,  &&yy785,  &&yy786,  &&yy786,  &&yy786,  &&yy786,
				&&yy786,  &&yy786,  &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy790,  &&yy53,   &&yy53,   &&yy794,  &&yy53,   &&yy788,  &&yy53,
				&&yy53,   &&yy53,   &&yy787,  &&yy53,   &&yy53,   &&yy789,  &&yy793,  &&yy792,
				&&yy53,   &&yy53,   &&yy53,   &&yy791,  &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy790,  &&yy53,   &&yy53,   &&yy794,  &&yy53,   &&yy788,  &&yy53,
				&&yy53,   &&yy53,   &&yy787,  &&yy53,   &&yy53,   &&yy789,  &&yy793,  &&yy792,
				&&yy53,   &&yy53,   &&yy53,   &&yy791,  &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53
			};
			goto *yytarget[yych];
		}
yy615:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy734,  &&yy735,  &&yy736,  &&yy736,  &&yy736,  &&yy736,  &&yy736,  &&yy736,
				&&yy736,  &&yy736,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy617,  &&yy740,  &&yy617,  &&yy617,  &&yy744,  &&yy617,  &&yy738,  &&yy617,
				&&yy617,  &&yy617,  &&yy737,  &&yy617,  &&yy617,  &&yy739,  &&yy743,  &&yy742,
				&&yy617,  &&yy617,  &&yy617,  &&yy741,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy617,  &&yy740,  &&yy617,  &&yy617,  &&yy744,  &&yy617,  &&yy738,  &&yy617,
				&&yy617,  &&yy617,  &&yy737,  &&yy617,  &&yy617,  &&yy739,  &&yy743,  &&yy742,
				&&yy617,  &&yy617,  &&yy617,  &&yy741,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,
				&&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617,  &&yy617
			};
			goto *yytarget[yych];
		}
yy616:
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
		yych = *YYCURSOR;
yy617:
		{
			static void *yytarget[256] = {
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy616,  &&yy616,  &&yy616,  &&yy616,  &&yy616,  &&yy616,  &&yy616,  &&yy616,
				&&yy616,  &&yy616,  &&yy616,  &&yy616,  &&yy616,  &&yy616,  &&yy616,  &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy699,  &&yy53,   &&yy53,   &&yy701,  &&yy53,   &&yy697,  &&yy53,
				&&yy53,   &&yy619,  &&yy623,  &&yy53,   &&yy53,   &&yy698,  &&yy626,  &&yy625,
				&&yy53,   &&yy53,   &&yy53,   &&yy700,  &&yy53,   &&yy53,   &&yy621,  &&yy53,
				&&yy622,  &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy699,  &&yy53,   &&yy53,   &&yy701,  &&yy53,   &&yy697,  &&yy53,
				&&yy53,   &&yy53,   &&yy623,  &&yy53,   &&yy53,   &&yy698,  &&yy626,  &&yy625,
				&&yy53,   &&yy53,   &&yy53,   &&yy700,  &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53
			};
			goto *yytarget[yych];
		}
yy618:
		yych = *++YYCURSOR;
		if(yych <= '1') {
			if(yych <= '/') goto yy617;
			if(yych <= '0') goto yy693;
			goto yy694;
		} else {
			if(yych <= '5') goto yy695;
			if(yych <= '9') goto yy696;
			goto yy617;
		}
yy619:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'H') {
			if(yych <= '.') {
				if(yych >= ' ') goto yy657;
			} else {
				if(yych <= '/') goto yy620;
				if(yych <= '9') goto yy659;
			}
		} else {
			if(yych <= 'V') {
				if(yych <= 'I') goto yy692;
				if(yych >= 'V') goto yy665;
			} else {
				if(yych == 'X') goto yy665;
			}
		}
yy620:
#line 1139 "parse_date.g.re"
		{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 9058 "<stdout>"
yy621:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= 0x1F) goto yy620;
			if(yych <= '.') goto yy657;
			goto yy620;
		} else {
			if(yych <= '9') goto yy659;
			if(yych == 'I') goto yy690;
			goto yy620;
		}
yy622:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= 0x1F) goto yy620;
			if(yych <= '.') goto yy657;
			goto yy620;
		} else {
			if(yych <= '9') goto yy659;
			if(yych == 'I') goto yy689;
			goto yy620;
		}
yy623:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'A') goto yy682;
			if(yych <= 'T') goto yy53;
			goto yy681;
		} else {
			if(yych <= 'a') {
				if(yych <= '`') goto yy53;
				goto yy682;
			} else {
				if(yych == 'u') goto yy681;
				goto yy53;
			}
		}
yy624:
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= 'L') {
				if(yych == '.') goto yy629;
				goto yy53;
			} else {
				if(yych <= 'M') goto yy630;
				if(yych == 'P') goto yy675;
				goto yy53;
			}
		} else {
			if(yych <= 'o') {
				if(yych <= 'U') goto yy674;
				if(yych == 'm') goto yy630;
				goto yy53;
			} else {
				if(yych <= 'p') goto yy675;
				if(yych == 'u') goto yy674;
				goto yy53;
			}
		}
yy625:
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy669;
		if(yych == 'c') goto yy669;
		goto yy53;
yy626:
		yych = *++YYCURSOR;
		if(yych == 'O') goto yy655;
		if(yych == 'o') goto yy655;
		goto yy53;
yy627:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy633;
		if(yych <= '9') goto yy635;
		goto yy53;
yy628:
		yych = *++YYCURSOR;
		if(yych <= 'L') {
			if(yych != '.') goto yy53;
		} else {
			if(yych <= 'M') goto yy630;
			if(yych == 'm') goto yy630;
			goto yy53;
		}
yy629:
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy630;
		if(yych != 'm') goto yy53;
yy630:
		++YYCURSOR;
		if((yych = *YYCURSOR) == '.') goto yy632;
yy631:
#line 929 "parse_date.g.re"
		{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
#line 9169 "<stdout>"
yy632:
		yych = *++YYCURSOR;
		goto yy631;
yy633:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy636;
		} else {
			if(yych <= '9') goto yy649;
			if(yych <= ':') goto yy636;
		}
yy634:
#line 946 "parse_date.g.re"
		{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			s->errors += tz_not_found;
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 9206 "<stdout>"
yy635:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '.') goto yy636;
		if(yych != ':') goto yy634;
yy636:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy637;
		if(yych <= '6') goto yy638;
		if(yych <= '9') goto yy639;
		goto yy53;
yy637:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '.') goto yy640;
		if(yych <= '/') goto yy634;
		if(yych <= '9') goto yy643;
		goto yy634;
yy638:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '.') goto yy640;
		if(yych == '0') goto yy643;
		goto yy634;
yy639:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych != '.') goto yy634;
yy640:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
yy641:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= '/') goto yy634;
		if(yych <= '9') goto yy641;
		goto yy634;
yy643:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'A') {
			if(yych <= '-') {
				if(yych != ' ') goto yy634;
			} else {
				if(yych <= '.') goto yy640;
				if(yych <= '@') goto yy634;
				goto yy646;
			}
		} else {
			if(yych <= '`') {
				if(yych == 'P') goto yy646;
				goto yy634;
			} else {
				if(yych <= 'a') goto yy646;
				if(yych == 'p') goto yy646;
				goto yy634;
			}
		}
yy644:
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
		yych = *YYCURSOR;
		if(yych <= 'O') {
			if(yych <= ' ') {
				if(yych <= 0x1F) goto yy53;
				goto yy644;
			} else {
				if(yych != 'A') goto yy53;
			}
		} else {
			if(yych <= 'a') {
				if(yych <= 'P') goto yy646;
				if(yych <= '`') goto yy53;
			} else {
				if(yych != 'p') goto yy53;
			}
		}
yy646:
		yych = *++YYCURSOR;
		if(yych <= 'L') {
			if(yych != '.') goto yy53;
		} else {
			if(yych <= 'M') goto yy648;
			if(yych == 'm') goto yy648;
			goto yy53;
		}
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy648;
		if(yych != 'm') goto yy53;
yy648:
		yych = *++YYCURSOR;
		if(yych == '.') goto yy632;
		goto yy631;
yy649:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych <= '-') {
				if(yych != ' ') goto yy634;
			} else {
				if(yych <= '.') goto yy636;
				if(yych == ':') goto yy636;
				goto yy634;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'A') goto yy652;
				if(yych == 'P') goto yy652;
				goto yy634;
			} else {
				if(yych <= 'a') goto yy652;
				if(yych == 'p') goto yy652;
				goto yy634;
			}
		}
yy650:
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
		yych = *YYCURSOR;
		if(yych <= 'O') {
			if(yych <= ' ') {
				if(yych <= 0x1F) goto yy53;
				goto yy650;
			} else {
				if(yych != 'A') goto yy53;
			}
		} else {
			if(yych <= 'a') {
				if(yych <= 'P') goto yy652;
				if(yych <= '`') goto yy53;
			} else {
				if(yych != 'p') goto yy53;
			}
		}
yy652:
		yych = *++YYCURSOR;
		if(yych <= 'L') {
			if(yych != '.') goto yy53;
		} else {
			if(yych <= 'M') goto yy654;
			if(yych == 'm') goto yy654;
			goto yy53;
		}
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy654;
		if(yych != 'm') goto yy53;
yy654:
		yych = *++YYCURSOR;
		if(yych == '.') goto yy632;
		goto yy631;
yy655:
		yych = *++YYCURSOR;
		if(yych == 'V') goto yy656;
		if(yych != 'v') goto yy53;
yy656:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= 0x1F) goto yy620;
			if(yych <= '.') goto yy657;
			if(yych <= '/') goto yy620;
			goto yy659;
		} else {
			if(yych <= 'E') {
				if(yych <= 'D') goto yy620;
				goto yy661;
			} else {
				if(yych == 'e') goto yy661;
				goto yy620;
			}
		}
yy657:
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
		yych = *YYCURSOR;
yy658:
		if(yych <= 0x1F) goto yy53;
		if(yych <= '.') goto yy657;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
yy659:
		++YYCURSOR;
		if((yych = *YYCURSOR) <= '/') goto yy660;
		if(yych <= '9') goto yy666;
yy660:
#line 1073 "parse_date.g.re"
		{
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
#line 9408 "<stdout>"
yy661:
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy662;
		if(yych != 'm') goto yy53;
yy662:
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy663;
		if(yych != 'b') goto yy53;
yy663:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy664;
		if(yych != 'e') goto yy53;
yy664:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy665;
		if(yych != 'r') goto yy53;
yy665:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 0x1F) goto yy620;
		if(yych <= '.') goto yy657;
		if(yych <= '/') goto yy620;
		if(yych <= '9') goto yy659;
		goto yy620;
yy666:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy660;
		if(yych >= ':') goto yy660;
yy667:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy660;
		if(yych >= ':') goto yy660;
		yych = *++YYCURSOR;
		goto yy660;
yy669:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy670;
		if(yych != 't') goto yy53;
yy670:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= 0x1F) goto yy620;
			if(yych <= '.') goto yy657;
			if(yych <= '/') goto yy620;
			goto yy659;
		} else {
			if(yych <= 'O') {
				if(yych <= 'N') goto yy620;
			} else {
				if(yych != 'o') goto yy620;
			}
		}
yy671:
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy672;
		if(yych != 'b') goto yy53;
yy672:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy673;
		if(yych != 'e') goto yy53;
yy673:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy665;
		if(yych == 'r') goto yy665;
		goto yy53;
yy674:
		yych = *++YYCURSOR;
		if(yych == 'G') goto yy678;
		if(yych == 'g') goto yy678;
		goto yy53;
yy675:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy676;
		if(yych != 'r') goto yy53;
yy676:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= 0x1F) goto yy620;
			if(yych <= '.') goto yy657;
			if(yych <= '/') goto yy620;
			goto yy659;
		} else {
			if(yych <= 'I') {
				if(yych <= 'H') goto yy620;
			} else {
				if(yych != 'i') goto yy620;
			}
		}
yy677:
		yych = *++YYCURSOR;
		if(yych == 'L') goto yy665;
		if(yych == 'l') goto yy665;
		goto yy53;
yy678:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= 0x1F) goto yy620;
			if(yych <= '.') goto yy657;
			if(yych <= '/') goto yy620;
			goto yy659;
		} else {
			if(yych <= 'U') {
				if(yych <= 'T') goto yy620;
			} else {
				if(yych != 'u') goto yy620;
			}
		}
yy679:
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy680;
		if(yych != 's') goto yy53;
yy680:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy665;
		if(yych == 't') goto yy665;
		goto yy53;
yy681:
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych == 'L') goto yy688;
			if(yych <= 'M') goto yy53;
			goto yy687;
		} else {
			if(yych <= 'l') {
				if(yych <= 'k') goto yy53;
				goto yy688;
			} else {
				if(yych == 'n') goto yy687;
				goto yy53;
			}
		}
yy682:
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy683;
		if(yych != 'n') goto yy53;
yy683:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= 0x1F) goto yy620;
			if(yych <= '.') goto yy657;
			if(yych <= '/') goto yy620;
			goto yy659;
		} else {
			if(yych <= 'U') {
				if(yych <= 'T') goto yy620;
			} else {
				if(yych != 'u') goto yy620;
			}
		}
yy684:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy685;
		if(yych != 'a') goto yy53;
yy685:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy686;
		if(yych != 'r') goto yy53;
yy686:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy665;
		if(yych == 'y') goto yy665;
		goto yy53;
yy687:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= 0x1F) goto yy620;
			if(yych <= '.') goto yy657;
			if(yych <= '/') goto yy620;
			goto yy659;
		} else {
			if(yych <= 'E') {
				if(yych <= 'D') goto yy620;
				goto yy665;
			} else {
				if(yych == 'e') goto yy665;
				goto yy620;
			}
		}
yy688:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= 0x1F) goto yy620;
			if(yych <= '.') goto yy657;
			if(yych <= '/') goto yy620;
			goto yy659;
		} else {
			if(yych <= 'Y') {
				if(yych <= 'X') goto yy620;
				goto yy665;
			} else {
				if(yych == 'y') goto yy665;
				goto yy620;
			}
		}
yy689:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= 0x1F) goto yy620;
			if(yych <= '.') goto yy657;
			goto yy620;
		} else {
			if(yych <= '9') goto yy659;
			if(yych == 'I') goto yy665;
			goto yy620;
		}
yy690:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= 0x1F) goto yy620;
			if(yych <= '.') goto yy657;
			goto yy620;
		} else {
			if(yych <= '9') goto yy659;
			if(yych != 'I') goto yy620;
		}
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= 0x1F) goto yy620;
			if(yych <= '.') goto yy657;
			goto yy620;
		} else {
			if(yych <= '9') goto yy659;
			if(yych == 'I') goto yy665;
			goto yy620;
		}
yy692:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= 0x1F) goto yy620;
			if(yych <= '.') goto yy657;
			goto yy620;
		} else {
			if(yych <= '9') goto yy659;
			if(yych == 'I') goto yy665;
			goto yy620;
		}
yy693:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy724;
			goto yy634;
		} else {
			if(yych <= '9') goto yy733;
			if(yych <= ':') goto yy636;
			goto yy634;
		}
yy694:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy724;
			goto yy634;
		} else {
			if(yych <= '2') goto yy733;
			if(yych <= '9') goto yy649;
			if(yych <= ':') goto yy636;
			goto yy634;
		}
yy695:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy724;
			goto yy634;
		} else {
			if(yych <= '9') goto yy649;
			if(yych <= ':') goto yy636;
			goto yy634;
		}
yy696:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '.') goto yy724;
		if(yych == ':') goto yy636;
		goto yy634;
yy697:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy718;
		if(yych == 'e') goto yy718;
		goto yy53;
yy698:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy715;
		if(yych == 'a') goto yy715;
		goto yy53;
yy699:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'P') goto yy675;
			if(yych <= 'T') goto yy53;
			goto yy674;
		} else {
			if(yych <= 'p') {
				if(yych <= 'o') goto yy53;
				goto yy675;
			} else {
				if(yych == 'u') goto yy674;
				goto yy53;
			}
		}
yy700:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy708;
		if(yych == 'e') goto yy708;
		goto yy53;
yy701:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy702;
		if(yych != 'e') goto yy53;
yy702:
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy703;
		if(yych != 'c') goto yy53;
yy703:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= 0x1F) goto yy620;
			if(yych <= '.') goto yy657;
			if(yych <= '/') goto yy620;
			goto yy659;
		} else {
			if(yych <= 'E') {
				if(yych <= 'D') goto yy620;
			} else {
				if(yych != 'e') goto yy620;
			}
		}
yy704:
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy705;
		if(yych != 'm') goto yy53;
yy705:
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy706;
		if(yych != 'b') goto yy53;
yy706:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy707;
		if(yych != 'e') goto yy53;
yy707:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy665;
		if(yych == 'r') goto yy665;
		goto yy53;
yy708:
		yych = *++YYCURSOR;
		if(yych == 'P') goto yy709;
		if(yych != 'p') goto yy53;
yy709:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= 0x1F) goto yy620;
			if(yych <= '.') goto yy657;
			if(yych <= '/') goto yy620;
			goto yy659;
		} else {
			if(yych <= 'T') {
				if(yych <= 'S') goto yy620;
			} else {
				if(yych != 't') goto yy620;
			}
		}
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= 0x1F) goto yy620;
			if(yych <= '.') goto yy657;
			if(yych <= '/') goto yy620;
			goto yy659;
		} else {
			if(yych <= 'E') {
				if(yych <= 'D') goto yy620;
			} else {
				if(yych != 'e') goto yy620;
			}
		}
yy711:
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy712;
		if(yych != 'm') goto yy53;
yy712:
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy713;
		if(yych != 'b') goto yy53;
yy713:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy714;
		if(yych != 'e') goto yy53;
yy714:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy665;
		if(yych == 'r') goto yy665;
		goto yy53;
yy715:
		yych = *++YYCURSOR;
		if(yych <= 'Y') {
			if(yych == 'R') goto yy716;
			if(yych <= 'X') goto yy53;
			goto yy665;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy53;
			} else {
				if(yych == 'y') goto yy665;
				goto yy53;
			}
		}
yy716:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= 0x1F) goto yy620;
			if(yych <= '.') goto yy657;
			if(yych <= '/') goto yy620;
			goto yy659;
		} else {
			if(yych <= 'C') {
				if(yych <= 'B') goto yy620;
			} else {
				if(yych != 'c') goto yy620;
			}
		}
yy717:
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy665;
		if(yych == 'h') goto yy665;
		goto yy53;
yy718:
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy719;
		if(yych != 'b') goto yy53;
yy719:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= 0x1F) goto yy620;
			if(yych <= '.') goto yy657;
			if(yych <= '/') goto yy620;
			goto yy659;
		} else {
			if(yych <= 'R') {
				if(yych <= 'Q') goto yy620;
			} else {
				if(yych != 'r') goto yy620;
			}
		}
yy720:
		yych = *++YYCURSOR;
		if(yych == 'U') goto yy721;
		if(yych != 'u') goto yy53;
yy721:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy722;
		if(yych != 'a') goto yy53;
yy722:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy723;
		if(yych != 'r') goto yy53;
yy723:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy665;
		if(yych == 'y') goto yy665;
		goto yy53;
yy724:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy725;
		if(yych <= '6') goto yy726;
		if(yych <= '9') goto yy727;
		goto yy53;
yy725:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '.') goto yy640;
		if(yych <= '/') goto yy634;
		if(yych <= '9') goto yy732;
		goto yy634;
yy726:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy640;
			goto yy634;
		} else {
			if(yych <= '0') goto yy732;
			if(yych <= '9') goto yy728;
			goto yy634;
		}
yy727:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '.') goto yy640;
		if(yych <= '/') goto yy634;
		if(yych >= ':') goto yy634;
yy728:
		++YYCURSOR;
		if((yych = *YYCURSOR) <= '/') goto yy729;
		if(yych <= '9') goto yy730;
yy729:
#line 1087 "parse_date.g.re"
		{
		DEBUG_OUTPUT("pointed date");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 9933 "<stdout>"
yy730:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy729;
		if(yych >= ':') goto yy729;
		yych = *++YYCURSOR;
		goto yy729;
yy732:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych <= '-') {
				if(yych == ' ') goto yy644;
				goto yy634;
			} else {
				if(yych <= '.') goto yy640;
				if(yych <= '/') goto yy634;
				if(yych <= '9') goto yy730;
				goto yy634;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'A') goto yy646;
				if(yych == 'P') goto yy646;
				goto yy634;
			} else {
				if(yych <= 'a') goto yy646;
				if(yych == 'p') goto yy646;
				goto yy634;
			}
		}
yy733:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych <= '-') {
				if(yych == ' ') goto yy650;
				goto yy634;
			} else {
				if(yych <= '.') goto yy724;
				if(yych == ':') goto yy636;
				goto yy634;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'A') goto yy652;
				if(yych == 'P') goto yy652;
				goto yy634;
			} else {
				if(yych <= 'a') goto yy652;
				if(yych == 'p') goto yy652;
				goto yy634;
			}
		}
yy734:
		yych = *++YYCURSOR;
		if(yych == '-') goto yy773;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy736;
		goto yy53;
yy735:
		yych = *++YYCURSOR;
		if(yych == '-') goto yy773;
		if(yych <= '/') goto yy53;
		if(yych >= '3') goto yy53;
yy736:
		yych = *++YYCURSOR;
		if(yych == '-') goto yy773;
		goto yy53;
yy737:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'A') goto yy769;
			if(yych <= 'T') goto yy53;
			goto yy768;
		} else {
			if(yych <= 'a') {
				if(yych <= '`') goto yy53;
				goto yy769;
			} else {
				if(yych == 'u') goto yy768;
				goto yy53;
			}
		}
yy738:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy766;
		if(yych == 'e') goto yy766;
		goto yy53;
yy739:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy763;
		if(yych == 'a') goto yy763;
		goto yy53;
yy740:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'P') goto yy760;
			if(yych <= 'T') goto yy53;
			goto yy759;
		} else {
			if(yych <= 'p') {
				if(yych <= 'o') goto yy53;
				goto yy760;
			} else {
				if(yych == 'u') goto yy759;
				goto yy53;
			}
		}
yy741:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy756;
		if(yych == 'e') goto yy756;
		goto yy53;
yy742:
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy754;
		if(yych == 'c') goto yy754;
		goto yy53;
yy743:
		yych = *++YYCURSOR;
		if(yych == 'O') goto yy752;
		if(yych == 'o') goto yy752;
		goto yy53;
yy744:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy745;
		if(yych != 'e') goto yy53;
yy745:
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy746;
		if(yych != 'c') goto yy53;
yy746:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= ',') {
				if(yych <= 0x1F) goto yy620;
				goto yy657;
			} else {
				if(yych <= '-') goto yy747;
				if(yych <= '.') goto yy657;
				goto yy620;
			}
		} else {
			if(yych <= 'E') {
				if(yych <= '9') goto yy659;
				if(yych <= 'D') goto yy620;
				goto yy704;
			} else {
				if(yych == 'e') goto yy704;
				goto yy620;
			}
		}
yy747:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy658;
		if(yych <= '0') goto yy748;
		if(yych <= '2') goto yy749;
		if(yych <= '3') goto yy750;
		goto yy658;
yy748:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy660;
		if(yych <= '0') goto yy666;
		if(yych <= '9') goto yy751;
		goto yy660;
yy749:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy660;
		if(yych <= '9') goto yy751;
		goto yy660;
yy750:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy660;
		if(yych <= '1') goto yy751;
		if(yych <= '9') goto yy666;
		goto yy660;
yy751:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy660;
		if(yych <= '9') goto yy667;
		goto yy660;
yy752:
		yych = *++YYCURSOR;
		if(yych == 'V') goto yy753;
		if(yych != 'v') goto yy53;
yy753:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= ',') {
				if(yych <= 0x1F) goto yy620;
				goto yy657;
			} else {
				if(yych <= '-') goto yy747;
				if(yych <= '.') goto yy657;
				goto yy620;
			}
		} else {
			if(yych <= 'E') {
				if(yych <= '9') goto yy659;
				if(yych <= 'D') goto yy620;
				goto yy661;
			} else {
				if(yych == 'e') goto yy661;
				goto yy620;
			}
		}
yy754:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy755;
		if(yych != 't') goto yy53;
yy755:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= ',') {
				if(yych <= 0x1F) goto yy620;
				goto yy657;
			} else {
				if(yych <= '-') goto yy747;
				if(yych <= '.') goto yy657;
				goto yy620;
			}
		} else {
			if(yych <= 'O') {
				if(yych <= '9') goto yy659;
				if(yych <= 'N') goto yy620;
				goto yy671;
			} else {
				if(yych == 'o') goto yy671;
				goto yy620;
			}
		}
yy756:
		yych = *++YYCURSOR;
		if(yych == 'P') goto yy757;
		if(yych != 'p') goto yy53;
yy757:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= ',') {
				if(yych <= 0x1F) goto yy620;
				goto yy657;
			} else {
				if(yych <= '-') goto yy747;
				if(yych <= '.') goto yy657;
				goto yy620;
			}
		} else {
			if(yych <= 'T') {
				if(yych <= '9') goto yy659;
				if(yych <= 'S') goto yy620;
			} else {
				if(yych != 't') goto yy620;
			}
		}
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= ',') {
				if(yych <= 0x1F) goto yy620;
				goto yy657;
			} else {
				if(yych <= '-') goto yy747;
				if(yych <= '.') goto yy657;
				goto yy620;
			}
		} else {
			if(yych <= 'E') {
				if(yych <= '9') goto yy659;
				if(yych <= 'D') goto yy620;
				goto yy711;
			} else {
				if(yych == 'e') goto yy711;
				goto yy620;
			}
		}
yy759:
		yych = *++YYCURSOR;
		if(yych == 'G') goto yy762;
		if(yych == 'g') goto yy762;
		goto yy53;
yy760:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy761;
		if(yych != 'r') goto yy53;
yy761:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= ',') {
				if(yych <= 0x1F) goto yy620;
				goto yy657;
			} else {
				if(yych <= '-') goto yy747;
				if(yych <= '.') goto yy657;
				goto yy620;
			}
		} else {
			if(yych <= 'I') {
				if(yych <= '9') goto yy659;
				if(yych <= 'H') goto yy620;
				goto yy677;
			} else {
				if(yych == 'i') goto yy677;
				goto yy620;
			}
		}
yy762:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= ',') {
				if(yych <= 0x1F) goto yy620;
				goto yy657;
			} else {
				if(yych <= '-') goto yy747;
				if(yych <= '.') goto yy657;
				goto yy620;
			}
		} else {
			if(yych <= 'U') {
				if(yych <= '9') goto yy659;
				if(yych <= 'T') goto yy620;
				goto yy679;
			} else {
				if(yych == 'u') goto yy679;
				goto yy620;
			}
		}
yy763:
		yych = *++YYCURSOR;
		if(yych <= 'Y') {
			if(yych == 'R') goto yy764;
			if(yych <= 'X') goto yy53;
			goto yy765;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy53;
			} else {
				if(yych == 'y') goto yy765;
				goto yy53;
			}
		}
yy764:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= ',') {
				if(yych <= 0x1F) goto yy620;
				goto yy657;
			} else {
				if(yych <= '-') goto yy747;
				if(yych <= '.') goto yy657;
				goto yy620;
			}
		} else {
			if(yych <= 'C') {
				if(yych <= '9') goto yy659;
				if(yych <= 'B') goto yy620;
				goto yy717;
			} else {
				if(yych == 'c') goto yy717;
				goto yy620;
			}
		}
yy765:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '-') {
			if(yych <= 0x1F) goto yy620;
			if(yych <= ',') goto yy657;
			goto yy747;
		} else {
			if(yych <= '.') goto yy657;
			if(yych <= '/') goto yy620;
			if(yych <= '9') goto yy659;
			goto yy620;
		}
yy766:
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy767;
		if(yych != 'b') goto yy53;
yy767:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= ',') {
				if(yych <= 0x1F) goto yy620;
				goto yy657;
			} else {
				if(yych <= '-') goto yy747;
				if(yych <= '.') goto yy657;
				goto yy620;
			}
		} else {
			if(yych <= 'R') {
				if(yych <= '9') goto yy659;
				if(yych <= 'Q') goto yy620;
				goto yy720;
			} else {
				if(yych == 'r') goto yy720;
				goto yy620;
			}
		}
yy768:
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych == 'L') goto yy772;
			if(yych <= 'M') goto yy53;
			goto yy771;
		} else {
			if(yych <= 'l') {
				if(yych <= 'k') goto yy53;
				goto yy772;
			} else {
				if(yych == 'n') goto yy771;
				goto yy53;
			}
		}
yy769:
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy770;
		if(yych != 'n') goto yy53;
yy770:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= ',') {
				if(yych <= 0x1F) goto yy620;
				goto yy657;
			} else {
				if(yych <= '-') goto yy747;
				if(yych <= '.') goto yy657;
				goto yy620;
			}
		} else {
			if(yych <= 'U') {
				if(yych <= '9') goto yy659;
				if(yych <= 'T') goto yy620;
				goto yy684;
			} else {
				if(yych == 'u') goto yy684;
				goto yy620;
			}
		}
yy771:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= ',') {
				if(yych <= 0x1F) goto yy620;
				goto yy657;
			} else {
				if(yych <= '-') goto yy747;
				if(yych <= '.') goto yy657;
				goto yy620;
			}
		} else {
			if(yych <= 'E') {
				if(yych <= '9') goto yy659;
				if(yych <= 'D') goto yy620;
				goto yy665;
			} else {
				if(yych == 'e') goto yy665;
				goto yy620;
			}
		}
yy772:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= ',') {
				if(yych <= 0x1F) goto yy620;
				goto yy657;
			} else {
				if(yych <= '-') goto yy747;
				if(yych <= '.') goto yy657;
				goto yy620;
			}
		} else {
			if(yych <= 'Y') {
				if(yych <= '9') goto yy659;
				if(yych <= 'X') goto yy620;
				goto yy665;
			} else {
				if(yych == 'y') goto yy665;
				goto yy620;
			}
		}
yy773:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '2') goto yy774;
		if(yych <= '3') goto yy776;
		if(yych <= '9') goto yy777;
		goto yy53;
yy774:
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych <= '/') goto yy775;
			if(yych <= '9') goto yy777;
			if(yych >= 'n') goto yy779;
		} else {
			if(yych <= 'r') {
				if(yych >= 'r') goto yy780;
			} else {
				if(yych <= 's') goto yy778;
				if(yych <= 't') goto yy781;
			}
		}
yy775:
#line 1060 "parse_date.g.re"
		{
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 10461 "<stdout>"
yy776:
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych <= '/') goto yy775;
			if(yych <= '1') goto yy777;
			if(yych <= 'm') goto yy775;
			goto yy779;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy775;
				goto yy780;
			} else {
				if(yych <= 's') goto yy778;
				if(yych <= 't') goto yy781;
				goto yy775;
			}
		}
yy777:
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'q') {
			if(yych == 'n') goto yy779;
			goto yy775;
		} else {
			if(yych <= 'r') goto yy780;
			if(yych <= 's') goto yy778;
			if(yych <= 't') goto yy781;
			goto yy775;
		}
yy778:
		yych = *++YYCURSOR;
		if(yych == 't') goto yy782;
		goto yy53;
yy779:
		yych = *++YYCURSOR;
		if(yych == 'd') goto yy782;
		goto yy53;
yy780:
		yych = *++YYCURSOR;
		if(yych == 'd') goto yy782;
		goto yy53;
yy781:
		yych = *++YYCURSOR;
		if(yych != 'h') goto yy53;
yy782:
		yych = *++YYCURSOR;
		goto yy775;
yy783:
		yyaccept = 13;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych <= '/') {
				if(yych >= '/') goto yy837;
			} else {
				if(yych <= '9') goto yy786;
				if(yych >= 'n') goto yy834;
			}
		} else {
			if(yych <= 'r') {
				if(yych >= 'r') goto yy835;
			} else {
				if(yych <= 's') goto yy833;
				if(yych <= 't') goto yy836;
			}
		}
yy784:
#line 1033 "parse_date.g.re"
		{
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr((char **) &ptr, 4);
			TIMELIB_PROCESS_YEAR(s->time->y);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
#line 10543 "<stdout>"
yy785:
		yyaccept = 13;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych <= '/') {
				if(yych <= '.') goto yy784;
				goto yy837;
			} else {
				if(yych <= '1') goto yy786;
				if(yych <= 'm') goto yy784;
				goto yy834;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy784;
				goto yy835;
			} else {
				if(yych <= 's') goto yy833;
				if(yych <= 't') goto yy836;
				goto yy784;
			}
		}
yy786:
		yyaccept = 13;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych == '/') goto yy837;
			if(yych <= 'm') goto yy784;
			goto yy834;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy784;
				goto yy835;
			} else {
				if(yych <= 's') goto yy833;
				if(yych <= 't') goto yy836;
				goto yy784;
			}
		}
yy787:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'A') goto yy832;
			if(yych <= 'T') goto yy53;
			goto yy831;
		} else {
			if(yych <= 'a') {
				if(yych <= '`') goto yy53;
				goto yy832;
			} else {
				if(yych == 'u') goto yy831;
				goto yy53;
			}
		}
yy788:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy830;
		if(yych == 'e') goto yy830;
		goto yy53;
yy789:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy829;
		if(yych == 'a') goto yy829;
		goto yy53;
yy790:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'P') goto yy828;
			if(yych <= 'T') goto yy53;
			goto yy827;
		} else {
			if(yych <= 'p') {
				if(yych <= 'o') goto yy53;
				goto yy828;
			} else {
				if(yych == 'u') goto yy827;
				goto yy53;
			}
		}
yy791:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy825;
		if(yych == 'e') goto yy825;
		goto yy53;
yy792:
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy824;
		if(yych == 'c') goto yy824;
		goto yy53;
yy793:
		yych = *++YYCURSOR;
		if(yych == 'O') goto yy823;
		if(yych == 'o') goto yy823;
		goto yy53;
yy794:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy795;
		if(yych != 'e') goto yy53;
yy795:
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy796;
		if(yych != 'c') goto yy53;
yy796:
		yych = *++YYCURSOR;
		if(yych != '/') goto yy53;
yy797:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
		yych = *++YYCURSOR;
		if(yych != ':') goto yy53;
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '1') goto yy803;
		if(yych <= '2') goto yy804;
		goto yy53;
yy803:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy805;
		goto yy53;
yy804:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= '4') goto yy53;
yy805:
		yych = *++YYCURSOR;
		if(yych != ':') goto yy53;
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= '6') goto yy53;
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
		yych = *++YYCURSOR;
		if(yych != ':') goto yy53;
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy810;
		if(yych <= '6') goto yy811;
		goto yy53;
yy810:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy812;
		goto yy53;
yy811:
		yych = *++YYCURSOR;
		if(yych != '0') goto yy53;
yy812:
		yych = *++YYCURSOR;
		if(yych != ' ') goto yy53;
yy813:
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
		yych = *YYCURSOR;
		if(yych <= '*') {
			if(yych == ' ') goto yy813;
			goto yy53;
		} else {
			if(yych == ',') goto yy53;
			if(yych >= '.') goto yy53;
		}
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '1') goto yy816;
		if(yych <= '2') goto yy818;
		if(yych <= '9') goto yy819;
		goto yy53;
yy816:
		++YYCURSOR;
		if((yych = *YYCURSOR) <= '/') goto yy817;
		if(yych <= '9') goto yy819;
		if(yych <= ':') goto yy820;
yy817:
#line 1264 "parse_date.g.re"
		{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		s->errors += tz_not_found;
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 10746 "<stdout>"
yy818:
		yych = *++YYCURSOR;
		if(yych <= '5') {
			if(yych <= '/') goto yy817;
			if(yych >= '4') goto yy821;
		} else {
			if(yych <= '9') goto yy822;
			if(yych <= ':') goto yy820;
			goto yy817;
		}
yy819:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy817;
		if(yych <= '5') goto yy821;
		if(yych <= '9') goto yy822;
		if(yych >= ';') goto yy817;
yy820:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy817;
		if(yych <= '5') goto yy821;
		if(yych <= '9') goto yy822;
		goto yy817;
yy821:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy817;
		if(yych >= ':') goto yy817;
yy822:
		yych = *++YYCURSOR;
		goto yy817;
yy823:
		yych = *++YYCURSOR;
		if(yych == 'V') goto yy796;
		if(yych == 'v') goto yy796;
		goto yy53;
yy824:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy796;
		if(yych == 't') goto yy796;
		goto yy53;
yy825:
		yych = *++YYCURSOR;
		if(yych == 'P') goto yy826;
		if(yych != 'p') goto yy53;
yy826:
		yych = *++YYCURSOR;
		if(yych <= 'S') {
			if(yych == '/') goto yy797;
			goto yy53;
		} else {
			if(yych <= 'T') goto yy796;
			if(yych == 't') goto yy796;
			goto yy53;
		}
yy827:
		yych = *++YYCURSOR;
		if(yych == 'G') goto yy796;
		if(yych == 'g') goto yy796;
		goto yy53;
yy828:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy796;
		if(yych == 'r') goto yy796;
		goto yy53;
yy829:
		yych = *++YYCURSOR;
		if(yych <= 'Y') {
			if(yych == 'R') goto yy796;
			if(yych <= 'X') goto yy53;
			goto yy796;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy53;
				goto yy796;
			} else {
				if(yych == 'y') goto yy796;
				goto yy53;
			}
		}
yy830:
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy796;
		if(yych == 'b') goto yy796;
		goto yy53;
yy831:
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych == 'L') goto yy796;
			if(yych <= 'M') goto yy53;
			goto yy796;
		} else {
			if(yych <= 'l') {
				if(yych <= 'k') goto yy53;
				goto yy796;
			} else {
				if(yych == 'n') goto yy796;
				goto yy53;
			}
		}
yy832:
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy796;
		if(yych == 'n') goto yy796;
		goto yy53;
yy833:
		yych = *++YYCURSOR;
		if(yych == 't') goto yy842;
		goto yy53;
yy834:
		yych = *++YYCURSOR;
		if(yych == 'd') goto yy842;
		goto yy53;
yy835:
		yych = *++YYCURSOR;
		if(yych == 'd') goto yy842;
		goto yy53;
yy836:
		yych = *++YYCURSOR;
		if(yych == 'h') goto yy842;
		goto yy53;
yy837:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy784;
		if(yych >= ':') goto yy784;
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy784;
		if(yych >= ':') goto yy784;
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy784;
		if(yych >= ':') goto yy784;
		yych = *++YYCURSOR;
		goto yy784;
yy842:
		yyaccept = 13;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '/') goto yy837;
		goto yy784;
yy843:
		yych = *++YYCURSOR;
		if(yych <= '-') goto yy617;
		if(yych <= '.') goto yy845;
		if(yych >= '0') goto yy617;
yy844:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy790,  &&yy53,   &&yy53,   &&yy794,  &&yy53,   &&yy788,  &&yy53,
				&&yy53,   &&yy53,   &&yy787,  &&yy53,   &&yy53,   &&yy789,  &&yy793,  &&yy792,
				&&yy53,   &&yy53,   &&yy53,   &&yy791,  &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy790,  &&yy53,   &&yy53,   &&yy794,  &&yy53,   &&yy788,  &&yy53,
				&&yy53,   &&yy53,   &&yy787,  &&yy53,   &&yy53,   &&yy789,  &&yy793,  &&yy792,
				&&yy53,   &&yy53,   &&yy53,   &&yy791,  &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53
			};
			goto *yytarget[yych];
		}
yy845:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy617;
		if(yych <= '0') goto yy846;
		if(yych <= '1') goto yy847;
		if(yych <= '9') goto yy848;
		goto yy617;
yy846:
		yych = *++YYCURSOR;
		if(yych == '.') goto yy849;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy848;
		goto yy53;
yy847:
		yych = *++YYCURSOR;
		if(yych == '.') goto yy849;
		if(yych <= '/') goto yy53;
		if(yych >= '3') goto yy53;
yy848:
		yych = *++YYCURSOR;
		if(yych != '.') goto yy53;
yy849:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy729;
		if(yych <= '9') goto yy728;
		goto yy729;
yy851:
		yych = *++YYCURSOR;
		if(yych == '-') goto yy852;
		if(yych <= '/') goto yy57;
		if(yych <= '9') goto yy879;
		goto yy57;
yy852:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy734,  &&yy735,  &&yy736,  &&yy736,  &&yy736,  &&yy736,  &&yy736,  &&yy736,
				&&yy736,  &&yy736,  &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy856,  &&yy53,   &&yy53,   &&yy860,  &&yy53,   &&yy854,  &&yy53,
				&&yy53,   &&yy53,   &&yy853,  &&yy53,   &&yy53,   &&yy855,  &&yy859,  &&yy858,
				&&yy53,   &&yy53,   &&yy53,   &&yy857,  &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy856,  &&yy53,   &&yy53,   &&yy860,  &&yy53,   &&yy854,  &&yy53,
				&&yy53,   &&yy53,   &&yy853,  &&yy53,   &&yy53,   &&yy855,  &&yy859,  &&yy858,
				&&yy53,   &&yy53,   &&yy53,   &&yy857,  &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53
			};
			goto *yytarget[yych];
		}
yy853:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'A') goto yy878;
			if(yych <= 'T') goto yy53;
			goto yy877;
		} else {
			if(yych <= 'a') {
				if(yych <= '`') goto yy53;
				goto yy878;
			} else {
				if(yych == 'u') goto yy877;
				goto yy53;
			}
		}
yy854:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy876;
		if(yych == 'e') goto yy876;
		goto yy53;
yy855:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy875;
		if(yych == 'a') goto yy875;
		goto yy53;
yy856:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'P') goto yy874;
			if(yych <= 'T') goto yy53;
			goto yy873;
		} else {
			if(yych <= 'p') {
				if(yych <= 'o') goto yy53;
				goto yy874;
			} else {
				if(yych == 'u') goto yy873;
				goto yy53;
			}
		}
yy857:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy871;
		if(yych == 'e') goto yy871;
		goto yy53;
yy858:
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy870;
		if(yych == 'c') goto yy870;
		goto yy53;
yy859:
		yych = *++YYCURSOR;
		if(yych == 'O') goto yy869;
		if(yych == 'o') goto yy869;
		goto yy53;
yy860:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy861;
		if(yych != 'e') goto yy53;
yy861:
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy862;
		if(yych != 'c') goto yy53;
yy862:
		yych = *++YYCURSOR;
		if(yych != '-') goto yy53;
yy863:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '0') goto yy864;
		if(yych <= '2') goto yy865;
		if(yych <= '3') goto yy866;
		goto yy53;
yy864:
		yych = *++YYCURSOR;
		if(yych <= '0') goto yy53;
		if(yych <= '9') goto yy867;
		goto yy53;
yy865:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy867;
		goto yy53;
yy866:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= '2') goto yy53;
yy867:
		++YYCURSOR;
#line 1251 "parse_date.g.re"
		{
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 11105 "<stdout>"
yy869:
		yych = *++YYCURSOR;
		if(yych == 'V') goto yy862;
		if(yych == 'v') goto yy862;
		goto yy53;
yy870:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy862;
		if(yych == 't') goto yy862;
		goto yy53;
yy871:
		yych = *++YYCURSOR;
		if(yych == 'P') goto yy872;
		if(yych != 'p') goto yy53;
yy872:
		yych = *++YYCURSOR;
		if(yych <= 'S') {
			if(yych == '-') goto yy863;
			goto yy53;
		} else {
			if(yych <= 'T') goto yy862;
			if(yych == 't') goto yy862;
			goto yy53;
		}
yy873:
		yych = *++YYCURSOR;
		if(yych == 'G') goto yy862;
		if(yych == 'g') goto yy862;
		goto yy53;
yy874:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy862;
		if(yych == 'r') goto yy862;
		goto yy53;
yy875:
		yych = *++YYCURSOR;
		if(yych <= 'Y') {
			if(yych == 'R') goto yy862;
			if(yych <= 'X') goto yy53;
			goto yy862;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy53;
				goto yy862;
			} else {
				if(yych == 'y') goto yy862;
				goto yy53;
			}
		}
yy876:
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy862;
		if(yych == 'b') goto yy862;
		goto yy53;
yy877:
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych == 'L') goto yy862;
			if(yych <= 'M') goto yy53;
			goto yy862;
		} else {
			if(yych <= 'l') {
				if(yych <= 'k') goto yy53;
				goto yy862;
			} else {
				if(yych == 'n') goto yy862;
				goto yy53;
			}
		}
yy878:
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy862;
		if(yych == 'n') goto yy862;
		goto yy53;
yy879:
		yyaccept = 14;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,
				&&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,
				&&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,
				&&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,
				&&yy884,  &&yy884,  &&yy884,  &&yy884,  &&yy884,  &&yy884,  &&yy884,  &&yy884,
				&&yy884,  &&yy884,  &&yy884,  &&yy884,  &&yy884,  &&yy881,  &&yy887,  &&yy882,
				&&yy900,  &&yy901,  &&yy903,  &&yy904,  &&yy51,   &&yy51,   &&yy51,   &&yy51,
				&&yy51,   &&yy51,   &&yy902,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,
				&&yy880,  &&yy884,  &&yy880,  &&yy880,  &&yy884,  &&yy880,  &&yy884,  &&yy880,
				&&yy884,  &&yy884,  &&yy884,  &&yy880,  &&yy880,  &&yy884,  &&yy884,  &&yy884,
				&&yy880,  &&yy880,  &&yy880,  &&yy884,  &&yy884,  &&yy880,  &&yy884,  &&yy905,
				&&yy884,  &&yy884,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,
				&&yy880,  &&yy884,  &&yy880,  &&yy880,  &&yy884,  &&yy880,  &&yy884,  &&yy880,
				&&yy884,  &&yy880,  &&yy884,  &&yy880,  &&yy880,  &&yy884,  &&yy884,  &&yy884,
				&&yy880,  &&yy880,  &&yy880,  &&yy884,  &&yy884,  &&yy880,  &&yy880,  &&yy884,
				&&yy880,  &&yy884,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,
				&&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,
				&&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,
				&&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,
				&&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,
				&&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,
				&&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,
				&&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,
				&&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,
				&&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,
				&&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,
				&&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,
				&&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,
				&&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,
				&&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,
				&&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,
				&&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880,  &&yy880
			};
			goto *yytarget[yych];
		}
yy880:
#line 1283 "parse_date.g.re"
		{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 11229 "<stdout>"
yy881:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy1065, &&yy1066, &&yy1067, &&yy1067, &&yy1067, &&yy1067, &&yy1067, &&yy1067,
				&&yy1067, &&yy1067, &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy886,  &&yy1060, &&yy886,  &&yy886,  &&yy1064, &&yy886,  &&yy1058, &&yy886,
				&&yy886,  &&yy886,  &&yy1057, &&yy886,  &&yy886,  &&yy1059, &&yy1063, &&yy1062,
				&&yy886,  &&yy886,  &&yy886,  &&yy1061, &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy886,  &&yy1060, &&yy886,  &&yy886,  &&yy1064, &&yy886,  &&yy1058, &&yy886,
				&&yy886,  &&yy886,  &&yy1057, &&yy886,  &&yy886,  &&yy1059, &&yy1063, &&yy1062,
				&&yy886,  &&yy886,  &&yy886,  &&yy1061, &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,
				&&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886,  &&yy886
			};
			goto *yytarget[yych];
		}
yy882:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '0') goto yy1038;
		if(yych <= '1') goto yy1039;
		if(yych <= '9') goto yy1040;
		goto yy53;
yy883:
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
		yych = *YYCURSOR;
yy884:
		{
			static void *yytarget[256] = {
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy883,  &&yy885,  &&yy885,  &&yy885,  &&yy885,  &&yy885,  &&yy885,  &&yy885,
				&&yy885,  &&yy885,  &&yy885,  &&yy885,  &&yy885,  &&yy885,  &&yy885,  &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy895,  &&yy53,   &&yy53,   &&yy899,  &&yy53,   &&yy893,  &&yy53,
				&&yy60,   &&yy888,  &&yy892,  &&yy53,   &&yy53,   &&yy894,  &&yy898,  &&yy897,
				&&yy53,   &&yy53,   &&yy53,   &&yy896,  &&yy65,   &&yy53,   &&yy890,  &&yy62,
				&&yy891,  &&yy64,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy895,  &&yy53,   &&yy53,   &&yy899,  &&yy53,   &&yy893,  &&yy53,
				&&yy60,   &&yy53,   &&yy892,  &&yy53,   &&yy53,   &&yy894,  &&yy898,  &&yy897,
				&&yy53,   &&yy53,   &&yy53,   &&yy896,  &&yy65,   &&yy53,   &&yy53,   &&yy62,
				&&yy53,   &&yy64,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53
			};
			goto *yytarget[yych];
		}
yy885:
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
		yych = *YYCURSOR;
yy886:
		{
			static void *yytarget[256] = {
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy885,  &&yy885,  &&yy885,  &&yy885,  &&yy885,  &&yy885,  &&yy885,  &&yy885,
				&&yy885,  &&yy885,  &&yy885,  &&yy885,  &&yy885,  &&yy885,  &&yy885,  &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy895,  &&yy53,   &&yy53,   &&yy1030, &&yy53,   &&yy1027, &&yy53,
				&&yy53,   &&yy888,  &&yy892,  &&yy53,   &&yy53,   &&yy1028, &&yy898,  &&yy897,
				&&yy53,   &&yy53,   &&yy53,   &&yy1029, &&yy53,   &&yy53,   &&yy890,  &&yy53,
				&&yy891,  &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy895,  &&yy53,   &&yy53,   &&yy1030, &&yy53,   &&yy1027, &&yy53,
				&&yy53,   &&yy53,   &&yy892,  &&yy53,   &&yy53,   &&yy1028, &&yy898,  &&yy897,
				&&yy53,   &&yy53,   &&yy53,   &&yy1029, &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53
			};
			goto *yytarget[yych];
		}
yy887:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy886;
		if(yych <= '0') goto yy1024;
		if(yych <= '2') goto yy1025;
		if(yych <= '3') goto yy1026;
		goto yy886;
yy888:
		++YYCURSOR;
		if((yych = *YYCURSOR) <= 'U') {
			if(yych == 'I') goto yy1023;
		} else {
			if(yych == 'W') goto yy889;
			if(yych <= 'X') goto yy977;
		}
yy889:
#line 1113 "parse_date.g.re"
		{
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 11388 "<stdout>"
yy890:
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy1021;
		goto yy889;
yy891:
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy1020;
		goto yy889;
yy892:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'A') goto yy1013;
			if(yych <= 'T') goto yy53;
			goto yy1012;
		} else {
			if(yych <= 'a') {
				if(yych <= '`') goto yy53;
				goto yy1013;
			} else {
				if(yych == 'u') goto yy1012;
				goto yy53;
			}
		}
yy893:
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych <= 'N') {
				if(yych == 'E') goto yy1006;
				goto yy53;
			} else {
				if(yych <= 'O') goto yy83;
				if(yych <= 'Q') goto yy53;
				goto yy82;
			}
		} else {
			if(yych <= 'n') {
				if(yych == 'e') goto yy1006;
				goto yy53;
			} else {
				if(yych <= 'o') goto yy83;
				if(yych == 'r') goto yy82;
				goto yy53;
			}
		}
yy894:
		yych = *++YYCURSOR;
		if(yych <= 'O') {
			if(yych <= 'H') {
				if(yych == 'A') goto yy1003;
				goto yy53;
			} else {
				if(yych <= 'I') goto yy110;
				if(yych <= 'N') goto yy53;
				goto yy109;
			}
		} else {
			if(yych <= 'h') {
				if(yych == 'a') goto yy1003;
				goto yy53;
			} else {
				if(yych <= 'i') goto yy110;
				if(yych == 'o') goto yy109;
				goto yy53;
			}
		}
yy895:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'P') goto yy997;
			if(yych <= 'T') goto yy53;
			goto yy996;
		} else {
			if(yych <= 'p') {
				if(yych <= 'o') goto yy53;
				goto yy997;
			} else {
				if(yych == 'u') goto yy996;
				goto yy53;
			}
		}
yy896:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych <= 'D') {
				if(yych == 'A') goto yy119;
				goto yy53;
			} else {
				if(yych <= 'E') goto yy989;
				if(yych <= 'T') goto yy53;
				goto yy118;
			}
		} else {
			if(yych <= 'd') {
				if(yych == 'a') goto yy119;
				goto yy53;
			} else {
				if(yych <= 'e') goto yy989;
				if(yych == 'u') goto yy118;
				goto yy53;
			}
		}
yy897:
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy984;
		if(yych == 'c') goto yy984;
		goto yy53;
yy898:
		yych = *++YYCURSOR;
		if(yych == 'O') goto yy978;
		if(yych == 'o') goto yy978;
		goto yy53;
yy899:
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych == 'A') goto yy106;
			if(yych <= 'D') goto yy53;
			goto yy971;
		} else {
			if(yych <= 'a') {
				if(yych <= '`') goto yy53;
				goto yy106;
			} else {
				if(yych == 'e') goto yy971;
				goto yy53;
			}
		}
yy900:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '0') goto yy969;
		if(yych <= '9') goto yy970;
		goto yy57;
yy901:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '2') goto yy938;
		if(yych <= '9') goto yy917;
		goto yy57;
yy902:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '0') goto yy918;
		if(yych <= '1') goto yy919;
		goto yy53;
yy903:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '9') goto yy917;
		goto yy57;
yy904:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '5') goto yy913;
		if(yych <= '6') goto yy914;
		if(yych <= '9') goto yy51;
		goto yy57;
yy905:
		yych = *++YYCURSOR;
		if(yych <= '5') {
			if(yych <= '/') goto yy53;
			if(yych <= '0') goto yy906;
			if(yych <= '4') goto yy907;
			goto yy908;
		} else {
			if(yych <= 'E') {
				if(yych <= 'D') goto yy53;
				goto yy98;
			} else {
				if(yych == 'e') goto yy98;
				goto yy53;
			}
		}
yy906:
		yych = *++YYCURSOR;
		if(yych <= '0') goto yy53;
		if(yych <= '9') goto yy909;
		goto yy53;
yy907:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy909;
		goto yy53;
yy908:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= '4') goto yy53;
yy909:
		++YYCURSOR;
		if((yych = *YYCURSOR) <= '/') goto yy910;
		if(yych <= '7') goto yy911;
yy910:
#line 1219 "parse_date.g.re"
		{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 11598 "<stdout>"
yy911:
		++YYCURSOR;
#line 1200 "parse_date.g.re"
		{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 11619 "<stdout>"
yy913:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '9') goto yy915;
		goto yy57;
yy914:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '6') goto yy915;
		if(yych <= '9') goto yy51;
		goto yy57;
yy915:
		yyaccept = 15;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy57,   &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy51,   &&yy51,   &&yy51,   &&yy51,   &&yy51,   &&yy51,   &&yy51,   &&yy51,
				&&yy51,   &&yy51,   &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy57,   &&yy916,  &&yy57,   &&yy916,
				&&yy57,   &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy57,   &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy57,   &&yy57,   &&yy916,  &&yy916,  &&yy57,
				&&yy916,  &&yy57,   &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy57,   &&yy916,  &&yy57,   &&yy916,
				&&yy57,   &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy57,   &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy57,   &&yy57,   &&yy916,  &&yy916,  &&yy57,
				&&yy916,  &&yy57,   &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916
			};
			goto *yytarget[yych];
		}
yy916:
#line 1187 "parse_date.g.re"
		{
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
#line 11684 "<stdout>"
yy917:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '9') goto yy915;
		goto yy57;
yy918:
		yych = *++YYCURSOR;
		if(yych <= '0') goto yy53;
		if(yych <= '9') goto yy920;
		goto yy53;
yy919:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= '3') goto yy53;
yy920:
		yych = *++YYCURSOR;
		if(yych != ':') goto yy53;
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '0') goto yy922;
		if(yych <= '2') goto yy923;
		if(yych <= '3') goto yy924;
		goto yy53;
yy922:
		yych = *++YYCURSOR;
		if(yych <= '0') goto yy53;
		if(yych <= '9') goto yy925;
		goto yy53;
yy923:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy925;
		goto yy53;
yy924:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= '2') goto yy53;
yy925:
		yych = *++YYCURSOR;
		if(yych != ' ') goto yy53;
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '1') goto yy927;
		if(yych <= '2') goto yy928;
		goto yy53;
yy927:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy929;
		goto yy53;
yy928:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= '4') goto yy53;
yy929:
		yych = *++YYCURSOR;
		if(yych != ':') goto yy53;
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= '6') goto yy53;
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
		yych = *++YYCURSOR;
		if(yych != ':') goto yy53;
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy934;
		if(yych <= '6') goto yy935;
		goto yy53;
yy934:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy936;
		goto yy53;
yy935:
		yych = *++YYCURSOR;
		if(yych != '0') goto yy53;
yy936:
		++YYCURSOR;
yy937:
#line 1163 "parse_date.g.re"
		{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->f = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
				s->errors += tz_not_found;
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
#line 11789 "<stdout>"
yy938:
		yych = *++YYCURSOR;
		if(yych <= '2') {
			if(yych <= '/') goto yy57;
			if(yych >= '1') goto yy940;
		} else {
			if(yych <= '3') goto yy941;
			if(yych <= '9') goto yy915;
			goto yy57;
		}
yy939:
		yyaccept = 15;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy57,   &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy51,   &&yy942,  &&yy942,  &&yy942,  &&yy942,  &&yy942,  &&yy942,  &&yy942,
				&&yy942,  &&yy942,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy57,   &&yy916,  &&yy57,   &&yy916,
				&&yy57,   &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy57,   &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy57,   &&yy57,   &&yy916,  &&yy916,  &&yy57,
				&&yy916,  &&yy57,   &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy57,   &&yy916,  &&yy57,   &&yy916,
				&&yy57,   &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy57,   &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy57,   &&yy57,   &&yy916,  &&yy916,  &&yy57,
				&&yy916,  &&yy57,   &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916
			};
			goto *yytarget[yych];
		}
yy940:
		yyaccept = 15;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy57,   &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy942,  &&yy942,  &&yy942,  &&yy942,  &&yy942,  &&yy942,  &&yy942,  &&yy942,
				&&yy942,  &&yy942,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy57,   &&yy916,  &&yy57,   &&yy916,
				&&yy57,   &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy57,   &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy57,   &&yy57,   &&yy916,  &&yy916,  &&yy57,
				&&yy916,  &&yy57,   &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy57,   &&yy916,  &&yy57,   &&yy916,
				&&yy57,   &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy57,   &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy57,   &&yy57,   &&yy916,  &&yy916,  &&yy57,
				&&yy916,  &&yy57,   &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916
			};
			goto *yytarget[yych];
		}
yy941:
		yyaccept = 15;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy57,   &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy942,  &&yy942,  &&yy51,   &&yy51,   &&yy51,   &&yy51,   &&yy51,   &&yy51,
				&&yy51,   &&yy51,   &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy57,   &&yy916,  &&yy57,   &&yy916,
				&&yy57,   &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy57,   &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy57,   &&yy57,   &&yy916,  &&yy916,  &&yy57,
				&&yy916,  &&yy57,   &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy57,   &&yy916,  &&yy57,   &&yy916,
				&&yy57,   &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy57,   &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy57,   &&yy57,   &&yy916,  &&yy916,  &&yy57,
				&&yy916,  &&yy57,   &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,
				&&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916,  &&yy916
			};
			goto *yytarget[yych];
		}
yy942:
		yyaccept = 16;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,
				&&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,
				&&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,
				&&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,
				&&yy56,   &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,
				&&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,
				&&yy51,   &&yy51,   &&yy51,   &&yy51,   &&yy51,   &&yy51,   &&yy51,   &&yy51,
				&&yy51,   &&yy51,   &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,
				&&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy61,   &&yy943,  &&yy63,   &&yy943,
				&&yy60,   &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy59,   &&yy943,  &&yy943,
				&&yy943,  &&yy943,  &&yy943,  &&yy58,   &&yy944,  &&yy943,  &&yy943,  &&yy62,
				&&yy943,  &&yy64,   &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,
				&&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy61,   &&yy943,  &&yy63,   &&yy943,
				&&yy60,   &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy59,   &&yy943,  &&yy943,
				&&yy943,  &&yy943,  &&yy943,  &&yy58,   &&yy945,  &&yy943,  &&yy943,  &&yy62,
				&&yy943,  &&yy64,   &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,
				&&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,
				&&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,
				&&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,
				&&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,
				&&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,
				&&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,
				&&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,
				&&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,
				&&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,
				&&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,
				&&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,
				&&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,
				&&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,
				&&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,
				&&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,
				&&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943,  &&yy943
			};
			goto *yytarget[yych];
		}
yy943:
#line 1151 "parse_date.g.re"
		{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
#line 11972 "<stdout>"
yy944:
		yych = *++YYCURSOR;
		if(yych <= 'H') {
			if(yych <= '2') {
				if(yych <= '/') goto yy53;
				if(yych <= '1') goto yy959;
				goto yy960;
			} else {
				if(yych <= '9') goto yy961;
				if(yych <= 'G') goto yy53;
				goto yy66;
			}
		} else {
			if(yych <= 'g') {
				if(yych == 'U') goto yy67;
				goto yy53;
			} else {
				if(yych <= 'h') goto yy66;
				if(yych == 'u') goto yy67;
				goto yy53;
			}
		}
yy945:
		yych = *++YYCURSOR;
		if(yych <= 'H') {
			if(yych <= '2') {
				if(yych <= '/') goto yy53;
				if(yych >= '2') goto yy947;
			} else {
				if(yych <= '9') goto yy948;
				if(yych <= 'G') goto yy53;
				goto yy66;
			}
		} else {
			if(yych <= 'g') {
				if(yych == 'U') goto yy67;
				goto yy53;
			} else {
				if(yych <= 'h') goto yy66;
				if(yych == 'u') goto yy67;
				goto yy53;
			}
		}
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy953;
		if(yych <= '9') goto yy948;
		goto yy53;
yy947:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '3') goto yy953;
		if(yych <= '5') goto yy949;
		goto yy53;
yy948:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= '6') goto yy53;
yy949:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
yy950:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy951;
		if(yych <= '6') goto yy952;
		goto yy53;
yy951:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy936;
		goto yy53;
yy952:
		yych = *++YYCURSOR;
		if(yych == '0') goto yy936;
		goto yy53;
yy953:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy954;
		if(yych <= '9') goto yy950;
		goto yy53;
yy954:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy955;
		if(yych <= '6') goto yy956;
		if(yych <= '9') goto yy950;
		goto yy53;
yy955:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy957;
		if(yych <= '6') goto yy958;
		if(yych <= '9') goto yy936;
		goto yy53;
yy956:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '0') goto yy957;
		if(yych <= '5') goto yy951;
		if(yych <= '6') goto yy952;
		goto yy53;
yy957:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy937;
		if(yych <= '9') goto yy936;
		goto yy937;
yy958:
		yych = *++YYCURSOR;
		if(yych == '0') goto yy936;
		goto yy937;
yy959:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy968;
		if(yych <= '9') goto yy961;
		if(yych <= ':') goto yy962;
		goto yy53;
yy960:
		yych = *++YYCURSOR;
		if(yych <= '5') {
			if(yych <= '/') goto yy53;
			if(yych <= '3') goto yy968;
			goto yy949;
		} else {
			if(yych == ':') goto yy962;
			goto yy53;
		}
yy961:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy949;
		if(yych != ':') goto yy53;
yy962:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= '6') goto yy53;
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
		yych = *++YYCURSOR;
		if(yych != ':') goto yy53;
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy966;
		if(yych <= '6') goto yy967;
		goto yy53;
yy966:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy936;
		goto yy53;
yy967:
		yych = *++YYCURSOR;
		if(yych == '0') goto yy936;
		goto yy53;
yy968:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy954;
		if(yych <= '9') goto yy950;
		if(yych <= ':') goto yy962;
		goto yy53;
yy969:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '0') goto yy51;
		if(yych <= '9') goto yy915;
		goto yy57;
yy970:
		yych = *++YYCURSOR;
		if(yych <= '2') {
			if(yych <= '/') goto yy57;
			if(yych <= '0') goto yy939;
			goto yy940;
		} else {
			if(yych <= '3') goto yy941;
			if(yych <= '9') goto yy915;
			goto yy57;
		}
yy971:
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy972;
		if(yych != 'c') goto yy53;
yy972:
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'E') goto yy973;
		if(yych != 'e') goto yy889;
yy973:
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy974;
		if(yych != 'm') goto yy53;
yy974:
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy975;
		if(yych != 'b') goto yy53;
yy975:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy976;
		if(yych != 'e') goto yy53;
yy976:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy977;
		if(yych != 'r') goto yy53;
yy977:
		yych = *++YYCURSOR;
		goto yy889;
yy978:
		yych = *++YYCURSOR;
		if(yych == 'V') goto yy979;
		if(yych != 'v') goto yy53;
yy979:
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'E') goto yy980;
		if(yych != 'e') goto yy889;
yy980:
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy981;
		if(yych != 'm') goto yy53;
yy981:
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy982;
		if(yych != 'b') goto yy53;
yy982:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy983;
		if(yych != 'e') goto yy53;
yy983:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy977;
		if(yych == 'r') goto yy977;
		goto yy53;
yy984:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy985;
		if(yych != 't') goto yy53;
yy985:
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'O') goto yy986;
		if(yych != 'o') goto yy889;
yy986:
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy987;
		if(yych != 'b') goto yy53;
yy987:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy988;
		if(yych != 'e') goto yy53;
yy988:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy977;
		if(yych == 'r') goto yy977;
		goto yy53;
yy989:
		yych = *++YYCURSOR;
		if(yych <= 'P') {
			if(yych == 'C') goto yy121;
			if(yych <= 'O') goto yy53;
		} else {
			if(yych <= 'c') {
				if(yych <= 'b') goto yy53;
				goto yy121;
			} else {
				if(yych != 'p') goto yy53;
			}
		}
yy990:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy991;
		if(yych != 't') goto yy889;
yy991:
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'E') goto yy992;
		if(yych != 'e') goto yy889;
yy992:
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy993;
		if(yych != 'm') goto yy53;
yy993:
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy994;
		if(yych != 'b') goto yy53;
yy994:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy995;
		if(yych != 'e') goto yy53;
yy995:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy977;
		if(yych == 'r') goto yy977;
		goto yy53;
yy996:
		yych = *++YYCURSOR;
		if(yych == 'G') goto yy1000;
		if(yych == 'g') goto yy1000;
		goto yy53;
yy997:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy998;
		if(yych != 'r') goto yy53;
yy998:
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'I') goto yy999;
		if(yych != 'i') goto yy889;
yy999:
		yych = *++YYCURSOR;
		if(yych == 'L') goto yy977;
		if(yych == 'l') goto yy977;
		goto yy53;
yy1000:
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'U') goto yy1001;
		if(yych != 'u') goto yy889;
yy1001:
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy1002;
		if(yych != 's') goto yy53;
yy1002:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy977;
		if(yych == 't') goto yy977;
		goto yy53;
yy1003:
		yych = *++YYCURSOR;
		if(yych <= 'Y') {
			if(yych == 'R') goto yy1004;
			if(yych <= 'X') goto yy53;
			goto yy977;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy53;
			} else {
				if(yych == 'y') goto yy977;
				goto yy53;
			}
		}
yy1004:
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'C') goto yy1005;
		if(yych != 'c') goto yy889;
yy1005:
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy977;
		if(yych == 'h') goto yy977;
		goto yy53;
yy1006:
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy1007;
		if(yych != 'b') goto yy53;
yy1007:
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'R') goto yy1008;
		if(yych != 'r') goto yy889;
yy1008:
		yych = *++YYCURSOR;
		if(yych == 'U') goto yy1009;
		if(yych != 'u') goto yy53;
yy1009:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy1010;
		if(yych != 'a') goto yy53;
yy1010:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy1011;
		if(yych != 'r') goto yy53;
yy1011:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy977;
		if(yych == 'y') goto yy977;
		goto yy53;
yy1012:
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych == 'L') goto yy1019;
			if(yych <= 'M') goto yy53;
			goto yy1018;
		} else {
			if(yych <= 'l') {
				if(yych <= 'k') goto yy53;
				goto yy1019;
			} else {
				if(yych == 'n') goto yy1018;
				goto yy53;
			}
		}
yy1013:
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy1014;
		if(yych != 'n') goto yy53;
yy1014:
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'U') goto yy1015;
		if(yych != 'u') goto yy889;
yy1015:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy1016;
		if(yych != 'a') goto yy53;
yy1016:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy1017;
		if(yych != 'r') goto yy53;
yy1017:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy977;
		if(yych == 'y') goto yy977;
		goto yy53;
yy1018:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy977;
		if(yych == 'e') goto yy977;
		goto yy889;
yy1019:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy977;
		if(yych == 'y') goto yy977;
		goto yy889;
yy1020:
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy977;
		goto yy889;
yy1021:
		yych = *++YYCURSOR;
		if(yych != 'I') goto yy889;
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy977;
		goto yy889;
yy1023:
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy977;
		goto yy889;
yy1024:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '0') goto yy1037;
		if(yych <= '9') goto yy1036;
		goto yy53;
yy1025:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy1035;
		goto yy53;
yy1026:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy1033;
		if(yych <= '6') goto yy1032;
		goto yy53;
yy1027:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy1006;
		if(yych == 'e') goto yy1006;
		goto yy53;
yy1028:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy1003;
		if(yych == 'a') goto yy1003;
		goto yy53;
yy1029:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy1031;
		if(yych == 'e') goto yy1031;
		goto yy53;
yy1030:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy971;
		if(yych == 'e') goto yy971;
		goto yy53;
yy1031:
		yych = *++YYCURSOR;
		if(yych == 'P') goto yy990;
		if(yych == 'p') goto yy990;
		goto yy53;
yy1032:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '6') goto yy1034;
		goto yy53;
yy1033:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
yy1034:
		yych = *++YYCURSOR;
		goto yy916;
yy1035:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy1034;
		goto yy53;
yy1036:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy1034;
		goto yy53;
yy1037:
		yych = *++YYCURSOR;
		if(yych <= '0') goto yy53;
		if(yych <= '9') goto yy1034;
		goto yy53;
yy1038:
		yych = *++YYCURSOR;
		if(yych <= '.') goto yy53;
		if(yych <= '/') goto yy1041;
		if(yych <= '0') goto yy1040;
		if(yych <= '9') goto yy1051;
		goto yy53;
yy1039:
		yych = *++YYCURSOR;
		if(yych <= '.') goto yy53;
		if(yych <= '/') goto yy1041;
		if(yych <= '2') goto yy1051;
		goto yy53;
yy1040:
		yych = *++YYCURSOR;
		if(yych != '/') goto yy53;
yy1041:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '2') goto yy1042;
		if(yych <= '3') goto yy1044;
		if(yych <= '9') goto yy1045;
		goto yy53;
yy1042:
		yyaccept = 18;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych <= '/') goto yy1043;
			if(yych <= '9') goto yy1045;
			if(yych >= 'n') goto yy1047;
		} else {
			if(yych <= 'r') {
				if(yych >= 'r') goto yy1048;
			} else {
				if(yych <= 's') goto yy1046;
				if(yych <= 't') goto yy1049;
			}
		}
yy1043:
#line 1048 "parse_date.g.re"
		{
		DEBUG_OUTPUT("iso8601date | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 12533 "<stdout>"
yy1044:
		yyaccept = 18;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych <= '/') goto yy1043;
			if(yych <= '1') goto yy1045;
			if(yych <= 'm') goto yy1043;
			goto yy1047;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy1043;
				goto yy1048;
			} else {
				if(yych <= 's') goto yy1046;
				if(yych <= 't') goto yy1049;
				goto yy1043;
			}
		}
yy1045:
		yyaccept = 18;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'q') {
			if(yych == 'n') goto yy1047;
			goto yy1043;
		} else {
			if(yych <= 'r') goto yy1048;
			if(yych <= 's') goto yy1046;
			if(yych <= 't') goto yy1049;
			goto yy1043;
		}
yy1046:
		yych = *++YYCURSOR;
		if(yych == 't') goto yy1050;
		goto yy53;
yy1047:
		yych = *++YYCURSOR;
		if(yych == 'd') goto yy1050;
		goto yy53;
yy1048:
		yych = *++YYCURSOR;
		if(yych == 'd') goto yy1050;
		goto yy53;
yy1049:
		yych = *++YYCURSOR;
		if(yych != 'h') goto yy53;
yy1050:
		yych = *++YYCURSOR;
		goto yy1043;
yy1051:
		yych = *++YYCURSOR;
		if(yych != '/') goto yy53;
		yych = *++YYCURSOR;
		if(yych <= '2') {
			if(yych <= '/') goto yy53;
			if(yych >= '1') goto yy1054;
		} else {
			if(yych <= '3') goto yy1055;
			if(yych <= '9') goto yy1045;
			goto yy53;
		}
		yyaccept = 18;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych <= '0') {
				if(yych <= '/') goto yy1043;
				goto yy1045;
			} else {
				if(yych <= '9') goto yy1056;
				if(yych <= 'm') goto yy1043;
				goto yy1047;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy1043;
				goto yy1048;
			} else {
				if(yych <= 's') goto yy1046;
				if(yych <= 't') goto yy1049;
				goto yy1043;
			}
		}
yy1054:
		yyaccept = 18;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych <= '/') goto yy1043;
			if(yych <= '9') goto yy1056;
			if(yych <= 'm') goto yy1043;
			goto yy1047;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy1043;
				goto yy1048;
			} else {
				if(yych <= 's') goto yy1046;
				if(yych <= 't') goto yy1049;
				goto yy1043;
			}
		}
yy1055:
		yyaccept = 18;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych <= '/') goto yy1043;
			if(yych <= '1') goto yy1056;
			if(yych <= 'm') goto yy1043;
			goto yy1047;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy1043;
				goto yy1048;
			} else {
				if(yych <= 's') goto yy1046;
				if(yych <= 't') goto yy1049;
				goto yy1043;
			}
		}
yy1056:
		yyaccept = 18;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych == '/') goto yy1050;
			if(yych <= 'm') goto yy1043;
			goto yy1047;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy1043;
				goto yy1048;
			} else {
				if(yych <= 's') goto yy1046;
				if(yych <= 't') goto yy1049;
				goto yy1043;
			}
		}
yy1057:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'A') goto yy1132;
			if(yych <= 'T') goto yy53;
			goto yy1131;
		} else {
			if(yych <= 'a') {
				if(yych <= '`') goto yy53;
				goto yy1132;
			} else {
				if(yych == 'u') goto yy1131;
				goto yy53;
			}
		}
yy1058:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy1129;
		if(yych == 'e') goto yy1129;
		goto yy53;
yy1059:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy1126;
		if(yych == 'a') goto yy1126;
		goto yy53;
yy1060:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'P') goto yy1123;
			if(yych <= 'T') goto yy53;
			goto yy1122;
		} else {
			if(yych <= 'p') {
				if(yych <= 'o') goto yy53;
				goto yy1123;
			} else {
				if(yych == 'u') goto yy1122;
				goto yy53;
			}
		}
yy1061:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy1119;
		if(yych == 'e') goto yy1119;
		goto yy53;
yy1062:
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy1117;
		if(yych == 'c') goto yy1117;
		goto yy53;
yy1063:
		yych = *++YYCURSOR;
		if(yych == 'O') goto yy1115;
		if(yych == 'o') goto yy1115;
		goto yy53;
yy1064:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy1113;
		if(yych == 'e') goto yy1113;
		goto yy53;
yy1065:
		yych = *++YYCURSOR;
		if(yych <= '/') {
			if(yych == '-') goto yy1068;
			goto yy53;
		} else {
			if(yych <= '0') goto yy1067;
			if(yych <= '9') goto yy1087;
			goto yy53;
		}
yy1066:
		yych = *++YYCURSOR;
		if(yych == '-') goto yy1068;
		if(yych <= '/') goto yy53;
		if(yych <= '2') goto yy1087;
		goto yy53;
yy1067:
		yych = *++YYCURSOR;
		if(yych != '-') goto yy53;
yy1068:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '2') goto yy1069;
		if(yych <= '3') goto yy1070;
		if(yych <= '9') goto yy1071;
		goto yy53;
yy1069:
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'm') {
			if(yych <= '9') {
				if(yych <= '/') goto yy775;
				goto yy1071;
			} else {
				if(yych == 'T') goto yy1076;
				goto yy775;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'n') goto yy1073;
				if(yych <= 'q') goto yy775;
				goto yy1074;
			} else {
				if(yych <= 's') goto yy1072;
				if(yych <= 't') goto yy1075;
				goto yy775;
			}
		}
yy1070:
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'm') {
			if(yych <= '1') {
				if(yych <= '/') goto yy775;
			} else {
				if(yych == 'T') goto yy1076;
				goto yy775;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'n') goto yy1073;
				if(yych <= 'q') goto yy775;
				goto yy1074;
			} else {
				if(yych <= 's') goto yy1072;
				if(yych <= 't') goto yy1075;
				goto yy775;
			}
		}
yy1071:
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych == 'T') goto yy1076;
			if(yych <= 'm') goto yy775;
			goto yy1073;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy775;
				goto yy1074;
			} else {
				if(yych <= 's') goto yy1072;
				if(yych <= 't') goto yy1075;
				goto yy775;
			}
		}
yy1072:
		yych = *++YYCURSOR;
		if(yych == 't') goto yy1086;
		goto yy53;
yy1073:
		yych = *++YYCURSOR;
		if(yych == 'd') goto yy1086;
		goto yy53;
yy1074:
		yych = *++YYCURSOR;
		if(yych == 'd') goto yy1086;
		goto yy53;
yy1075:
		yych = *++YYCURSOR;
		if(yych == 'h') goto yy1086;
		goto yy53;
yy1076:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '1') goto yy1077;
		if(yych <= '2') goto yy1078;
		if(yych <= '9') goto yy1079;
		goto yy53;
yy1077:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy1079;
		if(yych <= ':') goto yy1080;
		goto yy53;
yy1078:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '3') goto yy1079;
		if(yych == ':') goto yy1080;
		goto yy53;
yy1079:
		yych = *++YYCURSOR;
		if(yych != ':') goto yy53;
yy1080:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy1081;
		if(yych <= '9') goto yy1082;
		goto yy53;
yy1081:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy1082;
		if(yych <= ':') goto yy1083;
		goto yy53;
yy1082:
		yych = *++YYCURSOR;
		if(yych != ':') goto yy53;
yy1083:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy1084;
		if(yych <= '6') goto yy1085;
		if(yych <= '9') goto yy936;
		goto yy53;
yy1084:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy937;
		if(yych <= '9') goto yy936;
		goto yy937;
yy1085:
		yych = *++YYCURSOR;
		if(yych == '0') goto yy936;
		goto yy937;
yy1086:
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'T') goto yy1076;
		goto yy775;
yy1087:
		yych = *++YYCURSOR;
		if(yych != '-') goto yy53;
		yych = *++YYCURSOR;
		if(yych <= '2') {
			if(yych <= '/') goto yy53;
			if(yych >= '1') goto yy1090;
		} else {
			if(yych <= '3') goto yy1091;
			if(yych <= '9') goto yy1071;
			goto yy53;
		}
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'm') {
			if(yych <= '9') {
				if(yych <= '/') goto yy775;
				if(yych <= '0') goto yy1071;
				goto yy1092;
			} else {
				if(yych == 'T') goto yy1076;
				goto yy775;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'n') goto yy1073;
				if(yych <= 'q') goto yy775;
				goto yy1074;
			} else {
				if(yych <= 's') goto yy1072;
				if(yych <= 't') goto yy1075;
				goto yy775;
			}
		}
yy1090:
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'm') {
			if(yych <= '9') {
				if(yych <= '/') goto yy775;
				goto yy1092;
			} else {
				if(yych == 'T') goto yy1076;
				goto yy775;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'n') goto yy1073;
				if(yych <= 'q') goto yy775;
				goto yy1074;
			} else {
				if(yych <= 's') goto yy1072;
				if(yych <= 't') goto yy1075;
				goto yy775;
			}
		}
yy1091:
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'm') {
			if(yych <= '1') {
				if(yych <= '/') goto yy775;
			} else {
				if(yych == 'T') goto yy1076;
				goto yy775;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'n') goto yy1073;
				if(yych <= 'q') goto yy775;
				goto yy1074;
			} else {
				if(yych <= 's') goto yy1072;
				if(yych <= 't') goto yy1075;
				goto yy775;
			}
		}
yy1092:
		yyaccept = 18;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych == 'T') goto yy1093;
			if(yych <= 'm') goto yy1043;
			goto yy1073;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy1043;
				goto yy1074;
			} else {
				if(yych <= 's') goto yy1072;
				if(yych <= 't') goto yy1075;
				goto yy1043;
			}
		}
yy1093:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '1') goto yy1094;
		if(yych <= '2') goto yy1095;
		if(yych <= '9') goto yy1079;
		goto yy53;
yy1094:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy1096;
		if(yych <= ':') goto yy1080;
		goto yy53;
yy1095:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '3') goto yy1096;
		if(yych == ':') goto yy1080;
		goto yy53;
yy1096:
		yych = *++YYCURSOR;
		if(yych != ':') goto yy53;
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy1098;
		if(yych <= '9') goto yy1082;
		goto yy53;
yy1098:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy1099;
		if(yych <= ':') goto yy1083;
		goto yy53;
yy1099:
		yych = *++YYCURSOR;
		if(yych != ':') goto yy53;
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy1101;
		if(yych <= '6') goto yy1102;
		if(yych <= '9') goto yy936;
		goto yy53;
yy1101:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy937;
		if(yych <= '9') goto yy1103;
		goto yy937;
yy1102:
		yych = *++YYCURSOR;
		if(yych != '0') goto yy937;
yy1103:
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych != '.') goto yy937;
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
yy1105:
		yyaccept = 19;
		YYMARKER = ++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
		yych = *YYCURSOR;
		if(yych <= ',') {
			if(yych != '+') goto yy937;
		} else {
			if(yych <= '-') goto yy1107;
			if(yych <= '/') goto yy937;
			if(yych <= '9') goto yy1105;
			goto yy937;
		}
yy1107:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '1') goto yy1108;
		if(yych <= '2') goto yy1109;
		if(yych <= '9') goto yy1110;
		goto yy53;
yy1108:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy937;
		if(yych <= '9') goto yy1110;
		if(yych <= ':') goto yy1111;
		goto yy937;
yy1109:
		yych = *++YYCURSOR;
		if(yych <= '5') {
			if(yych <= '/') goto yy937;
			if(yych >= '4') goto yy1112;
		} else {
			if(yych <= '9') goto yy936;
			if(yych <= ':') goto yy1111;
			goto yy937;
		}
yy1110:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy937;
		if(yych <= '5') goto yy1112;
		if(yych <= '9') goto yy936;
		if(yych >= ';') goto yy937;
yy1111:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy937;
		if(yych <= '5') goto yy1112;
		if(yych <= '9') goto yy936;
		goto yy937;
yy1112:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy937;
		if(yych <= '9') goto yy936;
		goto yy937;
yy1113:
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy1114;
		if(yych != 'c') goto yy53;
yy1114:
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych == '-') goto yy863;
			goto yy889;
		} else {
			if(yych <= 'E') goto yy973;
			if(yych == 'e') goto yy973;
			goto yy889;
		}
yy1115:
		yych = *++YYCURSOR;
		if(yych == 'V') goto yy1116;
		if(yych != 'v') goto yy53;
yy1116:
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych == '-') goto yy863;
			goto yy889;
		} else {
			if(yych <= 'E') goto yy980;
			if(yych == 'e') goto yy980;
			goto yy889;
		}
yy1117:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy1118;
		if(yych != 't') goto yy53;
yy1118:
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'N') {
			if(yych == '-') goto yy863;
			goto yy889;
		} else {
			if(yych <= 'O') goto yy986;
			if(yych == 'o') goto yy986;
			goto yy889;
		}
yy1119:
		yych = *++YYCURSOR;
		if(yych == 'P') goto yy1120;
		if(yych != 'p') goto yy53;
yy1120:
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych == '-') goto yy863;
			goto yy889;
		} else {
			if(yych <= 'T') goto yy1121;
			if(yych != 't') goto yy889;
		}
yy1121:
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych == '-') goto yy863;
			goto yy889;
		} else {
			if(yych <= 'E') goto yy992;
			if(yych == 'e') goto yy992;
			goto yy889;
		}
yy1122:
		yych = *++YYCURSOR;
		if(yych == 'G') goto yy1125;
		if(yych == 'g') goto yy1125;
		goto yy53;
yy1123:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy1124;
		if(yych != 'r') goto yy53;
yy1124:
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'H') {
			if(yych == '-') goto yy863;
			goto yy889;
		} else {
			if(yych <= 'I') goto yy999;
			if(yych == 'i') goto yy999;
			goto yy889;
		}
yy1125:
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych == '-') goto yy863;
			goto yy889;
		} else {
			if(yych <= 'U') goto yy1001;
			if(yych == 'u') goto yy1001;
			goto yy889;
		}
yy1126:
		yych = *++YYCURSOR;
		if(yych <= 'Y') {
			if(yych == 'R') goto yy1127;
			if(yych <= 'X') goto yy53;
			goto yy1128;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy53;
			} else {
				if(yych == 'y') goto yy1128;
				goto yy53;
			}
		}
yy1127:
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'B') {
			if(yych == '-') goto yy863;
			goto yy889;
		} else {
			if(yych <= 'C') goto yy1005;
			if(yych == 'c') goto yy1005;
			goto yy889;
		}
yy1128:
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '-') goto yy863;
		goto yy889;
yy1129:
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy1130;
		if(yych != 'b') goto yy53;
yy1130:
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'Q') {
			if(yych == '-') goto yy863;
			goto yy889;
		} else {
			if(yych <= 'R') goto yy1008;
			if(yych == 'r') goto yy1008;
			goto yy889;
		}
yy1131:
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych == 'L') goto yy1135;
			if(yych <= 'M') goto yy53;
			goto yy1134;
		} else {
			if(yych <= 'l') {
				if(yych <= 'k') goto yy53;
				goto yy1135;
			} else {
				if(yych == 'n') goto yy1134;
				goto yy53;
			}
		}
yy1132:
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy1133;
		if(yych != 'n') goto yy53;
yy1133:
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych == '-') goto yy863;
			goto yy889;
		} else {
			if(yych <= 'U') goto yy1015;
			if(yych == 'u') goto yy1015;
			goto yy889;
		}
yy1134:
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych == '-') goto yy863;
			goto yy889;
		} else {
			if(yych <= 'E') goto yy977;
			if(yych == 'e') goto yy977;
			goto yy889;
		}
yy1135:
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'X') {
			if(yych == '-') goto yy863;
			goto yy889;
		} else {
			if(yych <= 'Y') goto yy977;
			if(yych == 'y') goto yy977;
			goto yy889;
		}
yy1136:
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= '-') goto yy617;
			if(yych <= '.') goto yy845;
			if(yych <= '/') goto yy844;
			goto yy617;
		} else {
			if(yych <= 'U') goto yy74;
			if(yych == 'u') goto yy74;
			goto yy617;
		}
yy1137:
		yych = *++YYCURSOR;
		if(yych <= 'P') {
			if(yych == 'C') goto yy121;
			if(yych <= 'O') goto yy53;
			goto yy709;
		} else {
			if(yych <= 'c') {
				if(yych <= 'b') goto yy53;
				goto yy121;
			} else {
				if(yych == 'p') goto yy709;
				goto yy53;
			}
		}
yy1138:
		yych = *++YYCURSOR;
		if(yych <= 'm') {
			if(yych <= '.') {
				if(yych <= ',') goto yy1140;
				if(yych <= '-') goto yy615;
				goto yy845;
			} else {
				if(yych <= '/') goto yy844;
				if(yych <= '9') goto yy851;
				goto yy1140;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'n') goto yy612;
				if(yych <= 'q') goto yy1140;
				goto yy613;
			} else {
				if(yych <= 's') goto yy606;
				if(yych <= 't') goto yy610;
				goto yy1140;
			}
		}
yy1139:
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
		yych = *YYCURSOR;
yy1140:
		{
			static void *yytarget[256] = {
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy1139, &&yy616,  &&yy616,  &&yy616,  &&yy616,  &&yy616,  &&yy616,  &&yy616,
				&&yy616,  &&yy616,  &&yy616,  &&yy616,  &&yy616,  &&yy616,  &&yy616,  &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy699,  &&yy53,   &&yy53,   &&yy608,  &&yy53,   &&yy609,  &&yy53,
				&&yy60,   &&yy619,  &&yy623,  &&yy53,   &&yy53,   &&yy607,  &&yy626,  &&yy625,
				&&yy53,   &&yy53,   &&yy53,   &&yy605,  &&yy65,   &&yy53,   &&yy621,  &&yy62,
				&&yy622,  &&yy64,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy699,  &&yy53,   &&yy53,   &&yy608,  &&yy53,   &&yy609,  &&yy53,
				&&yy60,   &&yy53,   &&yy623,  &&yy53,   &&yy53,   &&yy607,  &&yy626,  &&yy625,
				&&yy53,   &&yy53,   &&yy53,   &&yy605,  &&yy65,   &&yy53,   &&yy53,   &&yy62,
				&&yy53,   &&yy64,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,
				&&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53,   &&yy53
			};
			goto *yytarget[yych];
		}
yy1141:
		yych = *++YYCURSOR;
		if(yych <= ':') {
			if(yych <= '.') {
				if(yych <= ',') goto yy1140;
				if(yych <= '-') goto yy615;
			} else {
				if(yych <= '/') goto yy844;
				if(yych <= '5') goto yy1144;
				if(yych <= '9') goto yy851;
				goto yy1143;
			}
		} else {
			if(yych <= 'q') {
				if(yych == 'n') goto yy612;
				goto yy1140;
			} else {
				if(yych <= 'r') goto yy613;
				if(yych <= 's') goto yy606;
				if(yych <= 't') goto yy610;
				goto yy1140;
			}
		}
yy1142:
		yych = *++YYCURSOR;
		if(yych <= '1') {
			if(yych <= '/') goto yy617;
			if(yych <= '0') goto yy1166;
			goto yy1167;
		} else {
			if(yych <= '5') goto yy1168;
			if(yych <= '9') goto yy1169;
			goto yy617;
		}
yy1143:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy1161;
		if(yych <= '9') goto yy1162;
		goto yy53;
yy1144:
		yych = *++YYCURSOR;
		if(yych == '-') goto yy852;
		if(yych <= '/') goto yy57;
		if(yych >= ':') goto yy57;
		yyaccept = 20;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146,
				&&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146,
				&&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146,
				&&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146,
				&&yy884,  &&yy884,  &&yy884,  &&yy884,  &&yy884,  &&yy884,  &&yy884,  &&yy884,
				&&yy884,  &&yy884,  &&yy884,  &&yy884,  &&yy884,  &&yy881,  &&yy887,  &&yy882,
				&&yy1147, &&yy1148, &&yy1149, &&yy1150, &&yy1151, &&yy1151, &&yy1152, &&yy51,
				&&yy51,   &&yy51,   &&yy902,  &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146,
				&&yy1146, &&yy884,  &&yy1146, &&yy1146, &&yy884,  &&yy1146, &&yy884,  &&yy1146,
				&&yy884,  &&yy884,  &&yy884,  &&yy1146, &&yy1146, &&yy884,  &&yy884,  &&yy884,
				&&yy1146, &&yy1146, &&yy1146, &&yy884,  &&yy884,  &&yy1146, &&yy884,  &&yy905,
				&&yy884,  &&yy884,  &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146,
				&&yy1146, &&yy884,  &&yy1146, &&yy1146, &&yy884,  &&yy1146, &&yy884,  &&yy1146,
				&&yy884,  &&yy1146, &&yy884,  &&yy1146, &&yy1146, &&yy884,  &&yy884,  &&yy884,
				&&yy1146, &&yy1146, &&yy1146, &&yy884,  &&yy884,  &&yy1146, &&yy1146, &&yy884,
				&&yy1146, &&yy884,  &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146,
				&&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146,
				&&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146,
				&&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146,
				&&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146,
				&&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146,
				&&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146,
				&&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146,
				&&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146,
				&&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146,
				&&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146,
				&&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146,
				&&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146,
				&&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146,
				&&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146,
				&&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146,
				&&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146, &&yy1146
			};
			goto *yytarget[yych];
		}
yy1146:
#line 970 "parse_date.g.re"
		{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
#line 13488 "<stdout>"
yy1147:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '0') goto yy1159;
		if(yych <= '9') goto yy1160;
		goto yy57;
yy1148:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '2') goto yy1158;
		if(yych <= '9') goto yy1157;
		goto yy57;
yy1149:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '9') goto yy1157;
		goto yy57;
yy1150:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '5') goto yy1155;
		if(yych <= '6') goto yy1156;
		if(yych <= '9') goto yy1153;
		goto yy57;
yy1151:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '9') goto yy1153;
		goto yy57;
yy1152:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '0') goto yy1153;
		if(yych <= '9') goto yy51;
		goto yy57;
yy1153:
		yyaccept = 21;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy51,   &&yy51,   &&yy51,   &&yy51,   &&yy51,   &&yy51,   &&yy51,   &&yy51,
				&&yy51,   &&yy51,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy57,   &&yy1154,
				&&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy57,   &&yy1154, &&yy1154, &&yy57,
				&&yy1154, &&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy57,   &&yy1154,
				&&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy57,   &&yy1154, &&yy1154, &&yy57,
				&&yy1154, &&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154
			};
			goto *yytarget[yych];
		}
yy1154:
#line 1015 "parse_date.g.re"
		{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			s->errors += tz_not_found;
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
#line 13582 "<stdout>"
yy1155:
		yyaccept = 21;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy915,  &&yy915,  &&yy915,  &&yy915,  &&yy915,  &&yy915,  &&yy915,  &&yy915,
				&&yy915,  &&yy915,  &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy57,   &&yy1154,
				&&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy57,   &&yy1154, &&yy1154, &&yy57,
				&&yy1154, &&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy57,   &&yy1154,
				&&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy57,   &&yy1154, &&yy1154, &&yy57,
				&&yy1154, &&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154
			};
			goto *yytarget[yych];
		}
yy1156:
		yyaccept = 21;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy915,  &&yy915,  &&yy915,  &&yy915,  &&yy915,  &&yy915,  &&yy915,  &&yy51,
				&&yy51,   &&yy51,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy57,   &&yy1154,
				&&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy57,   &&yy1154, &&yy1154, &&yy57,
				&&yy1154, &&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy57,   &&yy1154,
				&&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy57,   &&yy1154, &&yy1154, &&yy57,
				&&yy1154, &&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154
			};
			goto *yytarget[yych];
		}
yy1157:
		yyaccept = 21;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy915,  &&yy915,  &&yy915,  &&yy915,  &&yy915,  &&yy915,  &&yy915,  &&yy915,
				&&yy915,  &&yy915,  &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy57,   &&yy1154,
				&&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy57,   &&yy1154, &&yy1154, &&yy57,
				&&yy1154, &&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy57,   &&yy1154,
				&&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy57,   &&yy1154, &&yy1154, &&yy57,
				&&yy1154, &&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154
			};
			goto *yytarget[yych];
		}
yy1158:
		yyaccept = 21;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy939,  &&yy940,  &&yy940,  &&yy941,  &&yy915,  &&yy915,  &&yy915,  &&yy915,
				&&yy915,  &&yy915,  &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy57,   &&yy1154,
				&&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy57,   &&yy1154, &&yy1154, &&yy57,
				&&yy1154, &&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy57,   &&yy1154,
				&&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy57,   &&yy1154, &&yy1154, &&yy57,
				&&yy1154, &&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154
			};
			goto *yytarget[yych];
		}
yy1159:
		yyaccept = 21;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy51,   &&yy915,  &&yy915,  &&yy915,  &&yy915,  &&yy915,  &&yy915,  &&yy915,
				&&yy915,  &&yy915,  &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy57,   &&yy1154,
				&&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy57,   &&yy1154, &&yy1154, &&yy57,
				&&yy1154, &&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy57,   &&yy1154,
				&&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy57,   &&yy1154, &&yy1154, &&yy57,
				&&yy1154, &&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154
			};
			goto *yytarget[yych];
		}
yy1160:
		yyaccept = 21;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy939,  &&yy940,  &&yy940,  &&yy941,  &&yy915,  &&yy915,  &&yy915,  &&yy915,
				&&yy915,  &&yy915,  &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy57,   &&yy1154,
				&&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy57,   &&yy1154, &&yy1154, &&yy57,
				&&yy1154, &&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy57,   &&yy1154,
				&&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy57,   &&yy57,   &&yy1154, &&yy1154, &&yy57,
				&&yy1154, &&yy57,   &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154,
				&&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154, &&yy1154
			};
			goto *yytarget[yych];
		}
yy1161:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy1163;
			goto yy634;
		} else {
			if(yych <= '9') goto yy1162;
			if(yych <= ':') goto yy1163;
			goto yy634;
		}
yy1162:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '.') goto yy1163;
		if(yych != ':') goto yy634;
yy1163:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy1164;
		if(yych <= '6') goto yy1165;
		if(yych <= '9') goto yy639;
		goto yy53;
yy1164:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '.') goto yy640;
		if(yych <= '/') goto yy634;
		if(yych <= '9') goto yy639;
		goto yy634;
yy1165:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '.') goto yy640;
		if(yych == '0') goto yy639;
		goto yy634;
yy1166:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy1170;
			goto yy634;
		} else {
			if(yych <= '9') goto yy1169;
			if(yych <= ':') goto yy1163;
			goto yy634;
		}
yy1167:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy1170;
			goto yy634;
		} else {
			if(yych <= '2') goto yy1169;
			if(yych <= '9') goto yy1162;
			if(yych <= ':') goto yy1163;
			goto yy634;
		}
yy1168:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy1170;
			goto yy634;
		} else {
			if(yych <= '9') goto yy1162;
			if(yych <= ':') goto yy1163;
			goto yy634;
		}
yy1169:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '.') goto yy1170;
		if(yych == ':') goto yy1163;
		goto yy634;
yy1170:
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy1171;
		if(yych <= '6') goto yy1172;
		if(yych <= '9') goto yy727;
		goto yy53;
yy1171:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '.') goto yy640;
		if(yych <= '/') goto yy634;
		if(yych <= '9') goto yy1173;
		goto yy634;
yy1172:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy640;
			goto yy634;
		} else {
			if(yych <= '0') goto yy1173;
			if(yych <= '9') goto yy728;
			goto yy634;
		}
yy1173:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '.') goto yy640;
		if(yych <= '/') goto yy634;
		if(yych <= '9') goto yy730;
		goto yy634;
yy1174:
		yych = *++YYCURSOR;
		if(yych <= ':') {
			if(yych <= '.') {
				if(yych <= ',') goto yy604;
				if(yych <= '-') goto yy615;
				goto yy618;
			} else {
				if(yych <= '/') goto yy614;
				if(yych <= '5') goto yy1144;
				if(yych <= '9') goto yy851;
				goto yy627;
			}
		} else {
			if(yych <= 'q') {
				if(yych == 'n') goto yy612;
				goto yy604;
			} else {
				if(yych <= 'r') goto yy613;
				if(yych <= 's') goto yy606;
				if(yych <= 't') goto yy610;
				goto yy604;
			}
		}
yy1175:
		yych = *++YYCURSOR;
		if(yych <= ':') {
			if(yych <= '.') {
				if(yych <= ',') goto yy1140;
				if(yych <= '-') goto yy615;
				goto yy1142;
			} else {
				if(yych <= '/') goto yy614;
				if(yych <= '5') goto yy1144;
				if(yych <= '9') goto yy851;
				goto yy1143;
			}
		} else {
			if(yych <= 'q') {
				if(yych == 'n') goto yy612;
				goto yy1140;
			} else {
				if(yych <= 'r') goto yy613;
				if(yych <= 's') goto yy606;
				if(yych <= 't') goto yy610;
				goto yy1140;
			}
		}
yy1176:
		yych = *++YYCURSOR;
		if(yych <= '0') goto yy53;
		if(yych >= ':') goto yy53;
yy1177:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= '/') goto yy1179;
		if(yych <= '9') goto yy1177;
yy1179:
#line 905 "parse_date.g.re"
		{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 14013 "<stdout>"
yy1180:
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy134;
				goto yy1211;
			}
		} else {
			if(yych <= 'm') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				goto yy134;
			} else {
				if(yych <= 'n') goto yy1211;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy1181:
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych <= '@') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych == 'I') goto yy1205;
				if(yych <= 'T') goto yy134;
				goto yy1204;
			}
		} else {
			if(yych <= 'i') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				if(yych <= 'h') goto yy134;
				goto yy1205;
			} else {
				if(yych == 'u') goto yy1204;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy1182:
		yych = *++YYCURSOR;
		if(yych <= 'M') {
			if(yych <= '@') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych == 'D') goto yy1193;
				if(yych <= 'L') goto yy134;
				goto yy1194;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				if(yych <= 'c') goto yy134;
				goto yy1193;
			} else {
				if(yych == 'm') goto yy1194;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy1183:
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy134;
				goto yy1189;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				goto yy134;
			} else {
				if(yych <= 'e') goto yy1189;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy1184:
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy134;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				goto yy134;
			} else {
				if(yych <= 'e') goto yy1185;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy1185:
		yych = *++YYCURSOR;
		if(yych <= 'L') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'K') goto yy135;
			}
		} else {
			if(yych <= 'k') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy3;
				goto yy135;
			} else {
				if(yych <= 'l') goto yy1186;
				if(yych <= 'z') goto yy135;
				goto yy3;
			}
		}
yy1186:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'E') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'F') goto yy1187;
			if(yych != 'f') goto yy3;
		}
yy1187:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy1188;
		if(yych != 't') goto yy53;
yy1188:
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy159;
		if(yych == 'h') goto yy159;
		goto yy53;
yy1189:
		yych = *++YYCURSOR;
		if(yych <= 'S') {
			if(yych <= ')') {
				if(yych <= '(') goto yy341;
				goto yy132;
			} else {
				if(yych <= '@') goto yy341;
				if(yych <= 'R') goto yy135;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy341;
				goto yy135;
			} else {
				if(yych <= 's') goto yy1190;
				if(yych <= 'z') goto yy135;
				goto yy341;
			}
		}
yy1190:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'C') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'D') goto yy1191;
			if(yych != 'd') goto yy3;
		}
yy1191:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy1192;
		if(yych != 'a') goto yy53;
yy1192:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy347;
		if(yych == 'y') goto yy347;
		goto yy53;
yy1193:
		yych = *++YYCURSOR;
		if(yych <= 'A') {
			if(yych == ')') goto yy132;
			if(yych <= '@') goto yy3;
			goto yy1201;
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				goto yy3;
			} else {
				if(yych <= 'a') goto yy1201;
				if(yych <= 'z') goto yy135;
				goto yy3;
			}
		}
yy1194:
		yych = *++YYCURSOR;
		if(yych <= 'O') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'N') goto yy135;
			}
		} else {
			if(yych <= 'n') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy3;
				goto yy135;
			} else {
				if(yych <= 'o') goto yy1195;
				if(yych <= 'z') goto yy135;
				goto yy3;
			}
		}
yy1195:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'Q') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'R') goto yy1196;
			if(yych != 'r') goto yy3;
		}
yy1196:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy1197;
		if(yych != 'r') goto yy53;
yy1197:
		yych = *++YYCURSOR;
		if(yych == 'O') goto yy1198;
		if(yych != 'o') goto yy53;
yy1198:
		yych = *++YYCURSOR;
		if(yych == 'W') goto yy1199;
		if(yych != 'w') goto yy53;
yy1199:
		++YYCURSOR;
yy1200:
#line 893 "parse_date.g.re"
		{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 14278 "<stdout>"
yy1201:
		yych = *++YYCURSOR;
		if(yych <= 'X') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'Y') goto yy1202;
			if(yych != 'y') goto yy3;
		}
yy1202:
		++YYCURSOR;
yy1203:
#line 883 "parse_date.g.re"
		{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 14300 "<stdout>"
yy1204:
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych <= ')') {
				if(yych <= '(') goto yy341;
				goto yy132;
			} else {
				if(yych <= '@') goto yy341;
				if(yych <= 'Q') goto yy135;
				goto yy1207;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy341;
				goto yy135;
			} else {
				if(yych <= 'r') goto yy1207;
				if(yych <= 'z') goto yy135;
				goto yy341;
			}
		}
yy1205:
		yych = *++YYCURSOR;
		if(yych <= 'S') {
			if(yych <= '@') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= 'Q') goto yy135;
				if(yych >= 'S') goto yy317;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy3;
				goto yy135;
			} else {
				if(yych <= 'r') goto yy1206;
				if(yych <= 's') goto yy317;
				if(yych <= 'z') goto yy135;
				goto yy3;
			}
		}
yy1206:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'C') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'D') goto yy159;
			if(yych == 'd') goto yy159;
			goto yy3;
		}
yy1207:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'R') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'S') goto yy1208;
			if(yych != 's') goto yy3;
		}
yy1208:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy1209;
		if(yych != 'd') goto yy53;
yy1209:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy1210;
		if(yych != 'a') goto yy53;
yy1210:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy347;
		if(yych == 'y') goto yy347;
		goto yy53;
yy1211:
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy135;
			}
		} else {
			if(yych <= 's') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy3;
				goto yy135;
			} else {
				if(yych <= 't') goto yy1212;
				if(yych <= 'z') goto yy135;
				goto yy3;
			}
		}
yy1212:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'G') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'H') goto yy159;
			if(yych == 'h') goto yy159;
			goto yy3;
		}
yy1213:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'N') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy134;
				goto yy1211;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy134;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'n') goto yy1242;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy1214:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy132,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,
				&&yy134,  &&yy1205, &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,
				&&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy1204, &&yy134,  &&yy134,
				&&yy134,  &&yy134,  &&yy134,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,
				&&yy137,  &&yy1236, &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,
				&&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy1235, &&yy137,  &&yy137,
				&&yy137,  &&yy137,  &&yy137,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy1215:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy132,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy134,  &&yy134,  &&yy134,  &&yy1193, &&yy134,  &&yy134,  &&yy134,
				&&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy1194, &&yy134,  &&yy134,
				&&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,
				&&yy134,  &&yy134,  &&yy134,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy137,  &&yy137,  &&yy137,  &&yy1226, &&yy137,  &&yy137,  &&yy137,
				&&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy1227, &&yy137,  &&yy137,
				&&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,
				&&yy137,  &&yy137,  &&yy137,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy1216:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'E') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy134;
				goto yy1189;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy134;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'e') goto yy1222;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy1217:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'E') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy134;
				goto yy1185;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy134;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'e') goto yy1218;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy1218:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'L') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'K') goto yy135;
				goto yy1186;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'l') goto yy1219;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy1219:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'F') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'E') goto yy3;
				goto yy1187;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'f') goto yy1220;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy1220:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy1188;
		if(yych != 't') goto yy144;
		yych = *++YYCURSOR;
		if(yych <= '^') {
			if(yych <= '/') {
				if(yych <= '.') goto yy53;
				goto yy138;
			} else {
				if(yych == 'H') goto yy159;
				goto yy53;
			}
		} else {
			if(yych <= 'g') {
				if(yych <= '_') goto yy138;
				if(yych <= '`') goto yy53;
				goto yy143;
			} else {
				if(yych <= 'h') goto yy241;
				if(yych <= 'z') goto yy143;
				goto yy53;
			}
		}
yy1222:
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy341;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy341;
				if(yych <= 'R') goto yy135;
				goto yy1190;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				if(yych == '_') goto yy138;
				goto yy341;
			} else {
				if(yych == 's') goto yy1223;
				if(yych <= 'z') goto yy142;
				goto yy341;
			}
		}
yy1223:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'C') goto yy3;
				goto yy1191;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'd') goto yy1224;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy1224:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy1192;
		if(yych != 'a') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy347;
		if(yych == 'y') goto yy355;
		goto yy144;
yy1226:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'A') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				goto yy1201;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '^') goto yy3;
				goto yy138;
			} else {
				if(yych <= '`') goto yy3;
				if(yych <= 'a') goto yy1233;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy1227:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'O') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'N') goto yy135;
				goto yy1195;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'o') goto yy1228;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy1228:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'R') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'Q') goto yy3;
				goto yy1196;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'r') goto yy1229;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy1229:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy1197;
		if(yych != 'r') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'O') goto yy1198;
		if(yych != 'o') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'W') goto yy1199;
		if(yych != 'w') goto yy144;
		yyaccept = 22;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '^') {
			if(yych == '/') goto yy138;
			goto yy1200;
		} else {
			if(yych <= '_') goto yy138;
			if(yych <= '`') goto yy1200;
			if(yych <= 'z') goto yy143;
			goto yy1200;
		}
yy1233:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'Y') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'X') goto yy3;
				goto yy1202;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'y') goto yy1234;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy1234:
		yyaccept = 23;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '^') {
			if(yych == '/') goto yy138;
			goto yy1203;
		} else {
			if(yych <= '_') goto yy138;
			if(yych <= '`') goto yy1203;
			if(yych <= 'z') goto yy143;
			goto yy1203;
		}
yy1235:
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'R') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy341;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy341;
				if(yych <= 'Q') goto yy135;
				goto yy1207;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				if(yych == '_') goto yy138;
				goto yy341;
			} else {
				if(yych == 'r') goto yy1238;
				if(yych <= 'z') goto yy142;
				goto yy341;
			}
		}
yy1236:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy132,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy1206, &&yy317,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy1237, &&yy320,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy1237:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'C') goto yy3;
				goto yy159;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'd') goto yy241;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy1238:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'R') goto yy3;
				goto yy1208;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 's') goto yy1239;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy1239:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy1209;
		if(yych != 'd') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy1210;
		if(yych != 'a') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy347;
		if(yych == 'y') goto yy355;
		goto yy144;
yy1242:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy135;
				goto yy1212;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 't') goto yy1243;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy1243:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'H') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'G') goto yy3;
				goto yy159;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'h') goto yy241;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy1244:
		yych = *++YYCURSOR;
		if(yych <= 'Y') {
			if(yych <= '@') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych == 'R') goto yy1255;
				if(yych <= 'X') goto yy134;
				goto yy1256;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				if(yych <= 'q') goto yy134;
				goto yy1255;
			} else {
				if(yych == 'y') goto yy1256;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy1245:
		yych = *++YYCURSOR;
		if(yych <= 'D') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'C') goto yy134;
				goto yy1250;
			}
		} else {
			if(yych <= 'c') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				goto yy134;
			} else {
				if(yych <= 'd') goto yy1250;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy1246:
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy134;
			}
		} else {
			if(yych <= 'm') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				goto yy134;
			} else {
				if(yych <= 'n') goto yy1247;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy1247:
		yych = *++YYCURSOR;
		if(yych <= 'D') {
			if(yych <= ')') {
				if(yych <= '(') goto yy341;
				goto yy132;
			} else {
				if(yych <= '@') goto yy341;
				if(yych <= 'C') goto yy135;
			}
		} else {
			if(yych <= 'c') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy341;
				goto yy135;
			} else {
				if(yych <= 'd') goto yy1248;
				if(yych <= 'z') goto yy135;
				goto yy341;
			}
		}
yy1248:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'A') goto yy1249;
			if(yych != 'a') goto yy3;
		}
yy1249:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy347;
		if(yych == 'y') goto yy347;
		goto yy53;
yy1250:
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy135;
			}
		} else {
			if(yych <= 'm') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy3;
				goto yy135;
			} else {
				if(yych <= 'n') goto yy1251;
				if(yych <= 'z') goto yy135;
				goto yy3;
			}
		}
yy1251:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'H') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'I') goto yy1252;
			if(yych != 'i') goto yy3;
		}
yy1252:
		yych = *++YYCURSOR;
		if(yych == 'G') goto yy1253;
		if(yych != 'g') goto yy53;
yy1253:
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy1254;
		if(yych != 'h') goto yy53;
yy1254:
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy1202;
		if(yych == 't') goto yy1202;
		goto yy53;
yy1255:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy360,  &&yy359,  &&yy359,  &&yy359,  &&yy361,  &&yy359,  &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy359,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy1257, &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy1257, &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy1256:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= ')') {
				if(yych <= 0x1F) goto yy3;
				if(yych <= '(') goto yy359;
				goto yy360;
			} else {
				if(yych == '-') goto yy361;
				goto yy359;
			}
		} else {
			if(yych <= '@') {
				if(yych <= '/') goto yy3;
				if(yych <= '9') goto yy359;
				goto yy3;
			} else {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy3;
				if(yych <= 'z') goto yy135;
				goto yy3;
			}
		}
yy1257:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'G') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'H') goto yy358;
			if(yych == 'h') goto yy358;
			goto yy3;
		}
yy1258:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy132,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,
				&&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,
				&&yy134,  &&yy134,  &&yy1255, &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,
				&&yy134,  &&yy1256, &&yy134,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,
				&&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,
				&&yy137,  &&yy137,  &&yy1269, &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,
				&&yy137,  &&yy1270, &&yy137,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy1259:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'C') goto yy134;
				goto yy1250;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy134;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'd') goto yy1264;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy1260:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'N') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy134;
				goto yy1247;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy134;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'n') goto yy1261;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy1261:
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy341;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy341;
				if(yych <= 'C') goto yy135;
				goto yy1248;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				if(yych == '_') goto yy138;
				goto yy341;
			} else {
				if(yych == 'd') goto yy1262;
				if(yych <= 'z') goto yy142;
				goto yy341;
			}
		}
yy1262:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'A') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				goto yy1249;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych <= 'a') goto yy1263;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy1263:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy347;
		if(yych == 'y') goto yy355;
		goto yy144;
yy1264:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'N') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy135;
				goto yy1251;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'n') goto yy1265;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy1265:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'I') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'H') goto yy3;
				goto yy1252;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'i') goto yy1266;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy1266:
		yych = *++YYCURSOR;
		if(yych == 'G') goto yy1253;
		if(yych != 'g') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy1254;
		if(yych != 'h') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy1202;
		if(yych == 't') goto yy1234;
		goto yy144;
yy1269:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy360,  &&yy359,  &&yy359,  &&yy359,  &&yy361,  &&yy359,  &&yy138,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy359,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy1257, &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy142,  &&yy142,  &&yy1271, &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy1270:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= ')') {
				if(yych <= 0x1F) goto yy3;
				if(yych <= '(') goto yy359;
				goto yy360;
			} else {
				if(yych == '-') goto yy361;
				if(yych <= '.') goto yy359;
				goto yy138;
			}
		} else {
			if(yych <= '^') {
				if(yych <= '9') goto yy359;
				if(yych <= '@') goto yy3;
				if(yych <= 'Z') goto yy135;
				goto yy3;
			} else {
				if(yych <= '_') goto yy138;
				if(yych <= '`') goto yy3;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy1271:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'H') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'G') goto yy3;
				goto yy358;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'h') goto yy457;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy1272:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy132,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,
				&&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy1280,
				&&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy1281, &&yy1278,
				&&yy134,  &&yy134,  &&yy134,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,
				&&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy1280,
				&&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy1281, &&yy1278,
				&&yy134,  &&yy134,  &&yy134,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy1273:
		yych = *++YYCURSOR;
		if(yych <= 'X') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'W') goto yy134;
				goto yy1277;
			}
		} else {
			if(yych <= 'w') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				goto yy134;
			} else {
				if(yych <= 'x') goto yy1277;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy1274:
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy134;
			}
		} else {
			if(yych <= 'm') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				goto yy134;
			} else {
				if(yych <= 'n') goto yy1275;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy1275:
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy135;
			}
		} else {
			if(yych <= 's') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy3;
				goto yy135;
			} else {
				if(yych <= 't') goto yy1276;
				if(yych <= 'z') goto yy135;
				goto yy3;
			}
		}
yy1276:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'G') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'H') goto yy159;
			if(yych == 'h') goto yy159;
			goto yy3;
		}
yy1277:
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy135;
				goto yy317;
			}
		} else {
			if(yych <= 's') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy3;
				goto yy135;
			} else {
				if(yych <= 't') goto yy317;
				if(yych <= 'z') goto yy135;
				goto yy3;
			}
		}
yy1278:
		++YYCURSOR;
		if((yych = *YYCURSOR) <= '@') {
			if(yych == ')') goto yy132;
		} else {
			if(yych <= 'Z') goto yy135;
			if(yych <= '`') goto yy1279;
			if(yych <= 'z') goto yy135;
		}
yy1279:
#line 862 "parse_date.g.re"
		{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 15636 "<stdout>"
yy1280:
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy135;
				goto yy1286;
			}
		} else {
			if(yych <= 'm') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy3;
				goto yy135;
			} else {
				if(yych <= 'n') goto yy1286;
				if(yych <= 'z') goto yy135;
				goto yy3;
			}
		}
yy1281:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy360,  &&yy359,  &&yy359,  &&yy359,  &&yy361,  &&yy359,  &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy359,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy1282, &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy1282, &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy1282:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'L') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'M') goto yy1283;
			if(yych != 'm') goto yy3;
		}
yy1283:
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy1284;
		if(yych != 'b') goto yy53;
yy1284:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy1285;
		if(yych != 'e') goto yy53;
yy1285:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy358;
		if(yych == 'r') goto yy358;
		goto yy53;
yy1286:
		++YYCURSOR;
		if((yych = *YYCURSOR) == ')') goto yy132;
yy1287:
#line 871 "parse_date.g.re"
		{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 15737 "<stdout>"
yy1288:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy132,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,
				&&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy1280,
				&&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy134,  &&yy1281, &&yy1278,
				&&yy134,  &&yy134,  &&yy134,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,
				&&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy1295,
				&&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy137,  &&yy1296, &&yy1294,
				&&yy137,  &&yy137,  &&yy137,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy1289:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'X') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'W') goto yy134;
				goto yy1277;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy134;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'x') goto yy1293;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy1290:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'N') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy134;
				goto yy1275;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy134;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'n') goto yy1291;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy1291:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy135;
				goto yy1276;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 't') goto yy1292;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy1292:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'H') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'G') goto yy3;
				goto yy159;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'h') goto yy241;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy1293:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy135;
				goto yy317;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 't') goto yy320;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy1294:
		yyaccept = 24;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych <= ')') {
				if(yych <= '(') goto yy1279;
				goto yy132;
			} else {
				if(yych == '/') goto yy138;
				goto yy1279;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '^') goto yy1279;
				goto yy138;
			} else {
				if(yych <= '`') goto yy1279;
				if(yych <= 'z') goto yy142;
				goto yy1279;
			}
		}
yy1295:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'N') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy135;
				goto yy1286;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'n') goto yy1301;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy1296:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy360,  &&yy359,  &&yy359,  &&yy359,  &&yy361,  &&yy359,  &&yy138,
				&&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,  &&yy359,
				&&yy359,  &&yy359,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy1282, &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,  &&yy135,
				&&yy135,  &&yy135,  &&yy135,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy138,
				&&yy3,    &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy1297, &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,  &&yy142,
				&&yy142,  &&yy142,  &&yy142,  &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,
				&&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3,    &&yy3
			};
			goto *yytarget[yych];
		}
yy1297:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'M') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'L') goto yy3;
				goto yy1283;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'm') goto yy1298;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy1298:
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy1284;
		if(yych != 'b') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy1285;
		if(yych != 'e') goto yy144;
		yych = *++YYCURSOR;
		if(yych <= '^') {
			if(yych <= '/') {
				if(yych <= '.') goto yy53;
				goto yy138;
			} else {
				if(yych == 'R') goto yy358;
				goto yy53;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= '_') goto yy138;
				if(yych <= '`') goto yy53;
				goto yy143;
			} else {
				if(yych <= 'r') goto yy457;
				if(yych <= 'z') goto yy143;
				goto yy53;
			}
		}
yy1301:
		yyaccept = 25;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == ')') goto yy132;
			if(yych <= '.') goto yy1287;
			goto yy138;
		} else {
			if(yych <= '_') {
				if(yych <= '^') goto yy1287;
				goto yy138;
			} else {
				if(yych <= '`') goto yy1287;
				if(yych <= 'z') goto yy143;
				goto yy1287;
			}
		}
yy1302:
		yych = *++YYCURSOR;
		if(yych <= 'S') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'R') goto yy134;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'Z') goto yy134;
				if(yych <= '`') goto yy3;
				goto yy134;
			} else {
				if(yych <= 's') goto yy1303;
				if(yych <= 'z') goto yy134;
				goto yy3;
			}
		}
yy1303:
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy132;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy135;
			}
		} else {
			if(yych <= 's') {
				if(yych <= 'Z') goto yy135;
				if(yych <= '`') goto yy3;
				goto yy135;
			} else {
				if(yych <= 't') goto yy1304;
				if(yych <= 'z') goto yy135;
				goto yy3;
			}
		}
yy1304:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych == ')') goto yy132;
			goto yy3;
		} else {
			if(yych <= 'E') goto yy1305;
			if(yych != 'e') goto yy3;
		}
yy1305:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy1306;
		if(yych != 'r') goto yy53;
yy1306:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy1307;
		if(yych != 'd') goto yy53;
yy1307:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy1308;
		if(yych != 'a') goto yy53;
yy1308:
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy1309;
		if(yych != 'y') goto yy53;
yy1309:
		++YYCURSOR;
yy1310:
#line 850 "parse_date.g.re"
		{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 16130 "<stdout>"
yy1311:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'R') goto yy134;
				goto yy1303;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy134;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 's') goto yy1312;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy1312:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy135;
				goto yy1304;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy135;
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 't') goto yy1313;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy1313:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'E') {
			if(yych <= '.') {
				if(yych == ')') goto yy132;
				goto yy3;
			} else {
				if(yych <= '/') goto yy138;
				if(yych <= 'D') goto yy3;
				goto yy1305;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy138;
				goto yy3;
			} else {
				if(yych == 'e') goto yy1314;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy1314:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy1306;
		if(yych != 'r') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy1307;
		if(yych != 'd') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy1308;
		if(yych != 'a') goto yy144;
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy1309;
		if(yych != 'y') goto yy144;
		yyaccept = 26;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '^') {
			if(yych == '/') goto yy138;
			goto yy1310;
		} else {
			if(yych <= '_') goto yy138;
			if(yych <= '`') goto yy1310;
			if(yych <= 'z') goto yy143;
			goto yy1310;
		}
	}
}
#line 1411 "parse_date.g.re"

}

#define YYMAXFILL 26

timelib_time* timelib_strtotime(char *s, int len, int *errors, timelib_tzdb *tzdb)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	while (isspace(*s) && s < e) {
		s++;
	}
	while (isspace(*e) && e > s) {
		e--;
	}
	if (e - s < 1) {
		*errors = 1;
		in.time = timelib_time_ctor();
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->f = in.time->z = in.time->dst = -1;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	memset(&in, 0, sizeof(in));
	in.str = malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = -1;
	in.time->d = -1;
	in.time->m = -1;
	in.time->h = -1;
	in.time->i = -1;
	in.time->s = -1;
	in.time->f = -1;
	in.time->z = -1;
	in.time->dst = -1;
	in.errors = 0;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	do {
		t = scan(&in);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	free(in.str);
	*errors = in.errors;
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options && TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->f = 0;
	}
	if (parsed->y == -1) parsed->y = now->y != -1 ? now->y : 0;
	if (parsed->d == -1) parsed->d = now->d != -1 ? now->d : 0;
	if (parsed->m == -1) parsed->m = now->m != -1 ? now->m : 0;
	if (parsed->h == -1) parsed->h = now->h != -1 ? now->h : 0;
	if (parsed->i == -1) parsed->i = now->i != -1 ? now->i : 0;
	if (parsed->s == -1) parsed->s = now->s != -1 ? now->s : 0;
	if (parsed->f == -1) parsed->f = now->f != -1 ? now->f : 0;
	if (parsed->z == -1) parsed->z = now->z != -1 ? now->z : 0;
	if (parsed->dst == -1) parsed->dst = now->dst != -1 ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, long gmtoffset, int isdst)
{
	timelib_tz_lookup_table *tp;

	tp = zone_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS", 
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;				
}
#endif

/*
 * vim: syntax=c
 */
