/* Generated by re2c */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define	BSIZE	8192


enum ScanContition {
	EStateNormal,
	EStateComment,
	EStateSkiptoeol,
	EStateString,
};


typedef struct Scanner
{
	FILE			    *fp;
	unsigned char	    *cur, *tok, *lim, *eof;
	unsigned char 	    buffer[BSIZE];
	unsigned char       yych;
	enum ScanContition  cond;
	int                 state;
} Scanner;

int fill(Scanner *s, int len)
{
	if (!len)
	{
		s->cur = s->tok = s->lim = s->buffer;
		s->eof = 0;
	}
	if (!s->eof)
	{
		int got, cnt = s->tok - s->buffer;

		if (cnt > 0)
		{
			memcpy(s->buffer, s->tok, s->lim - s->tok);
			s->tok -= cnt;
			s->cur -= cnt;
			s->lim -= cnt;
		}
		cnt = BSIZE - cnt;
		if ((got = fread(s->lim, 1, cnt, s->fp)) != cnt)
		{
			s->eof = &s->lim[got];
		}
		s->lim += got;
	}
	else if (s->cur + len > s->eof)
	{
		return 0; /* not enough input data */
	}
	return -1;
}

void fputl(const char *s, size_t len, FILE *stream)
{
	while(len-- > 0)
	{
		fputc(*s++, stream);
	}
}

void scan(Scanner *s)
{
	fill(s, 0);

	for(;;)
	{
		s->tok = s->cur;


		switch (s->state) {
		default: goto yy0;
		case 0: goto yyFillLabel0;
		case 1: goto yyFillLabel1;
		case 2: goto yyFillLabel2;
		case 3: goto yyFillLabel3;
		}
yy0:
		if (s->cond < 2) {
			if (s->cond < 1) {
				goto yyc_Normal;
			} else {
				goto yyc_Comment;
			}
		} else {
			if (s->cond < 3) {
				goto yyc_Skiptoeol;
			} else {
				goto yyc_String;
			}
		}
/* *********************************** */
yyc_Comment:
		s->state = 0;(0);
		if ((s->lim - s->cur) < 2) if(fill(s, 2) >= 0) break;
yyFillLabel0:
		s->yych = *s->cur;
		if (s->yych != '*') goto yy5;
		++s->cur;
		if ((s->yych = *s->cur) == '/') goto yy6;
yy4:
		{
				goto yyc_Comment;
			}
yy5:
		s->yych = *++s->cur;
		goto yy4;
yy6:
		++s->cur;
		{
				s->cond = EStateNormal;
				continue;
			}
/* *********************************** */
yyc_Normal:
		s->state = 1;(1);
		if ((s->lim - s->cur) < 4) if(fill(s, 4) >= 0) break;
yyFillLabel1:
		s->yych = *s->cur;
		if (s->yych <= '\'') {
			if (s->yych == '"') goto yy14;
			if (s->yych <= '&') goto yy16;
			goto yy13;
		} else {
			if (s->yych <= '/') {
				if (s->yych <= '.') goto yy16;
				goto yy12;
			} else {
				if (s->yych != '?') goto yy16;
			}
		}
		s->yych = *(s->tok = ++s->cur);
		if (s->yych == '?') goto yy27;
yy11:
		{
				fputc(*s->tok, stdout);
				continue;
			}
yy12:
		s->yych = *++s->cur;
		if (s->yych == '*') goto yy25;
		if (s->yych == '/') goto yy23;
		goto yy11;
yy13:
		s->yych = *(s->tok = ++s->cur);
		if (s->yych == '"') goto yy17;
		if (s->yych == '\\') goto yy19;
		goto yy11;
yy14:
		++s->cur;
		{
				fputc(*s->tok, stdout);
				s->state = EStateString;
				continue;
			}
yy16:
		s->yych = *++s->cur;
		goto yy11;
yy17:
		s->yych = *++s->cur;
		if (s->yych == '\'') goto yy21;
yy18:
		s->cur = s->tok;
		goto yy11;
yy19:
		s->yych = *++s->cur;
		if (s->yych != '"') goto yy18;
		s->yych = *++s->cur;
		if (s->yych != '\'') goto yy18;
yy21:
		++s->cur;
		{
				fputl("'\"'", 3, stdout);
				continue;
			}
yy23:
		++s->cur;
		{
				s->cond = EStateSkiptoeol;
				goto yyc_Skiptoeol;
			}
yy25:
		++s->cur;
		{
				s->cond = EStateComment;
				goto yyc_Comment;
			}
yy27:
		s->yych = *++s->cur;
		switch (s->yych) {
		case '!':	goto yy42;
		case '\'':	goto yy40;
		case '(':	goto yy28;
		case ')':	goto yy30;
		case '-':	goto yy44;
		case '/':	goto yy38;
		case '<':	goto yy32;
		case '=':	goto yy36;
		case '>':	goto yy34;
		default:	goto yy18;
		}
yy28:
		++s->cur;
		{
				fputc('[', stdout);
				continue;
			}
yy30:
		++s->cur;
		{
				fputc(']', stdout);
				continue;
			}
yy32:
		++s->cur;
		{
				fputc('{', stdout);
				continue;
			}
yy34:
		++s->cur;
		{
				fputc('}', stdout);
				continue;
			}
yy36:
		++s->cur;
		{
				fputc('#', stdout);
				continue;
			}
yy38:
		++s->cur;
		{
				fputc('\\', stdout);
				continue;
			}
yy40:
		++s->cur;
		{
				fputc('^', stdout);
				continue;
			}
yy42:
		++s->cur;
		{
				fputc('|', stdout);
				continue;
			}
yy44:
		++s->cur;
		{
				fputc('~', stdout);
				continue;
			}
/* *********************************** */
yyc_Skiptoeol:
		s->state = 2;(2);
		if ((s->lim - s->cur) < 5) if(fill(s, 5) >= 0) break;
yyFillLabel2:
		s->yych = *s->cur;
		if (s->yych <= '>') {
			if (s->yych == '\n') goto yy51;
			goto yy53;
		} else {
			if (s->yych <= '?') goto yy48;
			if (s->yych == '\\') goto yy50;
			goto yy53;
		}
yy48:
		s->yych = *(s->tok = ++s->cur);
		if (s->yych == '?') goto yy58;
yy49:
		{
				goto yyc_Skiptoeol;
			}
yy50:
		s->yych = *(s->tok = ++s->cur);
		if (s->yych == '\n') goto yy56;
		if (s->yych == '\r') goto yy54;
		goto yy49;
yy51:
		++s->cur;
		{
				s->cond = EStateNormal;
				continue;
			}
yy53:
		s->yych = *++s->cur;
		goto yy49;
yy54:
		s->yych = *++s->cur;
		if (s->yych == '\n') goto yy56;
yy55:
		s->cur = s->tok;
		goto yy49;
yy56:
		++s->cur;
		{
				goto yyc_Skiptoeol;
			}
yy58:
		s->yych = *++s->cur;
		if (s->yych != '/') goto yy55;
		s->yych = *++s->cur;
		if (s->yych == '\n') goto yy61;
		if (s->yych != '\r') goto yy55;
		s->yych = *++s->cur;
		if (s->yych != '\n') goto yy55;
yy61:
		++s->cur;
		{
				goto yyc_Skiptoeol;
			}
/* *********************************** */
yyc_String:
		s->state = 3;(3);
		if ((s->lim - s->cur) < 2) if(fill(s, 2) >= 0) break;
yyFillLabel3:
		s->yych = *s->cur;
		if (s->yych == '"') goto yy67;
		if (s->yych != '\\') goto yy69;
		++s->cur;
		if ((s->yych = *s->cur) != '\n') goto yy70;
yy66:
		{
				fputc(*s->tok, stdout);
				continue;
			}
yy67:
		++s->cur;
		{
				fputc(*s->tok, stdout);
				s->cond = EStateNormal;
				continue;
			}
yy69:
		s->yych = *++s->cur;
		goto yy66;
yy70:
		++s->cur;
		{
				fputl((const char*)s->tok, 2, stdout);
				continue;
			}

	}
}

int main(int argc, char **argv)
{
	Scanner in;
	char c;

	if (argc != 2)
	{
		fprintf(stderr, "%s <file>\n", argv[0]);
		return 1;;
	}

	memset((char*) &in, 0, sizeof(in));

	if (!strcmp(argv[1], "-"))
	{
		in.fp = stdin;
	}
	else if ((in.fp = fopen(argv[1], "r")) == NULL)
	{
		fprintf(stderr, "Cannot open file '%s'\n", argv[1]);
		return 1;
	}

 	in.cond = EStateNormal;
 	scan(&in);

	if (in.fp != stdin)
	{
		fclose(in.fp);
	}
	return 0;
}
