/* Generated by re2c */

#include <stdio.h>
#include <stdlib.h> /* malloc, free */

static void *read_file
    ( const char *fname
    , size_t unit
    , size_t padding
    , size_t *pfsize
    )
{
    void *buffer = NULL;
    size_t fsize = 0;

    /* open file */
    FILE *f = fopen(fname, "rb");
    if(f == NULL) {
        goto error;
    }

    /* get file size */
    fseek(f, 0, SEEK_END);
    fsize = (size_t) ftell(f) / unit;
    fseek(f, 0, SEEK_SET);

    /* allocate memory for file and padding */
    buffer = malloc(unit * (fsize + padding));
    if (buffer == NULL) {
        goto error;
    }

    /* read the whole file in memory */
    if (fread(buffer, unit, fsize, f) != fsize) {
        goto error;
    }

    fclose(f);
    *pfsize = fsize;
    return buffer;

error:
    fprintf(stderr, "error: cannot read file '%s'\n", fname);
    free(buffer);
    if (f != NULL) {
        fclose(f);
    }
    return NULL;
}

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYBACKUP() marker = cursor
#define YYRESTORE() cursor = marker
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line66
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line66: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line66: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line66()
{
    const size_t padding = 2; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("php20150211_pdo_sql_parser.ig--skeleton.c.line66.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ("php20150211_pdo_sql_parser.ig--skeleton.c.line66.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        const YYCTYPE *marker = NULL;
        YYCTYPE yych;
        unsigned int yyaccept = 0;
        static const unsigned char yybm[] = {
            /* table 1 .. 8: 0 */
              2, 195, 195, 195, 195, 195, 195, 195, 
            195, 195, 195, 195, 195, 195, 195, 195, 
            195, 195, 195, 195, 195, 195, 195, 195, 
            195, 195, 195, 195, 195, 195, 195, 195, 
            195, 195,  66, 195, 195, 195, 195, 130, 
            195, 195, 196, 195, 195, 195, 195, 195, 
            211, 211, 211, 211, 211, 211, 211, 211, 
            211, 211, 226, 195, 195, 195, 195, 202, 
            195, 211, 211, 211, 211, 211, 211, 211, 
            211, 211, 211, 211, 211, 211, 211, 211, 
            211, 211, 211, 211, 211, 211, 211, 211, 
            211, 211, 211, 195,   3, 195, 195, 211, 
            195, 211, 211, 211, 211, 211, 211, 211, 
            211, 211, 211, 211, 211, 211, 211, 211, 
            211, 211, 211, 211, 211, 211, 211, 211, 
            211, 211, 211, 195, 195, 195, 195, 195, 
            195, 195, 195, 195, 195, 195, 195, 195, 
            195, 195, 195, 195, 195, 195, 195, 195, 
            195, 195, 195, 195, 195, 195, 195, 195, 
            195, 195, 195, 195, 195, 195, 195, 195, 
            195, 195, 195, 195, 195, 195, 195, 195, 
            195, 195, 195, 195, 195, 195, 195, 195, 
            195, 195, 195, 195, 195, 195, 195, 195, 
            195, 195, 195, 195, 195, 195, 195, 195, 
            195, 195, 195, 195, 195, 195, 195, 195, 
            195, 195, 195, 195, 195, 195, 195, 195, 
            195, 195, 195, 195, 195, 195, 195, 195, 
            195, 195, 195, 195, 195, 195, 195, 195, 
            195, 195, 195, 195, 195, 195, 195, 195, 
            195, 195, 195, 195, 195, 195, 195, 195, 
            195, 195, 195, 195, 195, 195, 195, 195, 
            195, 195, 195, 195, 195, 195, 195, 195, 
            /* table 9 .. 11: 256 */
            128, 224, 224, 224, 224, 224, 224, 224, 
            224, 224,  32, 224, 224,  32, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 128, 224, 224, 224, 224, 128, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 128, 224, 224, 224, 224, 128, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
        };

        if (YYLESSTHAN (2)) YYFILL(2);
        yych = YYPEEK ();
        {
            static void *yytarget[256] = {
                &&yy2,  &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy3,  &&yy12, &&yy12, &&yy12, &&yy12, &&yy5,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy11, &&yy12, &&yy9,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy6,  &&yy12, &&yy12, &&yy12, &&yy12, &&yy7,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12,
                &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12, &&yy12
            };
            goto *yytarget[yych];
        }
yy2:
        YYRESTORE ();
        if (yyaccept == 0) {
            goto yy4;
        } else {
            goto yy10;
        }
yy3:
        yyaccept = 0;
        YYSKIP ();
        YYBACKUP ();
        yych = YYPEEK ();
        if (yych >= 0x01) goto yy43;
yy4:
        status = action_line66(i, keys, input, token, &cursor, 5);
        continue;
yy5:
        yyaccept = 0;
        YYSKIP ();
        YYBACKUP ();
        yych = YYPEEK ();
        if (yych <= 0x00) goto yy4;
        goto yy38;
yy6:
        YYSKIP ();
        yych = YYPEEK ();
        if (yybm[0+yych] & 16) {
            goto yy32;
        }
        if (yych <= '/') goto yy4;
        if (yych <= ':') goto yy35;
        goto yy4;
yy7:
        YYSKIP ();
        if (yybm[0+(yych = YYPEEK ())] & 8) {
            goto yy29;
        }
        status = action_line66(i, keys, input, token, &cursor, 4);
        continue;
yy9:
        YYSKIP ();
        if ((yych = YYPEEK ()) == '*') goto yy19;
        goto yy13;
yy10:
        status = action_line66(i, keys, input, token, &cursor, 7);
        continue;
yy11:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych == '-') goto yy14;
        goto yy13;
yy12:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
yy13:
        if (yybm[256+yych] & 32) {
            goto yy12;
        }
        goto yy10;
yy14:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yybm[256+yych] & 64) {
            goto yy14;
        }
        if (yych <= 0x00) goto yy17;
        if (yych <= '\r') goto yy12;
        goto yy17;
yy16:
        status = action_line66(i, keys, input, token, &cursor, 6);
        continue;
yy17:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yybm[256+yych] & 128) {
            goto yy17;
        }
        goto yy16;
yy19:
        yyaccept = 1;
        YYSKIP ();
        YYBACKUP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yybm[0+yych] & 1) {
            goto yy19;
        }
        if (yych <= '\'') goto yy21;
        if (yych <= '*') goto yy23;
yy21:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yybm[0+yych] & 2) {
            goto yy21;
        }
        goto yy26;
yy23:
        yyaccept = 1;
        YYSKIP ();
        YYBACKUP ();
        if (YYLESSTHAN (2)) YYFILL(2);
        yych = YYPEEK ();
        {
            static void *yytarget[256] = {
                &&yy21, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy21, &&yy19, &&yy19, &&yy19, &&yy19, &&yy21,
                &&yy19, &&yy19, &&yy23, &&yy19, &&yy19, &&yy19, &&yy19, &&yy25,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy21, &&yy19, &&yy19, &&yy19, &&yy19, &&yy21,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
                &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19
            };
            goto *yytarget[yych];
        }
yy25:
        YYSKIP ();
        yych = YYPEEK ();
        if (yybm[256+yych] & 32) {
            goto yy12;
        }
        goto yy16;
yy26:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych == '*') goto yy26;
        if (yych != '/') goto yy21;
        YYSKIP ();
        yych = YYPEEK ();
        goto yy16;
yy29:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yybm[0+yych] & 8) {
            goto yy29;
        }
yy31:
        status = action_line66(i, keys, input, token, &cursor, 2);
        continue;
yy32:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yybm[0+yych] & 16) {
            goto yy32;
        }
        status = action_line66(i, keys, input, token, &cursor, 3);
        continue;
yy35:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yybm[0+yych] & 32) {
            goto yy35;
        }
        goto yy31;
yy37:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
yy38:
        if (yybm[0+yych] & 64) {
            goto yy37;
        }
        if (yych <= 0x00) goto yy2;
        if (yych <= '\'') goto yy40;
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00) goto yy2;
        goto yy37;
yy40:
        YYSKIP ();
        status = action_line66(i, keys, input, token, &cursor, 1);
        continue;
yy42:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
yy43:
        if (yybm[0+yych] & 128) {
            goto yy42;
        }
        if (yych <= 0x00) goto yy2;
        if (yych <= '"') goto yy45;
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00) goto yy2;
        goto yy42;
yy45:
        YYSKIP ();
        status = action_line66(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line66: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line66: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYBACKUP
#undef YYRESTORE
#undef YYLESSTHAN
#undef YYFILL

int main()
{
    if(lex_line66() != 0) {
        return 1;
    }
    return 0;
}
"\ "\ "\ "\ "\ "\ "\ "\ "		\ "

\ "\ "\ "

\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "  \ "!!\ "##\ "$$\ "%%\ "&&\ "''\ "((\ "))\ "**\ "++\ ",,\ "--\ "..\ "//\ "00\ "11\ "22\ "33\ "44\ "55\ "66\ "77\ "88\ "99\ "::\ ";;\ "<<\ "==\ ">>\ "??\ "@@\ "AA\ "BB\ "CC\ "DD\ "EE\ "FF\ "GG\ "HH\ "II\ "JJ\ "KK\ "LL\ "MM\ "NN\ "OO\ "PP\ "QQ\ "RR\ "SS\ "TT\ "UU\ "VV\ "WW\ "XX\ "YY\ "ZZ\ "[[\ "]]\ "^^\ "__\ "``\ "aa\ "bb\ "cc\ "dd\ "ee\ "ff\ "gg\ "hh\ "ii\ "jj\ "kk\ "ll\ "mm\ "nn\ "oo\ "pp\ "qq\ "rr\ "ss\ "tt\ "uu\ "vv\ "ww\ "xx\ "yy\ "zz\ "{{\ "||\ "}}\ "~~\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ """""""""""""""""		""

""""""

""""""""""""""""""""""""""""""""""""""  ""!!""##""$$""%%""&&""''""((""))""**""++"",,""--""..""//""00""11""22""33""44""55""66""77""88""99""::"";;""<<""=="">>""??""@@""AA""BB""CC""DD""EE""FF""GG""HH""II""JJ""KK""LL""MM""NN""OO""PP""QQ""RR""SS""TT""UU""VV""WW""XX""YY""ZZ""[[""]]""^^""__""``""aa""bb""cc""dd""ee""ff""gg""hh""ii""jj""kk""ll""mm""nn""oo""pp""qq""rr""ss""tt""uu""vv""ww""xx""yy""zz""{{""||""}}""~~"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""" " " " " " " " "		 "

 " " "

 " " " " " " " " " " " " " " " " " " "   "!! "## "$$ "%% "&& "'' "(( ")) "** "++ ",, "-- ".. "// "00 "11 "22 "33 "44 "55 "66 "77 "88 "99 ":: ";; "<< "== ">> "?? "@@ "AA "BB "CC "DD "EE "FF "GG "HH "II "JJ "KK "LL "MM "NN "OO "PP "QQ "RR "SS "TT "UU "VV "WW "XX "YY "ZZ "[[ "]] "^^ "__ "`` "aa "bb "cc "dd "ee "ff "gg "hh "ii "jj "kk "ll "mm "nn "oo "pp "qq "rr "ss "tt "uu "vv "ww "xx "yy "zz "{{ "|| "}} "~~ " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " "\ "\ "\ "\ "\ "\ "\ "\ "	\ "
\ "\ "\ "
\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ " \ "!\ "#\ "$\ "%\ "&\ "'\ "(\ ")\ "*\ "+\ ",\ "-\ ".\ "/\ "0\ "1\ "2\ "3\ "4\ "5\ "6\ "7\ "8\ "9\ ":\ ";\ "<\ "=\ ">\ "?\ "@\ "A\ "B\ "C\ "D\ "E\ "F\ "G\ "H\ "I\ "J\ "K\ "L\ "M\ "N\ "O\ "P\ "Q\ "R\ "S\ "T\ "U\ "V\ "W\ "X\ "Y\ "Z\ "[\ "]\ "^\ "_\ "`\ "a\ "b\ "c\ "d\ "e\ "f\ "g\ "h\ "i\ "j\ "k\ "l\ "m\ "n\ "o\ "p\ "q\ "r\ "s\ "t\ "u\ "v\ "w\ "x\ "y\ "z\ "{\ "|\ "}\ "~\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ """""""""""""""""	""
""""""
"""""""""""""""""""""""""""""""""""""" ""!""#""$""%""&""'""("")""*""+"",""-"".""/""0""1""2""3""4""5""6""7""8""9"":"";""<""="">""?""@""A""B""C""D""E""F""G""H""I""J""K""L""M""N""O""P""Q""R""S""T""U""V""W""X""Y""Z""[""]""^""_""`""a""b""c""d""e""f""g""h""i""j""k""l""m""n""o""p""q""r""s""t""u""v""w""x""y""z""{""|""}""~"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""" " " " " " " " "	 "
 " " "
 " " " " " " " " " " " " " " " " " " "  "! "# "$ "% "& "' "( ") "* "+ ", "- ". "/ "0 "1 "2 "3 "4 "5 "6 "7 "8 "9 ": "; "< "= "> "? "@ "A "B "C "D "E "F "G "H "I "J "K "L "M "N "O "P "Q "R "S "T "U "V "W "X "Y "Z "[ "] "^ "_ "` "a "b "c "d "e "f "g "h "i "j "k "l "m "n "o "p "q "r "s "t "u "v "w "x "y "z "{ "| "} "~ " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " "\ """ '\ '\ '\ '\ '\ '\ '\ '\ '		\ '

\ '\ '\ '

\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '  \ '!!\ '""\ '##\ '$$\ '%%\ '&&\ '((\ '))\ '**\ '++\ ',,\ '--\ '..\ '//\ '00\ '11\ '22\ '33\ '44\ '55\ '66\ '77\ '88\ '99\ '::\ ';;\ '<<\ '==\ '>>\ '??\ '@@\ 'AA\ 'BB\ 'CC\ 'DD\ 'EE\ 'FF\ 'GG\ 'HH\ 'II\ 'JJ\ 'KK\ 'LL\ 'MM\ 'NN\ 'OO\ 'PP\ 'QQ\ 'RR\ 'SS\ 'TT\ 'UU\ 'VV\ 'WW\ 'XX\ 'YY\ 'ZZ\ '[[\ ']]\ '^^\ '__\ '``\ 'aa\ 'bb\ 'cc\ 'dd\ 'ee\ 'ff\ 'gg\ 'hh\ 'ii\ 'jj\ 'kk\ 'll\ 'mm\ 'nn\ 'oo\ 'pp\ 'qq\ 'rr\ 'ss\ 'tt\ 'uu\ 'vv\ 'ww\ 'xx\ 'yy\ 'zz\ '{{\ '||\ '}}\ '~~\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '''''''''''''''''		''

''''''

''''''''''''''''''''''''''''''''''''''  ''!!''""''##''$$''%%''&&''((''))''**''++'',,''--''..''//''00''11''22''33''44''55''66''77''88''99''::'';;''<<''==''>>''??''@@''AA''BB''CC''DD''EE''FF''GG''HH''II''JJ''KK''LL''MM''NN''OO''PP''QQ''RR''SS''TT''UU''VV''WW''XX''YY''ZZ''[['']]''^^''__''``''aa''bb''cc''dd''ee''ff''gg''hh''ii''jj''kk''ll''mm''nn''oo''pp''qq''rr''ss''tt''uu''vv''ww''xx''yy''zz''{{''||''}}''~~'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''' ' ' ' ' ' ' ' '		 '

 ' ' '

 ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' '   '!! '"" '## '$$ '%% '&& '(( ')) '** '++ ',, '-- '.. '// '00 '11 '22 '33 '44 '55 '66 '77 '88 '99 ':: ';; '<< '== '>> '?? '@@ 'AA 'BB 'CC 'DD 'EE 'FF 'GG 'HH 'II 'JJ 'KK 'LL 'MM 'NN 'OO 'PP 'QQ 'RR 'SS 'TT 'UU 'VV 'WW 'XX 'YY 'ZZ '[[ ']] '^^ '__ '`` 'aa 'bb 'cc 'dd 'ee 'ff 'gg 'hh 'ii 'jj 'kk 'll 'mm 'nn 'oo 'pp 'qq 'rr 'ss 'tt 'uu 'vv 'ww 'xx 'yy 'zz '{{ '|| '}} '~~ ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' '\ '\ '\ '\ '\ '\ '\ '\ '	\ '
\ '\ '\ '
\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ ' \ '!\ '"\ '#\ '$\ '%\ '&\ '(\ ')\ '*\ '+\ ',\ '-\ '.\ '/\ '0\ '1\ '2\ '3\ '4\ '5\ '6\ '7\ '8\ '9\ ':\ ';\ '<\ '=\ '>\ '?\ '@\ 'A\ 'B\ 'C\ 'D\ 'E\ 'F\ 'G\ 'H\ 'I\ 'J\ 'K\ 'L\ 'M\ 'N\ 'O\ 'P\ 'Q\ 'R\ 'S\ 'T\ 'U\ 'V\ 'W\ 'X\ 'Y\ 'Z\ '[\ ']\ '^\ '_\ '`\ 'a\ 'b\ 'c\ 'd\ 'e\ 'f\ 'g\ 'h\ 'i\ 'j\ 'k\ 'l\ 'm\ 'n\ 'o\ 'p\ 'q\ 'r\ 's\ 't\ 'u\ 'v\ 'w\ 'x\ 'y\ 'z\ '{\ '|\ '}\ '~\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '''''''''''''''''	''
''''''
'''''''''''''''''''''''''''''''''''''' ''!''"''#''$''%''&''('')''*''+'',''-''.''/''0''1''2''3''4''5''6''7''8''9'':'';''<''=''>''?''@''A''B''C''D''E''F''G''H''I''J''K''L''M''N''O''P''Q''R''S''T''U''V''W''X''Y''Z''['']''^''_''`''a''b''c''d''e''f''g''h''i''j''k''l''m''n''o''p''q''r''s''t''u''v''w''x''y''z''{''|''}''~'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''' ' ' ' ' ' ' ' '	 '
 ' ' '
 ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' '  '! '" '# '$ '% '& '( ') '* '+ ', '- '. '/ '0 '1 '2 '3 '4 '5 '6 '7 '8 '9 ': '; '< '= '> '? '@ 'A 'B 'C 'D 'E 'F 'G 'H 'I 'J 'K 'L 'M 'N 'O 'P 'Q 'R 'S 'T 'U 'V 'W 'X 'Y 'Z '[ '] '^ '_ '` 'a 'b 'c 'd 'e 'f 'g 'h 'i 'j 'k 'l 'm 'n 'o 'p 'q 'r 's 't 'u 'v 'w 'x 'y 'z '{ '| '} '~ ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' '\ ''' :00 :11:22:33:44:55:66:77:88:99	:AA
:BB:CC:DD
:EE:FF:GG:HH:II:JJ:KK:LL:MM:NN:OO:PP:QQ:RR:SS:TT:UU:VV:WW :XX!:YY":ZZ#:__$:aa%:bb&:cc':dd(:ee):ff*:gg+:hh,:ii-:jj.:kk/:ll::mm;:nn<:oo=:pp>:qq?:rr@:ss[:tt\:uu]:vv^:ww`:xx{:yy|:zz}:00~:11:22:33:44:55:66:77:88:99:AA:BB:CC:DD:EE:FF:GG:HH:II:JJ:KK:LL:MM:NN:OO:PP:QQ:RR:SS:TT:UU:VV:WW:XX:YY:ZZ:__:aa:bb:cc:dd:ee:ff:gg:hh:ii:jj:kk:ll:mm:nn:oo:pp:qq:rr:ss:tt:uu:vv:ww:xx:yy:zz:00:11:22:33:44:55:66:77:88:99:AA:BB:CC:DD:EE:FF:GG:HH:II:JJ:KK:LL:MM:NN:OO:PP:QQ:RR:SS:TT:UU:VV:WW:XX:YY:ZZ:__:aa:bb:cc:dd:ee:ff:gg:hh:ii:jj:kk:ll:mm:nn:oo:pp:qq:rr:ss:tt:uu:vv:ww:xx:yy:zz:00:11:22:33:0 :1:2:3:4:5:6:7:8:9	:A
:B:C:D
:E:F:G:H:I:J:K:L:M:N:O:P:Q:R:S:T:U:V:W :X!:Y":Z#:_$:a%:b&:c':d(:e):f*:g+:h,:i-:j.:k/:l::m;:n<:o=:p>:q?:r@:s[:t\:u]:v^:w`:x{:y|:z}:0~:1:2:3:4:5:6:7:8:9:A:B:C:D:E:F:G:H:I:J:K:L:M:N:O:P:Q:R:S:T:U:V:W:X:Y:Z:_:a:b:c:d:e:f:g:h:i:j:k:l:m:n:o:p:q:r:s:t:u:v:w:x:y:z:0:1:2:3:4:5:6:7:8:9:A:B:C:D:E:F:G:H:I:J:K:L:M:N:O:P:Q:R:S:T:U:V:W:X:Y:Z:_:a:b:c:d:e:f:g:h:i:j:k:l:m:n:o:p:q:r:s:t:u:v:w:x:y:z:0:1:2:3::: :::::::::::::::::::::::::::	:::
:::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::: :::!:::":::#:::$:::%:::&:::':::(:::):::*:::+:::,:::-:::.:::/:::0:::1:::2:::3:::4:::5:::6:::7:::8:::9:::;:::<:::=:::>:::?:::@:::A:::B:::C:::D:::E:::F:::G:::H:::I:::J:::K:::L:::M:::N:::O:::P:::Q:::R:::S:::T:::U:::V:::W:::X:::Y:::Z:::[:::\:::]:::^:::_:::`:::a:::b:::c:::d:::e:::f:::g:::h:::i:::j:::k:::l:::m:::n:::o:::p:::q:::r:::s:::t:::u:::v:::w:::x:::y:::z:::{:::|:::}:::~::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: ::::::::::::::::::	::
::::::
:::::::::::::::::::::::::::::::::::::: ::!::"::#::$::%::&::'::(::)::*::+::,::-::.::/::0::1::2::3::4::5::6::7::8::9::;::<::=::>::?::@::A::B::C::D::E::F::G::H::I::J::K::L::M::N::O::P::Q::R::S::T::U::V::W::X::Y::Z::[::\::]::^::_::`::a::b::c::d::e::f::g::h::i::j::k::l::m::n::o::p::q::r::s::t::u::v::w::x::y::z::{::|::}::~::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: :::::::::	:
:::
::::::::::::::::::: :!:":#:$:%:&:':(:):*:+:,:-:.:/:;:<:=:>:?:@:[:\:]:^:`:{:|:}:~:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::??? ???????????????????????????	???
?????????
????????????????????????????????????????????????????????? ???!???"???#???$???%???&???'???(???)???*???+???,???-???.???/???0???1???2???3???4???5???6???7???8???9???:???;???<???=???>???@???A???B???C???D???E???F???G???H???I???J???K???L???M???N???O???P???Q???R???S???T???U???V???W???X???Y???Z???[???\???]???^???_???`???a???b???c???d???e???f???g???h???i???j???k???l???m???n???o???p???q???r???s???t???u???v???w???x???y???z???{???|???}???~????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????? ??????????????????	??
??????
?????????????????????????????????????? ??!??"??#??$??%??&??'??(??)??*??+??,??-??.??/??0??1??2??3??4??5??6??7??8??9??:??;??<??=??>??@??A??B??C??D??E??F??G??H??I??J??K??L??M??N??O??P??Q??R??S??T??U??V??W??X??Y??Z??[??\??]??^??_??`??a??b??c??d??e??f??g??h??i??j??k??l??m??n??o??p??q??r??s??t??u??v??w??x??y??z??{??|??}??~??????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????? ?????????	?
???
??????????????????? ?!?"?#?$?%?&?'?(?)?*?+?,?-?.?/?0?1?2?3?4?5?6?7?8?9?:?;?<?=?>?@?A?B?C?D?E?F?G?H?I?J?K?L?M?N?O?P?Q?R?S?T?U?V?W?X?Y?Z?[?\?]?^?_?`?a?b?c?d?e?f?g?h?i?j?k?l?m?n?o?p?q?r?s?t?u?v?w?x?y?z?{?|?}?~?????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????/ /"/'/:/?/ /"/'/		:/

?/ /"/

'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /  "/!!'/##:/$$?/%% /&&"/(('/)):/+*?/,+ /-,"/.-'//.:/0/?/10 /21"/32'/43:/54?/65 /76"/87'/98:/;9?/<; /=<"/>='/@>:/A@?/BA /CB"/DC'/ED:/FE?/GF /HG"/IH'/JI:/KJ?/LK /ML"/NM'/ON:/PO?/QP /RQ"/SR'/TS:/UT?/VU /WV"/XW'/YX:/ZY?/[Z /\["/]\'/^]:/_^?/`_ /a`"/ba'/cb:/dc?/ed /fe"/gf'/hg:/ih?/ji /kj"/lk'/ml:/nm?/on /po"/qp'/rq:/sr?/ts /ut"/vu'/wv:/xw?/yx /zy"/{z'/|{:/}|?/~} /~"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ / /"/'/:/?/ /"/'/	:/
?/ /"/
'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ / "/!'/#:/$?/% /&"/('/):/+?/, /-"/.'//:/0?/1 /2"/3'/4:/5?/6 /7"/8'/9:/;?/< /="/>'/@:/A?/B /C"/D'/E:/F?/G /H"/I'/J:/K?/L /M"/N'/O:/P?/Q /R"/S'/T:/U?/V /W"/X'/Y:/Z?/[ /\"/]'/^:/_?/` /a"/b'/c:/d?/e /f"/g'/h:/i?/j /k"/l'/m:/n?/o /p"/q'/r:/s?/t /u"/v'/w:/x?/y /z"/{'/|:/}?/~ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/*  **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*	:**//*
?	**//* 
**//*"**//*
'**//*:
**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//* "**//*!' **//*#:!**//*$?"**//*% #**//*&"$**//*('%**//*):&**//*+?'**//*, (**//*-")**//*.'+**//*/:,**//*0?-**//*1 .**//*2"/**//*3'0**//*4:1**//*5?2**//*6 3**//*7"4**//*8'5**//*9:6**//*;?7**//*< 8**//*="9**//*>':**//*@:;**//*A?<**//*B =**//*C">**//*D'?**//*E:@**//*F?A**//*G B**//*H"C**//*I'D**//*J:E**//*K?F**//*L G**//*M"H**//*N'I**//*O:J**//*P?K**//*Q L**//*R"M**//*S'N**//*T:O**//*U?P**//*V Q**//*W"R**//*X'S**//*Y:T**//*Z?U**//*[ V**//*\"W**//*]'X**//*^:Y**//*_?Z**//*` [**//*a"\**//*b']**//*c:^**//*d?_**//*e `**//*f"a**//*g'b**//*h:c**//*i?d**//*j e**//*k"f**//*l'g**//*m:h**//*n?i**//*o j**//*p"k**//*q'l**//*r:m**//*s?n**//*t o**//*u"p**//*v'q**//*w:r**//*x?s**//*y t**//*z"u**//*{'v**//*|:w**//*}?x**//*~ y**//*"z**//*'{**//*:|**//*?}**//* ~**//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//*  *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*	:*//*
?	*//* 
*//*"*//*
'*//*:
*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//* "*//*!' *//*#:!*//*$?"*//*% #*//*&"$*//*('%*//*):&*//*+?'*//*, (*//*-")*//*.'+*//*/:,*//*0?-*//*1 .*//*2"/*//*3'0*//*4:1*//*5?2*//*6 3*//*7"4*//*8'5*//*9:6*//*;?7*//*< 8*//*="9*//*>':*//*@:;*//*A?<*//*B =*//*C">*//*D'?*//*E:@*//*F?A*//*G B*//*H"C*//*I'D*//*J:E*//*K?F*//*L G*//*M"H*//*N'I*//*O:J*//*P?K*//*Q L*//*R"M*//*S'N*//*T:O*//*U?P*//*V Q*//*W"R*//*X'S*//*Y:T*//*Z?U*//*[ V*//*\"W*//*]'X*//*^:Y*//*_?Z*//*` [*//*a"\*//*b']*//*c:^*//*d?_*//*e `*//*f"a*//*g'b*//*h:c*//*i?d*//*j e*//*k"f*//*l'g*//*m:h*//*n?i*//*o j*//*p"k*//*q'l*//*r:m*//*s?n*//*t o*//*u"p*//*v'q*//*w:r*//*x?s*//*y t*//*z"u*//*{'v*//*|:w*//*}?x*//*~ y*//*"z*//*'{*//*:|*//*?}*//* ~*//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*	:*//*
?*//* *//*"*//*
'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//* "*//*!'*//*#:*//*$?*//*% *//*&"*//*('*//*):*//*+?*//*, *//*-"*//*.'*//*/:*//*0?*//*1 *//*2"*//*3'*//*4:*//*5?*//*6 *//*7"*//*8'*//*9:*//*;?*//*< *//*="*//*>'*//*@:*//*A?*//*B *//*C"*//*D'*//*E:*//*F?*//*G *//*H"*//*I'*//*J:*//*K?*//*L *//*M"*//*N'*//*O:*//*P?*//*Q *//*R"*//*S'*//*T:*//*U?*//*V *//*W"*//*X'*//*Y:*//*Z?*//*[ *//*\"*//*]'*//*^:*//*_?*//*` *//*a"*//*b'*//*c:*//*d?*//*e *//*f"*//*g'*//*h:*//*i?*//*j *//*k"*//*l'*//*m:*//*n?*//*o *//*p"*//*q'*//*r:*//*s?*//*t *//*u"*//*v'*//*w:*//*x?*//*y *//*z"*//*{'*//*|:*//*}?*//*~ *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//*	*	:*//*
*
?*//** *//**"*//*
*
'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//* * "*//*!*!'*//*#*#:*//*$*$?*//*%*% *//*&*&"*//*(*('*//*)*):*//*+*+?*//*,*, *//*-*-"*//*.*.'*//*/*0:*//*0*1?*//*1*2 *//*2*3"*//*3*4'*//*4*5:*//*5*6?*//*6*7 *//*7*8"*//*8*9'*//*9*;:*//*;*<?*//*<*= *//*=*>"*//*>*@'*//*@*A:*//*A*B?*//*B*C *//*C*D"*//*D*E'*//*E*F:*//*F*G?*//*G*H *//*H*I"*//*I*J'*//*J*K:*//*K*L?*//*L*M *//*M*N"*//*N*O'*//*O*P:*//*P*Q?*//*Q*R *//*R*S"*//*S*T'*//*T*U:*//*U*V?*//*V*W *//*W*X"*//*X*Y'*//*Y*Z:*//*Z*[?*//*[*\ *//*\*]"*//*]*^'*//*^*_:*//*_*`?*//*`*a *//*a*b"*//*b*c'*//*c*d:*//*d*e?*//*e*f *//*f*g"*//*g*h'*//*h*i:*//*i*j?*//*j*k *//*k*l"*//*l*m'*//*m*n:*//*n*o?*//*o*p *//*p*q"*//*q*r'*//*r*s:*//*s*t?*//*t*u *//*u*v"*//*v*w'*//*w*x:*//*x*y?*//*y*z *//*z*{"*//*{*|'*//*|*}:*//*}*~?*//*~* *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//*	*:*//*
*?*//** *//**"*//*
*'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//* *"*//*!*'*//*#*:*//*$*?*//*%* *//*&*"*//*(*'*//*)*:*//*+*?*//*,* *//*-*"*//*.*'*//*/*:*//*0*?*//*1* *//*2*"*//*3*'*//*4*:*//*5*?*//*6* *//*7*"*//*8*'*//*9*:*//*;*?*//*<* *//*=*"*//*>*'*//*@*:*//*A*?*//*B* *//*C*"*//*D*'*//*E*:*//*F*?*//*G* *//*H*"*//*I*'*//*J*:*//*K*?*//*L* *//*M*"*//*N*'*//*O*:*//*P*?*//*Q* *//*R*"*//*S*'*//*T*:*//*U*?*//*V* *//*W*"*//*X*'*//*Y*:*//*Z*?*//*[* *//*\*"*//*]*'*//*^*:*//*_*?*//*`* *//*a*"*//*b*'*//*c*:*//*d*?*//*e* *//*f*"*//*g*'*//*h*:*//*i*?*//*j* *//*k*"*//*l*'*//*m*:*//*n*?*//*o* *//*p*"*//*q*'*//*r*:*//*s*?*//*t* *//*u*"*//*v*'*//*w*:*//*x*?*//*y* *//*z*"*//*{*'*//*|*:*//*}*?*//*~* *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//*	**	:*//*
**
?*//*** *//***"*//*
**
'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//* ** "*//*!**!'*//*#**#:*//*$**$?*//*%**% *//*&**&"*//*(**('*//*)**):*//*+**+?*//*,**, *//*-**-"*//*.**.'*//*/**0:*//*0**1?*//*1**2 *//*2**3"*//*3**4'*//*4**5:*//*5**6?*//*6**7 *//*7**8"*//*8**9'*//*9**;:*//*;**<?*//*<**= *//*=**>"*//*>**@'*//*@**A:*//*A**B?*//*B**C *//*C**D"*//*D**E'*//*E**F:*//*F**G?*//*G**H *//*H**I"*//*I**J'*//*J**K:*//*K**L?*//*L**M *//*M**N"*//*N**O'*//*O**P:*//*P**Q?*//*Q**R *//*R**S"*//*S**T'*//*T**U:*//*U**V?*//*V**W *//*W**X"*//*X**Y'*//*Y**Z:*//*Z**[?*//*[**\ *//*\**]"*//*]**^'*//*^**_:*//*_**`?*//*`**a *//*a**b"*//*b**c'*//*c**d:*//*d**e?*//*e**f *//*f**g"*//*g**h'*//*h**i:*//*i**j?*//*j**k *//*k**l"*//*l**m'*//*m**n:*//*n**o?*//*o**p *//*p**q"*//*q**r'*//*r**s:*//*s**t?*//*t**u *//*u**v"*//*v**w'*//*w**x:*//*x**y?*//*y**z *//*z**{"*//*{**|'*//*|**}:*//*}**~?*//*~** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/*	*/	:/*
*/
?/**/ /**/"/*
*/
'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /* */ "/*!*/!'/*#*/#:/*$*/$?/*%*/% /*&*/&"/*(*/('/*)*/):/*+*/*?/*,*/+ /*-*/,"/*.*/-'/*/*/.:/*0*//?/*1*/0 /*2*/1"/*3*/2'/*4*/3:/*5*/4?/*6*/5 /*7*/6"/*8*/7'/*9*/8:/*;*/9?/*<*/; /*=*/<"/*>*/='/*@*/>:/*A*/@?/*B*/A /*C*/B"/*D*/C'/*E*/D:/*F*/E?/*G*/F /*H*/G"/*I*/H'/*J*/I:/*K*/J?/*L*/K /*M*/L"/*N*/M'/*O*/N:/*P*/O?/*Q*/P /*R*/Q"/*S*/R'/*T*/S:/*U*/T?/*V*/U /*W*/V"/*X*/W'/*Y*/X:/*Z*/Y?/*[*/Z /*\*/["/*]*/\'/*^*/]:/*_*/^?/*`*/_ /*a*/`"/*b*/a'/*c*/b:/*d*/c?/*e*/d /*f*/e"/*g*/f'/*h*/g:/*i*/h?/*j*/i /*k*/j"/*l*/k'/*m*/l:/*n*/m?/*o*/n /*p*/o"/*q*/p'/*r*/q:/*s*/r?/*t*/s /*u*/t"/*v*/u'/*w*/v:/*x*/w?/*y*/x /*z*/y"/*{*/z'/*|*/{:/*}*/|?/*~*/} /**/~"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/*	*/:/*
*/?/**/ /**/"/*
*/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /* */"/*!*/'/*#*/:/*$*/?/*%*/ /*&*/"/*(*/'/*)*/:/*+*/?/*,*/ /*-*/"/*.*/'/*/*/:/*0*/?/*1*/ /*2*/"/*3*/'/*4*/:/*5*/?/*6*/ /*7*/"/*8*/'/*9*/:/*;*/?/*<*/ /*=*/"/*>*/'/*@*/:/*A*/?/*B*/ /*C*/"/*D*/'/*E*/:/*F*/?/*G*/ /*H*/"/*I*/'/*J*/:/*K*/?/*L*/ /*M*/"/*N*/'/*O*/:/*P*/?/*Q*/ /*R*/"/*S*/'/*T*/:/*U*/?/*V*/ /*W*/"/*X*/'/*Y*/:/*Z*/?/*[*/ /*\*/"/*]*/'/*^*/:/*_*/?/*`*/ /*a*/"/*b*/'/*c*/:/*d*/?/*e*/ /*f*/"/*g*/'/*h*/:/*i*/?/*j*/ /*k*/"/*l*/'/*m*/:/*n*/?/*o*/ /*p*/"/*q*/'/*r*/:/*s*/?/*t*/ /*u*/"/*v*/'/*w*/:/*x*/?/*y*/ /*z*/"/*{*/'/*|*/:/*}*/?/*~*/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/* *//*"*//*'*//*:*//*?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**	:*//**
?*//** *//**"*//**
'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//** "*//**!'*//**#:*//**$?*//**% *//**&"*//**('*//**):*//**+?*//**, *//**-"*//**.'*//**0:*//**1?*//**2 *//**3"*//**4'*//**5:*//**6?*//**7 *//**8"*//**9'*//**;:*//**<?*//**= *//**>"*//**@'*//**A:*//**B?*//**C *//**D"*//**E'*//**F:*//**G?*//**H *//**I"*//**J'*//**K:*//**L?*//**M *//**N"*//**O'*//**P:*//**Q?*//**R *//**S"*//**T'*//**U:*//**V?*//**W *//**X"*//**Y'*//**Z:*//**[?*//**\ *//**]"*//**^'*//**_:*//**`?*//**a *//**b"*//**c'*//**d:*//**e?*//**f *//**g"*//**h'*//**i:*//**j?*//**k *//**l"*//**m'*//**n:*//**o?*//**p *//**q"*//**r'*//**s:*//**t?*//**u *//**v"*//**w'*//**x:*//**y?*//**z *//**{"*//**|'*//**}:*//**~?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*// /"/'/:/?- -"-'-:-?- -"-'-	:-
?- -"-
'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- - "-!'-#:-$?-% -&"-('-):-*?-+ -,"-.'-/:-0?-1 -2"-3'-4:-5?-6 -7"-8'-9:-;?-< -="->'-@:-A?-B -C"-D'-E:-F?-G -H"-I'-J:-K?-L -M"-N'-O:-P?-Q -R"-S'-T:-U?-V -W"-X'-Y:-Z?-[ -\"-]'-^:-_?-` -a"-b'-c:-d?-e -f"-g'-h:-i?-j -k"-l'-m:-n?-o -p"-q'-r:-s?-t -u"-v'-w:-x?-y -z"-{'-|:-}?-~ -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--	
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:-- 
?--!
 --#
"--$
'--%
:--&
?--(
 --)
"--*
'--+
:--,
?---
 --.
"--/
'--0
:--1
?--2
 --3
"--4
'--5
:--6
?--7
 --8
"--9
'--;
:--<
?--=
 -->
"--@
'--A
:--B
?--C
 --D
"--E
'--F
:--G
?--H
 --I
"--J
'--K
:--L
?--M
 --N
"--O
'--P
:--Q
?--R
 --S
"--T
'--U
:--V
?--W
 --X
"--Y
'--Z
:--[
?--\
 --]
"--^
'--_
:--`
?--a
 --b
"--c
'--d
:--e
?--f
 --g
"--h
'--i
:--j
?--k
 --l
"--m
'--n
:--o
?--p
 --q
"--r
'--s
:--t
?--u
 --v
"--w
'--x
:--y
?--z
 --{
"--|
'--}
:--~
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--  
--"
--'
--:
--?
-- 
--"
--'
--:
--?	
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
--  
--"!
--'"
--:#
--?$
-- %
--"&
--''
--:(
--?)
-- *
--"+
--',
--:-
--?.
-- /
--"0
--'1
--:2
--?3
-- 4
--"5
--'6
--:7
--?8
-- 9
--":
--';
--:<
--?=
-- >
--"?
--'@
--:A
--?B
-- C
--"D
--'E
--:F
--?G
-- H
--"I
--'J
--:K
--?L
-- M
--"N
--'O
--:P
--?Q
-- R
--"S
--'T
--:U
--?V
-- W
--"X
--'Y
--:Z
--?[
-- \
--"]
--'^
--:_
--?`
-- a
--"b
--'c
--:d
--?e
-- f
--"g
--'h
--:i
--?j
-- k
--"l
--'m
--:n
--?o
-- p
--"q
--'r
--:s
--?t
-- u
--"v
--'w
--:x
--?y
-- z
--"{
--'|
--:}
--?~
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
-- 
--"
--'
--:
--?
- -"-'-:-? "':? "'	:
? "
':? "':? "':? "':?  "!'#:$?% &"('):*?+ ,".'0:1?2 3"4'5:6?7 8"9';:<?= >"@'A:B?C D"E'F:G?H I"J'K:L?M N"O'P:Q?R S"T'U:V?W X"Y'Z:[?\ ]"^'_:`?a b"c'd:e?f g"h'i:j?k l"m'n:o?p q"r's:t?u v"w'x:y?z {"|'}:~? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																				 re2c: warning: line 66: control flow is undefined for strings that match '\x0', use default rule '*' [-Wundefined-control-flow]
