#----------------------------------------------------------------------------------#
#
# FILE:			__init__.py
# AUTHOR:		Peter Quinn
# DATE:			23.02.2005
# VERSION:		1.00
#
# DESCRIPTION:	Regular expression control
#
#----------------------------------------------------------------------------------#

from libdesklets.controls import Control, Interface, Permission
import re


#----------------------------------------------------------------------------------#
#
# Regexp Interface
#
class IRegExp(Interface):

	result	= Permission.READ
	search	= Permission.WRITE
	sub		= Permission.WRITE
	simple	= Permission.READWRITE


#----------------------------------------------------------------------------------#
#
#
#
class RegExp(Control, IRegExp):
	
	#
	# Regexp constructor
	#
	def __init__(self):

		self.__result	= None
		self.__simple	= True

		Control.__init__(self)


	#
	# Translates simple expressions into regular expressions
	#
	def __translate(self, str):

		str = re.sub("<upperword>", "([A-Z]+)", str)
		str = re.sub("<lowerword>", "([a-z]+)", str)
		str = re.sub("<upperletter>", "([A-Z])", str)
		str = re.sub("<lowerletter>", "([a-z])", str)
		str = re.sub("<letter>", "([a-zA-B])", str)
		str = re.sub("<word>", "(\w+)", str)
		str = re.sub("<digit>", "(\d)", str)
		str = re.sub("<number>", "(\d+)", str)
		str = re.sub("<everything>", "(.*)", str)
		str = re.sub("<letterdigit>", "([a-zA-Z0-9])", str)
		str = re.sub("<wordnumber>", "([a-zA-Z0-9]+)", str)
		str = re.sub("<ipaddress>", "((?:[0-9]{1,3}\.){3}[0-9]{1,3})", str)

		return str
		
	#
	# Searches a string for a occurance
	#
	def __search(self, obj):

		(str, source) = obj

		if self.__simple:
			self.__result = re.search(self.__translate(str), source)
	
		else:
			self.__result = re.search(str, source)


	#
	# Substitutes a occurance within a string with another string
	#
	def __sub(self, obj):

		(search, str, source) = obj

		if self.__simple:
			self.__result = re.search(self.__translate(str), source)

		else:
			self.__result = re.sub(search, str, source)


	#
	# Returns the result of the last regular expression
	#
	def __get_result(self):

		return self.__result
		

	#
	# Returns the status of simple regular expression usage
	#
	def __get_simple(self):

		return self.__simple


	#
	# Turns on/off simple regular expression usage
	#
	def __set_simple(self, flag):

		self.__simple = flag

		
	#
	# Interface
	#
	search	= property(	fset = __search,
						doc = "Perform a regular expression search")
	sub		= property(	fset = __sub,
						doc = "")
	result	= property(	fget = __get_result,
						doc = "Result from previous regular expression")
	simple	= property(	fget = __get_simple, fset = __set_simple,
						doc = "Get/Set simple regular expression usage")
	
	
#----------------------------------------------------------------------------------#

def get_class(): return RegExp

