/*
 Copyright (c) 2003, Dominik Reichl <dominik.reichl@t-online.de>
 All rights reserved.

 LICENSE TERMS

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.
 * Neither the name of ReichlSoft nor the names of its contributors may be used
   to endorse or promote products derived from this software without specific
   prior written permission.

 DISCLAIMER

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include "crc16.h"

// CRC-16 lookup table
static const UWORD16 g_pCRC16Tab[] = {
	0x0000, 0xC0C1, 0xC181, 0x0140, 0xC301, 0x03C0, 0x0280, 0xC241,
	0xC601, 0x06C0, 0x0780, 0xC741, 0x0500, 0xC5C1, 0xC481, 0x0440,
	0xCC01, 0x0CC0, 0x0D80, 0xCD41, 0x0F00, 0xCFC1, 0xCE81, 0x0E40,
	0x0A00, 0xCAC1, 0xCB81, 0x0B40, 0xC901, 0x09C0, 0x0880, 0xC841,
	0xD801, 0x18C0, 0x1980, 0xD941, 0x1B00, 0xDBC1, 0xDA81, 0x1A40,
	0x1E00, 0xDEC1, 0xDF81, 0x1F40, 0xDD01, 0x1DC0, 0x1C80, 0xDC41,
	0x1400, 0xD4C1, 0xD581, 0x1540, 0xD701, 0x17C0, 0x1680, 0xD641,
	0xD201, 0x12C0, 0x1380, 0xD341, 0x1100, 0xD1C1, 0xD081, 0x1040,
	0xF001, 0x30C0, 0x3180, 0xF141, 0x3300, 0xF3C1, 0xF281, 0x3240,
	0x3600, 0xF6C1, 0xF781, 0x3740, 0xF501, 0x35C0, 0x3480, 0xF441,
	0x3C00, 0xFCC1, 0xFD81, 0x3D40, 0xFF01, 0x3FC0, 0x3E80, 0xFE41,
	0xFA01, 0x3AC0, 0x3B80, 0xFB41, 0x3900, 0xF9C1, 0xF881, 0x3840,
	0x2800, 0xE8C1, 0xE981, 0x2940, 0xEB01, 0x2BC0, 0x2A80, 0xEA41,
	0xEE01, 0x2EC0, 0x2F80, 0xEF41, 0x2D00, 0xEDC1, 0xEC81, 0x2C40,
	0xE401, 0x24C0, 0x2580, 0xE541, 0x2700, 0xE7C1, 0xE681, 0x2640,
	0x2200, 0xE2C1, 0xE381, 0x2340, 0xE101, 0x21C0, 0x2080, 0xE041,
	0xA001, 0x60C0, 0x6180, 0xA141, 0x6300, 0xA3C1, 0xA281, 0x6240,
	0x6600, 0xA6C1, 0xA781, 0x6740, 0xA501, 0x65C0, 0x6480, 0xA441,
	0x6C00, 0xACC1, 0xAD81, 0x6D40, 0xAF01, 0x6FC0, 0x6E80, 0xAE41,
	0xAA01, 0x6AC0, 0x6B80, 0xAB41, 0x6900, 0xA9C1, 0xA881, 0x6840,
	0x7800, 0xB8C1, 0xB981, 0x7940, 0xBB01, 0x7BC0, 0x7A80, 0xBA41,
	0xBE01, 0x7EC0, 0x7F80, 0xBF41, 0x7D00, 0xBDC1, 0xBC81, 0x7C40,
	0xB401, 0x74C0, 0x7580, 0xB541, 0x7700, 0xB7C1, 0xB681, 0x7640,
	0x7200, 0xB2C1, 0xB381, 0x7340, 0xB101, 0x71C0, 0x7080, 0xB041,
	0x5000, 0x90C1, 0x9181, 0x5140, 0x9301, 0x53C0, 0x5280, 0x9241,
	0x9601, 0x56C0, 0x5780, 0x9741, 0x5500, 0x95C1, 0x9481, 0x5440,
	0x9C01, 0x5CC0, 0x5D80, 0x9D41, 0x5F00, 0x9FC1, 0x9E81, 0x5E40,
	0x5A00, 0x9AC1, 0x9B81, 0x5B40, 0x9901, 0x59C0, 0x5880, 0x9841,
	0x8801, 0x48C0, 0x4980, 0x8941, 0x4B00, 0x8BC1, 0x8A81, 0x4A40,
	0x4E00, 0x8EC1, 0x8F81, 0x4F40, 0x8D01, 0x4DC0, 0x4C80, 0x8C41,
	0x4400, 0x84C1, 0x8581, 0x4540, 0x8701, 0x47C0, 0x4680, 0x8641,
	0x8201, 0x42C0, 0x4380, 0x8341, 0x4100, 0x81C1, 0x8081, 0x4040
};

CCRC16Hash::CCRC16Hash()
{
}

CCRC16Hash::~CCRC16Hash()
{
}

void CCRC16Hash::Init(RH_DATA_INFO *pInfo)
{
	m_crc16 = 0x0000;
}

void CCRC16Hash::Update(const UWORD8 *pBuf, UINTPREF uLen)
{
	UWORD32 i;

	for(i = 0; i < uLen; i++)
		m_crc16 = (m_crc16 >> 8) ^ g_pCRC16Tab[*pBuf++ ^ (m_crc16 & 0xFF)];
}

void CCRC16Hash::Final()
{
}

//////////////////////////////////////////////////////////////////////////////

static const UWORD16 g_pCRC16CcittTable[256] =
{
	0x0000U, 0x1021U, 0x2042U, 0x3063U, 0x4084U, 0x50a5U, 0x60c6U, 0x70e7U,
	0x8108U, 0x9129U, 0xa14aU, 0xb16bU, 0xc18cU, 0xd1adU, 0xe1ceU, 0xf1efU,
	0x1231U, 0x0210U, 0x3273U, 0x2252U, 0x52b5U, 0x4294U, 0x72f7U, 0x62d6U,
	0x9339U, 0x8318U, 0xb37bU, 0xa35aU, 0xd3bdU, 0xc39cU, 0xf3ffU, 0xe3deU,
	0x2462U, 0x3443U, 0x0420U, 0x1401U, 0x64e6U, 0x74c7U, 0x44a4U, 0x5485U,
	0xa56aU, 0xb54bU, 0x8528U, 0x9509U, 0xe5eeU, 0xf5cfU, 0xc5acU, 0xd58dU,
	0x3653U, 0x2672U, 0x1611U, 0x0630U, 0x76d7U, 0x66f6U, 0x5695U, 0x46b4U,
	0xb75bU, 0xa77aU, 0x9719U, 0x8738U, 0xf7dfU, 0xe7feU, 0xd79dU, 0xc7bcU,
	0x48c4U, 0x58e5U, 0x6886U, 0x78a7U, 0x0840U, 0x1861U, 0x2802U, 0x3823U,
	0xc9ccU, 0xd9edU, 0xe98eU, 0xf9afU, 0x8948U, 0x9969U, 0xa90aU, 0xb92bU,
	0x5af5U, 0x4ad4U, 0x7ab7U, 0x6a96U, 0x1a71U, 0x0a50U, 0x3a33U, 0x2a12U,
	0xdbfdU, 0xcbdcU, 0xfbbfU, 0xeb9eU, 0x9b79U, 0x8b58U, 0xbb3bU, 0xab1aU,
	0x6ca6U, 0x7c87U, 0x4ce4U, 0x5cc5U, 0x2c22U, 0x3c03U, 0x0c60U, 0x1c41U,
	0xedaeU, 0xfd8fU, 0xcdecU, 0xddcdU, 0xad2aU, 0xbd0bU, 0x8d68U, 0x9d49U,
	0x7e97U, 0x6eb6U, 0x5ed5U, 0x4ef4U, 0x3e13U, 0x2e32U, 0x1e51U, 0x0e70U,
	0xff9fU, 0xefbeU, 0xdfddU, 0xcffcU, 0xbf1bU, 0xaf3aU, 0x9f59U, 0x8f78U,
	0x9188U, 0x81a9U, 0xb1caU, 0xa1ebU, 0xd10cU, 0xc12dU, 0xf14eU, 0xe16fU,
	0x1080U, 0x00a1U, 0x30c2U, 0x20e3U, 0x5004U, 0x4025U, 0x7046U, 0x6067U,
	0x83b9U, 0x9398U, 0xa3fbU, 0xb3daU, 0xc33dU, 0xd31cU, 0xe37fU, 0xf35eU,
	0x02b1U, 0x1290U, 0x22f3U, 0x32d2U, 0x4235U, 0x5214U, 0x6277U, 0x7256U,
	0xb5eaU, 0xa5cbU, 0x95a8U, 0x8589U, 0xf56eU, 0xe54fU, 0xd52cU, 0xc50dU,
	0x34e2U, 0x24c3U, 0x14a0U, 0x0481U, 0x7466U, 0x6447U, 0x5424U, 0x4405U,
	0xa7dbU, 0xb7faU, 0x8799U, 0x97b8U, 0xe75fU, 0xf77eU, 0xc71dU, 0xd73cU,
	0x26d3U, 0x36f2U, 0x0691U, 0x16b0U, 0x6657U, 0x7676U, 0x4615U, 0x5634U,
	0xd94cU, 0xc96dU, 0xf90eU, 0xe92fU, 0x99c8U, 0x89e9U, 0xb98aU, 0xa9abU,
	0x5844U, 0x4865U, 0x7806U, 0x6827U, 0x18c0U, 0x08e1U, 0x3882U, 0x28a3U,
	0xcb7dU, 0xdb5cU, 0xeb3fU, 0xfb1eU, 0x8bf9U, 0x9bd8U, 0xabbbU, 0xbb9aU,
	0x4a75U, 0x5a54U, 0x6a37U, 0x7a16U, 0x0af1U, 0x1ad0U, 0x2ab3U, 0x3a92U,
	0xfd2eU, 0xed0fU, 0xdd6cU, 0xcd4dU, 0xbdaaU, 0xad8bU, 0x9de8U, 0x8dc9U,
	0x7c26U, 0x6c07U, 0x5c64U, 0x4c45U, 0x3ca2U, 0x2c83U, 0x1ce0U, 0x0cc1U,
	0xef1fU, 0xff3eU, 0xcf5dU, 0xdf7cU, 0xaf9bU, 0xbfbaU, 0x8fd9U, 0x9ff8U,
	0x6e17U, 0x7e36U, 0x4e55U, 0x5e74U, 0x2e93U, 0x3eb2U, 0x0ed1U, 0x1ef0U
};

CCRC16CcittHash::CCRC16CcittHash()
{
}

CCRC16CcittHash::~CCRC16CcittHash()
{
}

void CCRC16CcittHash::Init(RH_DATA_INFO *pInfo)
{
	m_crc16 = 0xFFFF;
}

void CCRC16CcittHash::Update(const UWORD8 *pBuf, UINTPREF uLen)
{
	UWORD32 i;

	for(i = 0; i < uLen; i++)
		m_crc16 = g_pCRC16CcittTable[(UWORD8)(m_crc16 >> 8) ^ *pBuf++] ^ (m_crc16 << 8);
}

void CCRC16CcittHash::Final()
{
}

//////////////////////////////////////////////////////////////////////////////

static const UWORD16 g_pCRC16XModemTable[256] =
{
	0x0000U, 0x17ceU, 0x0fdfU, 0x1811U, 0x1fbeU, 0x0870U, 0x1061U, 0x07afU,
	0x1f3fU, 0x08f1U, 0x10e0U, 0x072eU, 0x0081U, 0x174fU, 0x0f5eU, 0x1890U,
	0x1e3dU, 0x09f3U, 0x11e2U, 0x062cU, 0x0183U, 0x164dU, 0x0e5cU, 0x1992U,
	0x0102U, 0x16ccU, 0x0eddU, 0x1913U, 0x1ebcU, 0x0972U, 0x1163U, 0x06adU,
	0x1c39U, 0x0bf7U, 0x13e6U, 0x0428U, 0x0387U, 0x1449U, 0x0c58U, 0x1b96U,
	0x0306U, 0x14c8U, 0x0cd9U, 0x1b17U, 0x1cb8U, 0x0b76U, 0x1367U, 0x04a9U,
	0x0204U, 0x15caU, 0x0ddbU, 0x1a15U, 0x1dbaU, 0x0a74U, 0x1265U, 0x05abU,
	0x1d3bU, 0x0af5U, 0x12e4U, 0x052aU, 0x0285U, 0x154bU, 0x0d5aU, 0x1a94U,
	0x1831U, 0x0fffU, 0x17eeU, 0x0020U, 0x078fU, 0x1041U, 0x0850U, 0x1f9eU,
	0x070eU, 0x10c0U, 0x08d1U, 0x1f1fU, 0x18b0U, 0x0f7eU, 0x176fU, 0x00a1U,
	0x060cU, 0x11c2U, 0x09d3U, 0x1e1dU, 0x19b2U, 0x0e7cU, 0x166dU, 0x01a3U,
	0x1933U, 0x0efdU, 0x16ecU, 0x0122U, 0x068dU, 0x1143U, 0x0952U, 0x1e9cU,
	0x0408U, 0x13c6U, 0x0bd7U, 0x1c19U, 0x1bb6U, 0x0c78U, 0x1469U, 0x03a7U,
	0x1b37U, 0x0cf9U, 0x14e8U, 0x0326U, 0x0489U, 0x1347U, 0x0b56U, 0x1c98U,
	0x1a35U, 0x0dfbU, 0x15eaU, 0x0224U, 0x058bU, 0x1245U, 0x0a54U, 0x1d9aU,
	0x050aU, 0x12c4U, 0x0ad5U, 0x1d1bU, 0x1ab4U, 0x0d7aU, 0x156bU, 0x02a5U,
	0x1021U, 0x07efU, 0x1ffeU, 0x0830U, 0x0f9fU, 0x1851U, 0x0040U, 0x178eU,
	0x0f1eU, 0x18d0U, 0x00c1U, 0x170fU, 0x10a0U, 0x076eU, 0x1f7fU, 0x08b1U,
	0x0e1cU, 0x19d2U, 0x01c3U, 0x160dU, 0x11a2U, 0x066cU, 0x1e7dU, 0x09b3U,
	0x1123U, 0x06edU, 0x1efcU, 0x0932U, 0x0e9dU, 0x1953U, 0x0142U, 0x168cU,
	0x0c18U, 0x1bd6U, 0x03c7U, 0x1409U, 0x13a6U, 0x0468U, 0x1c79U, 0x0bb7U,
	0x1327U, 0x04e9U, 0x1cf8U, 0x0b36U, 0x0c99U, 0x1b57U, 0x0346U, 0x1488U,
	0x1225U, 0x05ebU, 0x1dfaU, 0x0a34U, 0x0d9bU, 0x1a55U, 0x0244U, 0x158aU,
	0x0d1aU, 0x1ad4U, 0x02c5U, 0x150bU, 0x12a4U, 0x056aU, 0x1d7bU, 0x0ab5U,
	0x0810U, 0x1fdeU, 0x07cfU, 0x1001U, 0x17aeU, 0x0060U, 0x1871U, 0x0fbfU,
	0x172fU, 0x00e1U, 0x18f0U, 0x0f3eU, 0x0891U, 0x1f5fU, 0x074eU, 0x1080U,
	0x162dU, 0x01e3U, 0x19f2U, 0x0e3cU, 0x0993U, 0x1e5dU, 0x064cU, 0x1182U,
	0x0912U, 0x1edcU, 0x06cdU, 0x1103U, 0x16acU, 0x0162U, 0x1973U, 0x0ebdU,
	0x1429U, 0x03e7U, 0x1bf6U, 0x0c38U, 0x0b97U, 0x1c59U, 0x0448U, 0x1386U,
	0x0b16U, 0x1cd8U, 0x04c9U, 0x1307U, 0x14a8U, 0x0366U, 0x1b77U, 0x0cb9U,
	0x0a14U, 0x1ddaU, 0x05cbU, 0x1205U, 0x15aaU, 0x0264U, 0x1a75U, 0x0dbbU,
	0x152bU, 0x02e5U, 0x1af4U, 0x0d3aU, 0x0a95U, 0x1d5bU, 0x054aU, 0x1284U
};

CCRC16XModemHash::CCRC16XModemHash()
{
}

CCRC16XModemHash::~CCRC16XModemHash()
{
}

void CCRC16XModemHash::Init(RH_DATA_INFO *pInfo)
{
	m_crc16 = 0x0000;
}

void CCRC16XModemHash::Update(const UWORD8 *pBuf, UINTPREF uLen)
{
	UWORD32 i;

	for(i = 0; i < uLen; i++)
		m_crc16 = g_pCRC16XModemTable[(m_crc16 ^ *pBuf++) & 0xFF] ^ (m_crc16 >> 8);
}

void CCRC16XModemHash::Final()
{
}
