/*
 Copyright (c) 2003, Dominik Reichl <dominik.reichl@t-online.de>
 All rights reserved.

 LICENSE TERMS

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.
 * Neither the name of ReichlSoft nor the names of its contributors may be used
   to endorse or promote products derived from this software without specific
   prior written permission.

 DISCLAIMER

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include "xumhash.h"

#define XUM_ELF_MOD 997

static const UWORD32 g_pXUMCRC32Tab[] =
{
	CONST32(0x00000000), CONST32(0x77073096), CONST32(0xEE0E612C), CONST32(0x990951BA),
	CONST32(0x076DC419), CONST32(0x706AF48F), CONST32(0xE963A535), CONST32(0x9E6495A3),
	CONST32(0x0EDB8832), CONST32(0x79DCB8A4), CONST32(0xE0D5E91E), CONST32(0x97D2D988),
	CONST32(0x09B64C2B), CONST32(0x7EB17CBD), CONST32(0xE7B82D07), CONST32(0x90BF1D91),
	CONST32(0x1DB71064), CONST32(0x6AB020F2), CONST32(0xF3B97148), CONST32(0x84BE41DE),
	CONST32(0x1ADAD47D), CONST32(0x6DDDE4EB), CONST32(0xF4D4B551), CONST32(0x83D385C7),
	CONST32(0x136C9856), CONST32(0x646BA8C0), CONST32(0xFD62F97A), CONST32(0x8A65C9EC),
	CONST32(0x14015C4F), CONST32(0x63066CD9), CONST32(0xFA0F3D63), CONST32(0x8D080DF5),
	CONST32(0x3B6E20C8), CONST32(0x4C69105E), CONST32(0xD56041E4), CONST32(0xA2677172),
	CONST32(0x3C03E4D1), CONST32(0x4B04D447), CONST32(0xD20D85FD), CONST32(0xA50AB56B),
	CONST32(0x35B5A8FA), CONST32(0x42B2986C), CONST32(0xDBBBC9D6), CONST32(0xACBCF940),
	CONST32(0x32D86CE3), CONST32(0x45DF5C75), CONST32(0xDCD60DCF), CONST32(0xABD13D59),
	CONST32(0x26D930AC), CONST32(0x51DE003A), CONST32(0xC8D75180), CONST32(0xBFD06116),
	CONST32(0x21B4F4B5), CONST32(0x56B3C423), CONST32(0xCFBA9599), CONST32(0xB8BDA50F),
	CONST32(0x2802B89E), CONST32(0x5F058808), CONST32(0xC60CD9B2), CONST32(0xB10BE924),
	CONST32(0x2F6F7C87), CONST32(0x58684C11), CONST32(0xC1611DAB), CONST32(0xB6662D3D),
	CONST32(0x76DC4190), CONST32(0x01DB7106), CONST32(0x98D220BC), CONST32(0xEFD5102A),
	CONST32(0x71B18589), CONST32(0x06B6B51F), CONST32(0x9FBFE4A5), CONST32(0xE8B8D433),
	CONST32(0x7807C9A2), CONST32(0x0F00F934), CONST32(0x9609A88E), CONST32(0xE10E9818),
	CONST32(0x7F6A0DBB), CONST32(0x086D3D2D), CONST32(0x91646C97), CONST32(0xE6635C01),
	CONST32(0x6B6B51F4), CONST32(0x1C6C6162), CONST32(0x856530D8), CONST32(0xF262004E),
	CONST32(0x6C0695ED), CONST32(0x1B01A57B), CONST32(0x8208F4C1), CONST32(0xF50FC457),
	CONST32(0x65B0D9C6), CONST32(0x12B7E950), CONST32(0x8BBEB8EA), CONST32(0xFCB9887C),
	CONST32(0x62DD1DDF), CONST32(0x15DA2D49), CONST32(0x8CD37CF3), CONST32(0xFBD44C65),
	CONST32(0x4DB26158), CONST32(0x3AB551CE), CONST32(0xA3BC0074), CONST32(0xD4BB30E2),
	CONST32(0x4ADFA541), CONST32(0x3DD895D7), CONST32(0xA4D1C46D), CONST32(0xD3D6F4FB),
	CONST32(0x4369E96A), CONST32(0x346ED9FC), CONST32(0xAD678846), CONST32(0xDA60B8D0),
	CONST32(0x44042D73), CONST32(0x33031DE5), CONST32(0xAA0A4C5F), CONST32(0xDD0D7CC9),
	CONST32(0x5005713C), CONST32(0x270241AA), CONST32(0xBE0B1010), CONST32(0xC90C2086),
	CONST32(0x5768B525), CONST32(0x206F85B3), CONST32(0xB966D409), CONST32(0xCE61E49F),
	CONST32(0x5EDEF90E), CONST32(0x29D9C998), CONST32(0xB0D09822), CONST32(0xC7D7A8B4),
	CONST32(0x59B33D17), CONST32(0x2EB40D81), CONST32(0xB7BD5C3B), CONST32(0xC0BA6CAD),
	CONST32(0xEDB88320), CONST32(0x9ABFB3B6), CONST32(0x03B6E20C), CONST32(0x74B1D29A),
	CONST32(0xEAD54739), CONST32(0x9DD277AF), CONST32(0x04DB2615), CONST32(0x73DC1683),
	CONST32(0xE3630B12), CONST32(0x94643B84), CONST32(0x0D6D6A3E), CONST32(0x7A6A5AA8),
	CONST32(0xE40ECF0B), CONST32(0x9309FF9D), CONST32(0x0A00AE27), CONST32(0x7D079EB1),
	CONST32(0xF00F9344), CONST32(0x8708A3D2), CONST32(0x1E01F268), CONST32(0x6906C2FE),
	CONST32(0xF762575D), CONST32(0x806567CB), CONST32(0x196C3671), CONST32(0x6E6B06E7),
	CONST32(0xFED41B76), CONST32(0x89D32BE0), CONST32(0x10DA7A5A), CONST32(0x67DD4ACC),
	CONST32(0xF9B9DF6F), CONST32(0x8EBEEFF9), CONST32(0x17B7BE43), CONST32(0x60B08ED5),
	CONST32(0xD6D6A3E8), CONST32(0xA1D1937E), CONST32(0x38D8C2C4), CONST32(0x4FDFF252),
	CONST32(0xD1BB67F1), CONST32(0xA6BC5767), CONST32(0x3FB506DD), CONST32(0x48B2364B),
	CONST32(0xD80D2BDA), CONST32(0xAF0A1B4C), CONST32(0x36034AF6), CONST32(0x41047A60),
	CONST32(0xDF60EFC3), CONST32(0xA867DF55), CONST32(0x316E8EEF), CONST32(0x4669BE79),
	CONST32(0xCB61B38C), CONST32(0xBC66831A), CONST32(0x256FD2A0), CONST32(0x5268E236),
	CONST32(0xCC0C7795), CONST32(0xBB0B4703), CONST32(0x220216B9), CONST32(0x5505262F),
	CONST32(0xC5BA3BBE), CONST32(0xB2BD0B28), CONST32(0x2BB45A92), CONST32(0x5CB36A04),
	CONST32(0xC2D7FFA7), CONST32(0xB5D0CF31), CONST32(0x2CD99E8B), CONST32(0x5BDEAE1D),
	CONST32(0x9B64C2B0), CONST32(0xEC63F226), CONST32(0x756AA39C), CONST32(0x026D930A),
	CONST32(0x9C0906A9), CONST32(0xEB0E363F), CONST32(0x72076785), CONST32(0x05005713),
	CONST32(0x95BF4A82), CONST32(0xE2B87A14), CONST32(0x7BB12BAE), CONST32(0x0CB61B38),
	CONST32(0x92D28E9B), CONST32(0xE5D5BE0D), CONST32(0x7CDCEFB7), CONST32(0x0BDBDF21),
	CONST32(0x86D3D2D4), CONST32(0xF1D4E242), CONST32(0x68DDB3F8), CONST32(0x1FDA836E),
	CONST32(0x81BE16CD), CONST32(0xF6B9265B), CONST32(0x6FB077E1), CONST32(0x18B74777),
	CONST32(0x88085AE6), CONST32(0xFF0F6A70), CONST32(0x66063BCA), CONST32(0x11010B5C),
	CONST32(0x8F659EFF), CONST32(0xF862AE69), CONST32(0x616BFFD3), CONST32(0x166CCF45),
	CONST32(0xA00AE278), CONST32(0xD70DD2EE), CONST32(0x4E048354), CONST32(0x3903B3C2),
	CONST32(0xA7672661), CONST32(0xD06016F7), CONST32(0x4969474D), CONST32(0x3E6E77DB),
	CONST32(0xAED16A4A), CONST32(0xD9D65ADC), CONST32(0x40DF0B66), CONST32(0x37D83BF0),
	CONST32(0xA9BCAE53), CONST32(0xDEBB9EC5), CONST32(0x47B2CF7F), CONST32(0x30B5FFE9),
	CONST32(0xBDBDF21C), CONST32(0xCABAC28A), CONST32(0x53B39330), CONST32(0x24B4A3A6),
	CONST32(0xBAD03605), CONST32(0xCDD70693), CONST32(0x54DE5729), CONST32(0x23D967BF),
	CONST32(0xB3667A2E), CONST32(0xC4614AB8), CONST32(0x5D681B02), CONST32(0x2A6F2B94),
	CONST32(0xB40BBE37), CONST32(0xC30C8EA1), CONST32(0x5A05DF1B), CONST32(0x2D02EF8D)
};

CXUM32Hash::CXUM32Hash()
{
}

CXUM32Hash::~CXUM32Hash()
{
}

void CXUM32Hash::Init(RH_DATA_INFO *pInfo)
{
	m_crc32 = CONST32(0xFFFFFFFF); // Initialize CRC-32
	m_elf32 = CONST32(0x00000000); // Initialize ELF-32

	m_xum32 = CONST32(0x00000000); // Initialize XUM-32
}

void CXUM32Hash::Update(const UWORD8 *pBuf, UINTPREF uLen)
{
	UINTPREF i;
	UWORD32 g;

	for(i = 0; i < uLen; i++)
	{
		m_crc32 = ((m_crc32 >> 8) & CONST32(0x00FFFFFF)) ^
			g_pXUMCRC32Tab[(m_crc32 ^ pBuf[i]) & 0xFF];

		m_elf32 = (m_elf32 << 4) + pBuf[i];
		g = m_elf32 & CONST32(0xF0000000);

		if(g != 0) m_elf32 ^= g >> 24;
		m_elf32 &= ~g;
	}

	m_xum32 += (UWORD32)uLen; // Update data-size
}

void CXUM32Hash::Final()
{
	m_crc32 = ~m_crc32; // Finalize CRC-32
	m_elf32 %= XUM_ELF_MOD; // XUM-specific ELF transformation

	m_xum32 = (m_xum32 << 16) + (m_xum32 >> 16);

	m_xum32 ^= m_crc32;
	m_xum32 ^= m_elf32;
}
