/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.reader;

import com.sun.msv.datatype.xsd.AnyURIType;
import com.sun.msv.datatype.xsd.BuiltinAtomicType;
import com.sun.msv.datatype.xsd.DurationType;
import com.sun.msv.datatype.xsd.GDayType;
import com.sun.msv.datatype.xsd.GMonthDayType;
import com.sun.msv.datatype.xsd.GMonthType;
import com.sun.msv.datatype.xsd.GYearMonthType;
import com.sun.msv.datatype.xsd.GYearType;
import com.sun.msv.datatype.xsd.NormalizedStringType;
import com.sun.msv.datatype.xsd.NumberType;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.Grammar;
import com.sun.msv.grammar.IDContextProvider;
import com.sun.msv.grammar.ReferenceContainer;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.reader.AbortException;
import com.sun.msv.reader.Controller;
import com.sun.msv.reader.ExpressionState;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.msv.reader.State;
import com.sun.msv.util.StartTagInfo;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.relaxng.datatype.Datatype;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public abstract class GrammarReader
extends XMLFilterImpl
implements IDContextProvider {
    public Locator locator;
    public final Controller controller;
    public final SAXParserFactory parserFactory;
    public final ExpressionPool pool;
    public static final PrefixResolver basePrefixResolver = new PrefixResolver(){

        public String resolve(String string) {
            if (string.equals("xml")) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            return null;
        }
    };
    public PrefixResolver prefixResolver = basePrefixResolver;
    private InclusionContext pendingIncludes;
    private Stack includeStack = new Stack();
    public final BackwardReferenceMap backwardReference = new BackwardReferenceMap();
    private final Map declaredLocations = new HashMap();
    private final Vector backPatchJobs = new Vector();
    public static final String ERR_MALPLACED_ELEMENT = "GrammarReader.MalplacedElement";
    public static final String ERR_CHARACTERS = "GrammarReader.Characters";
    public static final String ERR_DISALLOWED_ATTRIBUTE = "GrammarReader.DisallowedAttribute";
    public static final String ERR_MISSING_ATTRIBUTE = "GrammarReader.MissingAttribute";
    public static final String ERR_BAD_ATTRIBUTE_VALUE = "GrammarReader.BadAttributeValue";
    public static final String ERR_MISSING_ATTRIBUTE_2 = "GrammarReader.MissingAttribute.2";
    public static final String ERR_CONFLICTING_ATTRIBUTES = "GrammarReader.ConflictingAttribute";
    public static final String ERR_RECURSIVE_INCLUDE = "GrammarReader.RecursiveInclude";
    public static final String ERR_FRAGMENT_IDENTIFIER = "GrammarReader.FragmentIdentifier";
    public static final String ERR_UNDEFINED_DATATYPE = "GrammarReader.UndefinedDataType";
    public static final String ERR_DATATYPE_ALREADY_DEFINED = "GrammarReader.DataTypeAlreadyDefined";
    public static final String ERR_MISSING_CHILD_EXPRESSION = "GrammarReader.Abstract.MissingChildExpression";
    public static final String ERR_MORE_THAN_ONE_CHILD_EXPRESSION = "GrammarReader.Abstract.MoreThanOneChildExpression";
    public static final String ERR_MORE_THAN_ONE_CHILD_TYPE = "GrammarReader.Abstract.MoreThanOneChildType";
    public static final String ERR_MISSING_CHILD_TYPE = "GrammarReader.Abstract.MissingChildType";
    public static final String ERR_ILLEGAL_FINAL_VALUE = "GrammarReader.IllegalFinalValue";
    public static final String ERR_RUNAWAY_EXPRESSION = "GrammarReader.Abstract.RunAwayExpression";
    public static final String ERR_MISSING_TOPLEVEL = "GrammarReader.Abstract.MissingTopLevel";
    public static final String WRN_MAYBE_WRONG_NAMESPACE = "GrammarReader.Warning.MaybeWrongNamespace";
    public static final String WRN_DEPRECATED_TYPENAME = "GrammarReader.Warning.DeprecatedTypeName";
    public static final String ERR_BAD_TYPE = "GrammarReader.BadType";
    public static final String ERR_RECURSIVE_DATATYPE = "GrammarReader.RecursiveDatatypeDefinition";

    protected static SAXParserFactory createParserFactory() {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        return sAXParserFactory;
    }

    protected GrammarReader(GrammarReaderController grammarReaderController, SAXParserFactory sAXParserFactory, ExpressionPool expressionPool, State state) {
        this.controller = new Controller(grammarReaderController);
        this.parserFactory = sAXParserFactory;
        if (!sAXParserFactory.isNamespaceAware()) {
            throw new IllegalArgumentException("parser factory must be namespace-aware");
        }
        this.pool = expressionPool;
        this.pushState(state, null, null);
    }

    public abstract Grammar getResultAsGrammar();

    protected abstract boolean isGrammarElement(StartTagInfo var1);

    public void startPrefixMapping(String string, String string2) throws SAXException {
        PrefixResolver prefixResolver = this.prefixResolver;
        this.prefixResolver = new ChainPrefixResolver(string, string2);
        super.startPrefixMapping(string, string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
        this.prefixResolver = ((ChainPrefixResolver)this.prefixResolver).previous;
        super.endPrefixMapping(string);
    }

    public Iterator iterateInscopeNamespaces() {
        return new Iterator(){
            private PrefixResolver resolver;
            {
                this.resolver = this.proceed(GrammarReader.this.prefixResolver);
            }

            public Object next() {
                ChainPrefixResolver chainPrefixResolver = (ChainPrefixResolver)this.resolver;
                this.resolver = this.proceed(chainPrefixResolver.previous);
                return new Map.Entry(this, chainPrefixResolver){
                    private final /* synthetic */ ChainPrefixResolver val$cpr;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$cpr = chainPrefixResolver;
                    }

                    public Object getKey() {
                        return this.val$cpr.prefix;
                    }

                    public Object getValue() {
                        return this.val$cpr.uri;
                    }

                    public Object setValue(Object object) {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public boolean hasNext() {
                return this.resolver instanceof ChainPrefixResolver;
            }

            private PrefixResolver proceed(PrefixResolver prefixResolver) {
                while (prefixResolver instanceof ChainPrefixResolver) {
                    ChainPrefixResolver chainPrefixResolver = (ChainPrefixResolver)prefixResolver;
                    if (GrammarReader.this.resolveNamespacePrefix(chainPrefixResolver.prefix) == chainPrefixResolver.uri) {
                        return prefixResolver;
                    }
                    prefixResolver = chainPrefixResolver.previous;
                }
                return prefixResolver;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String[] splitQName(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            String string2 = this.prefixResolver.resolve("");
            if (string2 == null) {
                string2 = "";
            }
            return new String[]{string2, string, string};
        }
        String string3 = this.prefixResolver.resolve(string.substring(0, n));
        if (string3 == null) {
            return null;
        }
        return new String[]{string3, string.substring(n + 1), string};
    }

    protected Expression interceptExpression(ExpressionState expressionState, Expression expression) {
        return expression;
    }

    public XSDatatype getBackwardCompatibleType(String string) {
        BuiltinAtomicType builtinAtomicType = null;
        if (string.equals("uriReference")) {
            builtinAtomicType = AnyURIType.theInstance;
        } else if (string.equals("number")) {
            builtinAtomicType = NumberType.theInstance;
        } else if (string.equals("timeDuration")) {
            builtinAtomicType = DurationType.theInstance;
        } else if (string.equals("CDATA")) {
            builtinAtomicType = NormalizedStringType.theInstance;
        } else if (string.equals("year")) {
            builtinAtomicType = GYearType.theInstance;
        } else if (string.equals("yearMonth")) {
            builtinAtomicType = GYearMonthType.theInstance;
        } else if (string.equals("month")) {
            builtinAtomicType = GMonthType.theInstance;
        } else if (string.equals("monthDay")) {
            builtinAtomicType = GMonthDayType.theInstance;
        } else if (string.equals("day")) {
            builtinAtomicType = GDayType.theInstance;
        }
        if (builtinAtomicType != null) {
            this.reportWarning(WRN_DEPRECATED_TYPENAME, string, builtinAtomicType.displayName());
        }
        return builtinAtomicType;
    }

    private void pushInclusionContext() {
        this.pendingIncludes = new InclusionContext(this.prefixResolver, this.locator, this.locator.getSystemId(), this.pendingIncludes);
        this.prefixResolver = basePrefixResolver;
        this.locator = null;
    }

    private void popInclusionContext() {
        this.prefixResolver = this.pendingIncludes.prefixResolver;
        this.locator = this.pendingIncludes.locator;
        this.pendingIncludes = this.pendingIncludes.previousContext;
    }

    public final InputSource resolveLocation(State state, String string) throws AbortException {
        try {
            string = this.combineURL(state.getBaseURI(), string);
            InputSource inputSource = this.controller.resolveEntity(null, string);
            if (inputSource == null) {
                return new InputSource(string);
            }
            return inputSource;
        }
        catch (IOException iOException) {
            this.controller.error(iOException, this.locator);
        }
        catch (SAXException sAXException) {
            this.controller.error(sAXException, this.locator);
        }
        throw AbortException.theInstance;
    }

    public final String combineURL(String string, String string2) {
        try {
            return new URL(new URL(string), string2).toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return string2;
        }
    }

    public void switchSource(State state, String string, State state2) throws AbortException {
        if (string.indexOf(35) >= 0) {
            this.reportError(ERR_FRAGMENT_IDENTIFIER, (Object)string);
            throw AbortException.theInstance;
        }
        this.switchSource(this.resolveLocation(state, string), state2);
    }

    public void switchSource(InputSource inputSource, State state) {
        String string = inputSource.getSystemId();
        InclusionContext inclusionContext = this.pendingIncludes;
        while (inclusionContext != null) {
            if (inclusionContext.systemId.equals(string)) {
                String string2 = "";
                InclusionContext inclusionContext2 = this.pendingIncludes;
                while (inclusionContext2 != inclusionContext) {
                    string2 = inclusionContext2.systemId + " > " + string2;
                    inclusionContext2 = inclusionContext2.previousContext;
                }
                string2 = string + " > " + string2 + string;
                this.reportError(ERR_RECURSIVE_INCLUDE, (Object)string2);
                return;
            }
            inclusionContext = inclusionContext.previousContext;
        }
        this.pushInclusionContext();
        State state2 = this.getCurrentState();
        try {
            this.pushState(state, null, null);
            this._parse(inputSource, state2.location);
            Object var8_8 = null;
            super.setContentHandler(state2);
            this.popInclusionContext();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            super.setContentHandler(state2);
            this.popInclusionContext();
            throw throwable;
        }
    }

    public final void parse(String string) {
        this._parse(string, null);
    }

    public final void parse(InputSource inputSource) {
        this._parse(inputSource, null);
    }

    public final void _parse(Object object, Locator locator) {
        try {
            XMLReader xMLReader = this.parserFactory.newSAXParser().getXMLReader();
            xMLReader.setContentHandler(this);
            if (object instanceof InputSource) {
                xMLReader.parse((InputSource)object);
            }
            if (object instanceof String) {
                xMLReader.parse((String)object);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.controller.error(parserConfigurationException, locator);
        }
        catch (IOException iOException) {
            this.controller.error(iOException, locator);
        }
        catch (SAXParseException sAXParseException) {
            this.controller.error(sAXParseException);
        }
        catch (SAXException sAXException) {
            this.controller.error(sAXException, locator);
        }
    }

    public void setDeclaredLocationOf(Object object) {
        this.declaredLocations.put(object, new LocatorImpl(this.locator));
    }

    public Locator getDeclaredLocationOf(Object object) {
        return (Locator)this.declaredLocations.get(object);
    }

    public void detectUndefinedOnes(ReferenceContainer referenceContainer, String string) {
        Iterator iterator = referenceContainer.iterator();
        while (iterator.hasNext()) {
            ReferenceExp referenceExp = (ReferenceExp)iterator.next();
            if (referenceExp.isDefined()) continue;
            this.reportError(this.backwardReference.getReferer(referenceExp), string, new Object[]{referenceExp.name});
            referenceExp.exp = Expression.nullSet;
        }
    }

    public void pushState(State state, State state2, StartTagInfo startTagInfo) {
        super.setContentHandler(state);
        state.init(this, state2, startTagInfo);
    }

    public void popState() {
        State state = this.getCurrentState();
        if (state.parentState != null) {
            super.setContentHandler(state.parentState);
        } else {
            super.setContentHandler(new DefaultHandler());
        }
    }

    public final State getCurrentState() {
        return (State)super.getContentHandler();
    }

    public abstract State createExpressionChildState(State var1, StartTagInfo var2);

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }

    public String resolveNamespacePrefix(String string) {
        return this.prefixResolver.resolve(string);
    }

    public boolean isUnparsedEntity(String string) {
        return true;
    }

    public boolean isNotation(String string) {
        return true;
    }

    public String getBaseUri() {
        return this.getCurrentState().getBaseURI();
    }

    public void onID(Datatype datatype, String string) {
    }

    public final void addBackPatchJob(BackPatch backPatch) {
        this.backPatchJobs.add(backPatch);
    }

    public final void runBackPatchJob() {
        Locator locator = this.locator;
        Iterator iterator = ((AbstractList)this.backPatchJobs).iterator();
        while (iterator.hasNext()) {
            BackPatch backPatch = (BackPatch)iterator.next();
            this.locator = backPatch.getOwnerState().getLocation();
            backPatch.patch();
        }
        this.locator = locator;
    }

    public final void reportError(String string) {
        this.reportError(string, null, null, null);
    }

    public final void reportError(String string, Object object) {
        this.reportError(string, new Object[]{object}, null, null);
    }

    public final void reportError(String string, Object object, Object object2) {
        this.reportError(string, new Object[]{object, object2}, null, null);
    }

    public final void reportError(String string, Object object, Object object2, Object object3) {
        this.reportError(string, new Object[]{object, object2, object3}, null, null);
    }

    public final void reportError(Exception exception, String string) {
        this.reportError(string, null, exception, null);
    }

    public final void reportError(Exception exception, String string, Object object) {
        this.reportError(string, new Object[]{object}, exception, null);
    }

    public final void reportError(Locator[] locatorArray, String string, Object[] objectArray) {
        this.reportError(string, objectArray, null, locatorArray);
    }

    public final void reportWarning(String string) {
        this.reportWarning(string, null, null);
    }

    public final void reportWarning(String string, Object object) {
        this.reportWarning(string, new Object[]{object}, null);
    }

    public final void reportWarning(String string, Object object, Object object2) {
        this.reportWarning(string, new Object[]{object, object2}, null);
    }

    private Locator[] prepareLocation(Locator[] locatorArray) {
        if (locatorArray != null) {
            int n = 0;
            int n2 = 0;
            while (n2 < locatorArray.length) {
                if (locatorArray[n2] != null) {
                    ++n;
                }
                ++n2;
            }
            if (locatorArray.length == n) {
                return locatorArray;
            }
            Locator[] locatorArray2 = new Locator[n];
            n = 0;
            int n3 = 0;
            while (n3 < locatorArray.length) {
                if (locatorArray[n3] != null) {
                    locatorArray2[n++] = locatorArray[n3];
                }
                ++n3;
            }
            return locatorArray2;
        }
        if (this.locator != null) {
            return new Locator[]{this.locator};
        }
        return new Locator[0];
    }

    public final void reportError(String string, Object[] objectArray, Exception exception, Locator[] locatorArray) {
        this.controller.error(this.prepareLocation(locatorArray), this.localizeMessage(string, objectArray), exception);
    }

    public final void reportWarning(String string, Object[] objectArray, Locator[] locatorArray) {
        this.controller.warning(this.prepareLocation(locatorArray), this.localizeMessage(string, objectArray));
    }

    protected abstract String localizeMessage(String var1, Object[] var2);

    public static interface BackPatch {
        public void patch();

        public State getOwnerState();
    }

    public class BackwardReferenceMap {
        private final Map impl = new HashMap();

        public void memorizeLink(Object object) {
            ArrayList arrayList;
            if (this.impl.containsKey(object)) {
                arrayList = (ArrayList)this.impl.get(object);
            } else {
                arrayList = new ArrayList();
                this.impl.put(object, arrayList);
            }
            arrayList.add(new LocatorImpl(GrammarReader.this.locator));
        }

        public Locator[] getReferer(Object object) {
            if (this.impl.containsKey(object)) {
                ArrayList arrayList = (ArrayList)this.impl.get(object);
                Locator[] locatorArray = new Locator[arrayList.size()];
                arrayList.toArray(locatorArray);
                return locatorArray;
            }
            return null;
        }
    }

    private class InclusionContext {
        final PrefixResolver prefixResolver;
        final Locator locator;
        final String systemId;
        final InclusionContext previousContext;

        InclusionContext(PrefixResolver prefixResolver, Locator locator, String string, InclusionContext inclusionContext) {
            this.prefixResolver = prefixResolver;
            this.locator = locator;
            this.systemId = string;
            this.previousContext = inclusionContext;
        }
    }

    public class ChainPrefixResolver
    implements PrefixResolver {
        public final PrefixResolver previous;
        public final String prefix;
        public final String uri;

        public ChainPrefixResolver(String string, String string2) {
            this.prefix = string;
            this.uri = string2;
            this.previous = GrammarReader.this.prefixResolver;
        }

        public String resolve(String string) {
            if (string.equals(this.prefix)) {
                return this.uri;
            }
            return this.previous.resolve(string);
        }
    }

    public static interface PrefixResolver {
        public String resolve(String var1);
    }
}

