/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.reader.relax;

import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.reader.ChoiceState;
import com.sun.msv.reader.ExpressionState;
import com.sun.msv.reader.GrammarReader;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.msv.reader.SequenceState;
import com.sun.msv.reader.State;
import com.sun.msv.reader.TerminalState;
import com.sun.msv.reader.datatype.xsd.FacetState;
import com.sun.msv.reader.relax.ElementRefState;
import com.sun.msv.reader.relax.HedgeRefState;
import com.sun.msv.util.StartTagInfo;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.xml.parsers.SAXParserFactory;

public abstract class RELAXReader
extends GrammarReader {
    public static final String RELAXCoreNamespace = "http://www.xml.gr.jp/xmlns/relaxCore";
    public final StateFactory sfactory;
    public static final String ERR_ILLEGAL_OCCURS = "RELAXReader.IllegalOccurs";
    public static final String ERR_MISPLACED_OCCURS = "RELAXReader.MisplacedOccurs";

    public RELAXReader(GrammarReaderController grammarReaderController, SAXParserFactory sAXParserFactory, StateFactory stateFactory, ExpressionPool expressionPool, State state) {
        super(grammarReaderController, sAXParserFactory, expressionPool, state);
        this.sfactory = stateFactory;
    }

    public State createExpressionChildState(State state, StartTagInfo startTagInfo) {
        if (startTagInfo.localName.equals("ref")) {
            return this.sfactory.refLabel(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("hedgeRef")) {
            return this.sfactory.hedgeRef(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("choice")) {
            return this.sfactory.choice(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("none")) {
            return this.sfactory.none(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("empty")) {
            return this.sfactory.empty(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("sequence")) {
            return this.sfactory.sequence(state, startTagInfo);
        }
        return null;
    }

    public FacetState createFacetState(State state, StartTagInfo startTagInfo) {
        if (!RELAXCoreNamespace.equals(startTagInfo.namespaceURI)) {
            return null;
        }
        if (FacetState.facetNames.contains(startTagInfo.localName)) {
            return this.sfactory.facets(state, startTagInfo);
        }
        return null;
    }

    protected boolean canHaveOccurs(ExpressionState expressionState) {
        return expressionState instanceof SequenceState || expressionState instanceof ElementRefState || expressionState instanceof HedgeRefState || expressionState instanceof ChoiceState;
    }

    protected Expression interceptExpression(ExpressionState expressionState, Expression expression) {
        String string = expressionState.getStartTag().getAttribute("occurs");
        if (this.canHaveOccurs(expressionState)) {
            if (string != null) {
                if (string.equals("?")) {
                    expression = this.pool.createOptional(expression);
                } else if (string.equals("+")) {
                    expression = this.pool.createOneOrMore(expression);
                } else if (string.equals("*")) {
                    expression = this.pool.createZeroOrMore(expression);
                } else {
                    this.reportError(ERR_ILLEGAL_OCCURS, (Object)string);
                }
            }
        } else if (string != null) {
            this.reportError(ERR_MISPLACED_OCCURS, (Object)expressionState.getStartTag().localName);
        }
        return expression;
    }

    protected abstract Expression resolveElementRef(String var1, String var2);

    protected abstract Expression resolveHedgeRef(String var1, String var2);

    protected String localizeMessage(String string, Object[] objectArray) {
        String string2;
        try {
            string2 = ResourceBundle.getBundle("com.sun.msv.reader.relax.Messages").getString(string);
        }
        catch (Exception exception) {
            string2 = ResourceBundle.getBundle("com.sun.msv.reader.Messages").getString(string);
        }
        return MessageFormat.format(string2, objectArray);
    }

    protected ExpressionPool getPool() {
        return this.pool;
    }

    public static class StateFactory {
        protected State refLabel(State state, StartTagInfo startTagInfo) {
            return new ElementRefState();
        }

        protected State hedgeRef(State state, StartTagInfo startTagInfo) {
            return new HedgeRefState();
        }

        protected State choice(State state, StartTagInfo startTagInfo) {
            return new ChoiceState();
        }

        protected State none(State state, StartTagInfo startTagInfo) {
            return new TerminalState(Expression.nullSet);
        }

        protected State empty(State state, StartTagInfo startTagInfo) {
            return new TerminalState(Expression.epsilon);
        }

        protected State sequence(State state, StartTagInfo startTagInfo) {
            return new SequenceState();
        }

        protected FacetState facets(State state, StartTagInfo startTagInfo) {
            return new FacetState();
        }
    }
}

