/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.reader.util;

import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.Grammar;
import com.sun.msv.grammar.xmlschema.XMLSchemaGrammar;
import com.sun.msv.reader.Controller;
import com.sun.msv.reader.GrammarReader;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.msv.reader.dtd.DTDReader;
import com.sun.msv.reader.relax.core.RELAXCoreReader;
import com.sun.msv.reader.trex.classic.TREXGrammarReader;
import com.sun.msv.reader.trex.ng.RELAXNGReader;
import com.sun.msv.reader.trex.ng.comp.RELAXNGCompReader;
import com.sun.msv.reader.xmlschema.XMLSchemaReader;
import com.sun.msv.relaxns.reader.RELAXNSReader;
import com.sun.msv.util.Util;
import com.sun.msv.verifier.jaxp.SAXParserFactoryImpl;
import com.sun.msv.verifier.regexp.REDocumentDeclaration;
import com.sun.msv.verifier.regexp.xmlschema.XSREDocDecl;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.Verifier;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.VerifierFilter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class GrammarLoader {
    private SAXParserFactory factory;
    private Controller controller;
    private ExpressionPool pool;
    private boolean strictCheck = false;

    public static REDocumentDeclaration loadVGM(String string, GrammarReaderController grammarReaderController, SAXParserFactory sAXParserFactory) throws SAXException, ParserConfigurationException, IOException {
        Grammar grammar = GrammarLoader.loadSchema(string, grammarReaderController, sAXParserFactory);
        if (grammar != null) {
            return GrammarLoader.wrapByVGM(grammar);
        }
        return null;
    }

    public static REDocumentDeclaration loadVGM(InputSource inputSource, GrammarReaderController grammarReaderController, SAXParserFactory sAXParserFactory) throws SAXException, ParserConfigurationException, IOException {
        Grammar grammar = GrammarLoader.loadSchema(inputSource, grammarReaderController, sAXParserFactory);
        if (grammar != null) {
            return GrammarLoader.wrapByVGM(grammar);
        }
        return null;
    }

    private static REDocumentDeclaration wrapByVGM(Grammar grammar) {
        if (grammar instanceof XMLSchemaGrammar) {
            return new XSREDocDecl((XMLSchemaGrammar)grammar);
        }
        return new REDocumentDeclaration(grammar);
    }

    public static REDocumentDeclaration loadVGM(String string) throws SAXException, ParserConfigurationException, IOException {
        try {
            return GrammarLoader.loadVGM(string, (GrammarReaderController)new ThrowController(), null);
        }
        catch (GrammarLoaderException grammarLoaderException) {
            throw grammarLoaderException.e;
        }
    }

    public static REDocumentDeclaration loadVGM(InputSource inputSource) throws SAXException, ParserConfigurationException, IOException {
        try {
            return GrammarLoader.loadVGM(inputSource, (GrammarReaderController)new ThrowController(), null);
        }
        catch (GrammarLoaderException grammarLoaderException) {
            throw grammarLoaderException.e;
        }
    }

    public static Grammar loadSchema(String string, GrammarReaderController grammarReaderController, SAXParserFactory sAXParserFactory) throws SAXException, ParserConfigurationException, IOException {
        GrammarLoader grammarLoader = new GrammarLoader();
        grammarLoader.setController(grammarReaderController);
        grammarLoader.setSAXParserFactory(sAXParserFactory);
        return grammarLoader.parse(string);
    }

    public static Grammar loadSchema(InputSource inputSource, GrammarReaderController grammarReaderController, SAXParserFactory sAXParserFactory) throws SAXException, ParserConfigurationException, IOException {
        GrammarLoader grammarLoader = new GrammarLoader();
        grammarLoader.setController(grammarReaderController);
        grammarLoader.setSAXParserFactory(sAXParserFactory);
        return grammarLoader.parse(inputSource);
    }

    public static Grammar loadSchema(String string, GrammarReaderController grammarReaderController) throws SAXException, ParserConfigurationException, IOException {
        GrammarLoader grammarLoader = new GrammarLoader();
        grammarLoader.setController(grammarReaderController);
        return grammarLoader.parse(string);
    }

    public static Grammar loadSchema(InputSource inputSource, GrammarReaderController grammarReaderController) throws SAXException, ParserConfigurationException, IOException {
        GrammarLoader grammarLoader = new GrammarLoader();
        grammarLoader.setController(grammarReaderController);
        return grammarLoader.parse(inputSource);
    }

    public static Grammar loadSchema(String string) throws SAXException, ParserConfigurationException, IOException {
        try {
            return GrammarLoader.loadSchema(string, (GrammarReaderController)new ThrowController(), null);
        }
        catch (GrammarLoaderException grammarLoaderException) {
            throw grammarLoaderException.e;
        }
    }

    public static Grammar loadSchema(InputSource inputSource) throws SAXException, ParserConfigurationException, IOException {
        try {
            return GrammarLoader.loadSchema(inputSource, (GrammarReaderController)new ThrowController(), null);
        }
        catch (GrammarLoaderException grammarLoaderException) {
            throw grammarLoaderException.e;
        }
    }

    public void setSAXParserFactory(SAXParserFactory sAXParserFactory) {
        this.factory = sAXParserFactory;
    }

    public SAXParserFactory getSAXParserFactory() {
        if (this.factory == null) {
            this.factory = SAXParserFactory.newInstance();
            this.factory.setNamespaceAware(true);
        }
        return this.factory;
    }

    public void setController(GrammarReaderController grammarReaderController) {
        this.controller = new Controller(grammarReaderController);
    }

    public Controller getController() {
        if (this.controller == null) {
            this.controller = new Controller(new GrammarReaderController(){

                public void warning(Locator[] locatorArray, String string) {
                }

                public void error(Locator[] locatorArray, String string, Exception exception) {
                }

                public InputSource resolveEntity(String string, String string2) {
                    return null;
                }
            });
        }
        return this.controller;
    }

    public void setPool(ExpressionPool expressionPool) {
        this.pool = expressionPool;
    }

    public ExpressionPool getPool() {
        if (this.pool == null) {
            return new ExpressionPool();
        }
        return this.pool;
    }

    public void setStrictCheck(boolean bl) {
        this.strictCheck = bl;
    }

    public boolean getStrictCheck() {
        return this.strictCheck;
    }

    public Grammar parse(InputSource inputSource) throws SAXException, ParserConfigurationException, IOException {
        return this._loadSchema(inputSource);
    }

    public Grammar parse(String string) throws SAXException, ParserConfigurationException, IOException {
        return this._loadSchema(string);
    }

    public REDocumentDeclaration parseVGM(String string) throws SAXException, ParserConfigurationException, IOException {
        Grammar grammar = this._loadSchema(string);
        if (grammar == null) {
            return null;
        }
        return new REDocumentDeclaration(grammar);
    }

    public REDocumentDeclaration parseVGM(InputSource inputSource) throws SAXException, ParserConfigurationException, IOException {
        Grammar grammar = this._loadSchema(inputSource);
        if (grammar == null) {
            return null;
        }
        return new REDocumentDeclaration(grammar);
    }

    private boolean hasDTDextension(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length() - 4;
        if (n < 0) {
            return false;
        }
        return string.substring(n).equalsIgnoreCase(".dtd");
    }

    private Grammar _loadSchema(Object object) throws SAXException, ParserConfigurationException, IOException {
        boolean bl = false;
        if (object instanceof String && this.hasDTDextension((String)object)) {
            bl = true;
        }
        if (object instanceof InputSource && this.hasDTDextension(((InputSource)object).getSystemId())) {
            bl = true;
        }
        if (bl) {
            if (object instanceof String) {
                object = Util.getInputSource((String)object);
            }
            return DTDReader.parse((InputSource)object, this.getController());
        }
        final GrammarReader[] grammarReaderArray = new GrammarReader[1];
        final XMLReader xMLReader = this.getSAXParserFactory().newSAXParser().getXMLReader();
        xMLReader.setContentHandler(new DefaultHandler(){
            private Locator locator;
            private Vector prefixes = new Vector();

            public void setDocumentLocator(Locator locator) {
                this.locator = locator;
            }

            public void startPrefixMapping(String string, String string2) {
                this.prefixes.add(new String[]{string, string2});
            }

            private ContentHandler setupPipeline(Schema schema) throws SAXException {
                try {
                    Verifier verifier = schema.newVerifier();
                    verifier.setErrorHandler((ErrorHandler)GrammarLoader.this.getController());
                    VerifierFilter verifierFilter = verifier.getVerifierFilter();
                    verifierFilter.setContentHandler(grammarReaderArray[0]);
                    return (ContentHandler)verifierFilter;
                }
                catch (VerifierConfigurationException verifierConfigurationException) {
                    throw new SAXException((Exception)((Object)verifierConfigurationException));
                }
            }

            public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                ContentHandler contentHandler;
                Schema schema;
                if (string2.equals("module")) {
                    if (GrammarLoader.this.strictCheck) {
                        schema = RELAXCoreReader.getRELAXCoreSchema4Schema();
                        grammarReaderArray[0] = new RELAXCoreReader(GrammarLoader.this.getController(), new SAXParserFactoryImpl(GrammarLoader.this.getSAXParserFactory(), schema), GrammarLoader.this.getPool());
                        contentHandler = this.setupPipeline(schema);
                    } else {
                        grammarReaderArray[0] = new RELAXCoreReader(GrammarLoader.this.getController(), GrammarLoader.this.getSAXParserFactory(), GrammarLoader.this.getPool());
                        contentHandler = grammarReaderArray[0];
                    }
                } else if (string2.equals("schema")) {
                    if (GrammarLoader.this.strictCheck) {
                        schema = XMLSchemaReader.getXmlSchemaForXmlSchema();
                        grammarReaderArray[0] = new XMLSchemaReader(GrammarLoader.this.getController(), new SAXParserFactoryImpl(GrammarLoader.this.getSAXParserFactory(), schema), GrammarLoader.this.getPool());
                        contentHandler = this.setupPipeline(schema);
                    } else {
                        grammarReaderArray[0] = new XMLSchemaReader(GrammarLoader.this.getController(), GrammarLoader.this.getSAXParserFactory(), GrammarLoader.this.getPool());
                        contentHandler = grammarReaderArray[0];
                    }
                } else if ("http://www.xml.gr.jp/xmlns/relaxNamespace".equals(string)) {
                    grammarReaderArray[0] = new RELAXNSReader(GrammarLoader.this.getController(), GrammarLoader.this.getSAXParserFactory(), GrammarLoader.this.getPool());
                    contentHandler = grammarReaderArray[0];
                } else if ("http://www.thaiopensource.com/trex".equals(string) || string.equals("")) {
                    grammarReaderArray[0] = new TREXGrammarReader(GrammarLoader.this.getController(), GrammarLoader.this.getSAXParserFactory(), GrammarLoader.this.getPool());
                    contentHandler = grammarReaderArray[0];
                } else if (GrammarLoader.this.strictCheck) {
                    schema = RELAXNGReader.getRELAXNGSchema4Schema();
                    grammarReaderArray[0] = new RELAXNGCompReader(GrammarLoader.this.getController(), new SAXParserFactoryImpl(GrammarLoader.this.getSAXParserFactory(), schema), GrammarLoader.this.getPool());
                    contentHandler = this.setupPipeline(schema);
                } else {
                    grammarReaderArray[0] = new RELAXNGCompReader(GrammarLoader.this.getController(), GrammarLoader.this.getSAXParserFactory(), GrammarLoader.this.getPool());
                    contentHandler = grammarReaderArray[0];
                }
                contentHandler.setDocumentLocator(this.locator);
                contentHandler.startDocument();
                int n = 0;
                while (n < this.prefixes.size()) {
                    String[] stringArray = (String[])this.prefixes.get(n);
                    contentHandler.startPrefixMapping(stringArray[0], stringArray[1]);
                    ++n;
                }
                contentHandler.startElement(string, string2, string3, attributes);
                xMLReader.setContentHandler(contentHandler);
            }
        });
        xMLReader.setErrorHandler(this.getController());
        if (object instanceof String) {
            xMLReader.parse((String)object);
        } else {
            xMLReader.parse((InputSource)object);
        }
        if (this.getController().hadError()) {
            return null;
        }
        return grammarReaderArray[0].getResultAsGrammar();
    }

    private static class ThrowController
    implements GrammarReaderController {
        private ThrowController() {
        }

        public void warning(Locator[] locatorArray, String string) {
        }

        public void error(Locator[] locatorArray, String string, Exception exception) {
            int n = 0;
            while (n < locatorArray.length) {
                if (locatorArray[n] != null) {
                    throw new GrammarLoaderException(new SAXParseException(string, locatorArray[n], exception));
                }
                ++n;
            }
            throw new GrammarLoaderException(new SAXException(string, exception));
        }

        public InputSource resolveEntity(String string, String string2) {
            return null;
        }
    }

    private static class GrammarLoaderException
    extends RuntimeException {
        public final SAXException e;

        GrammarLoaderException(SAXException sAXException) {
            super(sAXException.getMessage());
            this.e = sAXException;
        }
    }
}

