/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.writer.relaxng;

import com.sun.msv.datatype.SerializationContext;
import com.sun.msv.datatype.xsd.ConcreteType;
import com.sun.msv.datatype.xsd.DataTypeWithFacet;
import com.sun.msv.datatype.xsd.EnumerationFacet;
import com.sun.msv.datatype.xsd.FinalComponent;
import com.sun.msv.datatype.xsd.FractionDigitsFacet;
import com.sun.msv.datatype.xsd.LengthFacet;
import com.sun.msv.datatype.xsd.ListType;
import com.sun.msv.datatype.xsd.MaxLengthFacet;
import com.sun.msv.datatype.xsd.MinLengthFacet;
import com.sun.msv.datatype.xsd.PatternFacet;
import com.sun.msv.datatype.xsd.RangeFacet;
import com.sun.msv.datatype.xsd.TokenType;
import com.sun.msv.datatype.xsd.TotalDigitsFacet;
import com.sun.msv.datatype.xsd.UnionType;
import com.sun.msv.datatype.xsd.WhiteSpaceFacet;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.datatype.xsd.XSDatatypeImpl;
import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.BinaryExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.ConcurExp;
import com.sun.msv.grammar.DataExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionVisitorVoid;
import com.sun.msv.grammar.InterleaveExp;
import com.sun.msv.grammar.ListExp;
import com.sun.msv.grammar.MixedExp;
import com.sun.msv.grammar.OneOrMoreExp;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.SequenceExp;
import com.sun.msv.grammar.ValueExp;
import com.sun.msv.grammar.relax.EmptyStringType;
import com.sun.msv.grammar.relax.NoneType;
import com.sun.msv.writer.XMLWriter;
import com.sun.msv.writer.relaxng.Context;
import java.util.HashSet;
import java.util.Vector;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.ValidationContext;

public abstract class PatternWriter
implements ExpressionVisitorVoid {
    protected final XMLWriter writer;
    protected final Context context;
    static /* synthetic */ Class class$com$sun$msv$grammar$InterleaveExp;
    static /* synthetic */ Class class$com$sun$msv$grammar$ChoiceExp;
    static /* synthetic */ Class class$com$sun$msv$grammar$SequenceExp;

    public PatternWriter(Context context) {
        this.writer = context.getWriter();
        this.context = context;
    }

    public abstract void onOther(OtherExp var1);

    public abstract void onRef(ReferenceExp var1);

    public void onElement(ElementExp elementExp) {
        this.writer.start("element");
        this.context.writeNameClass(elementExp.getNameClass());
        this.visitUnary(elementExp.contentModel);
        this.writer.end("element");
    }

    public void onEpsilon() {
        this.writer.element("empty");
    }

    public void onNullSet() {
        this.writer.element("notAllowed");
    }

    public void onAnyString() {
        this.writer.element("text");
    }

    public void onInterleave(InterleaveExp interleaveExp) {
        this.visitBinExp("interleave", interleaveExp, class$com$sun$msv$grammar$InterleaveExp == null ? (class$com$sun$msv$grammar$InterleaveExp = PatternWriter.class$("com.sun.msv.grammar.InterleaveExp")) : class$com$sun$msv$grammar$InterleaveExp);
    }

    public void onConcur(ConcurExp concurExp) {
        throw new IllegalArgumentException("the grammar includes concur, which is not supported");
    }

    public void onList(ListExp listExp) {
        this.writer.start("list");
        this.visitUnary(listExp.exp);
        this.writer.end("list");
    }

    protected void onOptional(Expression expression) {
        if (expression instanceof OneOrMoreExp) {
            this.onZeroOrMore((OneOrMoreExp)expression);
            return;
        }
        this.writer.start("optional");
        this.visitUnary(expression);
        this.writer.end("optional");
    }

    public void onChoice(ChoiceExp choiceExp) {
        if (choiceExp.exp1 == Expression.epsilon) {
            this.onOptional(choiceExp.exp2);
            return;
        }
        if (choiceExp.exp2 == Expression.epsilon) {
            this.onOptional(choiceExp.exp1);
            return;
        }
        this.visitBinExp("choice", choiceExp, class$com$sun$msv$grammar$ChoiceExp == null ? (class$com$sun$msv$grammar$ChoiceExp = PatternWriter.class$("com.sun.msv.grammar.ChoiceExp")) : class$com$sun$msv$grammar$ChoiceExp);
    }

    public void onSequence(SequenceExp sequenceExp) {
        this.visitBinExp("group", sequenceExp, class$com$sun$msv$grammar$SequenceExp == null ? (class$com$sun$msv$grammar$SequenceExp = PatternWriter.class$("com.sun.msv.grammar.SequenceExp")) : class$com$sun$msv$grammar$SequenceExp);
    }

    public void visitBinExp(String string, BinaryExp binaryExp, Class clazz) {
        this.writer.start(string);
        Expression[] expressionArray = binaryExp.getChildren();
        int n = 0;
        while (n < expressionArray.length) {
            expressionArray[n].visit(this);
            ++n;
        }
        this.writer.end(string);
    }

    public void onMixed(MixedExp mixedExp) {
        this.writer.start("mixed");
        this.visitUnary(mixedExp.exp);
        this.writer.end("mixed");
    }

    public void onOneOrMore(OneOrMoreExp oneOrMoreExp) {
        this.writer.start("oneOrMore");
        this.visitUnary(oneOrMoreExp.exp);
        this.writer.end("oneOrMore");
    }

    protected void onZeroOrMore(OneOrMoreExp oneOrMoreExp) {
        this.writer.start("zeroOrMore");
        this.visitUnary(oneOrMoreExp.exp);
        this.writer.end("zeroOrMore");
    }

    public void onAttribute(AttributeExp attributeExp) {
        this.writer.start("attribute");
        this.context.writeNameClass(attributeExp.nameClass);
        this.visitUnary(attributeExp.exp);
        this.writer.end("attribute");
    }

    public void visitUnary(Expression expression) {
        if (expression instanceof SequenceExp) {
            SequenceExp sequenceExp = (SequenceExp)expression;
            this.visitUnary(sequenceExp.exp1);
            sequenceExp.exp2.visit(this);
        } else {
            expression.visit(this);
        }
    }

    public void onValue(ValueExp valueExp) {
        if (valueExp.dt instanceof XSDatatypeImpl) {
            XSDatatypeImpl xSDatatypeImpl = (XSDatatypeImpl)valueExp.dt;
            final Vector<String> vector = new Vector<String>();
            String string = xSDatatypeImpl.convertToLexicalValue(valueExp.value, new SerializationContext(){

                public String getNamespacePrefix(String string) {
                    int n = vector.size() / 2;
                    vector.add("xmlns:ns" + n);
                    vector.add(string);
                    return "ns" + n;
                }
            });
            if (xSDatatypeImpl != TokenType.theInstance) {
                vector.add("type");
                vector.add(xSDatatypeImpl.getName());
            }
            this.writer.start("value", vector.toArray(new String[0]));
            this.writer.characters(string);
            this.writer.end("value");
            return;
        }
        throw new UnsupportedOperationException(valueExp.dt.getClass().getName());
    }

    public void onData(DataExp dataExp) {
        Datatype datatype = dataExp.dt;
        if (datatype instanceof XSDatatypeImpl) {
            XSDatatypeImpl xSDatatypeImpl = (XSDatatypeImpl)datatype;
            if (this.isPredefinedType(datatype)) {
                this.writer.element("data", new String[]{"type", xSDatatypeImpl.getName()});
            } else {
                this.serializeDataType(xSDatatypeImpl);
            }
            return;
        }
        this.writer.element("data-unknown", new String[]{"class", datatype.getClass().getName()});
    }

    protected void serializeDataType(XSDatatype xSDatatype) {
        Object object;
        if (xSDatatype instanceof UnionType) {
            this.serializeUnionType((UnionType)xSDatatype);
            return;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        Vector<XSDatatype> vector = new Vector<XSDatatype>();
        XSDatatype xSDatatype2 = xSDatatype;
        while (xSDatatype2 instanceof DataTypeWithFacet || xSDatatype2 instanceof FinalComponent) {
            if (xSDatatype2 instanceof FinalComponent) {
                xSDatatype2 = xSDatatype2.getBaseType();
                continue;
            }
            object = ((DataTypeWithFacet)xSDatatype2).facetName;
            if (((String)object).equals("enumeration")) {
                this.serializeEnumeration((XSDatatypeImpl)xSDatatype, (EnumerationFacet)xSDatatype2);
                return;
            }
            if (((String)object).equals("whiteSpace")) {
                throw new UnsupportedOperationException("whiteSpace facet is not supported");
            }
            if (!hashSet.contains(object) || hashSet.equals("pattern")) {
                hashSet.add(object);
                vector.add(xSDatatype2);
            }
            xSDatatype2 = ((DataTypeWithFacet)xSDatatype2).baseType;
        }
        if (xSDatatype2 instanceof ListType) {
            this.serializeListType((XSDatatypeImpl)xSDatatype);
            return;
        }
        if (!(xSDatatype2 instanceof ConcreteType)) {
            throw new Error(xSDatatype2.getClass().getName());
        }
        if (xSDatatype2 instanceof EmptyStringType) {
            this.writer.element("value");
            return;
        }
        if (xSDatatype2 instanceof NoneType) {
            this.writer.element("notAllowed");
            return;
        }
        object = new Vector();
        this.writer.start("data", new String[]{"type", xSDatatype2.getName()});
        int n = vector.size() - 1;
        while (n >= 0) {
            DataTypeWithFacet dataTypeWithFacet = (DataTypeWithFacet)vector.get(n);
            if (dataTypeWithFacet instanceof LengthFacet) {
                this.param("length", Long.toString(((LengthFacet)dataTypeWithFacet).length));
            } else if (dataTypeWithFacet instanceof MinLengthFacet) {
                this.param("minLength", Long.toString(((MinLengthFacet)dataTypeWithFacet).minLength));
            } else if (dataTypeWithFacet instanceof MaxLengthFacet) {
                this.param("maxLength", Long.toString(((MaxLengthFacet)dataTypeWithFacet).maxLength));
            } else if (dataTypeWithFacet instanceof PatternFacet) {
                String string = "";
                PatternFacet patternFacet = (PatternFacet)dataTypeWithFacet;
                int n2 = 0;
                while (n2 < patternFacet.exps.length) {
                    if (string.length() != 0) {
                        string = string + "|";
                    }
                    string = string + patternFacet.patterns[n2];
                    ++n2;
                }
                this.param("pattern", string);
            } else if (dataTypeWithFacet instanceof TotalDigitsFacet) {
                this.param("totalDigits", Long.toString(((TotalDigitsFacet)dataTypeWithFacet).precision));
            } else if (dataTypeWithFacet instanceof FractionDigitsFacet) {
                this.param("fractionDigits", Long.toString(((FractionDigitsFacet)dataTypeWithFacet).scale));
            } else if (dataTypeWithFacet instanceof RangeFacet) {
                this.param(dataTypeWithFacet.facetName, dataTypeWithFacet.convertToLexicalValue(((RangeFacet)dataTypeWithFacet).limitValue, null));
            } else if (!(dataTypeWithFacet instanceof WhiteSpaceFacet)) {
                throw new Error();
            }
            --n;
        }
        this.writer.end("data");
    }

    protected void param(String string, String string2) {
        this.writer.start("param", new String[]{"name", string});
        this.writer.characters(string2);
        this.writer.end("param");
    }

    protected boolean isPredefinedType(Datatype datatype) {
        return !(datatype instanceof DataTypeWithFacet) && !(datatype instanceof UnionType) && !(datatype instanceof ListType) && !(datatype instanceof FinalComponent) && !(datatype instanceof EmptyStringType) && !(datatype instanceof NoneType);
    }

    protected void serializeUnionType(UnionType unionType) {
        this.writer.start("choice");
        int n = 0;
        while (n < unionType.memberTypes.length) {
            this.serializeDataType(unionType.memberTypes[n]);
            ++n;
        }
        this.writer.end("choice");
    }

    protected void serializeListType(XSDatatypeImpl xSDatatypeImpl) {
        ListType listType = (ListType)xSDatatypeImpl.getConcreteType();
        if (xSDatatypeImpl.getFacetObject("length") != null) {
            int n = ((LengthFacet)xSDatatypeImpl.getFacetObject((String)"length")).length;
            this.writer.start("list");
            int n2 = 0;
            while (n2 < n) {
                this.serializeDataType(listType.itemType);
                ++n2;
            }
            this.writer.end("list");
            return;
        }
        if (xSDatatypeImpl.getFacetObject("maxLength") != null) {
            throw new UnsupportedOperationException("warning: maxLength facet to list type is not properly converted.");
        }
        MinLengthFacet minLengthFacet = (MinLengthFacet)xSDatatypeImpl.getFacetObject("minLength");
        this.writer.start("list");
        if (minLengthFacet != null) {
            int n = 0;
            while (n < minLengthFacet.minLength) {
                this.serializeDataType(listType.itemType);
                ++n;
            }
        }
        this.writer.start("zeroOrMore");
        this.serializeDataType(listType.itemType);
        this.writer.end("zeroOrMore");
        this.writer.end("list");
    }

    protected void serializeEnumeration(XSDatatypeImpl xSDatatypeImpl, EnumerationFacet enumerationFacet) {
        Object[] objectArray = enumerationFacet.values.toArray();
        if (objectArray.length > 1) {
            this.writer.start("choice");
        }
        int n = 0;
        while (n < objectArray.length) {
            final Vector<String> vector = new Vector<String>();
            String string = xSDatatypeImpl.convertToLexicalValue(objectArray[n], new SerializationContext(){

                public String getNamespacePrefix(String string) {
                    int n = vector.size() / 2;
                    vector.add("xmlns:ns" + n);
                    vector.add(string);
                    return "ns" + n;
                }
            });
            boolean bl = xSDatatypeImpl.isValid(string, new ValidationContext(){

                public String resolveNamespacePrefix(String string) {
                    if (!string.startsWith("ns")) {
                        return null;
                    }
                    int n = Integer.parseInt(string.substring(2));
                    return (String)vector.get(n * 2 + 1);
                }

                public boolean isUnparsedEntity(String string) {
                    return true;
                }

                public boolean isNotation(String string) {
                    return true;
                }

                public String getBaseUri() {
                    return null;
                }
            });
            vector.add("type");
            vector.add(xSDatatypeImpl.getConcreteType().getName());
            if (bl) {
                this.writer.start("value", vector.toArray(new String[0]));
                this.writer.characters(string);
                this.writer.end("value");
            }
            ++n;
        }
        if (objectArray.length > 1) {
            this.writer.end("choice");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

