package relaxngcc.javabody;

import java.io.StringReader;
import java.text.MessageFormat;

/**
 * 
 * 
 * @author Kohsuke Kawaguchi (kk@kohsuke.org)
 */
public class Test {
    public static void main( String[] args ) throws Exception {
        String s =
            "(x,y, // abcdefghi\n"+
            " delta-echo+/*blah\"*/pop, \n"+
            "  xyz)peep;;;";
        
        JavaBodyParser parser = new JavaBodyParser(new StringReader(s));
        parser.Arguments();
        System.out.println(
            cutString( s, parser.token.beginLine, parser.token.beginColumn ));
             
        printToken(parser.token);
    }
    
    private static String cutString( String str, int line, int col ) {
        StringBuffer buf = new StringBuffer();
        
        while(line>1) {
            int idx = str.indexOf('\n');
            buf.append(str.substring(0,idx+1));
            str = str.substring(idx+1);
            line--;
        }
        
        buf.append(str.substring(0,col));
        
        return buf.toString();
    }
    
    private static void printToken( Token t ) {
        System.out.println(MessageFormat.format(
            "col:{0} image:''{1}''",
            new Object[]{
                Integer.toString( t.beginColumn ),
                t.image
            }));
    }
}

