#ifndef __I2C_RIVA_H
#define __I2C_RIVA_H

#include <linux/i2c.h>
#include <linux/i2c-algo-bit.h>

/* Riva I2C bus instance */
struct riva_i2c_bus {
	unsigned char Read_Reg;
	unsigned char Write_Reg;
	volatile unsigned char *IO_Addr;
	struct rivatv_chip *chip;
};

struct i2c_riva_initdata {
	/* Riva I2C bus manipulation functions and data */
	struct i2c_algo_bit_data *algo;
	/* For registering I2C adapter driver */
	struct i2c_adapter *bus0;
	struct i2c_adapter *bus1;
	struct i2c_adapter *bus2;
	/* Reset the I2C bus lines */
	int (* bus_init) (struct riva_i2c_bus *bus);
};

struct i2c_riva_info {
	int bus_used;
	struct i2c_adapter i2c_bus0;
	struct i2c_adapter i2c_bus1;
	struct i2c_adapter i2c_bus2;
	struct i2c_algo_bit_data bit_riva_data0;
	struct i2c_algo_bit_data bit_riva_data1;
	struct i2c_algo_bit_data bit_riva_data2;
	struct riva_i2c_bus bus_data0;
	struct riva_i2c_bus bus_data1;
	struct riva_i2c_bus bus_data2;
	struct i2c_client *video_decoder;
	struct i2c_client *tuner;
	struct i2c_client *audio_decoder;
	struct i2c_client *audio_processor;
	struct i2c_client *ir_chip;
};

#endif /* __I2C_RIVA_H */
