/* ------------------------------------------------------------------------- */
/*   rivatv-cards.c nVidia based graphics boards list             	     */
/* ------------------------------------------------------------------------- */
/*   Copyright (C) 2002, 2003, 2004 Stefan Jahn <stefan@lkcc.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		     */
/* ------------------------------------------------------------------------- */

#include <linux/config.h>
#include <linux/types.h>
#include <linux/init.h>
#include <linux/i2c.h>
#include <linux/pci.h>

#include "tuner.h"

#include "rivatv.h"

struct __initdata rivatv_card rivatv_cards[RIVATV_MAX_CARDS + 1] = {

	/* ASUS 3DexPlorer */ 
  	/* Miro Magic Premium Riva 128 */
	{ PCI_VENDOR_ID_NVIDIA_SGS, PCI_DEVICE_ID_NVIDIA_SGS_RIVA128,
	  0x2A15,
	  0x54A3, "Asus 3DP-V3000 TV", 
	  I2C_DRIVERID_SAA7111A, "saa7111a", { 3, 4, 0 }, -1, -1 },

	/* ASUS */
	{ PCI_VENDOR_ID_NVIDIA_SGS, PCI_DEVICE_ID_NVIDIA_SGS_RIVA128,
	  PCI_VENDOR_ID_ASUSTEK,
	  0x0100, "Asus V3000ZX TV", 
	  I2C_DRIVERID_SAA7111A, "saa7111a", { 3, 4, 0 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_TNT,
	  PCI_VENDOR_ID_ASUSTEK,
	  0x0200, "Asus V3400 TV",
	  I2C_DRIVERID_SAA7111A, "saa7111a", { 3, 4, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_TNT2,
	  PCI_VENDOR_ID_ASUSTEK,
	  0x0200, "Asus V3800 TVR (TNT2)",
	  I2C_DRIVERID_SAA7113, "saa7113h", { 3, 6, 0 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_UTNT2,
	  PCI_VENDOR_ID_ASUSTEK,
	  0x0200, "Asus V3800 TVR (Ultra TNT2)",
	  I2C_DRIVERID_SAA7113, "saa7113h", { 3, 6, 0 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_UTNT2,
	  PCI_VENDOR_ID_ASUSTEK,
	  0x0201, "Asus V3800 Ultra Deluxe",
	  I2C_DRIVERID_SAA7113, "saa7113h", { 3, 6, 0 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_TNT2,
	  PCI_VENDOR_ID_ASUSTEK,
	  0x4000, "Asus V3800 Pro Deluxe",
	  I2C_DRIVERID_SAA7113, "saa7113h", { 3, 6, 0 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_TNT2,
	  PCI_VENDOR_ID_ASUSTEK,
	  0x4017, "Asus V3800 Deluxe",
	  I2C_DRIVERID_SAA7113, "saa7113h", { 3, 6, 0 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_SDR,
	  PCI_VENDOR_ID_ASUSTEK,
	  0x4008, "Asus V6600 Deluxe",
	  I2C_DRIVERID_SAA7113, "saa7113h", { 3, 6, 0 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_DDR,
	  PCI_VENDOR_ID_ASUSTEK,
	  0x400A, "Asus V6800 TVR",
	  I2C_DRIVERID_SAA7113, "saa7113h", { 3, 6, 0 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE2_MX,
	  PCI_VENDOR_ID_ASUSTEK,
	  0x4021, "Asus V7100 Combo Deluxe",
	  I2C_DRIVERID_SAA7113, "saa7113h", { 3, 6, 1 }, TUNER_PHILIPS_FQ1216ME, 1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE2_GTS,
	  PCI_VENDOR_ID_ASUSTEK,
	  0x4016, "Asus V7700 TVR",
	  I2C_DRIVERID_SAA7113, "saa7113h", { 3, 6, 0 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE2_GTS,
	  PCI_VENDOR_ID_ASUSTEK,
	  0x4026, "Asus V7700 Deluxe",
	  I2C_DRIVERID_SAA7113, "saa7113h", { 3, 6, 1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE2_GTS2,
	  PCI_VENDOR_ID_ASUSTEK,
	  0x405F, "Asus V7700 Ti Deluxe [3]",
	  I2C_DRIVERID_SAA7113, "saa7113h", { 3, 6, 1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE2_GTS2,
	  PCI_VENDOR_ID_ASUSTEK,
	  0x4060, "Asus V7700 Ti Deluxe",
	  I2C_DRIVERID_SAA7113, "saa7113h", { 3, 6, 1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE2_GTS2,
	  PCI_VENDOR_ID_ASUSTEK,
	  0x4066, "Asus V7700 Ti Deluxe [2]",
	  I2C_DRIVERID_SAA7113, "saa7113h", { 3, 6, 1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE3,
	  PCI_VENDOR_ID_ASUSTEK,
	  0x402F, "Asus V8200 Deluxe",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, 0 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE3_1,
	  PCI_VENDOR_ID_ASUSTEK,
	  0x4057, "Asus V8200/T2 Deluxe",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, 0 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE3_2,
	  PCI_VENDOR_ID_ASUSTEK,
	  0x405B, "Asus V8200/T5 Deluxe",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, 0 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200,
	  PCI_VENDOR_ID_ASUSTEK,
	  0x8057, "Asus V8420 Deluxe",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, 0 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4400,
	  PCI_VENDOR_ID_ASUSTEK,
	  0x802F, "Asus V8440 Deluxe",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, 0 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4600,
	  PCI_VENDOR_ID_ASUSTEK,
	  0x8013, "Asus V8460 Ultra Deluxe",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, 0 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_440_8X,
	  PCI_VENDOR_ID_ASUSTEK,
	  0x8083, "Asus V9180 Video Suite",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, 0 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200_8X,
	  PCI_VENDOR_ID_ASUSTEK,
	  0x8097, "Asus V9280 Video Suite",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, 0 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200_8X,
	  PCI_VENDOR_ID_ASUSTEK,
	  0x808F, "Asus V9280-S/TVD",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, 0 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4800_SE,
	  PCI_VENDOR_ID_ASUSTEK,
          0x80B3, "Asus V9480-TVD",
          I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, 0 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5200,
	  PCI_VENDOR_ID_ASUSTEK,
          0x80E3, "Asus V9520 Video Suite",
          I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, 0 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5600,
	  PCI_VENDOR_ID_ASUSTEK,
          0x80E7, "Asus V9560 Video Suite",
          I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, 0 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5200,
	  PCI_VENDOR_ID_ASUSTEK,
          0x8113, "Asus V9520 Home Theater",
	  I2C_DRIVERID_SAA7174, "saa7174hl", { 0, 6, 1 }, TUNER_MT2032, -1 },

	/* ELSA */
	{ PCI_VENDOR_ID_NVIDIA_SGS, PCI_DEVICE_ID_NVIDIA_SGS_RIVA128,
	  PCI_VENDOR_ID_ELSA,
	  0x0C10, "Elsa Victory Erazor",
	  I2C_DRIVERID_VPX32XX, "vpx32xx", { 1, 7, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_TNT2,
	  PCI_VENDOR_ID_ELSA,
	  0x0C29, "Elsa Erazor III Video",
	  I2C_DRIVERID_VPX32XX, "vpx32xx", { 1, 7, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_TNT2,
	  PCI_VENDOR_ID_ELSA,
	  0x0C32, "Elsa Erazor III Pro Video",
	  I2C_DRIVERID_VPX32XX, "vpx32xx", { 1, 7, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE2_MX,
	  PCI_VENDOR_ID_ELSA,
	  0x0C60, "Elsa Gladiac GeForce2 MX VIVO",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200_8X,
	  PCI_VENDOR_ID_ELSA,
	  0x0C92, "Elsa Gladiac 528 128MB GeForce4 Ti4200",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },

        /* Gainward */
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE2_MX,
	  PCI_VENDOR_ID_GAINWARD,
	  0x0603, "Gainward CARDEXpert GeForce2 MX400 VIVO",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE3,
	  PCI_VENDOR_ID_GAINWARD,
	  0x064E, "Gainward GF3 Powerpack!",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE2_GTS2,
	  PCI_VENDOR_ID_GAINWARD,
	  0x03EA, "Gainward CARDEXpert GeForce2 Ti500",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE2_GTS2,
	  PCI_VENDOR_ID_GAINWARD,
	  0x0BCC, "Gainward GeForce2 Ti500 XP VIVO Golden Sample",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4400,
	  PCI_VENDOR_ID_GAINWARD,
	  0x1460, "Gainward CARDEXpert GeForce4 Ti4400/Ultra",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4600,
	  PCI_VENDOR_ID_GAINWARD,
	  0x1428, "Gainward CARDEXpert GeForce4 Ti4600",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_460,
	  PCI_VENDOR_ID_GAINWARD,
	  0x0EF8, "Gainward Pro 650XP GF4 MX460",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_460,
	  PCI_VENDOR_ID_GAINWARD,
	  0x0B02, "Gainward Geforce4 Pro 650 TV Golden Sample",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200,
	  PCI_VENDOR_ID_GAINWARD,
	  0x1603, "Gainward GF4 PowerPack! Ultra/650XP VIVO",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4600,
	  PCI_VENDOR_ID_GAINWARD,
	  0x1528, "Gainward GF4 PowerPack! Ultra/750XP",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4800_SE,
	  PCI_VENDOR_ID_GAINWARD,
	  0x0603, "Gainward GF4 PowerPack! Ultra/750XP-8X",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5600,
	  PCI_VENDOR_ID_GAINWARD,
	  0x0604, "Gainward Ultra/780XP Geforce FX 5600",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200_8X,
	  PCI_VENDOR_ID_GAINWARD,
	  0x0A0F, "Gainward GF4 PowerPack! Ultra/650XP-8X",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4800_SE,
	  PCI_VENDOR_ID_GAINWARD,
	  0x0A05, "Gainward Ultra/750-8X GeForce4 Ti4800SE",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5950_ULTRA,
	  PCI_VENDOR_ID_GAINWARD,
	  0x0A03, "Gainward FX Ultra/1800 Golden Sample",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },

	/* MSI */
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE2_GTS2,
	  PCI_VENDOR_ID_MSI,
	  0x3601, "MSI G2Ti PRO-VT(G)",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE2_MX,
	  PCI_VENDOR_ID_MSI,
	  0x8826, "MSI G2 ???",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE2_GTS2,
	  PCI_VENDOR_ID_MSI,
	  0x8364, "MSI G2TiVX Pro-VT",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE2_MX,
	  PCI_VENDOR_ID_MSI,
	  0x8833, "MSI MX400 Pro-VT32S",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE3_1,
	  PCI_VENDOR_ID_MSI,
	  0x8838, "MSI G3Ti200 PRO-VT(G)",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE3_1,
	  PCI_VENDOR_ID_MSI,
	  0x8503, "MSI G3Ti200 Pro Video",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_440,
	  PCI_VENDOR_ID_MSI,
	  0x8661, "MSI G4MX440-VTP",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_460,
	  PCI_VENDOR_ID_MSI,
	  0x8670, "MSI G4MX460-VTP",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200,
	  PCI_VENDOR_ID_MSI,
	  0x8863, "MSI G4Ti4200-VTP",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200,
	  PCI_VENDOR_ID_MSI,
	  0x8700, "MSI G4Ti4200-VTD64",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4400,
	  PCI_VENDOR_ID_MSI,
	  0x8711, "MSI G4Ti4400-VTD",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4600,
	  PCI_VENDOR_ID_MSI,
	  0x8725, "MSI G4Ti4600-VTD",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_440_8X,
	  PCI_VENDOR_ID_MSI,
	  0x8880, "MSI G4MX440-VTD8X",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200_8X,
	  PCI_VENDOR_ID_MSI,
	  0x8943, "MSI G4Ti4200-VTD8X",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200_8X,
	  PCI_VENDOR_ID_MSI,
	  0x8944, "MSI G4Ti4200",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4800_SE,
	  PCI_VENDOR_ID_MSI,
	  0x8943, "MSI G4Ti4800SE-VTD8X",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4800,
	  PCI_VENDOR_ID_MSI,
	  0x9000, "MSI G4Ti4800-VT2D8X",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5200,
	  PCI_VENDOR_ID_MSI,
	  0x9180, "MSI Personal Cinema FX 5200",
	  I2C_DRIVERID_SAA7174, "saa7174hl", { 0, 6, 1 }, TUNER_PHILIPS_NTSC, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5900,
	  PCI_VENDOR_ID_MSI,
	  0x9292, "MSI FX5900SP VTD128",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5600,
	  PCI_VENDOR_ID_MSI,
	  0x9123, "MSI FX5600-VTDR128",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5600,
	  PCI_VENDOR_ID_MSI,
	  0x9126, "MSI FX5600-VTD256",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5200,
	  PCI_VENDOR_ID_MSI,
	  0x9190, "MSI FX5200-VTD128",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5600_XT,
	  PCI_VENDOR_ID_MSI,
	  0x9123, "MSI GeForce FX 5600 XT VDTR128",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5200,
	  PCI_VENDOR_ID_MSI,
	  0x9280, "MSI TV5200-VTDF128",
	  I2C_DRIVERID_SAA7174, "saa7174hl", { 0, 6, 1 }, TUNER_PHILIPS_PAL, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5600_ULTRA,
	  PCI_VENDOR_ID_MSI,
	  0x9311, "MSI GeForce FX 5600 Ultra VTD",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5900_XT,
	  PCI_VENDOR_ID_MSI,
	  0x9370, "MSI FX5900 XT-VTD128",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5950_ULTRA,
	  PCI_VENDOR_ID_MSI,
	  0x9460, "MSI GeForce FX 5950 Ultra-TD256",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },

	/* AOpen */
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE2_MX,
	  PCI_VENDOR_ID_AOPEN,
	  0x003C, "AOpen MX400-A32 [NTSC]",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, 1 }, TUNER_PHILIPS_NTSC, 1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE2_MX,
	  PCI_VENDOR_ID_AOPEN,
	  0x003D, "AOpen MX400-A32 [PAL]",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, 1 }, TUNER_PHILIPS_PAL, 1 },

	/* Leadtek */
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_SDR,
	  PCI_VENDOR_ID_LEADTEK,
	  0x287C, "Leadtek Winfast A170 Pro TD",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE2_GTS2,
	  PCI_VENDOR_ID_LEADTEK,
	  0x2848, "Leadtek GeForce2 Ti",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200,
	  PCI_VENDOR_ID_LEADTEK,
	  0x289C, "Leadtek Winfast A250 TD GF4 Ti4200 ViVo",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
        { PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200,
          PCI_VENDOR_ID_LEADTEK,
          0x289E, "Leadtek Winfast A250LE TD GF4 Ti4200 MyViVo",
          I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200,
	  PCI_VENDOR_ID_LEADTEK,
	  0x289F, "Leadtek Winfast A250 TD GF4 Ti4200 MyViVo",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4400,
	  PCI_VENDOR_ID_LEADTEK,
	  0x2893, "Leadtek Winfast A250 TD GF4 Ti4400 MyViVo",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
        { PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4600,
          PCI_VENDOR_ID_LEADTEK,
          0x2891, "Leadtek Winfast A250 TD GF4 Ti4600 MyViVo",
          I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
        { PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_440_8X,
          PCI_VENDOR_ID_LEADTEK,
	  0x2921, "Leadtek Winfast A180 TDH GF4 MX440 MyViVo",
          I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, 0 }, -1, -1 },
        { PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_440_8X,
          PCI_VENDOR_ID_LEADTEK,
	  0x2927, "Leadtek Winfast A180 TDH Cinema",
	  I2C_DRIVERID_SAA7174, "saa7174hl", { 0, 6, 1 }, TUNER_PHILIPS_PAL, -1 },
        { PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200_8X,
          PCI_VENDOR_ID_LEADTEK,
	  0x2931, "Leadtek Winfast A280LE TDH GF4 Ti4200 MyViVo [2]",
          I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
        { PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4800_SE,
          PCI_VENDOR_ID_LEADTEK,
	  0x2932, "Leadtek Winfast A280 TD GF4 Ti4800 MyViVo",
          I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
        { PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200_8X,
          PCI_VENDOR_ID_LEADTEK,
	  0x293B, "Leadtek Winfast A280LE TDH GF4 Ti4200 MyViVo",
          I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
        { PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5600,
          PCI_VENDOR_ID_LEADTEK,
	  0x2951, "Leadtek WinFast A310 TD MyViVo",
          I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
        { PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5950_ULTRA,
          PCI_VENDOR_ID_LEADTEK,
	  0x2978, "Leadtek Winfast A380 Ultra TDH MyViVo",
          I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
        { PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5700,
          PCI_VENDOR_ID_LEADTEK,
	  0x298F, "Leadtek WinFast A360 TDH MyViVo",
          I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
        { PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5700,
          PCI_VENDOR_ID_LEADTEK,
	  0x298B, "Leadtek WinFast A360 TDH MyViVo [2]",
          I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },

	/* Prolink */
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_460,
	  PCI_VENDOR_ID_PROLINK,
	  0x1101, "Prolink Pixelview GeForce4 MX460",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5600,
	  PCI_VENDOR_ID_PROLINK,
	  0x1142, "Prolink Pixelview GeForce FX 5600",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5200,
	  PCI_VENDOR_ID_PROLINK,
	  0x1152, "Prolink PixelView Personal Cinema FX 5200",
	  I2C_DRIVERID_SAA7174, "saa7174hl", { 0, 6, 1 }, TUNER_PHILIPS_PAL, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5700,
	  PCI_VENDOR_ID_PROLINK,
	  0x1172, "Prolink Pixelview GF FX5700 256MB ViVo",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },

	/* VisionTek */
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_420,
	  PCI_VENDOR_ID_VISIONTEK,
	  0x0035, "VisionTek Xtasy GeForce4 MX420",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4600,
	  PCI_VENDOR_ID_VISIONTEK,
	  0x0037, "VisionTek Xtasy GeForce4 Ti4600",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },

	/* Guillemot */
        { PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_UVTNT2,
          PCI_VENDOR_ID_GUILLEMOT,
          0x5620, "Guillemot Cougar Video Edition",
          I2C_DRIVERID_VPX32XX, "vpx32xx", { 1, 7, -1 }, -1, -1 },

	/* Pine */
        { PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200,
          PCI_VENDOR_ID_PINE,
          0x1214, "Pine GeForce4 Ti4200 VIVO",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
        { PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4400,
          PCI_VENDOR_ID_PINE,
          0x1222, "Pine GeForce4 Ti4400 VIVO",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },

	/* Triplex */
        { PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_440_8X,
          PCI_VENDOR_ID_TRIPLEX,
          0x0161, "Triplex Millennium Silver TX-680",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },

	/* Kasan */
	{ PCI_VENDOR_ID_NVIDIA_SGS, PCI_DEVICE_ID_NVIDIA_SGS_RIVA128,
	  0x2A15,
	  0x54A3, "Kasan MultiPerfect 128", 
	  I2C_DRIVERID_VPX32XX, "vpx32xx", { 1, 7, -1 }, -1, -1 },

	/* Abit */
        { PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_460,
          PCI_VENDOR_ID_ABIT,
          0x8F03, "Abit Siluro GF4 MX Pro",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },

	/* Diamond */
        { PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_TNT,
          PCI_VENDOR_ID_DIAMOND,
          0x0550, "Diamond Viper TNT",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },

	/* eVGA */
        { PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_440_8X,
          PCI_VENDOR_ID_EVGA,
          0x3088, "eVGA Personal Cinema",
	  I2C_DRIVERID_SAA7174, "saa7174hl", { 0, 6, 1 }, TUNER_PHILIPS_NTSC, -1 },
        { PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5600,
          PCI_VENDOR_ID_EVGA,
          0xA311, "Personal Cinema FX 5600",
	  I2C_DRIVERID_SAA7174, "saa7174hl", { 0, 6, 1 }, TUNER_PHILIPS_NTSC, -1 },

	/* Albatron */
        { PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5900,
          PCI_VENDOR_ID_TRIPLEX,
          0x01C5, "Albatron GeForce FX 5900 PV",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },

	/* MBO */
        { PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_440_8X,
          PCI_VENDOR_ID_TRIPLEX,
          0x016D, "MBO Geforce4 MX 440",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },

	/* PNY */
        { PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5700,
          PCI_VENDOR_ID_TRIPLEX,
          0x01E6, "PNY GeForce FX 5700 Personal Cinema",
	  I2C_DRIVERID_SAA7174, "saa7174hl", { 0, 6, 1 }, TUNER_PHILIPS_PAL, -1 },

	/* unset vendors possibly: 
	   VisionTek, Prolink, AOpen, PowerColor, Sparkle, Albatron, XFX, BFG,
	   Compro, Mentor, Creative, S-Media, eVGA, Soltek, PNY, InnoVISION */
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE2_MX,
	  0x0000,
	  0x0000, "VisionTek Xtasy Everything Personal Cinema",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, 0 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE3_2,
	  0x0000,
	  0x0000, "Compro Personal Cinema GeForce3 Ti500",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, 0 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_UVTNT2,
	  0x0000,
	  0x0000, "PowerColor CM64A-TNT2 M64",
	  I2C_DRIVERID_TW98, "tw98", { 2, 5, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_440_8X,
	  0x0000,
	  0x0000, "Prolink PixelView GeForce4 MX440-8X",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200,
	  0x0000,
	  0x0000, "Prolink Pixelview GeForce4 Ti4200",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200_8X,
	  0x0000,
	  0x0000, "Prolink Pixelview GeForce4 Ti4200 VIVO",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200,
	  0x0000,
	  0x0000, "AOpen Aelous GeForce4 Ti4200",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200,
	  0x0000,
	  0x0000, "Sparkle SP7200T2 VIVO",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4400,
	  0x0000,
	  0x0000, "Sparkle SP7200T4 VIVO",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_440_8X,
	  0x0000,
	  0x0000, "Sparkle SP7300M4 VIVO",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200_8X,
	  0x0000,
	  0x0000, "Sparkle SP7228DV",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5600,
	  0x0000,
	  0x0000, "Sparkle SP8831DV",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
  	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4600,
	  0x0000,
	  0x0000, "Albatron GeForce4 Ti4600V VIVO",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200_8X,
	  0x0000,
	  0x0000, "XFX GeForce4 Ti4200 VIVO",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5600,
	  0x0000,
	  0x0000, "XFX GeForce FX 5600 Ultra AGP8x",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5200,
	  0x0000,
	  0x0000, "XFX Personal Cinema GeForce 5200 FX",
	  I2C_DRIVERID_SAA7174, "saa7174hl", { 0, 6, 1 }, TUNER_MT2032, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200_8X,
	  0x0000,
	  0x0000, "Mentor GeForce4 Ti4200",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE2_MX,
	  0x0000,
	  0x0000, "Creative 3D Blaster Personal Cinema GeForce2 MX400",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, 0 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200,
	  0x0000,
	  0x0000, "S-Media GeForce4 Ti4200 VIVO",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200,
	  0x0000,
	  0x0000, "eVGA GeForce4 Ti4200",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4600,
	  0x0000,
	  0x0000, "eVGA GeForce4 Ti4600 4x",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4800,
	  0x0000,
	  0x0000, "eVGA GeForce4 Ti4800 8x",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5600,
	  0x0000,
	  0x0000, "eVGA GeForce FX 5600 256MB",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5200,
	  0x0000,
	  0x0000, "eVGA Personal Cinema GeForce FX 5200",
	  I2C_DRIVERID_SAA7174, "saa7174hl", { 0, 6, 1 }, TUNER_PHILIPS_PAL, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200,
	  0x0000,
	  0x0000, "Soltek GeForce4 Ti4200 DVC128",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5950_ULTRA,
	  0x0000,
	  0x0000, "PNY Verto GeForceFX 5950 Ultra",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_440_8X,
	  0x0000,
	  0x0000, "Inno3D Tornado GeForce4 MX440-8X",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5600,
	  0x0000,
	  0x0000, "Inno3D FX5600 128MB",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5600,
	  0x0000,
	  0x0000, "Inno3D Tornado FX5600 Personal Cinema FX",
	  I2C_DRIVERID_SAA7174, "saa7108e", { 0, 6, 1 }, TUNER_PHILIPS_PAL, -1 },
	{ PCI_VENDOR_ID_NVIDIA, PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5600,
	  0x0000,
	  0x0000, "BFG Technologies Asylum 5600 GeForce FX 5600 256MB",
	  I2C_DRIVERID_SAA7108, "saa7108e", { 0, 6, -1 }, -1, -1 },

	/* end of list */
	{ PCI_ANY_ID, PCI_ANY_ID, PCI_ANY_ID, 0x0000, "", 0x0000, "", { -1, -1, -1 }, -1, -1 }
};

struct __initdata rivatv_vendor rivatv_vendors[] = {
	{ 0x2A15,                  "Asus (?)" },
	{ PCI_VENDOR_ID_ASUSTEK,   "Asus" },
	{ PCI_VENDOR_ID_ELSA,      "ELSA" },
	{ PCI_VENDOR_ID_GAINWARD,  "Gainward" },
	{ PCI_VENDOR_ID_MSI,       "MSI" },
	{ PCI_VENDOR_ID_AOPEN,     "AOpen" },
	{ PCI_VENDOR_ID_LEADTEK,   "Leadtek" },
	{ PCI_VENDOR_ID_PROLINK,   "Prolink" },
	{ PCI_VENDOR_ID_VISIONTEK, "VisionTek" },
	{ PCI_VENDOR_ID_GUILLEMOT, "Guillemot" },
	{ PCI_VENDOR_ID_PINE,      "Pine" },
	{ PCI_VENDOR_ID_TRIPLEX,   "Triplex" },
	{ PCI_VENDOR_ID_ABIT,      "Abit" },
	{ PCI_VENDOR_ID_DIAMOND,   "Diamond" },
	{ PCI_VENDOR_ID_EVGA,      "eVGA" },
	{ PCI_ANY_ID, "" }
};
