 /*
    tw98.h - definitions for the generic i2c-driver for the
     
     - tw98 Analog to Digital Video Decoder
    
    Copyright (C) 2000 H. S. Magnuski <hankm@mtinet.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __INCLUDED_TW98__
#define __INCLUDED_TW98__

/* FIXME: this has to be defined in "i2c.h" */
#ifndef I2C_DRIVERID_TW98
#define I2C_DRIVERID_TW98 0xF6
#endif

#define TW98_DEVICE_NAME "TW98"

/* Number of TW98 registers. */
#define TW98_NR_REGISTER 256

/* All unused bytes are reserved. */

#define TW98_ID			0x00
#define TW98_CSTATUS		0x01
#define TW98_INFORM		0x02
#define TW98_OPFORM		0x03
#define TW98_HSLEN		0x04
#define TW98_POLARITY		0x05
#define TW98_ACNTL		0x06
#define TW98_CROP_HI		0x07
#define TW98_VDELAY_LO		0x08
#define TW98_VACTIVE_LO		0x09
#define TW98_HDELAY_LO		0x0A
#define TW98_HACTIVE_LO		0x0B
#define TW98_VSCALE_HI		0x0C
#define TW98_VSCALE_LO		0x0D
#define TW98_HSCALE_HI		0x0E
#define TW98_HSCALE_LO		0x0F
#define TW98_BRIGHTNESS		0x10
#define TW98_CONTRAST		0x11
#define TW98_SHARPNESS		0x12
#define TW98_SAT_U		0x13
#define TW98_SAT_V		0x14
#define TW98_HUE		0x15
#define TW98_CKILL		0x16
#define TW98_CORING		0x17
#define TW98_AUTODETECT         0x18
#define TW98_VBICNTL		0x19
#define TW98_CC_STATUS		0x1A
#define TW98_CC_DATA		0x1B
#define TW98_AGCGAIN		0x1C
#define TW98_GPIO		0x1D
#define TW98_TEST		0x1E
#define TW98_NOISE		0x1F

#define TW98_TSC1               0xC1
#define TW98_TSC2               0xC2
#define TW98_TSC3               0xC3
#define TW98_TSC4               0xC4
#define TW98_TSC5               0xC5
#define TW98_TSCM1              0xC7
#define TW98_TSCM2              0xC8
#define TW98_TSCM3              0xC9
#define TW98_TSCM4              0xCA
#define TW98_TSCM5              0xCB
#define TW98_TSCL1              0xCD
#define TW98_TSCL2              0xCE
#define TW98_TSCL3              0xCF
#define TW98_TSCL4              0xD0
#define TW98_TSCL5              0xD1

#define TW98_BURST              0xD2
#define TW98_SYNCL              0xD3
#define TW98_HSCOUNT            0xD4
#define TW98_HPLLC              0xD5
#define TW98_OUTCTRL            0xD6
#define TW98_COMPCTRL           0xD7
#define TW98_SHARP1             0xD8
#define TW98_SHARP2             0xD9
#define TW98_CCSTART            0xDA
#define TW98_CCPERIOD           0xDB
#define TW98_TSCC               0xDC
#define TW98_PLLC               0xDD
#define TW98_BURSTSW            0xDE
#define TW98_LLENGTH            0xDF
#define TW98_PEAKAGC            0xE0
#define TW98_HSYNC              0xE1
#define TW98_HSK                0xE2
#define TW98_HSZ                0xE3
#define TW98_HFK                0xE4
#define TW98_HFZ                0xE5
#define TW98_SYNCTRL            0xE6
#define TW98_VFORMAT            0xE7
#define TW98_PHERR              0xE8

#endif /* __INCLUDED_TW98__ */
