/*
 * Decompiled with CFR 0.152.
 */
package com.rc.retroweaver;

import com.rc.retroweaver.RetroWeaver;
import com.rc.retroweaver.event.WeaveListener;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class RetroWeaverTask
extends Task
implements WeaveListener {
    private int version = 48;
    private final Set<FileSet> sources = new HashSet<FileSet>();
    private File destDir;

    public void setVersion(String ver) {
        if ((ver = ver.intern()) == "1.4") {
            this.version = 48;
            return;
        }
        if (ver == "1.3") {
            this.version = 47;
            return;
        }
        if (ver == "1.2") {
            this.version = 46;
            return;
        }
        throw new BuildException("Unrecognized version number: " + ver);
    }

    public void addConfiguredSource(FileSet fs) {
        this.sources.add(fs);
    }

    public void setDestdir(File dir) {
        this.destDir = dir;
    }

    public void execute() throws BuildException {
        RetroWeaver weaver = new RetroWeaver(this.version);
        weaver.setListener(this);
        Iterator<FileSet> i$ = this.sources.iterator();
        while (i$.hasNext()) {
            FileSet fs = i$.next();
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File baseDir = ds.getBasedir();
            this.log("Weaving " + baseDir, 2);
            String[] arr$ = ds.getIncludedFiles();
            int len$ = arr$.length;
            for (int i$2 = 0; i$2 < len$; ++i$2) {
                File dest;
                String f = arr$[i$2];
                File src = new File(baseDir, f);
                if (this.destDir == null) {
                    dest = src;
                } else {
                    dest = new File(this.destDir, f);
                    if (dest.exists() && dest.lastModified() > src.lastModified()) {
                        this.log("Skipping " + src, 3);
                        continue;
                    }
                }
                try {
                    weaver.weave(src, dest);
                    continue;
                }
                catch (IOException e) {
                    throw new BuildException("Failed to weave " + src, (Throwable)e);
                }
            }
        }
    }

    public void weavingPath(String sourcePath) {
        this.log("Weaving " + sourcePath, 3);
    }
}

