/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.rngom.dump;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.kohsuke.rngom.ast.builder.Annotations;
import org.kohsuke.rngom.ast.builder.CommentList;
import org.kohsuke.rngom.ast.builder.DataPatternBuilder;
import org.kohsuke.rngom.ast.builder.Div;
import org.kohsuke.rngom.ast.builder.ElementAnnotationBuilder;
import org.kohsuke.rngom.ast.builder.Grammar;
import org.kohsuke.rngom.ast.builder.Include;
import org.kohsuke.rngom.ast.om.Location;
import org.kohsuke.rngom.ast.om.ParsedElementAnnotation;
import org.kohsuke.rngom.ast.om.ParsedNameClass;
import org.kohsuke.rngom.ast.om.ParsedPattern;

public class Printer {
    private final PrintWriter out;
    private boolean hasParams = false;

    public Printer(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public Printer(Writer writer) {
        this.out = new PrintWriter(writer);
    }

    public Printer(OutputStream outputStream) {
        this(new OutputStreamWriter(outputStream));
    }

    public Printer object(String string) {
        this.out.print(string);
        this.out.print('.');
        return this;
    }

    public Printer name(String string) {
        this.out.print(string + '(');
        return this;
    }

    public Printer param(Object object) {
        if (this.hasParams) {
            this.out.print(',');
        }
        if (object instanceof String) {
            this.out.print('\"');
            this.out.print(object);
            this.out.print('\"');
        } else {
            this.out.print(object);
        }
        this.hasParams = true;
        return this;
    }

    public Printer param(int n) {
        return this.param(new Integer(n));
    }

    private Object r(Object object) {
        this.out.print(") -> ");
        this.out.print(object);
        this.out.println();
        this.out.flush();
        this.hasParams = false;
        return object;
    }

    public void result() {
        this.out.println(")");
        this.out.flush();
        this.hasParams = false;
    }

    public ParsedPattern result(ParsedPattern parsedPattern) {
        this.r(parsedPattern);
        return parsedPattern;
    }

    public ParsedNameClass result(ParsedNameClass parsedNameClass) {
        this.r(parsedNameClass);
        return parsedNameClass;
    }

    public Location result(Location location) {
        this.r(location);
        return location;
    }

    public Annotations result(Annotations annotations) {
        this.r(annotations);
        return annotations;
    }

    public CommentList result(CommentList commentList) {
        this.r(commentList);
        return commentList;
    }

    public Grammar result(Grammar grammar) {
        this.r(grammar);
        return grammar;
    }

    public Div result(Div div) {
        this.r(div);
        return div;
    }

    public Include result(Include include) {
        this.r(include);
        return include;
    }

    public ElementAnnotationBuilder result(ElementAnnotationBuilder elementAnnotationBuilder) {
        this.r(elementAnnotationBuilder);
        return elementAnnotationBuilder;
    }

    public ParsedElementAnnotation result(ParsedElementAnnotation parsedElementAnnotation) {
        this.r(parsedElementAnnotation);
        return parsedElementAnnotation;
    }

    public DataPatternBuilder result(DataPatternBuilder dataPatternBuilder) {
        this.r(dataPatternBuilder);
        return dataPatternBuilder;
    }
}

