/**
 * PublicKey.js
 * https://github.com/diafygi/publickeyjs
 *
 * A simple javascript library that allows you to search for PGP
 * public keys on SKS keyservers and Keybase. The API and results
 * are similar to specifications described in HTTP Keyserver Protocol.
 *
 * @licstart  The following is the entire license notice for the
 * JavaScript code in this file.
 *
 * Copyright (c) 2015 Daniel Roesler
 *
 * The JavaScript code in this page is free software: you can
 * redistribute it and/or modify it under the terms of the GNU
 * General Public License (GNU GPL) as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option)
 * any later version.  The code is distributed WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU GPL for more details.
 *
 * As additional permission under GNU GPL version 3 section 7, you
 * may distribute non-source (e.g., minimized or compacted) forms of
 * that code without the copy of the GNU GPL normally required by
 * section 4, provided you include this license notice and a URL
 * through which recipients can access the Corresponding Source.
 *
 * @licend  The above is the entire license notice
 * for the JavaScript code in this file.
 *
 * @author Daniel Roesler (diafygi)
 */
(function(u){var v=["https://keys.fedoraproject.org/","https://keybase.io/"],p=function(e){this.keyservers=e||v};p.prototype.get=function(e,k,h,c){void 0===h&&(h=0);if(h>=this.keyservers.length)return k(null,c||404);c=this.keyservers[h];var g=this;if(0===c.indexOf("https://keybase.io/")){0===e.indexOf("0x")&&(e=e.substr(2));var b=new XMLHttpRequest;b.open("get","https://keybase.io/_/api/1.0/user/lookup.json?fields=public_keys&key_fingerprint="+e);b.onload=function(){if(200===b.status){var c=JSON.parse(b.responseText);
return 0!==c.status.code?g.get(e,k,h+1,c.status.code):0===c.them.length?g.get(e,k,h+1,404):k(c.them[0].public_keys.primary.bundle,null)}return g.get(e,k,h+1,b.status)}}else 0!==e.indexOf("0x")&&(e="0x"+e),b=new XMLHttpRequest,b.open("get",c+"pks/lookup?op=get&options=mr&search="+e),b.onload=function(){return 200===b.status?k(b.responseText,null):g.get(e,k,h+1,b.status)};b.send()};p.prototype.search=function(e,k,h,c,g){void 0===h&&(h=0);void 0===c&&(c=[]);if(h>=this.keyservers.length){if(0===c.length)return k(null,
g||404);g={};for(var b=0;b<c.length;b++){var f=c[b];if(void 0!==g[f.keyid])for(var n=0;n<f.uids.length;n++){for(var p=!1,t=0;t<g[f.keyid].uids.length;t++)if(g[f.keyid].uids[t].uid===f.uids[n]){p=!0;break}p||g[f.keyid].uids.push(f.uids[n])}else g[f.keyid]=f}n=[];for(b=0;b<c.length;b++)f=c[b],void 0!==g[f.keyid]&&(n.push(g[f.keyid]),delete g[f.keyid]);return k(n,null)}var r=this.keyservers[h],q=this;if(0===r.indexOf("https://keybase.io/")){var m=new XMLHttpRequest;m.open("get","https://keybase.io/_/api/1.0/user/autocomplete.json?q="+
encodeURIComponent(e));m.onload=function(){if(200===m.status){var b=JSON.parse(m.responseText);if(0!==b.status.code)return q.search(e,k,h+1,c,b.status.code);if(0===b.completions.length)return q.search(e,k,h+1,c,404);for(var g=[],f=0;f<b.completions.length;f++){var a=b.completions[f].components;if(void 0!==a.key_fingerprint){var l={keyid:a.key_fingerprint.val.toUpperCase(),href:"https://keybase.io/"+a.username.val+"/key.asc",info:"https://keybase.io/"+a.username.val,algo:a.key_fingerprint.algo,keylen:a.key_fingerprint.nbits,
creationdate:null,expirationdate:null,revoked:!1,disabled:!1,expired:!1,uids:[{uid:a.username.val+" on Keybase <https://keybase.io/"+a.username.val+">",creationdate:null,expirationdate:null,revoked:!1,disabled:!1,expired:!1}]};void 0!==a.full_name&&l.uids.push({uid:"Full Name: "+a.full_name.val,creationdate:null,expirationdate:null,revoked:!1,disabled:!1,expired:!1});void 0!==a.twitter&&l.uids.push({uid:a.twitter.val+" on Twitter <https://twitter.com/"+a.twitter.val+">",creationdate:null,expirationdate:null,
revoked:!1,disabled:!1,expired:!1});void 0!==a.github&&l.uids.push({uid:a.github.val+" on Github <https://github.com/"+a.github.val+">",creationdate:null,expirationdate:null,revoked:!1,disabled:!1,expired:!1});void 0!==a.reddit&&l.uids.push({uid:a.reddit.val+" on Github <https://reddit.com/u/"+a.reddit.val+">",creationdate:null,expirationdate:null,revoked:!1,disabled:!1,expired:!1});void 0!==a.hackernews&&l.uids.push({uid:a.hackernews.val+" on Hacker News <https://news.ycombinator.com/user?id="+a.hackernews.val+
">",creationdate:null,expirationdate:null,revoked:!1,disabled:!1,expired:!1});void 0!==a.coinbase&&l.uids.push({uid:a.coinbase.val+" on Coinbase <https://www.coinbase.com/"+a.coinbase.val+">",creationdate:null,expirationdate:null,revoked:!1,disabled:!1,expired:!1});if(void 0!==a.websites)for(var d=0;d<a.websites.length;d++)l.uids.push({uid:"Owns "+a.websites[d].val,creationdate:null,expirationdate:null,revoked:!1,disabled:!1,expired:!1});g.push(l)}}c=c.concat(g);return q.search(e,k,h+1,c,null)}return q.search(e,
k,h+1,c,m.status)}}else m=new XMLHttpRequest,m.open("get",r+"pks/lookup?op=index&options=mr&fingerprint=on&search="+encodeURIComponent(e)),m.onload=function(){if(200===m.status){for(var b=[],g=m.responseText.split("\n"),f=void 0,a=0;a<g.length;a++){var l=g[a].trim();if(0==l.indexOf("pub:")){void 0!==f&&b.push(f);var d=l.split(":"),f={keyid:d[1],href:r+"pks/lookup?op=get&options=mr&search=0x"+d[1],info:r+"pks/lookup?op=vindex&search=0x"+d[1],algo:""===d[2]?null:parseInt(d[2]),keylen:""===d[3]?null:
parseInt(d[3]),creationdate:""===d[4]?null:parseInt(d[4]),expirationdate:""===d[5]?null:parseInt(d[5]),revoked:-1!==d[6].indexOf("r"),disabled:-1!==d[6].indexOf("d"),expired:-1!==d[6].indexOf("e"),uids:[]}}0==l.indexOf("uid:")&&(d=l.split(":"),f.uids.push({uid:decodeURIComponent(d[1]),creationdate:""===d[2]?null:parseInt(d[2]),expirationdate:""===d[3]?null:parseInt(d[3]),revoked:-1!==d[4].indexOf("r"),disabled:-1!==d[4].indexOf("d"),expired:-1!==d[4].indexOf("e")}))}b.push(f);c=c.concat(b);return q.search(e,
k,h+1,c,null)}return q.search(e,k,h+1,c,m.status)};m.send()};u.PublicKey=p})("undefined"===typeof exports?this:exports);
